/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.Component;
import com.gui.GUIGraphics;
import com.gui.GUIManager;
import com.gui.Readline;
import com.gui.UniKeys;
import javax.microedition.lcdui.Graphics;

public final class GUIGauge
extends Component {
    private int value;
    private int maxValue;
    private int widthPole = 0;
    private int heightPole = 0;
    private Readline titleString = new Readline("");
    private boolean interactive = true;
    private boolean percent = true;

    public GUIGauge(String label, boolean interactive, int maxValue, int value) {
        super(label);
        this.interactive = interactive;
        this.maxValue = maxValue;
        this.setValue(value);
        this.titleString.setTextFont(super.getLabelFont());
    }

    String getTypeComponent() {
        return "GUIGauge";
    }

    int paintComponent(Graphics g, int x, int y, int width, int height, boolean b) {
        if (this.widthPole > width || this.widthPole <= 0) {
            this.widthPole = x + width - 7;
        }
        if (this.heightPole <= 0) {
            this.heightPole = super.getLabelFont().getHeight();
        }
        double ss = (double)this.widthPole / (double)this.maxValue;
        double ss1 = Math.floor((double)this.value * ss);
        int xss = (int)ss1;
        int xs = this.widthPole;
        int ys2 = this.heightPole;
        int ys3 = 2;
        int ys5 = 5;
        int ys6 = 0;
        this.titleString.setString(super.getLabel());
        this.titleString.setLabelAlignment(super.getLabelAlignment());
        this.titleString.setColor(GUIManager.getTheme().labelRGB);
        int ys1 = this.titleString.paintComponent(g, x + 1, y + 2, width, height, b);
        if (ys1 == 0) {
            ys6 = 2;
        }
        int ys4 = ys1 + ys2;
        int ys7 = y + ys1 + ys3;
        if (ys1 == 0) {
            ys4 += 4;
        }
        if (this.value == this.maxValue) {
            xss = xs;
        }
        if (this.value == 0) {
            xss = 0;
        }
        g.setColor(GUIManager.getTheme().gaugeFieldRGB);
        GUIGraphics.fillRect(g, x + 3, ys7, xs, ys2);
        GUIManager.getTheme().gradientFill(g, x + 3, ys7, xss, ys2, true, GUIManager.getTheme().gaugeProcessRGB1, GUIManager.getTheme().gaugeProcessRGB2);
        if (!this.interactive && this.percent) {
            g.setFont(super.getLabelFont());
            int pr = this.value * 100 / this.getMaxValue();
            g.setColor(GUIManager.getTheme().gaugeTextRGB);
            GUIGraphics.drawString(g, pr + "%", x + 3 + xs / 2, ys7 + (ys2 - super.getLabelFont().getHeight()) / 2 + 1, 17);
        }
        g.setColor(GUIManager.getTheme().gaugeFieldFrameRGB);
        g.drawRect(x + 3, ys7, xs, ys2);
        if (b && this.interactive) {
            int ys8 = ys4 + ys5 + ys6;
            g.setColor(GUIManager.getTheme().fonFrameRGB);
            g.drawRect(x, y, width - 1, ys8);
            g.drawRect(x + 1, y + 1, width - 3, ys8 - 2);
        }
        return ys4;
    }

    void keyComponent(int key) {
        if (this.interactive) {
            if ((UniKeys.isKey(key, "LEFT") || GUIManager.isDuplicationOfKeysOfNavigation() && UniKeys.isKey(key, "KEY_NUM4")) && this.value > 0) {
                --this.value;
            }
            if ((UniKeys.isKey(key, "RIGHT") || GUIManager.isDuplicationOfKeysOfNavigation() && UniKeys.isKey(key, "KEY_NUM6")) && this.value < this.maxValue) {
                ++this.value;
            }
        }
    }

    public void setPreferredSize(int width, int height) {
        this.widthPole = width;
        this.heightPole = height;
    }

    public void setDefaultPreferredSize() {
        this.widthPole = 0;
        this.heightPole = 0;
    }

    public void showPercent(boolean b) {
        this.percent = b;
    }

    public void setValue(int value) {
        if (value >= 0 && value <= this.maxValue) {
            this.value = value;
        }
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setLayout(int layout) {
    }

    public int getValue() {
        return this.value;
    }

    public int getMaxValue() {
        return this.maxValue;
    }
}

