/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.Component;
import com.gui.GUIGraphics;
import com.gui.GUIManager;
import com.gui.Readline;
import com.gui.UniKeys;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;

public final class GUITextField
extends Component {
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int UNEDITABLE = 131072;
    public static final int NUMERIC = 2;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    public static final int SENSITIVE = 262144;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int NON_PREDICTIVE = 524288;
    public static final int CONSTRAINT_MASK = 65535;
    public static final int PASSWORD = 65536;
    private Readline titleString;
    private int maxsize;
    private int type;

    public GUITextField(String label, String text, int maxsize, int type) {
        super(label);
        this.maxsize = maxsize;
        this.type = type;
        super.setString(text);
        this.titleString = new Readline(label);
        this.titleString.setTextFont(super.getLabelFont());
    }

    int paintComponent(Graphics g, int x, int y, int width, int height, boolean b) {
        int ys2 = super.getLabelFont().getHeight();
        int ys3 = 2;
        int ys5 = 5;
        int ys6 = 0;
        this.titleString.setString(super.getLabel());
        this.titleString.setColor(GUIManager.getTheme().labelRGB);
        int ys1 = this.titleString.paintComponent(g, x + 1, y + 2, width, height, b);
        if (ys1 == 0) {
            ys6 = 2;
            ys3 = 4;
        }
        int ys4 = ys1 + super.getLabelFont().getHeight();
        int ys7 = y + ys1 + ys3;
        int xs = x + width - 7;
        g.setColor(GUIManager.getTheme().entryFieldRGB);
        GUIGraphics.fillRect(g, x + 3, ys7, xs, ys2);
        g.setColor(GUIManager.getTheme().entryFieldFrameRGB);
        g.drawRect(x + 3, ys7, xs, ys2);
        g.setFont(super.getTextFont());
        g.setColor(GUIManager.getTheme().entryFieldTextRGB);
        GUIGraphics.drawString(g, this.getShowString(super.getString(), super.getTextFont(), width - 8), x + 5, ys7 + 1, 0);
        if (b) {
            int ys8 = ys4 + ys5 + ys6;
            g.setColor(GUIManager.getTheme().fonFrameRGB);
            g.drawRect(x, y, width - 1, ys8);
            g.drawRect(x + 1, y + 1, width - 3, ys8 - 2);
        }
        return ys4;
    }

    void keyComponent(int key) {
        if (UniKeys.isKey(key, "FIRE") || GUIManager.isDuplicationOfKeysOfNavigation() && UniKeys.isKey(key, "KEY_NUM5")) {
            GUIManager.show((Displayable)new InputText(super.getLabel(), super.getString(), this.maxsize, this.type, this));
        }
    }

    String getTypeComponent() {
        return "GUITextField";
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getMaxSize() {
        return this.maxsize;
    }

    public void setMaxSize(int size) {
        this.maxsize = size;
    }

    private String getShowString(String s, Font f, int w) {
        if (f.stringWidth(s) > w) {
            StringBuffer sb = new StringBuffer();
            char[] ch = s.toCharArray();
            String pr = "...";
            sb.append(pr);
            for (int i = 0; i < s.length(); ++i) {
                if (f.stringWidth(sb.toString()) >= w - 5) {
                    sb.delete(0, sb.length());
                    sb.append(ch, 0, i).append(pr);
                    break;
                }
                if (this.type == 65536) {
                    ch[i] = 42;
                }
                sb.append(ch[i]);
            }
            return sb.toString();
        }
        if (this.type == 65536) {
            char[] ch = new char[s.length()];
            for (int i = 0; i < ch.length; ++i) {
                ch[i] = 42;
            }
            s = new String(ch);
        }
        return s;
    }

    final class InputText
    extends TextBox
    implements CommandListener {
        Command cmdOk;
        Command cmdBack;
        GUITextField guitf;

        InputText(String t, String s, int size, int type, GUITextField guitf) {
            super(t, s, size, type);
            this.guitf = guitf;
            this.cmdOk = new Command("Ok", 4, 1);
            this.cmdBack = new Command("Back", 2, 1);
            super.addCommand(this.cmdOk);
            super.addCommand(this.cmdBack);
            super.setString(guitf.getString());
            super.setCommandListener((CommandListener)this);
        }

        public void commandAction(Command c, Displayable d) {
            if (c == this.cmdOk) {
                this.guitf.setString(super.getString());
            }
            GUIManager.show(GUIManager.getPrevScreen());
        }
    }
}

