/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ReadManiacFont {
    private Image I = null;
    private short[] X = null;
    private short[] Y = null;
    private byte[] W = null;
    private InputStream is;
    private int H;
    private int tC;
    private int bC;

    public ReadManiacFont(String res, int fontColor, int backColor) throws Exception {
        try {
            this.X = new short[256];
            this.Y = new short[256];
            this.W = new byte[256];
            this.is = this.getClass().getResourceAsStream(res);
            if (this.ReadWord() != 13313) {
                this.is.close();
                throw new Exception();
            }
            this.ReadInt();
            this.H = this.ReadByte();
            this.ReadByte();
            this.tC = this.ReadInt();
            this.bC = this.ReadInt();
            for (int l = 0; l < 32; ++l) {
                this.X[l] = 0;
                this.Y[l] = 0;
                this.W[l] = 0;
            }
            short word0 = 0;
            short word1 = 0;
            for (int i1 = 32; i1 < 256; ++i1) {
                byte byte2 = this.ReadByte();
                if (word0 + byte2 > 200) {
                    word0 = 0;
                    word1 = (short)(word1 + (short)this.H);
                }
                this.X[i1] = word0;
                this.Y[i1] = word1;
                this.W[i1] = byte2;
                word0 = (short)(word0 + (short)byte2);
            }
            int imgsize = this.ReadInt();
            byte[] imgbyte = new byte[imgsize];
            this.is.read(imgbyte, 0, imgsize);
            this.is.close();
            this.I = Image.createImage((byte[])imgbyte, (int)0, (int)imgsize);
            this.bC = this.ChangeColor(backColor, this.bC);
            this.setColor(fontColor);
        }
        catch (Exception exception) {
            throw new Exception();
        }
        catch (OutOfMemoryError outofmemoryerror) {
            throw new Exception();
        }
        System.gc();
    }

    public void drawString(Graphics g, int x, int y, String s) {
        for (int k = 0; k < s.length(); ++k) {
            int ch = s.charAt(k);
            ch = ch == 1025 ? 168 : (ch == 1105 ? 184 : ch);
            int n = ch = ch > 1024 ? ch - 848 : ch;
            if (this.W[ch] == 0) continue;
            if (x + this.W[ch] >= 0) {
                g.drawRegion(this.I, (int)this.X[ch], (int)this.Y[ch], (int)this.W[ch], this.H, 0, x, y, 20);
            }
            x += this.W[ch];
        }
    }

    public void setColor(int RGB) {
        try {
            this.tC = this.ChangeColor(RGB |= 0xFF000000, this.tC);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    public int stringWidth(String s) {
        int j = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u00ff') {
                c = '\u0000';
            }
            j += this.W[c];
        }
        return j;
    }

    public int getHeight() {
        return this.H;
    }

    private int ChangeColor(int newcolor, int thisColor) throws Exception {
        thisColor |= 0xFF000000;
        int width = this.I.getWidth();
        int height = this.I.getHeight();
        int lenght = width * height;
        try {
            int[] pixelARGB = new int[lenght];
            this.I.getRGB(pixelARGB, 0, width, 0, 0, width, height);
            for (int pos = 0; pos < lenght; ++pos) {
                if (pixelARGB[pos] != thisColor) continue;
                pixelARGB[pos] = newcolor;
            }
            this.I = Image.createRGBImage((int[])pixelARGB, (int)width, (int)height, (boolean)true);
        }
        catch (OutOfMemoryError outofmemoryerror) {
            throw new Exception();
        }
        thisColor = newcolor - -16777216;
        return thisColor;
    }

    private int ReadWord() throws IOException {
        return this.is.read() & 0xFF | (this.is.read() & 0xFF) << 8;
    }

    private int ReadInt() throws IOException {
        return this.is.read() & 0xFF | (this.is.read() & 0xFF) << 8 | (this.is.read() & 0xFF | (this.is.read() & 0xFF) << 8) << 16;
    }

    private byte ReadByte() throws IOException {
        return (byte)this.is.read();
    }
}

