/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import java.io.ByteArrayOutputStream;
import java.io.UTFDataFormatException;
import java.util.Hashtable;
import java.util.Vector;

public class TextUtils {
    public static int ARRAY_LENGTH;
    private static String[] array;
    private static String[] a;

    public int indexOf(String source, String template) {
        int i;
        int sourceLen = source.length();
        int templateLen = template.length();
        if (templateLen > sourceLen) {
            return -1;
        }
        Hashtable<Character, Integer> offsetTable = new Hashtable<Character, Integer>();
        for (i = 0; i <= 255; ++i) {
            offsetTable.put(new Character((char)i), new Integer(templateLen));
        }
        for (i = 0; i < templateLen - 1; ++i) {
            offsetTable.put(new Character(template.charAt(i)), new Integer(templateLen - i - 1));
        }
        int j = i = templateLen - 1;
        int k = i;
        while (j >= 0 && i <= sourceLen - 1) {
            k = i;
            for (j = templateLen - 1; j >= 0 && source.charAt(k) == template.charAt(j); --j) {
                --k;
            }
            i += ((Integer)offsetTable.get(new Character(source.charAt(i)))).intValue();
        }
        if (k >= sourceLen - templateLen) {
            return -1;
        }
        return k + 1;
    }

    public static String html(String string_1) {
        StringBuffer sb = new StringBuffer("");
        int int_1 = string_1.length();
        boolean int_2 = false;
        String string_2 = "";
        for (int int_3 = 0; int_3 < int_1; ++int_3) {
            char char_1 = string_1.charAt(int_3);
            if (char_1 == '<') {
                if (string_2.length() > 0) {
                    sb = sb.append(string_2 + " ");
                    string_2 = "";
                }
                int_2 = true;
                continue;
            }
            if (char_1 == '>') {
                int_2 = false;
                continue;
            }
            if (int_2 || char_1 <= '\u001f') continue;
            string_2 = string_2 + String.valueOf(char_1);
        }
        if (string_2.length() > 0) {
            sb = sb.append(string_2 + " ");
        }
        return sb.toString();
    }

    public static String byteArrayToString(byte[] bytes, String encoding) {
        char[] map = "\u0402\u0403\u201a\u0453\u201e\u2026\u2020\u2021\u20ac\u2030\u0409\u2039\u040a\u040c\u040b\u040f\u0452\u2018\u2019\u201c\u201d\u2022\u2013\u2014\ufffd\u2122\u0459\u203a\u045a\u045c\u045b\u045f\u00a0\u040e\u045e\u0408\u00a4\u0490\u00a6\u00a7\u0401\u00a9\u0404\u00ab\u00ac\u00ad\u00ae\u0407\u00b0\u00b1\u0406\u0456\u0491\u00b5\u00b6\u00b7\u0451\u2116\u0454\u00bb\u0458\u0405\u0455\u0457\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f".toCharArray();
        if (encoding.equals("UTF-8")) {
            encoding = "ISO-8859-1";
        }
        try {
            return TextUtils.decodeUTF8(bytes, false);
        }
        catch (UTFDataFormatException udfe) {
            char[] chars = new char[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                chars[i] = b >= 0 ? (char)b : map[b + 128];
            }
            return new String(chars);
        }
    }

    public static byte[] encodeUTF8(String text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                baos.write(c);
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c < '\u0800') {
                baos.write((byte)(0xC0 | 0x1F & c >> 6));
                baos.write((byte)(0x80 | 0x3F & c));
                continue;
            }
            baos.write((byte)(0xE0 | 0xF & c >> 12));
            baos.write((byte)(0x80 | 0x3F & c >> 6));
            baos.write((byte)(0x80 | 0x3F & c));
        }
        byte[] ret = baos.toByteArray();
        return ret;
    }

    private static String decodeUTF8(byte[] data, boolean gracious) throws UTFDataFormatException {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            try {
                byte b;
                byte a = data[i];
                if ((a & 0x80) == 0) {
                    ret.append((char)a);
                    continue;
                }
                if ((a & 0xE0) == 192) {
                    b = data[i + 1];
                    if ((b & 0xC0) == 128) {
                        ret.append((char)((a & 0x1F) << 6 | b & 0x3F));
                        ++i;
                        continue;
                    }
                    throw new UTFDataFormatException("Illegal 2-byte group");
                }
                if ((a & 0xF0) == 224) {
                    b = data[i + 1];
                    byte c = data[i + 2];
                    if ((b & 0xC0) == 128 && (c & 0xC0) == 128) {
                        ret.append((char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F));
                        i += 2;
                        continue;
                    }
                    throw new UTFDataFormatException("Illegal 3-byte group");
                }
                if ((a & 0xF0) != 240 && (a & 0xC0) != 128) continue;
                throw new UTFDataFormatException("Illegal first byte of a group");
            }
            catch (UTFDataFormatException udfe) {
                if (gracious) {
                    ret.append("?");
                    continue;
                }
                throw udfe;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                if (gracious) {
                    ret.append("?");
                    continue;
                }
                throw new UTFDataFormatException("Unexpected EOF");
            }
        }
        return ret.toString();
    }

    public static String[] splitString(String str, String delim) {
        if (str == null) {
            return null;
        }
        if (str.equals("") || delim == null || delim.length() == 0) {
            return new String[]{str};
        }
        Vector<String> v = new Vector<String>();
        int pos = 0;
        int newpos = str.indexOf(delim, pos);
        while (newpos != -1) {
            v.addElement(str.substring(pos, newpos));
            pos = newpos + delim.length();
            newpos = str.indexOf(delim, pos);
        }
        v.addElement(str.substring(pos));
        String[] s = new String[v.size()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (String)v.elementAt(i);
        }
        return s;
    }

    public static String stringDelete(String str, int startIndex, int endIndex) {
        if (endIndex < str.length()) {
            return str.substring(0, startIndex).concat(str.substring(endIndex));
        }
        return str.substring(0, str.length() - 1);
    }

    public static String stringDelete(String str, int index) {
        return TextUtils.stringDelete(str, index, index + 1);
    }

    public static String stringInsert(String str, String ins, int index) {
        if (index > 0) {
            return str.substring(0, index) + ins + str.substring(index);
        }
        return ins + str;
    }

    public static String stringReplace(String str, String replace, int index) {
        return TextUtils.stringInsert(TextUtils.stringDelete(str, index, index + replace.length()), replace, index);
    }

    public static String replace(String s, String s1, String s2) {
        String out = " ";
        s = s + " ";
        int i = s.indexOf(s1);
        while (i > -1) {
            out = out + s.substring(0, i) + s2;
            s = s.substring(i + s1.length());
            i = s.indexOf(s1);
        }
        out = out + s;
        return out.substring(1, out.length() - 1);
    }

    public static String processMacros(String s) {
        return TextUtils.replace(s, "^n", "\n");
    }

    public static String[] search(String[] array, String key) {
        Vector<String> v = new Vector<String>();
        int bin = TextUtils.BinarySearch(array, key, true);
        if (bin != -1) {
            v.addElement(array[bin]);
            Object[] result = new String[v.size()];
            v.copyInto(result);
            v.removeAllElements();
            v = null;
            return result;
        }
        for (int i = 0; i < array.length; ++i) {
            String temp = array[i];
            if (temp.indexOf(key) == -1) continue;
            v.addElement(temp);
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        v.removeAllElements();
        v = null;
        return result;
    }

    public static int BinarySearch(String[] array, String key, boolean notSorted) {
        return TextUtils.BinarySearch(array, 0, array.length, key, notSorted);
    }

    public static int BinarySearch(String[] array, int start, int end, String key, boolean notSorted) {
        if (start > end) {
            return -1;
        }
        if (end > array.length) {
            return -1;
        }
        if (notSorted) {
            array = TextUtils.quickSort(array, false, true, true);
        }
        int Median = (start + end) / 2;
        String temp = array[Median];
        switch (key.compareTo(temp)) {
            case -1: {
                end = Median - 1;
                return TextUtils.BinarySearch(array, start, end, key, false);
            }
            case 0: {
                return Median;
            }
            case 1: {
                start = Median + 1;
                return TextUtils.BinarySearch(array, start, end, key, false);
            }
        }
        return -1;
    }

    public static void swap(String[] arr, int i, int j) {
        String t = arr[i];
        arr[i] = arr[j];
        arr[j] = t;
    }

    public static String[] sortFiles(String[] as) {
        int length = as.length;
        String[] as1 = new String[length];
        int i = 0;
        for (int j = 0; j < length; ++j) {
            if (as[j].indexOf("/") == -1) continue;
            as1[i] = as[j];
            ++i;
        }
        for (int k = 0; k < length; ++k) {
            if (as[k].indexOf("/") != -1) continue;
            as1[i] = as[k];
            ++i;
        }
        return as1;
    }

    public static boolean compare(String x, String y, boolean ignoreCase) {
        return TextUtils.x(x, y, ignoreCase);
    }

    public static boolean x(String x, String y, boolean ignoreCase) {
        if (ignoreCase) {
            x = x.toLowerCase();
            y = y.toLowerCase();
        }
        return x.compareTo(y) > 0;
    }

    public static String[] reverse(String[] a) {
        String[] b = new String[a.length];
        int j = a.length;
        for (int i = 0; i < j; ++i) {
            b[j - 1 - i] = a[i];
        }
        return b;
    }

    public static String[] bubbleSort(String[] arr, boolean reverse, boolean ignoreCase, boolean ifFm) {
        for (int i = arr.length - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (!TextUtils.x(arr[j], arr[j + 1], ignoreCase)) continue;
                TextUtils.swap(arr, j, j + 1);
            }
        }
        if (ifFm) {
            arr = TextUtils.sortFiles(arr);
        }
        if (reverse) {
            return TextUtils.reverse(arr);
        }
        return arr;
    }

    public static String[] shellSort(String[] arr, boolean reverse, boolean ignoreCase, boolean ifFm) {
        int increment = arr.length / 2;
        while (increment > 0) {
            for (int i = increment; i < arr.length; ++i) {
                String temp = arr[i];
                for (int j = i; j >= increment && TextUtils.x(arr[j - increment], temp, ignoreCase); j -= increment) {
                    arr[j] = arr[j - increment];
                    arr[j - increment] = temp;
                }
            }
            increment = increment == 2 ? 1 : (int)Math.floor((double)increment / 2.2);
        }
        if (ifFm) {
            arr = TextUtils.sortFiles(arr);
        }
        if (reverse) {
            return TextUtils.reverse(arr);
        }
        return arr;
    }

    public static String[] quickSort(String[] arr, boolean reverse, boolean ignoreCase, boolean ifFm) {
        array = arr;
        ARRAY_LENGTH = array.length;
        TextUtils.quickSort(ignoreCase);
        if (ifFm) {
            array = TextUtils.sortFiles(array);
        }
        if (reverse) {
            return TextUtils.reverse(array);
        }
        return array;
    }

    public static void quickSort(boolean ignoreCase) {
        int startIndex = 0;
        int endIndex = ARRAY_LENGTH - 1;
        TextUtils.doSortS(startIndex, endIndex, ignoreCase);
    }

    private static void doSortS(int start, int end, boolean ignoreCase) {
        if (start >= end) {
            return;
        }
        int i = start;
        int j = end;
        int cur = i - (i - j) / 2;
        while (i < j) {
            while (i < cur && TextUtils.compare(array[cur], array[i], ignoreCase)) {
                ++i;
            }
            while (j > cur && TextUtils.compare(array[j], array[cur], ignoreCase)) {
                --j;
            }
            if (i >= j) continue;
            String temp = array[i];
            TextUtils.array[i] = array[j];
            TextUtils.array[j] = temp;
            if (i == cur) {
                cur = j;
                continue;
            }
            if (j != cur) continue;
            cur = i;
        }
        TextUtils.doSortS(start, cur, ignoreCase);
        TextUtils.doSortS(cur + 1, end, ignoreCase);
    }

    static {
        a = null;
    }
}

