/*
 * Decompiled with CFR 0.152.
 */
package framework.math;

import framework.math.MathUtils;

public class FP {
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = -2147483647;
    public static int SHIFT = 8;
    public static int PRECISION_POW = 256;
    public static int FRACTIONAL_DIGITS_POW = 100;
    public static int ZERO = 0 << SHIFT;
    public static int ONE = 1 << SHIFT;
    public static int TWO = 2 << SHIFT;
    public static int TEN = 10 << SHIFT;
    public static int HUNDRED = 100 << SHIFT;
    public static int THOUSAND = 1000 << SHIFT;
    public static int PI = 3216 >> 10 - SHIFT;
    public static int HUNDRED_EIGHTY_DIV_PI = 58670 >> 10 - SHIFT;
    public static int HALF = (ONE << SHIFT) / (2 << SHIFT);
    public static int THREE_DIV_FOUR = (75 << SHIFT << SHIFT) / HUNDRED;

    public static void setPrecision(int shift) {
        if (shift < 4 || shift > 16) {
            throw new RuntimeException("Specified precision is invalid! It should be between 4 and 16 inclusive.");
        }
        SHIFT = shift;
        PRECISION_POW = MathUtils.powIntInt(2, SHIFT);
        FRACTIONAL_DIGITS_POW = shift < 7 ? 10 : (shift < 10 ? 100 : (shift < 14 ? 1000 : 10000));
        ZERO = 0 << SHIFT;
        ONE = 1 << SHIFT;
        TEN = 10 << SHIFT;
        HUNDRED = 100 << SHIFT;
        THOUSAND = 1000 << SHIFT;
        PI = shift < 10 ? 3216 >> 10 - shift : (shift > 10 ? 3216 << shift - 10 : 3216);
        HUNDRED_EIGHTY_DIV_PI = shift < 10 ? 58670 >> 10 - shift : (shift > 10 ? 58670 << shift - 10 : 58670);
        HALF = (ONE << SHIFT) / (2 << SHIFT);
        THREE_DIV_FOUR = (75 << SHIFT << SHIFT) / HUNDRED;
    }

    public static final int fromInt(int x) {
        return x << SHIFT;
    }

    public static final int toInt(int fp_x) {
        if (fp_x < 0) {
            return -(-fp_x >> SHIFT);
        }
        return fp_x >> SHIFT;
    }

    public static final int toPositiveInt(int fp_x) {
        return fp_x >> SHIFT;
    }

    public static final int fromFloat(float x) {
        return (int)(x * (float)PRECISION_POW);
    }

    public static final float toFloat(int fp_x) {
        return (float)fp_x / (float)PRECISION_POW;
    }

    public static final String toString(int fp_x) {
        if (fp_x < 0) {
            int frac = (-fp_x & PRECISION_POW - 1) * FRACTIONAL_DIGITS_POW / PRECISION_POW;
            return "-" + (-fp_x >> SHIFT) + "." + (frac < 10 ? "0" + frac : "" + frac);
        }
        int frac = (fp_x & PRECISION_POW - 1) * FRACTIONAL_DIGITS_POW / PRECISION_POW;
        return (fp_x >> SHIFT) + "." + (frac < 10 ? "0" + frac : "" + frac);
    }

    public static final int fromString(String numberStr) {
        int length = numberStr.length();
        int dotIndex = numberStr.indexOf(46);
        int endIndex = dotIndex == -1 ? length : dotIndex;
        boolean negative = numberStr.charAt(0) == '-';
        int index = negative ? 1 : 0;
        int decPart = 0;
        int fracPart = 0;
        while (index < endIndex) {
            decPart = 10 * decPart + (numberStr.charAt(index++) - 48);
        }
        int fracLength = Math.max(0, length - ++index);
        while (index < length) {
            fracPart = 10 * fracPart + (numberStr.charAt(index++) - 48);
        }
        decPart <<= SHIFT;
        fracPart = (fracPart << SHIFT << SHIFT) / (MathUtils.powIntInt(10, fracLength) << SHIFT);
        if (negative) {
            return -decPart - fracPart;
        }
        return decPart + fracPart;
    }
}

