/*
 * Decompiled with CFR 0.152.
 */
package framework.menu;

import framework.graphics.SimpleSprite;
import framework.graphics.TextRenderer;
import javax.microedition.lcdui.Graphics;

public class MenuControl {
    public static final byte NOT_TAB = -1;
    public static final int TEXTBOX = 1;
    public static final int LABEL = 2;
    public static final int CHECKBOX = 3;
    public static final int BUTTON = 4;
    public static final int IMAGE = 5;
    public static final int SCROLLBOX = 6;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 4;
    public static final int TOP = 8;
    public static final int MIDDLE = 16;
    public static final int BOTTOM = 32;
    public int state;
    public int tabOrder;
    public int width;
    public int height;
    public int lineCount = 1;
    public int currentLine = 0;
    public int visibleLines = 0;
    public int relativeX;
    public int relativeY;
    public boolean isVisible;
    public int type;
    public int textAlignment;
    public int textPadding;
    public int anchor;
    public StringBuffer text;
    public SimpleSprite image;
    public SimpleSprite fontNormal;
    public SimpleSprite fontHighLighted;
    public SimpleSprite fontHighLighted2;
    public int spriteTransformation = 0;
    public int pozX;
    public int pozY;
    public int textPozX;
    public int textPozY;
    private boolean centerBoxText;

    /*
     * Enabled aggressive block sorting
     */
    public void calculatePositions(int menuFormOffsetX, int menuFormOffsetY, TextRenderer renderer) {
        block34: {
            block37: {
                block38: {
                    block39: {
                        block35: {
                            block36: {
                                this.pozX = menuFormOffsetX + this.relativeX;
                                this.pozY = menuFormOffsetY + this.relativeY;
                                this.textPozX = menuFormOffsetX + this.relativeX;
                                this.textPozY = menuFormOffsetY + this.relativeY;
                                if (!this.isVisible) break block34;
                                if (this.type != 4 && this.type != 2 && this.type != 3) break block34;
                                if (this.text == null) return;
                                if ((this.anchor & 1) == 0) break block35;
                                if ((this.textAlignment & 1) == 0) break block36;
                                this.textPozX -= (this.width >> 1) + this.textPadding;
                                break block37;
                            }
                            if ((this.textAlignment & 2) != 0) {
                                this.textPozX -= renderer.getStringWidth(this.text.length() / this.lineCount) >> 1;
                                break block37;
                            } else if ((this.textAlignment & 4) != 0) {
                                this.textPozX = this.textPozX + (this.width >> 1) - renderer.getStringWidth(this.text.length() / this.lineCount) - this.textPadding;
                            }
                            break block37;
                        }
                        if ((this.anchor & 4) == 0) break block38;
                        if ((this.textAlignment & 1) == 0) break block39;
                        this.textPozX += this.textPadding;
                        break block37;
                    }
                    if ((this.textAlignment & 2) != 0) {
                        this.textPozX += this.width - renderer.getStringWidth(this.text.length() / this.lineCount) >> 1;
                        break block37;
                    } else if ((this.textAlignment & 4) != 0) {
                        this.textPozX = this.textPozX + this.width - renderer.getStringWidth(this.text.length() / this.lineCount) - this.textPadding;
                    }
                    break block37;
                }
                if ((this.anchor & 8) != 0) {
                    if ((this.textAlignment & 1) != 0) {
                        this.textPozX = this.textPozX - this.width + this.textPadding;
                    } else if ((this.textAlignment & 2) != 0) {
                        this.textPozX = this.textPozX - (this.width >> 1) - (renderer.getStringWidth(this.text.length()) >> 1);
                    } else if ((this.textAlignment & 4) != 0) {
                        this.textPozX -= renderer.getStringWidth(this.text.length() / this.lineCount);
                    }
                }
            }
            if ((this.anchor & 2) != 0) {
                if ((this.textAlignment & 8) != 0) {
                    this.textPozY = this.textPozY - (this.height >> 1) + this.textPadding;
                    return;
                }
                if ((this.textAlignment & 0x10) != 0) {
                    this.textPozY -= renderer.getStringHeight(this.lineCount) >> 1;
                    return;
                }
                if ((this.textAlignment & 0x20) == 0) return;
                this.textPozY = this.textPozY + (this.height >> 1) - (renderer.getStringHeight(this.lineCount) >> 1);
                return;
            }
            if ((this.anchor & 0x10) != 0) {
                if ((this.textAlignment & 8) != 0) {
                    this.textPozY += this.textPadding;
                    return;
                }
                if ((this.textAlignment & 0x10) != 0) {
                    this.textPozY += this.height - renderer.getStringHeight(this.lineCount) >> 1;
                    return;
                }
                if ((this.textAlignment & 0x20) == 0) return;
                this.textPozY = this.textPozY + this.height - renderer.getStringHeight(this.lineCount) - this.textPadding;
                return;
            }
            if ((this.anchor & 0x20) == 0) return;
            if ((this.textAlignment & 8) != 0) {
                this.textPozY = this.textPozY - this.height + this.textPadding;
                return;
            }
            if ((this.textAlignment & 0x10) != 0) {
                this.textPozY -= this.height + renderer.getStringHeight(this.lineCount) >> 1;
                return;
            }
            if ((this.textAlignment & 0x20) == 0) return;
            this.textPozY = this.textPozY - renderer.getStringHeight(this.lineCount) - this.textPadding;
            return;
        }
        if (this.type != 1) {
            if (this.type != 6) return;
        }
        if ((this.anchor & 1) != 0) {
            this.textPozX -= (this.width >> 1) + this.textPadding;
        } else if ((this.anchor & 4) != 0) {
            this.textPozX += this.textPadding;
        } else if ((this.anchor & 8) != 0) {
            this.textPozX = this.textPozX - this.width + this.textPadding;
        }
        if ((this.anchor & 2) != 0) {
            if ((this.textAlignment & 8) != 0) {
                this.textPozY = this.textPozY - (this.height >> 1) + this.textPadding;
                return;
            }
            if ((this.textAlignment & 0x10) != 0) {
                this.textPozY -= renderer.getStringHeight(this.lineCount) >> 1;
                return;
            }
            if ((this.textAlignment & 0x20) == 0) return;
            this.textPozY = this.textPozY + (this.height >> 1) - (renderer.getStringHeight(this.lineCount) >> 1);
            return;
        }
        if ((this.anchor & 0x10) != 0) {
            if ((this.textAlignment & 8) != 0) {
                this.textPozY += this.textPadding;
                return;
            }
            if ((this.textAlignment & 0x10) != 0) {
                this.textPozY += this.height - renderer.getStringHeight(this.lineCount) >> 1;
                return;
            }
            if ((this.textAlignment & 0x20) == 0) return;
            this.textPozY = this.textPozY + this.height - renderer.getStringHeight(this.lineCount) - this.textPadding;
            return;
        }
        if ((this.anchor & 0x20) == 0) return;
        if ((this.textAlignment & 8) != 0) {
            this.textPozY = this.textPozY - this.height + this.textPadding;
            return;
        }
        if ((this.textAlignment & 0x10) != 0) {
            this.textPozY -= this.height + renderer.getStringHeight(this.lineCount) >> 1;
            return;
        }
        if ((this.textAlignment & 0x20) == 0) return;
        this.textPozY = this.textPozY - renderer.getStringHeight(this.lineCount) - this.textPadding;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Graphics graphics, TextRenderer renderer) {
        if (this.isVisible) {
            if (this.type == 4 || this.type == 2 || this.type == 3) {
                if (this.image != null) {
                    this.image.paintWithAnchor(graphics, this.pozX, this.pozY, this.state, this.spriteTransformation, this.anchor);
                }
                if (this.text == null) return;
                switch (this.state) {
                    case 0: {
                        renderer.setCurrentFont(this.fontNormal);
                        break;
                    }
                    case 1: {
                        renderer.setCurrentFont(this.fontHighLighted);
                        break;
                    }
                    case 2: {
                        renderer.setCurrentFont(this.fontHighLighted2);
                        break;
                    }
                }
                renderer.renderText(graphics, this.textPozX, this.textPozY, this.text);
                renderer.setCurrentFont(this.fontNormal);
                return;
            }
        }
        if (this.isVisible) {
            if (this.type == 5) {
                if (this.image == null) return;
                this.image.paintWithAnchor(graphics, this.pozX, this.pozY, this.state, this.spriteTransformation, this.anchor);
                return;
            }
        }
        if (!this.isVisible) return;
        if (this.type != 6) {
            if (this.type != 1) return;
        }
        if (this.image != null) {
            this.image.paintWithAnchor(graphics, this.pozX, this.pozY, this.state, this.spriteTransformation, this.anchor);
        }
        if (this.text == null) return;
        switch (this.state) {
            case 0: {
                renderer.setCurrentFont(this.fontNormal);
                break;
            }
            case 1: {
                renderer.setCurrentFont(this.fontHighLighted);
                break;
            }
            case 2: {
                renderer.setCurrentFont(this.fontHighLighted2);
                break;
            }
        }
        boolean bl = this.centerBoxText = (this.textAlignment & 2) != 0;
        if (this.currentLine + this.visibleLines <= this.lineCount && this.currentLine >= 0) {
            renderer.renderTextWordBreak(graphics, this.textPozX, this.textPozY, this.width, this.height, this.currentLine, this.text, this.centerBoxText);
        } else if (this.currentLine + this.visibleLines > this.lineCount) {
            this.currentLine = this.lineCount - this.visibleLines;
            renderer.renderTextWordBreak(graphics, this.textPozX, this.textPozY, this.width, this.height, this.currentLine, this.text, this.centerBoxText);
        } else if (this.currentLine < 0) {
            renderer.renderTextWordBreak(graphics, this.textPozX, this.textPozY, this.width, this.height, 0, this.text, this.centerBoxText);
            this.currentLine = 0;
        }
        renderer.setCurrentFont(this.fontNormal);
    }
}

