/*
 * Decompiled with CFR 0.152.
 */
package menu;

import containers.Localizaton;
import framework.AppState;
import framework.MainGameCanvas;
import framework.graphics.SimpleSprite;
import framework.graphics.TextRenderer;
import framework.menu.MenuForm;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import root.GoolGlobals;

public class Splash
extends AppState {
    Image background;
    Image bowl;
    Image winner;
    SimpleSprite confetti;
    SimpleSprite button;
    Random rand = new Random();
    public int[] particleVars;
    private int mode;
    private MenuForm mainMenu;
    private int particleCount = 200;
    private int maxLiveTime = 40;
    private int activePaticles = 0;
    private long lastSpawned = 0L;
    private long spawnTime = 400L;
    private long moveTime = 50L;
    private long startMove = 0L;
    private long currentTime;
    private int maxParticleSpeed = 4;
    private int fallBorder = 240;
    private int bowlPosition = 0;
    private int winerPosition = 0;
    private int continue2ID;
    private int music2ID;
    private int exit2ID;
    int timeCount = 0;
    int state = -1;

    public Splash(String stateName, MainGameCanvas mainGameCanvas) {
        super(stateName, mainGameCanvas);
    }

    public boolean initialize(Object param) {
        int state = 0;
        if (param != null) {
            this.state = state = ((Integer)param).intValue();
            this.mode = state;
        }
        try {
            if (GoolGlobals.button2 == null) {
                this.bowl = Image.createImage((String)"/button2.png");
                this.button = new SimpleSprite(this.bowl, 1);
                this.bowl = null;
            } else {
                this.button = GoolGlobals.button2;
            }
            if (state == 0) {
                this.createMainMenu3();
                this.background = Image.createImage((String)"/logo176o.png");
                this.winner = Image.createImage((String)"/ngames_splash_132.png");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void update(int deltaTime) {
        int i = 0;
        int j = 0;
        if (this.mode == 2) {
            this.currentTime = System.currentTimeMillis();
            if (this.activePaticles < this.particleCount) {
                if (this.lastSpawned == 0L) {
                    this.lastSpawned = this.currentTime;
                } else if (this.currentTime - this.lastSpawned > this.spawnTime) {
                    for (i = j = this.activePaticles * 5; i < j + 25; i += 5) {
                        this.spawnParticle(i);
                        ++this.activePaticles;
                    }
                    this.lastSpawned = this.currentTime;
                }
            }
            if (this.startMove == 0L) {
                this.startMove = this.currentTime;
            } else if (this.currentTime - this.startMove > this.moveTime) {
                this.startMove = this.currentTime;
                for (i = 0; i < this.activePaticles * 5; i += 5) {
                    if (this.particleVars[i + 4] > 0) {
                        int n = i + 1;
                        this.particleVars[n] = this.particleVars[n] + this.particleVars[i + 4];
                        if (this.particleVars[i + 1] <= this.fallBorder || Math.abs(this.rand.nextInt()) % Math.max(1, 320 - this.particleVars[i + 1]) != 0) continue;
                        this.particleVars[i + 4] = 0;
                        continue;
                    }
                    int n = i + 3;
                    this.particleVars[n] = this.particleVars[n] + 1;
                    if (this.particleVars[i + 3] <= this.maxLiveTime) continue;
                    this.spawnParticle(i);
                }
            }
        }
        ++this.timeCount;
        if (this.timeCount == 300) {
            this.mainGameCanvas.requestAppStateChange("Menu");
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        super.keyReleased(keyCode);
    }

    private void createMainMenu() {
        int fontSize = TextRenderer.getInstance().getStringHeight(1);
        int[] cols = new int[]{GoolGlobals.MAINMENU_MARGIN, GoolGlobals.menuBackground.getWidth() - GoolGlobals.MAINMENU_MARGIN, -1};
        int[] rows = new int[]{GoolGlobals.MAINMENU_BG_Y, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, 2 * fontSize, 2 * fontSize, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, -1};
        this.mainMenu = MenuForm.createMenuForm(4, rows, cols, 240, 320, (byte)1, (byte)0);
        this.continue2ID = this.mainMenu.createScrollBox(240 - 4 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 2, 1, 10, 10, Localizaton.EMPTY, 0);
        this.exit2ID = this.mainMenu.createControl(4, 1, 3, 1, null, Localizaton.EMPTY);
        int tempID = this.mainMenu.createControl(4, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 0, 33, 18, GoolGlobals.button, Localizaton.MENU_CONTINUE, 0, 0);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.mainMenu.createControl(4, -1, 5, 0, null, Localizaton.EMPTY);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
    }

    private void createMainMenu2() {
        int fontSize = TextRenderer.getInstance().getStringHeight(1);
        int[] cols = new int[]{GoolGlobals.MAINMENU_MARGIN, GoolGlobals.menuBackground.getWidth() - GoolGlobals.MAINMENU_MARGIN, -1};
        int[] rows = new int[]{GoolGlobals.MAINMENU_BG_Y, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, 2 * fontSize, 2 * fontSize, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, -1};
        this.mainMenu = MenuForm.createMenuForm(4, rows, cols, 240, 320, (byte)1, (byte)0);
        this.continue2ID = this.mainMenu.createScrollBox(240 - 4 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 2, 1, 10, 10, Localizaton.WIN, 0);
        this.exit2ID = this.mainMenu.createControl(4, 1, 3, 1, null, Localizaton.EMPTY);
        int tempID = this.mainMenu.createControl(4, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 0, 33, 18, GoolGlobals.button, Localizaton.MENU_CONTINUE, 0, 0);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.mainMenu.createControl(4, -1, 5, 0, null, Localizaton.EMPTY);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
    }

    private void createMainMenu3() {
        int fontSize = TextRenderer.getInstance().getStringHeight(1);
        int[] cols = new int[]{GoolGlobals.MAINMENU_MARGIN, 100 - GoolGlobals.MAINMENU_MARGIN, -1};
        int[] rows = new int[]{GoolGlobals.MAINMENU_BG_Y, 50 - 2 * fontSize, 2 * fontSize, 2 * fontSize, 50 - 2 * fontSize, -1};
        this.mainMenu = MenuForm.createMenuForm(4, rows, cols, 240, 320, (byte)1, (byte)0);
        this.continue2ID = this.mainMenu.createScrollBox(240 - 4 * fontSize, TextRenderer.getInstance().getStringHeight(10), -1, 2, 1, 10, 10, Localizaton.LOADING, 0);
        this.exit2ID = this.mainMenu.createControl(4, 1, 3, 1, null, Localizaton.EMPTY);
        int tempID = this.mainMenu.createControl(4, -1, 5, 0, null, Localizaton.EMPTY);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.mainMenu.createControl(4, -1, 5, 0, null, Localizaton.EMPTY);
        this.mainMenu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
    }

    public void render(Graphics g) {
        if (this.timeCount > 150) {
            g.setColor(0xCCCCFF);
            g.fillRect(0, 0, 240, 320);
            TextRenderer.getInstance().renderText(g, 120 - TextRenderer.getInstance().getStringWidth(Localizaton.LOADING.length()) / 2, 240, Localizaton.LOADING);
            g.drawImage(this.background, 120 - this.background.getWidth() / 2 + 5, 10, 0);
        } else {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, 240, 320);
            g.drawImage(this.winner, 120 - this.winner.getWidth() / 2, 160 - this.winner.getHeight() / 2, 0);
        }
    }

    public void deinitialize() {
        this.background = null;
        this.bowl = null;
        this.confetti = null;
        this.winner = null;
        this.button = null;
        this.particleVars = null;
    }

    private void spawnParticle(int i) {
        this.particleVars[i] = Math.abs(this.rand.nextInt()) % 240;
        this.particleVars[i + 1] = 0;
        this.particleVars[i + 2] = Math.abs(this.rand.nextInt()) % this.confetti.framesCount;
        this.particleVars[i + 3] = 0;
        this.particleVars[i + 4] = 1 + Math.abs(this.rand.nextInt()) % this.maxParticleSpeed;
    }
}

