/*
 * Decompiled with CFR 0.152.
 */
package framework.math;

import framework.math.FP;
import framework.math.Int;

public class Interpolator {
    private InterpolVar[] var;
    private int varLength;

    public Interpolator(int varCount) {
        this.var = new InterpolVar[varCount];
        this.varLength = 0;
    }

    public boolean linearInterpolation(Int fp_valReference, int fp_from, int fp_to, int fp_time) {
        if (fp_time < 0) {
            return false;
        }
        this.var[this.varLength] = new InterpolVar(fp_valReference, fp_from, fp_to, fp_time);
        ++this.varLength;
        return true;
    }

    public boolean linearInterpolationTab(Int fp_valReference, int[] fp_points, int[] fp_times) {
        this.var[this.varLength] = new InterpolVar(fp_valReference, fp_points, fp_times);
        ++this.varLength;
        return true;
    }

    public void updateTab(int fp_deltaTime) {
        boolean j = false;
        for (int i = 0; i < this.varLength; ++i) {
            this.var[i].fp_remainingTime -= fp_deltaTime;
            this.var[i].fp_value += this.var[i].fp_step * fp_deltaTime >> FP.SHIFT;
            this.var[i].fp_valReference.setValue(this.var[i].fp_value);
            if (this.var[i].fp_remainingTime > 0) continue;
            this.var[i].times_count++;
            if (this.var[i].times_count != this.var[i].times.length) {
                this.var[i].fp_value = this.var[i].points[this.var[i].times_count];
                this.var[i].fp_remainingTime = this.var[i].times[this.var[i].times_count];
                this.var[i].fp_step = (this.var[i].points[this.var[i].times_count + 1] - this.var[i].points[this.var[i].times_count] << FP.SHIFT) / this.var[i].times[this.var[i].times_count];
                continue;
            }
            this.var[i] = this.var[this.varLength - 1];
            --this.varLength;
        }
    }

    public void update(int fp_deltaTime) {
        for (int i = 0; i < this.varLength; ++i) {
            this.var[i].fp_remainingTime -= fp_deltaTime;
            this.var[i].fp_value += this.var[i].fp_step * fp_deltaTime >> FP.SHIFT;
            this.var[i].fp_valReference.setValue(this.var[i].fp_value);
            if (this.var[i].fp_remainingTime > 0) continue;
            this.var[i] = this.var[this.varLength - 1];
            --this.varLength;
        }
    }

    private class InterpolVar {
        private Int fp_valReference;
        private int fp_value;
        private int fp_remainingTime;
        private int fp_step;
        private int[] times;
        private int[] points;
        private int times_count;

        private InterpolVar() {
            this.fp_value = 0;
            this.fp_remainingTime = 0;
            this.fp_step = 0;
        }

        private InterpolVar(Int fp_valReference, int fp_from, int fp_to, int fp_time) {
            this.fp_valReference = fp_valReference;
            this.fp_value = fp_from;
            this.fp_remainingTime = fp_time;
            this.times_count = 0;
            this.fp_step = (fp_to - fp_from << FP.SHIFT) / fp_time;
        }

        public InterpolVar(Int fp_valRefrence, int[] fp_points, int[] fp_times) {
            this.points = this.points;
            this.times = this.times;
            this.fp_valReference = this.fp_valReference;
            this.fp_value = fp_points[0];
            this.fp_remainingTime = fp_times[0];
            this.fp_step = (fp_points[1] - fp_points[0] << FP.SHIFT) / fp_times[0];
        }
    }
}

