/*
 * Decompiled with CFR 0.152.
 */
package framework.utils;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileReader {
    private static final short STRING_BUFFER_SIZE = 256;
    private InputStream is;
    private DataInputStream dis;
    private StringBuffer lineStringBuffer;

    public FileReader(String fileName) throws IOException {
        this.is = this.getClass().getResourceAsStream(fileName);
        if (this.is == null) {
            throw new RuntimeException("Couldn't create resource stream for file: " + fileName + ".");
        }
        this.dis = new DataInputStream(this.is);
        if (this.dis == null) {
            this.is.close();
            throw new RuntimeException("Couldn't create data input stream for file: " + fileName + ".");
        }
        this.lineStringBuffer = new StringBuffer(256);
    }

    public String readNextLine() throws IOException {
        this.lineStringBuffer.delete(0, this.lineStringBuffer.length());
        int ch = 0;
        while (this.dis.available() > 0 && (ch = this.dis.readUnsignedByte()) != 13 && ch != 10) {
            this.lineStringBuffer.append((char)ch);
        }
        if (ch == 13 && (ch = this.dis.readUnsignedByte()) != 10) {
            this.close();
            throw new RuntimeException("Expected CR LF format, but after character '\\r' the character with code " + ch + " was found.");
        }
        return this.lineStringBuffer.toString();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    public void skipEOL() throws IOException {
        if (this.dis.readUnsignedByte() == 13) {
            this.dis.readUnsignedByte();
        }
    }

    public void close() {
        try {
            if (this.dis != null) {
                this.dis.close();
            }
        }
        catch (IOException exc) {
            throw new RuntimeException("IOException was thrown during closing data input stream.");
        }
    }

    public boolean EOF() throws IOException {
        return this.dis.available() <= 0;
    }
}

