/*
 * Decompiled with CFR 0.152.
 */
package tdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;

public class PNGUtil {
    private static final int FTEXT_MASK = 1;
    private static final int FHCRC_MASK = 2;
    private static final int FEXTRA_MASK = 4;
    private static final int FNAME_MASK = 8;
    private static final int FCOMMENT_MASK = 16;
    private static final int BTYPE_NONE = 0;
    private static final int BTYPE_FIXED = 1;
    private static final int BTYPE_DYNAMIC = 2;
    private static final int BTYPE_RESERVED = 3;
    private static final int MAX_BITS = 16;
    private static final int MAX_CODE_LITERALS = 287;
    private static final int MAX_CODE_DISTANCES = 31;
    private static final int MAX_CODE_LENGTHS = 18;
    private static final int EOB_CODE = 256;
    private static final int[] LENGTH_EXTRA_BITS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 99, 99};
    private static final int[] LENGTH_VALUES = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0};
    private static final int[] DISTANCE_EXTRA_BITS = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private static final int[] DISTANCE_VALUES = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
    private static final int[] DYNAMIC_LENGTH_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static int gzipIndex;
    private static int gzipByte;
    private static int gzipBit;
    private static final int PNG = -1991225785;
    private static final int IHDR = 1229472850;
    private static final int PLTE = 1347179589;
    private static final int tRNS = 1951551059;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    static int imageWidth;
    static int imageHeight;
    static int bitDepth;
    static int scanLength;
    static int sourceOffset;
    private static final int BASE = 65521;
    private static final int NMAX = 5552;
    static int[] CRCTable;
    private static int crc;
    static final byte[] _IEND;

    public static byte[] deflate(byte[] inflated) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeByte(1);
        int len = inflated.length << 8 | inflated.length >> 8;
        dos.writeShort(len);
        dos.writeShort(~len);
        ((OutputStream)dos).write(inflated);
        int _adler32 = (int)PNGUtil.adler32(1L, inflated, 0, inflated.length);
        dos.writeInt(_adler32);
        System.out.println("ADLER32 : " + Integer.toHexString(_adler32));
        dos.close();
        return bos.toByteArray();
    }

    public static byte[] inflate(byte[] gzip, int _offset, int inflatedSize) throws IOException {
        gzipBit = 0;
        gzipByte = 0;
        gzipIndex = _offset;
        byte[] uncompressed = new byte[inflatedSize];
        int uncompressedIndex = 0;
        int bfinal = 0;
        int btype = 0;
        do {
            int[] distanceTree;
            int[] literalTree;
            bfinal = PNGUtil.readBits(gzip, 1);
            btype = PNGUtil.readBits(gzip, 2);
            if (btype == 0) {
                gzipBit = 0;
                int len = PNGUtil.readBits(gzip, 16);
                int nlen = PNGUtil.readBits(gzip, 16);
                System.arraycopy(gzip, gzipIndex, uncompressed, uncompressedIndex, len);
                gzipIndex += len;
                uncompressedIndex += len;
                continue;
            }
            if (btype == 2) {
                int hlit = PNGUtil.readBits(gzip, 5) + 257;
                int hdist = PNGUtil.readBits(gzip, 5) + 1;
                int hclen = PNGUtil.readBits(gzip, 4) + 4;
                byte[] lengthBits = new byte[19];
                for (int i = 0; i < hclen; ++i) {
                    lengthBits[PNGUtil.DYNAMIC_LENGTH_ORDER[i]] = (byte)PNGUtil.readBits(gzip, 3);
                }
                int[] lengthTree = PNGUtil.createHuffmanTree(lengthBits, 18);
                literalTree = PNGUtil.createHuffmanTree(PNGUtil.decodeCodeLengths(gzip, lengthTree, hlit), hlit - 1);
                distanceTree = PNGUtil.createHuffmanTree(PNGUtil.decodeCodeLengths(gzip, lengthTree, hdist), hdist - 1);
            } else {
                int i;
                byte[] literalBits = new byte[288];
                for (i = 0; i < 144; ++i) {
                    literalBits[i] = 8;
                }
                for (i = 144; i < 256; ++i) {
                    literalBits[i] = 9;
                }
                for (i = 256; i < 280; ++i) {
                    literalBits[i] = 7;
                }
                for (i = 280; i < 288; ++i) {
                    literalBits[i] = 8;
                }
                literalTree = PNGUtil.createHuffmanTree(literalBits, 287);
                byte[] distanceBits = new byte[32];
                for (int i2 = 0; i2 < distanceBits.length; ++i2) {
                    distanceBits[i2] = 5;
                }
                distanceTree = PNGUtil.createHuffmanTree(distanceBits, 31);
            }
            int code = 0;
            int leb = 0;
            int deb = 0;
            while ((code = PNGUtil.readCode(gzip, literalTree)) != 256) {
                if (code > 256) {
                    int length = LENGTH_VALUES[code -= 257];
                    leb = LENGTH_EXTRA_BITS[code];
                    if (leb > 0) {
                        length += PNGUtil.readBits(gzip, leb);
                    }
                    code = PNGUtil.readCode(gzip, distanceTree);
                    int distance = DISTANCE_VALUES[code];
                    deb = DISTANCE_EXTRA_BITS[code];
                    if (deb > 0) {
                        distance += PNGUtil.readBits(gzip, deb);
                    }
                    int offset = uncompressedIndex - distance;
                    while (distance < length) {
                        System.arraycopy(uncompressed, offset, uncompressed, uncompressedIndex, distance);
                        uncompressedIndex += distance;
                        length -= distance;
                        distance <<= 1;
                    }
                    System.arraycopy(uncompressed, offset, uncompressed, uncompressedIndex, length);
                    uncompressedIndex += length;
                    continue;
                }
                uncompressed[uncompressedIndex++] = (byte)code;
            }
        } while (bfinal == 0);
        return uncompressed;
    }

    private static int readBits(byte[] gzip, int n) {
        int data = gzipBit == 0 ? (gzipByte = gzip[gzipIndex++] & 0xFF) : gzipByte >> gzipBit;
        for (int i = 8 - gzipBit; i < n; i += 8) {
            gzipByte = gzip[gzipIndex++] & 0xFF;
            data |= gzipByte << i;
        }
        gzipBit = gzipBit + n & 7;
        return data & (1 << n) - 1;
    }

    private static int readCode(byte[] gzip, int[] tree) {
        int node = tree[0];
        while (node >= 0) {
            if (gzipBit == 0) {
                gzipByte = gzip[gzipIndex++] & 0xFF;
            }
            node = (gzipByte & 1 << gzipBit) == 0 ? tree[node >> 16] : tree[node & 0xFFFF];
            gzipBit = gzipBit + 1 & 7;
        }
        return node & 0xFFFF;
    }

    private static byte[] decodeCodeLengths(byte[] gzip, int[] lengthTree, int count) {
        byte[] bits = new byte[count];
        int i = 0;
        int code = 0;
        int last = 0;
        while (i < count) {
            code = PNGUtil.readCode(gzip, lengthTree);
            if (code >= 16) {
                int repeat = 0;
                if (code == 16) {
                    repeat = 3 + PNGUtil.readBits(gzip, 2);
                    code = last;
                } else {
                    repeat = code == 17 ? 3 + PNGUtil.readBits(gzip, 3) : 11 + PNGUtil.readBits(gzip, 7);
                    code = 0;
                }
                while (repeat-- > 0) {
                    bits[i++] = (byte)code;
                }
            } else {
                bits[i++] = (byte)code;
            }
            last = code;
        }
        return bits;
    }

    private static int[] createHuffmanTree(byte[] bits, int maxCode) {
        int[] bl_count = new int[17];
        for (int i = 0; i < bits.length; ++i) {
            byte by = bits[i];
            bl_count[by] = bl_count[by] + 1;
        }
        int code = 0;
        bl_count[0] = 0;
        int[] next_code = new int[17];
        for (int i = 1; i <= 16; ++i) {
            next_code[i] = code = code + bl_count[i - 1] << 1;
        }
        int[] tree = new int[(maxCode << 1) + 16];
        int treeInsert = 1;
        for (int i = 0; i <= maxCode; ++i) {
            byte len = bits[i];
            if (len == 0) continue;
            byte by = len;
            next_code[by] = next_code[by] + 1;
            int node = 0;
            for (int bit = len - 1; bit >= 0; --bit) {
                int value = code & 1 << bit;
                if (value == 0) {
                    int left = tree[node] >> 16;
                    if (left == 0) {
                        int n = node;
                        tree[n] = tree[n] | treeInsert << 16;
                        node = treeInsert++;
                        continue;
                    }
                    node = left;
                    continue;
                }
                int right = tree[node] & 0xFFFF;
                if (right == 0) {
                    int n = node;
                    tree[n] = tree[n] | treeInsert;
                    node = treeInsert++;
                    continue;
                }
                node = right;
            }
            tree[node] = Integer.MIN_VALUE | i;
        }
        return tree;
    }

    static Image loadImage(String filename) throws Exception {
        return PNGUtil.loadImage2(Class.forName("tdf.PNGUtil").getResourceAsStream(filename));
    }

    static Image loadImage2(InputStream _is) throws Exception {
        long startTime = System.currentTimeMillis();
        DataInputStream is = new DataInputStream(_is);
        byte[] sourceData = new byte[49152];
        try {
            is.readFully(sourceData);
        }
        catch (IOException ex) {
            // empty catch block
        }
        is.close();
        is = new DataInputStream(new ByteArrayInputStream(sourceData));
        int i = 0;
        sourceOffset = 0;
        block10: while (true) {
            int chunkType = is.readInt();
            sourceOffset += 4;
            switch (chunkType) {
                case -1991225785: {
                    System.out.println("PNG Signature");
                    break;
                }
                case 1229472850: {
                    System.out.println("IHDR");
                    byte[] header = new byte[13];
                    is.read(header);
                    sourceOffset += 13;
                    imageWidth = ((header[2] & 0xFF) << 8) + (header[3] & 0xFF);
                    imageHeight = ((header[6] & 0xFF) << 8) + (header[7] & 0xFF);
                    bitDepth = header[8];
                    System.out.println("Width : " + imageWidth);
                    System.out.println("Height : " + imageHeight);
                    System.out.println("Bit depth : " + bitDepth);
                    break;
                }
                case 1347179589: {
                    System.out.println("PLTE");
                    is.skip(i);
                    sourceOffset += i;
                    break;
                }
                case 1951551059: {
                    System.out.println("tRNS");
                    is.skip(i);
                    sourceOffset += i;
                    break;
                }
                case 1229278788: {
                    System.out.println("IEND");
                    is.skip(i);
                    sourceOffset += i;
                    break;
                }
                case 1229209940: {
                    System.out.println("IDAT");
                    sourceOffset += 2;
                    break block10;
                }
                default: {
                    System.out.println("Unknown chunk : " + Integer.toHexString(chunkType));
                    is.skip(i);
                    sourceOffset += i;
                }
            }
            is.readInt();
            sourceOffset += 4;
            if (is.available() == 0) break;
            i = is.readInt();
            sourceOffset += 4;
        }
        is.close();
        scanLength = imageWidth * bitDepth / 8 + 1;
        if (imageWidth * bitDepth % 8 != 0) {
            ++scanLength;
        }
        byte[] inflated = PNGUtil.inflate(sourceData, sourceOffset, imageHeight * scanLength);
        System.out.println("scanLength=" + scanLength);
        System.out.println();
        System.out.println(inflated == null ? "inflated is null" : "inflated size : " + inflated.length);
        System.out.println();
        System.out.println();
        PNGUtil.verticalFlip(inflated);
        byte[] deflated = PNGUtil.deflate(inflated);
        System.out.println("deflated.length=" + deflated.length);
        System.arraycopy(deflated, 0, sourceData, sourceOffset, deflated.length);
        sourceData[PNGUtil.sourceOffset - 1] = 1;
        int l = deflated.length + 2;
        sourceData[PNGUtil.sourceOffset - 2 - 4 - 4] = (byte)(l >> 24);
        sourceData[PNGUtil.sourceOffset - 2 - 4 - 4 + 1] = (byte)(l >> 16);
        sourceData[PNGUtil.sourceOffset - 2 - 4 - 4 + 2] = (byte)(l >> 8);
        sourceData[PNGUtil.sourceOffset - 2 - 4 - 4 + 3] = (byte)l;
        int crc32 = ~PNGUtil.crc32(sourceData, sourceOffset - 2 - 4, deflated.length + 2 + 4, -1);
        System.out.println("\nCRC32 : " + Integer.toHexString(crc32) + "\n");
        sourceData[PNGUtil.sourceOffset + deflated.length] = (byte)(crc32 >> 24);
        sourceData[PNGUtil.sourceOffset + deflated.length + 1] = (byte)(crc32 >> 16);
        sourceData[PNGUtil.sourceOffset + deflated.length + 2] = (byte)(crc32 >> 8);
        sourceData[PNGUtil.sourceOffset + deflated.length + 3] = (byte)crc32;
        System.arraycopy(_IEND, 0, sourceData, sourceOffset + deflated.length + 4, 12);
        System.out.println();
        Image result = Image.createImage((byte[])sourceData, (int)0, (int)sourceData.length);
        return result;
    }

    static void verticalFlip(byte[] inflated) {
        for (int y = 0; y < imageHeight; ++y) {
            block6: for (int x = 1; x < scanLength / 2 + 1; ++x) {
                int leftPixel = y * scanLength + x;
                int rightPixel = y * scanLength + (scanLength - x);
                byte bl = inflated[leftPixel];
                byte br = inflated[rightPixel];
                switch (bitDepth) {
                    case 8: {
                        inflated[rightPixel] = bl;
                        inflated[leftPixel] = br;
                        continue block6;
                    }
                    case 4: {
                        inflated[leftPixel] = (byte)((br & 0xF) << 4 | (br & 0xF0) >> 4);
                        inflated[rightPixel] = (byte)((bl & 0xF) << 4 | (bl & 0xF0) >> 4);
                        continue block6;
                    }
                    case 2: {
                        inflated[leftPixel] = (byte)(br << 6 | br >> 2 & 0xFF | br >> 4 & 0xFF | br >> 6);
                        inflated[rightPixel] = (byte)(bl << 6 | bl >> 2 & 0xFF | bl >> 4 & 0xFF | bl >> 6);
                    }
                }
            }
        }
    }

    static long adler32(long adler, byte[] buf, int index, int len) {
        if (buf == null) {
            return 1L;
        }
        long s1 = adler & 0xFFFFL;
        long s2 = adler >> 16 & 0xFFFFL;
        while (len > 0) {
            int k = len < 5552 ? len : 5552;
            len -= k;
            while (k >= 16) {
                for (int i = 0; i < 16; ++i) {
                    s2 += (s1 += (long)(buf[index++] & 0xFF));
                }
                k -= 16;
            }
            if (k != 0) {
                do {
                    s2 += (s1 += (long)(buf[index++] & 0xFF));
                } while (--k != 0);
            }
            s1 %= 65521L;
            s2 %= 65521L;
        }
        return s2 << 16 | s1;
    }

    public static int crc32(byte[] buffer, int start, int count, int lastcrc) {
        int i = start;
        crc = lastcrc;
        while (count-- != 0) {
            int temp1 = crc >>> 8;
            int temp2 = CRCTable[(crc ^ buffer[i++]) & 0xFF];
            crc = temp1 ^ temp2;
        }
        return crc;
    }

    static {
        int CRC32_POLYNOMIAL = -306674912;
        CRCTable = new int[256];
        for (int i = 0; i <= 255; ++i) {
            int crc = i;
            for (int j = 8; j > 0; --j) {
                if ((crc & 1) == 1) {
                    crc = crc >>> 1 ^ 0xEDB88320;
                    continue;
                }
                crc >>>= 1;
            }
            PNGUtil.CRCTable[i] = crc;
        }
        _IEND = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    }
}

