/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class LFont {
    private static final boolean _bLower2Upper = true;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int VCENTER = 3;
    public static final int HVCENTER = 4;
    public static final int HCENTER = 5;
    public static final int TextWithCapture = 10;
    private int _startIdx;
    private int _endIdx;
    int _offset;
    int clipX = 0;
    int clipY = 0;
    int clipW = 0;
    int clipH = 0;
    private Image _image;
    private short[] _xStarts;
    private short[] _widths;
    private int _height;

    public static int getWidth() {
        return 128;
    }

    public static String[] LStr2(LFont font, String txt) {
        return LFont.LStr2(font, txt, LFont.getWidth() - 4, 1);
    }

    public static String[] LStr2(LFont font, String txt, int xs) {
        return LFont.LStr2(font, txt, xs, 1);
    }

    public static String[] LStr2(LFont font, String txt, int xs, int gap) {
        if (txt == null) {
            return null;
        }
        int myWrapCnt = 0;
        String[] myWrapTxt = new String[300];
        int start = 0;
        int end = 0;
        int tend = 0;
        int t = 0;
        while (txt.charAt(txt.length() - 1) == ' ') {
            txt = txt.substring(0, txt.length() - 1);
        }
        while (end < txt.length()) {
            char c = txt.charAt(end);
            if (c >= ' ') {
                if (c == ' ') {
                    tend = end;
                }
                t += font.charWidth(c) + gap;
            }
            if (t >= xs || c == '\n' || c == '|' || c == '\\') {
                if (t >= xs && tend > start) {
                    end = tend;
                    if (txt.charAt(end) == ' ') {
                        --end;
                    }
                } else {
                    tend = end;
                    if (tend > start || end == start) {
                        --end;
                    }
                }
                myWrapTxt[myWrapCnt++] = txt.substring(start, end + 1);
                start = tend;
                end = tend;
                if (txt.charAt(start) == ' ') {
                    ++start;
                }
                if (txt.charAt(start) == '\n') {
                    ++start;
                }
                if (txt.charAt(start) == '|') {
                    ++start;
                }
                if (txt.charAt(start) == '\\') {
                    ++start;
                }
                t = 0;
            }
            ++end;
        }
        if (end != start) {
            myWrapTxt[myWrapCnt++] = txt.substring(start, end);
        }
        String[] toRet = new String[myWrapCnt];
        for (int i = 0; i < myWrapCnt; ++i) {
            toRet[i] = myWrapTxt[i];
        }
        return toRet;
    }

    public LFont(Image iFont, short[] fontW, int offset) {
        this._offset = offset;
        this._startIdx = 33;
        this._endIdx = this._startIdx + fontW.length;
        this.setImage(iFont, fontW);
    }

    int drawChar(Graphics g, char c, int x, int y, boolean needToPaint) {
        return this.drawChar(g, c, x, y, -1, needToPaint);
    }

    private int GetNewCharIndex(char c) {
        int index = 32;
        switch (c) {
            case '\u00ae': {
                index = 65;
                break;
            }
            case '\u00c4': {
                index = 94;
                break;
            }
            case '\u00dc': {
                index = 95;
                break;
            }
            case '\u00d6': {
                index = 96;
                break;
            }
            case '\u00c0': {
                index = 97;
                break;
            }
            case '\u00cc': {
                index = 98;
                break;
            }
            case '\u00d9': {
                index = 99;
                break;
            }
            case '\u00c9': {
                index = 100;
                break;
            }
            case '\u00c8': {
                index = 101;
                break;
            }
            case '\u00d3': {
                index = 102;
                break;
            }
            case '\u00c1': {
                index = 103;
                break;
            }
            case '\u00da': {
                index = 104;
                break;
            }
            case '\u00fc': {
                index = 105;
                break;
            }
            case '\u00e4': {
                index = 106;
                break;
            }
            case '\u00f6': {
                index = 107;
                break;
            }
            case '\u00e8': {
                index = 108;
                break;
            }
            case '\u00e0': {
                index = 109;
                break;
            }
            case '\u00e9': {
                index = 110;
                break;
            }
            case '\u00ea': {
                index = 111;
                break;
            }
            case '\u00e7': {
                index = 112;
                break;
            }
            case '\u00f4': {
                index = 113;
                break;
            }
            case '\u00fa': {
                index = 114;
                break;
            }
            case '\u00a1': {
                index = 115;
                break;
            }
            case '\u00f3': {
                index = 116;
                break;
            }
            case '\u00e1': {
                index = 117;
                break;
            }
            case '\u00cd': {
                index = 118;
                break;
            }
            case '\u00f1': {
                index = 119;
                break;
            }
            case '\u00a9': {
                index = 64;
                break;
            }
            case '\u00df': {
                index = 121;
                break;
            }
            case '\u00b0': {
                index = 122;
                break;
            }
            case '\u00ba': {
                index = 123;
                break;
            }
            case '\u00bf': {
                index = 124;
                break;
            }
            case '\u201e': {
                index = 125;
                break;
            }
            case '\u00d5': {
                index = 126;
                break;
            }
            case '\u00f5': {
                index = 126;
                break;
            }
            default: {
                index = 32;
            }
        }
        return index;
    }

    int drawChar(Graphics g, char c, int x, int y, int color, boolean needToPaint) {
        int width = 2;
        if (c != ' ') {
            int index = c - this._startIdx;
            if (c > '`' && c < '{') {
                index -= 32;
            }
            if (c > '\u00a0') {
                index = this.GetNewCharIndex(c);
            }
            width = this.getWidth(index);
            if (g != null) {
                if (color != -1) {
                    g.setClip(0, 0, LFont.getWidth(), this.getHeight());
                    g.setColor(color);
                    g.fillRect(x - 1, y - 1, width + 2, this.getHeight() + 2);
                }
                if (width > 0 && needToPaint) {
                    this.paint(g, x, y, index);
                }
            }
        }
        return width;
    }

    int drawString(Graphics g, String ch, int x, int y) {
        return this.drawString(g, ch, x, y, 0, true);
    }

    int drawString(Graphics g, String ch, int x, int y, boolean needToPaint) {
        return this.drawString(g, ch, x, y, 0, needToPaint);
    }

    int drawString(Graphics g, String ch, int x, int y, int align) {
        return this.drawString(g, ch, x, y, align, true);
    }

    int drawString(Graphics g, String ch, int x, int y, int align, boolean needToPaint) {
        this.clipX = g.getClipX();
        this.clipY = g.getClipY();
        this.clipW = g.getClipWidth();
        this.clipH = g.getClipHeight();
        if (ch != null) {
            int len = ch.length();
            switch (align) {
                case 1: {
                    x -= this.stringWidth(ch) >> 1;
                    break;
                }
                case 2: {
                    x -= this.stringWidth(ch);
                }
            }
            for (int k = 0; k < len; ++k) {
                x += this.drawChar(g, ch.charAt(k), x, y, needToPaint) + 1;
            }
        }
        g.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
        return x;
    }

    int charWidth(char c) {
        int width = 2;
        if (c != ' ') {
            int index = c - this._startIdx;
            if (c > '`' && c < '{') {
                index -= 32;
            }
            if (c > '\u00a0') {
                index = this.GetNewCharIndex(c);
            }
            width = this.getWidth(index);
        }
        return width;
    }

    int stringWidth(String ch) {
        int width = 0;
        int len = ch.length();
        if (ch != null) {
            for (int k = 0; k < len; ++k) {
                width += this.charWidth(ch.charAt(k)) + 1;
            }
        }
        return width;
    }

    void setImage(Image image, short[] xWidths) {
        this._image = image;
        this._widths = xWidths;
        this._height = image.getHeight();
        this._xStarts = new short[xWidths.length];
        for (int i = 0; i < xWidths.length - 1; ++i) {
            this._xStarts[i + 1] = (short)(this._xStarts[i] + xWidths[i]);
        }
    }

    int paint(Graphics g, int x, int y, int index) {
        y -= this._offset;
        if (index >= this._widths.length) {
            return 0;
        }
        g.setClip(x, y, (int)this._widths[index], this._height);
        g.drawImage(this._image, x - this._xStarts[index], y, 20);
        return this._widths[index];
    }

    int getWidth(int index) {
        if (index >= this._widths.length || index < 0) {
            return 0;
        }
        return this._widths[index];
    }

    int getHeight() {
        return this._height;
    }
}

