/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameAnimation {
    private static final Random random = new Random();
    public static final int PLAY_ANIMATION_LOOP = 0;
    public static final int PLAY_ANIMATION_ONCE = 1;
    public static final int CLIP_NONE = 0;
    public static final int CLIP_BOUNDING_BOX = 1;
    public static final int CLIP_ALL = 2;
    Image[] animationImage;
    public short[][] animationFrameFileNumber;
    public short[][] animationFramePositionX;
    public short[][] animationFramePositionY;
    public short[] animationFrameLeft;
    public short[] animationFrameRight;
    public short[] animationFrameUp;
    public short[] animationFrameDown;
    public short[][] animationFrameNumber;
    public short[][] animationPositionX;
    public short[][] animationPositionY;
    public short screenWidth;
    public short screenHeight;

    GameAnimation(FootBag midlet, String animationFileNumber, String imagesFileNumber, int _screenWidth, int _screenHeight) {
        this.screenWidth = (short)_screenWidth;
        this.screenHeight = (short)_screenHeight;
        this.animationImage = this.loadImages(midlet, imagesFileNumber);
        this.loadAnimationFile(midlet, animationFileNumber);
        this.setFramesBoundingBox();
    }

    private void setFramesBoundingBox() {
        int _animationFrameNumber = this.animationFrameFileNumber.length;
        this.animationFrameLeft = new short[_animationFrameNumber];
        this.animationFrameRight = new short[_animationFrameNumber];
        this.animationFrameUp = new short[_animationFrameNumber];
        this.animationFrameDown = new short[_animationFrameNumber];
        for (int i = 0; i < _animationFrameNumber; ++i) {
            int _animationFrameParts = this.animationFrameFileNumber[i].length;
            if (_animationFrameParts > 0) {
                this.animationFrameLeft[i] = this.animationFramePositionX[i][0];
                this.animationFrameRight[i] = (short)(this.animationFramePositionX[i][0] + this.animationImage[this.animationFrameFileNumber[i][0]].getWidth());
                this.animationFrameUp[i] = (short)(this.animationFramePositionY[i][0] + this.animationImage[this.animationFrameFileNumber[i][0]].getHeight());
                this.animationFrameDown[i] = this.animationFramePositionY[i][0];
            }
            for (int j = 1; j < _animationFrameParts; ++j) {
                if (this.animationFramePositionX[i][j] < this.animationFrameLeft[i]) {
                    this.animationFrameLeft[i] = this.animationFramePositionX[i][j];
                }
                if (this.animationFramePositionX[i][j] + this.animationImage[this.animationFrameFileNumber[i][j]].getWidth() > this.animationFrameRight[i]) {
                    this.animationFrameRight[i] = (short)(this.animationFramePositionX[i][j] + this.animationImage[this.animationFrameFileNumber[i][j]].getWidth());
                }
                if (this.animationFramePositionY[i][j] + this.animationImage[this.animationFrameFileNumber[i][j]].getHeight() > this.animationFrameUp[i]) {
                    this.animationFrameUp[i] = (short)(this.animationFramePositionY[i][j] + this.animationImage[this.animationFrameFileNumber[i][j]].getHeight());
                }
                if (this.animationFramePositionY[i][j] >= this.animationFrameDown[i]) continue;
                this.animationFrameDown[i] = this.animationFramePositionY[i][j];
            }
        }
    }

    private void loadAnimationFile(FootBag midlet, String name) {
        block18: {
            boolean _afpX = false;
            boolean _afpY = false;
            boolean _apX = false;
            boolean _apY = false;
            InputStream is = null;
            DataInputStream dis = null;
            try {
                byte _tempByte2;
                byte _tempByte1;
                byte _tempByte0;
                is = ((Object)((Object)midlet)).getClass().getResourceAsStream(name);
                dis = new DataInputStream(is);
                int _animationFrameNumber = dis.readShort();
                int _animationNumber = dis.readShort();
                byte _animationFileType = dis.readByte();
                if (_animationFileType == 3) {
                    byte _tempType3Setup = dis.readByte();
                    _afpX = (_tempType3Setup & 1) == 1;
                    _afpY = (_tempType3Setup >> 1 & 1) == 1;
                    _apX = (_tempType3Setup >> 2 & 1) == 1;
                    _apY = (_tempType3Setup >> 3 & 1) == 1;
                }
                this.animationFrameFileNumber = new short[_animationFrameNumber][];
                this.animationFramePositionX = new short[_animationFrameNumber][];
                this.animationFramePositionY = new short[_animationFrameNumber][];
                this.animationFrameNumber = new short[_animationNumber][];
                this.animationPositionX = new short[_animationNumber][];
                this.animationPositionY = new short[_animationNumber][];
                for (int i = 0; i < _animationFrameNumber; ++i) {
                    int _animationFrameParts = dis.readUnsignedByte();
                    this.animationFrameFileNumber[i] = new short[_animationFrameParts];
                    this.animationFramePositionX[i] = new short[_animationFrameParts];
                    this.animationFramePositionY[i] = new short[_animationFrameParts];
                    for (int j = 0; j < _animationFrameParts; ++j) {
                        this.animationFrameFileNumber[i][j] = (short)dis.readUnsignedByte();
                        if (_animationFileType == 1) {
                            this.animationFramePositionX[i][j] = dis.readByte();
                            this.animationFramePositionY[i][j] = dis.readByte();
                            continue;
                        }
                        if (_animationFileType == 2) {
                            this.animationFramePositionX[i][j] = dis.readShort();
                            this.animationFramePositionY[i][j] = dis.readShort();
                            continue;
                        }
                        if (_animationFileType == 3) {
                            this.animationFramePositionX[i][j] = _afpX ? dis.readShort() : (short)dis.readByte();
                            this.animationFramePositionY[i][j] = _afpY ? dis.readShort() : (short)dis.readByte();
                            continue;
                        }
                        if (_animationFileType != 4) continue;
                        _tempByte0 = dis.readByte();
                        _tempByte1 = dis.readByte();
                        _tempByte2 = dis.readByte();
                        this.animationFramePositionX[i][j] = (short)((_tempByte0 >> 4 & 0xF) << 8 | _tempByte1);
                        this.animationFramePositionX[i][j] = this.animationFramePositionX[i][j] > 2048 ? (short)(this.animationFramePositionX[i][j] - 4096) : this.animationFramePositionX[i][j];
                        this.animationFramePositionY[i][j] = (short)((_tempByte0 & 0xF) << 8 | _tempByte2);
                        this.animationFramePositionY[i][j] = this.animationFramePositionY[i][j] > 2048 ? (short)(this.animationFramePositionY[i][j] - 4096) : this.animationFramePositionY[i][j];
                    }
                }
                for (int i = 0; i < _animationNumber; ++i) {
                    int _animationLength = dis.readUnsignedByte();
                    this.animationFrameNumber[i] = new short[_animationLength];
                    this.animationPositionX[i] = new short[_animationLength];
                    this.animationPositionY[i] = new short[_animationLength];
                    for (int j = 0; j < _animationLength; ++j) {
                        this.animationFrameNumber[i][j] = dis.readShort();
                        if (_animationFileType == 1) {
                            this.animationPositionX[i][j] = dis.readByte();
                            this.animationPositionY[i][j] = dis.readByte();
                            continue;
                        }
                        if (_animationFileType == 2) {
                            this.animationPositionX[i][j] = dis.readShort();
                            this.animationPositionY[i][j] = dis.readShort();
                            continue;
                        }
                        if (_animationFileType == 3) {
                            this.animationPositionX[i][j] = _apX ? dis.readShort() : (short)dis.readByte();
                            this.animationPositionY[i][j] = _apY ? dis.readShort() : (short)dis.readByte();
                            continue;
                        }
                        if (_animationFileType != 4) continue;
                        _tempByte0 = dis.readByte();
                        _tempByte1 = dis.readByte();
                        _tempByte2 = dis.readByte();
                        this.animationPositionX[i][j] = (short)((_tempByte0 >> 4 & 0xF) << 8 | _tempByte1);
                        this.animationPositionX[i][j] = this.animationPositionX[i][j] > 2048 ? (short)(this.animationPositionX[i][j] - 4096) : this.animationPositionX[i][j];
                        this.animationPositionY[i][j] = (short)((_tempByte0 & 0xF) << 8 | _tempByte2);
                        this.animationPositionY[i][j] = this.animationPositionY[i][j] > 2048 ? (short)(this.animationPositionY[i][j] - 4096) : this.animationPositionY[i][j];
                    }
                }
                dis.close();
                dis = null;
                is = null;
            }
            catch (Exception e) {
                System.out.println("loadAnimationFile Exception: B\u0142\u0105d pliku o nazwie:  " + name);
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception ed) {
                        // empty catch block
                    }
                    is = null;
                }
                if (dis == null) break block18;
                try {
                    dis.close();
                }
                catch (Exception ed) {
                    // empty catch block
                }
                dis = null;
            }
        }
    }

    private Image[] loadImages(FootBag midlet, String name) {
        Image[] images;
        block18: {
            InputStream is = null;
            DataInputStream dis = null;
            images = null;
            try {
                is = ((Object)((Object)midlet)).getClass().getResourceAsStream(name);
                dis = new DataInputStream(is);
                dis.readByte();
                dis.readByte();
                dis.readByte();
                int count = 0;
                int imagesNumber = 0;
                byte _imageFlag = 0;
                imagesNumber = dis.readUnsignedByte();
                images = new Image[imagesNumber];
                for (int imageCount = 0; imageCount < imagesNumber; ++imageCount) {
                    _imageFlag = dis.readByte();
                    if ((_imageFlag >> 7 & 1) == 1) {
                        count = dis.readShort();
                        if (count > 0) {
                            byte[] temp = new byte[count];
                            for (int k = 0; k < count; ++k) {
                                temp[k] = dis.readByte();
                            }
                            images[imageCount] = Image.createImage((byte[])temp, (int)0, (int)temp.length);
                        } else {
                            images[imageCount] = null;
                        }
                        midlet.mainCanvas.tickProgressBar(imageCount, imagesNumber, 12);
                        continue;
                    }
                    int _parentImage = dis.readUnsignedByte();
                    int _transformation = _imageFlag & 7;
                    if (_transformation == 1) {
                        _transformation = 5;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation == 2) {
                        _transformation = 3;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation == 3) {
                        _transformation = 6;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation == 4) {
                        _transformation = 2;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation == 5) {
                        _transformation = 5;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        _transformation = 2;
                        images[imageCount] = Image.createImage((Image)images[imageCount], (int)0, (int)0, (int)images[imageCount].getWidth(), (int)images[imageCount].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation == 6) {
                        _transformation = 3;
                        images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                        _transformation = 2;
                        images[imageCount] = Image.createImage((Image)images[imageCount], (int)0, (int)0, (int)images[imageCount].getWidth(), (int)images[imageCount].getHeight(), (int)_transformation);
                        continue;
                    }
                    if (_transformation != 7) continue;
                    _transformation = 6;
                    images[imageCount] = Image.createImage((Image)images[_parentImage], (int)0, (int)0, (int)images[_parentImage].getWidth(), (int)images[_parentImage].getHeight(), (int)_transformation);
                    _transformation = 2;
                    images[imageCount] = Image.createImage((Image)images[imageCount], (int)0, (int)0, (int)images[imageCount].getWidth(), (int)images[imageCount].getHeight(), (int)_transformation);
                }
                dis.close();
                dis = null;
                is = null;
            }
            catch (Exception e) {
                System.out.println("loadImages Exception: B\u0142\u0105d pliku o nazwie:  " + name);
                images = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception ed) {
                        // empty catch block
                    }
                    is = null;
                }
                if (dis == null) break block18;
                try {
                    dis.close();
                }
                catch (Exception ed) {
                    // empty catch block
                }
                dis = null;
            }
        }
        return images;
    }

    public byte playAnimation(int _animationNumber, int _animationFrameNumber, int _animationPlayType) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        ++_animationFrameNumber;
        if (_animationPlayType == 0) {
            if (_animationFrameNumber >= this.animationFrameNumber[_animationNumber].length) {
                _animationFrameNumber %= this.animationFrameNumber[_animationNumber].length;
            }
        } else if (_animationPlayType == 1 && _animationFrameNumber >= this.animationFrameNumber[_animationNumber].length) {
            _animationFrameNumber = this.animationFrameNumber[_animationNumber].length - 1;
        }
        return (byte)_animationFrameNumber;
    }

    public byte moveAnimationX(int _animationNumber) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        int animationLength = this.animationPositionX[_animationNumber].length - 1;
        return (byte)(this.animationPositionX[_animationNumber][animationLength] - this.animationPositionX[_animationNumber][0]);
    }

    public byte moveAnimationY(int _animationNumber) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        int animationLength = this.animationPositionY[_animationNumber].length - 1;
        return (byte)(this.animationPositionY[_animationNumber][animationLength] - this.animationPositionY[_animationNumber][0]);
    }

    public void paintAnimation(int _animationNumber, int _animationFrameNumber, int _positionX, int _positionY, int _clippingType, Graphics _g) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        if (_animationFrameNumber >= this.animationFrameNumber[_animationNumber].length) {
            _animationFrameNumber = this.animationFrameNumber[_animationNumber].length - 1;
        }
        short _animationFrame = this.animationFrameNumber[_animationNumber][_animationFrameNumber];
        short _animationPositionX = this.animationPositionX[_animationNumber][_animationFrameNumber];
        short _animationPositionY = this.animationPositionY[_animationNumber][_animationFrameNumber];
        if (!(_clippingType != 1 && _clippingType != 2 || _positionX + _animationPositionX + (this.animationFrameLeft[_animationFrame] - this.screenWidth) <= 0 && _positionX + _animationPositionX + this.animationFrameRight[_animationFrame] >= 0 && _positionY + _animationPositionY + (this.animationFrameDown[_animationFrame] - this.screenHeight) <= 0 && _positionY + _animationPositionY + this.animationFrameUp[_animationFrame] >= 0)) {
            return;
        }
        int _animationFrameParts = this.animationFrameFileNumber[_animationFrame].length;
        for (int i = 0; i < _animationFrameParts; ++i) {
            short _animationFrameFileNumber = this.animationFrameFileNumber[_animationFrame][i];
            short _animationFramePositionX = this.animationFramePositionX[_animationFrame][i];
            short _animationFramePositionY = this.animationFramePositionY[_animationFrame][i];
            if (_clippingType == 2 && (_positionX + _animationFramePositionX + _animationPositionX + (0 - this.screenWidth) > 0 || _positionX + _animationFramePositionX + _animationPositionX + this.animationImage[_animationFrameFileNumber].getWidth() < 0 || _positionY + _animationFramePositionY + _animationPositionY + (0 - this.screenHeight) > 0 || _positionY + _animationFramePositionY + _animationPositionY + this.animationImage[_animationFrameFileNumber].getHeight() < 0)) continue;
            _g.drawImage(this.animationImage[_animationFrameFileNumber], _positionX + _animationFramePositionX + _animationPositionX, _positionY + _animationFramePositionY + _animationPositionY, 0);
        }
    }
}

