/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class WordWrap {
    public static String error = "ok\n";
    public static String[] errorMsg = null;

    public static void drawError(Graphics g, int width) {
        int clipOldX = g.getClipX();
        int clipOldY = g.getClipY();
        int clipOldDX = g.getClipWidth();
        int clipOldDY = g.getClipHeight();
        Font f = g.getFont();
        int yoffset = 0;
        int yspacing = f.getHeight();
        int line = 0;
        if (errorMsg == null) {
            errorMsg = WordWrap.WrapString(width, error, f);
        }
        g.setColor(0);
        g.setClip(0, yoffset, width, yoffset + yspacing * errorMsg.length);
        g.fillRect(0, yoffset, width, yoffset + yspacing * errorMsg.length);
        g.setColor(0xFF6600);
        for (int i = 0; i < errorMsg.length; ++i) {
            g.drawString("" + errorMsg[i], 0, yoffset + yspacing * line++, 20);
        }
        g.setClip(clipOldX, clipOldY, clipOldDX, clipOldDY);
    }

    public static void setError(String str) {
        if (str == null) {
            str = "";
        }
        error = str;
        errorMsg = null;
    }

    public static void appendError(String str) {
        if (str == null) {
            str = "";
        }
        error = error + str;
        errorMsg = null;
    }

    private static Vector Tokenize(String InputString) {
        InputString = InputString.trim();
        Vector<String> Output = new Vector<String>();
        int CurrentWordStart = 0;
        for (int i = 0; i < InputString.length(); ++i) {
            if (InputString.charAt(i) != ' ' && InputString.charAt(i) != '\n') continue;
            Output.addElement(InputString.substring(CurrentWordStart, i + 1));
            CurrentWordStart = i + 1;
        }
        Output.addElement(InputString.substring(CurrentWordStart, InputString.length()));
        return Output;
    }

    private static Vector WrapWord(int WrapWidth, String InputString, Font font) {
        Vector<String> Output = new Vector<String>();
        int CurrentWordStart = 0;
        for (int i = 0; i < InputString.length(); ++i) {
            String StrToCheck = InputString.substring(CurrentWordStart, i);
            int StrToCheckWidth = font.stringWidth(StrToCheck);
            if (StrToCheckWidth <= WrapWidth) continue;
            Output.addElement(InputString.substring(CurrentWordStart, i - 1));
            CurrentWordStart = i - 1;
        }
        Output.addElement(InputString.substring(CurrentWordStart, InputString.length()));
        return Output;
    }

    public static String[] WrapString(int WrapWidth, String InputString, Font font) {
        int i;
        Vector TStringVector = WordWrap.Tokenize(InputString);
        Vector<String> Output = new Vector<String>();
        int CurWord = 0;
        boolean CurLineStart = false;
        String LineToCheck = "";
        String wordToAdd = "";
        int NumOfWordsInCurrentLine = 0;
        for (CurWord = 0; CurWord < TStringVector.size(); ++CurWord) {
            wordToAdd = (String)TStringVector.elementAt(CurWord);
            int LineToCheckWidth = font.stringWidth(LineToCheck + wordToAdd);
            if (LineToCheckWidth > WrapWidth) {
                if (NumOfWordsInCurrentLine == 0) {
                    Vector WordWrapOut = WordWrap.WrapWord(WrapWidth, LineToCheck + wordToAdd, font);
                    for (i = 0; i < WordWrapOut.size() - 1; ++i) {
                        Output.addElement(((String)WordWrapOut.elementAt(i)).trim());
                    }
                    LineToCheck = (String)WordWrapOut.elementAt(WordWrapOut.size() - 1);
                    NumOfWordsInCurrentLine = 1;
                    continue;
                }
                LineToCheck.trim();
                Output.addElement(LineToCheck.trim());
                LineToCheck = "";
                NumOfWordsInCurrentLine = 0;
                --CurWord;
                continue;
            }
            LineToCheck = LineToCheck + wordToAdd;
            ++NumOfWordsInCurrentLine;
            if (wordToAdd.charAt(wordToAdd.length() - 1) != '\n') continue;
            Output.addElement(LineToCheck.substring(0, LineToCheck.length() - 1).trim());
            LineToCheck = "";
            NumOfWordsInCurrentLine = 0;
        }
        Output.addElement(LineToCheck.trim());
        String[] OutputStringArray = new String[Output.size()];
        for (i = 0; i < Output.size(); ++i) {
            OutputStringArray[i] = (String)Output.elementAt(i);
        }
        return OutputStringArray;
    }

    private WordWrap() {
    }
}

