/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DeviceImage {
    private Image image;
    private int[] pixels;
    public short width;
    public short height;
    private int clip_x;
    private int clip_y;
    public static final int FLIP_HORIZONTAL = 0;
    static final int CF = 0;
    static final int ROT270 = 6;
    static final int ROT180 = 3;
    static final int ROT90 = 5;
    static final int[] ppg_frames = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 6, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 6, 3, 5, 6, 3, 5, 6, 3, 5, 6, 3, 5, 6, 3, 5, 6, 3, 5, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] ppg_frames_manipulation = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 9, 2, 3, 4, 5, 6, 7, 8, 0, 0, 1, 2, 3, 5, 6, 7, 8, 9, 9, 1, 2, 3, 4, 5, 6, 7, 10, 11, 12, 13, 14, 15, 16, 17, 11, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, 16, 16, 16, 18, 19, 20, 21, 22, 23, 24, 25};
    static final int PPG_TOTAL_FRAMES = 26;
    static DeviceImage[] ppg_graphics_frames = new DeviceImage[26];
    private int manipulation = 0;
    static int ppg_width = 0;
    static int ppg_height = 0;

    public DeviceImage(String string) {
        if (this.image == null) {
            byte[] byArray = Engine.getResource(string);
            try {
                this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            }
            catch (Exception exception) {
                return;
            }
        }
        this.width = (short)this.image.getWidth();
        this.height = (short)this.image.getHeight();
    }

    public DeviceImage(byte[] byArray, String string) {
        if (this.image == null) {
            try {
                this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            }
            catch (Exception exception) {
                return;
            }
        }
        this.width = (short)this.image.getWidth();
        this.height = (short)this.image.getHeight();
    }

    public DeviceImage(DeviceImage deviceImage, int n) {
        this.width = deviceImage.width;
        this.height = deviceImage.height;
    }

    public DeviceImage(String string, int n, int n2, int n3) {
        DeviceImage deviceImage = new DeviceImage(string);
        int n4 = deviceImage.width / n;
        this.width = (short)n;
        this.height = (short)n2;
        int n5 = n3 % n4;
        int n6 = n3 / n4;
        this.image = Image.createImage((int)n, (int)n2);
        this.image.getGraphics().drawImage(deviceImage.image, -(n5 * n), -(n6 * n2), 20);
    }

    public DeviceImage(DeviceImage deviceImage, int n, int n2, int n3, int n4) {
        this.width = (short)n3;
        this.height = (short)n4;
        this.image = deviceImage.image;
        this.clip_x = n * n3;
        this.clip_y = n2 * n4;
    }

    public DeviceImage[] divide(int n) {
        int n2 = this.width / n;
        short s = this.height;
        return this.divide(n2, s);
    }

    public DeviceImage[] divide(int n, int n2) {
        int n3 = this.width / n;
        int n4 = this.height / n2;
        DeviceImage[] deviceImageArray = new DeviceImage[n4 * n3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                deviceImageArray[n5++] = new DeviceImage(this, j, i, n, n2);
            }
        }
        return deviceImageArray;
    }

    public void drawImageNoClipping(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n, n2, 20);
    }

    public static DeviceImage[] loadPPGGraphicsWithFlipping(int n) {
        int n2;
        DeviceImage[] deviceImageArray = new DeviceImage[ppg_frames.length];
        for (n2 = 0; n2 < 26; ++n2) {
            String string = "";
            if (n2 < 10) {
                string = string + "0";
            }
            DeviceImage.ppg_graphics_frames[n2] = new DeviceImage("ppg_" + n + "_" + string + n2 + ".png");
        }
        ppg_width = DeviceImage.ppg_graphics_frames[0].width;
        ppg_height = DeviceImage.ppg_graphics_frames[0].height;
        Engine.debug("after loading ppg gfx");
        for (n2 = 0; n2 < ppg_frames.length; ++n2) {
            deviceImageArray[n2] = new DeviceImage(ppg_graphics_frames[ppg_frames_manipulation[n2]]);
            deviceImageArray[n2].manipulation = ppg_frames[n2];
        }
        return deviceImageArray;
    }

    public DeviceImage(DeviceImage deviceImage) {
        this.image = deviceImage.image;
        this.width = deviceImage.width;
        this.height = deviceImage.height;
    }

    public void drawImage(Graphics graphics, int n, int n2) {
        if (this.width == ppg_width && this.height == ppg_height) {
            graphics.setClip(n, n2, (int)this.width, (int)this.height);
            graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.width, (int)this.height, this.manipulation, n, n2, 20);
        } else {
            if (n < -this.width) {
                return;
            }
            if (n > 240) {
                return;
            }
            int n3 = this.width;
            int n4 = this.height;
            if (n + this.width > 240) {
                n3 = 240 - n;
            }
            if (n2 + this.height > 320) {
                n4 = 320 - n2;
            }
            graphics.setClip(n, n2, n3, n4);
            graphics.drawImage(this.image, n - this.clip_x, n2 - this.clip_y, 20);
        }
    }
}

