/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class XMLParser {
    XMLScanner scanner;
    String rootElemName;

    public XMLParser(String string, String string2) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            this.scanner = new XMLScanner(new InputStreamReader(inputStream, string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XMLException("Unsupported encoding " + string2);
        }
    }

    public XMLParser(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        this.scanner = new XMLScanner(new InputStreamReader(inputStream));
    }

    public XMLParser(Reader reader) {
        this.scanner = new XMLScanner(reader);
    }

    private final void throwException(String string) {
        throw new XMLException(this.scanner.getLine(), this.scanner.getColumn(), string);
    }

    private final XMLElement readElement(String string) {
        XMLElement xMLElement = new XMLElement(string);
        block5: while (true) {
            switch (this.scanner.scan()) {
                case 5: {
                    return xMLElement;
                }
                case 3: {
                    int n;
                    while ((n = this.scanner.scan()) == 2) {
                        if (this.scanner.scan() != 0) {
                            this.throwException("Element name expected");
                        }
                        String string2 = this.scanner.getIdentifier();
                        XMLElement xMLElement2 = this.readElement(string2);
                        xMLElement.addItem(xMLElement2);
                    }
                    if (n == 1) {
                        xMLElement.setValue(this.scanner.getValue());
                        n = this.scanner.scan();
                    }
                    if (n != 4 || this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals(string) || this.scanner.scan() != 3) {
                        this.throwException("Element is not closed");
                    }
                    return xMLElement;
                }
                case 0: {
                    String string3 = this.scanner.getIdentifier();
                    if (this.scanner.scan() != 6 || this.scanner.scan() != 1) {
                        this.throwException("Attribute value expected");
                    }
                    xMLElement.addAttribute(string3, this.scanner.getValue());
                    continue block5;
                }
            }
            this.throwException("Unexpected token");
        }
    }

    public Enumeration enumerateRootItems(String string) {
        int n;
        if (this.scanner.scan() != 2 || this.scanner.scan() != 0 || !this.scanner.getIdentifier().equals(string)) {
            this.throwException("No root element");
        }
        while ((n = this.scanner.scan()) != 3) {
            if (n != 7) continue;
            this.throwException("No root element");
        }
        return new XMLEnumeration(string);
    }

    public XMLElement getRoot() {
        if (this.scanner.scan() != 2 || this.scanner.scan() != 0) {
            this.throwException("No root element");
        }
        String string = this.scanner.getIdentifier();
        return this.readElement(string);
    }

    class XMLEnumeration
    implements Enumeration {
        XMLElement curr;
        String rootElemName;

        XMLEnumeration(String string) {
            this.rootElemName = string;
        }

        public boolean hasMoreElements() {
            if (this.curr != null) {
                return true;
            }
            int n = XMLParser.this.scanner.scan();
            if (n == 2) {
                if (XMLParser.this.scanner.scan() != 0) {
                    XMLParser.this.throwException("Element name expected");
                }
                String string = XMLParser.this.scanner.getIdentifier();
                this.curr = XMLParser.this.readElement(string);
                return true;
            }
            if (n != 4 || XMLParser.this.scanner.scan() != 0 || !XMLParser.this.scanner.getIdentifier().equals(this.rootElemName) || XMLParser.this.scanner.scan() != 3) {
                XMLParser.this.throwException("Root element is not closed");
            }
            return false;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            XMLElement xMLElement = this.curr;
            this.curr = null;
            return xMLElement;
        }
    }
}

