/*
 * Decompiled with CFR 0.152.
 */
class GS60_BitStreamReader {
    public byte[] data = null;
    public int byte_offset = 0;
    private int bit_offset = 0;

    public void Init(byte[] byArray) {
        this.data = byArray;
        this.bit_offset = 0;
        this.byte_offset = 0;
    }

    public void Init(GS60_BitStreamReader gS60_BitStreamReader) {
        this.data = gS60_BitStreamReader.data;
        this.byte_offset = gS60_BitStreamReader.byte_offset;
        this.bit_offset = gS60_BitStreamReader.bit_offset;
    }

    public static int Utility_BitsReqdToRepresentIntRange(int n) {
        int n2 = 1;
        while (1 << n2 < n) {
            ++n2;
        }
        return n2;
    }

    public int GetOffset() {
        return (this.byte_offset << 3) + this.bit_offset;
    }

    public void SetOffset(int n) {
        this.byte_offset = n >> 3;
        this.bit_offset = n & 7;
    }

    public boolean IsOnByteBoundary() {
        return this.bit_offset == 0;
    }

    public void SyncToByteBoundary() {
        if (this.bit_offset != 0) {
            ++this.byte_offset;
            this.bit_offset = 0;
        }
    }

    public byte ReadAlignedByte() {
        return this.data[this.byte_offset++];
    }

    public void Skip(int n) {
        this.bit_offset += n;
        this.byte_offset += this.bit_offset >> 3;
        this.bit_offset &= 7;
    }

    public int Read(int n) {
        int n2;
        if (8 - this.bit_offset >= n) {
            n2 = this.data[this.byte_offset] >> 8 - this.bit_offset - n & (1 << n) - 1;
            this.bit_offset += n;
            if (this.bit_offset == 8) {
                ++this.byte_offset;
                this.bit_offset = 0;
            }
        } else {
            n2 = this.data[this.byte_offset] & (1 << 8 - this.bit_offset) - 1;
            n -= 8 - this.bit_offset;
            ++this.byte_offset;
            while (n > 7) {
                n2 = (n2 << 8) + (this.data[this.byte_offset] & 0xFF);
                ++this.byte_offset;
                n -= 8;
            }
            if (n > 0) {
                n2 = (n2 << n) + (this.data[this.byte_offset] >> 8 - n & (1 << n) - 1);
            }
            this.bit_offset = n;
        }
        return n2;
    }

    public int ReadSigned(int n) {
        int n2 = this.Read(n);
        if ((n2 & 1 << n - 1) != 0) {
            n2 |= -1 << n;
        }
        return n2;
    }
}

