/*
 * Decompiled with CFR 0.152.
 */
class PROJ_Score {
    private gs60cpd applet;
    private PROJ_Canvas_Game proj_canvas;
    public StringBuffer last_shot_description = new StringBuffer(63);
    public int game_type = 0;
    public int turn;
    public int first_non_eliminated_player;
    public int num_players;
    public int darts_thrown;
    public boolean determining_who_goes_first;
    public int score_at_start_of_round;
    public int round_number;
    public int winner;
    public int[] player_order = new int[4];
    public int[] score = new int[4];
    public int[] total_num_of_darts_thrown = new int[4];
    public int[] score_for_high_score_purposes = new int[4];
    public boolean[] still_active = new boolean[4];
    public int[] elimination_round = new int[4];
    public int[] dist_to_center = new int[4];
    public short[][] score_history = new short[4][25];
    public int game_301__starting_points;
    public int golf__num_holes;
    public int[][] cricket__closures_remaining = new int[4][7];
    public int target_practice__rng;
    public int target_practice__rng_save;
    public int target_practice__target_x;
    public int target_practice__target_y;
    public int target_practice__next_x;
    public int target_practice__next_y;
    public boolean target_practice__last_shot_hit;
    public boolean target_practice__show_hit_or_miss_target;
    public long timed_game__time_remaining;
    public int ai_shot__aim_x;
    public int ai_shot__aim_y;
    public int[] desired_scores_301 = new int[20];
    private int[] layout__name_x = new int[4];
    private int[] layout__name_y = new int[4];
    private int layout__font_h;
    private int layout__v_stride__line;
    private int layout__v_stride__no_line;
    private int layout__score_cell_w;
    private int layout__num_scores;
    private int layout__num_scores_to_show;
    private int layout__baseball__name_field_w;
    private int layout__baseball__total_field_w;
    private int layout__widest_2_number_w;
    public int chalkboard_fg_color;
    public int chalkboard_bg_color;

    public void OneTimeInit(gs60cpd gs60cpd2, PROJ_Canvas_Game pROJ_Canvas_Game) {
        this.applet = gs60cpd2;
        this.proj_canvas = pROJ_Canvas_Game;
        this.desired_scores_301[0] = 32;
        this.desired_scores_301[1] = 16;
        this.desired_scores_301[2] = 8;
        this.desired_scores_301[3] = 40;
        this.desired_scores_301[4] = 24;
        this.desired_scores_301[5] = 36;
        this.desired_scores_301[6] = 28;
        this.desired_scores_301[7] = 20;
        this.desired_scores_301[8] = 12;
        this.desired_scores_301[9] = 4;
        this.desired_scores_301[10] = 38;
        this.desired_scores_301[11] = 34;
        this.desired_scores_301[12] = 30;
        this.desired_scores_301[13] = 26;
        this.desired_scores_301[14] = 22;
        this.desired_scores_301[15] = 18;
        this.desired_scores_301[16] = 14;
        this.desired_scores_301[17] = 10;
        this.desired_scores_301[18] = 6;
        this.desired_scores_301[19] = 2;
    }

    public int ExtractSaveData(byte[] byArray, int n) {
        this.last_shot_description.setLength(0);
        for (int i = 0; i < 63; ++i) {
            char c = (char)(byArray[n++] & 0xFF);
            if ((c = (char)(c + (char)(byArray[n++] << 8))) == '\u0000') continue;
            this.last_shot_description.append(c);
        }
        this.game_type = byArray[n++];
        this.turn = byArray[n++];
        this.first_non_eliminated_player = byArray[n++];
        this.num_players = byArray[n++];
        this.darts_thrown = byArray[n++];
        this.determining_who_goes_first = byArray[n++] != 0;
        this.score_at_start_of_round = byArray[n++] & 0xFF;
        this.score_at_start_of_round += (byte)(byArray[n++] & 0xFF) << 8;
        this.round_number = byArray[n++] & 0xFF;
        this.round_number += (byte)(byArray[n++] & 0xFF) << 8;
        this.winner = byArray[n++];
        for (int i = 0; i < 2; ++i) {
            int n2;
            this.score[i] = byArray[n++] & 0xFF;
            int n3 = i;
            this.score[n3] = this.score[n3] + ((byte)(byArray[n++] & 0xFF) << 8);
            this.score_for_high_score_purposes[i] = byArray[n++] & 0xFF;
            int n4 = i;
            this.score_for_high_score_purposes[n4] = this.score_for_high_score_purposes[n4] + ((byte)(byArray[n++] & 0xFF) << 8);
            this.still_active[i] = byArray[n++] != 0;
            this.elimination_round[i] = byArray[n++] & 0xFF;
            int n5 = i;
            this.elimination_round[n5] = this.elimination_round[n5] + ((byte)(byArray[n++] & 0xFF) << 8);
            this.dist_to_center[i] = byArray[n++] & 0xFF;
            int n6 = i;
            this.dist_to_center[n6] = this.dist_to_center[n6] + ((byArray[n++] & 0xFF) << 8);
            int n7 = i;
            this.dist_to_center[n7] = this.dist_to_center[n7] + ((byArray[n++] & 0xFF) << 16);
            int n8 = i;
            this.dist_to_center[n8] = this.dist_to_center[n8] + (byArray[n++] << 24);
            this.player_order[i] = byArray[n++];
            for (n2 = 0; n2 < 7; ++n2) {
                this.cricket__closures_remaining[i][n2] = byArray[n++];
            }
            n2 = 0;
            while (n2 < 25) {
                this.score_history[i][n2] = (short)(byArray[n++] & 0xFF);
                short[] sArray = this.score_history[i];
                int n9 = n2++;
                sArray[n9] = (short)(sArray[n9] + ((short)((byte)(byArray[n++] & 0xFF)) << 8));
            }
        }
        this.game_301__starting_points = byArray[n++] & 0xFF;
        this.game_301__starting_points += (byte)(byArray[n++] & 0xFF) << 8;
        this.golf__num_holes = byArray[n++];
        this.ai_shot__aim_x = byArray[n++] & 0xFF;
        this.ai_shot__aim_x += (byArray[n++] & 0xFF) << 8;
        this.ai_shot__aim_x += (byArray[n++] & 0xFF) << 16;
        this.ai_shot__aim_x += byArray[n++] << 24;
        this.ai_shot__aim_y = byArray[n++] & 0xFF;
        this.ai_shot__aim_y += (byArray[n++] & 0xFF) << 8;
        this.ai_shot__aim_y += (byArray[n++] & 0xFF) << 16;
        this.ai_shot__aim_y += byArray[n++] << 24;
        this.timed_game__time_remaining = byArray[n++] & 0xFF;
        this.timed_game__time_remaining += (long)((byArray[n++] & 0xFF) << 8);
        this.timed_game__time_remaining += (long)((byArray[n++] & 0xFF) << 16);
        this.timed_game__time_remaining += (long)(byArray[n++] << 24);
        this.target_practice__rng = byArray[n++] & 0xFF;
        this.target_practice__rng += (byArray[n++] & 0xFF) << 8;
        this.target_practice__rng += (byArray[n++] & 0xFF) << 16;
        this.target_practice__rng += byArray[n++] << 24;
        this.target_practice__rng_save = byArray[n++] & 0xFF;
        this.target_practice__rng_save += (byArray[n++] & 0xFF) << 8;
        this.target_practice__rng_save += (byArray[n++] & 0xFF) << 16;
        this.target_practice__rng_save += byArray[n++] << 24;
        this.target_practice__target_x = byArray[n++] & 0xFF;
        this.target_practice__target_x += (byArray[n++] & 0xFF) << 8;
        this.target_practice__target_x += (byArray[n++] & 0xFF) << 16;
        this.target_practice__target_x += byArray[n++] << 24;
        this.target_practice__target_y = byArray[n++] & 0xFF;
        this.target_practice__target_y += (byArray[n++] & 0xFF) << 8;
        this.target_practice__target_y += (byArray[n++] & 0xFF) << 16;
        this.target_practice__target_y += byArray[n++] << 24;
        this.target_practice__next_x = byArray[n++] & 0xFF;
        this.target_practice__next_x += (byArray[n++] & 0xFF) << 8;
        this.target_practice__next_x += (byArray[n++] & 0xFF) << 16;
        this.target_practice__next_x += byArray[n++] << 24;
        this.target_practice__next_y = byArray[n++] & 0xFF;
        this.target_practice__next_y += (byArray[n++] & 0xFF) << 8;
        this.target_practice__next_y += (byArray[n++] & 0xFF) << 16;
        this.target_practice__next_y += byArray[n++] << 24;
        this.target_practice__last_shot_hit = byArray[n++] != 0;
        this.target_practice__show_hit_or_miss_target = byArray[n++] != 0;
        return n;
    }

    public int PackSaveData(byte[] byArray, int n) {
        for (int i = 0; i < 63; ++i) {
            char c = '\u0000';
            if (i < this.last_shot_description.length()) {
                c = this.last_shot_description.charAt(i);
            }
            byArray[n++] = (byte)c;
            byArray[n++] = (byte)(c >> 8);
        }
        byArray[n++] = (byte)this.game_type;
        byArray[n++] = (byte)this.turn;
        byArray[n++] = (byte)this.first_non_eliminated_player;
        byArray[n++] = (byte)this.num_players;
        byArray[n++] = (byte)this.darts_thrown;
        byArray[n++] = (byte)(this.determining_who_goes_first ? 1 : 0);
        byArray[n++] = (byte)this.score_at_start_of_round;
        byArray[n++] = (byte)(this.score_at_start_of_round >> 8);
        byArray[n++] = (byte)this.round_number;
        byArray[n++] = (byte)(this.round_number >> 8);
        byArray[n++] = (byte)this.winner;
        for (int i = 0; i < 2; ++i) {
            int n2;
            byArray[n++] = (byte)this.score[i];
            byArray[n++] = (byte)(this.score[i] >> 8);
            byArray[n++] = (byte)this.score_for_high_score_purposes[i];
            byArray[n++] = (byte)(this.score_for_high_score_purposes[i] >> 8);
            byArray[n++] = (byte)(this.still_active[i] ? 1 : 0);
            byArray[n++] = (byte)this.elimination_round[i];
            byArray[n++] = (byte)(this.elimination_round[i] >> 8);
            byArray[n++] = (byte)this.dist_to_center[i];
            byArray[n++] = (byte)(this.dist_to_center[i] >> 8);
            byArray[n++] = (byte)(this.dist_to_center[i] >> 16);
            byArray[n++] = (byte)(this.dist_to_center[i] >> 24);
            byArray[n++] = (byte)this.player_order[i];
            for (n2 = 0; n2 < 7; ++n2) {
                byArray[n++] = (byte)this.cricket__closures_remaining[i][n2];
            }
            for (n2 = 0; n2 < 25; ++n2) {
                byArray[n++] = (byte)this.score_history[i][n2];
                byArray[n++] = (byte)(this.score_history[i][n2] >> 8);
            }
        }
        byArray[n++] = (byte)this.game_301__starting_points;
        byArray[n++] = (byte)(this.game_301__starting_points >> 8);
        byArray[n++] = (byte)this.golf__num_holes;
        byArray[n++] = (byte)this.ai_shot__aim_x;
        byArray[n++] = (byte)(this.ai_shot__aim_x >> 8);
        byArray[n++] = (byte)(this.ai_shot__aim_x >> 16);
        byArray[n++] = (byte)(this.ai_shot__aim_x >> 24);
        byArray[n++] = (byte)this.ai_shot__aim_y;
        byArray[n++] = (byte)(this.ai_shot__aim_y >> 8);
        byArray[n++] = (byte)(this.ai_shot__aim_y >> 16);
        byArray[n++] = (byte)(this.ai_shot__aim_y >> 24);
        byArray[n++] = (byte)this.timed_game__time_remaining;
        byArray[n++] = (byte)(this.timed_game__time_remaining >> 8);
        byArray[n++] = (byte)(this.timed_game__time_remaining >> 16);
        byArray[n++] = (byte)(this.timed_game__time_remaining >> 24);
        byArray[n++] = (byte)this.target_practice__rng;
        byArray[n++] = (byte)(this.target_practice__rng >> 8);
        byArray[n++] = (byte)(this.target_practice__rng >> 16);
        byArray[n++] = (byte)(this.target_practice__rng >> 24);
        byArray[n++] = (byte)this.target_practice__rng_save;
        byArray[n++] = (byte)(this.target_practice__rng_save >> 8);
        byArray[n++] = (byte)(this.target_practice__rng_save >> 16);
        byArray[n++] = (byte)(this.target_practice__rng_save >> 24);
        byArray[n++] = (byte)this.target_practice__target_x;
        byArray[n++] = (byte)(this.target_practice__target_x >> 8);
        byArray[n++] = (byte)(this.target_practice__target_x >> 16);
        byArray[n++] = (byte)(this.target_practice__target_x >> 24);
        byArray[n++] = (byte)this.target_practice__target_y;
        byArray[n++] = (byte)(this.target_practice__target_y >> 8);
        byArray[n++] = (byte)(this.target_practice__target_y >> 16);
        byArray[n++] = (byte)(this.target_practice__target_y >> 24);
        byArray[n++] = (byte)this.target_practice__next_x;
        byArray[n++] = (byte)(this.target_practice__next_x >> 8);
        byArray[n++] = (byte)(this.target_practice__next_x >> 16);
        byArray[n++] = (byte)(this.target_practice__next_x >> 24);
        byArray[n++] = (byte)this.target_practice__next_y;
        byArray[n++] = (byte)(this.target_practice__next_y >> 8);
        byArray[n++] = (byte)(this.target_practice__next_y >> 16);
        byArray[n++] = (byte)(this.target_practice__next_y >> 24);
        byArray[n++] = (byte)(this.target_practice__last_shot_hit ? 1 : 0);
        byArray[n++] = (byte)(this.target_practice__show_hit_or_miss_target ? 1 : 0);
        return n;
    }

    public void NewGame() {
        this.turn = 0;
        this.first_non_eliminated_player = 0;
        this.darts_thrown = 0;
        this.determining_who_goes_first = this.num_players > 1;
        this.score_at_start_of_round = 0;
        this.round_number = 0;
        this.winner = -1;
        int n = this.golf__num_holes = this.game_type == 5 ? 9 : 18;
        if (this.game_type == 0) {
            this.determining_who_goes_first = false;
        }
        for (int i = 0; i < 4; ++i) {
            this.score[i] = 0;
            this.score_for_high_score_purposes[i] = 0;
            if (this.game_type == 7) {
                this.score[i] = 1;
            }
            if (this.game_type == 2) {
                this.score[i] = 301;
                this.game_301__starting_points = 301;
            }
            if (this.game_type == 3) {
                this.score[i] = 501;
                this.game_301__starting_points = 501;
            }
            this.target_practice__rng_save = (int)(System.currentTimeMillis() & Integer.MAX_VALUE);
            this.still_active[i] = true;
            for (int j = 0; j < 7; ++j) {
                this.cricket__closures_remaining[i][j] = 3;
            }
        }
        this.NewPlayerTurn_IncludingNewGame();
        this.NewPlayerTurn_ButNotUntilWeGetToTheScoreboard();
    }

    private void SetScoreHistory() {
        this.score_history[this.turn][this.round_number < 25 ? this.round_number : 24] = (short)(this.score[this.turn] - this.score_at_start_of_round);
    }

    private void NewPlayerTurn_IncludingNewGame() {
        this.score_at_start_of_round = this.score[this.turn];
        this.darts_thrown = 0;
    }

    public void NewPlayerTurn_ButNotUntilWeGetToTheScoreboard() {
        this.target_practice__rng = this.target_practice__rng_save;
        this.target_practice__next_x = 0;
        this.target_practice__target_x = 0;
        this.target_practice__next_y = 0;
        this.target_practice__target_y = 0;
        this.target_practice__show_hit_or_miss_target = false;
        if (this.game_type == 0) {
            this.timed_game__time_remaining = 90000L;
        }
    }

    public boolean NewPlayerTurn() {
        boolean bl = false;
        do {
            if (++this.turn < this.num_players) continue;
            this.turn = 0;
            ++this.round_number;
            bl = true;
            if (this.round_number < 25) continue;
            for (int i = 0; i < 4; ++i) {
                for (int j = 1; j < 25; ++j) {
                    this.score_history[i][j - 1] = this.score_history[i][j];
                    this.score_history[i][j] = 0;
                }
            }
        } while (!this.still_active[this.turn]);
        this.NewPlayerTurn_IncludingNewGame();
        return bl;
    }

    public void DeactivatePeopleNotTiedForTheLead(boolean bl) {
        int n;
        int n2 = -9999999;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.num_players; ++n) {
            if (!this.still_active[n]) continue;
            if ((bl ? this.score[n] : -this.score[n]) == n2) {
                ++n3;
                continue;
            }
            if ((bl ? this.score[n] : -this.score[n]) <= n2) continue;
            n4 = n;
            n2 = bl ? this.score[n] : -this.score[n];
            n3 = 1;
        }
        if (n3 > 1) {
            this.turn = -1;
            for (n = 0; n < this.num_players; ++n) {
                if (!this.still_active[n]) continue;
                if ((bl ? this.score[n] : -this.score[n]) < n2) {
                    this.still_active[n] = false;
                    this.elimination_round[n] = this.round_number;
                    continue;
                }
                if (this.turn >= 0) continue;
                this.turn = n;
                this.first_non_eliminated_player = n;
            }
        } else {
            this.winner = n4;
        }
        this.score_at_start_of_round = this.score[this.turn];
    }

    public void ComputeChalkboardLayout(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        this.applet.graphical_font__chalk.SetFontAndColor(0, 0xFFFFFF, 0);
        char c = ' ';
        char c2 = ' ';
        char c3 = ' ';
        int n7 = 0;
        int n8 = 0;
        this.layout__font_h = this.applet.GetFontHeight(this.applet.graphical_font__chalk);
        if (this.layout__font_h < this.applet.GetFontHeight(this.applet.graphical_font)) {
            this.layout__font_h = this.applet.GetFontHeight(this.applet.graphical_font);
        }
        int n9 = n2;
        int n10 = n;
        StringBuffer stringBuffer = new StringBuffer(63);
        for (c3 = 'A'; c3 <= 'Z'; c3 = (char)(c3 + '\u0001')) {
            stringBuffer.setLength(0);
            stringBuffer.append(c3);
            n6 = this.applet.GetStringWidth(stringBuffer.toString());
            if (n6 <= n7) continue;
            c = c3;
            n7 = n6;
        }
        for (c3 = '0'; c3 <= '9'; c3 = (char)(c3 + 1)) {
            stringBuffer.setLength(0);
            stringBuffer.append(c3);
            n6 = this.applet.GetStringWidth(stringBuffer.toString());
            if (n6 <= n8) continue;
            c2 = c3;
            n8 = n6;
        }
        stringBuffer.setLength(0);
        for (n5 = 0; n5 < 3; ++n5) {
            stringBuffer.append(c);
        }
        int n11 = this.applet.GetStringWidth(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append(c2);
        stringBuffer.append(c2);
        this.layout__widest_2_number_w = this.applet.GetStringWidth(stringBuffer.toString());
        switch (this.game_type) {
            case 1: {
                n6 = this.num_players < 2 ? 2 : this.num_players;
                int n12 = this.layout__widest_2_number_w * 5 / 2 + 4 + 1;
                if (n12 * n6 > n) {
                    n12 = n / n6;
                }
                this.layout__name_x[0] = n10 - (n6 - 1) * n12 >> 1;
                this.layout__v_stride__no_line = this.layout__font_h + 0;
                this.layout__v_stride__line = this.layout__v_stride__no_line + 1 + 0;
                for (n5 = 0; n5 < 4; ++n5) {
                    this.layout__name_x[n5] = this.layout__name_x[0] + n5 * n12;
                    this.layout__name_y[n5] = 2;
                }
                break;
            }
            case 2: 
            case 3: {
                n6 = this.layout__widest_2_number_w * 5 / 2 + 4 + 1;
                if (n6 * this.num_players > n) {
                    n6 = n / this.num_players;
                }
                this.layout__name_x[0] = n10 - (this.num_players - 1) * n6 >> 1;
                this.layout__v_stride__no_line = this.layout__font_h + 0;
                this.layout__v_stride__line = this.layout__v_stride__no_line + 1 + 0;
                for (n5 = 0; n5 < 4; ++n5) {
                    this.layout__name_x[n5] = this.layout__name_x[0] + n5 * n6;
                    this.layout__name_y[n5] = 3;
                }
                this.layout__num_scores = (n2 - 6 - this.layout__v_stride__line - this.layout__v_stride__no_line) / (this.layout__v_stride__no_line * 2);
                break;
            }
            case 0: 
            case 7: {
                n6 = this.layout__widest_2_number_w * 5 / 2 + 4 + 1;
                if (n6 * this.num_players > n) {
                    n6 = n / this.num_players;
                }
                this.layout__name_x[0] = n10 - (this.num_players - 1) * n6 >> 1;
                this.layout__v_stride__no_line = this.layout__font_h + 3;
                this.layout__v_stride__line = this.layout__v_stride__no_line + 1 + 3;
                for (n5 = 0; n5 < 4; ++n5) {
                    this.layout__name_x[n5] = this.layout__name_x[0] + n5 * n6;
                    this.layout__name_y[n5] = 10;
                }
                break;
            }
            case 4: {
                this.layout__score_cell_w = this.layout__widest_2_number_w + 2;
                this.layout__baseball__name_field_w = n11 + 2;
                stringBuffer.setLength(0);
                this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, 155);
                this.applet.graphical_font.SetFontAndColor(this.chalkboard_bg_color, this.chalkboard_fg_color, 0);
                this.layout__baseball__total_field_w = this.applet.GetStringWidth(stringBuffer.toString()) + 4;
                this.layout__num_scores = (n10 - this.layout__baseball__name_field_w - this.layout__baseball__total_field_w - 4) / this.layout__score_cell_w;
                if (this.layout__num_scores > 9) {
                    this.layout__num_scores = 9;
                }
                for (n5 = 0; n5 < 4; ++n5) {
                    this.layout__name_x[n5] = (n10 - this.layout__baseball__total_field_w - this.layout__baseball__name_field_w - this.layout__score_cell_w * this.layout__num_scores >> 1) + (this.layout__baseball__name_field_w >> 1);
                    this.layout__v_stride__line = this.layout__font_h + 1 + 2;
                    this.layout__name_y[n5] = 8 + this.layout__v_stride__line * (2 + n5);
                }
                break;
            }
            case 5: 
            case 6: {
                n6 = this.num_players > 3 ? 4 : this.num_players + 1;
                int n13 = this.layout__widest_2_number_w * 5 / 2 + 4 + 1;
                if (n13 * n6 > n + 4) {
                    n13 = (n - 4) / n6;
                }
                this.layout__name_x[0] = n - (n6 - 1) * n13 >> 1;
                if (this.num_players < 4) {
                    this.layout__name_x[0] = this.layout__name_x[0] + n13;
                }
                this.layout__v_stride__no_line = this.layout__font_h + 0;
                this.layout__v_stride__line = this.layout__v_stride__no_line + 1 + 0;
                this.layout__num_scores = (n2 - 6 - (this.layout__v_stride__line << 1)) / this.layout__v_stride__no_line;
                if (this.layout__num_scores > 9) {
                    this.layout__num_scores = 9;
                }
                for (n5 = 0; n5 < 4; ++n5) {
                    this.layout__name_x[n5] = this.layout__name_x[0] + n5 * n13;
                    this.layout__name_y[n5] = this.layout__v_stride__line - this.layout__v_stride__no_line + (n2 - this.layout__v_stride__line * 2 - this.layout__v_stride__no_line * this.layout__num_scores >> 1);
                    if (this.layout__name_y[n5] <= 7) continue;
                    this.layout__name_y[n5] = 7;
                }
                break;
            }
        }
    }

    public void Draw_Chalkboard(int n, int n2) {
        int n3;
        int n4 = (this.applet.GetFontHeight(this.applet.graphical_font) - this.applet.GetFontHeight(this.applet.graphical_font__chalk)) / 2;
        int n5 = this.round_number >= 25 ? 24 - this.round_number : 0;
        int n6 = this.round_number + 1 - this.layout__num_scores;
        if (this.turn == this.first_non_eliminated_player && this.darts_thrown == 0) {
            --n6;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        this.applet.SetColor(this.chalkboard_fg_color);
        this.applet.graphical_font__chalk.SetFontAndColor(this.chalkboard_bg_color, this.chalkboard_fg_color, 0);
        int n7 = this.applet.GetFontHeight(this.applet.graphical_font);
        StringBuffer stringBuffer = new StringBuffer(63);
        for (n3 = 0; n3 < this.num_players; ++n3) {
            this.applet.DrawString(this.proj_canvas.plr_name[n3].toString(), n + this.layout__name_x[n3], n2 + this.layout__name_y[n3] + n4, 17);
        }
        switch (this.game_type) {
            case 1: {
                int n8 = 0;
                int n9 = this.layout__name_x[1] - this.layout__name_x[0];
                int n10 = this.num_players == 4 ? 1 : 0;
                int n11 = this.proj_canvas.cricket_marks.getHeight();
                int n12 = this.proj_canvas.cricket_marks.getWidth() / 3;
                int n13 = this.num_players < 2 ? 2 : this.num_players;
                this.applet.FillRect(n + this.layout__name_x[0] - (n9 >> 1) + 2, n2 + this.layout__name_y[0] + this.layout__v_stride__line, n13 * n9 - 4, 1);
                this.applet.FillRect(n + this.layout__name_x[0] - (n9 >> 1) + 2, n2 + this.layout__name_y[0] + 8 * this.layout__v_stride__line, n13 * n9 - 4, 1);
                for (int i = 0; i < n13; ++i) {
                    int n14;
                    if (i < n13 - 1) {
                        n14 = n + this.layout__name_x[i] + (n9 >> 1);
                        if (i == n10) {
                            this.applet.graphical_font.SetFontAndColor(this.chalkboard_bg_color, this.chalkboard_fg_color, 0);
                            this.applet.FillRect(n14, n2 + this.layout__name_y[0], 1, this.layout__v_stride__line);
                            for (n3 = 0; n3 < 7; ++n3) {
                                stringBuffer.setLength(0);
                                if (n3 == 6) {
                                    this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, 154);
                                } else {
                                    stringBuffer.append(20 - n3);
                                }
                                this.applet.DrawString(stringBuffer.toString(), n14, n2 + this.layout__name_y[0] + (n3 + 1) * this.layout__v_stride__line, 17);
                                if (n3 == 0) {
                                    n8 = 2 + this.applet.GetStringWidth(stringBuffer.toString()) / 2;
                                }
                                this.applet.DrawRect(n14 - n8, n2 + this.layout__name_y[0] + (n3 + 1) * this.layout__v_stride__line, n8 * 2, this.layout__v_stride__line + 1);
                            }
                            this.applet.graphical_font.SetFontAndColor(this.chalkboard_bg_color, this.chalkboard_fg_color, 0);
                            this.applet.FillRect(n14, n2 + this.layout__name_y[0] + 8 * this.layout__v_stride__line, 1, this.layout__v_stride__line);
                        } else {
                            this.applet.FillRect(n14, n2 + this.layout__name_y[0], 1, 9 * this.layout__v_stride__line);
                        }
                    }
                    if (i > this.num_players) continue;
                    int n15 = n + this.layout__name_x[i];
                    int n16 = n2 + this.layout__name_y[0] + 8 * this.layout__v_stride__line;
                    if (this.score[i] > 0) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(this.score[i]);
                        this.applet.DrawString(stringBuffer.toString(), n15, n16, 17);
                    }
                    n16 = n2 + this.layout__name_y[0] + this.layout__v_stride__line + (n7 - n11 >> 1);
                    n15 -= n12 >> 1;
                    if (i == n10) {
                        n15 -= n8 >> 1;
                    }
                    if (i == n10 + 1) {
                        n15 += n8 >> 1;
                    }
                    for (n3 = 0; n3 < 7; ++n3) {
                        if (this.cricket__closures_remaining[i][n3] < 3) {
                            n14 = n12 * (2 - this.cricket__closures_remaining[i][n3]);
                            this.applet.drawSubImage(this.proj_canvas.cricket_marks, n15, n16, n12, n11, n15 - n14, n16);
                        }
                        n16 += this.layout__v_stride__line;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                int n17 = this.layout__name_x[1] - this.layout__name_x[0];
                this.applet.FillRect(n + this.layout__name_x[0] - (n17 >> 1) + 2, n2 + this.layout__name_y[0] + this.layout__v_stride__no_line, this.num_players * n17 - 4, 1);
                block12: for (int i = 0; i < this.num_players; ++i) {
                    if (i < this.num_players - 1) {
                        this.applet.FillRect(n + this.layout__name_x[i] + (n17 >> 1), n2 + this.layout__name_y[0], 1, this.layout__v_stride__line + (2 * this.layout__num_scores + 1) * this.layout__v_stride__no_line);
                    }
                    int n18 = n2 + this.layout__name_y[0] + 2 * this.layout__v_stride__line + this.layout__v_stride__no_line * (2 * this.layout__num_scores - 1);
                    int n19 = n + this.layout__name_x[i] - ((n17 >> 1) - 2);
                    int n20 = n + this.layout__name_x[i] + ((n17 >> 1) - 2);
                    int n21 = this.score[i];
                    for (n3 = this.layout__num_scores - 1; n3 >= -1; --n3) {
                        if (n3 + n6 > this.round_number || this.determining_who_goes_first && n3 >= 0 || n3 + n6 == this.round_number && (this.turn < i || this.turn == i && this.darts_thrown == 0)) {
                            n18 -= 2 * this.layout__v_stride__no_line;
                            continue;
                        }
                        stringBuffer.setLength(0);
                        stringBuffer.append(n21);
                        this.applet.DrawString(stringBuffer.toString(), n19, n18, 20);
                        n18 -= this.layout__v_stride__no_line;
                        if (n3 == -1) continue block12;
                        stringBuffer.setLength(0);
                        stringBuffer.append(-this.score_history[i][n3 + n6 + n5]);
                        this.applet.DrawString(stringBuffer.toString(), n20, n18, 24);
                        n18 -= this.layout__v_stride__no_line;
                        n21 -= this.score_history[i][n3 + n6 + n5];
                    }
                }
                break;
            }
            case 7: {
                for (n3 = 0; n3 < this.num_players; ++n3) {
                    if (this.score[n3] <= 20) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(this.score[n3]);
                        this.applet.DrawString(stringBuffer.toString(), n + this.layout__name_x[n3], n2 + this.layout__name_y[n3] + this.layout__v_stride__line + (this.score[n3] > 1 ? this.layout__v_stride__no_line : 0), 17);
                    }
                    if (this.score[n3] > 1) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(this.score[n3] - 1);
                        this.applet.DrawString(stringBuffer.toString(), n + this.layout__name_x[n3], n2 + this.layout__name_y[n3] + this.layout__v_stride__line, 17);
                        int n22 = n + this.layout__name_x[n3];
                        int n23 = n2 + this.layout__name_y[n3] + this.layout__v_stride__line + (this.layout__font_h >> 1);
                        int n24 = this.layout__font_h >> 1;
                        this.applet.DrawLine(n22 + n24 - 1, n23 - n24 + 1, n22 - n24, n23 + n24);
                    }
                    if (n3 <= 0) continue;
                    this.applet.FillRect(n + (this.layout__name_x[n3 - 1] + this.layout__name_x[n3] >> 1), n2 + this.layout__name_y[n3], 1, this.layout__v_stride__no_line + (this.layout__v_stride__line << 1));
                }
                int n25 = this.layout__name_x[1] - this.layout__name_x[0];
                this.applet.FillRect(n + this.layout__name_x[0] - (n25 >> 1), n2 + this.layout__name_y[0] + this.layout__v_stride__no_line, n25 * this.num_players, 1);
                break;
            }
            case 0: {
                for (n3 = 0; n3 < this.num_players; ++n3) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(this.score[n3]);
                    this.applet.DrawString(stringBuffer.toString(), n + this.layout__name_x[n3], n2 + this.layout__name_y[n3] + this.layout__v_stride__line, 17);
                    if (n3 <= 0) continue;
                    this.applet.FillRect(n + (this.layout__name_x[n3 - 1] + this.layout__name_x[n3] >> 1), n2 + this.layout__name_y[n3], 1, this.layout__v_stride__no_line + (this.layout__v_stride__line << 1));
                }
                int n26 = this.layout__name_x[1] - this.layout__name_x[0];
                this.applet.FillRect(n + this.layout__name_x[0] - (n26 >> 1), n2 + this.layout__name_y[0] + this.layout__v_stride__no_line, n26 * this.num_players, 1);
                break;
            }
            case 4: {
                int n27;
                int n28 = n + this.layout__name_x[0] - (this.layout__baseball__name_field_w >> 1);
                int n29 = n2 + this.layout__name_y[0] - 1 - 1 - 2 * this.layout__v_stride__line;
                this.applet.FillRect(n28 + this.layout__baseball__name_field_w, n29, this.layout__num_scores * this.layout__score_cell_w, 1);
                this.applet.graphical_font.SetFontAndColor(this.chalkboard_bg_color, this.chalkboard_fg_color, 0);
                stringBuffer.setLength(0);
                this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, 156);
                this.applet.DrawString(stringBuffer.toString(), n28 + this.layout__baseball__name_field_w + (this.layout__num_scores * this.layout__score_cell_w >> 1), n29 + 1, 17);
                this.applet.FillRect(n28 + this.layout__baseball__name_field_w, n29, 1, this.layout__v_stride__line * (2 + this.num_players));
                this.applet.FillRect(n28 + this.layout__baseball__name_field_w + this.layout__num_scores * this.layout__score_cell_w, n29, 1, this.layout__v_stride__line * (2 + this.num_players));
                this.applet.FillRect(n28 + this.layout__baseball__name_field_w, n29 += this.layout__v_stride__line, this.layout__num_scores * this.layout__score_cell_w + this.layout__baseball__total_field_w, 1);
                for (n3 = 1; n3 < this.num_players + 2; ++n3) {
                    this.applet.FillRect(n28, n29 + n3 * this.layout__v_stride__line, this.layout__baseball__name_field_w + this.layout__baseball__total_field_w + this.layout__num_scores * this.layout__score_cell_w, 1);
                }
                this.applet.FillRect(n28, n29 + this.layout__v_stride__line, 1, this.layout__v_stride__line * this.num_players);
                this.applet.FillRect(n28 + this.layout__baseball__name_field_w + this.layout__num_scores * this.layout__score_cell_w + this.layout__baseball__total_field_w, n29, 1, this.layout__v_stride__line * (1 + this.num_players) + 1);
                for (n3 = 0; n3 < this.layout__num_scores; ++n3) {
                    this.applet.FillRect(n28 + this.layout__baseball__name_field_w + n3 * this.layout__score_cell_w, n29, 1, this.layout__v_stride__line * (1 + this.num_players));
                    stringBuffer.setLength(0);
                    stringBuffer.append(n3 + n6 + 1);
                    n27 = n28 + this.layout__baseball__name_field_w + ((n3 * 2 + 1) * this.layout__score_cell_w >> 1);
                    this.applet.graphical_font.SetFontAndColor(this.chalkboard_bg_color, this.chalkboard_fg_color, 0);
                    this.applet.DrawString(stringBuffer.toString(), n27, n29 + 1 + 1, 17);
                    this.applet.graphical_font__chalk.SetFontAndColor(this.chalkboard_bg_color, this.chalkboard_fg_color, 0);
                    for (int i = 0; !(i >= this.num_players || n3 + n6 > this.round_number || n3 + n6 == this.round_number && (this.turn < i || this.turn == i && this.darts_thrown == 0) || this.determining_who_goes_first); ++i) {
                        stringBuffer.setLength(0);
                        if (this.still_active[i] || n6 + n3 < this.elimination_round[i]) {
                            stringBuffer.append(this.score_history[i][n3 + n6 + n5]);
                        } else {
                            stringBuffer.append("-");
                        }
                        this.applet.DrawString(stringBuffer.toString(), n27, n29 + (i + 1) * this.layout__v_stride__line + 1 + 1 + n4, 17);
                    }
                }
                n27 = n28 + this.layout__baseball__name_field_w + this.layout__num_scores * this.layout__score_cell_w + (this.layout__baseball__total_field_w >> 1);
                stringBuffer.setLength(0);
                this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, 155);
                this.applet.graphical_font.SetFontAndColor(this.chalkboard_bg_color, this.chalkboard_fg_color, 0);
                this.applet.DrawString(stringBuffer.toString(), n27, n29 + 1 + 1, 17);
                this.applet.graphical_font__chalk.SetFontAndColor(this.chalkboard_bg_color, this.chalkboard_fg_color, 0);
                for (n3 = 0; n3 < this.num_players; ++n3) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(this.score[n3]);
                    this.applet.DrawString(stringBuffer.toString(), n27, n29 + (1 + n3) * this.layout__v_stride__line + 1 + 1 + n4, 17);
                }
                break;
            }
            case 5: 
            case 6: {
                int n30;
                int n31 = (this.layout__widest_2_number_w + 1 >> 1) + 2;
                int n32 = this.layout__name_x[1] - this.layout__name_x[0];
                int n33 = this.num_players > 3 ? 4 : this.num_players + 1;
                int n34 = this.num_players == 4 ? 1 : 999;
                int n35 = n + this.layout__name_x[0] - (n32 >> 1);
                if (this.num_players != 4) {
                    n35 -= n32;
                }
                this.applet.FillRect(n35, n2 + this.layout__name_y[0] + this.layout__v_stride__no_line, n33 * n32, 1);
                this.applet.FillRect(n35, n2 + this.layout__name_y[0] + this.layout__v_stride__no_line - this.layout__v_stride__line, n33 * n32, 1);
                this.applet.FillRect(n35, n2 + this.layout__name_y[0] + this.layout__num_scores * this.layout__v_stride__no_line + this.layout__v_stride__line - 1, n33 * n32, 1);
                this.applet.FillRect(n35, n2 + this.layout__name_y[0] + this.layout__num_scores * this.layout__v_stride__no_line + 2 * this.layout__v_stride__line - 1, n33 * n32, 1);
                block20: for (int i = -1; i < this.num_players + 1; ++i) {
                    if (i < 0 && this.num_players == 4) continue;
                    int n36 = n + this.layout__name_x[0] + ((2 * i - 1) * n32 >> 1);
                    if (i == n34 + 1) {
                        this.applet.FillRect(n36, n2 + this.layout__name_y[0] + this.layout__v_stride__no_line - this.layout__v_stride__line, 1, this.layout__v_stride__no_line + 1);
                        for (n3 = 0; n3 < this.layout__num_scores; ++n3) {
                            this.applet.DrawRect(n36 - n31, n2 + this.layout__name_y[0] + (n3 + 1) * this.layout__v_stride__no_line, n31 * 2, this.layout__v_stride__line);
                        }
                        this.applet.FillRect(n36, n2 + this.layout__name_y[0] + this.layout__v_stride__no_line * this.layout__num_scores + this.layout__v_stride__line, 1, this.layout__v_stride__line);
                    } else {
                        this.applet.FillRect(n36, n2 + this.layout__name_y[0] + this.layout__v_stride__no_line - this.layout__v_stride__line, 1, this.layout__num_scores * this.layout__v_stride__no_line + 2 * this.layout__v_stride__line + 1);
                    }
                    if (i < 0 || i >= this.num_players) continue;
                    n35 = n + this.layout__name_x[i];
                    n30 = n2 + this.layout__name_y[0] + this.layout__num_scores * this.layout__v_stride__no_line + this.layout__v_stride__line;
                    if (this.score[i] > 0) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(this.score[i]);
                        this.applet.DrawString(stringBuffer.toString(), n35, n30, 17);
                    }
                    n30 = n2 + this.layout__name_y[0] + this.layout__v_stride__no_line + 1;
                    if (i == n34) {
                        n35 -= n31 >> 1;
                    }
                    if (i == n34 + 1) {
                        n35 += n31 >> 1;
                    }
                    for (n3 = 0; n3 < this.layout__num_scores; ++n3) {
                        if (n3 + n6 > this.round_number || n3 + n6 == this.round_number && (this.turn < i || this.turn == i && this.darts_thrown == 0)) continue;
                        if (this.determining_who_goes_first) continue block20;
                        stringBuffer.setLength(0);
                        if (this.still_active[i] || n6 + n3 < this.elimination_round[i]) {
                            stringBuffer.append(this.score_history[i][n3 + n6 + n5]);
                        } else {
                            stringBuffer.append("-");
                        }
                        this.applet.DrawString(stringBuffer.toString(), n35, n30, 17);
                        n30 += this.layout__v_stride__no_line;
                    }
                }
                this.applet.graphical_font.SetFontAndColor(this.chalkboard_bg_color, this.chalkboard_fg_color, 0);
                if (this.num_players < 4) {
                    n35 = n + this.layout__name_x[0] - n32;
                    stringBuffer.setLength(0);
                    this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, 157);
                    this.applet.DrawString(stringBuffer.toString(), n35, n2 + this.layout__name_y[0], 17);
                } else {
                    n35 = n + (this.layout__name_x[n34 + 1] + this.layout__name_x[n34] >> 1);
                }
                n30 = n2 + this.layout__name_y[0] + this.layout__v_stride__no_line;
                for (n3 = 0; n3 < this.layout__num_scores; ++n3) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(1 + n3 + n6);
                    this.applet.DrawString(stringBuffer.toString(), n35, n30, 17);
                    n30 += this.layout__v_stride__no_line;
                }
                break;
            }
        }
    }

    public void BuildShotString(StringBuffer stringBuffer, int n, int n2) {
        if (this.game_type == 0) {
            this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, this.target_practice__last_shot_hit ? 152 : 153);
            return;
        }
        switch (n2) {
            case 1: 
            case 2: {
                stringBuffer.append(n);
                break;
            }
            case 4: {
                this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, 123);
                stringBuffer.append(n);
                break;
            }
            case 8: {
                this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, 124);
                stringBuffer.append(n);
                break;
            }
            case 16: {
                this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, 123);
            }
            case 32: {
                this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, 125);
                break;
            }
            case 64: {
                this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, 122);
                break;
            }
            case 128: 
            case 256: {
                this.applet.external_text_mgr.AppendStringBuffer(stringBuffer, 0, 121);
            }
        }
    }

    public void TargetPractice_PickNewTarget() {
        do {
            int n = 0;
            int n2 = 0;
            this.target_practice__rng = this.target_practice__rng * 1664525 + 1013904223 & Integer.MAX_VALUE;
            int n3 = this.target_practice__rng >> 8;
            if ((n3 %= 9) >= 1) {
                this.target_practice__rng = this.target_practice__rng * 1664525 + 1013904223 & Integer.MAX_VALUE;
                n = this.target_practice__rng >> 8;
                n %= 20;
                n = 16384 * n / 20;
                this.target_practice__rng = this.target_practice__rng * 1664525 + 1013904223 & Integer.MAX_VALUE;
                n3 = this.target_practice__rng >> 8;
                switch (n3 %= 4) {
                    case 0: {
                        n2 = 896859;
                        break;
                    }
                    case 1: {
                        n2 = 1462108;
                        break;
                    }
                    case 2: {
                        n2 = 1220935;
                        break;
                    }
                    default: {
                        n2 = 527564;
                    }
                }
            }
            this.target_practice__next_x = (int)((long)n2 * (long)this.applet.Sin(n) >> 14);
            this.target_practice__next_y = (int)((long)n2 * (long)this.applet.Sin(n + 4096) >> 14);
        } while (this.target_practice__next_x == this.target_practice__target_x && this.target_practice__next_y == this.target_practice__target_y);
    }

    public int ThrowDart(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        this.last_shot_description.setLength(0);
        if (this.determining_who_goes_first) {
            n6 |= 8;
            this.last_shot_description.setLength(0);
            this.dist_to_center[this.darts_thrown++] = n3;
            if (this.darts_thrown >= this.num_players) {
                boolean bl = this.DoesClosestGoFirst();
                for (int i = 0; i < this.num_players; ++i) {
                    int n7 = Integer.MAX_VALUE;
                    int n8 = bl ? i : this.num_players - 1 - i;
                    for (int j = 0; j < this.num_players; ++j) {
                        if (this.dist_to_center[j] >= n7) continue;
                        n7 = this.dist_to_center[j];
                        this.player_order[n8] = j;
                    }
                    this.dist_to_center[this.player_order[n8]] = Integer.MAX_VALUE;
                }
                this.determining_who_goes_first = false;
                this.darts_thrown = 0;
                n6 |= 0x10;
            }
        } else {
            int n9;
            int n10;
            int n11;
            int n12 = this.turn;
            this.total_num_of_darts_thrown[n12] = this.total_num_of_darts_thrown[n12] + 1;
            if (this.game_type == 0) {
                n11 = n4 - this.target_practice__target_x;
                n10 = n5 - this.target_practice__target_y;
                this.target_practice__last_shot_hit = false;
                if (n11 < 180224 && n11 > -180224 && n10 < 180224 && n10 > -180224) {
                    n9 = (int)((long)n11 * (long)n11 >> 14) + (int)((long)n10 * (long)n10 >> 14);
                    this.target_practice__last_shot_hit = n9 < 1982464;
                }
                this.target_practice__show_hit_or_miss_target = true;
            }
            this.BuildShotString(this.last_shot_description, n, n2);
            switch (this.game_type) {
                case 1: {
                    int n13 = this.turn;
                    this.score_for_high_score_purposes[n13] = this.score_for_high_score_purposes[n13] + 1;
                    if (n >= 15) {
                        int n14;
                        n11 = 6;
                        n10 = 1;
                        if (n <= 20) {
                            n11 = 20 - n;
                            if (n2 == 4) {
                                n10 = 2;
                            }
                            if (n2 == 8) {
                                n10 = 3;
                            }
                        } else if (n == 25 && n2 == 16) {
                            n10 = 2;
                        }
                        while (n10 > 0) {
                            if (this.cricket__closures_remaining[this.turn][n11] != 0) {
                                if (this.cricket__closures_remaining[this.turn][n11] <= n10) {
                                    n6 |= 0x400;
                                }
                                int[] nArray = this.cricket__closures_remaining[this.turn];
                                int n15 = n11;
                                nArray[n15] = nArray[n15] - 1;
                            } else {
                                n9 = 1;
                                for (n14 = 0; n14 < this.num_players; ++n14) {
                                    if (this.cricket__closures_remaining[n14][n11] == 0) continue;
                                    n9 = 0;
                                }
                                if (n9 != 0) {
                                    n6 |= 0x800;
                                }
                                if (n9 == 0 || this.num_players == 1) {
                                    int n16 = this.turn;
                                    this.score[n16] = this.score[n16] + n;
                                    n6 |= 0x1000;
                                }
                            }
                            --n10;
                        }
                        n14 = 1;
                        for (n9 = 0; n9 < 7; ++n9) {
                            if (this.cricket__closures_remaining[this.turn][n9] == 0) continue;
                            n14 = 0;
                        }
                        if (n14 != 0) {
                            n6 |= 0x100;
                        }
                        for (n9 = 0; n9 < this.num_players; ++n9) {
                            if (n9 == this.turn || this.score[n9] <= this.score[this.turn]) continue;
                            n14 = 0;
                        }
                        if (n14 != 0) {
                            n6 |= 0xA;
                            this.winner = this.turn;
                        }
                    } else {
                        n6 |= 0x200;
                    }
                    this.SetScoreHistory();
                    if (++this.darts_thrown < 3) break;
                    this.NewPlayerTurn();
                    n6 |= 8;
                    break;
                }
                case 2: 
                case 3: {
                    int n17 = this.turn;
                    this.score_for_high_score_purposes[n17] = this.score_for_high_score_purposes[n17] + 1;
                    n11 = 0;
                    int n18 = n10 = n2 == 4 || n2 == 16 ? 1 : 0;
                    if (n10 != 0 || this.score[this.turn] != this.game_301__starting_points) {
                        if (n2 == 4 || n2 == 16) {
                            n *= 2;
                        }
                        if (n2 == 8) {
                            n *= 3;
                        }
                        int n19 = this.turn;
                        this.score[n19] = this.score[n19] - n;
                        if (n != 0) {
                            if (this.score[this.turn] > 1 || this.score[this.turn] == 0 && n10 != 0) {
                                n6 |= 1;
                            }
                            if (this.score[this.turn] == 0 && n10 != 0) {
                                n6 |= 0xA;
                                this.winner = this.turn;
                            } else if (this.score[this.turn] <= 1) {
                                n11 = 1;
                                n6 &= 0xFFFFFFFE;
                                n6 |= 0x20;
                                this.score[this.turn] = this.score_at_start_of_round;
                            }
                        }
                    }
                    this.SetScoreHistory();
                    if (n11 == 0 && ++this.darts_thrown < 3) break;
                    this.NewPlayerTurn();
                    n6 |= 8;
                    break;
                }
                case 7: {
                    int n20 = this.turn;
                    this.score_for_high_score_purposes[n20] = this.score_for_high_score_purposes[n20] + 1;
                    if (n == this.score[this.turn]) {
                        int n21 = this.turn;
                        this.score[n21] = this.score[n21] + 1;
                        n6 |= 1;
                        if (this.score[this.turn] > 20) {
                            n6 |= 0xA;
                            this.winner = this.turn;
                        }
                    }
                    this.SetScoreHistory();
                    if (++this.darts_thrown < 3) break;
                    this.NewPlayerTurn();
                    n6 |= 8;
                    break;
                }
                case 4: {
                    this.last_shot_description.setLength(0);
                    if (this.round_number >= 9) {
                        if (n2 == 16) {
                            n = this.round_number + 1;
                            n2 = 4;
                        } else if (n2 == 32) {
                            n = this.round_number + 1;
                            n2 = 1;
                        } else {
                            n = 0;
                        }
                    }
                    if (n == this.round_number + 1) {
                        n11 = 1;
                        if (n2 == 4) {
                            n11 = 2;
                        }
                        if (n2 == 8) {
                            n11 = 3;
                        }
                        int n22 = this.turn;
                        this.score[n22] = this.score[n22] + n11;
                        this.last_shot_description.append(n11);
                        this.applet.external_text_mgr.AppendStringBuffer(this.last_shot_description, 0, n11 == 1 ? 144 : 145);
                    } else {
                        this.applet.external_text_mgr.AppendStringBuffer(this.last_shot_description, 0, 143);
                    }
                    this.score_for_high_score_purposes[this.turn] = this.score[this.turn];
                    this.SetScoreHistory();
                    if (++this.darts_thrown < 3) break;
                    this.NewPlayerTurn();
                    n6 |= 8;
                    if (this.round_number < 9 || this.turn != this.first_non_eliminated_player) break;
                    this.DeactivatePeopleNotTiedForTheLead(true);
                    if (this.winner < 0) break;
                    n6 |= 2;
                    break;
                }
                case 5: 
                case 6: {
                    this.last_shot_description.setLength(0);
                    n11 = this.score_at_start_of_round - this.score[this.turn];
                    n10 = 5;
                    if (n == this.round_number % this.golf__num_holes + 1) {
                        if (n2 == 1) {
                            n10 = 3;
                        }
                        if (n2 == 2) {
                            n10 = 4;
                        }
                        if (n2 == 4) {
                            n10 = 1;
                        }
                        if (n2 == 8) {
                            n10 = 2;
                        }
                    }
                    this.score[this.turn] = this.score_at_start_of_round + n10;
                    this.applet.external_text_mgr.AppendStringBuffer(this.last_shot_description, 0, 146 + n10 - 1);
                    this.score_for_high_score_purposes[this.turn] = this.score[this.turn];
                    this.SetScoreHistory();
                    if (++this.darts_thrown >= 3 || n10 == 1) {
                        n6 = this.ShotAccepted(n6);
                    }
                    if (n10 == 1) {
                        n6 |= 0x40;
                    }
                    if (n10 != 5) break;
                    n6 |= 0x80;
                    break;
                }
                case 0: {
                    if (this.target_practice__last_shot_hit) {
                        int n23 = this.turn;
                        this.score[n23] = this.score[n23] + 2;
                        n6 |= 1;
                    } else {
                        int n24 = this.turn;
                        this.score[n24] = this.score[n24] + -1;
                    }
                    if (this.score[this.turn] < 0) {
                        this.score[this.turn] = 0;
                    }
                    this.score_for_high_score_purposes[this.turn] = this.score[this.turn];
                    this.darts_thrown = 0;
                    this.TargetPractice_PickNewTarget();
                    break;
                }
            }
        }
        return n6;
    }

    public int ShotAccepted(int n) {
        switch (this.game_type) {
            case 5: 
            case 6: {
                this.NewPlayerTurn();
                n |= 8;
                if (this.round_number < this.golf__num_holes || this.turn != this.first_non_eliminated_player) break;
                this.DeactivatePeopleNotTiedForTheLead(false);
                if (this.winner < 0) break;
                n |= 2;
            }
        }
        return n;
    }

    public boolean DetermineAIShot(int n, int n2, int n3) {
        int n4;
        boolean bl = true;
        int n5 = 0;
        int n6 = 0;
        int n7 = n & 3;
        block0 : switch (this.game_type) {
            case 1: {
                int n8;
                int n9;
                int n10;
                n4 = this.turn + 1 & 1;
                for (n10 = 0; n10 < 7 && this.cricket__closures_remaining[this.turn][n10] == 0; ++n10) {
                }
                for (n9 = 0; n9 < 7 && this.cricket__closures_remaining[n4][n9] == 0; ++n9) {
                }
                if ((n & 0xC) == 4 && this.cricket__closures_remaining[this.turn][6] != 0) {
                    n6 = 0;
                    break;
                }
                if ((n & 0xC) == 8 && this.cricket__closures_remaining[this.turn][4] != 0) {
                    n5 = 16;
                    n10 = 4;
                    n6 = 896859;
                    break;
                }
                boolean bl2 = false;
                if (n10 > 7) {
                    bl2 = true;
                }
                switch (n & 0x10) {
                    case 16: {
                        if (this.score[this.turn] >= this.score[n4]) break;
                        bl2 = true;
                    }
                }
                if (n10 > n9 && this.score[this.turn] < this.score[n4] + ((n >> 12 & 0x7F) * 10 + 1)) {
                    bl2 = true;
                }
                int n11 = n8 = bl2 ? n9 : n10;
                if (n8 == 6) {
                    n6 = 0;
                    break;
                }
                n5 = 20 - n8;
                int n12 = this.cricket__closures_remaining[this.turn][n8];
                if (this.cricket__closures_remaining[n4][n8] > 0) {
                    n12 = 3;
                }
                switch (n12) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        n6 = 1220935;
                        break block0;
                    }
                    case 2: {
                        n6 = 896859;
                        break block0;
                    }
                }
                n6 = 896859;
                break;
            }
            case 2: 
            case 3: {
                int n13;
                n6 = 896859;
                switch (n & 0x60) {
                    case 0: {
                        n5 = 20;
                        break;
                    }
                    case 32: {
                        n5 = 19;
                        break;
                    }
                    case 96: {
                        n5 = 16;
                        break;
                    }
                    case 64: {
                        n5 = 20;
                        n6 = 0;
                    }
                }
                if (this.score[this.turn] == this.game_301__starting_points) {
                    n5 = n >> 19 & 0x1F;
                    n6 = 1462108;
                    break;
                }
                if (this.score[this.turn] <= 40 && (this.score[this.turn] & 1) == 0) {
                    n6 = 1462108;
                    n5 = this.score[this.turn] >> 1;
                    break;
                }
                if (this.score[this.turn] == 50 && this.darts_thrown == 2) {
                    n6 = 0;
                    break;
                }
                if (this.score[this.turn] == 110 || this.score[this.turn] == 107 || this.score[this.turn] == 104 || this.score[this.turn] == 101) {
                    n5 = (this.score[this.turn] - 50) / 3;
                    n6 = 896859;
                    break;
                }
                for (n4 = 0; n4 < 20; ++n4) {
                    n13 = this.score[this.turn] - this.desired_scores_301[n4];
                    if (n13 <= 0 || n13 > 20) continue;
                    n5 = n13;
                    n6 = 1220935;
                    break;
                }
                if (n4 < 20) break;
                for (n4 = 0; n4 < 20; ++n4) {
                    n13 = this.score[this.turn] - this.desired_scores_301[n4];
                    if (n13 % 2 == 0) {
                        if ((n13 >>= 1) > 0 && n13 <= 20) {
                            n5 = n13;
                            n6 = 1462108;
                            break;
                        }
                        n13 <<= 1;
                    }
                    if (n13 % 3 != 0 || (n13 /= 3) <= 0 || n13 > 20) continue;
                    n5 = n13;
                    n6 = 896859;
                    break;
                }
                if (n4 < 20 || this.darts_thrown != 0 || this.score[this.turn] > 170) break;
                n6 = 896859;
                if (this.score[this.turn] >= 130) {
                    if (this.score[this.turn] == 169 || this.score[this.turn] == 168 || this.score[this.turn] == 166 || this.score[this.turn] == 165 || this.score[this.turn] == 163 || this.score[this.turn] == 162 || this.score[this.turn] == 159) break;
                    n5 = 20;
                    if (this.score[this.turn] != 137) break;
                    n5 = 17;
                    break;
                }
                switch (this.score[this.turn]) {
                    case 97: 
                    case 99: 
                    case 107: 
                    case 119: 
                    case 123: 
                    case 127: 
                    case 129: {
                        n5 = 19;
                        break block0;
                    }
                    case 104: 
                    case 122: 
                    case 128: {
                        n5 = 18;
                        break block0;
                    }
                    case 101: {
                        n5 = 17;
                        break block0;
                    }
                    case 95: {
                        n5 = 15;
                        break block0;
                    }
                    case 125: {
                        n6 = 0;
                        break block0;
                    }
                }
                n5 = 20;
                break;
            }
            case 7: {
                n5 = this.score[this.turn];
                n6 = 1220935;
                break;
            }
            case 4: {
                n5 = this.round_number + 1;
                switch (n7) {
                    case 0: {
                        n6 = 1220935;
                        break;
                    }
                    case 1: {
                        n6 = 1058897;
                        break;
                    }
                    default: {
                        n6 = 896859;
                    }
                }
                if (this.round_number < 9) break;
                n6 = 0;
                break;
            }
            case 5: 
            case 6: {
                n5 = this.round_number % this.golf__num_holes + 1;
                n4 = 0;
                int n14 = this.score[this.turn] - this.score_at_start_of_round;
                if (n14 == 0) {
                    n14 = 6;
                }
                switch (n7) {
                    case 0: {
                        if (n14 <= 4) {
                            n4 = 1;
                        }
                        n6 = 896859;
                        break;
                    }
                    case 1: {
                        if (n14 <= 3) {
                            n4 = 1;
                        }
                        if (n14 <= 4 && this.darts_thrown >= 2) {
                            n4 = 1;
                        }
                        if (this.darts_thrown >= 1) {
                            n6 = 896859;
                            break;
                        }
                        n6 = 1462108;
                        break;
                    }
                    default: {
                        if (n14 <= 3) {
                            n4 = 1;
                        }
                        n6 = this.darts_thrown >= 2 ? 896859 : 1462108;
                    }
                }
                if (n4 == 0) break;
                bl = false;
                break;
            }
        }
        switch (n5) {
            case 20: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 1;
                break;
            }
            case 18: {
                n4 = 2;
                break;
            }
            case 4: {
                n4 = 3;
                break;
            }
            case 13: {
                n4 = 4;
                break;
            }
            case 6: {
                n4 = 5;
                break;
            }
            case 10: {
                n4 = 6;
                break;
            }
            case 15: {
                n4 = 7;
                break;
            }
            case 2: {
                n4 = 8;
                break;
            }
            case 17: {
                n4 = 9;
                break;
            }
            case 3: {
                n4 = 10;
                break;
            }
            case 19: {
                n4 = 11;
                break;
            }
            case 7: {
                n4 = 12;
                break;
            }
            case 16: {
                n4 = 13;
                break;
            }
            case 8: {
                n4 = 14;
                break;
            }
            case 11: {
                n4 = 15;
                break;
            }
            case 14: {
                n4 = 16;
                break;
            }
            case 9: {
                n4 = 17;
                break;
            }
            case 12: {
                n4 = 18;
                break;
            }
            case 5: {
                n4 = 19;
                break;
            }
            default: {
                n4 = 20;
            }
        }
        n4 = 16384 * n4 / 20;
        if (this.determining_who_goes_first) {
            n6 = 0;
        }
        this.ai_shot__aim_x = n2 + (int)((long)n6 * (long)this.applet.Sin(n4) >> 14);
        this.ai_shot__aim_y = n3 - (int)((long)n6 * (long)this.applet.Sin(n4 + 4096) >> 14);
        return bl;
    }

    public void TimedGame_DepleteTime(long l) {
        this.timed_game__time_remaining -= l;
        if (this.timed_game__time_remaining < 0L) {
            this.timed_game__time_remaining = 0L;
        }
    }

    public boolean TimedGame_IsTimedGame() {
        return this.game_type == 0;
    }

    boolean DoesClosestGoFirst() {
        return this.game_type != 5 && this.game_type != 6 && this.game_type != 4;
    }
}

