/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.tools;

import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class Camera {
    public static final int CAMERA_TYPE__SPRITE = 0;
    public static final int CAMERA_TYPE__FREE = 1;
    private static final int SLIDE_STEP = 5;
    private int cameraType;
    public int x = 0;
    public int y = 0;
    public int width = 0;
    public int height = 0;
    public int offsetX = 0;
    public int offsetY = 0;
    private boolean slidingX = false;
    private boolean slidingY = false;
    private int targetX = 0;
    private int targetY = 0;
    private int screenCenterX;
    private int screenCenterY;
    private int spriteCenterX;
    private int spriteCenterY;
    private LayerManager layerManager;
    private int layerManagerWidth;
    private int layerManagerHeight;
    private Sprite sprite;

    public Camera(LayerManager layerManager, int layerManagerWidth, int layerManagerHeight) {
        this.setBase(layerManager, layerManagerWidth, layerManagerHeight);
    }

    public void setBase(LayerManager layerManager, int layerManagerWidth, int layerManagerHeight) {
        this.layerManager = layerManager;
        this.layerManagerWidth = layerManagerWidth;
        this.layerManagerHeight = layerManagerHeight;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.screenCenterX = width / 2;
        this.screenCenterY = height / 2;
    }

    public void setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    public int getCameraType() {
        return this.cameraType;
    }

    public void setCameraType(int cameraType) {
        this.setCameraType(cameraType, null);
    }

    public void setCameraType(int cameraType, Sprite sprite) {
        this.cameraType = cameraType;
        this.sprite = sprite;
        if (sprite != null) {
            this.defineTarget(sprite);
        }
    }

    public void defineTarget(Sprite sprite) {
        this.spriteCenterX = sprite.getX() + sprite.getWidth() / 2;
        this.spriteCenterY = sprite.getY() + sprite.getHeight() / 2;
        if (this.layerManagerWidth > this.width) {
            this.slidingX = true;
            this.targetX = this.spriteCenterX < this.screenCenterX ? this.screenCenterX : (this.spriteCenterX > this.layerManagerWidth - this.screenCenterX ? this.layerManagerWidth - this.screenCenterX : this.spriteCenterX);
        }
        if (this.layerManagerHeight > this.height) {
            this.slidingY = true;
            this.targetY = this.spriteCenterY < this.screenCenterY ? this.screenCenterY : (this.spriteCenterY > this.layerManagerHeight - this.screenCenterY ? this.layerManagerHeight - this.screenCenterY : this.spriteCenterY);
        }
    }

    public void showPoint(int x, int y) {
        this.x = x < this.screenCenterX || this.layerManagerWidth <= this.width ? 0 : (x > this.layerManagerWidth - this.screenCenterX ? this.layerManagerWidth - this.width : x - this.screenCenterX);
        this.y = y < this.screenCenterY || this.layerManagerHeight <= this.height ? 0 : (y > this.layerManagerHeight - this.screenCenterY ? this.layerManagerHeight - this.height : y - this.screenCenterY);
    }

    public void updateView() {
        if (this.cameraType == 0 && this.sprite != null) {
            this.spriteCenterX = this.sprite.getX() + this.sprite.getWidth() / 2;
            this.spriteCenterY = this.sprite.getY() + this.sprite.getHeight() / 2;
            if (this.layerManagerWidth > this.width) {
                if (this.slidingX) {
                    int slideDistanceX = this.x + this.width / 2 - this.targetX;
                    if (slideDistanceX <= -5) {
                        this.x += 5;
                    } else if (slideDistanceX >= 5) {
                        this.x -= 5;
                    } else {
                        this.slidingX = false;
                    }
                } else {
                    this.x = this.spriteCenterX < this.screenCenterX ? 0 : (this.spriteCenterX > this.layerManagerWidth - this.screenCenterX ? this.layerManagerWidth - this.width : this.spriteCenterX - this.screenCenterX);
                }
            }
            if (this.layerManagerHeight > this.height) {
                if (this.slidingY) {
                    int slideDistanceY = this.y + this.height / 2 - this.targetY;
                    if (slideDistanceY <= -5) {
                        this.y += 5;
                    } else if (slideDistanceY >= 5) {
                        this.y -= 5;
                    } else {
                        this.slidingY = false;
                    }
                } else {
                    this.y = this.spriteCenterY < this.screenCenterY ? 0 : (this.spriteCenterY > this.layerManagerHeight - this.screenCenterY ? this.layerManagerHeight - this.height : this.spriteCenterY - this.screenCenterY);
                }
            }
        }
        this.layerManager.setViewWindow(this.x - this.offsetX, this.y - this.offsetY, this.width, this.height);
    }
}

