/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.Utility;
import com.jarbull.jbf.JBManager;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScoreAndTimeTraining {
    private int x;
    private int y;
    private int time;
    public boolean timeStopped;
    public static int points;
    Timer timer;
    Image background;

    public ScoreAndTimeTraining() {
        points = 0;
        this.time = 0;
        this.timeStopped = false;
        this.background = ImageHandler.getInstance().getImage("/res/img/timeAndScoreInTraining.png");
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){
            int i = 0;

            public void run() {
                if (!ScoreAndTimeTraining.this.timeStopped) {
                    ScoreAndTimeTraining.this.increaseTime();
                }
            }
        }, 0L, 1000L);
        this.setLocation(100, 0);
    }

    public static void increaseHomePoints(int amount) {
        if ((points += amount) > 99) {
            points = 0;
        }
    }

    public int getPoints() {
        return points;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void stopTime() {
        this.timeStopped = true;
    }

    public void startTime() {
        this.timeStopped = false;
    }

    public void increaseTime() {
        ++this.time;
    }

    public void paint(Graphics g) {
        g.drawImage(this.background, this.x, this.y, 0);
        String[] timeMinArray = Utility.int2StringArray(this.time / 60, 2);
        int startPoint2 = this.x + 5;
        for (int i = 0; i < timeMinArray.length; ++i) {
            g.drawImage(JBManager.getInstance().getTextImage(timeMinArray[i], "digital"), startPoint2, this.y + 3, 0);
            startPoint2 += JBManager.getInstance().getTextImage(timeMinArray[i], "digital").getWidth();
        }
        String[] timeSecArray = Utility.int2StringArray(this.time % 60, 2);
        int startPoint3 = this.x + 38;
        for (int i = 0; i < timeSecArray.length; ++i) {
            g.drawImage(JBManager.getInstance().getTextImage(timeSecArray[i], "digital"), startPoint3, this.y + 3, 0);
            startPoint3 += JBManager.getInstance().getTextImage(timeSecArray[i], "digital").getWidth();
        }
        String[] pointsArray = Utility.int2StringArray(points, 2);
        int startPoint4 = this.x + 25;
        for (int i = 0; i < pointsArray.length; ++i) {
            Image temp = JBManager.getInstance().getTextImage(pointsArray[i], "tombique-tam");
            g.drawImage(temp, startPoint4, this.y + 26, 0);
            startPoint4 += temp.getWidth();
        }
    }

    public void clear() {
        this.background = null;
        this.timer.cancel();
        this.timer = null;
    }
}

