/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.jbf;

import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBGameCanvas;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.gadget.ScoreCheckerThread;
import com.jarbull.jbf.menu.JBMainMenuCanvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class JBMIDlet
extends MIDlet {
    protected JBMainMenuCanvas jbMainMenuCanvas;
    protected JBGameCanvas jbGameCanvas;

    public void openPauseMenu() {
        this.pauseApp();
        this.jbMainMenuCanvas.setCurrentNode(JBManager.getInstance().getMenuNode("P0"), null);
        this.switchToMainMenu();
    }

    public JBGameCanvas getJbGameCanvas() {
        return this.jbGameCanvas;
    }

    protected final void startApp() throws MIDletStateChangeException {
        JBManager.getInstance().jBMIDlet = this;
        JBManager.getInstance().handleEvent(new JBAction((Object)this, "si:/res/intro.png"));
        JBManager.getInstance().handleEvent(new JBAction((Object)this, "load_config_xml:"));
        this.jbMainMenuCanvas = new JBMainMenuCanvas();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.jbMainMenuCanvas);
        new Thread(this.jbMainMenuCanvas).start();
    }

    protected final void pauseApp() {
        this.jbGameCanvas.isPaused = true;
        this.pauseJBApp(null);
    }

    protected final void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        this.jbMainMenuCanvas.stopProcessing();
        this.notifyDestroyed();
    }

    protected void switchToMainMenu() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.jbMainMenuCanvas);
        this.jbMainMenuCanvas.isPaused = false;
    }

    protected void switchToSubmitForm() {
        Form form = new Form("Enter your name");
        final TextField textField = new TextField("Name", "", 32, 0);
        form.append((Item)textField);
        form.addCommand(new Command("SUBMIT", "Submit", 4, 0));
        form.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                String userName = textField.getString();
                JBManager.getInstance().gameSettings.putAndSave("score:myname", userName);
                ScoreCheckerThread scoreCheckerThread = new ScoreCheckerThread(JBMIDlet.this.jbMainMenuCanvas.getCurrentNode());
                scoreCheckerThread.start();
                JBMIDlet.this.switchToMainMenu();
            }
        });
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
    }

    protected void startGame(String action) {
        this.startJBApp(action);
        if (this.jbGameCanvas == null) {
            throw new NullPointerException("jbGameCanvas is null");
        }
        this.jbGameCanvas.isRunning = true;
        new Thread(this.jbGameCanvas).start();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.jbGameCanvas);
    }

    protected void resumeGame(String action) {
        this.jbMainMenuCanvas.isPaused = true;
        this.resumeJBApp(action);
        this.jbGameCanvas.isPaused = false;
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.jbGameCanvas);
    }

    protected abstract void startJBApp(String var1);

    protected abstract void pauseJBApp(String var1);

    protected abstract void resumeJBApp(String var1);

    protected abstract void destroyJBApp(boolean var1, String var2);
}

