/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.Utility;
import com.jarbull.jbf.JBManager;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScoreAndTimeGame {
    private int x;
    private int y;
    private int time;
    public boolean timeStopped;
    public static int points;
    Timer timer;
    Image background;
    private int levelPoints;

    public ScoreAndTimeGame() {
        points = 0;
        this.time = 0;
        this.timeStopped = false;
        this.background = ImageHandler.getInstance().getImage("/res/img/timeAndScoreInGame.png");
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){
            int i = 0;

            public void run() {
                if (!ScoreAndTimeGame.this.timeStopped) {
                    ScoreAndTimeGame.this.decreaseTime();
                }
            }
        }, 0L, 1000L);
        this.setLocation(165, 5);
    }

    public static void increaseHomePoints(int amount) {
        points += amount;
        points = 0;
    }

    public static void setPoints(int points) {
        ScoreAndTimeGame.points = points;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getPoints() {
        return points;
    }

    public int getLevelPoints() {
        return this.levelPoints;
    }

    public void setLevelPoints(int levelPoints) {
        this.levelPoints = levelPoints;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void stopTime() {
        this.timeStopped = true;
    }

    public void startTime() {
        this.timeStopped = false;
    }

    public void increaseTime() {
        ++this.time;
    }

    private void decreaseTime() {
        if (this.time > 0) {
            --this.time;
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.background, this.x, this.y, 0);
        String[] timeMinArray = Utility.int2StringArray(this.time / 60, 2);
        int startPoint2 = this.x + 5;
        for (int i = 0; i < timeMinArray.length; ++i) {
            g.drawImage(JBManager.getInstance().getTextImage(timeMinArray[i], "digital"), startPoint2, this.y + 3, 0);
            startPoint2 += JBManager.getInstance().getTextImage(timeMinArray[i], "digital").getWidth();
        }
        String[] timeSecArray = Utility.int2StringArray(this.time % 60, 2);
        int startPoint3 = this.x + 38;
        for (int i = 0; i < timeSecArray.length; ++i) {
            g.drawImage(JBManager.getInstance().getTextImage(timeSecArray[i], "digital"), startPoint3, this.y + 3, 0);
            startPoint3 += JBManager.getInstance().getTextImage(timeSecArray[i], "digital").getWidth();
        }
        String[] pointsArray = Utility.int2StringArray(points, 2);
        int startPoint4 = this.x + 7;
        for (int i = 0; i < pointsArray.length; ++i) {
            Image temp = JBManager.getInstance().getTextImage(pointsArray[i], "tombique-tam");
            g.drawImage(temp, startPoint4, this.y + 26, 0);
            startPoint4 += temp.getWidth();
        }
        String[] levelPointsArray = Utility.int2StringArray(this.levelPoints, 2);
        int startPoint5 = this.x + 40;
        for (int i = 0; i < levelPointsArray.length; ++i) {
            Image temp = JBManager.getInstance().getTextImage(levelPointsArray[i], "tombique-tam");
            g.drawImage(temp, startPoint5, this.y + 26, 0);
            startPoint5 += temp.getWidth();
        }
    }

    public void clear() {
        this.background = null;
        this.timer.cancel();
        this.timer = null;
    }
}

