/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.jbf.menu;

import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.gadget.ScoreCheckerThread;
import com.jarbull.jbf.gadget.VersionCheckerThread;
import com.jarbull.jbf.menu.JBBGImage;
import com.jarbull.jbf.menu.JBElement;
import java.util.Vector;

public class JBMenuNode {
    private String id;
    private String title = "";
    private Vector bgImageVector = new Vector();
    private int top_space = 5;
    private int left_space = 5;
    private int bottom_space = 5;
    private int right_space = 5;
    private int title_padding = 50;
    private String align = "left";
    private Vector allElements = new Vector();
    private Vector visibleElements = new Vector();
    private int selectedElementIndex = 0;
    private String fontKey;
    private String buttonPath;
    private String selectedButtonPath;

    public JBMenuNode(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Vector getBGImages() {
        return this.bgImageVector;
    }

    public void addBGImage(JBBGImage jbbgi) {
        this.bgImageVector.addElement(jbbgi);
    }

    public int getTop_space() {
        return this.top_space;
    }

    public void setTop_space(int top_space) {
        this.top_space = top_space;
    }

    public int getLeft_space() {
        return this.left_space;
    }

    public void setLeft_space(int left_space) {
        this.left_space = left_space;
    }

    public int getBottom_space() {
        return this.bottom_space;
    }

    public void setBottom_space(int bottom_space) {
        this.bottom_space = bottom_space;
    }

    public int getRight_space() {
        return this.right_space;
    }

    public void setRight_space(int right_space) {
        this.right_space = right_space;
    }

    public int getTitle_padding() {
        return this.title_padding;
    }

    public void setTitle_padding(int title_padding) {
        this.title_padding = title_padding;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public void addElement(JBElement element) {
        this.allElements.addElement(element);
    }

    public Vector getElements() {
        return this.allElements;
    }

    public Vector getVisibleElements() {
        return this.visibleElements;
    }

    public void refreshVisibleElements(String refreshAction) {
        this.visibleElements.removeAllElements();
        if (refreshAction != null) {
            if (refreshAction.equals("check:start")) {
                for (int i = 0; i < this.allElements.size(); ++i) {
                    JBElement selElem = (JBElement)this.allElements.elementAt(i);
                    if (selElem.getAction() == null || !selElem.getAction().equals("VN:M0")) continue;
                    this.visibleElements.addElement(selElem);
                }
                this.setTitle(VersionCheckerThread.TITLE_CHECK_START);
            } else if (refreshAction.equals("check:success:A")) {
                for (int i = 0; i < this.allElements.size(); ++i) {
                    JBElement selElem = (JBElement)this.allElements.elementAt(i);
                    this.visibleElements.addElement(selElem);
                }
                this.setTitle(VersionCheckerThread.TITLE_CHECK_SUCCESS_A);
            } else if (refreshAction.equals("check:success:Y")) {
                for (int i = 0; i < this.allElements.size(); ++i) {
                    JBElement selElem = (JBElement)this.allElements.elementAt(i);
                    if (selElem.getAction() == null || !selElem.getAction().equals("VN:M0") && !selElem.getAction().equals("GO:download")) continue;
                    this.visibleElements.addElement(selElem);
                }
                this.setTitle(VersionCheckerThread.TITLE_CHECK_SUCCESS_Y);
            } else if (refreshAction.equals("check:success:N")) {
                for (int i = 0; i < this.allElements.size(); ++i) {
                    JBElement selElem = (JBElement)this.allElements.elementAt(i);
                    if (selElem.getAction() == null || !selElem.getAction().equals("VN:M0")) continue;
                    this.visibleElements.addElement(selElem);
                }
                this.setTitle(VersionCheckerThread.TITLE_CHECK_SUCCESS_N);
            } else if (refreshAction.equals("check:error")) {
                for (int i = 0; i < this.allElements.size(); ++i) {
                    JBElement selElem = (JBElement)this.allElements.elementAt(i);
                    if (selElem.getAction() == null || !selElem.getAction().equals("VN:M0")) continue;
                    this.visibleElements.addElement(selElem);
                }
                this.setTitle(VersionCheckerThread.TITLE_CHECK_ERROR);
            } else if (refreshAction.equals("top:start")) {
                for (int i = 0; i < this.allElements.size(); ++i) {
                    JBElement selElem = (JBElement)this.allElements.elementAt(i);
                    this.visibleElements.addElement(selElem);
                }
                String title = ScoreCheckerThread.TITLE_SCORE_START;
                String myLastScore = JBManager.getInstance().gameSettings.get("score:mylast");
                String myTopScore = JBManager.getInstance().gameSettings.get("score:mytop");
                if (myLastScore != null) {
                    title = ScoreCheckerThread.TITLE_YOUR_SCORE.startsWith("%") ? title + ";" + ScoreCheckerThread.TITLE_YOUR_SCORE + this.toHexFormat(" : " + myLastScore) : title + ";" + ScoreCheckerThread.TITLE_YOUR_SCORE + " : " + myLastScore;
                }
                if (myTopScore != null) {
                    title = ScoreCheckerThread.TITLE_YOUR_TOP_SCORE.startsWith("%") ? title + ";" + ScoreCheckerThread.TITLE_YOUR_TOP_SCORE + this.toHexFormat(" : " + myTopScore) : title + ";" + ScoreCheckerThread.TITLE_YOUR_TOP_SCORE + " : " + myTopScore;
                }
                title = title + ";";
                for (int i = 1; i <= 10; ++i) {
                    String score = JBManager.getInstance().gameSettings.get("score:top" + i);
                    if (score == null) continue;
                    title = title + ";" + score;
                }
                this.setTitle(title);
            } else if (refreshAction.equals("top:error")) {
                for (int i = 0; i < this.allElements.size(); ++i) {
                    JBElement selElem = (JBElement)this.allElements.elementAt(i);
                    if (selElem.getAction() == null || !selElem.getAction().equals("VN:M0")) continue;
                    this.visibleElements.addElement(selElem);
                }
                this.setTitle(ScoreCheckerThread.TITLE_SCORE_ERROR);
            } else if (refreshAction.equals("top:success")) {
                for (int i = 0; i < this.allElements.size(); ++i) {
                    JBElement selElem = (JBElement)this.allElements.elementAt(i);
                    if (selElem.getAction() == null || !selElem.getAction().equals("VN:M0")) continue;
                    this.visibleElements.addElement(selElem);
                }
                String title = ScoreCheckerThread.TITLE_SCORE_START;
                String myLastScore = JBManager.getInstance().gameSettings.get("score:mylast");
                String myTopScore = JBManager.getInstance().gameSettings.get("score:mytop");
                if (myLastScore != null) {
                    title = title + ";" + ScoreCheckerThread.TITLE_YOUR_SCORE + " : " + myLastScore;
                }
                if (myTopScore != null) {
                    title = title + ";" + ScoreCheckerThread.TITLE_YOUR_TOP_SCORE + " : " + myTopScore;
                }
                title = title + ";";
                for (int i = 1; i <= 10; ++i) {
                    String score = JBManager.getInstance().gameSettings.get("score:top" + i);
                    if (score == null) continue;
                    title = title + ";" + score;
                }
                this.setTitle(title);
            } else {
                for (int i = 0; i < this.allElements.size(); ++i) {
                    JBElement selElem = (JBElement)this.allElements.elementAt(i);
                    this.visibleElements.addElement(selElem);
                }
            }
        } else {
            for (int i = 0; i < this.allElements.size(); ++i) {
                JBElement selElem = (JBElement)this.allElements.elementAt(i);
                if (selElem.getConditon() != null && JBManager.getInstance().gameSettings.get(selElem.getConditon()) == null) continue;
                this.visibleElements.addElement(selElem);
            }
        }
        if (this.selectedElementIndex > this.visibleElements.size() - 1) {
            this.selectedElementIndex = 0;
        }
    }

    public int selectNextElement() {
        if (this.allElements.size() == 0) {
            return 0;
        }
        ++this.selectedElementIndex;
        if (this.selectedElementIndex > this.visibleElements.size() - 1) {
            this.selectedElementIndex = 0;
        }
        return this.selectedElementIndex;
    }

    public int selectPrevElement() {
        if (this.allElements.size() == 0) {
            return 0;
        }
        --this.selectedElementIndex;
        if (this.selectedElementIndex < 0) {
            this.selectedElementIndex = this.visibleElements.size() - 1;
        }
        return this.selectedElementIndex;
    }

    public int getSelectedElementIndex() {
        return this.selectedElementIndex;
    }

    public String getFontKey() {
        return this.fontKey;
    }

    public void setFontKey(String fontKey) {
        this.fontKey = fontKey;
    }

    public String getButtonPath() {
        return this.buttonPath;
    }

    public void setButtonPath(String buttonPath) {
        this.buttonPath = buttonPath;
    }

    public String getSelectedButtonPath() {
        return this.selectedButtonPath;
    }

    public void setSelectedButtonPath(String selectedButtonPath) {
        this.selectedButtonPath = selectedButtonPath;
    }

    private String toHexFormat(String text) {
        String output = "";
        for (int i = 0; i < text.length(); ++i) {
            output = output + "%" + Integer.toHexString(text.charAt(i)).toUpperCase();
        }
        return output;
    }
}

