/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.inGame;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class AnimatedObject
extends Sprite {
    int x;
    int y;
    int animationSpeed;
    int frameCount;
    private Timer animationTimer = new Timer();
    private Image defaultImage = null;
    private Image animationImage;
    private int loopCount = 1;

    public AnimatedObject(LayerManager layermanager, Image defaultImage, Image animationImage, int frameCount, int animationSpeedInMSec, int x, int y) {
        super(defaultImage);
        this.defaultImage = defaultImage;
        this.animationImage = animationImage;
        this.x = x;
        this.y = y;
        this.animationSpeed = animationSpeedInMSec;
        this.frameCount = frameCount;
        this.setPosition(x, y);
        layermanager.append((Layer)this);
    }

    public AnimatedObject(LayerManager layermanager, Image animationImage, int frameCount, int animationSpeedInMSec, int x, int y) {
        super(animationImage, animationImage.getWidth() / frameCount, animationImage.getHeight());
        this.animationImage = animationImage;
        this.x = x;
        this.y = y;
        this.animationSpeed = animationSpeedInMSec;
        this.frameCount = frameCount;
        this.setPosition(x, y);
        layermanager.append((Layer)this);
    }

    public void animate() {
        this.setImage(this.animationImage, this.animationImage.getWidth() / this.frameCount, this.animationImage.getHeight());
        this.animationTimer.schedule(new TimerTask(){
            int i = 0;

            public void run() {
                if (this.i == AnimatedObject.this.frameCount * AnimatedObject.this.loopCount) {
                    if (AnimatedObject.this.defaultImage != null) {
                        AnimatedObject.this.setImage(AnimatedObject.this.defaultImage, AnimatedObject.this.defaultImage.getWidth(), AnimatedObject.this.defaultImage.getHeight());
                        AnimatedObject.this.animationImage = null;
                    } else {
                        AnimatedObject.this.setFrame(0);
                    }
                    this.cancel();
                    System.gc();
                } else {
                    AnimatedObject.this.nextFrame();
                }
                ++this.i;
            }
        }, 0L, (long)this.animationSpeed);
    }

    public Image getAnimationImage() {
        return this.animationImage;
    }

    public void setAnimationImage(Image animationImage, int frameCount) {
        this.animationImage = null;
        this.animationImage = animationImage;
        this.setFrameCount(frameCount);
    }

    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setAnimationSpeed(int animationSpeed) {
        this.animationSpeed = animationSpeed;
    }

    public Image getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(Image defaultImage) {
        this.defaultImage = defaultImage;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public void clear() {
        this.defaultImage = null;
        this.animationImage = null;
        this.animationTimer.cancel();
        this.animationTimer = null;
        System.gc();
    }
}

