/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.inGame;

import com.jarbull.basket.inGame.Ball;
import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.Vector2D;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Wall
extends Sprite {
    int width;
    int height;
    int direction;
    boolean checkPixelLevel;
    public static final int DIRECTION_RIGHT = 0;
    public static final int DIRECTION_LEFT = 1;
    public static final int DIRECTION_UP = 2;
    public static final int DIRECTION_DOWN = 3;

    public Wall(int x, int y, int width, int height, int direction) {
        super(Image.createImage((int)width, (int)height));
        this.width = width;
        this.height = height;
        this.direction = direction;
        this.checkPixelLevel = false;
        int[] rgb = new int[width * height];
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = 0;
        }
        Image img = Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)false);
        this.setImage(img, width, height);
        this.setPosition(x, y);
    }

    public Wall(int x, int y, int width, int height, int direction, String imgPath) {
        super(ImageHandler.getInstance().getImage(imgPath));
        this.width = width;
        this.height = height;
        this.direction = direction;
        this.checkPixelLevel = true;
        this.setPosition(x, y);
    }

    public Wall(int x, int y, int direction, Image img) {
        super(img);
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.direction = direction;
        this.checkPixelLevel = true;
        this.setPosition(x, y);
    }

    public boolean checkCollision(Ball ball) {
        return ball.collidesWith(this, this.checkPixelLevel);
    }

    public int getCenterX() {
        return this.getX() + this.getWidth() / 2;
    }

    public int getCenterY() {
        return this.getY() + this.getHeight() / 2;
    }

    public boolean responseCollision(Ball ball, boolean isMovedBack) {
        if (!isMovedBack) {
            ball.moveBack();
            isMovedBack = true;
        }
        if (this.direction == 0) {
            ball.reflect(new Vector2D(1.0, 0.0).normalize());
        } else if (this.direction == 1) {
            ball.reflect(new Vector2D(-1.0, 0.0).normalize());
        } else if (this.direction == 2) {
            ball.reflect(new Vector2D(0.0, -1.0).normalize());
        } else if (this.direction == 3) {
            ball.reflect(new Vector2D(0.0, 1.0).normalize());
        }
        return isMovedBack;
    }
}

