/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import com.jarbull.jbf.JBManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Utility {
    public static final Image[] digitalDigitsArray = new Image[10];

    public static void fillDigitalDigitsArray() {
        for (int i = 0; i < 10; ++i) {
            Utility.digitalDigitsArray[i] = JBManager.getInstance().getTextImage("" + i, "digital");
        }
    }

    public static Image rescaleImage(Image image, int width, int height) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        Image newImage = Image.createImage((int)width, (int)height);
        Graphics g = newImage.getGraphics();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                g.setClip(x, y, 1, 1);
                int dx = x * sourceWidth / width;
                int dy = y * sourceHeight / height;
                g.drawImage(image, x - dx, y - dy, 20);
            }
        }
        return Image.createImage((Image)newImage);
    }

    public static Image blend(Image img, int opacity) {
        int[] rgbdata = new int[img.getWidth() * img.getHeight()];
        img.getRGB(rgbdata, 0, img.getWidth(), 0, 0, img.getWidth(), img.getHeight());
        for (int i = 0; i < rgbdata.length; ++i) {
            int pixel = rgbdata[i];
            int r = (pixel & 0xFF0000) >> 16;
            int g = (pixel & 0xFF00) >> 8;
            int b = (pixel & 0xFF) >> 0;
            rgbdata[i] = (opacity << 24) + (r << 16) + (g << 8) + b;
        }
        return Image.createRGBImage((int[])rgbdata, (int)img.getWidth(), (int)img.getHeight(), (boolean)true);
    }

    public static String[] int2StringArray(int num) {
        String s = Integer.toString(num);
        String[] array = new String[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            array[i] = s.substring(i, i + 1);
        }
        return array;
    }

    public static String[] int2StringArray(int num, int digitNo2Complete) {
        String s = Integer.toString(num);
        while (s.length() < digitNo2Complete) {
            s = "0" + s;
        }
        String[] array = new String[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            array[i] = s.substring(i, i + 1);
        }
        return array;
    }

    public static String replace(String source, String pattern, String replace) {
        if (source != null) {
            int len = pattern.length();
            StringBuffer sb = new StringBuffer();
            int found = -1;
            int start = 0;
            while ((found = source.indexOf(pattern, start)) != -1) {
                sb.append(source.substring(start, found));
                sb.append(replace);
                start = found + len;
            }
            sb.append(source.substring(start));
            return sb.toString();
        }
        return "";
    }
}

