/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.Utility;
import com.jarbull.jbf.JBManager;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TimeZoneinGame {
    private Image timeZone = ImageHandler.getInstance().getImage("/res/img/timeZone_inGame.png");
    private int x;
    private int y;
    public static int shortTime;
    public static int longTime;
    private boolean shortStopped = false;
    private boolean longStopped = false;
    Timer timer = new Timer();

    public TimeZoneinGame() {
        this.timer.schedule(new TimerTask(){
            int i = 0;

            public void run() {
                if (!TimeZoneinGame.this.shortStopped) {
                    TimeZoneinGame.this.decreaseShortTime();
                }
                if (!TimeZoneinGame.this.longStopped) {
                    TimeZoneinGame.this.decreaseLongTime();
                }
            }
        }, 0L, 1000L);
        this.setLocation(7, 274);
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void decreaseShortTime() {
        if (shortTime > 0) {
            --shortTime;
        } else {
            this.shortStopped = true;
            this.longStopped = true;
        }
    }

    public void decreaseLongTime() {
        if (longTime > 0) {
            --longTime;
        }
    }

    public int getWidth() {
        return this.timeZone.getWidth();
    }

    public int getHeight() {
        return this.timeZone.getHeight();
    }

    public int getLongTime() {
        return longTime;
    }

    public int getShortTime() {
        return shortTime;
    }

    public void setLongTime(int longTime) {
        TimeZoneinGame.longTime = longTime;
    }

    public void setShortTime(int shortTime) {
        TimeZoneinGame.shortTime = shortTime;
    }

    public void stopShortTime() {
        this.shortStopped = true;
    }

    public void stopLongTime() {
        this.longStopped = true;
    }

    public void paint(Graphics g) {
        g.drawImage(this.timeZone, this.x, this.y, 0);
        String[] shortTimeArray = Utility.int2StringArray(shortTime, 2);
        int startPoint = this.x + 34;
        for (int i = 0; i < shortTimeArray.length; ++i) {
            g.drawImage(Utility.digitalDigitsArray[Integer.parseInt(shortTimeArray[i])], startPoint, this.y + 4, 0);
            startPoint += Utility.digitalDigitsArray[Integer.parseInt(shortTimeArray[i])].getWidth();
        }
        g.drawImage(JBManager.getInstance().getTextImage(":", "tombique-tam"), this.x + 59, this.y + 22, 0);
        String[] longTimeMinArray = Utility.int2StringArray(longTime / 60, 2);
        int startPoint2 = this.x + 35;
        for (int i = 0; i < longTimeMinArray.length; ++i) {
            g.drawImage(JBManager.getInstance().getTextImage(longTimeMinArray[i], "tombique-tam"), startPoint2, this.y + 22, 0);
            startPoint2 += JBManager.getInstance().getTextImage(longTimeMinArray[i], "tombique-tam").getWidth();
        }
        String[] longTimeSecArray = Utility.int2StringArray(longTime % 60, 2);
        int startPoint3 = this.x + 64;
        for (int i = 0; i < longTimeSecArray.length; ++i) {
            g.drawImage(JBManager.getInstance().getTextImage(longTimeSecArray[i], "tombique-tam"), startPoint3, this.y + 22, 0);
            startPoint3 += JBManager.getInstance().getTextImage(longTimeSecArray[i], "tombique-tam").getWidth();
        }
        if (shortTime == 0) {
            g.setColor(0xFF0000);
            g.drawRect(this.x + 32, this.y + 1, 30, 20);
            g.drawRect(this.x + 31, this.y + 0, 32, 22);
        }
    }

    public void kill() {
        this.timer.cancel();
        this.timer = null;
        this.timeZone = null;
    }
}

