/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.game;

import com.jarbull.basket.game.BasketCanvas;
import com.jarbull.basket.game.CommentaryScreenCanvas;
import com.jarbull.basket.inGame.Ball;
import com.jarbull.basket.inGame.Golge;
import com.jarbull.basket.inGame.Pota;
import com.jarbull.basket.inGame.Wall;
import com.jarbull.basket.tools.Case;
import com.jarbull.basket.tools.CaseHandler;
import com.jarbull.basket.tools.DirectionAssistant;
import com.jarbull.basket.tools.Gauge;
import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.MathEx;
import com.jarbull.basket.tools.RandomGenerator;
import com.jarbull.basket.tools.ScoreAndTimeInCommentary;
import com.jarbull.basket.tools.ScoreBoardinGame;
import com.jarbull.basket.tools.ShotChoiceZone;
import com.jarbull.basket.tools.TimeZoneinGame;
import com.jarbull.basket.tools.XmlDataHolder;
import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBManager;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.TiledLayer;

public class BasketProcessor
implements Runnable {
    public byte shootType;
    public static boolean isRunning;
    public static boolean isPaused;
    private Thread t;
    public LayerManager layerManager;
    boolean vibrationOn = true;
    boolean sfxOn;
    Ball ball;
    Golge golge;
    Pota pota;
    DirectionAssistant assistant = new DirectionAssistant();
    boolean shootDone = false;
    BasketCanvas canvas;
    Gauge gauge;
    Wall normalZemin;
    Wall ilkZemin;
    public static int basketCounter;
    boolean prepareObjectsFinished = false;
    ScoreBoardinGame scoreBoard;
    TimeZoneinGame timeZone;
    int zeminCrashCount;
    public boolean firePressed = false;
    int counterForBB = 0;

    public BasketProcessor(BasketCanvas canvas) throws Exception {
        this.layerManager = new LayerManager();
        this.canvas = canvas;
        this.gauge = new Gauge();
        this.gauge.setVisible(true);
        isRunning = true;
        isPaused = false;
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void kill() {
        isRunning = false;
    }

    public void pause() {
        isPaused = true;
    }

    public void waitForClose() {
        try {
            this.t.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void shoot() {
        this.pota.ballXbeforeShoot = this.ball.getX();
        this.pota.ballYbeforeShoot = this.ball.getY();
        this.pota.check1 = false;
        this.ball.fileyeCarpti = false;
        this.ball.basketOldu = false;
        double angle = this.assistant.getAngle();
        double angleRadian = Math.toRadians(angle);
        double velocity = this.gauge.getValue() / 10 + 8;
        this.gauge.setVisible(false);
        this.ball.velocityX = velocity * Math.cos(angleRadian);
        this.ball.velocityY = velocity * Math.sin(angleRadian);
        this.assistant.visible = false;
        this.shootDone = true;
    }

    public void prepareObjects() {
        this.prepareObjectsFinished = false;
        try {
            this.pota = new Pota(this.layerManager, 0, 20);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            this.ball = new Ball(this.layerManager, 180, 210);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        RandomGenerator.getInstance().generateBallPlace(this.ball, ShotChoiceZone.dialogResult);
        TiledLayer backLayer = new TiledLayer(1, 1, ImageHandler.getInstance().getImage("/res/img/bg.png"), 240, 320);
        backLayer.setCell(0, 0, 1);
        backLayer.setPosition(0, 0);
        this.layerManager.append((Layer)backLayer);
        this.assistant.attachBall(this.ball);
        this.assistant.visible = true;
        this.assistant.setAngle((this.calculateAssistantAngle() + 180) % 360);
        this.gauge.setSize(75, 9);
        this.gauge.setVisible(true);
        this.golge = new Golge(this.layerManager, this.ball.getX(), this.ball.getY() + 20);
        this.golge.attachBall(this.ball);
        this.golge.setPosition(this.ball.getX(), this.ball.getY() + 20);
        this.scoreBoard = new ScoreBoardinGame((String)XmlDataHolder.getInstance().homeTeamInfo.get("nameShort"), (String)XmlDataHolder.getInstance().levelOpponentTeamInfo.get("nameShort"), ShotChoiceZone.dialogResult);
        this.timeZone = new TimeZoneinGame();
        this.normalZemin = this.generateZemin();
        this.ilkZemin = this.generateZemin(this.ball);
        this.shootDone = false;
        this.zeminCrashCount = 0;
        ScoreBoardinGame.setHomeScore(ScoreAndTimeInCommentary.homeScore);
        ScoreBoardinGame.setAwayScore(ScoreAndTimeInCommentary.awayScore);
        this.timeZone.setLongTime(ScoreAndTimeInCommentary.longTime);
        this.timeZone.setShortTime(ScoreAndTimeInCommentary.shortTime);
        this.prepareObjectsFinished = true;
    }

    public void keyPressed() {
        int keyCode = this.canvas.getKeyStates();
        if ((keyCode & 4) != 0 && this.assistant.getAngle() > 180.0) {
            this.assistant.decreaseAngle();
        }
        if ((keyCode & 0x20) != 0 && this.assistant.getAngle() < 270.0) {
            this.assistant.increaseAngle();
        }
        if ((keyCode & 0x100) != 0 && !this.shootDone && TimeZoneinGame.shortTime > 0) {
            this.shoot();
        }
    }

    public void run() {
        this.prepareObjects();
        while (isRunning && BasketCanvas.isRunning) {
            if (!isPaused) {
                this.checkTime();
                this.keyPressed();
                if (this.shootDone) {
                    this.ball.move();
                    this.golge.move();
                    this.checkCollisions();
                }
            }
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        ScoreAndTimeInCommentary.homeScore = this.scoreBoard.getHomeScore();
        ScoreAndTimeInCommentary.awayScore = this.scoreBoard.getAwayScore();
        ScoreAndTimeInCommentary.longTime = this.timeZone.getLongTime();
        ScoreAndTimeInCommentary.shortTime = this.timeZone.getShortTime();
        this.clear();
        BasketCanvas.isRunning = false;
        ImageHandler.getInstance().clearImageBuffer();
        JBManager.getInstance().clearFonts();
        JBManager.getInstance().addAction(new JBAction(this, "clearti"));
        System.gc();
    }

    private void checkCollisions() {
        this.pota.checkCollision(this.ball);
        if (this.ball.velocityX > 0.0 && this.ball.velocityY > 0.0) {
            if (this.normalZemin.checkCollision(this.ball)) {
                this.normalZemin.responseCollision(this.ball, false);
                if (!this.ball.basketOldu && CaseHandler.getInstance().currentCase != (Case)XmlDataHolder.getInstance().cases.get("home-missed")) {
                    CaseHandler.getInstance().currentCase = (Case)XmlDataHolder.getInstance().cases.get("home-missed");
                    CommentaryScreenCanvas.slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                    try {
                        CommentaryScreenCanvas.caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                    }
                    catch (IOException ex) {
                        CommentaryScreenCanvas.caseImage = null;
                    }
                }
                ++this.zeminCrashCount;
            }
        } else if (this.ilkZemin.checkCollision(this.ball)) {
            this.ilkZemin.responseCollision(this.ball, false);
            if (!this.ball.basketOldu && CaseHandler.getInstance().currentCase != (Case)XmlDataHolder.getInstance().cases.get("home-missed")) {
                CaseHandler.getInstance().currentCase = (Case)XmlDataHolder.getInstance().cases.get("home-missed");
                CommentaryScreenCanvas.slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                try {
                    CommentaryScreenCanvas.caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                }
                catch (IOException ex) {
                    CommentaryScreenCanvas.caseImage = null;
                }
            }
            ++this.zeminCrashCount;
        }
        if (this.ball.getX() < -10) {
            CaseHandler.getInstance().currentCase = (Case)XmlDataHolder.getInstance().cases.get("home-outofbounds");
            CommentaryScreenCanvas.slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
            try {
                CommentaryScreenCanvas.caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
            }
            catch (IOException ex) {
                CommentaryScreenCanvas.caseImage = null;
            }
        }
        if (this.ball.getX() > BasketCanvas.canvasWidth && !this.ball.basketOldu && CaseHandler.getInstance().currentCase != (Case)XmlDataHolder.getInstance().cases.get("home-missed")) {
            CaseHandler.getInstance().currentCase = (Case)XmlDataHolder.getInstance().cases.get("home-missed");
            CommentaryScreenCanvas.slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
            try {
                CommentaryScreenCanvas.caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
            }
            catch (IOException ex) {
                CommentaryScreenCanvas.caseImage = null;
            }
        }
        if (this.zeminCrashCount > 1 || this.ball.getX() < -10 || this.ball.getX() > BasketCanvas.canvasWidth || this.ball.getY() > BasketCanvas.canvasHeigth) {
            isPaused = true;
            for (int i = this.layerManager.getSize() - 1; i >= 0; --i) {
                this.layerManager.remove(this.layerManager.getLayerAt(0));
            }
            isRunning = false;
        }
    }

    private void checkTime() {
        if (!(this.shootDone || TimeZoneinGame.shortTime >= 1 && TimeZoneinGame.longTime >= 1)) {
            this.kill();
        }
    }

    public int calculateAssistantAngle() {
        double radians = MathEx.atan(this.ball.getY() + this.ball.getHeight() / 2 - (this.pota.getY() + this.pota.getHeight() / 2), this.ball.getX() + this.ball.getWidth() / 2 - (this.pota.getX() + this.pota.getWidth() / 2));
        return (int)Math.toDegrees(radians);
    }

    private Wall generateZemin() {
        Image zeminImg_1 = Image.createImage((int)240, (int)24);
        zeminImg_1 = Image.createImage((int)240, (int)24);
        Graphics g = zeminImg_1.getGraphics();
        g.drawLine(0, 0, zeminImg_1.getWidth(), zeminImg_1.getHeight());
        int[] rgbData = new int[zeminImg_1.getWidth() * zeminImg_1.getHeight()];
        rgbData = new int[zeminImg_1.getWidth() * zeminImg_1.getHeight()];
        zeminImg_1.getRGB(rgbData, 0, zeminImg_1.getWidth(), 0, 0, zeminImg_1.getWidth(), zeminImg_1.getHeight());
        for (int i = 0; i < zeminImg_1.getWidth() * zeminImg_1.getHeight(); ++i) {
            if ((rgbData[i] & 0xFFFFFF) >> 16 <= 200) continue;
            rgbData[i] = 0;
        }
        zeminImg_1 = Image.createRGBImage((int[])rgbData, (int)zeminImg_1.getWidth(), (int)zeminImg_1.getHeight(), (boolean)true);
        Wall zemin = new Wall(0, 180, 2, zeminImg_1);
        return zemin;
    }

    private Wall generateZemin(Ball ball) {
        Image zeminImg = Image.createImage((int)ball.getCenterX(), (int)(ball.getCenterY() - 180 + 20));
        zeminImg = Image.createImage((int)ball.getCenterX(), (int)(ball.getCenterY() - 180 + 20));
        Graphics g = zeminImg.getGraphics();
        g.drawLine(0, 0, zeminImg.getWidth(), zeminImg.getHeight());
        int[] rgbData = new int[zeminImg.getWidth() * zeminImg.getHeight()];
        zeminImg.getRGB(rgbData, 0, zeminImg.getWidth(), 0, 0, zeminImg.getWidth(), zeminImg.getHeight());
        for (int i = 0; i < zeminImg.getWidth() * zeminImg.getHeight(); ++i) {
            if ((rgbData[i] & 0xFFFFFF) >> 16 <= 200) continue;
            rgbData[i] = 0;
        }
        zeminImg = Image.createRGBImage((int[])rgbData, (int)zeminImg.getWidth(), (int)zeminImg.getHeight(), (boolean)true);
        Wall zemin = new Wall(0, 180, 2, zeminImg);
        return zemin;
    }

    public void clear() {
        this.pota.clear();
        this.ball.kill();
        this.timeZone.kill();
        this.golge = null;
        this.normalZemin = null;
        this.ilkZemin = null;
        this.scoreBoard.clear();
        for (int i = this.layerManager.getSize() - 1; i > -1; --i) {
            this.layerManager.remove(this.layerManager.getLayerAt(0));
        }
        this.layerManager = null;
    }
}

