/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.screens;

import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.Team;
import com.jarbull.basket.tools.XmlDataHolder;
import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import java.util.Enumeration;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class RaceSelectionScreenSmall
extends Canvas
implements Runnable {
    private MIDlet midlet;
    private Displayable previousScreen;
    private Thread thread;
    private boolean exit = false;
    private final int screenWidth;
    private final int screenHeight;
    public final Team[] teams;
    private final Image[] teamsImages;
    private final Image[] teamNamesImages;
    private int selectedRaceIndex;
    private int selectionColor;
    private boolean incSelectionColor;

    public RaceSelectionScreenSmall(MIDlet midlet) {
        this.midlet = midlet;
        this.selectedRaceIndex = 0;
        this.selectionColor = 0;
        this.incSelectionColor = true;
        this.previousScreen = Display.getDisplay((MIDlet)midlet).getCurrent();
        this.setFullScreenMode(true);
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.teams = new Team[XmlDataHolder.getInstance().teams.size()];
        int i = 0;
        Enumeration it = XmlDataHolder.getInstance().teams.keys();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            String[] temp = (String[])XmlDataHolder.getInstance().teams.get(key);
            this.teams[i] = new Team();
            this.teams[i].setLongName(key);
            this.teams[i].setShortName(temp[0]);
            this.teams[i].setImagePath("/res/img/bayraklar/" + temp[0] + ".png");
            this.teams[i].setLevel(Integer.parseInt(temp[2]));
            ++i;
        }
        this.teamsImages = new Image[this.teams.length];
        this.teamNamesImages = new Image[this.teams.length];
        for (int k = 0; k < this.teams.length; ++k) {
            this.teamsImages[k] = ImageHandler.getInstance().getImage(this.teams[k].getImagePath());
            this.teamNamesImages[k] = JBManager.getInstance().getTextImage(this.teams[k].getShortName(), "10x10-beyaz");
        }
        JBManager.getInstance().addAction(new JBAction(this, "clearti"));
    }

    public void setNextScreen(Displayable displayable) {
        this.previousScreen = displayable;
    }

    public Team getDialogResult() {
        return this.teams[this.selectedRaceIndex];
    }

    public void show() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void waitForClose() {
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    protected void keyPressed(int keyCode) {
        keyCode = KeyCodeAdapter.getInstance().adoptKeyCode(keyCode);
        switch (keyCode) {
            case -203: 
            case 205: 
            case 225: {
                this.exit = true;
                break;
            }
            case 223: {
                if (this.selectedRaceIndex <= 0) break;
                --this.selectedRaceIndex;
                break;
            }
            case 224: {
                if (this.selectedRaceIndex >= this.teams.length - 1) break;
                ++this.selectedRaceIndex;
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        for (int i = this.teams.length - 1; i >= 0; --i) {
            if (x < this.teams[i].getImagePosX() - this.teamsImages[i].getWidth() / 4 || x >= this.teams[i].getImagePosX() + this.teamsImages[i].getWidth() / 4 || y < this.teams[i].getImagePosY() - this.teamsImages[i].getHeight() / 2 || y >= this.teams[i].getImagePosY() + this.teamsImages[i].getHeight() / 2) continue;
            this.selectedRaceIndex = i;
            this.exit = true;
            break;
        }
    }

    protected void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        g.drawImage(JBManager.getInstance().getTextImage("SELECT YOUR TEAM", "10x10-beyaz"), 80, 5, 0);
        g.drawImage(this.teamsImages[this.selectedRaceIndex], this.screenWidth / 2 - this.teamsImages[this.selectedRaceIndex].getWidth() / 2, this.screenHeight / 2 - this.teamsImages[this.selectedRaceIndex].getHeight() / 2, 0);
        g.drawImage(this.teamNamesImages[this.selectedRaceIndex], this.screenWidth / 2 - this.teamNamesImages[this.selectedRaceIndex].getWidth() / 2, this.screenHeight / 2 - this.teamsImages[this.selectedRaceIndex].getHeight() / 2 + 20, 0);
        if (this.selectedRaceIndex > 0) {
            g.drawImage(JBManager.getInstance().getTextImage("<", "10x10-beyaz"), this.screenWidth / 2 - this.teamsImages[this.selectedRaceIndex].getWidth() / 2 - 15, this.screenHeight / 2 - this.teamsImages[this.selectedRaceIndex].getHeight() / 2 + 10, 0);
        }
        if (this.selectedRaceIndex < this.teams.length - 1) {
            g.drawImage(JBManager.getInstance().getTextImage(">", "10x10-beyaz"), this.screenWidth / 2 - this.teamsImages[this.selectedRaceIndex].getWidth() / 2 + 30, this.screenHeight / 2 - this.teamsImages[this.selectedRaceIndex].getHeight() / 2 + 10, 0);
        }
    }

    public void run() {
        while (!this.exit) {
            this.repaint();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.previousScreen);
        for (int i = this.teamNamesImages.length - 1; i > -1; --i) {
            this.teamNamesImages[i] = null;
            this.teamsImages[i] = null;
        }
        System.gc();
        ImageHandler.getInstance().clearImageBuffer();
        JBManager.getInstance().addAction(new JBAction(this, "clearti"));
    }
}

