/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import com.jarbull.basket.tools.Case;
import com.jarbull.basket.tools.RandomGenerator;
import com.jarbull.basket.tools.XmlDataHolder;
import java.io.InputStream;
import java.util.Vector;

public class XML_Parser {
    public String emp;
    String data;

    public XML_Parser() {
        this.emp = "/res/inGame/holy_" + XmlDataHolder.getInstance().levelNo + ".xml";
    }

    private String file() {
        InputStream is = this.getClass().getResourceAsStream(this.emp);
        StringBuffer sb = new StringBuffer();
        try {
            int chars;
            boolean i = false;
            while ((chars = is.read()) != -1) {
                sb.append((char)chars);
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void parseFile(String levelNo) {
        this.data = this.file();
        System.gc();
        this.parseLevelGeneralInfo(this.data, levelNo);
        this.parseCases(this.data, levelNo);
        this.parseAndChooseTeams(this.data, levelNo);
        this.data = null;
        System.gc();
    }

    public static void chooseOpponent() {
        int index = RandomGenerator.getInstance().generateRandomBetween(0, XmlDataHolder.getInstance().selectedTeams.size() - 1);
        String teamData = XmlDataHolder.getInstance().selectedTeams.elementAt(index).toString();
        if (XML_Parser.getTag(teamData, "name_short").equals(XmlDataHolder.getInstance().homeTeamInfo.get("nameShort"))) {
            XmlDataHolder.getInstance().selectedTeams.removeElementAt(index);
            index = RandomGenerator.getInstance().generateRandomBetween(0, XmlDataHolder.getInstance().selectedTeams.size() - 1);
            teamData = XmlDataHolder.getInstance().selectedTeams.elementAt(index).toString();
        }
        XmlDataHolder.getInstance().levelOpponentTeamInfo.put("name", XML_Parser.getTag(teamData, "name"));
        XmlDataHolder.getInstance().levelOpponentTeamInfo.put("nameShort", XML_Parser.getTag(teamData, "name_short"));
        XmlDataHolder.getInstance().levelOpponentTeamInfo.put("flagPath", "/res/img/bayraklar/" + XML_Parser.getTag(teamData, "name_short") + ".png");
        XmlDataHolder.getInstance().levelOpponentTeamInfo.put("level", XML_Parser.getTag(teamData, "level"));
    }

    private void parseAndChooseTeams(String data, String levelNo) {
        String teamData;
        String levelTeamsData = this.filterLevelOrTag(data, "teams");
        Vector teamsData = this.filterParent(levelTeamsData, "team", null);
        Vector selectedTeams = new Vector();
        for (int i = 0; i < teamsData.size(); ++i) {
            teamData = teamsData.elementAt(i).toString();
            String teamName = XML_Parser.getTag(teamData, "name");
            String teamNameShort = XML_Parser.getTag(teamData, "name_short");
            String flagPath = XML_Parser.getTag(teamData, "flag_path");
            String level = XML_Parser.getTag(teamData, "level");
            XmlDataHolder.getInstance().teams.put(teamName, new String[]{teamNameShort, flagPath, level});
            if (!("level_" + level).equals(levelNo)) continue;
            selectedTeams.addElement(teamsData.elementAt(i));
        }
        XmlDataHolder.getInstance().selectedTeams = selectedTeams;
        int index = RandomGenerator.getInstance().generateRandomBetween(0, selectedTeams.size() - 1);
        teamData = selectedTeams.elementAt(index).toString();
        XmlDataHolder.getInstance().levelOpponentTeamInfo.put("name", XML_Parser.getTag(teamData, "name"));
        XmlDataHolder.getInstance().levelOpponentTeamInfo.put("nameShort", XML_Parser.getTag(teamData, "name_short"));
        XmlDataHolder.getInstance().levelOpponentTeamInfo.put("flagPath", "/res/img/bayraklar/" + XML_Parser.getTag(teamData, "name_short") + ".png");
        XmlDataHolder.getInstance().levelOpponentTeamInfo.put("level", XML_Parser.getTag(teamData, "level"));
        teamsData.removeAllElements();
        levelTeamsData = null;
        teamsData = null;
        data = null;
        levelTeamsData = null;
    }

    private void parseLevelGeneralInfo(String data, String levelNo) {
        String levelData = this.filterLevelOrTag(data, levelNo);
        String levelInfoData = this.filterLevelOrTag(levelData, "info");
        String a = XML_Parser.getTag(levelInfoData, "remaining_time_long_random_start_inSec");
        String b = XML_Parser.getTag(levelInfoData, "remaining_time_long_random_end_inSec");
        int remainingTimeLong = RandomGenerator.getInstance().generateRandomBetween(Integer.parseInt(a), Integer.parseInt(b));
        XmlDataHolder.getInstance().levelGeneralInfo.put("remainingTimeLong", String.valueOf(remainingTimeLong));
        a = XML_Parser.getTag(levelInfoData, "remaining_time_short_random_start_inSec");
        b = XML_Parser.getTag(levelInfoData, "remaining_time_short_random_end_inSec");
        int remainingTimeShort = RandomGenerator.getInstance().generateRandomBetween(Integer.parseInt(a), Integer.parseInt(b));
        XmlDataHolder.getInstance().levelGeneralInfo.put("remainingTimeShort", String.valueOf(remainingTimeShort));
        a = XML_Parser.getTag(levelInfoData, "home_team_score_start");
        b = XML_Parser.getTag(levelInfoData, "home_team_score_end");
        int homeTeamScore = RandomGenerator.getInstance().generateRandomBetween(Integer.parseInt(a), Integer.parseInt(b));
        XmlDataHolder.getInstance().levelGeneralInfo.put("homeTeamScore", String.valueOf(homeTeamScore));
        a = XML_Parser.getTag(levelInfoData, "opponent_team_difference_start");
        b = XML_Parser.getTag(levelInfoData, "opponent_team_difference_end");
        int opTeamScore = homeTeamScore + RandomGenerator.getInstance().generateRandomBetween(Integer.parseInt(a), Integer.parseInt(b));
        XmlDataHolder.getInstance().levelGeneralInfo.put("opTeamScore", String.valueOf(opTeamScore));
        data = null;
        levelData = null;
        levelInfoData = null;
    }

    private void parseCases(String data, String levelNo) {
        String levelData = this.filterLevelOrTag(data, levelNo);
        String opponentCases = this.filterLevelOrTag(levelData, "opponent_cases");
        Vector cases = this.filterParent(opponentCases, "case", null);
        for (int i = 0; i < cases.size(); ++i) {
            String caseData = cases.elementAt(i).toString();
            Case tempCase = new Case();
            String caseName = XML_Parser.getTag(caseData, "name");
            String caseTimeStart = XML_Parser.getTag(caseData, "time_start");
            String caseTimeEnd = XML_Parser.getTag(caseData, "time_end");
            String caseImagePath = XML_Parser.getTag(caseData, "case_image");
            String caseText = XML_Parser.getTag(caseData, "text");
            String caseAction = XML_Parser.getTag(caseData, "action");
            String nextCases = this.filterLevelOrTag(caseData, "next_cases");
            Vector nextCasesVector = this.filterParent(nextCases, "next_case", null);
            for (int k = 0; k < nextCasesVector.size(); ++k) {
                String nextCaseData = nextCasesVector.elementAt(k).toString();
                tempCase.nextCases.put(XML_Parser.getTag(nextCaseData, "name"), XML_Parser.getTag(nextCaseData, "percentage"));
            }
            tempCase.setName(caseName);
            tempCase.setText(caseText);
            tempCase.setCaseImagePath(caseImagePath);
            tempCase.setTimeStart(Integer.parseInt(caseTimeStart));
            tempCase.setTimeEnd(Integer.parseInt(caseTimeEnd));
            tempCase.setAction(caseAction);
            XmlDataHolder.getInstance().cases.put(caseName, tempCase);
        }
        String homeTeamCases = this.filterLevelOrTag(data, "home_team_cases");
        Vector homeCases = this.filterParent(homeTeamCases, "case", null);
        for (int i = 0; i < homeCases.size(); ++i) {
            String caseData = homeCases.elementAt(i).toString();
            Case tempCase = new Case();
            String caseName = XML_Parser.getTag(caseData, "name");
            String caseTimeStart = XML_Parser.getTag(caseData, "time_start");
            String caseTimeEnd = XML_Parser.getTag(caseData, "time_end");
            String caseImagePath = XML_Parser.getTag(caseData, "case_image");
            String caseText = XML_Parser.getTag(caseData, "text");
            String caseAction = XML_Parser.getTag(caseData, "action");
            String nextCases = this.filterLevelOrTag(caseData, "next_cases");
            Vector nextCasesVector = this.filterParent(nextCases, "next_case", null);
            for (int k = 0; k < nextCasesVector.size(); ++k) {
                String nextCaseData = nextCasesVector.elementAt(k).toString();
                tempCase.nextCases.put(XML_Parser.getTag(nextCaseData, "name"), XML_Parser.getTag(nextCaseData, "percentage"));
            }
            tempCase.setName(caseName);
            tempCase.setText(caseText);
            tempCase.setCaseImagePath(caseImagePath);
            tempCase.setTimeEnd(Integer.parseInt(caseTimeEnd));
            tempCase.setTimeStart(Integer.parseInt(caseTimeStart));
            tempCase.setAction(caseAction);
            XmlDataHolder.getInstance().cases.put(caseName, tempCase);
        }
        data = null;
        levelData = null;
        opponentCases = null;
        homeCases = null;
        homeTeamCases = null;
        cases = null;
    }

    public static String getTag(String data, String tag) {
        String startTag = "<" + tag + ">";
        String finishTag = "</" + tag + ">";
        int acma = 0;
        int kapama = 0;
        if (data.indexOf(startTag) != -1) {
            acma = data.indexOf(startTag) + startTag.length();
        }
        if (data.indexOf(finishTag) != -1) {
            kapama = data.indexOf(finishTag);
        }
        if (acma == 0 || kapama == 0) {
            // empty if block
        }
        return data.substring(acma, kapama);
    }

    private Vector filterParent(String data, String parent, Vector indices) {
        if (indices == null) {
            indices = new Vector<String>();
        }
        int acma = 0;
        int kapama = 0;
        String startTag = "<" + parent + ">";
        String finishTag = "</" + parent + ">";
        if (data.indexOf(startTag) != -1) {
            acma = data.indexOf(startTag) + startTag.length();
        }
        if (data.indexOf(finishTag) != -1) {
            kapama = data.indexOf(finishTag) + finishTag.length();
        }
        indices.addElement(data.substring(acma, kapama));
        if (data.indexOf(startTag, kapama) != -1) {
            this.filterParent(data.substring(kapama), parent, indices);
        }
        return indices;
    }

    private String filterLevelOrTag(String data, String tagOrLevelNo) {
        int acma = 0;
        int kapama = 0;
        String startTag = "<" + tagOrLevelNo + ">";
        String finishTag = "</" + tagOrLevelNo + ">";
        if (data.indexOf(startTag) != -1) {
            acma = data.indexOf(startTag) + startTag.length();
        }
        if (data.indexOf(finishTag) != -1) {
            kapama = data.indexOf(finishTag);
        }
        if (acma == 0 || kapama == 0) {
            // empty if block
        }
        return data.substring(acma, kapama);
    }
}

