/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import com.jarbull.basket.inGame.Ball;
import javax.microedition.lcdui.Graphics;

public class DirectionAssistant {
    public static final int DEFAULT_COLOR = 0xFFFF00;
    public static final int ANGLE_SLICE = 120;
    private static final int DIRECTION_HELPER_RADIUS = 30;
    private double angle = 0.0;
    private int x = 0;
    private int y = 0;
    public boolean visible = false;
    private Ball ball;

    public void attachBall(Ball ball) {
        this.ball = ball;
        this.x = ball.getX() + ball.getWidth() / 2;
        this.y = ball.getY() + ball.getHeight() / 2;
    }

    public double getAngle() {
        if (this.angle < 0.0) {
            this.angle += 360.0;
        }
        this.angle %= 360.0;
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void increaseAngle() {
        this.angle += 3.0;
    }

    public void increaseAngle90() {
        this.angle += 90.0;
    }

    public void decreaseAngle() {
        this.angle -= 3.0;
        if (this.angle < 0.0) {
            this.angle += 360.0;
        }
    }

    public void decreaseAngle90() {
        this.angle -= 90.0;
        if (this.angle < 0.0) {
            this.angle += 360.0;
        }
    }

    public void paint(Graphics g, int x, int y) {
        if (!this.visible) {
            return;
        }
        if (this.ball != null) {
            this.x = x + this.ball.getX() + this.ball.getWidth() / 2;
            this.y = y + this.ball.getY() + this.ball.getHeight() / 2;
        }
        double angleRadian = Math.toRadians(this.angle);
        g.setStrokeStyle(1);
        g.setColor(0xFFFF00);
        g.drawLine(this.x, this.y, this.x + (int)(30.0 * Math.cos(angleRadian)), this.y + (int)(30.0 * Math.sin(angleRadian)));
    }
}

