/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import com.jarbull.basket.game.CommentaryScreenCanvas;
import com.jarbull.basket.tools.TimeZoneinGame;
import com.jarbull.basket.tools.Utility;
import com.jarbull.basket.tools.XmlDataHolder;
import com.jarbull.jbf.JBManager;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScoreAndTimeInCommentary {
    private int x;
    private int y;
    public static int shortTime;
    public static int longTime;
    public static boolean shortStopped;
    public static boolean longStopped;
    public static int homeScore;
    public static int awayScore;
    Timer timer;
    public String homeName_short;
    public String awayName_short;
    public Image homeFlag;
    public Image awayFlag;

    public ScoreAndTimeInCommentary() {
        this.homeName_short = (String)XmlDataHolder.getInstance().homeTeamInfo.get("nameShort");
        this.awayName_short = (String)XmlDataHolder.getInstance().levelOpponentTeamInfo.get("nameShort");
        shortStopped = false;
        longStopped = false;
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){
            int i = 0;

            public void run() {
                if (!shortStopped) {
                    ScoreAndTimeInCommentary.this.decreaseShortTime();
                    ScoreAndTimeInCommentary.this.decreaseCurrentCaseTime();
                }
                if (!longStopped) {
                    ScoreAndTimeInCommentary.this.decreaseLongTime();
                }
            }
        }, 0L, 1000L);
        this.setLocation(7, 274);
    }

    public static void increaseHomeScore(int amount) {
        homeScore += amount;
    }

    public static void increaseAwayScore(int amount) {
        awayScore += amount;
    }

    public int getAwayScore() {
        return awayScore;
    }

    public int getHomeScore() {
        return homeScore;
    }

    public static void setAwayScore(int awayScore) {
        ScoreAndTimeInCommentary.awayScore = awayScore;
    }

    public static void setHomeScore(int homeScore) {
        ScoreAndTimeInCommentary.homeScore = homeScore;
    }

    public void decreaseCurrentCaseTime() {
        --CommentaryScreenCanvas.currentCaseTime;
    }

    public void decreaseShortTime() {
        if (shortTime > 0) {
            --shortTime;
        } else {
            shortStopped = true;
            longStopped = true;
        }
    }

    public void decreaseLongTime() {
        if (longTime > 0) {
            --longTime;
        } else {
            shortStopped = true;
            longStopped = true;
        }
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setLongTime(int longTime) {
        TimeZoneinGame.longTime = longTime;
    }

    public void setShortTime(int shortTime) {
        TimeZoneinGame.shortTime = shortTime;
    }

    public void stopShortTime() {
        shortStopped = true;
    }

    public void stopLongTime() {
        longStopped = true;
    }

    public void startShortTime() {
        shortStopped = false;
    }

    public void startLongTime() {
        longStopped = false;
    }

    public static int getLongTime() {
        return longTime;
    }

    public static int getShortTime() {
        return shortTime;
    }

    public void paint(Graphics g) {
        g.drawImage(this.homeFlag, this.x, this.y, 0);
        g.drawImage(this.awayFlag, this.x + 81, this.y, 0);
        String[] shortTimeArray = Utility.int2StringArray(shortTime, 2);
        int startPoint = this.x + 39;
        for (int i = 0; i < shortTimeArray.length; ++i) {
            g.drawImage(Utility.digitalDigitsArray[Integer.parseInt(shortTimeArray[i])], startPoint, this.y + 0, 0);
            startPoint += Utility.digitalDigitsArray[Integer.parseInt(shortTimeArray[i])].getWidth();
        }
        g.drawImage(JBManager.getInstance().getTextImage(":", "tombique-tam"), this.x + 51, this.y + 22, 0);
        String[] longTimeMinArray = Utility.int2StringArray(longTime / 60, 2);
        int startPoint2 = this.x + 27;
        for (int i = 0; i < longTimeMinArray.length; ++i) {
            g.drawImage(JBManager.getInstance().getTextImage(longTimeMinArray[i], "tombique-tam"), startPoint2, this.y + 22, 0);
            startPoint2 += JBManager.getInstance().getTextImage(longTimeMinArray[i], "tombique-tam").getWidth();
        }
        String[] longTimeSecArray = Utility.int2StringArray(longTime % 60, 2);
        int startPoint3 = this.x + 56;
        for (int i = 0; i < longTimeSecArray.length; ++i) {
            g.drawImage(JBManager.getInstance().getTextImage(longTimeSecArray[i], "tombique-tam"), startPoint3, this.y + 22, 0);
            startPoint3 += JBManager.getInstance().getTextImage(longTimeSecArray[i], "tombique-tam").getWidth();
        }
        String[] homeScoreArray = Utility.int2StringArray(homeScore);
        int startPoint4 = this.x + 0;
        for (int i = 0; i < homeScoreArray.length; ++i) {
            Image temp = JBManager.getInstance().getTextImage(homeScoreArray[i], "tombique-tam");
            g.drawImage(temp, startPoint4, this.y + 33, 0);
            startPoint4 += temp.getWidth();
        }
        String[] awayScoreArray = Utility.int2StringArray(awayScore);
        int startPoint5 = this.x + 81;
        for (int i = 0; i < awayScoreArray.length; ++i) {
            Image temp = JBManager.getInstance().getTextImage(awayScoreArray[i], "tombique-tam");
            g.drawImage(temp, startPoint5, this.y + 33, 0);
            startPoint5 += temp.getWidth();
        }
        g.drawImage(JBManager.getInstance().getTextImage(this.homeName_short, "10x10-beyaz"), this.x + 3, this.y + 23, 0);
        g.drawImage(JBManager.getInstance().getTextImage(this.awayName_short, "10x10-beyaz"), this.x + 86, this.y + 23, 0);
    }

    public void clear() {
        this.timer.cancel();
        this.timer = null;
        this.homeFlag = null;
        this.awayFlag = null;
    }
}

