/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.screens;

import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.Team;
import com.jarbull.basket.tools.XmlDataHolder;
import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import java.util.Enumeration;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class RaceSelectionScreen
extends Canvas
implements Runnable {
    private MIDlet midlet;
    private Displayable previousScreen;
    private Thread thread;
    private boolean exit = false;
    private final int screenWidth;
    private final int screenHeight;
    private final int baseX;
    private final int baseY;
    public final Team[] teams;
    private final Image[] teamsImages;
    private final Image[] teamNamesImages;
    private int selectedRaceIndex;
    private int selectionColor;
    private boolean incSelectionColor;
    private int startX;
    private int startY;
    private int selectionColumnNo;
    private int selectionRowNo;
    private int distanceX;
    private int distanceY;

    public RaceSelectionScreen(MIDlet midlet) {
        this.midlet = midlet;
        this.distanceX = 25;
        this.distanceY = 35;
        this.startX = 25;
        this.startY = 20;
        this.selectionRowNo = 6;
        this.selectionColumnNo = 4;
        this.selectedRaceIndex = 0;
        this.selectionColor = 0;
        this.incSelectionColor = true;
        this.previousScreen = Display.getDisplay((MIDlet)midlet).getCurrent();
        this.setFullScreenMode(true);
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.baseX = (this.screenWidth - 128) / 2;
        this.baseY = (this.screenHeight - 160) / 2;
        this.teams = new Team[XmlDataHolder.getInstance().teams.size()];
        int i = 0;
        Enumeration it = XmlDataHolder.getInstance().teams.keys();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            String[] temp = (String[])XmlDataHolder.getInstance().teams.get(key);
            this.teams[i] = new Team();
            this.teams[i].setLongName(key);
            this.teams[i].setShortName(temp[0]);
            this.teams[i].setImagePath("/res/img/bayraklar/" + temp[0] + ".png");
            this.teams[i].setLevel(Integer.parseInt(temp[2]));
            ++i;
        }
        this.teamsImages = new Image[this.teams.length];
        this.teamNamesImages = new Image[this.teams.length];
        for (int k = 0; k < this.teams.length; ++k) {
            this.teamsImages[k] = ImageHandler.getInstance().getImage(this.teams[k].getImagePath());
            this.teamNamesImages[k] = JBManager.getInstance().getTextImage(this.teams[k].getShortName(), "10x10-beyaz");
        }
        int t = 0;
        for (int m = 0; m < this.selectionRowNo; ++m) {
            for (int n = 0; n < this.selectionColumnNo; ++n) {
                this.teams[t].setImagePosX(this.startX + n * this.distanceX);
                this.teams[t].setImagePosY(this.startY + m * this.distanceY);
                ++t;
            }
        }
        JBManager.getInstance().addAction(new JBAction(this, "clearti"));
    }

    public void setNextScreen(Displayable displayable) {
        this.previousScreen = displayable;
    }

    public Team getDialogResult() {
        return this.teams[this.selectedRaceIndex];
    }

    public void show() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void waitForClose() {
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    protected void keyPressed(int keyCode) {
        keyCode = KeyCodeAdapter.getInstance().adoptKeyCode(keyCode);
        switch (keyCode) {
            case -203: 
            case 205: 
            case 225: {
                this.exit = true;
                break;
            }
            case 204: 
            case 223: {
                if (this.selectedRaceIndex == 0) {
                    this.selectedRaceIndex = this.teams.length - 1;
                    break;
                }
                --this.selectedRaceIndex;
                break;
            }
            case 202: 
            case 221: {
                if (this.selectedRaceIndex < this.selectionColumnNo) break;
                this.selectedRaceIndex -= this.selectionColumnNo;
                break;
            }
            case 206: 
            case 224: {
                if (this.selectedRaceIndex == this.teams.length - 1) {
                    this.selectedRaceIndex = 0;
                    break;
                }
                ++this.selectedRaceIndex;
                break;
            }
            case 208: 
            case 222: {
                if (this.selectedRaceIndex > this.teams.length - this.selectionColumnNo - 1) break;
                this.selectedRaceIndex += this.selectionColumnNo;
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        for (int i = this.teams.length - 1; i >= 0; --i) {
            if (x < this.teams[i].getImagePosX() - this.teamsImages[i].getWidth() / 4 || x >= this.teams[i].getImagePosX() + this.teamsImages[i].getWidth() / 4 || y < this.teams[i].getImagePosY() - this.teamsImages[i].getHeight() / 2 || y >= this.teams[i].getImagePosY() + this.teamsImages[i].getHeight() / 2) continue;
            this.selectedRaceIndex = i;
            this.exit = true;
            break;
        }
    }

    protected void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        g.setClip(this.baseX, this.baseY, 128, 160);
        g.translate(this.baseX, this.baseY);
        g.drawImage(JBManager.getInstance().getTextImage("SELECT YOUR TEAM", "10x10-beyaz"), 34, 5, 0);
        for (int i = 0; i < this.teams.length; ++i) {
            g.drawImage(this.teamsImages[i], this.teams[i].getImagePosX() - this.teamsImages[i].getWidth() / 2, this.teams[i].getImagePosY() - this.teamsImages[i].getHeight() / 2, 20);
            g.drawImage(this.teamNamesImages[i], this.teams[i].getImagePosX(), this.teamsImages[i].getHeight() / 2 + this.teams[i].getImagePosY() + 10, 3);
            if (i != this.selectedRaceIndex) continue;
            this.selectionColor += this.incSelectionColor ? 50 : -50;
            if (this.selectionColor >= 255) {
                this.selectionColor = 255;
                this.incSelectionColor = false;
            } else if (this.selectionColor <= 0) {
                this.selectionColor = 0;
                this.incSelectionColor = true;
            }
            g.setColor(0xFF0000 + (this.selectionColor << 8) + this.selectionColor);
            g.drawRect(this.teams[i].getImagePosX() - this.teamsImages[i].getWidth() / 4 - 10, this.teams[i].getImagePosY() - this.teamsImages[i].getHeight() / 2 - 5, this.teamsImages[i].getWidth() / 2 + 20, this.teamsImages[i].getHeight() + this.teamNamesImages[i].getHeight() + 10);
        }
    }

    public void run() {
        while (!this.exit) {
            this.repaint();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.previousScreen);
        for (int i = this.teamNamesImages.length - 1; i > -1; --i) {
            this.teamNamesImages[i] = null;
            this.teamsImages[i] = null;
        }
        System.gc();
        ImageHandler.getInstance().clearImageBuffer();
        JBManager.getInstance().addAction(new JBAction(this, "clearti"));
    }
}

