/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.ScoreAndTimeInCommentary;
import com.jarbull.basket.tools.Utility;
import com.jarbull.jbf.JBManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScoreBoardinGame {
    String homeName_short;
    String awayName_short;
    private static int homeScore;
    private static int awayScore;
    private Image scoreBoard = ImageHandler.getInstance().getImage("/res/img/scoreboard_inGame.png");
    private Image homeFlag;
    private Image awayFlag;
    int x;
    int y;
    private static int increaseAmount;

    public ScoreBoardinGame(String homeName_short, String awayName_short, byte shootType) {
        this.homeName_short = homeName_short;
        this.awayName_short = awayName_short;
        this.homeFlag = ImageHandler.getInstance().getImage("/res/img/bayraklar/" + homeName_short + ".png");
        this.awayFlag = ImageHandler.getInstance().getImage("/res/img/bayraklar/" + awayName_short + ".png");
        if (shootType == 0) {
            increaseAmount = 2;
        }
        if (shootType == 1) {
            increaseAmount = 3;
        }
        this.setLocation(53, 5);
        homeScore = ScoreAndTimeInCommentary.homeScore;
        awayScore = ScoreAndTimeInCommentary.awayScore;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public static void increaseHomeScore() {
        homeScore += increaseAmount;
    }

    public static void increaseAwayScore() {
        awayScore += increaseAmount;
    }

    public int getAwayScore() {
        return awayScore;
    }

    public int getHomeScore() {
        return homeScore;
    }

    public static void setAwayScore(int awayScore) {
        ScoreBoardinGame.awayScore = awayScore;
    }

    public static void setHomeScore(int homeScore) {
        ScoreBoardinGame.homeScore = homeScore;
    }

    public void paint(Graphics g) {
        g.drawImage(this.scoreBoard, this.x, this.y, 0);
        g.drawImage(this.homeFlag, this.x + 10, this.y + 5, 0);
        g.drawImage(this.awayFlag, this.x + 45, this.y + 5, 0);
        g.drawImage(JBManager.getInstance().getTextImage(this.homeName_short, "10x10-beyaz"), this.x + 13, this.y + 23, 0);
        g.drawImage(JBManager.getInstance().getTextImage(this.awayName_short, "10x10-beyaz"), this.x + 48, this.y + 23, 0);
        String[] homeScoreArray = Utility.int2StringArray(homeScore);
        int startPoint = this.x + 17;
        for (int i = 0; i < homeScoreArray.length; ++i) {
            g.drawImage(JBManager.getInstance().getTextImage(homeScoreArray[i], "tombique-tam"), startPoint, this.y + 33, 0);
            startPoint += JBManager.getInstance().getTextImage(homeScoreArray[i], "tombique-tam").getWidth();
        }
        String[] awayScoreArray = Utility.int2StringArray(awayScore);
        int startPoint2 = this.x + 52;
        for (int i = 0; i < awayScoreArray.length; ++i) {
            g.drawImage(JBManager.getInstance().getTextImage(awayScoreArray[i], "tombique-tam"), startPoint2, this.y + 33, 0);
            startPoint2 += JBManager.getInstance().getTextImage(awayScoreArray[i], "tombique-tam").getWidth();
        }
    }

    public int getWidth() {
        return this.scoreBoard.getWidth();
    }

    public int getHeight() {
        return this.scoreBoard.getHeight();
    }

    public void clear() {
        this.scoreBoard = null;
        this.homeFlag = null;
        this.awayFlag = null;
    }
}

