/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.game;

import com.jarbull.basket.game.BasketCanvas;
import com.jarbull.basket.game.BasketMidlet;
import com.jarbull.basket.screens.BeforeGameScreen;
import com.jarbull.basket.screens.BeforeMatchScreen;
import com.jarbull.basket.screens.EndGameScreen;
import com.jarbull.basket.screens.EndMatchScreen;
import com.jarbull.basket.screens.LoadingScreen;
import com.jarbull.basket.screens.RaceSelectionScreenSmall;
import com.jarbull.basket.screens.ShotChoiceScreen;
import com.jarbull.basket.tools.Case;
import com.jarbull.basket.tools.CaseHandler;
import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.ScoreAndTimeInCommentary;
import com.jarbull.basket.tools.ShotChoiceZone;
import com.jarbull.basket.tools.SlidingTexts;
import com.jarbull.basket.tools.XML_Parser;
import com.jarbull.basket.tools.XmlDataHolder;
import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBGameCanvas;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class CommentaryScreenCanvas
extends JBGameCanvas
implements Runnable {
    public static final byte DIALOG_RESULT__2PTS = 0;
    public static final byte DIALOG_RESULT__3PTS = 1;
    private BasketMidlet m;
    private byte dialogResult;
    public Image background;
    public static Image caseImage;
    private Image menuIcon;
    public static int canvasWidth;
    public static int canvasHeigth;
    public ScoreAndTimeInCommentary scoreAndTime;
    public static SlidingTexts slidingTexts;
    public static int currentCaseTime;
    ShotChoiceZone shotChoiceZone;

    public CommentaryScreenCanvas(BasketMidlet m) {
        this.m = m;
        XmlDataHolder.getInstance().levelNo = 1;
        KeyCodeAdapter.getInstance().setCanvas((Canvas)this);
        this.setFullScreenMode(true);
        try {
            this.menuIcon = Image.createImage((String)"/res/img/menu.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        canvasWidth = this.getWidth();
        canvasHeigth = this.getHeight();
        this.background = ImageHandler.getInstance().getImage("/res/img/commentary_bg.png");
        this.shotChoiceZone = new ShotChoiceZone();
        this.shotChoiceZone.setLocation(50, 150);
        slidingTexts = new SlidingTexts(70, 80, 120, 200);
        this.scoreAndTime = new ScoreAndTimeInCommentary();
        this.scoreAndTime.setLocation(10, 10);
    }

    public byte getDialogResult() {
        return this.dialogResult;
    }

    protected void keyPressed(int keyCode) {
        keyCode = KeyCodeAdapter.getInstance().adoptKeyCode(keyCode);
        switch (keyCode) {
            case -202: 
            case 209: {
                System.gc();
                ImageHandler.getInstance().clearImageBuffer();
                JBManager.getInstance().clearFonts();
                JBManager.getInstance().addAction(new JBAction(this, "clearti"));
                this.scoreAndTime.stopLongTime();
                this.scoreAndTime.stopShortTime();
                this.m.openPauseMenu();
            }
        }
    }

    public void paint(Graphics g) {
        if (this.background != null) {
            g.drawImage(this.background, 0, 0, 0);
            if (this.scoreAndTime.homeFlag != null) {
                this.scoreAndTime.paint(g);
                slidingTexts.paint(g);
                g.drawImage(this.menuIcon, canvasWidth - this.menuIcon.getWidth(), canvasHeigth - this.menuIcon.getHeight(), 0);
                if (caseImage != null) {
                    // empty if block
                }
            }
        }
    }

    private void handleCase() {
        if (ScoreAndTimeInCommentary.longTime < 1) {
            this.scoreAndTime.stopLongTime();
            this.scoreAndTime.stopShortTime();
            EndMatchScreen endScreen = new EndMatchScreen(this.m, this);
            endScreen.show();
            endScreen.waitForClose();
            Display.getDisplay((MIDlet)this.m).setCurrent((Displayable)this);
            if (ScoreAndTimeInCommentary.longTime > 0) {
                this.scoreAndTime.startLongTime();
                this.scoreAndTime.startShortTime();
                return;
            }
            if (ScoreAndTimeInCommentary.homeScore > ScoreAndTimeInCommentary.awayScore) {
                XmlDataHolder.getInstance().score += XmlDataHolder.getInstance().levelNo * 1000;
                XmlDataHolder.getInstance().score += (ScoreAndTimeInCommentary.homeScore - ScoreAndTimeInCommentary.awayScore) * 1000;
                if ((long)XmlDataHolder.getInstance().levelNo == 5L) {
                    EndGameScreen endGame = new EndGameScreen(this.m, true);
                    endGame.addText((String)XmlDataHolder.getInstance().homeTeamInfo.get("nameShort") + " " + ScoreAndTimeInCommentary.homeScore + "   " + ScoreAndTimeInCommentary.awayScore + " " + (String)XmlDataHolder.getInstance().levelOpponentTeamInfo.get("nameShort"));
                    endGame.addText(" ");
                    endGame.addText("Congratulations!");
                    endGame.addText(" ");
                    endGame.addText(XmlDataHolder.getInstance().homeTeamInfo.get("name") + " won the");
                    endGame.addText("World Basketball");
                    endGame.addText("Championship");
                    endGame.addText(" ");
                    endGame.addText(" ");
                    endGame.addText(" ");
                    endGame.addText(" ");
                    endGame.addText(" ");
                    endGame.addText(" ");
                    endGame.addText("Score: " + XmlDataHolder.getInstance().score);
                    endGame.setState(0);
                    endGame.show();
                    endGame.waitForClose();
                    JBManager.getInstance().gameSettings.putAndSave("score:mylast", Integer.toString(XmlDataHolder.getInstance().score));
                    try {
                        if (Integer.parseInt(JBManager.getInstance().gameSettings.get("score:mytop")) < XmlDataHolder.getInstance().score) {
                            JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(XmlDataHolder.getInstance().score));
                        }
                    }
                    catch (Exception ex) {
                        JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(XmlDataHolder.getInstance().score));
                    }
                    XmlDataHolder.getInstance().levelNo = 1;
                    XmlDataHolder.getInstance().score = 0;
                    this.isRunning = false;
                    this.m.openPauseMenu();
                    JBManager.getInstance().addAction(new JBAction(this, "TOP:T0"));
                    this.m.destroyJBApp(true, null);
                    return;
                }
                ++XmlDataHolder.getInstance().levelNo;
                slidingTexts.clear();
                this.prepareLevel(XmlDataHolder.getInstance().levelNo, false);
                BeforeMatchScreen beforeSecreen = new BeforeMatchScreen(this.m);
                beforeSecreen.show();
                beforeSecreen.waitForClose();
                Display.getDisplay((MIDlet)this.m).setCurrent((Displayable)this);
                this.scoreAndTime.startLongTime();
                this.scoreAndTime.startShortTime();
                return;
            }
            if (ScoreAndTimeInCommentary.homeScore < ScoreAndTimeInCommentary.awayScore) {
                EndGameScreen endGame = new EndGameScreen(this.m, false);
                endGame.addText((String)XmlDataHolder.getInstance().homeTeamInfo.get("nameShort") + " " + ScoreAndTimeInCommentary.homeScore + "   " + ScoreAndTimeInCommentary.awayScore + " " + (String)XmlDataHolder.getInstance().levelOpponentTeamInfo.get("nameShort"));
                endGame.addText(" ");
                endGame.addText(XmlDataHolder.getInstance().homeTeamInfo.get("name") + " is");
                endGame.addText("eliminated in the");
                switch (XmlDataHolder.getInstance().levelNo) {
                    case 1: {
                        endGame.addText("Quarter Final 3rd Leg");
                        break;
                    }
                    case 2: {
                        endGame.addText("Quarter Final 2nd Leg");
                        break;
                    }
                    case 3: {
                        endGame.addText("Quarter Final");
                        break;
                    }
                    case 4: {
                        endGame.addText("Semi Final");
                        break;
                    }
                    case 5: {
                        endGame.addText("Final");
                    }
                }
                endGame.addText(" ");
                endGame.addText(" ");
                endGame.addText(" ");
                endGame.addText(" ");
                endGame.addText(" ");
                endGame.addText(" ");
                endGame.addText(" ");
                endGame.addText("Score: " + XmlDataHolder.getInstance().score);
                endGame.setState(0);
                endGame.show();
                endGame.waitForClose();
                JBManager.getInstance().gameSettings.putAndSave("score:mylast", Integer.toString(XmlDataHolder.getInstance().score));
                try {
                    if (Integer.parseInt(JBManager.getInstance().gameSettings.get("score:mytop")) < XmlDataHolder.getInstance().score) {
                        JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(XmlDataHolder.getInstance().score));
                    }
                }
                catch (Exception ex) {
                    JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(XmlDataHolder.getInstance().score));
                }
                this.isRunning = false;
                System.gc();
                ImageHandler.getInstance().clearImageBuffer();
                JBManager.getInstance().clearFonts();
                JBManager.getInstance().addAction(new JBAction(this, "clearti"));
                KeyCodeAdapter.getInstance().setCanvas(null);
                this.m.openPauseMenu();
                JBManager.getInstance().addAction(new JBAction(this, "TOP:T0"));
                this.m.destroyJBApp(true, null);
                return;
            }
            return;
        }
        if (ScoreAndTimeInCommentary.shortTime < 1) {
            if (CaseHandler.getInstance().currentCase.getNextCases().containsKey("opp-24sec")) {
                CaseHandler.getInstance().currentCase = (Case)XmlDataHolder.getInstance().cases.get("opp-24sec");
                currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
                slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                try {
                    caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                }
                catch (IOException ex) {
                    caseImage = null;
                }
            } else if (CaseHandler.getInstance().currentCase.getNextCases().containsKey("home-24sec")) {
                CaseHandler.getInstance().currentCase = (Case)XmlDataHolder.getInstance().cases.get("home-24sec");
                currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
                slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                try {
                    caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                }
                catch (IOException ex) {
                    caseImage = null;
                }
            }
            ScoreAndTimeInCommentary.shortTime = 24;
            return;
        }
        if (currentCaseTime < 1) {
            if (CaseHandler.getInstance().currentCase.getAction().equals("open_basket_choice_screen")) {
                slidingTexts.setVisible(false);
                this.shotChoiceZone.setVisible(true);
                ShotChoiceScreen shotChoice = new ShotChoiceScreen(this.m, this);
                shotChoice.show();
                shotChoice.waitForClose();
                Display.getDisplay((MIDlet)this.m).setCurrent((Displayable)this);
                shotChoice = null;
                this.dialogResult = this.shotChoiceZone.getDialogResult();
                System.gc();
                JBManager.getInstance().addAction(new JBAction(this, "clearti"));
                if (ScoreAndTimeInCommentary.longTime < 1) {
                    // empty if block
                }
                if (ScoreAndTimeInCommentary.shortTime < 1) {
                    if (CaseHandler.getInstance().currentCase.getNextCases().containsKey("opp-24sec")) {
                        CaseHandler.getInstance().currentCase = (Case)XmlDataHolder.getInstance().cases.get("opp-24sec");
                        slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                        try {
                            caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                        }
                        catch (IOException ex) {
                            caseImage = null;
                        }
                        currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
                        ScoreAndTimeInCommentary.shortTime = 24;
                    } else if (CaseHandler.getInstance().currentCase.getNextCases().containsKey("home-24sec")) {
                        CaseHandler.getInstance().currentCase = (Case)XmlDataHolder.getInstance().cases.get("home-24sec");
                        slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                        try {
                            caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                        }
                        catch (IOException ex) {
                            caseImage = null;
                        }
                        currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
                        ScoreAndTimeInCommentary.shortTime = 24;
                    }
                    slidingTexts.setVisible(true);
                    this.shotChoiceZone.setVisible(false);
                    return;
                }
                ScoreAndTimeInCommentary.shortStopped = true;
                ScoreAndTimeInCommentary.longStopped = true;
                ImageHandler.getInstance().clearImageBuffer();
                JBManager.getInstance().clearFonts();
                JBManager.getInstance().addAction(new JBAction(this, "clearti"));
                System.gc();
                BasketCanvas basketCanvas = null;
                this.isPaused = true;
                try {
                    basketCanvas = new BasketCanvas(this.m);
                    basketCanvas.previousScreen = this;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                basketCanvas.show();
                basketCanvas.waitForClose();
                Display.getDisplay((MIDlet)this.m).setCurrent((Displayable)this);
                slidingTexts.setVisible(true);
                this.shotChoiceZone.setVisible(false);
                basketCanvas = null;
                System.gc();
                ScoreAndTimeInCommentary.shortStopped = false;
                ScoreAndTimeInCommentary.longStopped = false;
                this.isPaused = false;
                if (ScoreAndTimeInCommentary.longTime < 1) {
                    // empty if block
                }
                if (ScoreAndTimeInCommentary.shortTime < 1) {
                    if (CaseHandler.getInstance().currentCase.getNextCases().containsKey("opp-24sec")) {
                        CaseHandler.getInstance().currentCase = (Case)XmlDataHolder.getInstance().cases.get("opp-24sec");
                        slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                        try {
                            caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                        }
                        catch (IOException ex) {
                            caseImage = null;
                        }
                        currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
                        ScoreAndTimeInCommentary.shortTime = 24;
                    } else if (CaseHandler.getInstance().currentCase.getNextCases().containsKey("home-24sec")) {
                        CaseHandler.getInstance().currentCase = (Case)XmlDataHolder.getInstance().cases.get("home-24sec");
                        slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                        try {
                            caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                        }
                        catch (IOException ex) {
                            caseImage = null;
                        }
                        currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
                        ScoreAndTimeInCommentary.shortTime = 24;
                    }
                    return;
                }
            } else if (CaseHandler.getInstance().currentCase.getAction().equals("op_2pts_basket")) {
                ScoreAndTimeInCommentary.increaseAwayScore(2);
                ScoreAndTimeInCommentary.shortTime = 24;
                CaseHandler.getInstance().currentCase = CaseHandler.getInstance().currentCase.next();
                slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                try {
                    caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                }
                catch (IOException ex) {
                    caseImage = null;
                }
                currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
            } else if (CaseHandler.getInstance().currentCase.getAction().equals("op_3pts_basket")) {
                ScoreAndTimeInCommentary.increaseAwayScore(3);
                ScoreAndTimeInCommentary.shortTime = 24;
                CaseHandler.getInstance().currentCase = CaseHandler.getInstance().currentCase.next();
                slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                try {
                    caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                }
                catch (IOException ex) {
                    caseImage = null;
                }
                currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
            } else if (CaseHandler.getInstance().currentCase.getAction().equals("stop_clocks")) {
                ScoreAndTimeInCommentary.longStopped = true;
                ScoreAndTimeInCommentary.shortStopped = true;
                CaseHandler.getInstance().currentCase = CaseHandler.getInstance().currentCase.next();
                slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                try {
                    caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                }
                catch (IOException ex) {
                    caseImage = null;
                }
                currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
            } else if (CaseHandler.getInstance().currentCase.getAction().equals("start_clocks")) {
                ScoreAndTimeInCommentary.longStopped = false;
                ScoreAndTimeInCommentary.shortStopped = false;
                CaseHandler.getInstance().currentCase = CaseHandler.getInstance().currentCase.next();
                slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                try {
                    caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                }
                catch (IOException ex) {
                    caseImage = null;
                }
                currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
            } else if (CaseHandler.getInstance().currentCase.getAction().equals("reset_24sec")) {
                ScoreAndTimeInCommentary.shortTime = 24;
                CaseHandler.getInstance().currentCase = CaseHandler.getInstance().currentCase.next();
                slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                try {
                    caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                }
                catch (IOException ex) {
                    caseImage = null;
                }
                currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
            } else {
                CaseHandler.getInstance().currentCase = CaseHandler.getInstance().currentCase.next();
                slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
                try {
                    caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
                }
                catch (IOException ex) {
                    caseImage = null;
                }
                currentCaseTime = CaseHandler.getInstance().currentCase.getTime();
            }
        }
    }

    public void prepareLevel(int levelNo, boolean justInitialize) {
        if (!justInitialize) {
            XML_Parser parsedFile = new XML_Parser();
            parsedFile.parseFile("level_" + levelNo);
            parsedFile = null;
        }
        if (XmlDataHolder.getInstance().homeTeamInfo.get("nameShort") != null && ((String)XmlDataHolder.getInstance().homeTeamInfo.get("nameShort")).equals((String)XmlDataHolder.getInstance().levelOpponentTeamInfo.get("nameShort"))) {
            XML_Parser.chooseOpponent();
            this.prepareLevel(XmlDataHolder.getInstance().levelNo, true);
        }
        CaseHandler.getInstance().currentCase = (Case)XmlDataHolder.getInstance().cases.get("opp-inbounds");
        ScoreAndTimeInCommentary.longTime = Integer.parseInt((String)XmlDataHolder.getInstance().levelGeneralInfo.get("remainingTimeLong"));
        ScoreAndTimeInCommentary.shortTime = Integer.parseInt((String)XmlDataHolder.getInstance().levelGeneralInfo.get("remainingTimeShort"));
        slidingTexts.addText(CaseHandler.getInstance().currentCase.getText());
        try {
            caseImage = Image.createImage((String)CaseHandler.getInstance().currentCase.getCaseImagePath());
        }
        catch (IOException ex) {
            caseImage = null;
        }
        this.scoreAndTime.awayName_short = (String)XmlDataHolder.getInstance().levelOpponentTeamInfo.get("nameShort");
        this.scoreAndTime.awayFlag = ImageHandler.getInstance().getImage("/res/img/bayraklar/" + this.scoreAndTime.awayName_short + ".png");
        ScoreAndTimeInCommentary.homeScore = Integer.parseInt((String)XmlDataHolder.getInstance().levelGeneralInfo.get("homeTeamScore"));
        ScoreAndTimeInCommentary.awayScore = Integer.parseInt((String)XmlDataHolder.getInstance().levelGeneralInfo.get("opTeamScore"));
    }

    public void run() {
        this.scoreAndTime.stopLongTime();
        this.scoreAndTime.stopShortTime();
        LoadingScreen loadingSec = new LoadingScreen(this.m);
        loadingSec.setNextDisplay((Displayable)this);
        loadingSec.setState(1);
        loadingSec.addText(" ");
        loadingSec.addText("Loading...", 1, "10x10-beyaz");
        loadingSec.show();
        this.prepareLevel(XmlDataHolder.getInstance().levelNo, false);
        loadingSec.removeTextFromEnd(1);
        loadingSec.addText("Press any key.", 0, "10x10-beyaz");
        loadingSec.setState(0);
        loadingSec.waitForClose();
        this.isPaused = true;
        BeforeGameScreen befGame = new BeforeGameScreen(this.m);
        befGame.show();
        befGame.setNextDisplay((Displayable)this);
        befGame.waitForClose();
        befGame = null;
        Display.getDisplay((MIDlet)this.m).setCurrent((Displayable)this);
        RaceSelectionScreenSmall raceSelect = new RaceSelectionScreenSmall(this.m);
        raceSelect.show();
        raceSelect.waitForClose();
        Display.getDisplay((MIDlet)this.m).setCurrent((Displayable)this);
        ImageHandler.getInstance().clearImageBuffer();
        JBManager.getInstance().addAction(new JBAction(this, "clearti"));
        XmlDataHolder.getInstance().homeTeamInfo.put("name", raceSelect.getDialogResult().getLongName());
        XmlDataHolder.getInstance().homeTeamInfo.put("nameShort", raceSelect.getDialogResult().getShortName());
        XmlDataHolder.getInstance().homeTeamInfo.put("flagPath", raceSelect.getDialogResult().getImagePath());
        if (XmlDataHolder.getInstance().homeTeamInfo.get("nameShort") != null && ((String)XmlDataHolder.getInstance().homeTeamInfo.get("nameShort")).equals((String)XmlDataHolder.getInstance().levelOpponentTeamInfo.get("nameShort"))) {
            XML_Parser.chooseOpponent();
            this.prepareLevel(XmlDataHolder.getInstance().levelNo, true);
        }
        this.scoreAndTime.homeFlag = ImageHandler.getInstance().getImage("/res/img/bayraklar/" + raceSelect.getDialogResult().getShortName() + ".png");
        this.scoreAndTime.homeName_short = raceSelect.getDialogResult().getShortName();
        for (int i = raceSelect.teams.length - 1; i > -1; --i) {
            raceSelect.teams[i] = null;
        }
        System.gc();
        BeforeMatchScreen beforeScreen = new BeforeMatchScreen(this.m);
        beforeScreen.show();
        beforeScreen.waitForClose();
        Display.getDisplay((MIDlet)this.m).setCurrent((Displayable)this);
        this.scoreAndTime.startLongTime();
        this.scoreAndTime.startShortTime();
        this.isPaused = false;
        while (this.isRunning) {
            if (!this.isPaused) {
                this.repaint();
                this.handleCase();
            }
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.scoreAndTime.clear();
        this.scoreAndTime = null;
        this.background = null;
        caseImage = null;
        slidingTexts.clear();
        slidingTexts = null;
        this.shotChoiceZone.clear();
        this.shotChoiceZone = null;
        System.gc();
        ImageHandler.getInstance().clearImageBuffer();
        JBManager.getInstance().clearFonts();
        JBManager.getInstance().addAction(new JBAction(this, "clearti"));
        KeyCodeAdapter.getInstance().setCanvas(null);
    }

    static {
        currentCaseTime = -1;
    }
}

