/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import ca.jamdat.flight.k;
import com.ea.sdk.SDKConfig;
import com.ea.sdk.SDKGame;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKKeys;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import com.ea.sdk.VpadDesigner;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class SDKCanvas
extends Canvas
implements SDKKeys,
VpadDesigner {
    public static final byte INPUT_MODE_NORMAL = 0;
    public static final byte INPUT_MODE_KEYBOARD = 1;
    public static final int VPAD_SHOW_DIRECTIONAL_KEYS = 15;
    public static final int VPAD_SHOW_LSK = 32;
    public static final int VPAD_SHOW_RSK = 64;
    public static final int VPAD_SHOW_CENTER = 16;
    public static final int VPAD_SHOW_STAR = 131072;
    public static final int VPAD_SHOW_POUND = 262144;
    public static final int VPAD_SHOW_ALL = 393343;
    public int mKeyState;
    public int mFrameKeysPressed;
    public int mFrameKeysRepeated;
    public int mFrameKeyReleased;
    public int mKeysDisabledNbFrames;
    public SDKGraphics mSdkGraphics;
    public byte mInputMode;
    public static int[] mVpadDefaultEvents;
    public int mVpadHeight;
    public int mVpadKeysGap;
    public int mVpadRows;
    public int mVpadCols;
    public VpadDesigner mVpadInterface;
    public int mVpadPressedButton;
    public int mVpadPressedKey;
    public int mVpadFlags;
    public boolean[] mVpadAvailableKeys = new boolean[9];

    public static SDKCanvas getInstance() {
        return k.y().k;
    }

    public void setInputMode(byte by) {
        this.mInputMode = by;
        k.s();
    }

    public static boolean isKeyPressed(int n2) {
        n2 = (SDKCanvas.getInstance().mKeyState & n2) != 0 ? 1 : 0;
        return n2 != 0;
    }

    public static boolean isNewKeyPressed(int n2) {
        n2 = (SDKCanvas.getInstance().mFrameKeysPressed & n2) != 0 ? 1 : 0;
        return n2 != 0;
    }

    public static boolean isNewKeyPressedOrRepeated(int n2) {
        n2 = SDKCanvas.isNewKeyPressed(n2) || (SDKCanvas.getInstance().mFrameKeysRepeated & n2) != 0 ? 1 : 0;
        return n2 != 0;
    }

    public static boolean isNewKeyReleased(int n2) {
        n2 = (SDKCanvas.getInstance().mFrameKeyReleased & n2) != 0 ? 1 : 0;
        return n2 != 0;
    }

    public static void disableInput(int n2) {
        SDKCanvas sDKCanvas = SDKCanvas.getInstance();
        SDKCanvas.getInstance().mKeysDisabledNbFrames = n2;
        sDKCanvas.mKeyState = 0;
        sDKCanvas.mFrameKeysPressed = 0;
        sDKCanvas.mFrameKeysRepeated = 0;
        sDKCanvas.mFrameKeyReleased = 0;
    }

    public long getAppTime() {
        return k.A() - k.y().n;
    }

    public int getWidth() {
        return k.b(k.x());
    }

    public int getHeight() {
        int n2 = k.a(k.x());
        if (SDKConfig.getVpadEnabled()) {
            n2 -= this.mVpadHeight;
        }
        return n2;
    }

    public SDKGame getGame() {
        return k.y().l;
    }

    public void vpadInit(int n2, int n3, boolean bl, int n4) {
        this.vpadResetPressedKey();
        this.vpadSetHeight(this.vpadGetHeight());
        if (bl) {
            this.mVpadInterface = this;
            this.mVpadRows = 3;
            this.mVpadCols = 3;
            boolean[] blArray = this.mVpadAvailableKeys;
            this.mVpadFlags = n4;
            if ((n4 & 1) != 0) {
                blArray[1] = true;
            }
            if ((n4 & 2) != 0) {
                blArray[7] = true;
            }
            if ((n4 & 4) != 0) {
                blArray[3] = true;
            }
            if ((n4 & 8) != 0) {
                blArray[5] = true;
            }
            if ((n4 & 0x10) != 0) {
                blArray[4] = true;
            }
            if ((n4 & 0x20) != 0) {
                blArray[0] = true;
            }
            if ((n4 & 0x40) != 0) {
                blArray[2] = true;
            }
            if ((n4 & 0x20000) != 0) {
                blArray[6] = true;
            }
            if ((n4 & 0x40000) != 0) {
                blArray[8] = true;
                return;
            }
        } else {
            this.mVpadInterface = this;
            this.mVpadRows = n2;
            this.mVpadCols = n3;
            this.mVpadFlags = 0;
        }
    }

    public void vpadSetHeight(int n2) {
        this.mVpadHeight = n2;
    }

    public int vpadGetHeight() {
        return this.mVpadHeight;
    }

    public void drawBackground(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(-16777216);
        sDKGraphics.fillRect(0, this.getHeight(), this.getWidth(), this.mVpadHeight);
    }

    public void drawButton(SDKGraphics sDKGraphics, int n2, boolean bl) {
        if (!this.mVpadAvailableKeys[n2]) {
            return;
        }
        int n3 = sDKGraphics.getClipX();
        int n4 = sDKGraphics.getClipY();
        int n5 = sDKGraphics.getClipWidth();
        int n6 = sDKGraphics.getClipHeight();
        int n7 = bl ? -8947849 : -5592406;
        sDKGraphics.setColor(n7);
        sDKGraphics.fillRect(n3, n4, n5, n6);
        int n8 = n5 < n6 ? n5 : n6;
        int n9 = n8;
        n7 = n8;
        n5 = n3 + n5 / 2 - n8 / 2;
        n6 = n4 + n6 / 2 - n8 / 2;
        if (n8 % 4 != 0) {
            n9 = n8 - n8 % 4;
        }
        if (n7 % 4 != 0) {
            n7 -= n7 % 4;
        }
        n8 = bl ? -65536 : -16777216;
        sDKGraphics.setColor(n8);
        switch (n2) {
            case 1: {
                sDKGraphics.fillTriangle(n5 + (n9 >> 1), n6, n5, n6 + n7 * 3 / 4, n5 + n9, n6 + n7 * 3 / 4);
                sDKGraphics.fillRect(n5 + n9 / 4, n6 + n7 * 3 / 4, n9 / 2, n7 / 8 + 1);
                return;
            }
            case 3: {
                sDKGraphics.fillTriangle(n5, n6 + (n7 >> 1), n5 + n9 * 3 / 4, n6, n5 + n9 * 3 / 4, n6 + n7);
                sDKGraphics.fillRect(n5 + n9 * 3 / 4, n6 + n7 / 4, n9 / 8 + 1, n7 / 2);
                return;
            }
            case 5: {
                sDKGraphics.fillTriangle(n5 + n9, n6 + (n7 >> 1), n5 + n9 / 4, n6, n5 + n9 / 4, n6 + n7);
                sDKGraphics.fillRect(n5 + n9 / 8, n6 + n7 / 4, n9 / 4, n7 / 2);
                return;
            }
            case 7: {
                sDKGraphics.fillTriangle(n5 + (n9 >> 1), n6 + n7, n5, n6 + n7 / 4, n5 + n9, n6 + n7 / 4);
                sDKGraphics.fillRect(n5 + n9 / 4, n6 + n7 / 8, n9 / 2, n7 / 8 + 1);
            }
        }
    }

    public void vpadSetDesigner(VpadDesigner vpadDesigner) {
        if (vpadDesigner == null) {
            vpadDesigner = this;
        }
        this.mVpadInterface = vpadDesigner;
    }

    public VpadDesigner vpadGetDesigner() {
        block0: {
            if (sDKCanvas.mVpadInterface != sDKCanvas) break block0;
            SDKCanvas sDKCanvas = null;
        }
        return sDKCanvas;
    }

    public void simulateKeyPressed(int n2) {
        if (n2 != 0 && (n2 & n2 - 1) == 0) {
            this.keyEvt(n2, true);
        }
    }

    public void simulateKeyReleased(int n2) {
        if (n2 != 0 && (n2 & n2 - 1) == 0) {
            this.keyEvt(n2, false);
        }
    }

    public void keyPressed(int n2) {
        this.FlightKeyEvt(k.b(n2), true);
    }

    public void keyReleased(int n2) {
        this.FlightKeyEvt(k.b(n2), false);
    }

    public void keyRepeated(int n2) {
    }

    public int getOsWidth() {
        return k.e(k.z().k());
    }

    public int getOsHeight() {
        return k.d(k.z().k());
    }

    public void setCommands(SDKString sDKString, SDKString sDKString2) {
    }

    public SDKCanvas() {
        this.mSdkGraphics = SDKUtils.createGraphics();
        if (SDKConfig.getVpadEnabled()) {
            this.mVpadHeight = 0;
            this.mVpadKeysGap = 5;
            this.mVpadRows = 3;
            this.mVpadCols = 3;
            this.mVpadFlags = 0;
            this.vpadInit(0, 0, true, 393343);
            this.vpadSetHeight(this.getHeight() >> 1);
        }
        this.setInputMode((byte)0);
    }

    public void destruct() {
        this.mSdkGraphics = null;
    }

    public void ResetFrameKeyStates() {
        if (this.mKeysDisabledNbFrames > 0) {
            --this.mKeysDisabledNbFrames;
        }
        this.mFrameKeysPressed = 0;
        this.mFrameKeysRepeated = 0;
        this.mFrameKeyReleased = 0;
    }

    public void paint(k k2) {
        this.mSdkGraphics.init(k2);
        k.y().l.draw(this.mSdkGraphics);
        if (SDKConfig.getVpadEnabled()) {
            this.vpadDraw(this.mSdkGraphics);
        }
    }

    public void paint(Graphics graphics) {
    }

    public void FlightKeyEvt(int n2, boolean bl) {
        if (this.mKeysDisabledNbFrames > 0) {
            return;
        }
        int n3 = this.FlightKeyToSDKKey(n2);
        if (n3 == 0) {
            n3 = k.c(n2);
            if (n3 != 0) {
                long l2 = this.getAppTime();
                SDKGame sDKGame = k.y().l;
                if (bl) {
                    sDKGame.appLetterPressed(n3, l2);
                    return;
                }
                sDKGame.appLetterReleased(n3, l2);
                return;
            }
        } else {
            this.keyEvt(n3, bl);
        }
    }

    public void FlightPointerPressed(int n2, int n3) {
        if (this.mKeysDisabledNbFrames > 0) {
            return;
        }
        SDKGame sDKGame = k.y().l;
        long l2 = this.getAppTime();
        if (SDKConfig.getVpadEnabled() && this.mVpadPressedKey != 0) {
            sDKGame.appKeyReleased(this.mVpadPressedKey, l2);
            this.vpadResetPressedKey();
        }
        int n4 = this.getHeight();
        if (SDKConfig.getVpadEnabled() && n3 > n4) {
            int n5 = 0;
            n4 = (n3 - n4) / (this.mVpadHeight / this.mVpadRows) * this.mVpadCols + n2 / (this.getWidth() / this.mVpadCols);
            if (this.mVpadInterface == this) {
                if (this.mVpadAvailableKeys[n4]) {
                    n5 = mVpadDefaultEvents[n4];
                }
            } else {
                n5 = -(n4 + 1000);
            }
            this.mVpadPressedButton = n4;
            this.mVpadPressedKey = n5;
            sDKGame.appKeyPressed(n5, l2);
            return;
        }
        sDKGame.appPointerPressed(n2, n3, l2);
    }

    public void FlightPointerReleased(int n2, int n3) {
        if (this.mKeysDisabledNbFrames > 0) {
            return;
        }
        if (SDKConfig.getVpadEnabled() && this.mVpadPressedKey != 0) {
            k.y().l.appKeyReleased(this.mVpadPressedKey, this.getAppTime());
            this.vpadResetPressedKey();
            return;
        }
        k.y().l.appPointerReleased(n2, n3, this.getAppTime());
    }

    public void FlightPointerDragged(int n2, int n3) {
        if (this.mKeysDisabledNbFrames > 0) {
            return;
        }
        k.y().l.appPointerDragged(n2, n3, this.getAppTime());
    }

    public int FlightKeyToSDKKey(int n2) {
        switch (n2) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 7: {
                return 16;
            }
            case 8: {
                return 0x100000;
            }
            case 9: {
                return 524288;
            }
            case 10: {
                return 0x800000;
            }
            case 11: {
                return 0x200000;
            }
            case 12: {
                return 0x400000;
            }
            case 13: {
                return 32;
            }
            case 14: {
                return 64;
            }
            case 15: {
                return 262144;
            }
            case 16: {
                return 131072;
            }
            case 17: {
                return 128;
            }
            case 18: {
                return 256;
            }
            case 19: {
                return 512;
            }
            case 20: {
                return 1024;
            }
            case 21: {
                return 2048;
            }
            case 22: {
                return 4096;
            }
            case 23: {
                return 8192;
            }
            case 24: {
                return 16384;
            }
            case 25: {
                return 32768;
            }
            case 26: {
                return 65536;
            }
        }
        return 0;
    }

    public void vpadDraw(SDKGraphics sDKGraphics) {
        if (this.mVpadInterface == null) {
            return;
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        sDKGraphics.setClip(0, n3, n2, this.mVpadHeight);
        this.mVpadInterface.drawBackground(sDKGraphics);
        int n4 = n2 / this.mVpadCols;
        n2 = this.mVpadHeight / this.mVpadRows;
        int n5 = this.mVpadKeysGap;
        for (int i2 = 0; i2 < this.mVpadRows; ++i2) {
            for (int i3 = 0; i3 < this.mVpadCols; ++i3) {
                sDKGraphics.setClip(0 + i3 * n4 + n5 / 2, n3 + i2 * n2 + n5 / 2, n4 - n5, n2 - n5);
                VpadDesigner vpadDesigner = this.mVpadInterface;
                int n6 = i2 * this.mVpadCols + i3;
                boolean bl = this.mVpadPressedButton == i2 * this.mVpadCols + i3;
                vpadDesigner.drawButton(sDKGraphics, n6, bl);
            }
        }
    }

    public void vpadResetPressedKey() {
        this.mVpadPressedButton = -1;
        this.mVpadPressedKey = 0;
    }

    public void keyEvt(int n2, boolean bl) {
        long l2 = this.getAppTime();
        SDKGame sDKGame = k.y().l;
        if (bl) {
            this.mFrameKeysPressed |= n2;
            this.mKeyState |= n2;
            sDKGame.appKeyPressed(n2, l2);
            return;
        }
        this.mFrameKeyReleased |= n2;
        this.mKeyState &= ~n2;
        sDKGame.appKeyReleased(n2, l2);
    }

    public static SDKCanvas[] InstArraySDKCanvas(int n2) {
        SDKCanvas[] sDKCanvasArray = new SDKCanvas[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sDKCanvasArray[i2] = new SDKCanvas();
        }
        return sDKCanvasArray;
    }

    public static SDKCanvas[][] InstArraySDKCanvas(int n2, int n3) {
        SDKCanvas[][] sDKCanvasArray = new SDKCanvas[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            sDKCanvasArray[i2] = new SDKCanvas[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                sDKCanvasArray[i2][i3] = new SDKCanvas();
            }
        }
        return sDKCanvasArray;
    }

    public static SDKCanvas[][][] InstArraySDKCanvas(int n2, int n3, int n4) {
        SDKCanvas[][][] sDKCanvasArray = new SDKCanvas[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            sDKCanvasArray[i2] = new SDKCanvas[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                sDKCanvasArray[i2][i3] = new SDKCanvas[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    sDKCanvasArray[i2][i3][i4] = new SDKCanvas();
                }
            }
        }
        return sDKCanvasArray;
    }

    static {
        int[] nArray = new int[9];
        int[] nArray2 = nArray;
        nArray[0] = 32;
        nArray2[1] = 1;
        nArray2[2] = 64;
        nArray2[3] = 4;
        nArray2[4] = 16;
        nArray2[5] = 8;
        nArray2[6] = 131072;
        nArray2[7] = 2;
        nArray2[8] = 262144;
        mVpadDefaultEvents = nArray2;
    }
}

