/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.AIController;
import com.ea.game.Controller;
import com.ea.game.DDDebug;
import com.ea.game.DDFile;
import com.ea.game.DDMath;
import com.ea.game.GameAIConstants;
import com.ea.game.GameFormation;
import com.ea.game.GameLogic;
import com.ea.game.GameRender;
import com.ea.game.MainFrame;
import com.ea.game.TouchscreenController;
import com.ea.game.Trajectory;
import com.ea.game.XMLMenuSystem;

public class GameAI
implements GameAIConstants {
    public static final int[] sidestepTargetYCoordSmaller = new int[]{30, 29, 30, 29};
    public static final int[] sidestepTargetYCoordLarger = new int[]{29, 30, 29, 30};
    public static int m_manOfTheMatch;
    public static int[] m_goalScorer;
    public static int[] m_targetPlayer;
    public static int[] m_stateLookUpTable;
    public static int[] m_playerWithBall;
    public static int[][][] m_playerStorage;
    public static int[] m_ballStorage;
    public static short[][] m_teamStorage;
    public static int[] m_setPieceTakers;
    public static final int SET_PIECE_TAKER_CORNER_KICK = 0;
    public static final int SET_PIECE_TAKER_FREE_KICK = 1;
    public static final int SET_PIECE_TAKER_PENALTY_KICK = 2;
    public static int[] m_passTargetObject;
    public static int[] m_shotTargetObject;
    public static int[] m_shootLastPlayer;
    public static int m_shootLastDistance;
    public static int m_shootLastIdealShotType;
    public static int m_shootLastShotType;
    public static final boolean DISPLAY_PASS_TRAJECTORIES = true;
    public static boolean m_forcePassToSpace;
    public static boolean m_displayPassTrajectory;
    public static int[] m_passTrajectoryMarker;
    public static final int PASS_STARTX = 0;
    public static final int PASS_STARTY = 1;
    public static final int PASS_STARTZ = 2;
    public static final int PASS_ENDX = 3;
    public static final int PASS_ENDY = 4;
    public static final int PASS_ENDZ = 5;
    public static final int PASS_TICKS = 6;
    public static final int PASS_SWERVEX = 7;
    public static final int PASS_SWERVEY = 8;
    public static final int PASS_FRAME = 9;
    public static final int PASS_SIZE = 10;
    public static int[] m_playerSubOff;
    public static int[] m_playerSubOn;
    public static int[] m_playerInjured;
    public static int[] m_menuPlayerInjured;
    public static int[] m_goalkeeperDiveTable;
    public static byte[] m_goalkeeperDiveFrameOffsetsList;
    public static short[] m_goalkeeperDiveFrameOffsetsToHands;
    public static short[] m_shootoutGoalkeeperDiveFrameOffsetsToHands;
    public static int[] m_dbgBallTrajectoryEnd;
    public static int[] m_dbgPassingAnalysisOrigin;
    public static int[] m_dbgPassingAnalysisTargetPlayer;
    public static int[][] m_dbgPassingAnalysisOppositionPlayers;
    public static int m_dbgPassingAnalysisPlayerCount;
    public static int m_dbgPassingAnalysisPreferredDirection;
    public static int m_dbgPassingAnalysisAngleRange;
    public static int m_dbgPassingAnalysisRadius;
    public static int[][] m_dbgThroughBallOppositionPlayers;
    public static int m_dbgThroughBallPlayerCount;
    public static int m_dbgThroughBallRunDist;
    public static int m_dbgThroughBallPreferredDirection;
    public static int m_dbgThroughBallAngleRange;
    public static int m_dbgThroughBallRadius;
    public static boolean debugShotTypeCheatOn;
    public static int debugshottype;
    public static int m_dbgPassIntoSpaceRunDist;
    public static int m_plrRunOntoBallDir;
    public static int m_playerWithBallDribbleSpeed;
    public static int m_idealShotType;
    public static int m_tackleShadowScale;
    public static int[] m_animationPassTarget;
    private static int m_animationPassFlags;
    public static int[] m_playerRunningOntoBall;
    private static int m_runOntoBallTimer;
    public static int m_runOntoBallAction;
    public static int m_passType;
    public static int[] m_passEvalPlayerList;
    public static int m_passEvalPlayerListCount;
    public static int[] m_throughBallExclusionDirs;
    public static int m_calculatedSwerveX;
    public static int m_calculatedSwerveY;
    public static int m_calculatedAttackingPassOffsetXDistance;
    public static int m_calculatedAttackingPassOffsetYDistance;
    public static boolean m_ballInSwerveCross;
    public static boolean m_crossIsCornerKick;
    public static int freeballcounter;
    public static int[] m_tempStorage;
    public static int[] m_shotTypeTable;
    public static int m_ballhandoffX;
    public static int m_ballhandoffY;
    public static int m_ballhandoffZ;
    public static int m_lastdribbleDir;
    public static int m_lastdribbleTimer;
    public static boolean doneheaderaction;
    public static boolean chestactiondone;
    public static int m_ballToGoalMarkerRunToPosX;
    public static int m_ballToGoalMarkerRunToPosY;
    public static int m_ballToGoalMarkerRunToPosJockeyX;
    public static int m_ballToGoalMarkerRunToPosJockeyY;
    public static int m_MarkerRunWidePosToUseX;
    public static int m_MarkerRunWidePosToUseY;
    public static int m_MarkerRunWidePosToDiscardX;
    public static int m_MarkerRunWidePosToDiscardY;
    public static int m_MarkerRunSideGrapplePosX;
    public static int m_MarkerRunSideGrapplePosY;
    public static int m_markTargetFacingAwayFromGoalRunToPosX;
    public static int m_markTargetFacingAwayFromGoalRunToPosY;
    public static int m_passIntoSpaceGoalSidePositionX;
    public static int m_passIntoSpaceGoalSidePositionY;
    public static int m_passIntoSpaceDefenceSidePositionX;
    public static int m_passIntoSpaceDefenceSidePositionY;
    private static final int[] PLAYERRATING_THRESHOLDS;
    private static final int PLAYERRATING_INITIAL_RATING = 30;
    private static final int PLAYERRATING_DEFENDER_INITIAL_RATING = 40;
    private static final int PLAYERRATING_KEEPER_SAVE_BONUS = 8;
    private static final int PLAYERRATING_KEEPER_SAVE_MAXBONUS = 50;
    private static final int PLAYERRATING_YELLOWCARD_PENALTY = 10;
    private static final int[] PLAYERRATING_CLEANSHEET_BONUS;
    private static final int[] PLAYERRATING_GOALS_CONCEDED_PENALTY;
    private static final int[] PLAYERRATING_GOALS_CONCEDED_MAXPENALTY;
    private static final int[] PLAYERRATING_PASS_BONUS;
    private static final int[] PLAYERRATING_PASS_MAXBONUS;
    private static final int[] PLAYERRATING_TACKLESWON_BONUS;
    private static final int[] PLAYERRATING_TACKLESWON_MAXBONUS;
    private static final int[] PLAYERRATING_SHOT_ONTARGET_BONUS;
    private static final int[] PLAYERRATING_SHOT_OFFTARGET_BONUS;
    private static final int[] PLAYERRATING_SHOTS_MAXBONUS;
    private static final int[] PLAYERRATING_GOAL_SCORED_BONUS;
    private static final int[] PLAYERRATING_GOAL_SCORED_MAXBONUS;
    private static final int[] PLAYERRATING_OWNGOAL_PENALTY;
    private static final int[] PLAYERRATING_OWNGOAL_MAXPENALTY;
    private static final int[] PLAYERRATING_LOST_BALL_PENALTY;
    private static final int[] PLAYERRATING_LOST_BALL_MAXPENALTY;
    private static final int[] PLAYERRATING_FOUL_PENALTY;
    private static final int[] PLAYERRATING_FOUL_MAXPENALTY;
    private static final int HIGH_STRENGTH_THRESHOLD = 80;
    private static final int MEDIUM_STRENGTH_THRESHOLD = 60;
    private static final int REDUCE_FATIGUE_EFFECT_HIGH = 2;
    private static final int REDUCE_FATIGUE_EFFECT_MEDIUM = 1;
    private static final int FREE_BALL_TIME = 3;
    public static final int PLAYER_BALLCOLLISION_MAXDISTANCE = 2;
    public static int[] diveAtFeetDribbler;
    public static boolean kickedball;
    private static final int PLAYER_CHASE_BALL_DISTANCE_THRESHOLD = 8;
    private static final int OUTOFPLAY_TIMER_STANDSTILL_THRESHOLD = 56;
    private static final int OUTOFPLAY_TIMER_INITIAL_JOSTLE_VALUE = 80;
    public static final int TACKLING_STOPPING_DISTANCE = 5;
    private static final int PASS_TO_HEAD_THRESHOLD = 70;
    private static final int PASS_TO_CHEST_THRESHOLD = 40;
    private static final int CELEBRATION_START_FRAME_RANGE = 10;
    private static final int KEEPER_CATCHSHOT_ACTION_TIME = 15;
    private static final int INITIAL_ACTION_TIME = 5;
    private static final int PLAYER_SPRINT_THRESHOLD = 30;
    public static boolean calculatedfinalposition;
    public static int[] theOneWhoShoot;
    public static int shootingPlayerFrameCnt;
    private static final int PLAYERS_RUN_OUT_OF_TUNNEL_STARTY_RANGE = 372;
    private static final int PLAYERS_RUN_OUT_OF_TUNNEL_ENDY_RANGE = 750;
    private static final int CLOSE_MISS_THRESHOLD = 25;
    private static final int NUM_KEEPER_SAVES_SHOT_CENTRE = 3;
    private static final int NUM_KEEPER_SAVES_SIDE_COVERED = 4;
    private static final int NUM_KEEPER_SAVES_SIDE_UNCOVERED = 6;
    private static final int NUM_KEEPER_BEATEN_SIDE_UNCOVERED = 3;
    private static final int CLOSE_RANGE_SHOT_THRESHOLD = 10;
    private static final int MIN_KEEPER_SAVE_DISTANCE = 4;
    private static final int TUTORIAL_TIME_DELAY = 4;
    private static final int KEEPER_OVERBAR_THRESHOLD = 50;
    private static final int VOLLEYSHOT_ACCURACY_THRESHOLD = 80;
    private static final int FIRSTTIMESHOT_ACCURACY_THRESHOLD = 80;
    private static int[] m_tempPlayer;
    private static final int DEFAULT_DIVE_DIST = 384;
    private static final int ANIM_DIRECTION_MASK = 7;
    private static final int ANIM_DIRECTION_SHIFT = 5;
    private static final int PLAYER_DIRECTION_THRESHOLD = 50;
    public static int m_passIntoSpaceEnemyDangerRadius;
    private static final int INITIAL_DRIBBLE_TIMER = 15;
    public static int[] m_throwAwayObject;
    public static final int BLUETOOTH_DATA_OFFSET_FRAME_COUNTER = 0;
    public static final int BLUETOOTH_DATA_OFFSET_JOYSTICK_BYTE0 = 1;
    public static final int BLUETOOTH_DATA_OFFSET_JOYSTICK_BYTE1 = 2;
    public static final int BLUETOOTH_DATA_OFFSET_JOYSTICK_BYTE2 = 3;
    public static final int BLUETOOTH_DATA_OFFSET_JOYSTICK_BYTE3 = 4;
    public static final int BLUETOOTH_DATA_OFFSET_INTERRUPT = 5;
    public static final int BLUETOOTH_DATA_OFFSET_BALL_X_BYTE0 = 6;
    public static final int BLUETOOTH_DATA_OFFSET_BALL_X_BYTE1 = 7;
    public static final int BLUETOOTH_DATA_OFFSET_BALL_X_BYTE2 = 8;
    public static final int BLUETOOTH_DATA_OFFSET_BALL_X_BYTE3 = 9;
    public static final int BLUETOOTH_DATA_OFFSET_BALL_Y_BYTE0 = 10;
    public static final int BLUETOOTH_DATA_OFFSET_BALL_Y_BYTE1 = 11;
    public static final int BLUETOOTH_DATA_OFFSET_BALL_Y_BYTE2 = 12;
    public static final int BLUETOOTH_DATA_OFFSET_BALL_Y_BYTE3 = 13;
    public static final int BLUETOOTH_DATA_OFFSET_PLAYER_DATA_CHECKSUM = 14;
    public static final int BLUETOOTH_TACTICS_DATA_OFFSET_TACTICS_STRATEGY = 0;
    public static final int BLUETOOTH_TACTICS_DATA_OFFSET_TACTICS_MARKING = 1;
    public static final int BLUETOOTH_TACTICS_DATA_OFFSET_TACTICS_PASSING = 2;
    public static final int BLUETOOTH_TACTICS_DATA_SIZE = 3;

    public static final void initAI() {
        m_playerStorage = new int[2][18][80];
        m_teamStorage = new short[2][21];
        m_ballStorage = new int[14];
        m_passTargetObject = new int[9];
        m_shotTargetObject = new int[9];
        m_passEvalPlayerList = new int[22];
        m_throughBallExclusionDirs = new int[16];
        m_passTrajectoryMarker = new int[10];
        XMLMenuSystem.initSubsData();
        m_goalkeeperDiveTable = DDFile.loadFileInts("/ad00.bin", true);
        m_goalkeeperDiveFrameOffsetsToHands = DDFile.loadFileShorts("/ad01.bin", true);
        m_goalkeeperDiveFrameOffsetsList = DDFile.loadFileBytes("/ad02.bin");
        m_stateLookUpTable = DDFile.loadFileInts("/ad03.bin", true);
        m_shotTypeTable = DDFile.loadFileInts("/ad04.bin", true);
    }

    public static final void resetMatchVariables() {
        int n2;
        GameLogic.m_movingSetPieceTarget = -1;
        GameAI.m_ballStorage[0] = 12311;
        GameAI.m_ballStorage[1] = 16007;
        GameAI.m_ballStorage[7] = 102;
        GameAI.m_ballStorage[8] = 102;
        m_playerWithBall = null;
        for (n2 = 0; n2 < 2; ++n2) {
            GameAI.m_teamStorage[n2][6] = 0;
            GameAI.m_teamStorage[n2][18] = 0;
            GameAI.m_teamStorage[n2][10] = 0;
            GameAI.m_teamStorage[n2][13] = 0;
            GameAI.m_teamStorage[n2][16] = 0;
            GameAI.m_teamStorage[n2][15] = 0;
            GameAI.m_teamStorage[n2][7] = 0;
            GameAI.m_teamStorage[n2][11] = 0;
            GameAI.m_teamStorage[n2][9] = 0;
            GameAI.m_teamStorage[n2][8] = 0;
            GameAI.m_teamStorage[n2][17] = 0;
            GameAI.m_teamStorage[n2][12] = 0;
            GameAI.m_teamStorage[n2][19] = 0;
        }
        m_goalScorer = null;
        Trajectory.resetAllTrajectoryData();
        for (n2 = 0; n2 < 9; ++n2) {
            GameAI.m_passTargetObject[n2] = 0;
            GameAI.m_shotTargetObject[n2] = 0;
            GameAI.m_tempStorage[n2] = 0;
        }
        for (n2 = 0; n2 < 80; ++n2) {
            GameAI.m_tempPlayer[n2] = 0;
        }
        freeballcounter = 0;
        m_lastdribbleDir = 0;
        m_lastdribbleTimer = 0;
        doneheaderaction = false;
        chestactiondone = false;
        m_playerSubOn = null;
        m_playerSubOff = null;
        m_playerRunningOntoBall = null;
        m_animationPassTarget = null;
        m_shootLastDistance = 0;
        m_shootLastIdealShotType = 0;
        m_shootLastPlayer = null;
        m_shootLastShotType = 0;
        m_animationPassFlags = 0;
        m_runOntoBallTimer = 0;
        m_runOntoBallAction = 0;
        m_passType = 0;
        m_playerWithBallDribbleSpeed = 0;
        m_idealShotType = 0;
        m_playerInjured = null;
        m_targetPlayer = null;
        m_menuPlayerInjured = null;
        m_plrRunOntoBallDir = 0;
        for (n2 = 0; n2 < 22; ++n2) {
            GameAI.m_passEvalPlayerList[n2] = 0;
        }
        for (n2 = 0; n2 < 16; ++n2) {
            GameAI.m_throughBallExclusionDirs[n2] = 0;
        }
        m_calculatedSwerveX = 0;
        m_calculatedSwerveY = 0;
        m_calculatedAttackingPassOffsetXDistance = 0;
        m_calculatedAttackingPassOffsetYDistance = 0;
        m_ballhandoffX = 0;
        m_ballhandoffY = 0;
        m_ballhandoffZ = 0;
    }

    public static final void resetAllPlayerData() {
        int n2;
        for (n2 = 0; n2 < 2; ++n2) {
            int n3;
            for (n3 = 0; n3 < 18; ++n3) {
                for (int i2 = 0; i2 < 80; ++i2) {
                    GameAI.m_playerStorage[n2][n3][i2] = 0;
                }
            }
            for (n3 = 0; n3 < 21; ++n3) {
                GameAI.m_teamStorage[n2][n3] = 0;
            }
        }
        for (n2 = 0; n2 < 14; ++n2) {
            GameAI.m_ballStorage[n2] = 0;
        }
        MainFrame.m_bluetoothInSync = true;
    }

    public static final int calculateManOfTheMatch(int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        short s = m_teamStorage[n2 ^ 1][6];
        short s2 = m_teamStorage[n2][6];
        for (n3 = 0; n3 < 18; ++n3) {
            GameAI.calcStatsForPlayer(m_playerStorage[n2][n3], s2, s);
            GameAI.updatePlayerForm(m_playerStorage[n2][n3], n3);
        }
        n4 = 0;
        for (n3 = 0; n3 < 18; ++n3) {
            if (m_playerStorage[n2][n3][72] <= n5) continue;
            n5 = m_playerStorage[n2][n3][72];
            n4 = XMLMenuSystem.m_currentLineup[0][n3];
        }
        return n4;
    }

    private static final void calcStatsForPlayer(int[] nArray, int n2, int n3) {
        int n4;
        int n5 = nArray[48];
        int n6 = (n5 = DDMath.min(n5, 3)) == 0 || n5 == 1 ? 40 : 30;
        if (n5 == -1) {
            return;
        }
        if (n3 == 0) {
            n6 += PLAYERRATING_CLEANSHEET_BONUS[n5];
        } else {
            n4 = 0;
            n4 = n3 * PLAYERRATING_GOALS_CONCEDED_PENALTY[n5];
            if (n4 > PLAYERRATING_GOALS_CONCEDED_MAXPENALTY[n5]) {
                n4 = PLAYERRATING_GOALS_CONCEDED_MAXPENALTY[n5];
            }
            n6 -= n4;
        }
        n6 -= nArray[69] * 10;
        if (n5 == 0) {
            n4 = 0;
            n4 = nArray[71] * 8;
            if (n4 > 50) {
                n4 = 50;
            }
            n6 += n4;
        } else {
            n4 = 0;
            n4 = nArray[62] * PLAYERRATING_PASS_BONUS[n5];
            if (n4 > PLAYERRATING_PASS_MAXBONUS[n5]) {
                n4 = PLAYERRATING_PASS_MAXBONUS[n5];
            }
            n6 += n4;
            n4 = 0;
            n4 = nArray[67] * PLAYERRATING_TACKLESWON_BONUS[n5];
            if (n4 > PLAYERRATING_TACKLESWON_MAXBONUS[n5]) {
                n4 = PLAYERRATING_TACKLESWON_MAXBONUS[n5];
            }
            n6 += n4;
            n4 = 0;
            n4 = nArray[64] * PLAYERRATING_SHOT_ONTARGET_BONUS[n5];
            if ((n4 += nArray[65] * PLAYERRATING_SHOT_OFFTARGET_BONUS[n5]) > PLAYERRATING_SHOTS_MAXBONUS[n5]) {
                n4 = PLAYERRATING_SHOTS_MAXBONUS[n5];
            }
            n6 += n4;
            n4 = 0;
            n4 = nArray[66] * PLAYERRATING_GOAL_SCORED_BONUS[n5];
            if (n4 > PLAYERRATING_GOAL_SCORED_MAXBONUS[n5]) {
                n4 = PLAYERRATING_GOAL_SCORED_MAXBONUS[n5];
            }
            n6 += n4;
            n4 = 0;
            n4 = nArray[70] * PLAYERRATING_OWNGOAL_PENALTY[n5];
            if (n4 > PLAYERRATING_OWNGOAL_MAXPENALTY[n5]) {
                n4 = PLAYERRATING_OWNGOAL_MAXPENALTY[n5];
            }
            n6 -= n4;
            n4 = 0;
            n4 = nArray[63] * PLAYERRATING_LOST_BALL_PENALTY[n5];
            if (n4 > PLAYERRATING_LOST_BALL_MAXPENALTY[n5]) {
                n4 = PLAYERRATING_LOST_BALL_MAXPENALTY[n5];
            }
            n6 -= n4;
            n4 = 0;
            n4 = nArray[68] * PLAYERRATING_FOUL_PENALTY[n5];
            if (n4 > PLAYERRATING_FOUL_MAXPENALTY[n5]) {
                n4 = PLAYERRATING_FOUL_MAXPENALTY[n5];
            }
            n6 -= n4;
        }
        switch (nArray[48]) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        if (n2 > n3) {
            n6 += 10;
        } else if (n2 < n3) {
            n6 -= 10;
        }
        int n7 = 10;
        for (int i2 = 0; i2 < 6; ++i2) {
            if (n6 >= PLAYERRATING_THRESHOLDS[i2]) continue;
            n7 = i2 + 4;
            break;
        }
        nArray[72] = n7;
    }

    private static final void updatePlayerForm(int[] nArray, int n2) {
        if (nArray[48] == -1) {
            if (XMLMenuSystem.m_menuForm[n2] == 0) {
                return;
            }
            if (XMLMenuSystem.m_menuForm[n2] > 0) {
                int n3 = n2;
                XMLMenuSystem.m_menuForm[n3] = XMLMenuSystem.m_menuForm[n3] - 1;
            } else {
                int n4 = n2;
                XMLMenuSystem.m_menuForm[n4] = XMLMenuSystem.m_menuForm[n4] + 1;
            }
        } else {
            int n5 = n2;
            XMLMenuSystem.m_menuForm[n5] = XMLMenuSystem.m_menuForm[n5] + (nArray[72] - 7);
            XMLMenuSystem.m_menuForm[n2] = DDMath.max(XMLMenuSystem.m_menuForm[n2], -10);
            XMLMenuSystem.m_menuForm[n2] = DDMath.min(XMLMenuSystem.m_menuForm[n2], 10);
        }
    }

    public static final void setupStatsData() {
        int n2 = 0;
        for (n2 = 0; n2 < 6; ++n2) {
            XMLMenuSystem.m_workArray[10 + n2] = m_playerStorage[GameLogic.getPlayerTeam()][XMLMenuSystem.m_currentLineup[0][m_manOfTheMatch]][62 + n2];
        }
    }

    public static final void playersUpdate() {
        --m_runOntoBallTimer;
        for (int i2 = 0; i2 < 2; ++i2) {
            int[] nArray;
            int n2;
            int[] nArray2 = null;
            int n3 = Integer.MAX_VALUE;
            for (n2 = 0; n2 < 11; ++n2) {
                int n4;
                nArray = m_playerStorage[i2][n2];
                nArray[61] = nArray[61] + 1;
                if (nArray[49] == 2 && nArray[28] != 75) continue;
                if ((nArray[6] & 0x20000) != 0) {
                    nArray[24] = nArray[24] - 1;
                    if (nArray[24] > 0) continue;
                    nArray[6] = nArray[6] & 0xFFFDFFFF;
                }
                if (GameLogic.m_gameMode == 1 || GameLogic.m_gameMode == 6) {
                    int n5;
                    if (nArray[23] < 180) {
                        n5 = 0;
                    } else {
                        n4 = GameLogic.m_fatigueEffect * 1;
                        if (nArray[45] > 80) {
                            if (n4 > 2) {
                                n4 -= 2;
                            }
                        } else if (nArray[45] > 60) {
                            --n4;
                        }
                        n4 = DDMath.max(1, n4);
                        n5 = -(n4 * ((nArray[23] << 8) / 360) >> 8);
                    }
                    nArray[79] = nArray[79] + n5;
                    nArray[79] = DDMath.min(nArray[79], 25600);
                    nArray[79] = DDMath.max(nArray[79], 0);
                }
                n4 = DDMath.min(m_ballStorage[0], 24622);
                int n6 = DDMath.min(m_ballStorage[1], 32015);
                n4 = DDMath.max(n4, 0);
                n6 = DDMath.max(n6, 0);
                int n7 = n4 - nArray[0];
                int n8 = n6 - nArray[1];
                nArray[35] = DDMath.atan(n7, n8) & 0xFF;
                nArray[36] = DDMath.sqrtRout(n7 * n7 + n8 * n8 >> 16);
                if (!DDDebug.DEBUG_SCENARIO || GameLogic.debugScenarioGetData(nArray, 0) != 1 || GameLogic.debugScenarioGetData(nArray, 5) != 0) {
                    GameAI.playerUpdateDirection(nArray);
                    GameAI.playerUpdateVelocity(nArray);
                    GameAI.playerUpdatePosition(nArray);
                }
                boolean bl = GameAI.playerUpdateState(nArray, m_teamStorage[i2], i2);
                if (nArray[28] != 3 && nArray[28] != 11 && nArray[28] != 12 && nArray[28] != 81 && nArray[28] != 23 && nArray[28] != 29 && nArray[28] != 173 && nArray[28] != 174 && nArray[28] != 121 && nArray[28] != 123) {
                    if (GameLogic.m_matchState != 15 && GameLogic.m_matchState != 7 && GameLogic.m_matchState != 16 && nArray[28] != 141 && nArray[28] != 142 && nArray[28] != 18 && nArray[28] != 23 && nArray[28] != 18 && nArray[28] != 75) {
                        GameAI.keepPositionWithinPitch(nArray);
                        if (n2 > 0 && nArray[36] < n3 && nArray[30] <= 0 && (GameAI.ballIsPossessed() && nArray != GameAI.ballGetLastTouchPlayer() || !GameAI.ballIsPossessed())) {
                            nArray2 = nArray;
                            n3 = nArray[36];
                        }
                    }
                    if ((nArray[6] & 0x40) == 0 && nArray[36] < 15) {
                        GameLogic.Object_AddToCollisionList(nArray, n2 << 1 | i2);
                    }
                }
                if ((nArray[6] & 0x20) != 0 && !bl && n2 != 0 && GameLogic.m_matchState == 2 && (i2 != GameAI.ballGetLastTouchPlayerTeam() || nArray == GameAI.ballGetLastTouchPlayer() || i2 == GameAI.ballGetLastTouchPlayerTeam() && GameAI.ballGetLastTouchPlayer()[36] > 2) && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
                    if (GameLogic.m_possession != i2) {
                        int[] nArray3 = GameAI.ballGetLastTouchPlayer();
                        GameLogic.beAProCheckIfBAPStatAchieved(12, nArray3, null);
                    }
                    if (!DDDebug.DEBUG_SCENARIO || GameLogic.debugScenarioGetData(nArray, 0) != 1 || GameLogic.debugScenarioGetData(nArray, 6) != 0) {
                        GameAI.teamSetPossession(nArray, m_teamStorage[i2], i2);
                    }
                }
                nArray[6] = nArray[6] & 0xFFFFFFDF;
            }
            if (GameLogic.m_matchPeriod == 4) {
                if (GameLogic.m_matchState != 2) continue;
                if (GameLogic.isFreeBallSituation()) {
                    if (++freeballcounter != MainFrame.m_inGameFrameRate * 3) continue;
                    GameLogic.penaltyShootOutUpdateScores(false);
                    continue;
                }
                freeballcounter = 0;
                continue;
            }
            if (nArray2 == null || GameLogic.m_matchState != 2) continue;
            GameAI.playerUpdatePassTargets(nArray2);
            if (GameLogic.isFreeBallSituation()) {
                if (++freeballcounter <= MainFrame.m_inGameFrameRate || nArray2[28] == 34 || nArray2[28] == 13) continue;
                for (n2 = 0; n2 < 11; ++n2) {
                    nArray = m_playerStorage[i2][n2];
                    if (nArray[28] != 34) continue;
                    GameAI.playerSetState(nArray, 0, 0, 0);
                }
                GameAI.playerSetState(nArray2, 0, 0, 34);
                continue;
            }
            freeballcounter = 0;
        }
    }

    private static final void playerTriggerBallAction(int[] nArray, int n2, int n3) {
        if (GameLogic.m_controller[n2].m_180turn) {
            GameAI.playerTriggerBallAction180Turn(nArray, n2, n3);
        } else if (GameLogic.m_controller[n2].m_crossBallIntoPenaltyArea) {
            GameAI.playerTriggerBallActionCrossBallIntoPenaltyArea(nArray, n2, n3);
        } else if (GameLogic.m_controller[n2].m_passBall || GameLogic.m_controller[n2].m_throughBall || m_runOntoBallAction == 3 && m_runOntoBallTimer > 0 && nArray == m_playerRunningOntoBall) {
            GameAI.playerTriggerBallActionPassBallOrThroughBall(nArray, n2, n3);
        } else if (GameLogic.m_controller[n2].m_crossBall || m_runOntoBallAction == 2 && m_runOntoBallTimer > 0 && nArray == m_playerRunningOntoBall) {
            GameAI.playerTriggerBallActionCrossBall(nArray, n2, n3);
        } else if (GameLogic.m_controller[n2].m_clearBall || m_runOntoBallAction == 1 && m_runOntoBallTimer > 0 && nArray == m_playerRunningOntoBall) {
            GameAI.playerTriggerBallActionClearBall(nArray, n2, n3);
        } else if (GameLogic.m_controller[n2].m_kickBallForwards) {
            GameAI.playerTriggerBallActionKickBallForwards(nArray, n2, n3);
        } else if (GameLogic.m_controller[n2].m_shootBall || m_runOntoBallAction == 0 && m_runOntoBallTimer > 0 && nArray == m_playerRunningOntoBall) {
            GameAI.playerTriggerBallActionShootBall(nArray, n2, n3);
        } else {
            GameAI.dribbleBall(nArray, n3);
        }
    }

    private static final void playerTriggerBallAction180Turn(int[] nArray, int n2, int n3) {
        if (nArray[23] != 0) {
            GameAI.playerSetState(nArray, 0, 0, 32);
        } else {
            GameAI.playerSetState(nArray, 0, 0, 140);
        }
        GameLogic.m_controller[n2].m_180turn = false;
    }

    private static final void playerTriggerBallActionCrossBallIntoPenaltyArea(int[] nArray, int n2, int n3) {
        GameLogic.m_controller[n2].m_crossBallIntoPenaltyArea = false;
        GameLogic.m_controller[n2].m_crossBall = false;
        int n4 = GameAI.teamGetPitchSide(n2) == 0 ? 28926 : 3089;
        GameAI.playerSetState(nArray, 12311, n4, 172);
    }

    private static final void playerTriggerBallActionPassBallOrThroughBall(int[] nArray, int n2, int n3) {
        int[] nArray2;
        int n4 = 0;
        if (GameLogic.m_controller[n2].m_throughBall) {
            n4 = 0;
        }
        if (GameLogic.m_controller[n2].m_longPass) {
            nArray2 = GameAI.getPassTargetAlternate(nArray);
            if (nArray2 == null) {
                nArray2 = GameAI.getPassTarget(nArray);
            }
        } else {
            nArray2 = GameAI.getPassTarget(nArray);
            if (nArray2 == null) {
                nArray2 = GameAI.getPassTargetAlternate(nArray);
            }
            if (nArray2 != null && nArray2[36] > 50) {
                GameAI.playerUpdatePassTargetsForShortPass(nArray);
                nArray2 = GameAI.getPassTarget(nArray);
                if (nArray2 == null) {
                    nArray2 = GameAI.getPassTargetAlternate(nArray);
                }
            }
        }
        int n5 = 1;
        if (nArray != null && nArray2 != null) {
            n5 = DDMath.calcTurnAngle(nArray[22], DDMath.calcAngle(nArray, nArray2));
        }
        if (DDMath.abs(n5) > 32) {
            n5 = DDMath.restrictRange(n5, -32, 32);
            m_ballStorage[11] = m_ballStorage[11] + n5;
            m_ballStorage[11] = m_ballStorage[11] & 0xFF;
            nArray[22] = m_ballStorage[11];
            GameAI.dribbleBall(nArray, nArray[22]);
            nArray[30] = nArray[30] + 1;
        } else {
            int[] nArray3 = m_playerStorage[n2][nArray[9]];
            nArray3[62] = nArray3[62] + 1;
            short[] sArray = m_teamStorage[n2];
            sArray[16] = (short)(sArray[16] + 1);
            if (GameLogic.m_controller[n2].m_longPass && nArray[33] != 0 && GameLogic.m_controller[n2].m_microGame.m_markerPosition > 50) {
                if (GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(n2))) {
                    n4 |= 0x20;
                }
                n4 |= 4;
            } else {
                n4 |= 1;
            }
            if (GameLogic.m_controller[n2].m_returningOneTwoPassPlayer == nArray2) {
                n4 |= 0x10;
            }
            GameLogic.m_controller[n2].m_returningOneTwoPassPlayer = null;
            if (GameLogic.m_controller[n2].m_throughBall) {
                n4 |= 8;
            }
            GameAI.AnimatePass(nArray, nArray2, n4, -1);
            GameLogic.m_controller[n2].m_passBall = false;
            GameLogic.m_controller[n2].m_crossBall = false;
            GameLogic.m_controller[n2].m_throughBall = false;
            m_playerRunningOntoBall = null;
            if (GameLogic.m_controller[n2].m_passBallAndRun) {
                DDDebug.msg("ONE_TWO_PASSING: This player is passing the ball then he's going to run ready for the one-two");
                nArray[29] = 119;
                GameLogic.m_controller[n2].m_returningOneTwoPassPlayer = nArray2;
                GameLogic.m_controller[n2].m_passBallAndRun = false;
            }
        }
    }

    private static final void playerTriggerBallActionCrossBall(int[] nArray, int n2, int n3) {
        int[] nArray2 = null;
        boolean bl = false;
        int[] nArray3 = m_playerStorage[n2][nArray[9]];
        nArray3[62] = nArray3[62] + 1;
        GameLogic.beAProCheckIfBAPStatAchieved(1, m_playerStorage[n2][nArray[9]], null);
        int n4 = 32;
        boolean bl2 = false;
        if (GameLogic.m_controller[n2].m_longPass && (nArray2 = GameAI.playerUpdatePassTargetsCross(nArray, n2)) != null) {
            bl2 = true;
        }
        if (!bl2) {
            if (GameAI.getPassTargetAlternate(nArray) != null) {
                nArray2 = GameAI.getPassTargetAlternate(nArray);
                bl = false;
            } else if (GameAI.getPassTarget(nArray) != null) {
                nArray2 = GameAI.getPassTarget(nArray);
                bl = false;
            } else {
                bl = true;
            }
        }
        if (!bl) {
            int n5 = nArray2[0] - nArray[0];
            int n6 = nArray2[1] - nArray[1];
            n4 = n5 * n5 + n6 * n6 < 0x640000 ? 1 : (n4 |= GameAI.chooseHeaderVolleyOrOverheadKick(nArray2));
        } else {
            n4 = GameAI.keeperInterceptCross(n2 ^ 1, false);
            nArray2 = GameLogic.m_setPieceTargetObject;
        }
        GameAI.AnimatePass(nArray, nArray2, n4, -1);
        GameLogic.m_controller[n2].m_crossBall = false;
        m_playerRunningOntoBall = null;
        if (GameAI.teamGetControlType(n2) == 0 && nArray2 != GameLogic.m_setPieceTargetObject && (n4 & 0x20) != 0) {
            GameAI.setupRunOntoBall(nArray2, 5);
        }
    }

    private static final void playerTriggerBallActionClearBall(int[] nArray, int n2, int n3) {
        nArray[21] = nArray[22] = nArray[14];
        GameAI.ballSetDribbleDirection(nArray[22]);
        GameAI.playerSetAnimation(nArray, 18);
        GameAI.Clearance(nArray, n2, 2);
        GameAI.playerSetState(nArray, 0, 0, 67);
        m_playerRunningOntoBall = null;
    }

    private static final void playerTriggerBallActionKickBallForwards(int[] nArray, int n2, int n3) {
        GameAI.kickBallForwards(nArray);
    }

    private static final void playerTriggerBallActionShootBall(int[] nArray, int n2, int n3) {
        if (m_runOntoBallAction != 0 || m_runOntoBallTimer <= 0 || nArray == m_playerRunningOntoBall) {
            // empty if block
        }
        GameAI.AnimateShot(nArray);
        GameLogic.m_controller[n2].m_shootBall = false;
        m_playerRunningOntoBall = null;
    }

    private static final int playerGetMarkPlayerWithBallMarkTimer(int[] nArray) {
        switch (nArray[52]) {
            case 1: 
            case 5: {
                return GameLogic.m_difficultySettingTackleTime_LB_RB;
            }
            case 3: {
                return GameLogic.m_difficultySettingTackleTime_CB;
            }
            case 2: 
            case 4: 
            case 14: {
                return GameLogic.m_difficultySettingTackleTime_LCB_RCB;
            }
        }
        return GameLogic.m_difficultySettingTackleTime_Default;
    }

    public static final void playerSetAnimation(int[] nArray, int n2) {
        if ((nArray[6] & 0x4000) != 0 && nArray[28] == 9) {
            return;
        }
        if (nArray[60] == 66 || nArray[60] == 65 || nArray[60] == 73 || nArray[60] == 72 || nArray[60] == 67) {
            GameAI.ballSetDrawnWithinFrame(nArray, false);
            GameAI.ballSetCollision(true);
        }
        if (n2 == 66 || n2 == 65 || n2 == 73 || n2 == 72) {
            GameAI.ballSetDrawnWithinFrame(nArray, true);
            nArray[6] = nArray[6] | 0x4000;
        }
        if ((nArray[6] & 0x40000) != 0) {
            n2 = 32;
        }
        if (n2 != nArray[60]) {
            nArray[59] = -1;
            nArray[61] = 0;
        }
        nArray[60] = n2;
    }

    private static final void playerSelectMovementAnimation(int[] nArray) {
        boolean bl;
        int n2 = nArray[60];
        int n3 = nArray[12];
        int n4 = n2;
        int[] nArray2 = GameAI.ballGetLastTouchPlayer();
        boolean bl2 = bl = nArray == nArray2 && nArray2[36] < 2;
        if (nArray[23] == 0) {
            int n5 = DDMath.calcTurnAngle(m_ballStorage[11], nArray[21]);
            if (n2 == 67) {
                if (nArray[61] > MainFrame.m_inGameFrameRate / 4) {
                    n4 = 62;
                }
            } else if (nArray[28] == 9 && bl && nArray[36] < 2 && (nArray[6] & 0x4000) == 0 && DDMath.abs(n5) >= 32 && DDMath.abs(n5) <= 64) {
                n4 = DDMath.abs(n5) > 32 ? (n5 > 0 ? 66 : 65) : (n5 > 0 ? 73 : 72);
            } else if (nArray[36] < 3 || nArray[28] == 93) {
                if (nArray[28] == 9 && n2 == 2 && nArray[61] < MainFrame.m_inGameFrameRate / 3) {
                    n4 = 2;
                } else {
                    if (!GameLogic.m_controller[n3].m_passBall) {
                        n4 = 62;
                    }
                    if (nArray[28] == 9) {
                        GameAI.m_ballStorage[3] = 0;
                        GameAI.m_ballStorage[4] = 0;
                    }
                }
            } else {
                n4 = 0;
            }
        } else if ((nArray[6] & 8) != 0) {
            n4 = 49;
        } else if ((nArray[6] & 4) != 0) {
            n4 = 50;
        } else if ((nArray[6] & 0x10) != 0) {
            n4 = 51;
        } else if (nArray[23] < 47) {
            if (nArray[28] == 93 || nArray[28] == 13 && DDMath.CalcModDifference(nArray[14], nArray[22]) < 32) {
                n4 = 63;
            } else if (n2 == 61 || n2 == 62 || n2 == 75 || n2 == 0 || n2 == 47 || !bl) {
                n4 = 61;
            } else {
                nArray[23] = 0;
                n4 = 67;
            }
        } else {
            n4 = nArray[23] <= 180 ? 60 : (nArray[23] <= 308 ? 16 : 33);
        }
        if ((nArray[6] & 0x4000) != 0 && nArray[61] >= GameRender.animationGetDuration(nArray[60]) - 1) {
            GameAI.ballSetDrawnWithinFrame(nArray, false);
            nArray[6] = nArray[6] & 0xFFFFBFFF;
            n4 = 0;
        }
        if (n4 != n2) {
            GameAI.playerSetAnimation(nArray, n4);
        }
    }

    public static final void adjustKeeperDivingShootDir(int[] nArray, int n2) {
        int n3 = nArray[22] + 16 >> 5;
        if (nArray[14] == 0) {
            nArray[60] = 95;
            switch (n3) {
                case 0: {
                    nArray[22] = 192;
                    break;
                }
                case 1: {
                    nArray[22] = 224;
                    break;
                }
                case 2: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    nArray[22] = 160;
                }
            }
            if (n2 == 2) {
                nArray[22] = nArray[22] + 128;
                nArray[22] = nArray[22] & 0xFF;
            }
        } else {
            nArray[60] = 96;
            switch (n3) {
                case 2: {
                    break;
                }
                case 3: {
                    nArray[22] = 160;
                    break;
                }
                case 4: {
                    nArray[22] = 192;
                    break;
                }
                case 5: {
                    nArray[22] = 224;
                    break;
                }
            }
            if (n2 == 2) {
                nArray[22] = nArray[22] + 128;
                nArray[22] = nArray[22] & 0xFF;
            }
        }
    }

    public static final int adjustKeeperDivingAtFeetDir(int[] nArray) {
        int n2 = m_playerWithBall[0] - nArray[0];
        int n3 = m_playerWithBall[1] - nArray[1];
        boolean bl = DDMath.abs(n2) > DDMath.abs(n3);
        int n4 = nArray[22] + 16 >> 5;
        if (n4 != 2 && n4 != 6) {
            if (bl && n2 > 0 && n3 > 0) {
                nArray[21] = 96;
                nArray[22] = 96;
            } else if (bl && n2 > 0 && n3 <= 0) {
                nArray[21] = 32;
                nArray[22] = 32;
            } else if (bl && n2 <= 0 && n3 > 0) {
                nArray[21] = 160;
                nArray[22] = 160;
            } else if (bl && n2 <= 0 && n3 <= 0) {
                nArray[21] = 224;
                nArray[22] = 224;
            } else if (!bl && n2 > 0 && n3 > 0) {
                nArray[21] = 224;
                nArray[22] = 224;
            } else if (!bl && n2 > 0 && n3 <= 0) {
                nArray[21] = 160;
                nArray[22] = 160;
            } else if (!bl && n2 <= 0 && n3 > 0) {
                nArray[21] = 32;
                nArray[22] = 32;
            } else if (!bl && n2 <= 0 && n3 <= 0) {
                nArray[21] = 96;
                nArray[22] = 96;
            }
        }
        if (n3 > 0) {
            return 95;
        }
        return 96;
    }

    public static final void playerSetState(int[] nArray, int n2, int n3, int n4) {
        int n5;
        if (nArray == null) {
            return;
        }
        int n6 = nArray[12];
        int n7 = nArray[60];
        int n8 = n4 * 4;
        if (nArray[28] == 81) {
            return;
        }
        if (n4 == 69) {
            n5 = 0;
        }
        int n9 = nArray[28];
        nArray[28] = n4;
        nArray[17] = 0;
        int n10 = m_stateLookUpTable[n8 + 1];
        if (n9 == 139 && n4 == 59) {
            nArray[17] = 0;
        }
        if ((n10 & 0x200) == 0) {
            nArray[6] = nArray[6] & 0x7C0000;
        }
        if ((n10 & 0x800) != 0) {
            nArray[6] = nArray[6] | 0x80;
        }
        if ((n10 & 0x400) != 0) {
            nArray[6] = nArray[6] | 0x1000;
        }
        if (nArray[48] == 0 && GameAI.ballIsPossessed() && GameAI.ballGetLastTouchPlayer() == nArray && (n4 == 90 || n4 == 29 || n4 == 12 || n4 == 32 || n4 == 140)) {
            GameAI.ballSetDrawnWithinFrame(nArray, true);
        }
        nArray[31] = DDMath.getPositiveRandom();
        if ((n9 == 32 || n9 == 140) && GameFormation.getPlayerType(GameAI.ballGetLastTouchPlayer()[52]) != 0) {
            GameAI.ballSetDrawnWithinFrame(nArray, false);
            GameAI.ballSetCollision(true);
        }
        if (m_stateLookUpTable[n8 + 0] >= 0) {
            n5 = m_stateLookUpTable[n8 + 0];
            if ((n5 == 10 || n5 == 95 || n5 == 96) && n4 == 28) {
                n5 = GameAI.adjustKeeperDivingAtFeetDir(nArray);
            }
            if (n5 != 33 && n5 != 16 || n7 != 33 && n7 != 16) {
                if (n4 == 9 && nArray[23] == 0) {
                    GameAI.playerSelectMovementAnimation(nArray);
                } else {
                    if (n4 == 91) {
                        int[] nArray2 = GameAI.ballGetLastTouchPlayer();
                        int n11 = nArray[0] - nArray2[0];
                        int n12 = nArray[1] - nArray2[1];
                        int n13 = DDMath.atan(n11, n12);
                        int n14 = DDMath.CalcModDifference(nArray2[22], n13);
                        int n15 = nArray2[22] - nArray[22] & 0xFF;
                        if (n14 <= 71 || GameLogic.m_controller[n6].m_microGameTackle && GameLogic.m_controller[n6].m_microGame.getResult() == 2) {
                            if (n15 < 32) {
                                n5 = 70;
                            } else if (n15 > 224) {
                                n5 = 69;
                            }
                        }
                    }
                    GameAI.playerSetAnimation(nArray, n5);
                    if ((m_stateLookUpTable[n8 + 1] & 0x80) != 0) {
                        nArray[59] = DDMath.getPositiveRandom() % GameRender.animationGetNumFrames(nArray[60]);
                    }
                }
            } else if ((n4 != 9 || nArray[23] != 0) && nArray[60] != n5) {
                nArray[60] = n5;
            }
        }
        if (m_stateLookUpTable[n8 + 2] >= 0) {
            nArray[30] = (int)((double)m_stateLookUpTable[n8 + 2] * ((double)MainFrame.m_inGameFrameRate / 12.0));
        }
        if (m_stateLookUpTable[n8 + 3] >= 0) {
            nArray[29] = m_stateLookUpTable[n8 + 3];
        }
        if ((n10 & 1) != 0) {
            GameAI.playerStopRunning(nArray);
        }
        if ((n10 & 2) != 0) {
            GameAI.playerSetMoveTargetPosition(nArray, n2, n3);
        }
        if ((n10 & 4) != 0) {
            GameAI.playerSetMoveTargetPosition(nArray, nArray[25], nArray[26]);
            if (nArray[9] != 0 && GameLogic.m_matchState == 2) {
                GameAI.formationOffsetPlayerMovePosition(nArray);
            }
        }
        if ((n10 & 8) != 0) {
            nArray[25] = n2;
            nArray[26] = n3;
        }
        if ((n10 & 0x10) != 0) {
            GameLogic.m_setPieceTaker = nArray;
        }
        if ((n10 & 0x20) != 0) {
            nArray[30] = GameRender.animationGetDuration(nArray[60]);
        }
        if (n4 == 138) {
            GameAI.playerSetStateGrapplingAndHasBall(nArray, n9, n7);
        } else if (n4 == 86) {
            GameAI.playerSetStateCelebrateCupWon(nArray, n9, n7);
        } else if (n4 == 192) {
            GameAI.playerSetStateFailedJumpForHeader(nArray, n9, n7);
        } else if (n4 == 189) {
            GameAI.playerSetStateGoalKeeperCatchBallAboveHead(nArray, n9, n7);
        } else if (n4 == 172) {
            GameAI.playerSetStateCrossBallIntoPenaltyArea(nArray, n9, n7);
        } else if (n4 == 171) {
            GameAI.playerSetStateGoalKeeperNarrowTheAngle(nArray, n9, n7);
        } else if (n4 == 153) {
            GameAI.playerSetStateShovePlayerForwards(nArray, n9, n7);
        } else if (n4 == 59) {
            GameAI.playerSetStateStandingTackle(nArray, n9, n7);
        } else if (n4 == 179) {
            GameAI.playerSetStateGoalKeeperCatchBallBody(nArray, n9, n7);
        } else if (n4 == 181) {
            GameAI.playerSetStateGoalKeeperCatchBallLow(nArray, n9, n7);
        } else if (n4 == 29) {
            GameAI.playerSetStateGoalKeeperDropKickWait(nArray, n9, n7);
        } else if (n4 == 180) {
            GameAI.playerSetStateGoalKeeperClearance(nArray, n9, n7);
        } else if (n4 == 160) {
            GameAI.playerSetStateGoalKeeperClearance(nArray, n9, n7);
        } else if (n4 == 188) {
            GameAI.playerSetStateGoalKeeperCatchShotFromDistance(nArray, n9, n7);
        } else if (n4 == 175) {
            GameAI.playerSetStateSlideToInterceptBall(nArray, n9, n7);
        } else if (n4 == 173) {
            GameAI.playerSetStateGoalKeeperDropKick(nArray, n9, n7);
        } else if (n4 == 174) {
            GameAI.playerSetStateGoalKeeperThrowBallOut(nArray, n9, n7);
        } else if (n4 == 184) {
            GameAI.playerSetStateRunToJostleForTheBall(nArray, n9, n7);
        } else if (n4 == 66) {
            GameAI.playerSetStateStandingHeaderShoot(nArray, n9, n7);
        } else if (n4 == 163) {
            GameAI.playerSetStateFirstTimeGroundPass(nArray, n9, n7);
        } else if (n4 == 177) {
            GameAI.playerSetStateGoalKeeperInterceptPass(nArray, n9, n7);
        } else if (n4 == 33) {
            GameAI.playerSetStateInterceptPass(nArray, n9, n7);
        } else if (n4 == 164) {
            GameAI.playerSetStateFirstTimeVolleyPass(nArray, n9, n7);
        } else if (n4 == 178) {
            GameAI.playerSetStateGoalKeeperPunchBallAway(nArray, n9, n7);
        } else if (n4 == 165) {
            GameAI.playerSetStateFirstTimeHeaderPass(nArray, n9, n7);
        } else if (n4 == 169) {
            GameAI.playerSetStateControlBallWithJumpingChest(nArray, n9, n7);
        } else if (n4 == 170) {
            GameAI.playerSetStateControlBallWithChest(nArray, n9, n7);
        } else if (n4 == 166) {
            GameAI.playerSetStateGroundClearance(nArray, n9, n7);
        } else if (n4 == 167) {
            GameAI.playerSetStateHeaderClearance(nArray, n9, n7);
        } else if (n4 == 92) {
            GameAI.playerSetStateDivingHeader(nArray, n9, n7);
        } else if (n4 == 60) {
            GameAI.playerSetStateStumble(nArray, n9, n7);
        } else if (n4 == 14) {
            GameAI.playerSetStateTackled(nArray, n9, n7);
        } else if (n4 == 16) {
            GameAI.playerSetStateWaitShortPassFromGoal(nArray, n9, n7);
        } else if (n4 == 185) {
            GameAI.playerSetStateWaitShortPassFromThrowIn(nArray, n9, n7);
        } else if (n4 == 186) {
            GameAI.playerSetStateRunToShortPassFromThrowIn(nArray, n9, n7);
        } else if (n4 == 146) {
            GameAI.playerSetStateAttackingSetPeiceLoopAround(nArray, n9, n7);
        } else if (n4 == 148) {
            GameAI.playerSetStateAttackingSetPieceFigureOfEight(nArray, n9, n7);
        } else if (n4 == 145) {
            GameAI.playerSetStateWaitAttackingRun(nArray, n9, n7);
        } else if (n4 == 143) {
            GameAI.playerSetStateDefendRunnersFromSetPiece(nArray, n9, n7);
        } else if (n4 == 0) {
            GameAI.playerSetStateIdle(nArray, n9, n7);
        } else if (n4 == 193) {
            GameAI.playerSetStateIdle(nArray, n9, n7);
        } else if (n4 == 71) {
            GameAI.playerSetStateFormationRunToPos(nArray, n9, n7);
        } else if (n4 == 139) {
            GameAI.playerSetStateGrapplingDoesntHaveBall(nArray, n9, n7);
        } else if (n4 == 9) {
            GameAI.playerSetStateDribble(nArray, n9, n7);
        } else if (n4 == 60) {
            nArray[6] = nArray[6] | 0x40;
        } else if (n4 == 34) {
            GameAI.playerSetStateChaseBall(nArray, n9, n7);
        } else if (n4 == 176) {
            GameAI.playerSetStateRunOntoInterception(nArray, n9, n7);
        } else if (n4 == 77) {
            GameAI.playerSetStateVolley(nArray, n9, n7);
        } else if (n4 == 28) {
            GameAI.playerSetStateGoalkeeperDiveAtPlayersFeet(nArray, n9, n7);
        } else if (n4 == 77 || n4 == 78) {
            nArray[22] = nArray[21] = (n5 = DDMath.atan(12311 - nArray[0], (nArray[14] == 128 ? 0 : 32015) - nArray[1]));
        } else if (n4 == 96) {
            GameAI.playerSetStateOverHeadKick(nArray, n9, n7);
        } else if (n4 == 119) {
            GameAI.playerSetStateRunReadyForOneTwo(nArray, n9, n7);
        } else if (n4 == 118) {
            int[] nArray3 = GameLogic.nearestPlayerData(nArray, n6 ^ 1, 0);
            if (nArray3 != null) {
                nArray3[30] = nArray[30] = DDMath.getPositiveRandom() % 64;
                GameAI.playerSetState(nArray3, 0, 0, 120);
            }
        } else if (n4 == 91) {
            GameAI.playerSetStateSlideTackle(nArray, n9, n7);
        } else if (n4 == 147) {
            GameAI.playerSetStateMarkLongPassFromGoalKickPlayer(nArray, n9, n7);
        } else if (n4 == 93) {
            GameAI.playerSetStateMarkPlayerWithTheBall(nArray, n9, n7);
        } else if (n4 == 70) {
            GameAI.playerSetStateControlBall(nArray, n9, n7);
        } else if (n4 != 90) {
            if (n4 == 74) {
                nArray[6] = nArray[6] | 0x40;
                GameAI.playerSetAnimation(nArray, 36 + (DDMath.getRandom() & 6));
            } else if (n4 == 76) {
                nArray[22] = (nArray[9] & 1) * 6 * 32;
                nArray[21] = nArray[22];
            } else if (n4 == 72) {
                GameAI.playerStopRunning(nArray);
                nArray[6] = nArray[6] | 0x40;
                if (GameLogic.m_controller[n6 ^ 1].m_microGame.m_type == 0 && GameLogic.m_controller[n6 ^ 1].m_microGame.getResult() == 3) {
                    nArray[30] = nArray[30] >> 1;
                }
            } else if (n4 == 81) {
                GameAI.playerSetStateInjury(nArray, n9, n7);
            } else if (n4 == 40 || n4 == 47) {
                GameAI.playerSetStateGoalKeeperDiveAndSaveWithBall(nArray, n9, n7);
            } else if (n4 == 10) {
                GameAI.playerSetStatePassedTo(nArray, n9, n7);
            } else if (n4 == 183) {
                GameAI.playerSetStateRunOntoOverTheTopThroughBall(nArray, n9, n7);
            } else if (n4 == 13) {
                GameAI.playerSetStateHumanControl(nArray, n9, n7);
            } else if (n4 == 102 || n4 == 103) {
                GameAI.playerSprintToMovePosition(nArray);
                GameAI.playerRunUsingPreciseTarget(nArray);
                nArray[17] = nArray[17] | 0x40;
            } else if (n4 == 27) {
                GameAI.playerSetStateGoalkeeperRushDribbler(nArray, n9, n7);
            } else if (n4 == 32 || n4 == 140) {
                GameAI.playerSetState180(nArray, n9, n7);
            } else if (n4 == 22) {
                GameAI.playerSetStateDefendSetPiece(nArray, n9, n7);
            } else if (n4 == 38) {
                GameAI.playerSetStateShootBall(nArray, n9, n7);
            } else if (n4 == 190) {
                GameAI.playerSetStatePassBallShort(nArray, n9, n7);
            } else if (n4 == 191) {
                GameAI.playerSetStatePassBallLong(nArray, n9, n7);
            } else if (n4 >= 39 && n4 <= 57 || n4 >= 112 && n4 <= 113) {
                GameAI.playerSetStateGoalKeeperStateTableStates(nArray, n9, n7);
            } else if (n4 == 125 || n4 == 126) {
                nArray[5] = GameLogic.PLAYER_JUMP_VELOCITY;
                nArray[22] = nArray[21] = nArray[35];
            } else if (n4 == 82) {
                nArray[23] = 256;
            } else if (n4 == 99) {
                nArray[23] = 256;
            } else if (n4 == 100) {
                n5 = nArray[22];
                int n16 = (int)(3584.0 / (double)MainFrame.m_inGameFrameRate);
                nArray[3] = DDMath.sin(n5) * n16 >> 16;
                nArray[4] = DDMath.cos(n5) * n16 >> 16;
                nArray[23] = 256;
                nArray[60] = 44;
            } else if (n4 == 101 || n4 == 129) {
                nArray[23] = 256;
                GameAI.playerSetAnimation(nArray, 16);
            } else if (n4 == 127) {
                nArray[23] = 256;
                int[] nArray4 = GameLogic.getNearestCornerFlag(nArray);
                GameAI.playerSetMoveTargetPosition(nArray, nArray4[0] - (nArray4[0] - nArray[0]) / 10, nArray4[1] - (nArray4[1] - nArray[1]) / 10);
            } else if (n4 == 80) {
                GameAI.playerSetStateGoalkeeperSmotherBall(nArray, n9, n7);
            } else if (n4 == 23) {
                GameAI.playerSetStateThrowIn(nArray, n9, n7);
            } else if (n4 == 12) {
                if (nArray[9] == 0) {
                    GameAI.playerSetAnimation(nArray, 56);
                }
                nArray[27] = 0;
            } else if (n4 == 161) {
                GameAI.playerSetStateRunningHeaderShoot(nArray, n9, n7);
            } else if (n4 == 182) {
                GameAI.playerSetStateRunReadyForThroughBall(nArray, n9, n7);
            } else if (n4 == 75) {
                GameAI.playerSetStateRedCard(nArray, n9, n7);
            } else if (n4 == 85 && GameLogic.isShootoutViewEnabled()) {
                GameAI.playerSetStateShootoutShot(nArray, n9, n7);
            } else if (n4 == 194) {
                GameAI.playerSetStateDefensiveHeader(nArray, n9, n7);
            }
        }
        if ((n10 & 0x20) != 0) {
            nArray[30] = GameRender.animationGetDuration(nArray[60]);
        }
        if ((n10 & 0x40) != 0) {
            nArray[30] = nArray[30] + GameRender.animationGetDuration(nArray[60]);
        }
    }

    public static final void playerSetStateRedCard(int[] nArray, int n2, int n3) {
        if (GameLogic.beAProIsPlayerBAPPlayer(nArray)) {
            XMLMenuSystem.bapBooked = true;
        }
    }

    public static final void playerSetStateGoalkeeperRecognisesBadShot(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateStumble(int[] nArray, int n2, int n3) {
        int n4 = (int)(1792.0 / (double)MainFrame.m_inGameFrameRate);
        nArray[6] = nArray[6] | 0x1040;
        nArray[21] = nArray[35];
        nArray[3] = DDMath.sin(nArray[35]) * n4 >> 16;
        nArray[4] = DDMath.cos(nArray[35]) * n4 >> 16;
    }

    public static final void playerSetStatePenalty(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateHeaderShoot(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateAfterHeader(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateMillAroundInBox(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateRushIntoShootZone(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateGrapplingDoesntHaveBall(int[] nArray, int n2, int n3) {
        GameLogic.m_controller[nArray[12]].m_forceBreakAway = false;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[6] = nArray[6] | 0x40;
        nArray[56] = GameAI.playerGetMarkPlayerWithBallMarkTimer(nArray);
    }

    public static final void playerSetStateControlBall(int[] nArray, int n2, int n3) {
        if (m_ballStorage[2] >= 384) {
            GameAI.playerSetAnimation(nArray, 1);
        } else {
            GameAI.playerSetAnimation(nArray, 2);
        }
        m_playerWithBall = nArray;
    }

    public static final void playerSetStateFormationRunToPos(int[] nArray, int n2, int n3) {
        nArray[21] = nArray[22] = nArray[35];
        GameAI.playerSelectMovementAnimation(nArray);
    }

    public static final void playerSetStateDivingHeader(int[] nArray, int n2, int n3) {
        nArray[22] = nArray[14];
        int n4 = GameRender.animationGetFramesUntilAction(nArray[60]);
        n4 = DDMath.max(n4, 1);
        int n5 = m_passTargetObject[0] - (DDMath.sin(nArray[22]) * 384 >> 16);
        int n6 = m_passTargetObject[1] - (DDMath.cos(nArray[22]) * 384 >> 16);
        nArray[3] = (n5 - nArray[0]) / n4;
        nArray[4] = (n6 - nArray[1]) / n4;
        nArray[6] = nArray[6] | 0x1000;
    }

    public static final void playerSetStateOverHeadKick(int[] nArray, int n2, int n3) {
        kickedball = false;
        nArray[22] = nArray[14];
        int n4 = GameRender.animationGetFramesUntilAction(nArray[60]);
        n4 = DDMath.max(n4, 1);
        int n5 = m_passTargetObject[0] - (DDMath.sin(nArray[22]) * 128 >> 16);
        int n6 = m_passTargetObject[1] - (DDMath.cos(nArray[22]) * 128 >> 16);
        nArray[3] = (n5 - nArray[0]) / n4;
        nArray[4] = (n6 - nArray[1]) / n4;
        nArray[6] = nArray[6] | 0x1000;
        nArray[21] = nArray[22] = nArray[14] + 128 & 0xFF;
    }

    public static final void playerSetStateVolley(int[] nArray, int n2, int n3) {
        nArray[22] = nArray[14];
        GameAI.playerSyncAnimationToBallPosition(nArray, 307, 51);
    }

    public static final void playerSetStateStandingHeaderShoot(int[] nArray, int n2, int n3) {
        GameAI.playerStopRunning(nArray);
        nArray[5] = 512 / MainFrame.m_inGameFrameRate;
    }

    public static final void playerSetStateGroundClearance(int[] nArray, int n2, int n3) {
        GameAI.playerStopRunning(nArray);
    }

    public static final void playerSetStateHeaderClearance(int[] nArray, int n2, int n3) {
        GameAI.playerStopRunning(nArray);
        nArray[5] = 512 / MainFrame.m_inGameFrameRate;
    }

    public static final void playerSetStateFirstTimeGroundPass(int[] nArray, int n2, int n3) {
        GameAI.playerStopRunning(nArray);
        nArray[22] = nArray[35];
    }

    public static final void playerSetStateGoalkeeperSmotherBall(int[] nArray, int n2, int n3) {
        GameAI.playerSyncAnimationToBallPosition(nArray, 512, 0);
    }

    public static final void playerSetStateMarkPlayerWithTheBall(int[] nArray, int n2, int n3) {
        nArray[54] = m_ballStorage[10] >> 1;
        nArray[57] = 1;
        nArray[56] = GameAI.playerGetMarkPlayerWithBallMarkTimer(nArray);
    }

    public static final void playerSetStateMarkLongPassFromGoalKickPlayer(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateGoalKeeperCatchBallAboveHead(int[] nArray, int n2, int n3) {
        GameAI.playerSyncAnimationToBallPosition(nArray, 0, 486);
    }

    public static final void playerSetStateFailedJumpForHeader(int[] nArray, int n2, int n3) {
        GameAI.playerStopRunning(nArray);
    }

    public static final void playerSetStateCrossBallIntoPenaltyArea(int[] nArray, int n2, int n3) {
        if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
            int n4 = nArray[47];
            int n5 = GameRender.animationGetDuration(nArray[60]) - GameRender.animationGetActionTime(nArray[60]);
            int n6 = 267;
            for (int i2 = 0; i2 < n5; ++i2) {
                n4 = n4 * n6 >> 8;
            }
            GameAI.ballSetAtPlayersFeet(nArray);
            GameAI.ballSetHorizontalSpeed(nArray[22], n4);
        }
    }

    public static final void playerSetStateControlBallWithChest(int[] nArray, int n2, int n3) {
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 256 / MainFrame.m_inGameFrameRate;
        chestactiondone = false;
    }

    public static final void playerSetStateGetBackOnSide(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateGoalKeeperNarrowTheAngle(int[] nArray, int n2, int n3) {
        nArray[55] = DDMath.getPositiveRandom() % 1280;
    }

    public static final void playerSetStateControlBallWithJumpingChest(int[] nArray, int n2, int n3) {
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 512 / MainFrame.m_inGameFrameRate;
        doneheaderaction = false;
    }

    public static final void playerSetStateFirstTimeHeaderPass(int[] nArray, int n2, int n3) {
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 512 / MainFrame.m_inGameFrameRate;
        nArray[21] = nArray[22] = nArray[35];
        GameAI.playerSyncAnimationToBallPosition(nArray, 0, 512);
        nArray[6] = nArray[6] | 1;
    }

    public static final void playerSetStateFirstTimeVolleyPass(int[] nArray, int n2, int n3) {
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 512 / MainFrame.m_inGameFrameRate;
        nArray[22] = nArray[35];
    }

    public static final void playerSetStateSlideTackle(int[] nArray, int n2, int n3) {
        int n4;
        int n5;
        int n6 = nArray[12];
        int[] nArray2 = GameAI.ballGetLastTouchPlayer();
        m_targetPlayer = nArray2;
        nArray[6] = nArray[6] & 0xFCFFFFFF;
        nArray[6] = nArray[6] & 0xFFFFFBFF;
        nArray[6] = nArray[6] | 0x1000;
        if (GameAI.teamGetControlType(n6) == 0) {
            GameLogic.m_controller[n6].m_aiTackleResult = GameAI.checkAITackle(nArray[44], n6);
        }
        GameRender.skidMarksAddSkidMark(nArray);
        if (GameAI.ObjectIsStationary(m_ballStorage) && nArray2 != null) {
            n5 = nArray2[3];
            n4 = nArray2[4];
        } else {
            n5 = m_ballStorage[3];
            n4 = m_ballStorage[4];
        }
        int n7 = m_ballStorage[0] + n5 * 14 - nArray[0];
        int n8 = m_ballStorage[1] + n4 * 14 - nArray[1];
        int n9 = DDMath.atan(n7, n8);
        if (GameAI.teamGetControlType(n6) == 2 && GameLogic.m_controller[n6].m_microGame.getResult() == 1 && DDMath.getPositiveRandom() % 100 < 60) {
            n9 += 16;
            GameLogic.m_refereeNextHumanSlideTackleIsOK = true;
        }
        nArray[3] = DDMath.sin(n9) * GameLogic.TACKLE_SLIDE_SPEED >> 16;
        nArray[4] = DDMath.cos(n9) * GameLogic.TACKLE_SLIDE_SPEED >> 16;
        nArray[22] = n9;
    }

    public static final void playerSetStateRunReadyForOneTwo(int[] nArray, int n2, int n3) {
        if ((DDMath.getRandom() & 0x3F) > 16) {
            nArray[6] = nArray[6] | 0x10;
        }
        int n4 = m_passTargetObject[0];
        int n5 = m_passTargetObject[1];
        int n6 = m_passType;
        int[] nArray2 = new int[]{n4, n5};
        int n7 = DDMath.calcHorizontalDist(nArray, nArray2);
        int n8 = n7 / GameAI.getPassSpeed(n7, 0) + MainFrame.m_inGameFrameRate / 2 + GameRender.animationGetDuration(17);
        GameAI.setPassTargetPosition(nArray2, nArray, n8, 16);
        nArray[15] = m_passTargetObject[0];
        nArray[16] = m_passTargetObject[1];
        m_passType = n6;
        GameAI.m_passTargetObject[0] = n4;
        GameAI.m_passTargetObject[1] = n5;
        nArray[23] = DDMath.max(nArray[23], 256);
        nArray[17] = 609;
        nArray[20] = n8;
    }

    public static final void playerSetStateAttackingSetPeiceLoopAround(int[] nArray, int n2, int n3) {
        nArray[57] = 0;
        nArray[54] = (nArray[1] & 0xFFFF) << 16 | nArray[0] & 0xFFFF;
        int n4 = 64;
        if (m_ballStorage[0] < 12311) {
            n4 = 192;
        }
        nArray[55] = n4;
        nArray[15] = nArray[0] + (DDMath.sin(n4) * 2048 >> 16);
        nArray[16] = nArray[1] + (DDMath.cos(n4) * 2048 >> 16);
        nArray[56] = MainFrame.m_inGameFrameRate + DDMath.getPositiveRandom() % (MainFrame.m_inGameFrameRate * 3);
    }

    public static final void playerSetStateAttackingSetPieceFigureOfEight(int[] nArray, int n2, int n3) {
        nArray[57] = 0;
        nArray[54] = (nArray[1] & 0xFFFF) << 16 | nArray[0] & 0xFFFF;
    }

    public static final void playerSetStateWaitAttackingRun(int[] nArray, int n2, int n3) {
        nArray[57] = DDMath.getPositiveRandom() % 100 > 50 ? 3 : 2;
    }

    public static final void playerSetStateDefendRunnersFromSetPiece(int[] nArray, int n2, int n3) {
        nArray[57] = DDMath.getPositiveRandom() % 100 > 50 ? 0 : 1;
    }

    public static final void playerSetStateGrapplingAndHasBall(int[] nArray, int n2, int n3) {
        GameAI.playerStopRunning(nArray);
        nArray[53] = 0;
    }

    public static final void playerSetStateInjury(int[] nArray, int n2, int n3) {
        m_playerInjured = nArray;
        m_menuPlayerInjured = nArray;
        nArray[6] = nArray[6] | 0x40000;
        int n4 = nArray[11];
        int n5 = 0 + n4;
        XMLMenuSystem.m_gmodePlayerStats[n5] = XMLMenuSystem.m_gmodePlayerStats[n5] & 0xFFFFFE3F;
        int n6 = 0 + n4;
        XMLMenuSystem.m_gmodePlayerStats[n6] = XMLMenuSystem.m_gmodePlayerStats[n6] | DDMath.getPositiveRandom() % 4 + 1 << 6;
        int n7 = (XMLMenuSystem.m_gmodePlayerStats[20 + n4] & 0xFF000000) >> 24;
        int n8 = 20 + n4;
        XMLMenuSystem.m_gmodePlayerStats[n8] = XMLMenuSystem.m_gmodePlayerStats[n8] & 0xFFFFFF;
        int n9 = 20 + n4;
        XMLMenuSystem.m_gmodePlayerStats[n9] = XMLMenuSystem.m_gmodePlayerStats[n9] | ++n7 << 24;
        GameLogic.matchEventAdd(nArray[12], nArray[11], GameLogic.m_matchTimer, 3);
    }

    public static final void playerSetStateIdle(int[] nArray, int n2, int n3) {
        GameAI.playerStopRunning(nArray);
        nArray[21] = nArray[22] = nArray[35];
        nArray[27] = 0;
    }

    public static final void playerSetStateGoalKeeperDiveAndSaveWithBall(int[] nArray, int n2, int n3) {
        GameAI.objectResetVelocity(m_ballStorage);
        GameAI.ballSetAtPlayersFeet(nArray);
        GameAI.ballSetCollision(false);
        GameAI.ballSetDrawnWithinFrame(nArray, true);
    }

    public static final void playerSetStateThroughBall(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateRunToPos(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateDribble(int[] nArray, int n2, int n3) {
        DDDebug.msg("SW: set state dribble " + nArray[9]);
        if (GameLogic.m_controller[nArray[12]].m_microGame.inProgress() && GameLogic.m_possession != nArray[12]) {
            GameLogic.m_controller[nArray[12]].m_microGame.cancelMicroGame();
        }
        if (GameLogic.m_matchState == 9) {
            DDDebug.msg("SW: dribbling when should be idle.");
        }
        nArray[6] = nArray[6] | 1;
        nArray[53] = 0;
        GameAI.ballSetCollision(true);
        m_playerWithBall = nArray;
        m_playerWithBallDribbleSpeed = nArray[23];
        if (GameAI.teamGetControlType(nArray[12]) == 2) {
            GameLogic.m_controller[nArray[12]].setControlPlayer(nArray);
        }
        if ((n2 == 32 || n2 == 140) && nArray[60] == 16) {
            nArray[59] = 5 * GameRender.animationGetTempo(16);
        }
    }

    public static final void playerSetStateRunOntoOverTheTopThroughBall(int[] nArray, int n2, int n3) {
        int n4;
        nArray[6] = nArray[6] | 0x1041;
        nArray[17] = 0;
        int n5 = Trajectory.getTimeToTarget(0);
        n5 = DDMath.max(n5, 10);
        nArray[22] = n4 = DDMath.atan(m_passTargetObject[0] - nArray[0], m_passTargetObject[1] - nArray[1]);
        nArray[18] = m_passTargetObject[0];
        nArray[19] = m_passTargetObject[1];
        int n6 = m_passTargetObject[0] - (DDMath.sin(n4) * 256 >> 16);
        int n7 = m_passTargetObject[1] - (DDMath.cos(n4) * 256 >> 16);
        nArray[3] = (n6 - nArray[0]) / n5;
        nArray[4] = (n7 - nArray[1]) / n5;
    }

    public static final void playerSetStatePassedTo(int[] nArray, int n2, int n3) {
        int n4;
        int n5;
        nArray[6] = nArray[6] | 1;
        GameAI.playerRunToMovePosition(nArray);
        GameAI.playerRunUsingPreciseTarget(nArray);
        nArray[17] = nArray[17] | 0x40;
        nArray[15] = nArray[18] = m_passTargetObject[0];
        nArray[16] = nArray[19] = m_passTargetObject[1];
        if (GameLogic.isObjectIn18YardBox(m_passTargetObject, GameAI.teamGetPitchSide(nArray[12] ^ 1)) && m_passTargetObject[2] > 0) {
            n5 = nArray[14];
            n5 = n5 + 128 & 0xFF;
            n4 = 640;
            if (m_passTargetObject[2] == 486) {
                n4 >>= 1;
            }
            nArray[15] = nArray[15] + (DDMath.sin(n5) * n4 >> 16);
            nArray[16] = nArray[16] + (DDMath.cos(n5) * n4 >> 16);
        }
        if (m_passType == 1 || m_passType == 4 || m_passType == 3) {
            if ((m_passType == 1 || m_passType == 3) && m_passTargetObject[2] > 0 && Trajectory.isBallUnderTrajectoryControl()) {
                nArray[17] = 0;
                nArray[6] = nArray[6] | 0x1000;
                n5 = Trajectory.getTimeToTarget(0);
                n5 = DDMath.max(n5, 6);
                nArray[3] = (nArray[15] - nArray[0]) / n5;
                nArray[4] = (nArray[16] - nArray[1]) / n5;
            } else {
                nArray[17] = nArray[17] | 0x220;
                nArray[20] = Trajectory.getTimeToTarget(0);
            }
        }
        if (GameLogic.m_gameMode != 2 && (m_passType == 3 || m_passType == 6)) {
            int[] nArray2 = GameLogic.nearestPlayerData(nArray, GameLogic.m_possession ^ 1, 0);
            if (GameAI.teamGetControlType(nArray2[12]) == 0) {
                n4 = GameLogic.m_difficultySettingDefensiveHeaderMinDistanceToAttacker + (100 - nArray[44] >> 4);
                GameLogic.m_controller[nArray2[12]].m_defensiveHeaderClearance = true;
            } else {
                n4 = GameLogic.m_difficultySettingDefensiveHeaderMinDistanceToAttackerHuman + (100 - nArray[44] >> 4);
            }
            GameAI.playerSetState(nArray2, nArray[0] - m_ballStorage[3] * n4, nArray[1] - m_ballStorage[4] * n4, 1);
            nArray2[29] = 34;
        }
        if (GameAI.playerMoveTargetReached(nArray, 16384)) {
            GameAI.playerWaitToReceivePass(nArray);
        }
    }

    public static final void playerSetStateWaitingToTakeSetPiece(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateRunToSetPiece(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateHumanControl(int[] nArray, int n2, int n3) {
        nArray[22] = nArray[21] = nArray[35];
    }

    public static final void playerSetStateTackled(int[] nArray, int n2, int n3) {
        int n4 = (int)(1024.0 / (double)MainFrame.m_inGameFrameRate);
        nArray[6] = nArray[6] | 0x1040;
        nArray[21] = nArray[35];
        nArray[3] = DDMath.sin(nArray[35] + 64) * n4 >> 16;
        nArray[4] = DDMath.cos(nArray[35] + 64) * n4 >> 16;
    }

    public static final void playerSetStateGoalKick(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateWaitShortPassFromGoal(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateWaitShortPassFromThrowIn(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateRunToShortPassFromThrowIn(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateCornerKick(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateInWall(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateDefendSetPiece(int[] nArray, int n2, int n3) {
        nArray[57] = 0;
    }

    public static final void playerSetStateThrowIn(int[] nArray, int n2, int n3) {
        GameAI.ballSetDrawnWithinFrame(nArray, true);
    }

    public static final void playerSetStateWaitToTakeKickOff(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateGoalkeeperRushDribbler(int[] nArray, int n2, int n3) {
        nArray[23] = DDMath.max(nArray[23], 256);
    }

    public static final void playerSetStateGoalkeeperFormation(int[] nArray, int n2, int n3) {
        GameAI.playerRunToFormationPosition(nArray);
    }

    public static final void playerSetStateGoalkeeperDiveAtPlayersFeet(int[] nArray, int n2, int n3) {
        int[] nArray2 = GameAI.ballGetLastTouchPlayer();
        nArray2[6] = nArray2[6] | 0x40;
        diveAtFeetDribbler = nArray2;
        GameAI.playerSyncAnimationToBallPosition(nArray, 384, 0);
    }

    public static final void playerSetStateWaitShot(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateGoalKeeperDropKick(int[] nArray, int n2, int n3) {
        int n4 = (int)(1536.0 / (double)MainFrame.m_inGameFrameRate);
        GameAI.ballSetDrawnWithinFrame(nArray, true);
        nArray[6] = nArray[6] | 0x1000;
        nArray[4] = DDMath.cos(nArray[14]) * n4 >> 16;
    }

    public static final void playerSetStateGoalKeeperThrowBallOut(int[] nArray, int n2, int n3) {
        GameAI.ballSetDrawnWithinFrame(nArray, true);
        int n4 = (int)(256.0 / (double)MainFrame.m_inGameFrameRate);
        nArray[6] = nArray[6] | 0x1000;
        nArray[4] = DDMath.cos(nArray[14]) * n4 >> 16;
    }

    public static final void playerSetStateRunToJostleForTheBall(int[] nArray, int n2, int n3) {
        int n4 = nArray[12] ^ 1;
        nArray[54] = -1;
        for (int i2 = 1; i2 < 11; ++i2) {
            if (m_playerStorage[n4][i2][28] != 10 && m_playerStorage[n4][i2][28] != 151) continue;
            nArray[54] = i2;
            break;
        }
        GameLogic.m_controller[nArray[12]].setControlPlayer(nArray);
    }

    public static final void playerSetState180(int[] nArray, int n2, int n3) {
        nArray[53] = 0;
        GameAI.ballSetCollision(false);
        nArray[56] = nArray[22];
    }

    public static final void playerSetStateChaseBall(int[] nArray, int n2, int n3) {
        if (GameAI.teamGetControlType(nArray[12]) == 0 && ((AIController)GameLogic.m_controller[nArray[12]]).playerCheckIfCanFirstTimePass(nArray)) {
            GameLogic.m_controller[nArray[12]].m_firstTimePass = true;
        }
        nArray[17] = (Trajectory.isBallUnderTrajectoryControl() ? 8 : 4) | 0x40;
        nArray[23] = 256;
    }

    public static final void playerSetStateHoldPosition(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateGoalKeeperStateTableStates(int[] nArray, int n2, int n3) {
        int n4 = nArray[28];
        int n5 = n4 * 4;
        int n6 = m_stateLookUpTable[n5 + 1];
        int n7 = (n4 - 39) * 5;
        if (n4 >= 112 && n4 <= 113) {
            n7 = (18 + n4 - 112) * 5;
        }
        if ((n6 & 0x80) == 0) {
            int n8 = GameAI.teamGetPitchSide(nArray[12]);
            if (GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4) {
                n8 = 1;
            }
            if (n4 == 46 || n4 == 56) {
                int n9;
                if (GameLogic.m_useGKDivePosition) {
                    n9 = DDMath.abs((GameLogic.m_setPieceGKTargetObject[0] - (12311 - GameLogic.m_goalWidth / 2)) / (GameLogic.m_goalWidth / 3));
                    n9 = DDMath.min(n9, 2);
                } else {
                    n9 = m_shotTargetObject[0] < nArray[0] ? 0 : (m_shotTargetObject[0] == nArray[0] ? 1 : (m_shotTargetObject[0] > nArray[0] ? 2 : -1));
                }
                GameAI.adjustKeeperDivingShootDir(nArray, n9);
            } else if (GameLogic.m_useGKDivePosition) {
                int n10 = DDMath.abs((GameLogic.m_setPieceGKTargetObject[0] - (12311 - GameLogic.m_goalWidth / 2)) / (GameLogic.m_goalWidth / 3));
                if ((n10 = DDMath.min(n10, 2)) == 0) {
                    nArray[22] = n8 == 0 ? 224 : 160;
                } else if (n10 == 1) {
                    nArray[22] = n8 == 0 ? 0 : 128;
                } else if (n10 == 2) {
                    nArray[22] = n8 == 0 ? 32 : 96;
                }
            } else if (m_shotTargetObject[0] < nArray[0]) {
                nArray[22] = n8 == 0 ? 224 : 160;
            } else if (m_shotTargetObject[0] == nArray[0]) {
                nArray[22] = n8 == 0 ? 0 : 128;
            } else if (m_shotTargetObject[0] > nArray[0]) {
                nArray[22] = n8 == 0 ? 32 : 96;
            }
            nArray[21] = nArray[22];
        }
        if ((m_goalkeeperDiveTable[n7 + 4] & 2) != 0) {
            nArray[21] = nArray[22] = nArray[35];
        }
        if (!Trajectory.isObjectUnderTrajectoryControl(nArray)) {
            if (n4 == 39 || n4 == 50 || n4 == 44 || n4 == 55) {
                if (n4 == 55) {
                    n4 = 55;
                }
                GameAI.CalcDive(nArray, 1, GameAI.keeperCalculateDiveDirection(nArray) | 0x400, nArray[60], false);
            } else if (n4 == 46 || n4 == 56) {
                GameAI.CalcDive(nArray, 1, GameAI.keeperCalculateDiveDirection(nArray), nArray[60], false);
            } else if (n4 != 47) {
                GameAI.CalcDive(nArray, 2, 0, nArray[60], false);
            }
        }
        if (n4 == 112) {
            GameAI.objectResetVelocity(m_ballStorage);
            GameAI.objectCopyValues(nArray, m_ballStorage, 0, 3);
        }
    }

    public static final void playerSetStateShootBall(int[] nArray, int n2, int n3) {
        boolean bl = false;
        if (DDMath.calcTurnAngle(nArray[22], DDMath.calcAngle(nArray, m_shotTargetObject)) > 0) {
            bl = true;
        }
        if (m_idealShotType == 1) {
            if (bl) {
                GameAI.playerSetAnimation(nArray, 85);
            } else {
                GameAI.playerSetAnimation(nArray, 74);
            }
        } else if (m_idealShotType == 0 && GameLogic.m_controller[nArray[12]].m_microGame.getMarkerZone() == 3) {
            if (bl) {
                GameAI.playerSetAnimation(nArray, 89);
            } else {
                GameAI.playerSetAnimation(nArray, 88);
            }
        } else if (m_idealShotType == 2) {
            if (bl) {
                GameAI.playerSetAnimation(nArray, 87);
            } else {
                GameAI.playerSetAnimation(nArray, 68);
            }
        } else if (bl) {
            GameAI.playerSetAnimation(nArray, 71);
        } else {
            GameAI.playerSetAnimation(nArray, 19);
        }
        nArray[3] = nArray[3] >> 1;
        nArray[4] = nArray[4] >> 1;
        int n4 = DDMath.sqrtRout(nArray[3] * nArray[3] + nArray[4] * nArray[4]);
        if ((nArray[6] & 0x20) != 0) {
            GameAI.m_ballStorage[3] = DDMath.sin(nArray[22]) * n4 >> 16;
            GameAI.m_ballStorage[4] = DDMath.cos(nArray[22]) * n4 >> 16;
        }
    }

    private static void playerSetStateShootoutShot(int[] nArray, int n2, int n3) {
        nArray[6] = nArray[6] | 0x40;
        nArray[30] = 21 * MainFrame.m_inGameFrameRate / 12;
    }

    private static boolean playerUpdateStateShootoutShot(int[] nArray, int n2) {
        nArray[30] = nArray[30] - 1;
        nArray[20] = nArray[20] + 1;
        if ((nArray[20] & 1) == 0) {
            ++GameRender.m_shootoutShooterFrame;
        }
        if ((GameRender.m_shootoutShooterFrame = DDMath.min(GameRender.m_shootoutShooterFrame, 25)) == 16 && GameLogic.m_setPieceShotType) {
            nArray[30] = nArray[30] - 0;
            int n3 = GameAI.shootCalculateShotType(nArray, n2, m_idealShotType);
            GameAI.shootKickBall(nArray, GameAI.shootAim(nArray, n2, n3 >> 2, n3 & 3));
            GameLogic.m_setPieceShotType = false;
            GameLogic.setState(2, -1, -1, -1);
            nArray[0] = nArray[15];
            nArray[1] = nArray[16];
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            if ((m_teamStorage[GameLogic.m_possession][0] & 2) == 2) {
                GameLogic.m_controller[n2].m_controlPlayer = null;
            }
        }
        return true;
    }

    public static final void playerSetStatePassBallLong(int[] nArray, int n2, int n3) {
        if (m_animationPassTarget != null) {
            if (DDMath.calcTurnAngle(nArray[22], DDMath.calcAngle(nArray, m_animationPassTarget)) < 0) {
                GameAI.playerSetAnimation(nArray, 18);
            } else {
                GameAI.playerSetAnimation(nArray, 81);
            }
        }
        nArray[3] = nArray[3] >> 1;
        nArray[4] = nArray[4] >> 1;
        int n4 = (int)(1024.0 / (double)MainFrame.m_inGameFrameRate);
        GameAI.m_ballStorage[3] = DDMath.sin(nArray[22]) * n4 >> 16;
        GameAI.m_ballStorage[4] = DDMath.cos(nArray[22]) * n4 >> 16;
    }

    public static final void playerSetStatePassBallShort(int[] nArray, int n2, int n3) {
        if (m_animationPassTarget != null) {
            if (DDMath.calcTurnAngle(nArray[22], DDMath.calcAngle(nArray, m_animationPassTarget)) < 0) {
                GameAI.playerSetAnimation(nArray, 17);
            } else {
                GameAI.playerSetAnimation(nArray, 17);
            }
        }
        nArray[3] = nArray[3] >> 1;
        nArray[4] = nArray[4] >> 1;
        int n4 = (int)(1024.0 / (double)MainFrame.m_inGameFrameRate);
        GameAI.m_ballStorage[3] = DDMath.sin(nArray[22]) * n4 >> 16;
        GameAI.m_ballStorage[4] = DDMath.cos(nArray[22]) * n4 >> 16;
    }

    public static final void playerSetStateInterceptPass(int[] nArray, int n2, int n3) {
        nArray[3] = nArray[3] >> 1;
        nArray[4] = nArray[4] >> 1;
    }

    public static final void playerSetStateSlideToInterceptBall(int[] nArray, int n2, int n3) {
        int n4;
        int n5 = GameRender.animationGetDuration(nArray[60]) - GameRender.animationGetActionTime(nArray[60]);
        nArray[22] = n4 = DDMath.atan(nArray[15] - nArray[0], nArray[16] - nArray[1]);
        nArray[15] = nArray[15] - (DDMath.sin(n4) * 384 >> 16);
        nArray[16] = nArray[16] - (DDMath.cos(n4) * 384 >> 16);
        nArray[3] = (nArray[15] - nArray[0]) / n5;
        nArray[4] = (nArray[16] - nArray[1]) / n5;
    }

    public static final void playerSetStateRunOntoInterception(int[] nArray, int n2, int n3) {
        int n4;
        nArray[6] = nArray[6] | 0x1000;
        int n5 = GameRender.animationGetDuration(nArray[60]) - GameRender.animationGetActionTime(nArray[60]);
        nArray[22] = n4 = DDMath.atan(nArray[15] - nArray[0], nArray[16] - nArray[1]);
        nArray[21] = n4;
        nArray[15] = nArray[15] - (DDMath.sin(n4) * 256 >> 16);
        nArray[16] = nArray[16] - (DDMath.cos(n4) * 256 >> 16);
        nArray[3] = (nArray[15] - nArray[0]) / n5;
        nArray[4] = (nArray[16] - nArray[1]) / n5;
    }

    public static final void playerSetStateGoalKeeperInterceptPass(int[] nArray, int n2, int n3) {
    }

    public static final void playerSetStateGoalKeeperPunchBallAway(int[] nArray, int n2, int n3) {
        int n4 = GameRender.animationGetDuration(nArray[60]) - GameRender.animationGetActionTime(nArray[60]);
        int n5 = DDMath.atan(nArray[15] - nArray[0], nArray[16] - nArray[1]);
        if (n5 == 0 && nArray[15] - nArray[0] == 0 && nArray[16] - nArray[1] == 0) {
            n5 = nArray[14];
        }
        nArray[22] = n5;
        nArray[15] = nArray[15] - (DDMath.sin(n5) * 256 >> 16);
        nArray[16] = nArray[16] - (DDMath.cos(n5) * 256 >> 16);
        nArray[3] = (nArray[15] - nArray[0]) / n4;
        nArray[4] = (nArray[16] - nArray[1]) / n4;
    }

    public static final void playerSetStateGoalKeeperCatchBallBody(int[] nArray, int n2, int n3) {
        int n4 = GameRender.animationGetFramesUntilAction(nArray[60]);
        int n5 = DDMath.atan(nArray[15] - nArray[0], nArray[16] - nArray[1]);
        nArray[6] = nArray[6] | 0x1000;
        nArray[22] = n5;
        nArray[3] = (nArray[15] - nArray[0]) / n4;
        nArray[4] = (nArray[16] - nArray[1]) / n4;
    }

    public static final void playerSetStateGoalKeeperCatchBallLow(int[] nArray, int n2, int n3) {
        int n4;
        int n5 = GameRender.animationGetDuration(nArray[60]) - GameRender.animationGetActionTime(nArray[60]);
        int n6 = n4 = DDMath.atan(m_ballStorage[0] - nArray[15], m_ballStorage[1] - nArray[16]);
        nArray[22] = n4;
        nArray[22] = GameAI.teamGetPitchSide(nArray[12]) == 1 ? (n6 > 160 ? 160 : (n6 > 96 ? 128 : 96)) : (DDMath.angleRangeCheck(n6, 128, 240) ? 224 : (DDMath.angleRangeCheck(n6, 240, 16) ? 0 : 32));
        nArray[15] = nArray[15] - (DDMath.sin(nArray[22]) * 384 >> 16);
        nArray[16] = nArray[16] - (DDMath.cos(nArray[22]) * 384 >> 16);
        nArray[6] = nArray[6] | 0x1000;
        nArray[17] = 0;
        nArray[21] = nArray[22];
        nArray[3] = (nArray[15] - nArray[0]) / n5;
        nArray[4] = (nArray[16] - nArray[1]) / n5;
    }

    public static final void playerSetStateGoalKeeperDropKickWait(int[] nArray, int n2, int n3) {
        nArray[2] = 0;
        if (GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod != 4 || GameLogic.m_gameMode == 2 && GameLogic.m_matchState == 2) {
            if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 5) {
                if (XMLMenuSystem.m_currSubTutorial == 0) {
                    XMLMenuSystem.m_tutorialState = 2;
                    XMLMenuSystem.m_tutorialTimer = 0;
                    GameRender.m_boxState = 5;
                } else {
                    XMLMenuSystem.tutorialReset();
                }
                return;
            }
            if ((GameLogic.m_refereeDecision == 0 || GameLogic.m_refereeDecision == 1 || GameLogic.m_refereeDecision == 2) && GameLogic.m_matchState == 2) {
                GameLogic.setState(1, 6, -1, -1);
            } else {
                GameLogic.m_refereeTimer = 1;
            }
            nArray[15] = 12311 + (nArray[0] > 12311 ? DDMath.getPositiveRandom() % 3097 : -(DDMath.getPositiveRandom() % 3097));
            nArray[16] = 2316 + DDMath.getRandom() % 1543;
            if (GameAI.teamGetPitchSide(nArray[12]) == 1) {
                nArray[16] = 32015 - nArray[16];
            }
        } else if (GameLogic.m_gameMode != 99) {
            GameAI.playerSetState(nArray, 0, 0, 26);
        }
    }

    public static final void playerSetStateGoalKeeperClearance(int[] nArray, int n2, int n3) {
        GameAI.playerSyncAnimationToBallPosition(nArray, 128, 0);
    }

    public static final void playerSetStateGoalKeeperCatchShotFromDistance(int[] nArray, int n2, int n3) {
        calculatedfinalposition = false;
        int n4 = GameAI.teamGetPitchSide(nArray[12]);
        int n5 = 12311;
        int n6 = 0;
        if (n4 == 1) {
            n6 = 32015 - n6;
        }
        int n7 = GameAI.ballCurrentDirection() + 128 & 0xFF;
        GameAI.playerSetMoveTargetPosition(nArray, n5 += DDMath.sin(n7) * 3089 >> 16, n6 += DDMath.cos(n7) * 3089 >> 16);
        nArray[17] = nArray[17] | 1;
        nArray[22] = nArray[14];
    }

    public static final void playerSetStateRunningHeaderShoot(int[] nArray, int n2, int n3) {
        nArray[22] = nArray[14];
        int n4 = GameRender.animationGetFramesUntilAction(nArray[60]);
        n4 = DDMath.max(n4, 1);
        int n5 = m_passTargetObject[0] - (DDMath.sin(nArray[22]) * 256 >> 16);
        int n6 = m_passTargetObject[1] - (DDMath.cos(nArray[22]) * 256 >> 16);
        nArray[3] = (n5 - nArray[0]) / n4;
        nArray[4] = (n6 - nArray[1]) / n4;
        nArray[5] = (m_passTargetObject[2] - 422) / n4;
        nArray[5] = nArray[5] + n4 * GameLogic.GRAVITY_PER_FRAME;
        GameLogic.ballCalculateFutureBallPosition(n4);
        nArray[6] = nArray[6] | 0x1000;
    }

    public static final void playerSetStateDefensiveHeader(int[] nArray, int n2, int n3) {
        nArray[30] = MainFrame.m_inGameFrameRate / 2;
        nArray[6] = nArray[6] | 0x1000;
        nArray[22] = nArray[21] = nArray[35];
        if (GameAI.ballIsInACross()) {
            int n4 = GameRender.animationGetFramesUntilAction(nArray[60]);
            n4 = DDMath.max(n4, 1);
            nArray[5] = (m_passTargetObject[2] - 422) / n4;
            nArray[5] = nArray[5] + n4 * GameLogic.GRAVITY_PER_FRAME;
            nArray[3] = 0;
        }
    }

    public static final void playerSetStateRunReadyForThroughBall(int[] nArray, int n2, int n3) {
        nArray[30] = MainFrame.m_inGameFrameRate / 2;
    }

    public static final void playerSetStateStandingTackle(int[] nArray, int n2, int n3) {
        if (!GameAI.ballIsPossessed()) {
            GameAI.playerSetState(nArray, 0, 0, 0);
            return;
        }
        int n4 = GameRender.animationGetFramesUntilAction(nArray[60]);
        n4 = DDMath.max(n4, 3);
        m_targetPlayer = GameAI.ballGetLastTouchPlayer();
        nArray[6] = nArray[6] & 0xFCFFFFFF;
        nArray[6] = nArray[6] | 0x1000;
        nArray[3] = (m_ballStorage[0] + m_ballStorage[3] * n4 - nArray[0]) / n4;
        nArray[4] = (m_ballStorage[1] + m_ballStorage[4] * n4 - nArray[1]) / n4;
    }

    public static final void playerSetStateShovePlayerForwards(int[] nArray, int n2, int n3) {
        int n4 = GameRender.animationGetFramesUntilAction(nArray[60]);
        int n5 = DDMath.atan(nArray[15] - nArray[0], nArray[16] - nArray[1]);
        nArray[6] = nArray[6] | 0x1000;
        nArray[21] = nArray[22] = n5;
        nArray[15] = nArray[15] - (DDMath.sin(n5) * 256 >> 16);
        nArray[16] = nArray[16] - (DDMath.cos(n5) * 256 >> 16);
        nArray[3] = (nArray[15] - nArray[0]) / n4;
        nArray[4] = (nArray[16] - nArray[1]) / n4;
        GameLogic.m_controller[nArray[12]].setControlPlayer(nArray);
    }

    public static final boolean playerUpdateState(int[] nArray, short[] sArray, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        int n3 = nArray[28];
        boolean bl3 = false;
        nArray[34] = nArray[34] - 1;
        boolean bl4 = false;
        if (n3 >= 39 && n3 <= 57 || n3 >= 112 && n3 <= 113) {
            bl4 = true;
        }
        if ((GameLogic.m_gameMode == 99 || GameLogic.m_matchPeriod == 4) && GameLogic.isShootoutViewEnabled() && GameLogic.m_penaltySavedInShootout) {
            bl4 = false;
        }
        if (bl4) {
            bl3 = GameAI.playerUpdateStateGoalKeeperStateTableStates(nArray, n2);
        }
        switch (nArray[28]) {
            case 114: {
                bl3 = GameAI.playerUpdateStateGoalKeeperBeatenHandsOnHead(nArray, n2);
            }
            case 172: {
                bl3 = GameAI.playerUpdateStateCrossBallIntoPenaltyArea(nArray, n2);
                break;
            }
            case 171: {
                bl3 = GameAI.playerUpdateStateGoalkeeperNarrowTheAngle(nArray, n2);
                break;
            }
            case 105: {
                bl3 = GameAI.playerUpdateStateGetBackOnSide(nArray, n2);
                break;
            }
            case 175: {
                bl3 = GameAI.playerUpdateStateSlideToInterceptBall(nArray, n2);
                break;
            }
            case 184: {
                bl3 = GameAI.playerUpdateStateRunToJostleForTheBall(nArray, n2);
                break;
            }
            case 176: {
                bl3 = GameAI.playerUpdateStateRunOntoInterception(nArray, n2);
                break;
            }
            case 188: {
                bl3 = GameAI.playerUpdateStateGoalKeeperCatchShotFromDistance(nArray, n2);
                break;
            }
            case 179: {
                bl3 = GameAI.playerUpdateStateGoalKeeperCatchBallBody(nArray, n2);
                break;
            }
            case 181: {
                bl3 = GameAI.playerUpdateStateGoalKeeperCatchBallLow(nArray, n2);
                break;
            }
            case 33: {
                bl3 = GameAI.playerUpdateStateInterceptPass(nArray, n2);
                break;
            }
            case 160: 
            case 180: {
                bl3 = GameAI.playerUpdateStateGoalKeeperClearance(nArray, n2);
                break;
            }
            case 166: {
                bl3 = GameAI.playerUpdateStateGroundClearance(nArray, n2);
                break;
            }
            case 66: {
                bl3 = GameAI.playerUpdateStateStandingHeaderShoot(nArray, n2);
                break;
            }
            case 167: {
                bl3 = GameAI.playerUpdateStateHeaderClearance(nArray, n2);
                break;
            }
            case 169: {
                bl3 = GameAI.playerUpdateStateControlBallWithJumpingChest(nArray, n2);
                break;
            }
            case 178: {
                bl3 = GameAI.playerUpdateStateKeeperPunchBallAway(nArray, n2);
                break;
            }
            case 170: {
                bl3 = GameAI.playerUpdateStateControlBallWithChest(nArray, n2);
                break;
            }
            case 168: {
                bl3 = GameAI.playerUpdateStateControlGroundBall(nArray, n2);
                break;
            }
            case 150: {
                bl3 = GameAI.playerUpdateStateRunJockeyForHighBall(nArray, n2);
                break;
            }
            case 165: {
                bl3 = GameAI.playerUpdateStateFirstTimeHeaderPass(nArray, n2);
                break;
            }
            case 164: {
                bl3 = GameAI.playerUpdateStateFirstTimeVolleyPass(nArray, n2);
                break;
            }
            case 163: {
                bl3 = GameAI.playerUpdateStateFirstTimeGroundPass(nArray, n2);
                break;
            }
            case 177: {
                bl3 = GameAI.playerUpdateStateKeeperInterceptPass(nArray, n2);
                break;
            }
            case 143: {
                bl3 = GameAI.playerUpdateStateDefendRunnersFromSetPiece(nArray, n2);
                break;
            }
            case 145: {
                bl3 = GameAI.playerUpdateStateWaitAttackingRun(nArray, n2);
                break;
            }
            case 146: {
                bl3 = GameAI.playerUpdateStateAttackingSetPeiceLoopAround(nArray, n2);
                break;
            }
            case 148: {
                bl3 = GameAI.playerUpdateStateAttackingSetPieceFigureOfEight(nArray, n2);
                break;
            }
            case 149: {
                if (GameAI.ballIsInAPass() && !GameAI.ballIsPossessed()) break;
                GameAI.playerSetState(nArray, 0, 0, 0);
                break;
            }
            case 144: {
                bl3 = GameAI.playerUpdateStateWaitShortPassFromSetPiece(nArray, n2);
                break;
            }
            case 116: {
                bl3 = GameAI.playerUpdateStateAttackingSetPiece(nArray, n2);
                break;
            }
            case 22: {
                bl3 = GameAI.playerUpdateStateDefendSetPiece(nArray, n2);
                break;
            }
            case 89: {
                bl3 = GameAI.playerUpdateStateOverlappingRun(nArray, n2);
                break;
            }
            case 36: {
                bl3 = GameAI.playerUpdateStateHoldPosition(nArray, n2);
                break;
            }
            case 189: {
                bl3 = GameAI.playerUpdateStateGoalKeeperCatchBallAboveHead(nArray, n2);
                break;
            }
            case 138: {
                bl3 = GameAI.playerUpdateStateGrapplingAndHasBall(nArray, n2);
                break;
            }
            case 85: {
                bl3 = GameAI.playerUpdateStateShootoutShot(nArray, n2);
                break;
            }
            case 139: {
                bl3 = GameAI.playerUpdateStateGrapplingDoesntHaveBall(nArray, n2);
                break;
            }
            case 93: {
                bl3 = GameAI.playerUpdateStateMarkPlayerWithTheBall(nArray, n2);
                break;
            }
            default: {
                break;
            }
            case 0: {
                if (GameAI.playerCheckPotentialHeadedClearance(nArray, n2)) {
                    return bl3;
                }
                bl3 = GameAI.playerUpdateStateIdle(nArray, n2);
                break;
            }
            case 121: {
                bl3 = GameAI.playerUpdateStateSubLeavePitch(nArray, n2);
                break;
            }
            case 122: {
                bl3 = GameAI.playerUpdateStateSubWaitToEnterPitch(nArray, n2);
                break;
            }
            case 123: {
                bl3 = GameAI.playerUpdateStateSubRunOntoPitch(nArray, n2);
                break;
            }
            case 99: {
                bl3 = GameAI.playerUpdateStateCelebrateRun(nArray, n2);
                break;
            }
            case 1: {
                if (GameAI.playerCheckPotentialHeadedClearance(nArray, n2)) {
                    return bl3;
                }
                bl3 = GameAI.playerUpdateStateRunToPos(nArray, n2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 20: 
            case 117: 
            case 147: 
            case 186: {
                bl3 = GameAI.playerUpdateStateRunToPos(nArray, n2);
                break;
            }
            case 73: {
                bl3 = GameAI.playerUpdateStateRunOffPitch(nArray, n2);
                break;
            }
            case 71: {
                bl3 = GameAI.playerUpdateStateFormationRunToPos(nArray, n2);
                break;
            }
            case 11: {
                bl3 = GameAI.playerUpdateStateRunToSetPiece(nArray, n2);
                break;
            }
            case 118: 
            case 120: {
                bl3 = GameAI.playerUpdateStateJostleOrMarkSetPiece(nArray, n2);
                break;
            }
            case 101: {
                bl3 = GameAI.playerUpdateStateCelebrateRunAndJump(nArray, n2);
                break;
            }
            case 129: {
                bl3 = GameAI.playerUpdateStateCelebrateRunAndSlide(nArray, n2);
                break;
            }
            case 82: {
                bl3 = true;
                nArray[17] = 1025;
                if (!GameAI.playerMoveTargetReached(nArray)) break;
                GameAI.playerSetState(nArray, 0, 0, 0);
                break;
            }
            case 100: {
                bl3 = true;
                if (nArray[59] != GameRender.animationGetNumFrames(44) - 1) break;
                GameAI.playerStopRunning(nArray);
                break;
            }
            case 128: {
                bl3 = true;
                if (nArray[59] != GameRender.animationGetNumFrames(nArray[60]) + 2) break;
                nArray[3] = nArray[3] * GameLogic.m_friction >> 9;
                nArray[4] = nArray[4] * GameLogic.m_friction >> 9;
                break;
            }
            case 127: {
                bl3 = true;
                nArray[17] = 1025;
                if (!GameAI.playerMoveTargetReached(nArray)) break;
                GameAI.playerSetState(nArray, 0, 0, 0);
                break;
            }
            case 27: {
                bl3 = GameAI.playerUpdateStateGoalkeeperRushDribbler(nArray, n2);
                break;
            }
            case 28: {
                bl3 = GameAI.playerUpdateStateGoalkeeperDiveAtPlayersFeet(nArray, n2);
                break;
            }
            case 29: {
                bl3 = GameAI.playerUpdateStateGoalkeeperHandKickWait(nArray, n2);
                break;
            }
            case 58: {
                bl3 = GameAI.playerUpdateStateGoalkeeperRecognisesBadShot(nArray, n2);
                break;
            }
            case 26: {
                bl3 = GameAI.playerUpdateStateGoalkeeperFormation(nArray, n2);
                break;
            }
            case 31: {
                bl3 = GameAI.playerUpdateStateWaitShot(nArray, n2);
                break;
            }
            case 124: {
                bl3 = GameAI.playerUpdateStateGoalKeeperReceiveCross(nArray, n2);
                break;
            }
            case 125: {
                bl3 = GameAI.playerUpdateStateGoalKeeperCatchCross(nArray, n2);
                break;
            }
            case 126: {
                bl3 = GameAI.playerUpdateStateGoalKeeperPunchCross(nArray, n2);
                break;
            }
            case 9: {
                bl3 = GameAI.playerUpdateStateDribble(nArray, n2);
                break;
            }
            case 10: {
                bl3 = GameAI.playerUpdateStatePassedTo(nArray, n2);
                break;
            }
            case 183: {
                bl3 = GameAI.playerUpdateStateRunOnToOverTheTopThroughBall(nArray, n2);
                break;
            }
            case 16: {
                bl3 = GameAI.playerUpdateStateWaitShortPassFromGoal(nArray, n2);
                break;
            }
            case 185: {
                bl3 = GameAI.playerUpdateStateWaitShortPassFromThrowIn(nArray, n2);
                break;
            }
            case 151: {
                bl3 = GameAI.playerUpdateStateWaitLongPassFromGoalKick(nArray, n2);
                break;
            }
            case 12: {
                bl3 = GameAI.playerUpdateStateWaitingToTakeSetPiece(nArray, n2);
                break;
            }
            case 23: {
                bl3 = GameAI.playerUpdateStateThrowIn(nArray, n2);
                break;
            }
            case 174: {
                bl3 = GameAI.playerUpdateStateGoalkeeperThrowBallOut(nArray, n2);
                break;
            }
            case 173: {
                bl3 = GameAI.playerUpdateStateGoalkeeperDropKick(nArray, n2);
                break;
            }
            case 15: {
                bl3 = GameAI.playerUpdateStateGoalKick(nArray, n2);
                break;
            }
            case 63: {
                bl3 = GameAI.playerUpdateStatePenalty(nArray, n2);
                break;
            }
            case 18: {
                bl3 = GameAI.playerUpdateStateCornerKick(nArray, n2);
                break;
            }
            case 21: {
                bl3 = GameAI.playerUpdateStateInWall(nArray, n2);
                break;
            }
            case 141: 
            case 142: {
                bl3 = GameAI.playerUpdateStatePassOrShoot(nArray, n2);
                break;
            }
            case 24: 
            case 25: {
                bl3 = GameAI.playerUpdateStateWaitToTakeKickOff(nArray, n2);
                break;
            }
            case 86: {
                bl3 = GameAI.playerUpdateStateCelebrateCupWon(nArray, n2);
                break;
            }
            case 13: {
                if (GameAI.playerCheckPotentialHeadedClearance(nArray, n2)) {
                    return bl3;
                }
                bl3 = GameAI.playerUpdateStateHumanControl(nArray, n2);
                break;
            }
            case 140: {
                bl3 = GameAI.playerUpdateStateStationary180(nArray, n2);
                break;
            }
            case 32: {
                bl3 = GameAI.playerUpdateState180(nArray, n2);
                break;
            }
            case 34: {
                if (!GameAI.ballIsInTheGoal()) {
                    if (GameAI.playerCheckPotentialHeadedClearance(nArray, n2)) {
                        return bl3;
                    }
                    bl3 = GameAI.playerUpdateStateChaseBall(nArray, n2);
                    break;
                }
                GameAI.playerSetState(nArray, 0, 0, 0);
                break;
            }
            case 190: 
            case 191: {
                bl3 = GameAI.playerUpdateStatePassBall(nArray, n2);
                break;
            }
            case 38: {
                bl3 = GameAI.playerUpdateStateShootBall(nArray, n2);
                break;
            }
            case 59: {
                bl3 = GameAI.playerUpdateStateStandingTackle(nArray, n2);
                break;
            }
            case 153: {
                bl3 = GameAI.playerUpdateStateShovePlayerForwards(nArray, n2);
                break;
            }
            case 91: {
                bl3 = GameAI.playerUpdateStateSlideTackle(nArray, n2);
            }
            case 90: {
                bl3 = GameAI.playerUpdateStateGetUpOffFloor(nArray, n2);
                break;
            }
            case 119: {
                bl3 = GameAI.playerUpdateStateRunReadyForOneTwo(nArray, n2);
                break;
            }
            case 94: {
                bl3 = GameAI.playerUpdateStateStruggleForBall(nArray, n2);
                break;
            }
            case 96: {
                bl3 = GameAI.playerUpdateStateOverHeadKick(nArray, n2);
                break;
            }
            case 77: {
                bl3 = GameAI.playerUpdateStateVolley(nArray, n2);
                break;
            }
            case 92: {
                bl3 = GameAI.playerUpdateStateDivingHeader(nArray, n2);
                break;
            }
            case 161: {
                bl3 = GameAI.playerUpdateStateRunningHeaderShoot(nArray, n2);
                break;
            }
            case 194: {
                bl3 = GameAI.playerUpdateStateHeadedClearance(nArray, n2);
                break;
            }
            case 67: {
                bl3 = GameAI.playerUpdateStateAfterHeader(nArray, n2);
                break;
            }
            case 78: {
                nArray[30] = nArray[30] - 1;
                if (nArray[30] > 0) break;
                GameAI.playerSetState(nArray, 0, 0, nArray[29]);
                break;
            }
            case 72: {
                bl3 = true;
            }
            case 14: {
                bl3 = GameAI.playerUpdateStateTackled(nArray, n2);
                break;
            }
            case 68: {
                bl3 = GameAI.playerUpdateStateMillAroundInBox(nArray, n2);
                break;
            }
            case 69: {
                bl3 = GameAI.playerUpdateStateRushIntoShootZone(nArray, n2);
                break;
            }
            case 70: {
                bl3 = GameAI.playerUpdateStateControlBall(nArray, n2);
                break;
            }
            case 76: {
                if (GameLogic.m_matchState == 12) break;
                GameAI.playerSetState(nArray, 0, 0, nArray[29]);
                break;
            }
            case 75: {
                nArray[17] = 1;
                if (!GameAI.playerMoveTargetReached(nArray)) break;
                if (nArray[15] == 0) {
                    nArray[15] = -5120;
                    break;
                }
                GameLogic.m_stateTimer = 0;
                GameAI.playerSetState(nArray, 0, 0, nArray[29]);
                break;
            }
            case 79: {
                if (GameLogic.m_matchPeriod == 6 && GameAI.ballIsInTheGoal()) {
                    GameAI.playerSetState(nArray, 0, 0, 0);
                    return false;
                }
                boolean bl5 = false;
                int n4 = m_ballStorage[0] - 12311;
                n4 = DDMath.abs(n4);
                GameLogic.nearestPlayerData(m_ballStorage, n2 ^ 1, 0);
                if (!GameLogic.isObjectIn18YardBox(m_ballStorage, GameAI.teamGetPitchSide(n2)) || n2 == GameLogic.m_possession && GameAI.ballGetLastTouchPlayerID() != 0) {
                    if ((nArray[6] & 0x20) != 0 && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
                        GameAI.objectResetVelocity(m_ballStorage);
                        GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
                        if (GameLogic.m_gameMode == 2) {
                            GameAI.Clearance(nArray, n2, 1);
                            break;
                        }
                        int[] nArray2 = GameLogic.nearestPlayerData(nArray, n2, 0);
                        GameAI.AnimatePass(nArray, nArray2, 1, -1);
                        break;
                    }
                } else if ((nArray[6] & 0x20) != 0) {
                    GameAI.objectResetVelocity(m_ballStorage);
                    GameAI.playerSetState(nArray, 0, 0, nArray[29]);
                    break;
                }
                if (GameLogic.isFreeBallSituation() && !GameFormation.isKeeperTheBestPlayerToPickUpTheFreeBall(nArray) || GameAI.ballIsPossessed() || GameLogic.m_matchState != 2) {
                    GameAI.playerSetState(nArray, 0, 0, 26);
                    break;
                }
                nArray[23] = 360;
                nArray[17] = 324;
                GameAI.playerSelectMovementAnimation(nArray);
                break;
            }
            case 102: 
            case 103: {
                GameFormation.keeperUpdateLevel1(n2, nArray);
                GameFormation.keeperUpdateLevel2(n2, nArray);
                if (GameLogic.m_matchState != 2) {
                    GameAI.playerSetState(nArray, 0, 0, 26);
                    bl3 = true;
                    break;
                }
                if ((nArray[6] & 0x20) != 0) {
                    if (!GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) break;
                    GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
                    GameAI.objectResetVelocity(m_ballStorage);
                    GameAI.playerStopRunning(nArray);
                    int n5 = m_ballStorage[2] < 243 ? 80 : 29;
                    GameAI.playerSetState(nArray, 0, 0, n5);
                    break;
                }
                if (GameAI.ballIsPossessed() || GameLogic.m_matchState != 2 || m_playerWithBall != null) {
                    GameAI.playerSetState(nArray, 0, 0, 26);
                    break;
                }
                if (GameAI.ballIsHeadingTowardsTheGoal(nArray)) {
                    int n6 = nArray[1] < 16007 ? 0 : 32015;
                    GameAI.playerSetMoveTargetPosition(nArray, DDMath.m_intersectionPointObject[0], n6 == 0 ? 128 : 31887);
                    int n7 = (n6 - m_ballStorage[1]) / m_ballStorage[4];
                    if (GameAI.playerMoveTargetReached(nArray, 16384) && nArray[5] == 0) {
                        int n8 = m_ballStorage[5];
                        for (int i2 = 0; i2 < n7; ++i2) {
                            n8 += m_ballStorage[5];
                        }
                        if (n8 > 486 && n8 < 936) {
                            nArray[5] = GameLogic.PLAYER_JUMP_VELOCITY;
                            GameAI.playerSetAnimation(nArray, 53);
                        }
                    }
                } else if (n3 == 103 || !DDMath.intersection(1)) {
                    GameAI.playerSetState(nArray, 0, 0, 26);
                }
                if (nArray[5] != 0) break;
                GameAI.playerSelectMovementAnimation(nArray);
                break;
            }
            case 80: {
                bl3 = GameAI.playerUpdateStateGoalkeeperSmotherBall(nArray, n2);
                break;
            }
            case 81: {
                bl3 = GameAI.playerUpdateStateInjury(nArray, n2);
                break;
            }
            case 60: 
            case 154: {
                bl3 = GameAI.playerUpdateStateStumble(nArray, n2);
                break;
            }
            case 182: {
                bl3 = GameAI.playerUpdateStateRunReadyForThroughBall(nArray, n2);
                break;
            }
            case 192: {
                bl3 = GameAI.playerUpdateStateFailedJumpForHeader(nArray, n2);
            }
        }
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean playerUpdateStateGoalKeeperStateTableStates(int[] nArray, int n2) {
        boolean bl;
        int n3;
        boolean bl2;
        block32: {
            block33: {
                bl2 = false;
                n3 = (nArray[28] - 39) * 5;
                int n4 = nArray[28];
                bl = GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray);
                if (n4 >= 112 && n4 <= 113) {
                    n3 = (18 + n4 - 112) * 5;
                }
                if (n4 == 46) {
                    n3 = 40;
                }
                bl2 = true;
                nArray[6] = nArray[6] | 1;
                if (Trajectory.isObjectUnderTrajectoryControl(nArray)) {
                    nArray[6] = nArray[6] | 1;
                    Trajectory.updateTrajectory(nArray, 1);
                    if (!Trajectory.isObjectUnderTrajectoryControl(nArray)) {
                        GameAI.playerStopRunning(nArray);
                        if (GameLogic.m_matchState == 2 && !GameAI.ballIsInAShot()) {
                            nArray[30] = GameRender.animationGetTempo(nArray[60]) * GameRender.animationGetNumFrames(nArray[60]);
                            nArray[30] = DDMath.max(nArray[30], 2);
                        }
                    }
                }
                nArray[30] = nArray[30] - 1;
                if (nArray[30] > 0 || nArray[2] > 0) break block33;
                if (GameLogic.m_gameMode == 4 && (m_goalkeeperDiveTable[n3 + 4] & 0x40) != 0) {
                    if (GameLogic.m_gameModeResetTimer <= 0) {
                        GameLogic.m_gameModeResetTimer = 20;
                    }
                    break block32;
                } else {
                    if ((m_goalkeeperDiveTable[n3 + 4] & 0x84) == 0) {
                        GameAI.playerSetState(nArray, 0, 0, m_goalkeeperDiveTable[n3 + 2]);
                        return true;
                    }
                    if ((m_goalkeeperDiveTable[n3 + 4] & 0x800) != 0) {
                        if (GameLogic.m_gameMode != 99 && GameLogic.m_matchPeriod != 4) {
                            GameAI.playerSetState(nArray, 0, 0, 90);
                        }
                        if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
                            nArray[29] = 29;
                            return true;
                        }
                        nArray[29] = 26;
                        return true;
                    }
                    if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
                        GameAI.playerSetState(nArray, 0, 0, 29);
                        break block32;
                    } else {
                        GameAI.playerSetState(nArray, 0, 0, 26);
                    }
                }
                break block32;
            }
            if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) && GameLogic.m_matchState == 2 && !GameAI.ballIsInTheGoal()) {
                boolean bl3;
                boolean bl4 = Trajectory.isObjectUnderTrajectoryControl(nArray) ? Trajectory.m_trajectoryParams[1][3] > 0 : (bl3 = nArray[3] > 0);
                if ((m_goalkeeperDiveTable[n3 + 4] & 0xD000) != 0) {
                    if (Trajectory.isBallUnderTrajectoryControl()) {
                        Trajectory.removeFromTrajectory(m_ballStorage, 0);
                    }
                    GameAI.ballSetToFreeBall();
                }
                int n5 = m_ballStorage[4];
                if (bl) {
                    if ((m_goalkeeperDiveTable[n3 + 4] & 0x1000) != 0) {
                        m_ballStorage[5] = m_ballStorage[5] + GameLogic.KEEPER_PARRY_VERTICAL_VELOCITY;
                        GameAI.m_ballStorage[5] = DDMath.min(m_ballStorage[5], GameLogic.MAX_PARRY_VERICAL_SPEED);
                    }
                    if ((m_goalkeeperDiveTable[n3 + 4] & 0x20000) != 0) {
                        m_ballStorage[5] = m_ballStorage[5] + GameLogic.KEEPER_PARRY_ULTRA_VERTICAL_VELOCITY;
                        GameAI.m_ballStorage[4] = m_ballStorage[4] * 235 >> 8;
                    }
                    if ((m_goalkeeperDiveTable[n3 + 4] & 0x4000) != 0) {
                        GameAI.m_ballStorage[3] = bl3 ? GameLogic.KEEPER_PARRY_HORIZONTAL_VELOCITY : -GameLogic.KEEPER_PARRY_HORIZONTAL_VELOCITY;
                        GameAI.m_ballStorage[4] = (DDMath.cos(nArray[22] + 128) >> 7) / MainFrame.m_inGameFrameRate;
                    }
                    if ((m_goalkeeperDiveTable[n3 + 4] & 0x8000) != 0) {
                        int n6 = GameAI.m_ballStorage[3] = bl3 ? GameLogic.KEEPER_PARRY_ULTRA_HORIZONTAL_VELOCITY_X : -GameLogic.KEEPER_PARRY_ULTRA_HORIZONTAL_VELOCITY_X;
                        if (DDMath.getPositiveRandom() % 3 == 0) {
                            GameAI.m_ballStorage[4] = -(DDMath.cos(nArray[22] + 128) * GameLogic.KEEPER_PARRY_ULTRA_HORIZONTAL_VELOCITY_Y >> 16 >> 1);
                            GameAI.m_ballStorage[3] = m_ballStorage[3] >> 1;
                        } else {
                            GameAI.m_ballStorage[4] = DDMath.cos(nArray[22] + 128) * GameLogic.KEEPER_PARRY_ULTRA_HORIZONTAL_VELOCITY_Y >> 16;
                        }
                    }
                    if ((m_goalkeeperDiveTable[n3 + 4] & 0x40000) != 0) {
                        int n7 = DDMath.max(DDMath.abs(n5 >> 2), GameLogic.KEEPER_PARRY_BACK_INTO_PLAY_SPEED);
                        GameAI.m_ballStorage[4] = DDMath.cos(nArray[22]) * n7 >> 16;
                    }
                }
                if ((m_goalkeeperDiveTable[n3 + 4] & 0x2000) != 0) {
                    if ((GameLogic.m_gameMode == 99 || GameLogic.m_matchPeriod == 4) && GameLogic.isShootoutViewEnabled()) {
                        GameLogic.m_penaltySavedInShootout = true;
                        GameAI.m_ballStorage[4] = (m_ballStorage[4] >> 2) * -1;
                        return false;
                    }
                    GameAI.ballSetLastTouchPlayer(nArray);
                }
                if (bl) {
                    if ((m_goalkeeperDiveTable[n3 + 4] & 0x9000) != 0) {
                        GameAI.ballSetToFreeBall();
                    }
                    if (m_goalkeeperDiveTable[n3 + 3] >= 0) {
                        GameLogic.m_controller[0].setControlPlayer(null);
                        GameLogic.m_controller[1].setControlPlayer(null);
                        GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
                        if (GameLogic.m_gameMode == 2) {
                            XMLMenuSystem.tutorialKeeperCatchesHasBall();
                        }
                        GameAI.playerSetState(nArray, 0, 0, m_goalkeeperDiveTable[n3 + 3]);
                        return true;
                    }
                }
            }
        }
        if ((m_goalkeeperDiveTable[n3 + 4] & 0x80000) != 0) {
            if (nArray[30] != GameRender.animationGetActionTime(nArray[60])) return bl2;
        }
        if ((m_goalkeeperDiveTable[n3 + 4] & 0x80) == 0) return bl2;
        if (!bl) return bl2;
        GameAI.objectResetVelocity(m_ballStorage);
        GameAI.objectCopyValues(nArray, m_ballStorage, 0, 2);
        GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
        if ((m_goalkeeperDiveTable[n3 + 4] & 0x100000) == 0) return bl2;
        GameAI.ballSetDrawnWithinFrame(nArray, true);
        return bl2;
    }

    public static final boolean playerUpdateStateGoalkeeperRecognisesBadShot(int[] nArray, int n2) {
        boolean bl = false;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, 26);
            return bl;
        }
        GameFormation.keeperUpdateLevel1(n2, nArray);
        if (DDMath.abs(nArray[1] - m_ballStorage[1]) < 2560) {
            GameAI.playerStopRunning(nArray);
            GameAI.playerSetAnimation(nArray, 55);
            nArray[30] = DDMath.min(nArray[30], MainFrame.m_inGameFrameRate / 2);
        } else if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerSetAnimation(nArray, 5);
        } else {
            nArray[17] = 66;
            nArray[23] = 180;
        }
        nArray[22] = nArray[35];
        return bl;
    }

    public static final boolean playerUpdateStateStandingTackle(int[] nArray, int n2) {
        boolean bl = true;
        int n3 = m_ballStorage[10];
        int[] nArray2 = GameAI.ballGetLastTouchPlayer();
        int n4 = -1;
        GameLogic.m_beAProPassPlayed = false;
        nArray[30] = nArray[30] - 1;
        if (GameAI.ballGetLastTouchPlayerID() != 0 && ((nArray[6] & 0x1000000) != 0 || (nArray[6] & 0x2000000) != 0)) {
            if (GameLogic.m_refereeTimer <= 0) {
                GameLogic.refereeSetDecision(0);
            }
            if ((nArray[6] & 0x1000000) == 0 || GameAI.teamGetControlType(n2) == 2 && GameLogic.m_controller[n2].m_microGameTackle) {
                GameLogic.refereeCheckTackle(nArray, n2, nArray2);
            } else {
                GameLogic.refereeSetDecision(1);
                if (GameLogic.checkIfTackleWon(nArray, nArray2)) {
                    short[] sArray = m_teamStorage[n2];
                    sArray[17] = (short)(sArray[17] + 1);
                }
                GameLogic.checkIfTackleLost(nArray2);
                GameLogic.beAProCheckIfBAPStatAchieved(5, nArray, nArray2);
                GameLogic.beAProCheckIfBAPStatAchieved(12, nArray2, nArray);
            }
            n4 = GameLogic.m_refereeDecision == 1 ? 14 : 72;
            GameAI.playerSetState(nArray2, 0, 0, n4);
            if ((nArray[6] & 0x20) == 0 && DDMath.calcHorizontalDistSquared(nArray, m_ballStorage) < 262144) {
                nArray[6] = nArray[6] | 0x20;
            } else {
                m_ballStorage[6] = m_ballStorage[6] & 0xFFFFFFDF;
            }
        }
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
                int n5 = m_ballStorage[10];
                int[] nArray3 = m_playerStorage[n5 & 1][n5 >> 1];
                if (nArray3 != nArray && (nArray3[28] == 9 || nArray3[28] == 138)) {
                    if (GameLogic.m_refereeTimer <= 0) {
                        GameLogic.refereeSetDecision(0);
                        GameLogic.refereeCheckTackle(nArray, n2, nArray2);
                    }
                    n4 = GameLogic.m_refereeDecision == 1 ? 60 : 14;
                    GameAI.playerSetState(nArray2, 0, 0, n4);
                }
                GameAI.ballSetDribbleDirection(nArray[22]);
                int[] nArray4 = GameAI.ballGetLastTouchPlayer();
                int n6 = GameAI.ballGetLastTouchPlayerTeam();
                if (GameLogic.m_possession != n6) {
                    GameLogic.beAProCheckIfBAPStatAchieved(12, nArray4, null);
                }
                GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
                GameAI.Clearance(nArray, n2, 4);
                if (GameAI.teamGetControlType(n2) == 2) {
                    GameLogic.m_controller[n2].setControlPlayer(nArray);
                }
                GameAI.playerSetState(nArray, 0, 0, 60);
                nArray[29] = 34;
                nArray[30] = 3;
                GameAI.playerStopRunning(nArray);
                GameAI.playerSetAnimation(nArray, 62);
                return bl;
            }
            nArray[29] = 34;
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateStumble(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) && nArray[29] != 34) {
            GameAI.playerStopRunning(nArray);
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateShovePlayerForwards(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray == GameLogic.m_controller[n2].m_controlPlayer) {
            GameAI.playerUpdatePassTargets(nArray);
        }
        GameLogic.m_controller[n2 ^ 1].m_passBall = true;
        int[] nArray2 = GameAI.playerGetMarkTarget(nArray);
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3 = 20;
            if (nArray2 != null) {
                n3 += nArray[40] - nArray2[40];
            }
            boolean bl2 = nArray[31] % 100 < n3;
            bl2 = false;
            if (nArray2 != null && GameAI.ballIsInAPass() && (!GameLogic.m_controller[n2 ^ 1].m_passBall && !GameLogic.m_controller[n2 ^ 1].m_clearBall || bl2) && DDMath.calcHorizontalDistSquared(nArray, nArray2) < 293764) {
                if (nArray2[28] == 10) {
                    nArray[29] = 10;
                }
                nArray2[35] = nArray2[35] + 32 & 0xFF;
                GameAI.playerSetState(nArray2, 0, 0, 60);
                nArray2[30] = Trajectory.getTimeToTarget(0) + GameRender.animationGetDuration(2);
                nArray[3] = 0;
                nArray[4] = 0;
            }
        }
        if (nArray[30] < GameRender.animationGetActionTime(nArray[60])) {
            if (GameLogic.m_controller[n2].m_passBall) {
                nArray[29] = 192;
                if (GameAI.playerCheckPotentialFirstTimePassingActions(nArray, n2)) {
                    return true;
                }
                if (nArray2 != null && nArray2[28] == 165) {
                    nArray[30] = 0;
                }
            } else if (GameLogic.m_controller[n2].m_clearBall && GameAI.playerCheckPotentialClearenceActions(nArray, n2)) {
                return true;
            }
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStatePenalty(int[] nArray, int n2) {
        boolean bl = true;
        nArray[17] = 65;
        int n3 = 0;
        int n4 = nArray[0] + nArray[3] * n3;
        int n5 = nArray[1] + nArray[4] * n3;
        int n6 = nArray[2] + nArray[5] * n3;
        if (GameLogic.isShootoutViewEnabled() && GameLogic.inShootoutView()) {
            nArray[20] = nArray[20] + 1;
            nArray[6] = nArray[6] | 0x40;
            if ((nArray[20] & 1) == 0) {
                ++GameRender.m_shootoutShooterFrame;
            }
            if (GameRender.m_shootoutShooterFrame == 5) {
                GameLogic.m_controller[n2].m_shootBall = false;
                GameLogic.m_setPieceShotType = true;
                GameAI.ballSetLastTouchPlayer(nArray);
                GameAI.playerSetState(nArray, 0, 0, 85);
            }
        } else if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n4, n5, n6)) {
            GameAI.ballSetLastTouchPlayer(nArray);
            GameAI.AnimateShot(nArray);
            GameLogic.m_controller[n2].m_shootBall = false;
            GameLogic.m_setPieceShotType = true;
            GameLogic.setState(2, -1, -1, -1);
        }
        return bl;
    }

    public static final boolean playerUpdateStateAfterHeader(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateMillAroundInBox(int[] nArray, int n2) {
        boolean bl = false;
        nArray[17] = 2;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            GameAI.playerSetAnimation(nArray, 0);
            nArray[21] = nArray[35];
        } else {
            GameAI.playerSetAnimation(nArray, 16);
        }
        if (GameLogic.m_matchState == 2 && (nArray[30] = nArray[30] - 1) <= 0) {
            GameAI.playerSetState(nArray, 0, 0, 0);
        }
        return bl;
    }

    public static final boolean playerUpdateStateRushIntoShootZone(int[] nArray, int n2) {
        boolean bl = false;
        nArray[17] = 8193;
        int n3 = GameLogic.isPlayerOffside(nArray, 1024) ? 47 : (GameLogic.isPlayerOffside(nArray, 2048) ? 180 : (GameLogic.isPlayerOffside(nArray, 4096) ? 256 : 360));
        nArray[23] = n3;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            nArray[30] = nArray[30] - 1;
        }
        GameAI.playerSelectMovementAnimation(nArray);
        if (GameLogic.m_matchState == 2) {
            if (GameLogic.m_possession != n2 || !GameLogic.isObjectInFinalThird(m_ballStorage, GameAI.teamGetPitchSide(n2))) {
                GameAI.playerSetState(nArray, 0, 0, 0);
            } else if (nArray[30] <= 0 && GameLogic.isPlayerOffside(nArray) && GameLogic.m_gameMode != 2) {
                int n4 = DDMath.cos(nArray[14]) * 640 >> 16;
                GameAI.playerSetState(nArray, nArray[25], GameLogic.m_offsideline[n2 ^ 1] - n4, 105);
            }
        } else {
            GameAI.playerSetState(nArray, 0, 0, 0);
        }
        return bl;
    }

    public static final boolean playerUpdateStateGrapplingDoesntHaveBall(int[] nArray, int n2) {
        boolean bl = true;
        boolean bl2 = GameAI.teamGetControlType(n2) == 2;
        int n3 = DDMath.calcHorizontalDistSquared(nArray, m_ballStorage);
        int n4 = Integer.MAX_VALUE;
        int n5 = 255;
        int[] nArray2 = GameAI.playerGetMarkTarget(nArray);
        if (nArray2 != null) {
            n4 = DDMath.calcHorizontalDistSquared(nArray, nArray2);
            n5 = DDMath.calcAngle(nArray2, m_ballStorage);
        }
        if (bl2) {
            GameLogic.m_controller[n2].setControlPlayer(nArray);
        }
        nArray[17] = nArray[17] | 0x121;
        nArray[6] = nArray[6] | 1;
        nArray[23] = nArray[23] + (nArray[42] >> 1) * (n3 > 188498 ? 1 : -1);
        nArray[23] = DDMath.max(nArray[23], 0);
        nArray[23] = DDMath.min(nArray[23], 440);
        nArray[23] = DDMath.min(nArray[23], 256);
        if (nArray2 != null && nArray2[28] == 138) {
            if (bl2 && GameLogic.m_controller[n2].m_forceBreakAway) {
                GameLogic.m_controller[n2].m_forceBreakAway = false;
                GameAI.playerSetState(nArray, 0, 0, 60);
                if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray2)) {
                    GameAI.playerSetState(nArray2, 0, 0, 9);
                } else {
                    GameAI.playerSetState(nArray2, 0, 0, 34);
                    nArray2[6] = nArray2[6] | 0x200;
                }
                return bl;
            }
            n5 = DDMath.calcTurnAngle(n5, nArray2[14]) > 0 ? n5 + 42 & 0xFF : n5 - 42 & 0xFF;
            nArray[15] = nArray2[0] + (DDMath.sin(n5) * 307 >> 16);
            nArray[16] = nArray2[1] + (DDMath.cos(n5) * 307 >> 16);
            nArray[22] = DDMath.calcAngle(nArray, m_ballStorage);
            GameAI.grappleUpdateGrapplingAnimationFlags(nArray, nArray2);
        } else {
            nArray[15] = nArray[15] + nArray[3];
            nArray[16] = nArray[16] + nArray[4];
            if (nArray[3] != 0 || nArray[4] != 0) {
                nArray[22] = DDMath.atan(nArray[3], nArray[4]);
            }
        }
        GameAI.playerSelectMovementAnimation(nArray);
        int n6 = GameLogic.m_difficultySettingGrappleSecondsBeforeAITackle_Default;
        switch (nArray[52]) {
            default: {
                n6 = GameLogic.m_difficultySettingGrappleSecondsBeforeAITackle_Default;
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 1: 
            case 5: {
                n6 = GameLogic.m_difficultySettingGrappleSecondsBeforeAITackle_LB_RB;
                break;
            }
            case 2: 
            case 4: {
                n6 = GameLogic.m_difficultySettingGrappleSecondsBeforeAITackle_LCB_RCB;
                break;
            }
            case 3: {
                n6 = GameLogic.m_difficultySettingGrappleSecondsBeforeAITackle_CB;
            }
        }
        if (GameLogic.m_matchState != 2 || GameAI.ballIsInTheGoal()) {
            GameAI.playerSetState(nArray, 0, 0, 0);
            return bl;
        }
        nArray[56] = nArray[56] - 1;
        if (nArray[56] <= 0) {
            if (bl2) {
                GameAI.playerSetState(nArray, 0, 0, 13);
            } else {
                GameAI.playerSetState(nArray, 0, 0, 93);
            }
            return bl;
        }
        if (GameAI.teamGetControlType(n2) == 0 && n3 < 262144 && nArray2 != null && nArray2[28] == 138 && (nArray2[53] = nArray2[53] + 1) > n6) {
            if (n4 < 262144) {
                boolean bl3 = false;
                boolean bl4 = false;
                switch (nArray[52]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 15: 
                    case 16: 
                    case 17: {
                        if (DDMath.getPositiveRandom() % 100 < 70) {
                            bl3 = true;
                            break;
                        }
                        bl4 = false;
                        break;
                    }
                    default: {
                        bl4 = true;
                    }
                }
                if (bl4) {
                    GameAI.playerSetState(nArray, 0, 0, 59);
                    nArray[29] = 34;
                    nArray[30] = 3;
                    if (GameLogic.m_possession != n2) {
                        GameLogic.beAProCheckIfBAPStatAchieved(12, nArray2, null);
                    }
                    GameAI.playerSetState(nArray2, 0, 0, 14);
                } else if (bl3) {
                    GameAI.playerSetState(nArray, 0, 0, 91);
                    GameAI.playerSetState(nArray2, 0, 0, 60);
                }
            } else if (n4 > 262144) {
                if (bl2) {
                    GameAI.playerSetState(nArray, 0, 0, 13);
                } else {
                    GameAI.playerSetState(nArray, 0, 0, 93);
                }
            }
            return bl;
        }
        return bl;
    }

    public static final boolean playerUpdateStateControlBall(int[] nArray, int n2) {
        boolean bl = true;
        nArray[22] = nArray[35];
        if ((nArray[6] & 0x20) != 0) {
            if (Trajectory.isBallUnderTrajectoryControl()) {
                Trajectory.removeFromTrajectory(m_ballStorage, 0);
            }
            GameAI.m_ballStorage[3] = nArray[3];
            GameAI.m_ballStorage[4] = nArray[4];
        }
        if ((nArray[30] = nArray[30] - 1) == 0) {
            int n3 = m_ballStorage[10];
            GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
            if ((n3 & 1) == n2 && n3 >> 1 == nArray[9] || nArray[60] == 1) {
                GameAI.playerSetState(nArray, 0, 0, 9);
                if (m_plrRunOntoBallDir != -1) {
                    GameLogic.m_controller[n2].m_180turn = false;
                    nArray[23] = 100;
                    nArray[22] = nArray[21] = m_plrRunOntoBallDir;
                    GameAI.ballSetDribbleDirection(m_plrRunOntoBallDir);
                }
            } else {
                GameAI.playerSetState(nArray, 0, 0, 0);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateFormationRunToPos(int[] nArray, int n2) {
        boolean bl = false;
        nArray[17] = 2;
        GameAI.playerSelectMovementAnimation(nArray);
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            if (GameLogic.m_matchState == 2) {
                nArray[57] = nArray[57] + 85 & 0xFF;
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateRunningHeaderShoot(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        nArray[21] = nArray[22] = nArray[14];
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3;
            int n4;
            int n5 = nArray[0] + (DDMath.sin(nArray[22]) * 256 >> 16);
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n5, n4 = nArray[1] + (DDMath.cos(nArray[22]) * 256 >> 16), n3 = 576) && !GameAI.checkIfDefensiveHeaderHasJustHappened(nArray)) {
                GameAI.ballSetLastTouchPlayer(nArray);
                m_idealShotType = 4;
                int n6 = GameAI.shootCalculateShotType(nArray, n2, 4);
                GameAI.shootKickBall(nArray, GameAI.shootAim(nArray, n2, n6 >> 2, n6 & 3));
                nArray[6] = nArray[6] | 0x40;
            }
        } else if (nArray[30] < GameRender.animationGetActionTime(nArray[60]) - 4) {
            nArray[3] = nArray[3] * 200 >> 8;
            nArray[4] = nArray[4] * 200 >> 8;
        }
        if (nArray[30] <= 0 && nArray[2] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateHeadedClearance(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (GameLogic.m_possession != n2) {
            if (DDMath.abs(m_ballStorage[3]) > DDMath.abs(m_ballStorage[4])) {
                if (nArray[1] < m_ballStorage[1]) {
                    int n3 = m_ballStorage[1] - nArray[1];
                    nArray[4] = DDMath.min(n3, 80);
                } else if (nArray[1] > m_ballStorage[1]) {
                    int n4 = m_ballStorage[1] - nArray[1];
                    nArray[4] = DDMath.max(n4, -80);
                }
            } else if (nArray[0] < m_ballStorage[0]) {
                int n5 = m_ballStorage[0] - nArray[0];
                nArray[3] = DDMath.min(n5, 80);
            } else if (nArray[0] > m_ballStorage[0]) {
                int n6 = m_ballStorage[0] - nArray[0];
                nArray[3] = DDMath.max(n6, -80);
            }
        }
        nArray[6] = nArray[6] | 0x1000;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n7;
            int n8 = nArray[0];
            int n9 = nArray[1];
            int n10 = 576;
            boolean bl2 = true;
            int[] nArray2 = GameAI.ballGetLastTouchPlayer();
            if (nArray[12] != nArray2[12] && (n7 = DDMath.calcHorizontalDistSquared(nArray, nArray2)) < 1000000) {
                bl2 = false;
            }
            if (bl2 && GameAI.ballIsCloseEnoughToDefensiveHeaderForAssumedCollision(nArray, n8, n9, n10)) {
                GameAI.ballSetLastTouchPlayer(nArray);
                nArray[67] = nArray[67] + 1;
                n7 = nArray[14] + DDMath.getRandom() % 32 & 0xFF;
                int n11 = (int)(2560.0 / (double)MainFrame.m_inGameFrameRate);
                int n12 = (int)(3072.0 / (double)MainFrame.m_inGameFrameRate);
                int n13 = n11 + DDMath.getPositiveRandom() % (n12 - n11);
                int n14 = DDMath.sin(n7) * n13 >> 15;
                int n15 = DDMath.cos(n7) * n13 >> 16;
                int n16 = n13 + DDMath.getRandom() % (n13 >> 3);
                Trajectory.removeFromTrajectory(m_ballStorage, 0);
                GameAI.m_ballStorage[3] = n14;
                GameAI.m_ballStorage[4] = n15;
                GameAI.m_ballStorage[5] = n16;
            }
        } else if (nArray[30] < GameRender.animationGetActionTime(nArray[60]) - 4) {
            nArray[3] = nArray[3] * 200 >> 8;
            nArray[4] = nArray[4] * 200 >> 8;
        }
        if (nArray[30] <= 0 && nArray[2] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateDivingHeader(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        nArray[22] = nArray[14];
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3;
            int n4;
            int n5 = nArray[0] + (DDMath.sin(nArray[22]) * 384 >> 16);
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n5, n4 = nArray[1] + (DDMath.cos(nArray[22]) * 384 >> 16), n3 = 256) && !GameAI.checkIfDefensiveHeaderHasJustHappened(nArray)) {
                GameAI.ballSetLastTouchPlayer(nArray);
                m_idealShotType = 4;
                int n6 = GameAI.shootCalculateShotType(nArray, n2, 4);
                GameAI.shootKickBall(nArray, GameAI.shootAim(nArray, n2, n6 >> 2, n6 & 3));
                nArray[6] = nArray[6] | 0x40;
            }
        } else if (nArray[30] < GameRender.animationGetActionTime(nArray[60]) - 4) {
            nArray[3] = nArray[3] * 200 >> 8;
            nArray[4] = nArray[4] * 200 >> 8;
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateOverHeadKick(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        nArray[22] = nArray[14] + 128 & 0xFF;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray) && !GameAI.checkIfDefensiveHeaderHasJustHappened(nArray)) {
            GameAI.ballSetLastTouchPlayer(nArray);
            kickedball = true;
            nArray[30] = MainFrame.m_inGameFrameRate;
            m_idealShotType = 4;
            int n3 = GameAI.shootCalculateShotType(nArray, n2, 4);
            GameAI.shootKickBall(nArray, GameAI.shootAim(nArray, n2, n3 >> 2, n3 & 3));
            nArray[6] = nArray[6] | 0x40;
        }
        if (kickedball) {
            nArray[3] = nArray[3] * 200 >> 8;
            nArray[4] = nArray[4] * 200 >> 8;
        }
        if (nArray[30] < 14) {
            GameAI.playerStopRunning(nArray);
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateVolley(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        nArray[22] = nArray[35];
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3 = nArray[0] + (DDMath.sin(nArray[22]) * 307 >> 16);
            int n4 = nArray[1] + (DDMath.cos(nArray[22]) * 307 >> 16);
            int n5 = nArray[2] - 243;
            GameAI.playerStopRunning(nArray);
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n3, n4, n5) && !GameAI.checkIfDefensiveHeaderHasJustHappened(nArray)) {
                GameAI.ballSetLastTouchPlayer(nArray);
                nArray[30] = MainFrame.m_inGameFrameRate;
                m_idealShotType = 5;
                int n6 = GameAI.shootCalculateShotType(nArray, n2, 5);
                GameAI.shootKickBall(nArray, GameAI.shootAim(nArray, n2, n6 >> 2, n6 & 3));
                nArray[6] = nArray[6] | 0x40;
            }
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateStandingHeaderShoot(int[] nArray, int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        nArray[22] = nArray[35];
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n5 = nArray[0], n4 = nArray[1], n3 = 576) && !GameAI.checkIfDefensiveHeaderHasJustHappened(nArray)) {
            GameAI.ballSetLastTouchPlayer(nArray);
            nArray[30] = MainFrame.m_inGameFrameRate;
            m_idealShotType = 4;
            int n6 = GameAI.shootCalculateShotType(nArray, n2, 4);
            GameAI.shootKickBall(nArray, GameAI.shootAim(nArray, n2, n6 >> 2, n6 & 3));
            nArray[6] = nArray[6] | 0x40;
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateGroundClearance(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
            GameAI.ballSetLastTouchPlayer(nArray);
            GameAI.Clearance(nArray, n2, 2);
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateHeaderClearance(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
            nArray[30] = MainFrame.m_inGameFrameRate;
            nArray[6] = nArray[6] | 0x40;
            GameAI.ballSetLastTouchPlayer(nArray);
            GameAI.Clearance(nArray, n2, 3);
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateFirstTimeGroundPass(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        nArray[22] = nArray[35];
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
            GameAI.ballSetLastTouchPlayer(nArray);
            int[] nArray2 = GameAI.getPassTarget(nArray);
            if (nArray2 != null) {
                DDDebug.msg("PASSING: call pass ball from first time ground pass");
                GameAI.passBall(m_ballStorage, nArray2, 1);
                GameAI.playerSetState(nArray2, 0, 0, 10);
                nArray[6] = nArray[6] | 0x40;
            } else {
                GameAI.kickBallForwards(nArray);
            }
            GameLogic.m_controller[n2].m_firstTimePass = false;
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateFirstTimeVolleyPass(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        nArray[22] = nArray[35];
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
            GameAI.ballSetLastTouchPlayer(nArray);
            int[] nArray2 = GameAI.getPassTarget(nArray);
            if (nArray2 != null) {
                DDDebug.msg("PASSING: call pass ball from first time volley pass");
                GameAI.passBall(m_ballStorage, nArray2, 4);
                GameAI.playerSetState(nArray2, 0, 0, 10);
                nArray[6] = nArray[6] | 0x40;
            } else {
                GameAI.kickBallForwards(nArray);
            }
            GameLogic.m_controller[n2].m_firstTimePass = false;
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static boolean playerUpdateStateRunJockeyForHighBall(int[] nArray, int n2) {
        boolean bl = false;
        GameAI.playerSelectMovementAnimation(nArray);
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
        } else {
            GameAI.playerRunToMovePosition(nArray);
        }
        return bl;
    }

    public static final boolean playerUpdateStateFirstTimeHeaderPass(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            nArray[3] = 0;
            nArray[4] = 0;
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
                GameAI.ballSetLastTouchPlayer(nArray);
                int[] nArray2 = GameAI.getPassTarget(nArray);
                if (nArray2 != null) {
                    GameLogic.m_controller[n2].m_headerPass = true;
                    DDDebug.msg("PASSING: call pass ball from first time header pass");
                    GameAI.passBall(m_ballStorage, nArray2, 1024);
                    GameAI.playerSetState(nArray2, 0, 0, 10);
                    nArray[6] = nArray[6] | 0x40;
                    GameLogic.m_controller[n2].m_headerPass = false;
                } else {
                    GameAI.kickBallForwards(nArray);
                }
                GameLogic.m_controller[n2].m_firstTimePass = false;
            }
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateControlBallWithJumpingChest(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (GameAI.teamGetControlType(n2) == 2) {
            GameLogic.m_controller[n2].setControlPlayer(nArray);
        }
        if (!doneheaderaction && nArray[30] == GameRender.animationGetActionTime(nArray[60]) && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray) && !GameAI.checkIfDefensiveHeaderHasJustHappened(nArray)) {
            doneheaderaction = true;
            nArray[30] = GameLogic.JUMPING_CHEST_CONTROL_FRAMES_TO_LAND_THE_JUMP;
            if (nArray[29] == 77) {
                nArray[30] = GameLogic.JUMPING_CHEST_CONTROL_FRAMES_TO_LAND_THE_JUMP - GameRender.animationGetFramesUntilAction(21);
            }
            if (GameLogic.m_controller[n2].m_shootBall || GameLogic.m_controller[n2].m_clearBall || GameLogic.m_controller[n2].m_passBall) {
                m_playerRunningOntoBall = nArray;
            }
            GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
            int n3 = GameLogic.JUMPING_CHEST_CONTROLLED_BALL_SPEED;
            if (nArray[29] == 160) {
                n3 >>= 1;
            }
            int n4 = nArray[22];
            if (nArray[29] == 77) {
                GameLogic.calculateNearFarGoalPostPositions(GameAI.teamGetPitchSide(n2 ^ 1));
                n4 = DDMath.calcAngle(nArray[0], nArray[1], GameLogic.m_nearGoalPostX, GameLogic.m_nearGoalPostY);
            }
            GameAI.m_ballStorage[3] = DDMath.sin(n4) * n3 >> 16;
            GameAI.m_ballStorage[4] = DDMath.cos(n4) * n3 >> 16;
            GameAI.m_ballStorage[5] = DDMath.cos(50) * n3 >> 16;
            nArray[6] = nArray[6] | 0x40;
        }
        if (nArray[30] <= 0) {
            if (!doneheaderaction) {
                nArray[29] = 0;
            }
            GameAI.ballSetToFreeBall();
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateGoalkeeperNarrowTheAngle(int[] nArray, int n2) {
        boolean bl = false;
        nArray[17] = 1;
        GameAI.calculateMovePositionThatNarrowsTheShotAngle(nArray, nArray[55]);
        GameAI.playerSelectMovementAnimation(nArray);
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
        }
        return bl;
    }

    public static final boolean playerUpdateStateGetBackOnSide(int[] nArray, int n2) {
        boolean bl = false;
        nArray[17] = 1;
        GameAI.playerSelectMovementAnimation(nArray);
        if (GameLogic.isPlayerOffside(nArray)) {
            int n3 = DDMath.cos(nArray[14]) * 640 >> 16;
            nArray[16] = GameLogic.m_offsideline[n2 ^ 1] - n3;
        }
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            nArray[30] = nArray[30] - 1;
            if (nArray[30] == 0) {
                GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateControlBallWithChest(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (GameAI.teamGetControlType(n2) == 2) {
            GameLogic.m_controller[n2].setControlPlayer(nArray);
        }
        if (!chestactiondone && nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            chestactiondone = true;
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
                nArray[30] = MainFrame.m_inGameFrameRate * 1 / 4;
                if (nArray[29] == 77) {
                    nArray[30] = nArray[30] - GameRender.animationGetFramesUntilAction(21);
                }
                if (GameLogic.m_controller[n2].m_shootBall || GameLogic.m_controller[n2].m_clearBall || GameLogic.m_controller[n2].m_passBall) {
                    m_playerRunningOntoBall = nArray;
                }
                GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
                int n3 = GameLogic.STANDING_CHEST_CONTROLLED_BALL_SPEED;
                if (nArray[29] == 160) {
                    n3 >>= 1;
                }
                GameAI.m_ballStorage[6] = 0;
                GameAI.m_ballStorage[3] = DDMath.sin(nArray[22]) * n3 >> 16;
                GameAI.m_ballStorage[4] = DDMath.cos(nArray[22]) * n3 >> 16;
                GameAI.m_ballStorage[5] = DDMath.cos(30) * n3 >> 16;
                nArray[6] = nArray[6] | 0x40;
            }
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static boolean playerUpdateStateControlGroundBall(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (GameAI.teamGetControlType(n2) == 2) {
            GameLogic.m_controller[n2].setControlPlayer(nArray);
        }
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
            if (GameLogic.m_controller[n2].m_shootBall || GameLogic.m_controller[n2].m_clearBall || GameLogic.m_controller[n2].m_passBall) {
                m_playerRunningOntoBall = nArray;
            }
            GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
            GameAI.objectResetVelocity(m_ballStorage);
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, 9);
        }
        return bl;
    }

    public static final boolean playerUpdateStateGoalKeeperBeatenHandsOnHead(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateCrossBallIntoPenaltyArea(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
            m_ballStorage[6] = m_ballStorage[6] & 0xFFFFDEDF;
            m_ballStorage[6] = m_ballStorage[6] | 4;
            int n3 = 12311;
            int n4 = GameAI.teamGetPitchSide(n2) == 0 ? 28926 : 3089;
            int n5 = DDMath.calcHorizontalDist(m_ballStorage, n3, n4);
            GameAI.ballSetLastTouchPlayer(nArray);
            int n6 = GameAI.getPassSpeed(n5, 0);
            int n7 = n5 / n6;
            Trajectory.setupTrajectory(m_ballStorage, 0, n7, m_ballStorage[0], m_ballStorage[1], m_ballStorage[2], n3, n4, 486, 0, 0);
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateGoalkeeperSmotherBall(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            if (nArray[29] == 29) {
                GameAI.playerSetState(nArray, 0, 0, 90);
                nArray[29] = 29;
                GameAI.ballSetDrawnWithinFrame(nArray, true);
                return true;
            }
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            return true;
        }
        if (GameLogic.m_matchState == 2) {
            nArray[3] = nArray[3] * 220 >> 8;
            nArray[4] = nArray[4] * 220 >> 8;
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
                GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
                GameAI.ballSetAtPlayersFeet(nArray);
                GameAI.objectResetVelocity(m_ballStorage);
                GameAI.playerStopRunning(nArray);
                GameAI.ballSetCollision(false);
                GameLogic.m_controller[0].setControlPlayer(null);
                GameLogic.m_controller[1].setControlPlayer(null);
                if (GameLogic.m_gameMode != 99 && GameLogic.m_gameMode != 4 && (GameLogic.m_gameMode != 1 || GameLogic.m_matchPeriod != 4)) {
                    nArray[29] = 29;
                }
            }
            if (GameAI.ballGetLastTouchPlayer() == nArray && nArray[30] <= GameRender.animationGetActionTime(nArray[60])) {
                GameAI.ballSetDrawnWithinFrame(nArray, true);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateMarkPlayerWithTheBall(int[] nArray, int n2) {
        boolean bl = true;
        boolean bl2 = false;
        if (nArray == GameAI.ballGetLastTouchPlayer()) {
            GameAI.playerSetState(nArray, 0, 0, 9);
            return true;
        }
        if (GameLogic.m_possession == nArray[12]) {
            GameAI.playerSetState(nArray, 0, 0, 0);
            GameLogic.m_controller[n2].setControlPlayer(null);
            return true;
        }
        if (GameLogic.m_matchState != 2) {
            GameAI.playerSetState(nArray, 0, 0, 0);
        }
        if (!GameAI.ballIsInAPass() && !GameAI.ballIsInAShot()) {
            int n3 = DDMath.calcHorizontalDistSquared(GameAI.ballGetLastTouchPlayer(), m_ballStorage);
            int n4 = DDMath.calcHorizontalDistSquared(nArray, m_ballStorage);
            if (n3 > 200000 && n4 < 40000) {
                GameAI.playerSetState(nArray, 0, 0, 9);
                return true;
            }
        }
        int[] nArray2 = GameAI.playerGetMarkTarget(nArray);
        if ((nArray[6] & 0x2000) != 0) {
            GameAI.playerSetState(nArray, 0, 0, 139);
            return bl;
        }
        if (GameAI.ballIsInAPass() || GameAI.ballIsInAShot() || GameAI.ballIsInACross() || !GameAI.ballIsPossessed()) {
            GameLogic.m_controller[n2].setControlPlayer(null);
            GameLogic.m_controller[n2].m_microGame.cancelMicroGame();
            GameAI.playerSetState(nArray, 0, 0, 0);
            if (GameAI.teamGetControlType(n2) == 2) {
                GameLogic.m_controller[n2].m_microGame.cancelMicroGame();
            }
        } else {
            if (nArray2 == null) {
                return bl;
            }
            switch (nArray[57]) {
                case 1: {
                    if (GameAI.teamGetControlType(n2) == 0 && (nArray[56] = nArray[56] - 1) <= 0) {
                        nArray[57] = 2;
                        break;
                    }
                    GameAI.markingSetMoveTargetPosition(nArray, nArray2);
                    if (GameAI.playerMoveTargetReached(nArray, 0)) {
                        GameAI.playerSetAnimation(nArray, 0);
                        nArray[23] = 0;
                    } else {
                        nArray[23] = !GameAI.ballIsInAPass() && !GameAI.ballIsInAShot() && !GameAI.ballIsInACross() && (GameAI.ballIsPossessed() || GameAI.ballGetLastTouchPlayerID() != 0) ? 360 : 256;
                    }
                    if (DDMath.calcHorizontalDistSquared(nArray, m_ballToGoalMarkerRunToPosJockeyX, m_ballToGoalMarkerRunToPosJockeyY) < 147456 && GameAI.markingIsTargetMovingTowardsPlayer(nArray, nArray2) && (GameAI.teamGetControlType(n2) == 2 || GameAI.teamGetControlType(n2) == 0 && GameLogic.m_controller[n2 ^ 1].m_controlPlayerMoveTimer >= 0)) {
                        nArray2[23] = 180;
                        nArray[23] = 180;
                        bl2 = true;
                        if (nArray[60] != 64) {
                            GameAI.playerSetAnimation(nArray, 64);
                        }
                    }
                    nArray[17] = nArray[17] | 1;
                    if (nArray[23] <= 0) break;
                    nArray[17] = nArray[17] | 0x20;
                    break;
                }
                case 2: {
                    if (GameAI.markingIsTargetShieldingTheBall(nArray, nArray2)) {
                        nArray[15] = m_MarkerRunSideGrapplePosX;
                        nArray[16] = m_MarkerRunSideGrapplePosY;
                        nArray[23] = 360;
                        nArray[17] = nArray[17] | 1;
                        break;
                    }
                    nArray[17] = 4;
                    if (nArray[36] << 8 <= 320 || nArray[36] << 8 <= 640 && DDMath.getPositiveRandom() % 24 == 0) {
                        GameAI.playerSetState(nArray, 0, 0, 59);
                        nArray[3] = (m_ballStorage[0] - nArray[0]) / (MainFrame.m_inGameFrameRate / 2);
                        nArray[4] = (m_ballStorage[1] - nArray[1]) / (MainFrame.m_inGameFrameRate / 2);
                        nArray[6] = nArray[6] | 0x1000;
                        break;
                    }
                    if (nArray[36] << 8 > 896 || DDMath.getPositiveRandom() % 96 != 0) break;
                    GameAI.playerSetState(nArray, 0, 0, 91);
                    GameAI.playerSetState(nArray2, 0, 0, 60);
                }
            }
        }
        if (!bl2) {
            GameAI.playerSelectMovementAnimation(nArray);
        }
        nArray[22] = nArray[15] != -1 && !bl2 && nArray[23] > 0 ? DDMath.calcAngle(nArray[0], nArray[1], nArray[15], nArray[16]) : nArray[35];
        return bl;
    }

    public static final boolean playerUpdateStateSlideTackle(int[] nArray, int n2) {
        boolean bl = false;
        if (GameLogic.m_matchState != 2) {
            GameAI.playerSetState(nArray, 0, 0, 0);
            return true;
        }
        if (GameAI.ballGetLastTouchPlayerID() != 0 && ((nArray[6] & 0x1000000) != 0 || (nArray[6] & 0x2000000) != 0) && GameLogic.m_refereeDecision == 0) {
            int n3;
            if ((nArray[6] & 0x2000000) != 0 || GameAI.teamGetControlType(n2) == 2 && GameLogic.m_controller[n2].m_microGameTackle) {
                GameLogic.refereeCheckTackle(nArray, n2, m_targetPlayer);
                n3 = 72;
            } else {
                n3 = 14;
            }
            int n4 = DDMath.getPositiveRandom() % 100;
            if (!(n4 <= 80 || GameLogic.m_refereeDecision != 3 && GameLogic.m_refereeDecision != 4 || XMLMenuSystem.m_menuMatchType == 4 || GameAI.teamGetControlType(GameLogic.m_fouledPlayer[12]) != 2 || m_targetPlayer[28] == 81 || m_teamStorage[GameLogic.m_fouledPlayersTeam][19] != 0 || XMLMenuSystem.m_subsRequestCount[GameLogic.m_fouledPlayersTeam] >= 3 || XMLMenuSystem.m_menuMatchType == 1 && XMLMenuSystem.m_menuSeasonType == 2 && m_targetPlayer[11] == XMLMenuSystem.m_beAProPlayerIndex)) {
                n3 = 81;
                short[] sArray = m_teamStorage[GameLogic.m_fouledPlayersTeam];
                sArray[19] = (short)(sArray[19] + 1);
                if (XMLMenuSystem.m_menuMatchType == 1 && XMLMenuSystem.m_menuSeasonType == 2) {
                    int n5 = m_targetPlayer[52];
                    int n6 = XMLMenuSystem.m_currentLineup[0][m_targetPlayer[11]];
                    int n7 = 0;
                    int n8 = m_targetPlayer[12];
                    int n9 = GameFormation.getPlayerType(n5);
                    boolean bl2 = false;
                    int n10 = 0;
                    while (!bl2) {
                        for (int i2 = 11; i2 < 18; ++i2) {
                            int[] nArray2 = m_playerStorage[n8][i2];
                            n5 = nArray2[48];
                            if (!XMLMenuSystem.isplayerSuitable(n9, n5, n10)) continue;
                            n7 = i2;
                            bl2 = true;
                            break;
                        }
                        ++n10;
                    }
                    if (n6 == n7) {
                        n6 = XMLMenuSystem.m_currentLineup[0][n6];
                    }
                    XMLMenuSystem.setupAutoSub(n6, n7, GameLogic.getPlayerTeam() == n8 ? 0 : 1);
                }
            }
            if (GameLogic.m_refereeDecision != 1) {
                GameAI.playerSetState(m_targetPlayer, 0, 0, n3);
                if ((nArray[6] & 0x20) == 0 && DDMath.calcHorizontalDistSquared(nArray, m_ballStorage) < 262144) {
                    nArray[6] = nArray[6] | 0x20;
                } else {
                    m_ballStorage[6] = m_ballStorage[6] & 0xFFFFFFDF;
                }
            }
        }
        if ((nArray[6] & 0x20) != 0 && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
            int[] nArray3 = GameAI.ballGetLastTouchPlayer();
            if (GameLogic.m_possession != n2) {
                GameLogic.beAProCheckIfBAPStatAchieved(12, nArray3, null);
            }
            GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
            GameAI.ballSetDribbleDirection(nArray[14]);
            GameAI.Clearance(nArray, n2, 0);
        }
        nArray[3] = nArray[3] * GameLogic.m_friction >> 8;
        nArray[4] = nArray[4] * GameLogic.m_friction >> 8;
        return bl;
    }

    public static boolean playerUpdateStateGetUpOffFloor(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[28] == 90 || nArray[30] < GameRender.animationGetActionTime(nArray[60])) {
            GameAI.playerStopRunning(nArray);
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateRunReadyForOneTwo(int[] nArray, int n2) {
        boolean bl = true;
        GameAI.playerSelectMovementAnimation(nArray);
        if (GameAI.playerMoveTargetReached(nArray)) {
            nArray[30] = nArray[30] - 1;
        }
        if (nArray[30] <= 0 || GameLogic.m_possession != nArray[12]) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static boolean playerUpdateStateStruggleForBall(int[] nArray, int n2) {
        boolean bl = false;
        if (GameLogic.m_possession == n2 || nArray[36] > 10) {
            GameAI.playerSetState(nArray, 0, 0, 0);
        } else {
            nArray[30] = nArray[30] - 1;
            if (nArray[30] != 0) {
                int n3;
                int n4;
                int[] nArray2 = m_playerStorage[m_ballStorage[10] & 1][m_ballStorage[10] >> 1];
                int n5 = nArray[35] - nArray2[22];
                int n6 = n4 = n5 > 0 ? 1 : -1;
                if (n5 < -128 || n5 > 128) {
                    n4 *= -1;
                }
                if (n4 == -1) {
                    int n7 = nArray2[0] + (DDMath.sin(nArray2[22] + 16) * 2 >> 8) - nArray[0];
                    int n8 = nArray2[1] + (DDMath.cos(nArray2[22] + 16) * 2 >> 8) - nArray[1];
                    n3 = DDMath.atan(n7 >> 8, n8 >> 8);
                } else {
                    int n9 = nArray2[0] + (DDMath.sin(nArray2[22] - 16) * 2 >> 8) - nArray[0];
                    int n10 = nArray2[1] + (DDMath.cos(nArray2[22] - 16) * 2 >> 8) - nArray[1];
                    n3 = DDMath.atan(n9, n10);
                }
                nArray[21] = n3;
                nArray[17] = 4352;
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateAttackingSetPeiceLoopAround(int[] nArray, int n2) {
        boolean bl = false;
        nArray[23] = 180;
        nArray[17] = 10241;
        if (nArray[57] == 1) {
            nArray[23] = 256;
        }
        if (GameAI.playerMoveTargetReached(nArray, 65536)) {
            if (nArray[56] > 0) {
                GameAI.playerSetAnimation(nArray, 0);
                GameAI.playerStopRunning(nArray);
                nArray[22] = nArray[35];
            }
            if (GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6) {
                nArray[56] = nArray[56] - 1;
                if (nArray[56] <= 0) {
                    if (nArray[57] == 0) {
                        nArray[56] = 0;
                        nArray[57] = 1;
                        nArray[55] = 0;
                    } else if (nArray[57] == 1) {
                        int n3;
                        int n4 = 21;
                        int n5 = 128 / n4;
                        if (m_ballStorage[0] < 12311) {
                            if (GameAI.teamGetPitchSide(n2) == 0) {
                                n4 = -n4;
                            }
                            n3 = 192;
                        } else {
                            if (GameAI.teamGetPitchSide(n2) == 1) {
                                n4 = -n4;
                            }
                            n3 = 64;
                        }
                        nArray[55] = nArray[55] + 1;
                        int n6 = n3 + nArray[55] * n4;
                        int n7 = nArray[54] & 0xFFFF;
                        int n8 = nArray[54] >> 16 & 0xFFFF;
                        if (nArray[55] <= n5) {
                            nArray[15] = n7 + (DDMath.sin(n6) * 2048 >> 16);
                            nArray[16] = n8 + (DDMath.cos(n6) * 2048 >> 18);
                            nArray[56] = 0;
                        } else {
                            nArray[57] = 2;
                            nArray[56] = MainFrame.m_inGameFrameRate + DDMath.getPositiveRandom() % (MainFrame.m_inGameFrameRate * 2);
                            nArray[15] = n7;
                            nArray[16] = n8;
                        }
                    } else if (nArray[57] == 2) {
                        GameAI.playerSetState(nArray, 0, 0, 116);
                        return bl;
                    }
                }
            } else {
                GameAI.playerSetState(nArray, 0, 0, 0);
                return bl;
            }
        }
        GameAI.playerSelectMovementAnimation(nArray);
        return bl;
    }

    public static final boolean playerUpdateStateAttackingSetPieceFigureOfEight(int[] nArray, int n2) {
        boolean bl = false;
        int[] nArray2 = new int[]{160, 224, 96, 32};
        nArray[23] = 180;
        nArray[17] = 10241;
        if (GameAI.playerMoveTargetReached(nArray)) {
            if (nArray[56] > 0) {
                GameAI.playerSetAnimation(nArray, 0);
                GameAI.playerStopRunning(nArray);
                nArray[22] = nArray[35];
            }
            if (GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6) {
                nArray[56] = nArray[56] - 1;
                if (nArray[56] <= 0) {
                    if (nArray[57] == 0) {
                        nArray[56] = 0;
                        nArray[57] = 1;
                        nArray[55] = 0;
                    } else if (nArray[57] == 1) {
                        nArray[55] = nArray[55] + 1;
                        int n3 = nArray[54] & 0xFFFF;
                        int n4 = nArray[54] >> 16 & 0xFFFF;
                        if (nArray[55] >= 4) {
                            nArray[57] = 2;
                            nArray[56] = MainFrame.m_inGameFrameRate + DDMath.getPositiveRandom() % (MainFrame.m_inGameFrameRate * 2);
                            nArray[15] = n3;
                            nArray[16] = n4;
                        } else {
                            int n5 = nArray2[nArray[55]];
                            nArray[15] = n3 + (DDMath.sin(n5) * 1280 >> 16);
                            nArray[16] = n4 + (DDMath.cos(n5) * 1280 >> 16);
                            nArray[56] = 0;
                        }
                    } else if (nArray[57] == 2) {
                        GameAI.playerSetState(nArray, 0, 0, 116);
                        return bl;
                    }
                }
            } else {
                GameAI.playerSetState(nArray, 0, 0, 0);
            }
        }
        GameAI.playerSelectMovementAnimation(nArray);
        return bl;
    }

    public static boolean playerUpdateStateWaitShortPassFromSetPiece(int[] nArray, int n2) {
        boolean bl = false;
        int n3 = 12311 - m_ballStorage[0];
        int n4 = 16007 - m_ballStorage[1];
        int n5 = DDMath.atan(n3, n4);
        nArray[15] = m_ballStorage[0] + (DDMath.sin(n5) * 3404 >> 16);
        nArray[16] = m_ballStorage[1] + (DDMath.cos(n5) * 3404 >> 16);
        nArray[17] = 1;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            if (GameLogic.m_matchState != 9 && GameLogic.m_matchState != 6) {
                GameAI.playerSetState(nArray, 0, 0, 0);
            }
        }
        GameAI.playerSelectMovementAnimation(nArray);
        return bl;
    }

    public static boolean playerUpdateStateAttackingSetPiece(int[] nArray, int n2) {
        boolean bl = false;
        nArray[17] = 1;
        GameAI.playerSelectMovementAnimation(nArray);
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            if (GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6) {
                nArray[30] = nArray[30] - 1;
                if (nArray[30] <= 0) {
                    switch (DDMath.getPositiveRandom() % 2) {
                        case 0: {
                            GameAI.playerSetState(nArray, 0, 0, 146);
                            break;
                        }
                        case 1: {
                            GameAI.playerSetState(nArray, 0, 0, 148);
                        }
                    }
                }
            } else if (GameLogic.m_setPieceMode == 0 || GameLogic.m_trajectoryType != 3) {
                GameAI.playerSetState(nArray, 0, 0, 149);
            } else {
                GameAI.playerSetState(nArray, 0, 0, 0);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateWaitAttackingRun(int[] nArray, int n2) {
        int n3;
        boolean bl = false;
        nArray[23] = 42;
        nArray[17] = 10241;
        if (nArray[57] == 3) {
            nArray[17] = nArray[17] | 0x20;
            nArray[22] = nArray[35];
        }
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            GameAI.playerSetAnimation(nArray, 0);
            if (GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6) {
                nArray[22] = nArray[35];
                nArray[23] = 0;
                if ((GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6) && (nArray[56] = nArray[56] - 1) <= 0) {
                    nArray[56] = MainFrame.m_inGameFrameRate / 2 + DDMath.getPositiveRandom() % (MainFrame.m_inGameFrameRate * 6);
                    if (nArray[57] == 2) {
                        nArray[57] = 3;
                        GameAI.playerSetAnimation(nArray, 64);
                    } else if (nArray[57] == 3) {
                        nArray[57] = 2;
                        GameAI.playerSetAnimation(nArray, 61);
                    }
                    int[] nArray2 = new int[]{0, 1, 2, 3};
                    GameAI.calculateMovePositionToSideOfPlayer(nArray, nArray2[nArray[57]], 2048);
                }
            } else {
                GameAI.playerSetState(nArray, 12311, GameAI.teamGetPitchSide(n2) == 0 ? 32015 - DDMath.getPositiveRandom() % 3089 : DDMath.getPositiveRandom() % 3089, 1);
                nArray[29] = 0;
            }
        } else if (GameLogic.isPlayerOffside(nArray) && nArray[57] != 2) {
            nArray[57] = 2;
            GameAI.playerSetAnimation(nArray, 61);
            nArray[15] = nArray[0];
            nArray[16] = GameAI.teamGetPitchSide(n2) == 1 ? nArray[1] + 2000 : nArray[1] - 2000;
            nArray[21] = nArray[22] = DDMath.atan(nArray[0] - nArray[15], nArray[1] - nArray[16]);
        } else if (GameLogic.m_matchState == 9 && nArray[57] == 2 && (n3 = DDMath.calcHorizontalDistSquared(nArray, GameLogic.m_setPieceTaker)) < 15000000) {
            int n4 = DDMath.getPositiveRandom() % 2;
            nArray[57] = 3;
            if (n4 == 0) {
                GameAI.playerSetAnimation(nArray, 61);
                nArray[16] = nArray[1];
                nArray[15] = nArray[0] > GameLogic.m_setPieceTaker[0] ? nArray[0] - 800 : nArray[0] + 800;
            } else {
                GameAI.playerSetAnimation(nArray, 64);
                nArray[15] = nArray[0];
                nArray[16] = GameAI.teamGetPitchSide(n2) == 1 ? nArray[1] - 800 : nArray[1] + 800;
            }
            nArray[21] = nArray[22] = DDMath.atan(nArray[0] - nArray[15], nArray[1] - nArray[16]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateDefendRunnersFromSetPiece(int[] nArray, int n2) {
        boolean bl = false;
        nArray[23] = 42;
        nArray[17] = 8193;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            GameAI.playerSetAnimation(nArray, 0);
            nArray[22] = nArray[35];
            if (GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6) {
                nArray[56] = nArray[56] - 1;
                if (nArray[56] <= 0) {
                    nArray[56] = MainFrame.m_inGameFrameRate / 2 + DDMath.getPositiveRandom() % (MainFrame.m_inGameFrameRate * 6);
                    if (nArray[57] == 0) {
                        nArray[57] = 1;
                        GameAI.playerSetAnimation(nArray, 30);
                    } else if (nArray[57] == 1) {
                        nArray[57] = 0;
                        GameAI.playerSetAnimation(nArray, 29);
                    }
                    int[] nArray2 = new int[]{0, 1, 2, 3};
                    GameAI.calculateMovePositionToSideOfPlayer(nArray, nArray2[nArray[57]], 768);
                }
            } else {
                GameAI.playerSetState(nArray, 12311, GameAI.teamGetPitchSide(n2) == 1 ? 32015 - DDMath.getPositiveRandom() % 3089 : DDMath.getPositiveRandom() % 3089, 1);
                nArray[29] = 0;
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateGrapplingAndHasBall(int[] nArray, int n2) {
        boolean bl = true;
        int[] nArray2 = GameAI.playerGetMarkTarget(nArray);
        if (nArray2 == null || nArray2[28] != 139) {
            GameAI.playerSetState(nArray, 0, 0, 9);
            return bl;
        }
        nArray[17] = nArray[17] | 0x104;
        nArray[23] = 220;
        nArray[53] = nArray[53] + 1;
        nArray[22] = nArray[35];
        m_playerWithBall = nArray;
        GameAI.playerUpdatePassTargets(nArray);
        nArray2[56] = GameLogic.MARKER_DELAY_DURING_GRAPPLE_BREAK_AWAY / 2;
        GameLogic.m_controller[n2].setControlPlayer(nArray);
        if (GameAI.teamGetControlType(n2) == 0) {
            ((AIController)GameLogic.m_controller[n2]).updateAIState(nArray);
        }
        if ((nArray[6] & 0x20) != 0) {
            if (GameAI.teamGetControlType(n2) == 0) {
                nArray[22] = GameAI.grappleCalculateAIDribbleDirection(nArray, nArray2);
                GameAI.ballSetDribbleDirection(nArray[22]);
                ((AIController)GameLogic.m_controller[n2]).updateAIState(nArray);
            }
            GameAI.playerTriggerBallAction(nArray, n2, m_ballStorage[11]);
            if (nArray[28] != 138) {
                GameAI.playerSetState(nArray2, 0, 0, 60);
                return bl;
            }
        }
        if (GameAI.grappleCheckIfDribblerShouldBreakAwayFromTarget(nArray, nArray2)) {
            GameAI.playerSetState(nArray2, 0, 0, 60);
            GameAI.playerSetState(nArray, 0, 0, 9);
            return bl;
        }
        if (GameAI.ballGetLastTouchPlayer() != nArray) {
            if (GameAI.ballGetLastTouchPlayer()[28] == 139 || GameAI.ballGetLastTouchPlayer() == nArray2) {
                GameAI.ballSetLastTouchPlayer(nArray);
            } else {
                GameAI.playerSetState(nArray, 0, 0, 0);
                if (GameAI.teamGetControlType(n2) == 2) {
                    GameLogic.m_controller[n2].setControlPlayer(null);
                }
            }
            return bl;
        }
        GameAI.grappleUpdateGrapplingAnimationFlags(nArray, nArray2);
        GameAI.playerSelectMovementAnimation(nArray);
        return bl;
    }

    public static final boolean playerUpdateStateInjury(int[] nArray, int n2) {
        return true;
    }

    public static final boolean playerUpdateStateIdle(int[] nArray, int n2) {
        if (nArray[9] == 0) {
            GameAI.playerSetState(nArray, 0, 0, 26);
            return true;
        }
        if (nArray != GameLogic.m_fouledPlayer && nArray != GameLogic.m_foulingPlayer) {
            nArray[22] = nArray[35];
        }
        if ((nArray[6] & 0x2000) != 0) {
            GameAI.playerSetState(nArray, 0, 0, 139);
            return false;
        }
        if (GameLogic.m_matchState == 17 || GameLogic.m_matchState == 14 || GameLogic.m_matchState == 3 || GameLogic.m_matchState == 9 || GameLogic.m_matchState == 1 && (GameLogic.m_matchSubState == 5 || GameLogic.m_matchSubState == 31 || GameLogic.m_matchSubState == 32) && GameLogic.m_foulingPlayer != null) {
            nArray[27] = 0;
        }
        nArray[27] = nArray[27] + 1;
        if (nArray[27] > nArray[46] && GameLogic.m_gameMode != 5) {
            GameAI.playerSetState(nArray, nArray[25], nArray[26], 71);
        }
        return false;
    }

    public static boolean playerUpdateStateSubLeavePitch(int[] nArray, int n2) {
        nArray[17] = 1;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerSetAnimation(nArray, 0);
            nArray[3] = 0;
            nArray[4] = 0;
        }
        return false;
    }

    public static boolean playerUpdateStateSubWaitToEnterPitch(int[] nArray, int n2) {
        if (m_playerSubOff[0] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, 123);
            GameLogic.requestSound(2);
        }
        if (GameLogic.m_controller[n2].m_buttonThrough) {
            GameFormation.jumpPlayersToTheirPositions();
            GameLogic.m_controller[n2].m_buttonThrough = false;
        }
        return false;
    }

    public static boolean playerUpdateStateSubRunOntoPitch(int[] nArray, int n2) {
        nArray[17] = 1;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            nArray[25] = nArray[0];
            nArray[26] = nArray[1];
        }
        return false;
    }

    public static boolean playerUpdateStateCelebrateRun(int[] nArray, int n2) {
        boolean bl = true;
        nArray[17] = 1;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerSetAnimation(nArray, 0);
            nArray[3] = 0;
            nArray[4] = 0;
        }
        if (m_goalScorer[28] == 100 && GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerSetAnimation(nArray, 0);
            nArray[3] = 0;
            nArray[4] = 0;
        }
        return bl;
    }

    public static final boolean playerUpdateStateRunToPos(int[] nArray, int n2) {
        nArray[17] = 1;
        if (nArray[28] == 117) {
            nArray[6] = nArray[6] | 0x40;
            nArray[17] = nArray[17] | 0x840;
        }
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return false;
    }

    public static boolean playerUpdateStateRunOffPitch(int[] nArray, int n2) {
        nArray[17] = 1;
        if (GameAI.playerMoveTargetReached(nArray)) {
            if (nArray[15] == 0) {
                nArray[15] = -5120;
            } else {
                nArray[0] = 0;
                nArray[1] = -32015;
                GameAI.playerSetState(nArray, 0, 0, 84);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean playerUpdateStateDribble(int[] nArray, int n2) {
        int n3;
        boolean bl = true;
        if ((nArray[6] & 0x40) != 0 && m_playerStorage[n2 ^ 1][0][28] == 28) {
            nArray[6] = nArray[6] & 0xFFFFFFBF;
        }
        int n4 = GameAI.teamGetControlType(n2);
        boolean bl2 = GameAI.isOppositionPlayerCloseAhead(nArray);
        if (GameLogic.m_matchState == 9) {
            DDDebug.msg("SW: dribbling when should be idle.");
        }
        m_playerWithBall = nArray;
        nArray[53] = nArray[53] + 1;
        int n5 = 256;
        GameAI.playerSelectMovementAnimation(nArray);
        GameAI.playerUpdatePassTargets(nArray);
        if ((m_ballStorage[6] & 0x80) == 0 && nArray[23] == 0) {
            nArray[6] = nArray[6] | 0x21;
            nArray[53] = 0;
        } else {
            nArray[6] = nArray[6] & 0xFFFFFFFE;
        }
        int n6 = 45;
        int n7 = 256;
        if (n4 == 2) {
            GameLogic.m_controller[n2].setControlPlayer(nArray);
            if ((nArray[17] & 0x200) != 0) {
                n5 |= 0x200;
            }
            n3 = nArray[42] * 2 * n7 >> 8;
            int n8 = n6 / 2;
            if (nArray[60] != 67 && !GameAI.playerIsSprinting(nArray) && bl2 && (GameLogic.m_controller[n2].m_controlPlayerMoveTimer >= 0 || TouchscreenController.m_touchTargetMoveSpeed > 0)) {
                m_playerWithBallDribbleSpeed -= n6 / 2;
                m_playerWithBallDribbleSpeed = DDMath.max(m_playerWithBallDribbleSpeed, 47);
            } else {
                m_playerWithBallDribbleSpeed = TouchscreenController.m_touchTargetMoveSpeed > m_playerWithBallDribbleSpeed ? (m_playerWithBallDribbleSpeed += DDMath.min(TouchscreenController.m_touchTargetMoveSpeed - m_playerWithBallDribbleSpeed, n3)) : (TouchscreenController.m_touchTargetMoveSpeed > 0 ? (m_playerWithBallDribbleSpeed -= DDMath.min(m_playerWithBallDribbleSpeed - TouchscreenController.m_touchTargetMoveSpeed, n8)) : (nArray[60] != 67 && GameLogic.m_controller[n2].m_controlPlayerMoveTimer >= 0 || GameLogic.m_controller[n2].m_hcpSprint ? (m_playerWithBallDribbleSpeed += n3) : (m_playerWithBallDribbleSpeed -= n8)));
            }
            int n9 = (nArray[17] & 0x200) != 0 ? 375 : (nArray[53] < MainFrame.m_inGameFrameRate * 3 ? 256 : 300);
            m_playerWithBallDribbleSpeed = DDMath.restrictRange(m_playerWithBallDribbleSpeed, 0, n9);
        } else {
            GameLogic.m_controller[n2].setControlPlayer(nArray);
            ((AIController)GameLogic.m_controller[n2]).updateAIState(nArray);
            if (GameLogic.m_controller[n2].m_hcpSprint) {
                n5 |= 0x200;
                nArray[17] = nArray[17] | 0x200;
            }
            if (nArray[60] != 67 && bl2) {
                m_playerWithBallDribbleSpeed -= n6;
                m_playerWithBallDribbleSpeed = DDMath.max(m_playerWithBallDribbleSpeed, 47);
            } else {
                m_playerWithBallDribbleSpeed += nArray[42] * n7 >> 8;
            }
            n3 = 0;
            n3 = (nArray[17] & 0x200) != 0 ? 375 : 225;
            m_playerWithBallDribbleSpeed = DDMath.restrictRange(m_playerWithBallDribbleSpeed, 0, n3);
        }
        if ((nArray[6] & 0x20) != 0) {
            bl = true;
            if (nArray == GameLogic.m_controller[n2].m_controlPlayer) {
                if (GameLogic.m_controller[n2].m_hcpSprint) {
                    n5 |= 0x200;
                } else if (nArray[23] > 180) {
                    GameLogic.m_controller[n2].m_hcpSprint = false;
                    n5 &= 0xFFFFFDFF;
                }
            }
            if (GameLogic.m_controller[n2].m_quickStop) {
                GameLogic.m_controller[n2].m_controlPlayerMoveTimer = -1;
                m_playerWithBallDribbleSpeed = 0;
                nArray[23] = 0;
                GameAI.playerSetAnimation(nArray, 67);
                GameLogic.m_controller[n2].m_quickStop = false;
            }
            nArray[23] = m_playerWithBallDribbleSpeed;
            int n10 = DDMath.calcTurnAngle(m_ballStorage[11], nArray[21]);
            if (n10 != 0) {
                if (DDMath.abs(n10) > 42 && nArray[23] > 47) {
                    nArray[23] = nArray[23] >> 1;
                }
                nArray[34] = 0;
            }
            if (!GameLogic.m_controller[n2].m_180turn && (nArray[6] & 0x4000) == 0) {
                nArray[22] = nArray[21] = m_ballStorage[11];
            }
            GameAI.playerTriggerBallAction(nArray, n2, m_ballStorage[11]);
        } else {
            n5 |= 0x44;
            nArray[23] = nArray[23] + (nArray[42] * n7 >> 8);
            nArray[23] = DDMath.min(nArray[23], 360);
            if ((m_ballStorage[2] > 486 || (nArray[6] & 0x40) != 0) && GameAI.playerMoveTargetReached(nArray)) {
                GameAI.playerStopRunning(nArray);
            }
        }
        nArray[17] = n5;
        if (GameLogic.m_matchState != 2) {
            if (GameLogic.m_gameMode == 2 && (XMLMenuSystem.m_currTutorial == 1 || XMLMenuSystem.m_currTutorial == 4)) {
                if (XMLMenuSystem.m_currTutorial == 1) {
                    GameAI.teamSetPossession(m_playerStorage[1][9], m_teamStorage[1], 1);
                    GameAI.playerSetState(m_playerStorage[1][9], 0, 0, 9);
                }
                GameLogic.m_matchState = 2;
                return bl;
            }
            GameAI.playerSetState(nArray, 0, 0, 71);
            return true;
        }
        if (nArray != GameAI.ballGetLastTouchPlayer()) {
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
                GameAI.playerSetState(nArray, 0, 0, 14);
            } else {
                GameAI.playerSetState(nArray, 0, 0, 71);
            }
            if (n4 != 2) return bl;
            GameLogic.m_controller[n2].m_forcePlayerSelect = true;
            if (nArray == GameLogic.m_controller[n2].m_controlPlayer) {
                GameLogic.m_controller[n2].setControlPlayer(null);
            }
            if (!GameLogic.m_controller[n2].m_microGame.inProgress()) return bl;
            GameLogic.m_controller[n2].m_microGame.cancelMicroGame();
            return bl;
        }
        if ((nArray[6] & 0x2000) != 0) {
            GameAI.playerSetState(nArray, 0, 0, 138);
            return bl;
        }
        if (GameAI.checkForTeamMembersThatAreTooClose(nArray)) {
            return bl;
        }
        if (n4 != 0) return bl;
        if (!GameAI.checkForOppositionPlayersThatAreTooClose(nArray)) return bl;
        if (DDMath.getPositiveRandom() % (GameLogic.m_difficultySettingAIOneInNPassBallAwayWhenBeingForcedOutOfPitch + 1) != 0) return bl;
        int[] nArray2 = GameLogic.nearestPlayerData(nArray, nArray[12], 0);
        GameAI.AnimatePass(nArray, nArray2, 1, -1);
        return bl;
    }

    public static final boolean checkForTeamMembersThatAreTooClose(int[] nArray) {
        for (int i2 = 1; i2 < 11; ++i2) {
            int[] nArray2 = m_playerStorage[nArray[12]][i2];
            if (nArray == nArray2 || nArray2[49] == 2 || nArray2[36] >= 4 || nArray[53] <= 30 || GameLogic.isPlayerOffside(nArray2) || DDMath.CalcModDifference(nArray[22], DDMath.calcAngle(nArray, nArray2)) >= 21) continue;
            GameAI.AnimatePass(nArray, nArray2, 1, -1);
            return true;
        }
        return false;
    }

    public static final boolean checkForOppositionPlayersThatAreTooClose(int[] nArray) {
        for (int i2 = 1; i2 < 11; ++i2) {
            int[] nArray2 = m_playerStorage[nArray[12] ^ 1][i2];
            if (nArray == nArray2 || nArray2[49] == 2 || nArray2[36] >= 3 || nArray[53] <= 15) continue;
            return true;
        }
        return false;
    }

    private static final boolean checkIfChasedBallIsCloseToEdgeOfPitch(int[] nArray) {
        int n2;
        if (nArray[4] > 0 ? m_ballStorage[1] > 32015 - (n2 = nArray[4] > 130 ? 500 : 400) : nArray[4] < 0 && m_ballStorage[1] < (n2 = nArray[4] < -130 ? 500 : 400)) {
            return true;
        }
        return nArray[3] > 0 ? m_ballStorage[0] > 24622 - (n2 = nArray[3] > 130 ? 500 : 400) : nArray[3] < 0 && m_ballStorage[0] < (n2 = nArray[3] < -130 ? 500 : 400);
    }

    private static final boolean checkIfDefensiveHeaderHasJustHappened(int[] nArray) {
        int n2;
        int[] nArray2 = GameAI.ballGetLastTouchPlayer();
        if (nArray[12] == nArray2[12]) {
            return false;
        }
        return nArray2[28] == 194 && (n2 = DDMath.calcHorizontalDistSquared(nArray, nArray2)) < 1500000;
    }

    public static final boolean playerUpdateStateRunOnToOverTheTopThroughBall(int[] nArray, int n2) {
        boolean bl = true;
        if (!GameAI.ballIsInAPass()) {
            if (GameLogic.isFreeBallSituation()) {
                GameAI.playerSetState(nArray, 0, 0, 34);
                return bl;
            }
            GameAI.playerSetState(nArray, 0, 0, 0);
            return bl;
        }
        nArray[22] = DDMath.atan(nArray[3], nArray[4]);
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(77, nArray[18], nArray[19], 217)) {
            GameAI.playerSetState(nArray, nArray[18], nArray[19], 176);
            return bl;
        }
        return bl;
    }

    public static final boolean playerUpdateStatePassedTo(int[] nArray, int n2) {
        boolean bl = m_ballStorage[3] == 0 && m_ballStorage[4] == 0 && m_ballStorage[5] == 0;
        boolean bl2 = false;
        if (nArray[9] == 0) {
            bl2 = true;
        }
        nArray[6] = nArray[6] | 1;
        if (nArray[48] != 0) {
            GameAI.playerSelectMovementAnimation(nArray);
        }
        if (GameAI.ballIsInAPass()) {
            GameLogic.m_controller[n2].setControlPlayer(nArray);
            if (GameAI.teamGetControlType(n2) == 0) {
                ((AIController)GameLogic.m_controller[n2]).updateAIState(nArray);
            }
            if (Trajectory.getEndZ(0) > 384) {
                GameAI.playerUpdatePassTargetsHeader(nArray);
            } else {
                GameAI.playerUpdatePassTargets(nArray);
            }
            if (bl || nArray[9] != 0 && m_passTargetObject[2] < 128 && GameAI.playerMoveTargetReached(nArray) && DDMath.calcHorizontalDistSquared(nArray, m_ballStorage) > 128 && m_ballStorage[2] < 384 && DDMath.abs(m_ballStorage[5]) < GameLogic.GRAVITY_PER_FRAME * MainFrame.m_inGameFrameRate / 2) {
                if (GameLogic.m_quickPlayMomentTriggeredTimer > 0 && GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 25) {
                    GameLogic.setState(2, -1, -1, -1);
                }
                GameAI.playerSetState(nArray, 0, 0, 34);
            } else if (GameAI.playerMoveTargetReached(nArray) && GameLogic.objectsAreAtTheSamePosition(nArray, m_passTargetObject)) {
                GameAI.playerWaitToReceivePass(nArray);
                GameAI.playerStopRunning(nArray);
                if (nArray[9] == 0) {
                    GameLogic.m_controller[n2].resetAllActions();
                } else if (GameLogic.m_controller[n2].m_shootBall) {
                    if (GameAI.playerCheckPotentialStandingShootActions(nArray, n2)) {
                        return bl2;
                    }
                } else if (!GameLogic.m_controller[n2].m_passBall && m_plrRunOntoBallDir != -1 && nArray[36] < 8 && m_ballStorage[2] < 243) {
                    GameAI.playerSetState(nArray, 0, 0, 34);
                    nArray[23] = 180;
                    m_plrRunOntoBallDir = -1;
                    return bl2;
                }
            } else {
                nArray[20] = Trajectory.getTimeToTarget(0);
                nArray[17] = 2145;
                if (GameAI.playerMoveTargetReached(nArray) && GameAI.playerMoveTargetReached(nArray)) {
                    GameAI.playerStopRunning(nArray);
                    GameAI.playerWaitToReceivePass(nArray);
                }
                if (GameLogic.m_controller[n2].m_shootBall && GameAI.playerCheckPotentialRunningShootActions(nArray, n2)) {
                    return bl2;
                }
            }
        } else {
            if (nArray[48] == 0) {
                GameAI.playerSetState(nArray, 0, 0, 26);
                return bl2;
            }
            if (GameLogic.m_possession != n2) {
                GameAI.playerSetState(nArray, 0, 0, 0);
                return bl2;
            }
            if (m_playerWithBall != null) {
                if (nArray != GameLogic.m_quickPlayMomentSetPieceTargetObject || GameLogic.m_quickPlayMomentTriggeredTimer <= 0) {
                    GameAI.playerSetState(nArray, 0, 0, 0);
                    return bl2;
                }
            } else {
                GameAI.playerSetState(nArray, 0, 0, 0);
                GameAI.sendPlayersToBall();
                return bl2;
            }
        }
        if (nArray[48] == 0) {
            if (GameAI.projectedBallCollisionWithSpecifiedAnimation(18, 1, nArray[0], nArray[1], 0)) {
                GameAI.playerSetState(nArray, 0, 0, 160);
                return true;
            }
            if (GameAI.projectedBallCollisionWithSpecifiedAnimation(1, 1, nArray[0], nArray[1], 320)) {
                GameAI.playerSetState(nArray, 0, 0, 170);
                nArray[29] = 160;
                return true;
            }
            if (GameAI.projectedBallCollisionWithSpecifiedAnimation(82, 1, nArray[0], nArray[1], 486)) {
                GameAI.playerSetState(nArray, 0, 0, 169);
                nArray[29] = 160;
                return true;
            }
            return bl2;
        }
        if (GameLogic.m_controller[n2].m_clearBall ? GameAI.playerCheckPotentialClearenceActions(nArray, n2) : (GameLogic.m_controller[n2].m_firstTimePass || GameLogic.m_controller[n2].m_passBall ? GameAI.playerCheckPotentialFirstTimePassingActions(nArray, n2) : GameAI.playerCheckPotentialControlActions(nArray, n2))) {
            return bl2;
        }
        return bl2;
    }

    public static final boolean playerUpdateStateRunToSetPiece(int[] nArray, int n2) {
        boolean bl = true;
        GameLogic.m_setPieceTaker = nArray;
        nArray[17] = 193;
        if (GameAI.playerMoveTargetReached(nArray)) {
            if (GameLogic.m_matchState == 5) {
                if (nArray[0] < 12311) {
                    nArray[22] = 64;
                    nArray[21] = 64;
                } else {
                    nArray[22] = 192;
                    nArray[21] = 192;
                }
            }
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static boolean playerUpdateStateJostleOrMarkSetPiece(int[] nArray, int n2) {
        boolean bl = false;
        nArray[6] = nArray[6] | 0x40;
        nArray[22] = nArray[35];
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            if (nArray[28] == 118) {
                if (nArray[60] != 27) {
                    GameAI.playerSetAnimation(nArray, 27);
                }
            } else if (nArray[60] != 28) {
                GameAI.playerSetAnimation(nArray, 28);
            }
            nArray[30] = 80;
        } else if (nArray[30] < 56 && nArray[60] != 0) {
            GameAI.playerSetAnimation(nArray, 0);
        }
        if (GameAI.playerMoveTargetReached(nArray)) {
            nArray[3] = 0;
            nArray[4] = 0;
        }
        if (GameLogic.m_matchState == 2 && (m_ballStorage[6] & 0xC) == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static boolean playerUpdateStateCelebrateRunAndJump(int[] nArray, int n2) {
        boolean bl = true;
        nArray[17] = 1025;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerSetState(nArray, 0, 0, 100);
        } else {
            GameLogic.m_stateTimer = 25;
        }
        return bl;
    }

    public static boolean playerUpdateStateCelebrateRunAndSlide(int[] nArray, int n2) {
        boolean bl = true;
        nArray[17] = 1025;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerSetState(nArray, 0, 0, 128);
        } else {
            GameLogic.m_stateTimer = 25;
        }
        return bl;
    }

    public static final boolean playerUpdateStateWaitingToTakeSetPiece(int[] nArray, int n2) {
        boolean bl = true;
        GameAI.playerStopRunning(nArray);
        GameLogic.m_setPieceTaker = nArray;
        GameLogic.m_controller[n2].setControlPlayer(nArray);
        if (GameLogic.m_matchState == 5) {
            int n3 = DDMath.calcAngle(nArray[0], nArray[1], 12311, 16007);
            if (GameAI.getPassTarget(nArray) != null) {
                n3 = DDMath.calcAngle(nArray, GameAI.getPassTarget(nArray));
            }
            if (nArray[0] < 12311) {
                DDMath.restrictRange(n3, 32, 96);
            } else {
                DDMath.restrictRange(n3, 160, 224);
            }
            nArray[22] = n3;
            nArray[21] = n3;
            nArray[59] = 0;
            GameAI.m_ballStorage[0] = nArray[0] - (DDMath.sin(nArray[22]) * 319 >> 16);
            GameAI.m_ballStorage[1] = nArray[1] - (DDMath.cos(nArray[22]) * 319 >> 16);
            GameAI.m_ballStorage[2] = 486;
            GameAI.m_ballStorage[5] = 0;
            GameAI.ballSetDribbleDirection(nArray[22]);
            GameAI.playerSetAnimation(nArray, 35);
            GameAI.ballSetDrawnWithinFrame(nArray, true);
            if (GameLogic.m_controller[n2].m_passBall && --GameLogic.m_stateTimer <= 0) {
                GameAI.playerSetState(nArray, m_ballStorage[0], m_ballStorage[1], 23);
                GameLogic.setState(5, 47, -1, -1);
                return bl;
            }
        } else if (GameLogic.m_matchState == 17) {
            GameAI.playerSetAnimation(nArray, 47);
            nArray[22] = nArray[35];
            if (GameLogic.m_controller[n2].m_passBall || GameLogic.m_controller[n2].m_longGoalKick) {
                GameAI.playerSetState(nArray, m_ballStorage[0], m_ballStorage[1], 15);
                GameLogic.setState(17, 43, -1, -1);
                return bl;
            }
        } else if (GameLogic.m_matchState == 1 && GameLogic.m_matchSubState == 6 || GameLogic.m_matchState == 14) {
            if (GameAI.playerMoveTargetReached(nArray)) {
                if (nArray[60] != 56) {
                    GameAI.ballSetDrawnWithinFrame(nArray, true);
                    GameAI.playerSetAnimation(nArray, 56);
                }
                nArray[59] = 1;
            } else if (nArray[60] != 11) {
                GameAI.ballSetDrawnWithinFrame(nArray, true);
                GameAI.playerSetAnimation(nArray, 11);
            }
            nArray[22] = nArray[14];
            GameAI.m_ballStorage[5] = 0;
            GameAI.m_ballStorage[0] = nArray[0] + (DDMath.sin(nArray[22]) * (nArray[7] + m_ballStorage[7]) >> 16) / 2;
            GameAI.m_ballStorage[1] = nArray[1] + (DDMath.cos(nArray[22]) * (nArray[7] + m_ballStorage[7]) >> 16) / 2;
            GameAI.m_ballStorage[2] = 358;
            if (GameAI.teamGetControlType(n2) == 2) {
                int n4 = nArray[27];
                nArray[27] = n4 + 1;
                if (n4 >= GameLogic.GOAL_KICK_MAX_DELAY) {
                    if (nArray[33] != -1) {
                        GameLogic.m_controller[n2].m_passBall = true;
                        GameLogic.m_controller[n2].m_longGoalKick = true;
                    } else if (nArray[32] != -1) {
                        GameLogic.m_controller[n2].m_passBall = true;
                    }
                }
            }
            if (GameLogic.m_controller[n2].m_passBall) {
                if (GameLogic.m_controller[nArray[12]].m_longGoalKick) {
                    GameAI.playerSetState(nArray, m_ballStorage[0], m_ballStorage[1], 173);
                } else {
                    GameAI.playerSetState(nArray, m_ballStorage[0], m_ballStorage[1], 174);
                }
                GameLogic.setState(10, 43, -1, -1);
                return bl;
            }
        } else if (GameLogic.m_matchState == 6) {
            nArray[22] = nArray[35];
            if (GameLogic.m_matchSubState != 16) {
                if (GameLogic.m_matchSubState == 17) {
                    if (GameAI.playerMoveTargetReached(nArray)) {
                        GameAI.playerStopRunning(nArray);
                    } else {
                        nArray[17] = 65;
                    }
                    GameAI.playerSelectMovementAnimation(nArray);
                } else if (GameLogic.m_matchSubState == 18) {
                    GameLogic.m_controller[n2].m_passBall = true;
                    GameAI.playerSetState(nArray, m_ballStorage[0], m_ballStorage[1], 18);
                    GameLogic.setState(6, 19, -1, -1);
                    return bl;
                }
            }
        } else if (GameLogic.m_matchState == 9) {
            nArray[22] = nArray[35];
            if (GameLogic.m_matchSubState != 25) {
                if (GameLogic.m_matchSubState == 27 || GameLogic.m_matchSubState == 26) {
                    GameAI.calculateFreeKickRunUpPosition(nArray);
                    if (GameAI.playerMoveTargetReached(nArray)) {
                        GameAI.playerStopRunning(nArray);
                        GameAI.playerSetAnimation(nArray, 0);
                    } else {
                        nArray[17] = 65;
                        nArray[23] = 47;
                        nArray[6] = nArray[6] & 0xFFFFEFFF;
                        GameAI.playerSelectMovementAnimation(nArray);
                    }
                } else if (GameLogic.m_matchSubState == 28) {
                    GameAI.calculateFreeKickRunUpPosition(nArray);
                    if (!GameAI.playerMoveTargetReached(nArray)) {
                        nArray[17] = 65;
                        nArray[23] = 47;
                        nArray[6] = nArray[6] & 0xFFFFEFFF;
                        GameAI.playerSelectMovementAnimation(nArray);
                    } else {
                        GameAI.playerStopRunning(nArray);
                        nArray[6] = nArray[6] | 0x1000;
                        GameAI.playerSelectMovementAnimation(nArray);
                        nArray[22] = nArray[35];
                        nArray[21] = nArray[35];
                        GameAI.m_ballStorage[11] = nArray[35];
                        if (GameLogic.m_setPieceMode == 1) {
                            GameAI.playerSetState(nArray, m_ballStorage[0], m_ballStorage[1], 141);
                            GameLogic.setState(9, 29, -1, -1);
                            return bl;
                        }
                        if (GameLogic.m_setPieceMode == 0 && GameLogic.m_controller[n2].m_shootBall && !GameLogic.m_controller[n2].m_blockShoot) {
                            GameAI.playerSetState(nArray, m_ballStorage[0], m_ballStorage[1], 142);
                            nArray[23] = 256;
                            GameLogic.setState(9, 30, -1, -1);
                            return bl;
                        }
                    }
                }
            }
        } else if (GameLogic.m_matchState == 8) {
            nArray[22] = nArray[35];
            if (GameLogic.m_controller[n2].m_shootBall) {
                GameAI.playerSetState(nArray, m_ballStorage[0], m_ballStorage[1], 63);
                GameLogic.setState(8, 15, -1, -1);
                return bl;
            }
        } else {
            nArray[22] = nArray[35];
        }
        return bl;
    }

    public static final boolean playerUpdateStateHumanControl(int[] nArray, int n2) {
        boolean bl = false;
        if (GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4) {
            GameAI.playerSetState(nArray, 0, 0, 0);
            bl = true;
            return true;
        }
        if (GameAI.ballIsPossessed() && GameAI.ballGetLastTouchPlayerID() == 0) {
            GameAI.playerSetState(nArray, 0, 0, 0);
            bl = true;
            return true;
        }
        if (nArray == GameLogic.m_controller[n2].m_controlPlayer) {
            if (GameLogic.m_matchState == 2) {
                if ((nArray[6] & 0x2000) != 0) {
                    GameAI.playerSetState(nArray, 0, 0, 139);
                    return bl;
                }
                if (GameLogic.m_controller[n2].m_microGame.inProgress()) {
                    bl = true;
                }
                if (GameLogic.m_controller[n2].m_hcpSprint || GameLogic.m_controller[n2].m_microGame.inProgress() || GameLogic.m_controller[n2].m_homeInOnBall) {
                    if (Trajectory.isBallUnderTrajectoryControl()) {
                        nArray[17] = 264;
                    } else if ((nArray[36] < 5 || GameLogic.m_controller[n2].m_microGame.inProgress()) && GameAI.ballIsPossessed() && GameAI.ballGetLastTouchPlayer() != nArray) {
                        GameAI.playerSetState(nArray, 0, 0, 93);
                    } else {
                        nArray[17] = 260;
                    }
                } else {
                    nArray[17] = 4352;
                }
                int[] nArray2 = GameAI.ballGetLastTouchPlayer();
                if (GameLogic.m_controller[n2].m_microGame.inProgress() && GameLogic.m_controller[n2].m_microGame.m_type == 0) {
                    if (nArray[36] > 4) {
                        GameLogic.m_controller[n2].m_hcpSprint = true;
                        GameLogic.m_controller[n2].m_microGame.updateTimeAllowed(3500);
                    } else {
                        GameLogic.m_controller[n2].m_hcpSprint = false;
                    }
                    if (((nArray[6] & 0x800) == 0 || nArray2[12] == n2) && GameLogic.m_controller[n2].m_microGame.m_state == 2) {
                        GameLogic.m_controller[n2].m_microGame.cancelMicroGame();
                        GameAI.ballSetDribbleDirection(nArray2[14]);
                        nArray2[21] = nArray2[14];
                        nArray2[17] = nArray2[17] | 0x200;
                    }
                }
                if (GameLogic.m_controller[n2].m_hcpSprint) {
                    nArray[17] = nArray[17] | 0x200;
                    nArray[23] = DDMath.max(nArray[23], 180);
                } else {
                    nArray[17] = nArray[17] & 0xFFFFFDFF;
                }
            } else {
                nArray[17] = nArray[17] & 0xFFFFFDFF;
            }
        } else {
            GameAI.playerSetState(nArray, 0, 0, 0);
            return bl;
        }
        GameAI.playerSelectMovementAnimation(nArray);
        return bl;
    }

    public static final boolean playerUpdateStateTackled(int[] nArray, int n2) {
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            GameAI.objectResetVelocity(nArray);
        }
        if ((nArray[30] = nArray[30] - 1) <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return true;
    }

    public static final boolean playerUpdateStateGoalKick(int[] nArray, int n2) {
        boolean bl = true;
        nArray[17] = 68;
        if ((nArray[6] & 0x20) != 0) {
            GameAI.m_ballStorage[10] = nArray[9] << 1 | n2;
            if (GameLogic.m_controller[n2].m_passBall && !GameLogic.m_controller[n2].m_longGoalKick) {
                if (nArray[32] != -1) {
                    GameAI.AnimatePass(nArray, m_playerStorage[n2][nArray[32]], 1, 2);
                }
                GameLogic.m_controller[n2].m_passBall = false;
            } else if (GameLogic.m_controller[n2].m_passBall && GameLogic.m_controller[n2].m_longGoalKick) {
                if (nArray[33] != -1) {
                    GameAI.AnimatePass(nArray, m_playerStorage[n2][nArray[33]], 65536, 2);
                }
                GameLogic.m_controller[n2].m_longGoalKick = false;
            } else {
                GameAI.Clearance(nArray, n2, 1);
                GameAI.playerSetState(nArray, 0, 0, 26);
                GameLogic.setState(2, -1, -1, -1);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateWaitShortPassFromGoal(int[] nArray, int n2) {
        if (GameAI.ballIsInAPass()) {
            GameAI.playerSetState(nArray, 0, 0, 0);
        }
        return false;
    }

    public static final boolean playerUpdateStateWaitShortPassFromThrowIn(int[] nArray, int n2) {
        if (GameAI.ballIsInAPass()) {
            GameAI.playerSetState(nArray, 0, 0, 0);
        }
        return false;
    }

    public static boolean playerUpdateStateWaitLongPassFromGoalKick(int[] nArray, int n2) {
        if (GameLogic.m_matchState != 17 && GameLogic.m_matchState != 14 && GameLogic.m_matchState != 10 && (m_ballStorage[6] & 4) != 0) {
            GameAI.playerSetState(nArray, 0, 0, 0);
        }
        nArray[17] = 8193;
        nArray[23] = 180;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            nArray[22] = nArray[35];
            GameAI.playerSetAnimation(nArray, 0);
        }
        return false;
    }

    public static final boolean playerUpdateStateCornerKick(int[] nArray, int n2) {
        boolean bl = true;
        nArray[17] = 4;
        if ((nArray[6] & 0x20) != 0) {
            GameAI.ballSetLastTouchPlayer(nArray);
            if (GameLogic.m_controller[n2].m_passFromFreeKickByAI) {
                int n3 = DDMath.getPositiveRandom() % 100;
                n3 = n3 > 70 ? 4 : (n3 > 40 ? 2 : 1);
                GameAI.AnimatePass(nArray, m_playerStorage[n2][nArray[32]], n3, 2);
                GameLogic.m_controller[n2].m_passFromFreeKickByAI = false;
            } else if (GameLogic.m_controller[n2].m_passBall) {
                int[] nArray2 = GameLogic.setPieceGetCurrentTarget();
                if (nArray2 == null) {
                    nArray2 = GameLogic.nearestPlayerData(GameLogic.m_setPieceTargetObject, n2, 0, nArray, null);
                }
                GameAI.AnimatePass(nArray, nArray2, GameLogic.getSetPiecePassFlags() | 0x20, 2);
            }
            GameLogic.setState(2, -1, -1, -1);
        }
        return bl;
    }

    public static final boolean playerUpdateStateInWall(int[] nArray, int n2) {
        boolean bl = false;
        if (GameLogic.m_matchState == 2) {
            if (GameLogic.m_matchPeriod != 6) {
                GameAI.playerSetState(nArray, 0, 0, 0);
            }
        } else {
            nArray[17] = 1;
            if (GameAI.playerMoveTargetReached(nArray)) {
                GameAI.playerStopRunning(nArray);
                nArray[22] = nArray[35];
            }
        }
        return bl;
    }

    public static boolean playerUpdateStatePassOrShoot(int[] nArray, int n2) {
        int n3;
        int n4;
        boolean bl = true;
        nArray[17] = 1;
        nArray[15] = m_ballStorage[0];
        nArray[16] = m_ballStorage[1];
        int n5 = nArray[0] + (DDMath.sin(nArray[22] + 128 & 0xFF) * 256 >> 16);
        if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n5, n4 = nArray[1] + (DDMath.cos(nArray[22] + 128 & 0xFF) * 256 >> 16), n3 = 0)) {
            GameAI.m_ballStorage[10] = nArray[9] << 1 | n2;
            if (GameLogic.m_controller[n2].m_shootBall) {
                GameAI.AnimateShot(nArray);
                GameLogic.m_controller[n2].m_shootBall = false;
                GameLogic.m_setPieceShotType = true;
            } else if (GameLogic.m_controller[n2].m_passFromFreeKickByAI) {
                int n6 = DDMath.getPositiveRandom() % 100;
                n6 = n6 > 70 ? 4 : (n6 > 40 ? 2 : 1);
                GameAI.AnimatePass(nArray, m_playerStorage[n2][nArray[32]], n6, 2);
                GameLogic.m_controller[n2].m_passFromFreeKickByAI = false;
            } else {
                int[] nArray2 = GameLogic.setPieceGetCurrentTarget();
                if (nArray2 == null) {
                    nArray2 = GameLogic.nearestPlayerData(GameLogic.m_setPieceTargetObject, n2, 0, nArray, null);
                }
                GameAI.AnimatePass(nArray, nArray2, GameLogic.getSetPiecePassFlags(), 2);
            }
            GameLogic.setState(2, -1, -1, -1);
        }
        return bl;
    }

    public static final boolean playerUpdateStateDefendSetPiece(int[] nArray, int n2) {
        boolean bl = false;
        nArray[23] = 42;
        nArray[17] = 10241;
        if (nArray[57] == 3) {
            nArray[17] = nArray[17] | 0x20;
            nArray[22] = nArray[35];
        }
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            GameAI.playerSetAnimation(nArray, 0);
            if (GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6) {
                nArray[22] = nArray[35];
                if ((GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6) && (nArray[56] = nArray[56] - 1) <= 0) {
                    nArray[56] = MainFrame.m_inGameFrameRate / 2 + DDMath.getPositiveRandom() % (MainFrame.m_inGameFrameRate * 6);
                    if (nArray[57] == 0) {
                        nArray[57] = 1;
                        GameAI.playerSetAnimation(nArray, 29);
                    } else if (nArray[57] == 1) {
                        nArray[57] = 0;
                        GameAI.playerSetAnimation(nArray, 30);
                    }
                    int[] nArray2 = new int[]{0, 1, 2, 3};
                    GameAI.calculateMovePositionToSideOfPlayer(nArray, nArray2[nArray[57]], 2);
                }
            } else {
                GameAI.playerSetState(nArray, 12311, GameAI.teamGetPitchSide(n2) == 1 ? 32015 - DDMath.getPositiveRandom() % 3089 : DDMath.getPositiveRandom() % 3089, 1);
                nArray[29] = 0;
            }
        }
        return bl;
    }

    public static boolean playerUpdateStateOverlappingRun(int[] nArray, int n2) {
        nArray[17] = 1;
        GameAI.playerSelectMovementAnimation(nArray);
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        if (GameLogic.m_possession != n2) {
            GameAI.playerSetState(nArray, 0, 0, 71);
        }
        return false;
    }

    public static final boolean playerUpdateStateThrowIn(int[] nArray, int n2) {
        nArray[30] = nArray[30] - 1;
        int n3 = DDMath.calcAngle(nArray[0], nArray[1], 12311, 16007);
        if (GameAI.getPassTarget(nArray) != null) {
            n3 = DDMath.calcAngle(nArray, GameAI.getPassTarget(nArray));
        }
        if (nArray[0] < 12311) {
            DDMath.restrictRange(n3, 32, 96);
        } else {
            DDMath.restrictRange(n3, 160, 224);
        }
        nArray[22] = n3;
        nArray[21] = n3;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            GameAI.ballSetDrawnWithinFrame(nArray, false);
            m_ballStorage[6] = m_ballStorage[6] & 0xFFFFDFFF;
            int n4 = nArray[32] != -1 ? nArray[32] : nArray[33];
            int[] nArray2 = m_playerStorage[n2][n4];
            GameAI.passBall(m_ballStorage, nArray2, 8196);
            GameAI.playerSetState(nArray2, 0, 0, 10);
        }
        if (nArray[30] > GameRender.animationGetActionTime(nArray[60])) {
            nArray[6] = nArray[6] | 0x100;
            m_ballStorage[6] = m_ballStorage[6] | 0x2000;
            GameAI.m_ballStorage[0] = nArray[0];
            GameAI.m_ballStorage[1] = nArray[1];
            GameAI.m_ballStorage[2] = 486;
            GameAI.m_ballStorage[5] = 0;
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return false;
    }

    public static final boolean playerUpdateStateWaitToTakeKickOff(int[] nArray, int n2) {
        nArray[22] = nArray[35];
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[17] = 0;
        return false;
    }

    public static final void playerSetStateCelebrateCupWon(int[] nArray, int n2, int n3) {
        nArray[59] = DDMath.getPositiveRandom() % 10;
    }

    public static final boolean playerUpdateStateCelebrateCupWon(int[] nArray, int n2) {
        nArray[22] = nArray[22];
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[17] = 0;
        return false;
    }

    public static final boolean playerUpdateStateGoalkeeperFormation(int[] nArray, int n2) {
        int n3;
        boolean bl = false;
        if (n2 == 1) {
            n3 = 10;
        }
        if (GameLogic.m_gameMode != 99 && (GameLogic.m_gameMode != 1 || GameLogic.m_matchPeriod != 4)) {
            GameAI.playerRunToFormationPosition(nArray);
            nArray[17] = nArray[17] | 0x40;
            if (GameLogic.m_matchState == 8) {
                GameAI.playerRunUsingPreciseTarget(nArray);
            }
            if (GameAI.playerMoveTargetReached(nArray) || GameAI.ballIsInTheGoal() || GameLogic.m_matchState == 2 || GameLogic.m_matchState == 8) {
                if (GameAI.playerMoveTargetReached(nArray)) {
                    nArray[30] = nArray[30] - 1;
                    if (nArray[30] <= 0) {
                        GameAI.playerSetAnimation(nArray, 5);
                        GameAI.playerStopRunning(nArray);
                    } else {
                        GameAI.playerRunAtSetSpeed(nArray, 180);
                    }
                } else {
                    nArray[30] = MainFrame.m_inGameFrameRate / 4;
                    if (nArray[60] != 64) {
                        GameAI.playerSetAnimation(nArray, 64);
                    }
                    GameAI.playerRunAtSetSpeed(nArray, 180);
                }
            } else {
                GameAI.playerSetAnimation(nArray, 16);
                GameAI.playerRunAtSetSpeed(nArray, 180);
            }
        } else {
            GameAI.playerStopRunning(nArray);
            GameAI.playerSetAnimation(nArray, 5);
        }
        nArray[21] = nArray[22] = nArray[35];
        GameFormation.keeperUpdateLevel1(n2, nArray);
        if (GameLogic.m_matchPeriod != 4) {
            GameFormation.keeperUpdateLevel2(n2, nArray);
        } else if (GameLogic.inShootoutView() && (GameLogic.m_matchSubState == 12 || GameLogic.m_matchSubState == 13)) {
            nArray[0] = nArray[25];
        }
        if (!((nArray[6] & 0x20) == 0 || GameAI.ballGetLastTouchPlayerTeam() == n2 && GameAI.ballIsPossessed())) {
            boolean bl2 = false;
            n3 = m_ballStorage[0] - 12311;
            int n4 = m_ballStorage[1];
            if (n3 > -5670 && n3 < 5670 && (n4 > 0 && n4 < 4633 || n4 > 27382 && n4 < 32015)) {
                bl2 = true;
            }
            GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
            if (bl2) {
                m_playerWithBall = nArray;
                GameAI.playerSetState(nArray, 0, 0, 29);
            } else {
                GameAI.Clearance(nArray, nArray[12], 1);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateGoalkeeperRushDribbler(int[] nArray, int n2) {
        boolean bl = false;
        boolean bl2 = GameLogic.isObjectIn18YardBox(m_ballStorage, GameAI.teamGetPitchSide(n2));
        if (GameLogic.m_possession == n2 || GameLogic.m_matchState != 2 || !bl2 || !GameAI.ballIsPossessed()) {
            GameAI.playerSetState(nArray, 0, 0, 26);
            return bl;
        }
        if (nArray[36] < 3) {
            GameAI.playerSetState(nArray, 0, 0, 28);
            return bl;
        }
        nArray[17] = 68;
        nArray[21] = nArray[22] = nArray[35];
        return bl;
    }

    public static final boolean playerUpdateStateGoalkeeperDiveAtPlayersFeet(int[] nArray, int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl = true;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n5 = nArray[0] + (DDMath.sin(nArray[22]) * 256 >> 16), n4 = nArray[1] + (DDMath.cos(nArray[22]) * 256 >> 16), n3 = nArray[2])) {
            GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
            GameAI.ballSetAtPlayersFeet(nArray);
            GameAI.objectResetVelocity(m_ballStorage);
            GameAI.ballSetDrawnWithinFrame(nArray, true);
            GameAI.ballSetCollision(false);
            GameLogic.m_controller[0].setControlPlayer(null);
            GameLogic.m_controller[1].setControlPlayer(null);
        }
        if (nArray[30] < GameRender.animationGetActionTime(nArray[60])) {
            nArray[3] = nArray[3] * 200 >> 8;
            nArray[4] = nArray[4] * 200 >> 8;
        }
        if ((nArray[30] = nArray[30] - 1) <= 0) {
            GameAI.objectResetVelocity(nArray);
            if (GameAI.ballIsPossessed() && nArray == GameAI.ballGetLastTouchPlayer()) {
                GameAI.playerSetState(nArray, 0, 0, 29);
            } else {
                GameAI.playerSetState(nArray, 0, 0, 26);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateGoalkeeperHandKickWait(int[] nArray, int n2) {
        GameLogic.m_setPieceTaker = nArray;
        GameAI.m_ballStorage[5] = 0;
        int n3 = (nArray[22] + 16 & 0xE0) >> 5 << 5;
        GameAI.m_ballStorage[0] = nArray[0] + (DDMath.sin(n3) * nArray[7] >> 16);
        GameAI.m_ballStorage[1] = nArray[1] + (DDMath.cos(n3) * nArray[7] >> 16);
        GameAI.m_ballStorage[2] = 358;
        GameAI.m_ballStorage[5] = 0;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            if (GameLogic.m_matchState == 1 && GameLogic.m_matchSubState == 6 || GameLogic.m_matchState == 14) {
                nArray[17] = 65;
                if (GameAI.playerMoveTargetReached(nArray)) {
                    if (GameLogic.m_matchState != 14) {
                        GameLogic.setState(14, -1, 2, -1);
                    }
                } else if (nArray[60] != 11) {
                    GameAI.ballSetDrawnWithinFrame(nArray, true);
                    GameAI.playerSetAnimation(nArray, 11);
                }
            }
        } else if (nArray[60] != 56) {
            GameAI.playerSetAnimation(nArray, 56);
        }
        if (GameLogic.m_controller[n2].m_buttonThrough) {
            GameFormation.jumpPlayersToTheirPositions();
            GameLogic.m_controller[n2].m_buttonThrough = false;
        }
        return false;
    }

    public static final boolean playerUpdateStateGoalkeeperThrowBallOut(int[] nArray, int n2) {
        int n3 = n2;
        if (GameLogic.m_gameMode == 2 && n2 == 1) {
            n3 = 0;
        }
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int[] nArray2 = null;
        if (nArray[32] != -1) {
            nArray2 = m_playerStorage[n2][nArray[32]];
            n4 = nArray2[0] - nArray[0];
            n5 = nArray2[1] - nArray[1];
        } else {
            nArray2 = GameLogic.nearestPlayerData(nArray, n3, 0);
            if (nArray2 != null) {
                n4 = nArray2[0] - nArray[0];
                n5 = nArray2[1] - nArray[1];
                DDDebug.msg("PASSING: error, no short pass target for the keeper to throw to");
            } else {
                return bl;
            }
        }
        nArray[22] = DDMath.atan(n4, n5) & 0xFF;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            GameAI.ballSetLastTouchPlayer(nArray);
            GameAI.ballSetCollision(true);
            GameAI.ballSetDrawnWithinFrame(nArray, false);
            GameAI.m_ballStorage[0] = nArray[0] + 0;
            GameAI.m_ballStorage[1] = nArray[1] + (140 * DDMath.cos(nArray[14]) >> 16);
            GameAI.m_ballStorage[2] = nArray[2] + 460;
            GameAI.passBall(m_ballStorage, nArray2, 1);
            GameAI.playerSetState(nArray2, 0, 0, 10);
            GameLogic.setState(2, -1, -1, -1);
            GameLogic.m_controller[n2].resetAllActions();
        } else if (nArray[30] > GameRender.animationGetActionTime(nArray[60])) {
            GameAI.ballSetDrawnWithinFrame(nArray, true);
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateGoalkeeperDropKick(int[] nArray, int n2) {
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int[] nArray2 = null;
        if (nArray[33] == -1) {
            DDDebug.msg("PASSING: error, no long pass target for the keeper to throw to");
            return bl;
        }
        nArray2 = GameLogic.m_gameMode == 2 && n2 == 1 ? m_playerStorage[n2 ^ 1][nArray[33]] : m_playerStorage[n2][nArray[33]];
        n3 = nArray2[0] - nArray[0];
        n4 = nArray2[1] - nArray[1];
        nArray[22] = nArray[14];
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            GameAI.ballSetLastTouchPlayer(nArray);
            GameAI.ballSetDrawnWithinFrame(nArray, false);
            GameAI.ballSetCollision(true);
            GameAI.m_ballStorage[0] = nArray[0] + 0;
            GameAI.m_ballStorage[1] = nArray[1] + (409 * DDMath.cos(nArray[14]) >> 16);
            GameAI.m_ballStorage[2] = nArray[2] + 204;
            m_ballInSwerveCross = false;
            GameAI.passBall(m_ballStorage, nArray2, 1024);
            GameAI.playerSetState(nArray2, 0, 0, 10);
            GameLogic.m_controller[n2].resetAllActions();
            GameLogic.setState(2, -1, -1, -1);
        } else if (nArray[30] > GameRender.animationGetActionTime(nArray[60])) {
            GameAI.ballSetDrawnWithinFrame(nArray, true);
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateWaitShot(int[] nArray, int n2) {
        int n3;
        int n4;
        boolean bl = false;
        int n5 = 5;
        if (nArray[29] != 0 && nArray[29] != 26 && (n4 = m_stateLookUpTable[(n3 = nArray[29] * 4) + 0]) > 0 && GameRender.animationGetActionTime(n4) > 0) {
            n5 = GameRender.animationGetDuration(n4) - GameRender.animationGetActionTime(n4);
        }
        if (nArray[29] == 188) {
            n5 = 15;
        }
        n3 = 0;
        if (Trajectory.isBallUnderTrajectoryControl() && m_shotTargetObject[0] == Trajectory.getEndX(0) && m_shotTargetObject[1] == Trajectory.getEndY(0) && m_shotTargetObject[2] == Trajectory.getEndZ(0)) {
            n3 = Trajectory.getTimeToTarget(0);
        } else {
            n3 = m_ballStorage[4] != 0 ? (m_shotTargetObject[1] - m_ballStorage[1]) / m_ballStorage[4] : 100;
            n3 = DDMath.max(n3, 0);
        }
        if (!GameAI.ballIsInAShot() && !Trajectory.isBallUnderTrajectoryControl() || GameAI.ballIsPossessed()) {
            if (GameAI.ballIsInTheGoal()) {
                GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            } else {
                GameAI.playerSetState(nArray, 0, 0, 26);
            }
        } else {
            n4 = 0;
            if (nArray[29] >= 39 && nArray[29] <= 58) {
                int n6 = (nArray[29] - 39) * 5;
                if ((m_goalkeeperDiveTable[n6 + 4] & 0x10000) != 0) {
                    n4 = 1;
                }
                if (GameLogic.m_matchPeriod == 4 && nArray[29] != 39) {
                    n4 -= 4;
                }
            }
            if (n3 + n4 <= n5) {
                GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateStationary180(int[] nArray, int n2) {
        boolean bl = true;
        GameAI.ballSetCollision(false);
        nArray[6] = nArray[6] | 0x40;
        nArray[22] = nArray[56];
        if (GameLogic.m_matchState != 2 || GameAI.ballGetLastTouchPlayer() != nArray) {
            GameAI.playerSetState(nArray, 0, 0, 0);
            GameAI.ballSetDrawnWithinFrame(nArray, false);
            GameAI.ballSetCollision(true);
            return bl;
        }
        if (nArray[59] < 1) {
            GameAI.ballSetDrawnWithinFrame(nArray, true);
        } else {
            GameAI.ballSetDrawnWithinFrame(nArray, false);
        }
        int n3 = (int)(2048.0 / (double)MainFrame.m_inGameFrameRate);
        GameAI.m_ballStorage[3] = DDMath.sin(nArray[22] + 128 & 0xFF) * n3 >> 16;
        GameAI.m_ballStorage[4] = DDMath.cos(nArray[22] + 128 & 0xFF) * n3 >> 16;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            nArray[22] = nArray[21] = m_ballStorage[11];
            GameAI.ballSetAtPlayersFeet(nArray);
            GameAI.playerStopRunning(nArray);
            GameAI.playerSetState(nArray, 0, 0, 9);
        }
        return bl;
    }

    public static final boolean playerUpdateState180(int[] nArray, int n2) {
        boolean bl = true;
        int n3 = (int)(2585.6 / (double)MainFrame.m_inGameFrameRate);
        if (GameLogic.m_matchState != 2 || GameAI.ballGetLastTouchPlayer() != nArray) {
            GameAI.playerSetState(nArray, 0, 0, 0);
            if (GameFormation.getPlayerType(GameAI.ballGetLastTouchPlayer()[52]) != 0) {
                GameAI.ballSetDrawnWithinFrame(nArray, false);
                GameAI.ballSetCollision(true);
            }
            return bl;
        }
        if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, nArray[0], nArray[1], 0)) {
            GameAI.ballSetCollision(false);
        }
        nArray[6] = nArray[6] | 0x40;
        nArray[22] = nArray[56];
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            m_ballStorage[6] = m_ballStorage[6] & 0xFFFFFF7F;
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, nArray[0], nArray[1], 0)) {
                GameAI.m_ballStorage[5] = 0;
                GameAI.m_ballStorage[2] = 0;
                GameAI.ballSetDrawnWithinFrame(nArray, false);
            } else {
                nArray[6] = nArray[6] | 0x800000;
            }
            m_ballStorage[6] = m_ballStorage[6] | 0x80;
        }
        if (nArray[59] == GameRender.animationGetTempo(nArray[60]) * 2) {
            if ((nArray[6] & 0x800000) == 0) {
                GameAI.m_ballStorage[3] = DDMath.sin(nArray[22] & 0xFF) * (GameLogic.PLAYER_KICK_BALL_FORWARDS_BALL_SPEED >> 2) >> 16;
                GameAI.m_ballStorage[4] = DDMath.cos(nArray[22] & 0xFF) * (GameLogic.PLAYER_KICK_BALL_FORWARDS_BALL_SPEED >> 2) >> 16;
            }
            int n4 = DDMath.sin(nArray[22]) * 128;
            int n5 = DDMath.cos(nArray[22]) * 128;
            nArray[0] = nArray[0] + (n4 >> 16);
            nArray[1] = nArray[1] + (n5 >> 16);
            GameLogic.m_controller[n2].m_controlPlayerMoveTimer = -1;
            GameAI.playerStopRunning(nArray);
        } else if (nArray[59] > GameRender.animationGetTempo(nArray[60]) * 3) {
            GameLogic.m_controller[n2].m_controlPlayerMoveTimer = nArray[59] * GameRender.animationGetTempo(48);
            nArray[23] = 100;
            nArray[6] = nArray[6] | 0x10000;
            if ((nArray[6] & 0x800000) == 0) {
                GameAI.m_ballStorage[3] = DDMath.sin(nArray[22] + 128 & 0xFF) * n3 >> 16;
                GameAI.m_ballStorage[4] = DDMath.cos(nArray[22] + 128 & 0xFF) * n3 >> 16;
            }
        }
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            if ((nArray[6] & 0x800000) == 0) {
                nArray[22] = nArray[21] = m_ballStorage[11];
                GameAI.playerSetState(nArray, 0, 0, 9);
                nArray[6] = nArray[6] & 0xFFFEFFFF;
            } else {
                GameAI.playerSetState(nArray, 0, 0, 34);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateChaseBall(int[] nArray, int n2) {
        boolean bl = false;
        if ((GameAI.ballIsPossessed() || GameAI.keeperGrabbedBall() || GameLogic.m_matchState != 2) && (nArray != GameLogic.m_quickPlayMomentSetPieceTargetObject || GameLogic.m_quickPlayMomentTriggeredTimer <= 0)) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            return true;
        }
        if (GameAI.ballIsInTheGoal()) {
            GameAI.playerSetState(nArray, 0, 0, 0);
            return true;
        }
        if (GameAI.teamGetControlType(n2) == 2) {
            GameLogic.m_controller[n2].setControlPlayer(nArray);
        }
        GameAI.playerSelectMovementAnimation(nArray);
        nArray[17] = (Trajectory.isBallUnderTrajectoryControl() ? 8 : 4) | 0x40;
        nArray[17] = (nArray[17] & 0x200) == 0 && !GameAI.ballIsInAPass() && nArray[31] % 100 < 30 ? nArray[17] | 0x200 : nArray[17] | 0x2000;
        if (nArray[48] == 0) {
            if (GameAI.projectedBallCollisionWithSpecifiedAnimation(18, nArray[0], nArray[1], 0)) {
                GameAI.playerSetState(nArray, 0, 0, 160);
            }
            return bl;
        }
        if (GameLogic.m_controller[n2].m_clearBall ? GameAI.playerCheckPotentialClearenceActions(nArray, n2) : GameLogic.m_controller[n2].m_firstTimePass && GameAI.playerCheckPotentialFirstTimePassingActions(nArray, n2)) {
            return bl;
        }
        if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray) && m_ballStorage[2] < 243 || GameAI.playerHasCollidedWithTheBall(nArray)) {
            int[] nArray2 = GameAI.ballGetLastTouchPlayer();
            int n3 = GameAI.ballGetLastTouchPlayerTeam();
            if (GameLogic.m_possession != n3) {
                GameLogic.beAProCheckIfBAPStatAchieved(12, nArray2, null);
            }
            if (GameAI.checkIfChasedBallIsCloseToEdgeOfPitch(nArray)) {
                GameAI.playerStopRunning(nArray);
                GameAI.teamSetPossession(nArray, m_teamStorage[nArray[12]], nArray[12]);
                GameLogic.m_controller[n2].m_controlPlayerMoveTimer = -1;
                m_playerWithBallDribbleSpeed = 0;
                nArray[23] = 0;
                GameAI.playerSetAnimation(nArray, 67);
            } else {
                GameAI.teamSetPossession(nArray, m_teamStorage[nArray[12]], nArray[12]);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateGoalKeeperCatchBallAboveHead(int[] nArray, int n2) {
        boolean bl = false;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3 = nArray[0];
            int n4 = nArray[1];
            int n5 = nArray[2] + 486;
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n3, n4, n5)) {
                GameAI.objectResetVelocity(m_ballStorage);
                GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
                nArray[29] = 29;
            }
            GameAI.playerStopRunning(nArray);
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateHoldPosition(int[] nArray, int n2) {
        boolean bl = false;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStatePassBall(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3 = m_ballStorage[10];
            if (m_animationPassTarget != null && (nArray == GameAI.ballGetLastTouchPlayer() || GameLogic.m_controller[n2].m_firstTimePass)) {
                GameAI.ballSetLastTouchPlayer(nArray);
                GameLogic.m_controller[n2].m_firstTimePass = false;
                DDDebug.msg("PASSING: call pass ball from animation pass ball state");
                GameAI.passBall(m_ballStorage, m_animationPassTarget, m_animationPassFlags);
                nArray[6] = nArray[6] | 0x40;
                if ((m_animationPassFlags & 0x40) == 0) {
                    if (m_animationPassTarget != GameLogic.m_setPieceTargetObject) {
                        if ((m_animationPassFlags & 8) != 0 && Trajectory.isBallUnderTrajectoryControl() && Trajectory.getTimeToTarget(0) > 10) {
                            GameAI.playerSetState(m_animationPassTarget, 0, 0, 183);
                        } else {
                            GameAI.playerSetState(m_animationPassTarget, 0, 0, 10);
                        }
                    }
                    if (GameAI.teamGetControlType(n2) == 2 && nArray == GameLogic.m_controller[n2].m_controlPlayer && m_animationPassTarget != GameLogic.m_setPieceTargetObject) {
                        GameLogic.m_controller[n2].setControlPlayer(m_animationPassTarget);
                    }
                } else {
                    GameLogic.m_controller[n2].setControlPlayer(null);
                }
            }
            if (m_animationPassTarget == null) {
                // empty if block
            }
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            if (GameAI.teamGetControlType(n2) == 2 && nArray == GameLogic.m_controller[n2].m_controlPlayer && m_animationPassTarget != GameLogic.m_setPieceTargetObject) {
                GameLogic.m_controller[n2].setControlPlayer(m_animationPassTarget);
            }
            if (GameLogic.m_matchNextState != -1 && GameLogic.m_matchState != 3 && GameLogic.m_matchState != 1) {
                GameLogic.setState(GameLogic.m_matchNextState, -1, -1, -1);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateShootBall(int[] nArray, int n2) {
        int n3;
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[22] != nArray[14]) {
            n3 = DDMath.calcTurnAngle(nArray[22], nArray[14]);
            n3 = DDMath.min(n3, 32);
            n3 = DDMath.max(n3, -32);
            nArray[21] = nArray[22] = nArray[22] + n3;
            if (nArray[30] <= GameRender.animationGetActionTime(nArray[60])) {
                // empty if block
            }
        }
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            n3 = nArray[0];
            int n4 = nArray[1];
            int n5 = 576;
            if ((m_ballStorage[10] & 1) == n2 && m_ballStorage[10] >> 1 == nArray[9] && GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n3, n4, n5)) {
                GameAI.ballSetLastTouchPlayer(nArray);
                int n6 = GameAI.shootCalculateShotType(nArray, n2, m_idealShotType);
                GameAI.shootKickBall(nArray, GameAI.shootAim(nArray, n2, n6 >> 2, n6 & 3));
                nArray[6] = nArray[6] | 0x40;
                theOneWhoShoot = nArray;
                shootingPlayerFrameCnt = 10;
                GameLogic.m_setPieceShotType = false;
            } else {
                nArray[29] = 14;
            }
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            if (GameAI.teamGetControlType(n2) == 2) {
                GameLogic.m_controller[n2].setControlPlayer(null);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateInterceptPass(int[] nArray, int n2) {
        boolean bl = false;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            nArray[21] = nArray[22] = nArray[35];
        } else {
            GameAI.playerRunToMovePosition(nArray);
            GameAI.playerRunAtSetSpeed(nArray, 256);
            GameAI.playerRunUsingPreciseTarget(nArray);
        }
        GameAI.playerSelectMovementAnimation(nArray);
        if (!GameAI.ballIsInAPass()) {
            GameAI.playerSetState(nArray, 0, 0, 0);
        }
        if (!GameAI.playerMoveTargetReached(nArray)) {
            if (GameAI.projectedBallCollisionWithSpecifiedAnimation(22, nArray[15], nArray[16], 0)) {
                GameAI.playerSetState(nArray, nArray[15], nArray[16], 175);
                return bl;
            }
            if (GameAI.projectedBallCollisionWithSpecifiedAnimation(77, nArray[15], nArray[16], 217)) {
                GameAI.playerSetState(nArray, nArray[15], nArray[16], 176);
                return bl;
            }
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(80, nArray[15], nArray[16], 0)) {
            GameAI.playerSetState(nArray, 0, 0, 168);
            return bl;
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(1, nArray[15], nArray[16], 320)) {
            GameAI.playerSetState(nArray, 0, 0, 170);
            return bl;
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(82, nArray[15], nArray[16], 486)) {
            GameAI.playerSetState(nArray, 0, 0, 169);
            return bl;
        }
        if (GameAI.playerHasCollidedWithTheBall(nArray)) {
            // empty if block
        }
        return bl;
    }

    public static final boolean playerUpdateStateRunToJostleForTheBall(int[] nArray, int n2) {
        int[] nArray2 = GameAI.playerGetMarkTarget(nArray);
        boolean bl = false;
        nArray[17] = 10241;
        nArray[23] = 360;
        if (GameLogic.m_matchState != 2 && GameLogic.m_matchState != 17) {
            GameAI.playerSetState(nArray, 0, 0, 0);
            return bl;
        }
        if (nArray2 != null) {
            int n3 = DDMath.calcAngle(nArray2, m_ballStorage) + 128 & 0xFF;
            nArray[15] = nArray2[0] + (DDMath.sin(n3) * 498 >> 16);
            nArray[16] = nArray2[1] + (DDMath.cos(n3) * 498 >> 16);
            if (nArray2[28] != 10) {
                GameAI.playerSetState(nArray, 0, 0, 0);
                return bl;
            }
        } else {
            GameLogic.ballCalculateFutureBouncePosition();
            nArray[15] = GameLogic.m_ballBouncePositionX;
            nArray[16] = GameLogic.m_ballBouncePositionY;
            if (GameAI.ballIsPossessed()) {
                GameAI.playerSetState(nArray, 0, 0, 0);
                return bl;
            }
        }
        if (GameAI.playerMoveTargetReached(nArray)) {
            nArray[22] = nArray[35];
            GameAI.playerStopRunning(nArray);
            if (nArray2 != null && Trajectory.isBallUnderTrajectoryControl() && Trajectory.getTimeToTarget(0) == GameRender.animationGetDuration(63) + GameRender.animationGetFramesUntilAction(2)) {
                nArray2[6] = nArray2[6] & 0xFFFFFFFE;
                GameAI.playerSetState(nArray, nArray2[0], nArray2[1], 153);
                return bl;
            }
        }
        GameAI.playerSelectMovementAnimation(nArray);
        return bl;
    }

    public static final boolean playerUpdateStateShoveOpponentForwards(int[] nArray, int n2) {
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            if (Trajectory.isBallUnderTrajectoryControl()) {
                int n3 = DDMath.calcHorizontalDistSquared(nArray, Trajectory.getEndX(0), Trajectory.getEndY(0));
                if (n3 < 0x190000) {
                    GameAI.playerSetState(nArray, 0, 0, 10);
                } else {
                    GameAI.playerSetState(nArray, 0, 0, 0);
                }
            } else {
                GameAI.playerSetState(nArray, 0, 0, 0);
            }
        } else {
            nArray[22] = nArray[35];
            GameAI.playerStopRunning(nArray);
        }
        return false;
    }

    public static final boolean playerUpdateStateSlideToInterceptBall(int[] nArray, int n2) {
        boolean bl = true;
        nArray[6] = nArray[6] | 0x1000;
        nArray[17] = 0;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3;
            int n4;
            int n5 = nArray[0] + (DDMath.sin(nArray[22]) * 384 >> 16);
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n5, n4 = nArray[1] + (DDMath.cos(nArray[22]) * 384 >> 16), n3 = nArray[2])) {
                GameAI.Clearance(nArray, n2, 0);
            }
        } else if (nArray[30] < GameRender.animationGetActionTime(nArray[60])) {
            nArray[3] = nArray[3] >> 1;
            nArray[4] = nArray[4] >> 1;
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            if (GameLogic.isFreeBallSituation()) {
                nArray[29] = 34;
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateRunOntoInterception(int[] nArray, int n2) {
        boolean bl = true;
        nArray[6] = nArray[6] | 0x1040;
        nArray[17] = 0;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3;
            int n4;
            int n5 = nArray[0] + (DDMath.sin(nArray[22]) * 256 >> 16);
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n5, n4 = nArray[1] + (DDMath.cos(nArray[22]) * 256 >> 16), n3 = nArray[2])) {
                GameAI.m_ballStorage[0] = n5;
                GameAI.m_ballStorage[1] = n4;
                int n6 = GameAI.ballGetSpeed() * 200 >> 8;
                GameAI.m_ballStorage[3] = DDMath.sin(nArray[22]) * n6 >> 16;
                GameAI.m_ballStorage[4] = DDMath.cos(nArray[22]) * n6 >> 16;
                GameAI.Clearance(nArray, n2, 6);
            }
        } else if (nArray[30] < GameRender.animationGetActionTime(nArray[60])) {
            nArray[3] = nArray[3] >> 1;
            nArray[4] = nArray[4] >> 1;
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            if (GameLogic.isFreeBallSituation()) {
                nArray[29] = 34;
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateKeeperInterceptPass(int[] nArray, int n2) {
        boolean bl = false;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            nArray[21] = nArray[22] = nArray[35];
        } else {
            GameAI.playerRunToMovePosition(nArray);
            GameAI.playerRunUsingPreciseTarget(nArray);
            GameAI.playerRunAtSetSpeed(nArray, 360);
        }
        if (!GameAI.ballIsInAPass()) {
            GameAI.playerSetState(nArray, 0, 0, 26);
            return bl;
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(12, nArray[15], nArray[16], 716) || GameAI.projectedBallCollisionWithSpecifiedAnimation(12, nArray[15], nArray[16], 563) || GameAI.projectedBallCollisionWithSpecifiedAnimation(12, nArray[15], nArray[16], 409)) {
            GameLogic.ballCalculateFutureBallPosition(GameRender.animationGetFramesUntilAction(12));
            GameAI.playerSetMoveTargetPosition(nArray, GameLogic.m_futureBallObject[0], GameLogic.m_futureBallObject[1]);
            GameAI.playerSetState(nArray, nArray[15], nArray[16], 178);
            return bl;
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(54, nArray[15], nArray[16], 307)) {
            GameLogic.ballCalculateFutureBallPosition(GameRender.animationGetDuration(54) - GameRender.animationGetActionTime(54));
            nArray[15] = GameLogic.m_futureBallObject[0];
            nArray[16] = GameLogic.m_futureBallObject[1];
            GameAI.playerSetState(nArray, nArray[15], nArray[16], 179);
            return bl;
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(83, nArray[15], nArray[16], 0)) {
            GameLogic.ballCalculateFutureBallPosition(GameRender.animationGetFramesUntilAction(83));
            nArray[15] = GameLogic.m_futureBallObject[0];
            nArray[16] = GameLogic.m_futureBallObject[1];
            GameAI.playerSetState(nArray, nArray[15], nArray[16], 181);
            return bl;
        }
        return bl;
    }

    public static final boolean playerUpdateStateKeeperPunchBallAway(int[] nArray, int n2) {
        boolean bl = true;
        nArray[6] = nArray[6] | 0x1000;
        nArray[17] = 0;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60]) + 2) {
            GameLogic.ballCalculateFutureBallPosition(2);
            if (GameLogic.m_futureBallObject[2] > 614) {
                nArray[5] = (GameLogic.m_futureBallObject[2] - 614 + 2 * GameLogic.GRAVITY_PER_FRAME) / 2;
            }
        }
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3;
            int n4;
            nArray[22] = nArray[35];
            int n5 = nArray[0] + (DDMath.sin(nArray[22]) * 256 >> 16);
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n5, n4 = nArray[1] + (DDMath.cos(nArray[22]) * 256 >> 16), n3 = nArray[2])) {
                GameAI.ballSetLastTouchPlayer(nArray);
                GameAI.Clearance(nArray, n2, 5);
            }
        } else if (nArray[30] < GameRender.animationGetActionTime(nArray[60])) {
            nArray[3] = nArray[3] >> 1;
            nArray[4] = nArray[4] >> 1;
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            if (GameLogic.isFreeBallSituation()) {
                nArray[29] = 79;
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateGoalKeeperCatchShotFromDistance(int[] nArray, int n2) {
        boolean bl = false;
        GameLogic.ballCalculateFutureBallPosition(10);
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            GameAI.playerSetAnimation(nArray, 5);
        } else {
            GameAI.playerRunToMovePosition(nArray);
        }
        if (GameAI.ballIsPossessed()) {
            GameAI.playerSetState(nArray, 0, 0, 71);
        }
        if (DDMath.calcHorizontalDistSquared(nArray, nArray[15], nArray[16]) < 0x640000) {
            if (GameAI.projectedBallCollisionWithSpecifiedAnimation(53, nArray[15], nArray[16], 716) || GameAI.projectedBallCollisionWithSpecifiedAnimation(53, nArray[15], nArray[16], 563) || GameAI.projectedBallCollisionWithSpecifiedAnimation(53, nArray[15], nArray[16], 409)) {
                GameLogic.ballCalculateFutureBallPosition(GameRender.animationGetFramesUntilAction(53));
                GameAI.playerSetMoveTargetPosition(nArray, GameLogic.m_futureBallObject[0], GameLogic.m_futureBallObject[1]);
                GameAI.playerSetState(nArray, nArray[15], nArray[16], 189);
                return bl;
            }
            if (GameAI.projectedBallCollisionWithSpecifiedAnimation(54, nArray[15], nArray[16], 307)) {
                GameLogic.ballCalculateFutureBallPosition(GameRender.animationGetFramesUntilAction(54));
                nArray[15] = GameLogic.m_futureBallObject[0];
                nArray[16] = GameLogic.m_futureBallObject[1];
                GameAI.playerSetState(nArray, nArray[15], nArray[16], 179);
                return bl;
            }
            if (GameAI.projectedBallCollisionWithSpecifiedAnimation(83, nArray[15], nArray[16], 0)) {
                GameLogic.ballCalculateFutureBallPosition(GameRender.animationGetFramesUntilAction(83));
                nArray[15] = GameLogic.m_futureBallObject[0];
                nArray[16] = GameLogic.m_futureBallObject[1];
                GameAI.playerSetState(nArray, nArray[15], nArray[16], 181);
                return bl;
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateGoalKeeperCatchBallBody(int[] nArray, int n2) {
        boolean bl = true;
        nArray[6] = nArray[6] | 0x1000;
        nArray[17] = 0;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3 = nArray[0];
            int n4 = nArray[1];
            int n5 = nArray[2] + 243;
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n3, n4, n5)) {
                GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
                nArray[29] = 29;
            }
        } else if (nArray[30] < GameRender.animationGetActionTime(nArray[60])) {
            nArray[3] = nArray[3] >> 1;
            nArray[4] = nArray[4] >> 1;
            if (nArray[29] == 29) {
                GameAI.playerStopRunning(nArray);
                GameAI.ballSetAtPlayersFeet(nArray);
                GameAI.ballSetDrawnWithinFrame(nArray, true);
                GameAI.m_ballStorage[2] = 230;
            }
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            if (GameLogic.isFreeBallSituation()) {
                nArray[29] = 79;
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateGoalKeeperCatchBallLow(int[] nArray, int n2) {
        boolean bl = true;
        nArray[6] = nArray[6] | 0x1000;
        nArray[21] = nArray[22];
        nArray[17] = 0;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3;
            int n4;
            int n5 = nArray[0] + (DDMath.sin(nArray[22]) * 384 >> 16);
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n5, n4 = nArray[1] + (DDMath.cos(nArray[22]) * 384 >> 16), n3 = nArray[2] + 243)) {
                GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
                nArray[29] = 29;
            }
        } else if (nArray[30] < GameRender.animationGetActionTime(nArray[60])) {
            nArray[3] = nArray[3] * 200 >> 8;
            nArray[4] = nArray[4] * 200 >> 8;
            if (nArray[29] == 29) {
                GameAI.playerStopRunning(nArray);
                GameAI.ballSetAtPlayersFeet(nArray);
                GameAI.ballSetDrawnWithinFrame(nArray, true);
            }
        }
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            if (GameLogic.isFreeBallSituation()) {
                nArray[29] = 79;
            }
        }
        return bl;
    }

    public static boolean playerUpdateStateGoalKeeperClearance(int[] nArray, int n2) {
        boolean bl = true;
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == GameRender.animationGetActionTime(nArray[60])) {
            int n3 = nArray[0] + (DDMath.sin(nArray[22]) * 256 >> 16);
            int n4 = nArray[1] + (DDMath.cos(nArray[22]) * 256 >> 16);
            int n5 = nArray[2];
            if (nArray[28] == 180) {
                n5 += 153;
            }
            if (GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray, n3, n4, n5)) {
                GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
                GameAI.Clearance(nArray, n2, 1);
                nArray[3] = nArray[3] >> 2;
                nArray[4] = nArray[4] >> 2;
            }
        }
        if (nArray[30] < GameRender.animationGetActionTime(nArray[60])) {
            nArray[3] = nArray[3] >> 1;
            nArray[4] = nArray[4] >> 1;
        }
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static boolean playerUpdateStateGoalKeeperReceiveCross(int[] nArray, int n2) {
        boolean bl = false;
        nArray[6] = nArray[6] | 1;
        nArray[17] = 193;
        if (GameAI.playerMoveTargetReached(nArray)) {
            nArray[17] = 2113;
            if (GameAI.playerMoveTargetReached(nArray)) {
                nArray[3] = 0;
                nArray[4] = 0;
                nArray[22] = nArray[21] = nArray[35];
            }
        }
        int n3 = nArray[30];
        nArray[30] = n3 - 1;
        if (n3 <= 0) {
            int n4 = Trajectory.getTimeToTarget(0);
            if ((m_ballStorage[6] & 8) == 0) {
                GameAI.playerSetState(nArray, 0, 0, 26);
            } else if (n4 <= 2) {
                GameAI.playerSetState(nArray, 0, 0, nArray[29]);
            }
        }
        return bl;
    }

    public static boolean playerUpdateStateGoalKeeperCatchCross(int[] nArray, int n2) {
        boolean bl = false;
        nArray[6] = nArray[6] | 0x1001;
        nArray[17] = 1089;
        if (nArray[29] != 29 && (nArray[6] & 0x20) != 0) {
            GameAI.teamSetPossession(nArray, m_teamStorage[n2], n2);
            nArray[29] = 29;
            m_ballStorage[6] = m_ballStorage[6] | 0x2000;
            nArray[6] = nArray[6] | 0x100;
        }
        if (nArray[2] == 0) {
            GameAI.playerSetAnimation(nArray, 11);
        } else {
            nArray[22] = nArray[21] = nArray[35];
        }
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static boolean playerUpdateStateGoalKeeperPunchCross(int[] nArray, int n2) {
        boolean bl = true;
        if ((nArray[6] & 0x20) != 0 && (m_ballStorage[6] & 0x1000) != 0) {
            int n3 = nArray[14] + DDMath.getRandom() % 32 & 0xFF;
            int n4 = (int)(4096.0 / (double)MainFrame.m_inGameFrameRate);
            int n5 = (int)(6579.2 / (double)MainFrame.m_inGameFrameRate);
            int n6 = n4 + DDMath.getPositiveRandom() % (n5 - n4);
            int n7 = DDMath.sin(n3) * n6 >> 16;
            int n8 = DDMath.cos(n3) * n6 >> 16;
            int n9 = n6 + DDMath.getRandom() % (n6 >> 3);
            Trajectory.removeFromTrajectory(m_ballStorage, 0);
            GameAI.m_ballStorage[3] = n7;
            GameAI.m_ballStorage[4] = n8;
            GameAI.m_ballStorage[5] = n9;
            GameAI.ballSetToFreeBall();
        }
        nArray[6] = nArray[6] | 0x1001;
        nArray[17] = 1089;
        nArray[22] = nArray[21] = nArray[35];
        nArray[30] = nArray[30] - 1;
        if (nArray[30] <= 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return bl;
    }

    public static final boolean playerUpdateStateRunReadyForThroughBall(int[] nArray, int n2) {
        boolean bl = false;
        if (GameAI.playerMoveTargetReached(nArray)) {
            GameAI.playerStopRunning(nArray);
            GameAI.playerFaceBall(nArray);
        } else {
            GameAI.playerRunToMovePosition(nArray);
            GameAI.playerRunAtSetSpeed(nArray, 256);
            GameAI.playerRunUsingPreciseTarget(nArray);
        }
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == 0) {
            if (GameLogic.isPlayerOffside(nArray)) {
                GameAI.playerSetState(nArray, 0, 0, 105);
            } else {
                GameAI.playerSetState(nArray, 0, 0, 71);
            }
        }
        return bl;
    }

    public static final boolean playerUpdateStateFailedJumpForHeader(int[] nArray, int n2) {
        nArray[30] = nArray[30] - 1;
        if (nArray[30] == 0) {
            GameAI.playerSetState(nArray, 0, 0, nArray[29]);
        }
        return false;
    }

    public static final void playerUpdateVelocity(int[] nArray) {
        if (theOneWhoShoot == nArray) {
            nArray[3] = nArray[3] >> 1;
            nArray[4] = nArray[4] >> 1;
            if (--shootingPlayerFrameCnt == 0) {
                theOneWhoShoot = null;
            }
            return;
        }
        if ((nArray[6] & 0x1000) == 0) {
            int n2;
            int n3;
            int n4;
            int n5 = nArray[17];
            int n6 = nArray[23];
            int n7 = 0;
            boolean bl = true;
            if (nArray[9] != 0 && nArray == GameLogic.m_controller[nArray[12]].m_controlPlayer && nArray[28] != 10) {
                if (GameLogic.m_controller[nArray[12]].m_controlPlayerMoveTimer >= 0 || GameLogic.m_controller[nArray[12]].m_hcpSprint || (nArray[6] & 0x8000) != 0) {
                    n7 = n5 == 0 ? 0 : ((n5 & 0x200) != 0 ? 360 : 256);
                } else if (TouchscreenController.m_touchTargetMoveSpeed > 0 && GameLogic.m_matchState == 2) {
                    n7 = TouchscreenController.m_touchTargetMoveSpeed;
                } else if (GameLogic.m_controller[nArray[12]].m_microGame.inProgress()) {
                    if (n6 != 0 && n6 < 180) {
                        n7 = 180;
                    } else {
                        bl = false;
                    }
                }
            }
            int n8 = n4 = (n5 & 0x1000) != 0 ? nArray[21] : nArray[22];
            if ((n5 & 0x1F) != 0) {
                if ((n5 & 2) != 0) {
                    nArray[15] = nArray[25];
                    nArray[16] = nArray[26];
                    if (nArray[9] != 0 && GameLogic.m_matchState == 2) {
                        GameAI.formationOffsetPlayerMovePosition(nArray);
                    }
                } else if ((n5 & 4) != 0) {
                    nArray[15] = m_ballStorage[0] + m_ballStorage[3] * 0;
                    nArray[16] = m_ballStorage[1] + m_ballStorage[4] * 0;
                    if (m_ballStorage[2] > 384) {
                        GameLogic.ballCalculateFutureBouncePosition();
                        nArray[15] = GameLogic.m_ballBouncePositionX;
                        nArray[16] = GameLogic.m_ballBouncePositionY;
                    }
                } else if ((n5 & 8) != 0) {
                    nArray[15] = Trajectory.getEndX(0);
                    nArray[16] = Trajectory.getEndY(0);
                } else if ((n5 & 0x10) != 0) {
                    nArray[15] = m_passTargetObject[0];
                    nArray[16] = m_passTargetObject[1];
                }
                n3 = nArray[15] - nArray[0];
                n2 = nArray[16] - nArray[1];
                n4 = DDMath.atan(n3, n2);
                if ((n5 & 0x2000) == 0) {
                    if ((n5 & 0x20) != 0 && nArray[20] > 0) {
                        int n9 = nArray[20];
                        nArray[20] = n9 - 1;
                        int n10 = n9;
                        n5 |= 0x40;
                        int n11 = n3 * n3 + n2 * n2;
                        int n12 = GameAI.playerEstimatePotentialMoveDist(nArray, n4, n10, 256);
                        int n13 = GameAI.playerEstimatePotentialMoveDist(nArray, n4, n10, 180);
                        n7 = n11 > n12 * n12 ? 360 : (n11 > n13 * n13 ? (nArray[28] != 93 ? 256 : 360) : 0);
                    } else {
                        int n14;
                        int n15 = n14 = (n5 & 0x800) != 0 ? 16384 : 65536;
                        if (GameAI.playerMoveTargetReached(nArray, n14)) {
                            bl = false;
                            nArray[0] = nArray[15];
                            nArray[1] = nArray[16];
                            nArray[23] = 0;
                        } else if (!GameAI.playerIsSprinting(nArray) && GameAI.playerMoveTargetReached(nArray, 0x120000)) {
                            n7 = 180;
                            if (nArray[28] == 71) {
                                n7 = 180;
                            }
                        } else {
                            int n16 = n7 = GameAI.playerIsSprinting(nArray) ? 360 : 256;
                            if (nArray[28] == 71) {
                                n7 = 180;
                            }
                        }
                    }
                } else {
                    n7 = nArray[23];
                }
                if ((n5 & 0x40) != 0) {
                    nArray[22] = n4;
                    nArray[21] = n4;
                } else if ((n5 & 0x20) != 0) {
                    nArray[21] = n4;
                } else {
                    nArray[21] = n4;
                    n4 = nArray[22];
                }
            }
            if (bl && nArray[28] != 9 && nArray[28] != 138 && nArray[28] != 139) {
                nArray[23] = GameAI.playerUpdateCurrentSpeed(XMLMenuSystem.getSprintControlType(nArray) == 0, nArray[23], n7, nArray[42]);
            }
            n3 = nArray[23] * GameAI.playerCalculateRunSpeed(nArray) >> 8;
            if (GameLogic.m_matchState != 2) {
                if (n3 != 0 && (n5 & 0x2000) == 0) {
                    n3 = GameLogic.ABSOLUTE_SPEED_RUN_ONTO_PITCH;
                }
            } else {
                if ((n5 & 0x80) != 0) {
                    n2 = 3 * MainFrame.m_inGameFrameRate;
                    n3 = nArray[36] * 256 / n2 + 256;
                } else if ((n5 & 0x400) != 0) {
                    n3 = 393;
                }
                if (nArray[28] == 9) {
                    n3 = n3 * 200 >> 8;
                }
            }
            if ((nArray[6] & 0x10000) != 0) {
                n4 += 128;
            }
            nArray[3] = DDMath.sin(n4 &= 0xFF) * n3 >> 16;
            nArray[4] = DDMath.cos(n4) * n3 >> 16;
        }
    }

    public static final void playerUpdateDirection(int[] nArray) {
        if ((nArray[21] & 0xFF) != (nArray[22] & 0xFF) && nArray[28] != 9 && nArray[28] != 138 && nArray[28] != 139 && nArray[28] != 10 && nArray[28] != 96 && nArray[28] != 90 && nArray[28] != 25 && nArray[28] != 24 && nArray[28] != 0 && nArray[28] != 91 && nArray[28] != 59 && nArray[28] != 12 && nArray[28] != 86) {
            int n2 = DDMath.calcTurnAngle(nArray[22], nArray[21]);
            int n3 = n2 > 0 ? 1 : -1;
            int n4 = nArray[41];
            if ((nArray[17] & 0x200) != 0) {
                n4 >>= 1;
            } else if (nArray[23] < 180) {
                n4 += 32;
            }
            if (n2 < 0) {
                n2 = -n2;
            }
            if (n2 > 128) {
                n2 = 255 - n2;
            }
            if (n2 < n4) {
                n4 = n2;
            } else if (n2 > 50) {
                nArray[23] = DDMath.max(nArray[23] - 12, 64);
            }
            nArray[22] = nArray[22] + n3 * n4;
            nArray[22] = nArray[22] & 0xFF;
        }
    }

    public static final void playerUpdatePosition(int[] nArray) {
        nArray[0] = nArray[0] + nArray[3];
        nArray[1] = nArray[1] + nArray[4];
        nArray[2] = nArray[2] + nArray[5];
        if (nArray[2] > 0) {
            nArray[5] = nArray[5] - GameLogic.GRAVITY_PER_FRAME;
        } else if (nArray[2] < 0) {
            nArray[5] = 0;
            nArray[2] = 0;
        }
    }

    public static final boolean playerHasAbilityToPerformDivingHeader(int[] nArray) {
        return nArray[51] > 45;
    }

    public static final boolean playerHasAbilityToPerformOverHeadKick(int[] nArray) {
        return nArray[51] > 60;
    }

    private static final void playerSetMoveTargetPosition(int[] nArray, int n2, int n3) {
        if ((n2 < 0 || n2 > 24622 || n3 < 0 || n3 > 32015) && GameLogic.m_matchState != 6 && GameLogic.m_matchState != 9 && GameLogic.m_matchState != 5 && GameLogic.m_matchState != 18) {
            return;
        }
        nArray[15] = n2;
        nArray[16] = n3;
    }

    public static final boolean playerMoveTargetReached(int[] nArray) {
        return GameAI.playerMoveTargetReached(nArray, (nArray[17] & 0x800) != 0 ? 16384 : 65536);
    }

    public static final boolean playerMoveTargetReached(int[] nArray, int n2) {
        int n3;
        int n4;
        int n5 = nArray[17];
        return (n5 & 0x100) == 0 && (n4 = nArray[15] - nArray[0]) * n4 + (n3 = nArray[16] - nArray[1]) * n3 <= n2;
    }

    public static final int playerCalculateRunSpeed(int[] nArray) {
        if (GameLogic.m_gameMode == 5) {
            return 93;
        }
        int n2 = nArray[47] >> 2;
        int n3 = nArray[47] - n2;
        return (n3 += nArray[79] * n2 / 25600) * 320 >> 8;
    }

    public static final void playerWaitToReceivePass(int[] nArray) {
        nArray[22] = nArray[21] = nArray[35];
        if (GameAI.teamGetControlType(nArray[12]) == 2) {
            GameAI.ballSetDribbleDirection(nArray[35]);
        } else {
            GameAI.ballSetDribbleDirection(nArray[14]);
        }
        int n2 = DDMath.calcTurnAngle(nArray[35], m_ballStorage[11]);
        int n3 = DDMath.abs(n2);
        nArray[21] = n3 < 64 ? m_ballStorage[11] : nArray[35] + (n2 > 0 ? 64 : -64);
    }

    private static final int playerUpdateCurrentSpeed(boolean bl, int n2, int n3, int n4) {
        int n5 = 45;
        int n6 = 256;
        if (n2 < n3) {
            n2 += n4 * n6 >> 8;
            n2 = DDMath.min(n2, n3);
        } else if (n2 > n3) {
            n2 -= n5;
            n2 = DDMath.max(n2, n3);
        }
        return n2;
    }

    public static final boolean playerIsMoving(int[] nArray) {
        return nArray[3] != 0 || nArray[4] != 0;
    }

    public static final boolean playerIsSprinting(int[] nArray) {
        return (nArray[17] & 0x200) != 0;
    }

    public static final void playerFaceBall(int[] nArray) {
        nArray[21] = nArray[22] = nArray[35];
    }

    public static final boolean playerHasCollidedWithTheBall(int[] nArray) {
        return (nArray[6] & 0x20) != 0;
    }

    public static final void playerStopRunning(int[] nArray) {
        GameAI.objectResetVelocity(nArray);
        nArray[17] = 0;
        nArray[23] = 0;
    }

    public static final void objectSetPosition(int[] nArray, int n2, int n3, int n4) {
        nArray[0] = n2;
        nArray[1] = n3;
        nArray[2] = n4;
    }

    public static final void playerRunToBallPosition(int[] nArray) {
        nArray[17] = nArray[17] | 4;
    }

    public static final void playerRunToMovePosition(int[] nArray) {
        nArray[17] = nArray[17] | 1;
    }

    public static final void playerSprintToMovePosition(int[] nArray) {
        nArray[17] = nArray[17] | 0x201;
    }

    public static final void playerRunToFormationPosition(int[] nArray) {
        nArray[17] = nArray[17] | 2;
        GameAI.playerSetMoveTargetPosition(nArray, nArray[25], nArray[26]);
    }

    public static final void playerSprintToFormationPosition(int[] nArray) {
        nArray[17] = nArray[17] | 0x202;
        GameAI.playerSetMoveTargetPosition(nArray, nArray[25], nArray[26]);
    }

    public static final void playerRunAtSetSpeed(int[] nArray, int n2) {
        nArray[17] = nArray[17] | 0x2000;
        nArray[23] = n2;
    }

    public static final void playerRunUsingPreciseTarget(int[] nArray) {
        nArray[17] = nArray[17] | 0x800;
    }

    public static final boolean playerCheckPotentialRunningShootActions(int[] nArray, int n2) {
        int n3 = DDMath.calcHorizontalDistSquared(nArray, nArray[18], nArray[19]);
        if (GameLogic.isObjectIn18YardBox(nArray, GameAI.teamGetPitchSide(n2 ^ 1)) && n3 < 600000 && !GameAI.checkIfDefensiveHeaderHasJustHappened(nArray)) {
            if (GameAI.playerHasAbilityToPerformDivingHeader(nArray) && m_passTargetObject[2] == 256) {
                if (GameAI.projectedBallCollisionWithSpecifiedAnimation(23, nArray[18], nArray[19], 256)) {
                    GameAI.playerSetState(nArray, 0, 0, 92);
                    GameLogic.m_controller[n2].m_aerialSpecial = false;
                    m_playerRunningOntoBall = null;
                    return true;
                }
            } else if (GameAI.playerHasAbilityToPerformOverHeadKick(nArray) && m_passTargetObject[2] == 486) {
                if (GameAI.projectedBallCollisionWithSpecifiedAnimation(20, nArray[18], nArray[19], 486)) {
                    GameAI.playerSetState(nArray, 0, 0, 96);
                    GameLogic.m_controller[n2].m_aerialSpecial = false;
                    m_playerRunningOntoBall = null;
                    return true;
                }
            } else if (GameAI.projectedBallCollisionWithSpecifiedAnimation(34, nArray[18], nArray[19], 486)) {
                GameAI.playerSetState(nArray, 0, 0, 161);
                GameLogic.m_controller[n2].m_aerialSpecial = false;
                m_playerRunningOntoBall = null;
                return true;
            }
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(21, nArray[18], nArray[19], 128)) {
            GameAI.playerSetState(nArray, 0, 0, 77);
            GameLogic.m_controller[n2].m_aerialSpecial = false;
            GameLogic.m_controller[n2].m_shootBall = false;
            m_playerRunningOntoBall = null;
            return true;
        }
        return false;
    }

    public static final boolean playerCheckPotentialStandingShootActions(int[] nArray, int n2) {
        if (GameLogic.isObjectIn18YardBox(nArray, GameAI.teamGetPitchSide(n2 ^ 1))) {
            if (GameAI.playerHasAbilityToPerformDivingHeader(nArray) && GameAI.projectedBallCollisionWithSpecifiedAnimation(23, nArray[18], nArray[19], 256)) {
                GameAI.playerSetState(nArray, nArray[18], nArray[19], 92);
                GameLogic.m_controller[n2].m_aerialSpecial = false;
                m_playerRunningOntoBall = null;
                return true;
            }
            if (GameAI.playerHasAbilityToPerformOverHeadKick(nArray) && GameAI.projectedBallCollisionWithSpecifiedAnimation(20, nArray[18], nArray[19], 486)) {
                GameAI.playerSetState(nArray, 0, 0, 96);
                GameLogic.m_controller[n2].m_aerialSpecial = false;
                m_playerRunningOntoBall = null;
                return true;
            }
            if (GameAI.projectedBallCollisionWithSpecifiedAnimation(15, nArray[18], nArray[19], 486)) {
                GameAI.playerSetState(nArray, 0, 0, 66);
                GameLogic.m_controller[n2].m_aerialSpecial = false;
                GameLogic.m_controller[n2].m_shootBall = false;
                m_playerRunningOntoBall = null;
                return true;
            }
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(21, nArray[18], nArray[19], 128)) {
            GameAI.playerSetState(nArray, 0, 0, 77);
            GameLogic.m_controller[n2].m_aerialSpecial = false;
            GameLogic.m_controller[n2].m_shootBall = false;
            m_playerRunningOntoBall = null;
            return true;
        }
        return false;
    }

    public static final boolean playerCheckPotentialHeadedClearance(int[] nArray, int n2) {
        if (GameLogic.isDefensiveHeaderAllowed(n2)) {
            boolean bl = false;
            if (GameAI.teamGetControlType(nArray[12]) == 2) {
                bl = true;
                if (!GameLogic.m_controller[n2].m_defensiveHeaderClearance) {
                    return false;
                }
            }
            if (GameAI.projectedBallCollisionWithDefensiveHeaderAnimation(bl, nArray[0], nArray[1], 486)) {
                int n3;
                int[] nArray2 = GameAI.ballGetLastTouchPlayer();
                int n4 = DDMath.calcHorizontalDistSquared(nArray, nArray2);
                if (n4 < (n3 = GameAI.ballIsInAShot() && GameLogic.m_shootingPlayerShotType != 4 ? 10000000 : 6000000)) {
                    return false;
                }
                GameAI.playerSetState(nArray, 0, 0, 194);
                GameLogic.m_controller[n2].m_defensiveHeaderClearance = false;
                GameLogic.m_controller[n2].m_clearBall = false;
                GameLogic.m_controller[n2].m_aerialSpecial = false;
                m_playerRunningOntoBall = null;
                return true;
            }
        }
        return false;
    }

    public static final boolean playerCheckPotentialControlActions(int[] nArray, int n2) {
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(1, nArray[0], nArray[1], 320)) {
            GameAI.playerSetState(nArray, 0, 0, 170);
            if (nArray[9] != 0 && GameLogic.m_controller[n2].m_shootBall && !GameAI.checkIfDefensiveHeaderHasJustHappened(nArray)) {
                nArray[29] = 77;
            }
            return true;
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(82, nArray[0], nArray[1], 486)) {
            GameAI.playerSetState(nArray, 0, 0, 169);
            if (nArray[9] != 0 && GameLogic.m_controller[n2].m_shootBall) {
                nArray[29] = 77;
            }
            return true;
        }
        return false;
    }

    public static final boolean playerCheckPotentialFirstTimePassingActions(int[] nArray, int n2) {
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(15, nArray[0], nArray[1], 638)) {
            GameAI.playerUpdatePassTargetsHeader(nArray);
            GameAI.playerSetState(nArray, 0, 0, 165);
            return true;
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(15, nArray[0], nArray[1], 486)) {
            GameAI.playerUpdatePassTargetsHeader(nArray);
            GameAI.playerSetState(nArray, 0, 0, 165);
            return true;
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(21, nArray[0], nArray[1], 128)) {
            GameAI.playerSetState(nArray, 0, 0, 164);
            return true;
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(17, nArray[0], nArray[1], 0)) {
            GameAI.playerSetState(nArray, 0, 0, 163);
            return true;
        }
        return false;
    }

    public static final boolean playerCheckPotentialClearenceActions(int[] nArray, int n2) {
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(15, nArray[0], nArray[1], 486)) {
            GameAI.playerSetState(nArray, 0, 0, 167);
            GameLogic.m_controller[n2].m_clearBall = false;
            return true;
        }
        if (GameAI.projectedBallCollisionWithSpecifiedAnimation(18, nArray[0], nArray[1], 0)) {
            GameAI.playerSetState(nArray, 0, 0, 166);
            GameLogic.m_controller[n2].m_clearBall = false;
            return true;
        }
        return false;
    }

    public static final boolean isOppositionPlayerCloseAhead(int[] nArray) {
        if (GameLogic.m_gameMode == 2) {
            return false;
        }
        for (int i2 = 1; i2 < 11; ++i2) {
            int[] nArray2 = m_playerStorage[nArray[12] ^ 1][i2];
            if (nArray2[36] << 8 >= 1280 || DDMath.CalcModDifference(nArray[22], nArray2[35] + 128 & 0xFF) >= 21) continue;
            return true;
        }
        return false;
    }

    public static final boolean isPlayerValidCrossingTarget(int[] nArray, int[] nArray2) {
        int n2 = nArray[1] < 16007 ? 0 : 1;
        boolean bl = GameLogic.isObjectIn18YardBox(nArray2, n2);
        int n3 = nArray2[0] < 12311 ? 5632 : 9262;
        int n4 = n2 == 0 ? 1536 : 25103;
        boolean bl2 = DDMath.rectangleContainsPoint(nArray2[0], nArray2[1], n3, n4, 9728, 5376);
        return bl || bl2;
    }

    public static final boolean playerCheckOpenGoal(int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = nArray[12];
        int n7 = GameAI.teamGetPitchSide(n6 ^ 1);
        GameLogic.calculateNearFarGoalPostPositions(n7);
        int n8 = m_ballStorage[0];
        int n9 = m_ballStorage[1];
        if (GameLogic.m_nearGoalPostX < 12311) {
            n5 = GameLogic.m_nearGoalPostX - 640;
            n4 = GameLogic.m_farGoalPostX + 640;
        } else {
            n5 = GameLogic.m_nearGoalPostX + 640;
            n4 = GameLogic.m_farGoalPostX - 640;
        }
        int n10 = DDMath.atan(n5 - n8, GameLogic.m_nearGoalPostY - n9);
        int n11 = DDMath.atan(n4 - n8, GameLogic.m_farGoalPostY - n9);
        int[] nArray2 = m_playerStorage[n6 ^ 1][0];
        int n12 = DDMath.atan(nArray2[0] - n8, nArray2[1] - n9);
        int n13 = n7 == 1 ? 0 : 128;
        if (DDMath.CalcModDifference(n10, n13) > 35) {
            return false;
        }
        if (n7 == 1 && n8 > 12311 || n7 == 0 && n8 < 12311) {
            n3 = n11;
            n2 = n10;
        } else {
            n3 = n10;
            n2 = n11;
        }
        if (n3 > n2 && DDMath.CalcModDifference(n3, n2) > 128) {
            int n14 = n2;
            n2 = n3;
            n3 = n14;
        }
        return !DDMath.angleRangeCheck(n12, n3, n2);
    }

    public static final boolean playerCheckIfHumanDoingOpenGoalCheat(int[] nArray, int[] nArray2) {
        int n2 = m_ballStorage[1] < 16007 ? m_ballStorage[1] : 32015 - m_ballStorage[1];
        return GameAI.teamGetControlType(nArray[12]) == 2 && !GameAI.shootPositionallyBeatenKeeperGoalDistance(nArray, nArray2, 325) && n2 > 2304 && DDMath.getRandom(0, 100) < 70;
    }

    public static final void playerSyncAnimationToBallPosition(int[] nArray, int n2, int n3) {
        int n4 = GameRender.animationGetFramesUntilAction(nArray[60]);
        GameLogic.ballCalculateFutureBallPosition(n4);
        n4 = DDMath.max(n4, 1);
        int n5 = GameLogic.m_futureBallObject[0] - (DDMath.sin(nArray[22]) * n2 >> 16);
        int n6 = GameLogic.m_futureBallObject[1] - (DDMath.cos(nArray[22]) * n2 >> 16);
        int n7 = GameLogic.m_futureBallObject[2];
        nArray[3] = (n5 - nArray[0]) / n4;
        nArray[4] = (n6 - nArray[1]) / n4;
        if (n7 - n3 > 0) {
            nArray[5] = (n7 - n3) / n4;
            nArray[5] = nArray[5] + n4 * GameLogic.GRAVITY_PER_FRAME / 2;
        }
        nArray[6] = nArray[6] | 0x1000;
        int n8 = 1536 / MainFrame.m_inGameFrameRate;
        nArray[3] = DDMath.min(nArray[3], n8);
        nArray[4] = DDMath.min(nArray[4], n8);
        nArray[5] = DDMath.min(nArray[5], n8);
        nArray[3] = DDMath.max(nArray[3], -n8);
        nArray[4] = DDMath.max(nArray[4], -n8);
        nArray[5] = DDMath.max(nArray[5], -n8);
    }

    public static final int[] playerGetMarkTarget(int[] nArray) {
        if (nArray[54] > 0 && nArray[54] < 11) {
            return m_playerStorage[nArray[12] ^ 1][nArray[54]];
        }
        return null;
    }

    private static final int keeperInterceptCross(int n2, boolean bl) {
        int n3 = 224;
        GameAI.m_ballStorage[6] = 0;
        m_ballStorage[6] = m_ballStorage[6] | 0x1000;
        int[] nArray = m_playerStorage[n2][0];
        int n4 = nArray[14] + DDMath.getRandom() % 32 & 0xFF;
        int n5 = 772 + DDMath.getPositiveRandom() % 1544;
        int n6 = DDMath.sin(n4) * n5 >> 16;
        int n7 = DDMath.cos(n4) * n5 >> 16;
        int n8 = nArray[0] + n6;
        if (n8 < 6641) {
            n8 = 6641;
        } else if (n8 > 17981) {
            n8 = 17981;
        }
        int n9 = nArray[1] + n7;
        if (nArray[14] == 0) {
            if (n9 < 0) {
                n9 = 0;
            } else if (n9 > 4633) {
                n9 = 4633;
            }
        } else if (n9 > 32015) {
            n9 = 32015;
        } else if (n9 < 27382) {
            n9 = 27382;
        }
        GameAI.playerSetState(nArray, n8, n9, 124);
        if (bl) {
            nArray[29] = 125;
        } else {
            boolean bl2 = true;
            for (int i2 = 10; i2 > 0; --i2) {
                int n10 = m_playerStorage[n2 ^ 1][i2][0] - n8;
                int n11 = m_playerStorage[n2 ^ 1][i2][1] - n9;
                if (n10 * n10 + n11 * n11 >= 2380849) continue;
                bl2 = false;
                break;
            }
            nArray[29] = bl2 ? 125 : 126;
        }
        GameLogic.m_setPieceTargetObject[0] = n8;
        GameLogic.m_setPieceTargetObject[1] = n9;
        return n3;
    }

    private static final void dribbleBall(int[] nArray, int n2) {
        int n3 = nArray[12];
        GameAI.m_ballStorage[3] = 0;
        GameAI.m_ballStorage[4] = 0;
        if (GameAI.teamGetControlType(n3) == 2 && GameLogic.m_controller[n3].m_microGame.inProgress()) {
            GameAI.m_ballStorage[3] = nArray[3];
            GameAI.m_ballStorage[4] = nArray[4];
        }
        int n4 = nArray[7] + m_ballStorage[7] / 2;
        if (GameAI.playerIsSprinting(nArray) && (nArray[59] == 2 * (MainFrame.m_inGameFrameRate / 12) || nArray[59] == 6 * (MainFrame.m_inGameFrameRate / 12))) {
            int n5;
            int n6 = 256;
            int n7 = GameLogic.m_friction;
            int n8 = 4;
            for (n5 = 0; n5 < n8 - 1; ++n5) {
                n6 += n7;
                n7 = n7 * GameLogic.m_friction >> 8;
            }
            n5 = (255 * n8 << 8) / n6;
            GameAI.m_ballStorage[3] = nArray[3] * n5 >> 8;
            GameAI.m_ballStorage[4] = nArray[4] * n5 >> 8;
        }
        GameAI.m_ballStorage[0] = nArray[0] + (DDMath.sin(n2) * n4 >> 16);
        GameAI.m_ballStorage[1] = nArray[1] + (DDMath.cos(n2) * n4 >> 16);
        GameAI.m_ballStorage[5] = DDMath.min(m_ballStorage[5], 0);
    }

    public static final void kickBallForwards(int[] nArray) {
        GameAI.m_ballStorage[6] = 0;
        GameAI.m_ballStorage[3] = DDMath.sin(nArray[22]) * GameLogic.PLAYER_KICK_BALL_FORWARDS_BALL_SPEED >> 16;
        GameAI.m_ballStorage[4] = DDMath.cos(nArray[22]) * GameLogic.PLAYER_KICK_BALL_FORWARDS_BALL_SPEED >> 16;
        GameAI.m_ballStorage[5] = 0;
        GameLogic.m_controller[nArray[12]].m_shootBall = false;
        GameLogic.m_controller[nArray[12]].m_clearBall = false;
        GameLogic.m_controller[nArray[12]].m_kickBallForwards = false;
        m_playerWithBall = null;
        GameLogic.m_beAProPassPlayed = GameLogic.beAProIsPlayerBAPPlayer(nArray);
    }

    public static final void ballSetLastTouchPlayer(int[] nArray) {
        GameLogic.refereeCheckOffside(nArray);
        GameLogic.m_possession = nArray[12];
        GameAI.m_ballStorage[10] = nArray[9] << 1 | nArray[12];
    }

    public static final int[] ballGetLastTouchPlayer() {
        return m_playerStorage[m_ballStorage[10] & 1][m_ballStorage[10] >> 1];
    }

    public static final int ballGetLastTouchPlayerID() {
        return m_ballStorage[10] >> 1;
    }

    public static final int ballGetLastTouchPlayerTeam() {
        return m_ballStorage[10] & 1;
    }

    public static final void ballSetCollision(boolean bl) {
        if (bl) {
            DDDebug.msg("SW: ball Set collision ON:");
            m_ballStorage[6] = m_ballStorage[6] & 0xFFFFFF7F;
        } else {
            DDDebug.msg("SW: ball Set Collision OFF:");
            m_ballStorage[6] = m_ballStorage[6] | 0x80;
        }
    }

    public static final void ballSetDribbleDirection(int n2) {
        GameAI.m_ballStorage[11] = n2;
    }

    public static final void ballSetDrawnWithinFrame(int[] nArray, boolean bl) {
        if (bl) {
            nArray[6] = nArray[6] | 0x100;
            m_ballStorage[6] = m_ballStorage[6] | 0x2080;
        } else {
            nArray[6] = nArray[6] & 0xFFFFFEFF;
            m_ballStorage[6] = m_ballStorage[6] & 0xFFFFDF7F;
        }
    }

    public static final void ballSetToFreeBall() {
        m_ballStorage[6] = m_ballStorage[6] & 0x40;
    }

    public static final void ballClearAllPassFlags() {
        m_ballStorage[6] = m_ballStorage[6] & 0xFFFFFEF3;
    }

    public static final boolean ballIsInAPass() {
        return (m_ballStorage[6] & 4) != 0;
    }

    public static final boolean ballIsInACross() {
        return GameAI.ballIsInAPass() && (m_ballStorage[6] & 8) != 0;
    }

    public static final boolean ballIsInAGroundPass() {
        return GameAI.ballIsInAPass() && (m_ballStorage[6] & 0x100) != 0;
    }

    public static final boolean ballIsInAHighPass() {
        return GameAI.ballIsInAPass() && !GameAI.ballIsInAGroundPass();
    }

    public static final boolean ballIsInAShot() {
        return (m_ballStorage[6] & 0x10) != 0;
    }

    public static final boolean ballIsInTheGoal() {
        return (m_ballStorage[6] & 0x40) != 0;
    }

    public static final void ballSetAtPlayersFeet(int[] nArray) {
        int n2 = 319;
        int n3 = nArray[22];
        if (GameAI.playerIsSprinting(nArray)) {
            n2 <<= 1;
        }
        GameAI.m_ballStorage[0] = nArray[0] + (DDMath.sin(n3) * n2 >> 16);
        GameAI.m_ballStorage[1] = nArray[1] + (DDMath.cos(n3) * n2 >> 16);
        GameAI.m_ballStorage[2] = 0;
    }

    public static final void ballSetHorizontalSpeed(int n2, int n3) {
        GameAI.m_ballStorage[3] = DDMath.sin(n2) * n3 >> 16;
        GameAI.m_ballStorage[4] = DDMath.cos(n2) * n3 >> 16;
    }

    public static final boolean ballIsCloseEnoughToPlayerForAssumedCollision(int[] nArray) {
        if (!GameAI.ballIsInTheGoal() && GameLogic.m_matchState != 3 && GameLogic.m_matchState != 1 && (nArray[9] == 0 || (m_ballStorage[6] & 0x80) == 0 && !GameAI.keeperGrabbedBall())) {
            int n2 = DDMath.calcHorizontalDistSquared(m_ballStorage, nArray);
            if (nArray[9] == 0) {
                boolean bl;
                boolean bl2 = bl = GameAI.ballIsInAShot() && (nArray[28] == 50 || nArray[28] == 189 || nArray[28] == 54 || nArray[28] == 112 || nArray[28] == 113 || nArray[28] == 28 || nArray[28] == 39 || nArray[28] == 46 || nArray[28] == 47 || nArray[28] == 40 || nArray[28] == 44);
                if (bl) {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int[] nArray2;
                    int n10 = m_ballStorage[0];
                    int n11 = m_ballStorage[1];
                    int n12 = m_ballStorage[2];
                    int n13 = nArray[0];
                    int n14 = nArray[1];
                    int n15 = nArray[2];
                    if (Trajectory.isBallUnderTrajectoryControl()) {
                        nArray2 = Trajectory.m_trajectoryParams[0];
                        n9 = nArray2[7] + 1;
                        n8 = nArray2[8];
                        n7 = m_ballStorage[0];
                        n6 = m_ballStorage[1];
                        if (n9 < n8) {
                            n10 = nArray2[0] + nArray2[3] * n9 / n8 + ((nArray2[9] << 8) / (n8 * n8) * (n9 * n9) >> 8);
                            n11 = nArray2[1] + nArray2[4] * n9 / n8 + ((nArray2[10] << 8) / (n8 * n8) * (n9 * n9) >> 8);
                            n5 = -3278 * n9 / (2 * MainFrame.m_inGameFrameRate);
                            n4 = nArray2[6] + n5;
                            n3 = n4 * n9 / MainFrame.m_inGameFrameRate;
                            n12 = nArray2[2] + n3;
                        } else {
                            n10 = nArray2[0] + nArray2[3] + nArray2[9];
                            n11 = nArray2[1] + nArray2[4] + nArray2[10];
                            n12 = nArray2[2] + nArray2[5];
                        }
                    } else {
                        n10 += m_ballStorage[3];
                        n11 += m_ballStorage[4];
                        n12 += m_ballStorage[5];
                    }
                    if (Trajectory.isObjectUnderTrajectoryControl(nArray)) {
                        nArray2 = Trajectory.m_trajectoryParams[1];
                        n9 = nArray2[7] + 1;
                        n8 = nArray2[8];
                        n7 = nArray[0];
                        n6 = nArray[1];
                        if (n9 < n8) {
                            n13 = nArray2[0] + nArray2[3] * n9 / n8 + ((nArray2[9] << 8) / (n8 * n8) * (n9 * n9) >> 8);
                            n14 = nArray2[1] + nArray2[4] * n9 / n8 + ((nArray2[10] << 8) / (n8 * n8) * (n9 * n9) >> 8);
                            n5 = -3278 * n9 / (2 * MainFrame.m_inGameFrameRate);
                            n4 = nArray2[6] + n5;
                            n3 = n4 * n9 / MainFrame.m_inGameFrameRate;
                            n15 = nArray2[2] + n3;
                        } else {
                            n13 = nArray2[0] + nArray2[3] + nArray2[9];
                            n14 = nArray2[1] + nArray2[4] + nArray2[10];
                            n15 = nArray2[2] + nArray2[5];
                        }
                    }
                    n12 -= n15;
                    return n2 <= (n10 -= n13) * n10 + (n11 -= n14) * n11 && DDMath.abs(m_ballStorage[2] - nArray[2]) < 690;
                }
            }
            return n2 < 287296 && DDMath.abs(m_ballStorage[2] - nArray[2]) < 690;
        }
        return false;
    }

    public static final boolean ballIsCloseEnoughToPlayerForAssumedCollision(int[] nArray, int n2, int n3, int n4) {
        if (GameLogic.m_matchState != 3 && GameLogic.m_matchState != 1 && (nArray[9] == 0 || (m_ballStorage[6] & 0x80) == 0 && !GameAI.keeperGrabbedBall())) {
            int n5 = DDMath.calcHorizontalDistSquared(m_ballStorage, nArray);
            if (nArray[9] == 0) {
                boolean bl;
                boolean bl2 = bl = nArray[28] == 50 || nArray[28] == 189 || nArray[28] == 54 || nArray[28] == 112 || nArray[28] == 113 || nArray[28] == 28 || nArray[28] == 39 || nArray[28] == 46 || nArray[28] == 47 || nArray[28] == 40 || nArray[28] == 44;
                if (bl) {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int[] nArray2;
                    int n13 = m_ballStorage[0];
                    int n14 = m_ballStorage[1];
                    int n15 = m_ballStorage[2];
                    int n16 = nArray[0];
                    int n17 = nArray[1];
                    int n18 = nArray[2];
                    if (Trajectory.isBallUnderTrajectoryControl()) {
                        nArray2 = Trajectory.m_trajectoryParams[0];
                        n12 = nArray2[7] + 1;
                        n11 = nArray2[8];
                        n10 = m_ballStorage[0];
                        n9 = m_ballStorage[1];
                        if (n12 < n11) {
                            n13 = nArray2[0] + nArray2[3] * n12 / n11 + ((nArray2[9] << 8) / (n11 * n11) * (n12 * n12) >> 8);
                            n14 = nArray2[1] + nArray2[4] * n12 / n11 + ((nArray2[10] << 8) / (n11 * n11) * (n12 * n12) >> 8);
                            n8 = -3278 * n12 / (2 * MainFrame.m_inGameFrameRate);
                            n7 = nArray2[6] + n8;
                            n6 = n7 * n12 / MainFrame.m_inGameFrameRate;
                            n15 = nArray2[2] + n6;
                        } else {
                            n13 = nArray2[0] + nArray2[3] + nArray2[9];
                            n14 = nArray2[1] + nArray2[4] + nArray2[10];
                            n15 = nArray2[2] + nArray2[5];
                        }
                    } else {
                        n13 += m_ballStorage[3];
                        n14 += m_ballStorage[4];
                        n15 += m_ballStorage[5];
                    }
                    if (Trajectory.isObjectUnderTrajectoryControl(nArray)) {
                        nArray2 = Trajectory.m_trajectoryParams[1];
                        n12 = nArray2[7] + 1;
                        n11 = nArray2[8];
                        n10 = nArray[0];
                        n9 = nArray[1];
                        if (n12 < n11) {
                            n16 = nArray2[0] + nArray2[3] * n12 / n11 + ((nArray2[9] << 8) / (n11 * n11) * (n12 * n12) >> 8);
                            n17 = nArray2[1] + nArray2[4] * n12 / n11 + ((nArray2[10] << 8) / (n11 * n11) * (n12 * n12) >> 8);
                            n8 = -3278 * n12 / (2 * MainFrame.m_inGameFrameRate);
                            n7 = nArray2[6] + n8;
                            n6 = n7 * n12 / MainFrame.m_inGameFrameRate;
                            n18 = nArray2[2] + n6;
                        } else {
                            n16 = nArray2[0] + nArray2[3] + nArray2[9];
                            n17 = nArray2[1] + nArray2[4] + nArray2[10];
                            n18 = nArray2[2] + nArray2[5];
                        }
                    }
                    n15 -= n18;
                    return DDMath.calcHorizontalDistSquared(m_ballStorage, n2, n3) <= (n13 -= n16) * n13 + (n14 -= n17) * n14 && DDMath.abs(m_ballStorage[2] - n4) < 690;
                }
            }
            return DDMath.calcHorizontalDistSquared(m_ballStorage, n2, n3) < 287296 && DDMath.abs(m_ballStorage[2] - n4) < 690;
        }
        return false;
    }

    public static final boolean ballIsCloseEnoughToDefensiveHeaderForAssumedCollision(int[] nArray, int n2, int n3, int n4) {
        if (GameLogic.m_matchState != 3 && GameLogic.m_matchState != 1 && (m_ballStorage[6] & 0x80) == 0) {
            int n5 = GameAI.teamGetControlType(nArray[12]) == 0 ? GameLogic.m_difficultySettingDefensiveHeaderMinBallHeight : GameLogic.m_difficultySettingDefensiveHeaderMinBallHeightHuman;
            int n6 = nArray[2] + 580;
            return DDMath.calcHorizontalDistSquared(m_ballStorage, n2, n3) < 287296 && m_ballStorage[2] < n6 && m_ballStorage[2] > (n5 += nArray[2]);
        }
        return false;
    }

    public static final boolean ballIsPossessed() {
        return (m_ballStorage[6] & 0x20) != 0;
    }

    public static final boolean ballWasPossessedLastFrame() {
        return (m_ballStorage[6] & 0x4000) != 0;
    }

    public static final boolean ObjectIsStationary(int[] nArray) {
        return nArray[3] == 0 && nArray[4] == 0 && nArray[5] == 0;
    }

    public static final int ballGetSpeed() {
        int n2 = DDMath.sqrtRout(m_ballStorage[3] * m_ballStorage[3] + m_ballStorage[4] * m_ballStorage[4]);
        n2 = DDMath.max(n2, 1);
        return n2;
    }

    public static final int ballCurrentDirection() {
        return DDMath.atan(m_ballStorage[3], m_ballStorage[4]);
    }

    public static final boolean ballIsDeflectedEnoughToCountAsAShotCollision(int[] nArray) {
        DDMath.m_vertices[0][0] = m_ballStorage[0];
        DDMath.m_vertices[0][1] = m_ballStorage[1];
        DDMath.m_vertices[1][0] = m_shotTargetObject[0];
        DDMath.m_vertices[1][1] = m_shotTargetObject[1];
        DDMath.m_vertices[2][0] = nArray[0] - 230;
        DDMath.m_vertices[2][1] = nArray[1];
        DDMath.m_vertices[3][0] = nArray[0] + 230;
        DDMath.m_vertices[3][1] = nArray[1];
        boolean bl = false;
        if (DDMath.intersection(0)) {
            bl = true;
        }
        if (!bl) {
            DDMath.m_vertices[2][0] = nArray[0];
            DDMath.m_vertices[2][1] = nArray[1] - 230;
            DDMath.m_vertices[3][0] = nArray[0];
            DDMath.m_vertices[3][1] = nArray[1] + 230;
            if (DDMath.intersection(0)) {
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean ballIsHeadingTowardsTheGoal(int[] nArray) {
        DDMath.m_vertices[0][0] = m_ballStorage[0];
        DDMath.m_vertices[0][1] = m_ballStorage[1];
        DDMath.m_vertices[1][0] = m_ballStorage[0] + m_ballStorage[3] * GameLogic.LOOSE_BALL_PREDICTION_FRAMES;
        DDMath.m_vertices[1][1] = m_ballStorage[1] + m_ballStorage[4] * GameLogic.LOOSE_BALL_PREDICTION_FRAMES;
        int n2 = nArray[1] < 16007 ? 0 : 32015;
        DDMath.m_vertices[2][0] = 6641;
        DDMath.m_vertices[2][1] = n2;
        DDMath.m_vertices[3][0] = 17981;
        DDMath.m_vertices[3][1] = n2;
        return DDMath.intersection(0);
    }

    public static final void teamSetPossession(int[] nArray, short[] sArray, int n2) {
        GameLogic.refereeCheckOffside(nArray);
        m_playerWithBall = null;
        boolean bl = GameLogic.m_possession != n2;
        GameAI.m_teamStorage[0][1] = 0;
        GameAI.m_teamStorage[1][1] = 0;
        GameAI.m_teamStorage[0][20] = 0;
        GameAI.m_teamStorage[1][20] = 0;
        int n3 = GameAI.ballGetLastTouchPlayerTeam();
        int n4 = GameAI.ballGetLastTouchPlayerID();
        int[] nArray2 = GameAI.ballGetLastTouchPlayer();
        int n5 = nArray2[28];
        if (bl) {
            GameAI.teamSetPossessionTeamChange(nArray2, nArray);
            XMLMenuSystem.tutorialSetPossessionTeamChange(nArray2, nArray);
            GameLogic.beAProCheckIfBAPStatAchieved(13, nArray2, null);
        } else {
            GameLogic.beAProCheckIfBAPStatAchieved(3, null, nArray);
        }
        if (nArray2 != nArray) {
            GameAI.teamSetPossessionPlayerChange(nArray2, nArray);
            if (GameLogic.m_gameMode == 2) {
                XMLMenuSystem.tutorialSetPossessionPlayerChange(nArray2, nArray);
            }
        }
        if (GameLogic.m_controller[n2].m_microGame.inProgress() && GameLogic.m_controller[n2].m_microGame.m_type == 0) {
            GameLogic.m_controller[n2].m_microGame.cancelMicroGame();
        }
        if (n5 == 9 || n5 == 38 || n5 == 191 || n5 == 190) {
            if (n2 == GameLogic.m_possession) {
                GameAI.playerSetState(nArray2, 0, 0, 0);
            } else if (n5 != 91) {
                GameAI.playerSetState(nArray2, 0, 0, 14);
                if (GameAI.teamGetControlType(n3) == 2 && nArray2 == GameLogic.m_controller[n3].m_controlPlayer) {
                    GameLogic.m_controller[n3].setControlPlayer(null);
                }
            }
        }
        if (nArray[28] == 9 || nArray[28] == 34 || nArray[28] == 10) {
            GameAI.objectCopyValues(nArray, m_ballStorage, 3, 2);
            m_ballStorage[3] = m_ballStorage[3] >> 1;
            m_ballStorage[4] = m_ballStorage[4] >> 1;
            m_ballStorage[5] = m_ballStorage[5] >> 1;
        } else if (nArray[9] != 0 && nArray[28] != 91) {
            GameAI.m_ballStorage[0] = nArray[0] + (DDMath.sin(nArray[22]) * 217 >> 16);
            GameAI.m_ballStorage[1] = nArray[1] + (DDMath.cos(nArray[22]) * 217 >> 16);
            GameAI.m_ballStorage[5] = DDMath.min(m_ballStorage[5], 0);
        }
        GameAI.ballSetToFreeBall();
        m_ballStorage[6] = m_ballStorage[6] | 0x20;
        GameLogic.m_possession = n2;
        GameAI.ballSetLastTouchPlayer(nArray);
        if (nArray[9] != 0 && (nArray[30] == 0 || nArray[28] == 69) && nArray[28] != 96 && nArray[28] != 77 && nArray[28] != 166 && nArray[28] != 169 && nArray[28] != 70 && m_ballStorage[2] < 384) {
            DDDebug.msg("ONE_TWO_PASSING: Is passballandrun set???");
            if (GameLogic.m_controller[n2].m_returningOneTwoPassPlayer == nArray) {
                DDDebug.msg("ONE_TWO_PASSING: m_returningOneTwoPassPlayer is this player. So return the ball to the previous player");
                nArray[32] = n4;
                GameLogic.m_controller[n2].initPass(0, nArray);
                DDDebug.msg("ONE_TWO_PASSING: set returning one-two pass");
            } else {
                GameLogic.m_controller[n2].m_returningOneTwoPassPlayer = null;
            }
            if (GameAI.playersFacingEachOther(nArray, nArray2) && DDMath.calcHorizontalDistSquared(nArray, nArray2) < 262144) {
                GameAI.Clearance(nArray, n2, 4);
                GameAI.playerSetState(nArray, 0, 0, 154);
                nArray[30] = 2;
                nArray[29] = 34;
                GameAI.playerSetState(nArray2, 0, 0, 14);
            } else {
                GameAI.playerSetState(nArray, 0, 0, 9);
                if (nArray == m_playerRunningOntoBall && m_runOntoBallTimer > 0) {
                    DDDebug.msg("TEAM SET POSSESSION: trigger player action ");
                    GameAI.playerTriggerBallAction(nArray, n2, nArray[22]);
                }
            }
        }
        if (GameLogic.m_gameMode == 4 && bl) {
            GameLogic.m_gameModeResetTimer = 20;
        } else if (GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4) {
            GameLogic.penaltyShootOutUpdateScores(false);
        }
    }

    public static final void teamSetPossessionTeamChange(int[] nArray, int[] nArray2) {
        DDDebug.msg("TEAM SET POSSESSION: team change");
        GameLogic.m_controller[nArray2[12]].resetDefensiveActions();
        GameLogic.m_controller[nArray[12]].resetAttackingActions();
        GameLogic.m_controller[nArray2[12]].resetThroughBallTargets();
        GameLogic.m_controller[nArray[12]].resetThroughBallTargets();
        GameLogic.m_controller[nArray2[12]].m_microGame.cancelMicroGame();
        GameLogic.m_controller[nArray[12]].m_microGame.cancelMicroGame();
        if ((m_teamStorage[nArray2[12]][0] & 2) == 0) {
            AIController cfr_ignored_0 = (AIController)GameLogic.m_controller[nArray2[12]];
            AIController.setAIState(nArray2, 0);
        }
        m_playerRunningOntoBall = null;
        GameLogic.refereeUpdateOffsidePlayerFlags(true);
    }

    public static final void teamSetPossessionPlayerChange(int[] nArray, int[] nArray2) {
        DDDebug.msg("TEAM SET POSSESSION: player change");
        if (nArray[12] != nArray2[12] || GameLogic.m_controller[nArray2[12]].m_microGame.m_type != 1) {
            GameLogic.m_controller[nArray2[12]].m_microGame.cancelMicroGame();
        }
        GameLogic.m_controller[nArray2[12]].m_180turn = false;
        if (GameLogic.m_controller[nArray2[12]].m_returningOneTwoPassPlayer != nArray2) {
            GameLogic.m_controller[nArray2[12]].m_returningOneTwoPassPlayer = null;
        }
    }

    public static final void teamSetState(int n2, int n3) {
        block7: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    if (n3 == 2) break block7;
                                    if (n3 != 7) break block8;
                                    int n4 = GameLogic.m_matchState == 4 ? 11 : 4;
                                    for (int i2 = 1; i2 < n4; ++i2) {
                                        if ((m_playerStorage[n2][i2][6] & 0x40000) != 0) continue;
                                        GameAI.playerSetState(m_playerStorage[n2][i2], 0, 0, 74);
                                    }
                                    break block7;
                                }
                                if (n3 != 1) break block9;
                                GameAI.objectResetVelocity(m_ballStorage);
                                GameFormation.setKickOffPositions();
                                for (int i3 = 0; i3 < 11; ++i3) {
                                    GameAI.playerSetState(m_playerStorage[n2][i3], m_playerStorage[n2][i3][25], m_playerStorage[n2][i3][26], 71);
                                }
                                break block7;
                            }
                            if (n3 != 8) break block10;
                            GameAI.objectResetVelocity(m_ballStorage);
                            GameFormation.updateLevel1();
                            for (int i4 = 1; i4 < 11; ++i4) {
                                GameAI.playerSetState(m_playerStorage[n2][i4], m_playerStorage[n2][i4][25], m_playerStorage[n2][i4][26], 71);
                            }
                            break block7;
                        }
                        if (n3 != 4) break block11;
                        int n5 = 0;
                        int n6 = 0;
                        while (n5 < 11) {
                            GameAI.m_playerStorage[n2][n5][0] = 2048 - n6 + n2 * 128;
                            GameAI.m_playerStorage[n2][n5][1] = 16007 + DDMath.getPositiveRandom() % 372 * (GameAI.teamGetPitchSide(n2) == 1 ? 1 : -1);
                            GameAI.m_playerStorage[n2][n5][21] = 64;
                            GameAI.m_playerStorage[n2][n5][22] = 64;
                            GameAI.playerSetState(m_playerStorage[n2][n5], 12311, 16007 + DDMath.getPositiveRandom() % 750 * (GameAI.teamGetPitchSide(n2) == 1 ? 2 : -2), 3);
                            ++n5;
                            n6 += 716;
                        }
                        break block7;
                    }
                    if (n3 != 6) break block12;
                    for (int i5 = 0; i5 < 11; ++i5) {
                        GameAI.playerSetState(m_playerStorage[n2][i5], 0, 16007, 73);
                    }
                    break block7;
                }
                if (n3 != 5) break block13;
                for (int i6 = 0; i6 < 11; ++i6) {
                    int[] nArray = m_playerStorage[n2][i6];
                    nArray[0] = nArray[25];
                    nArray[1] = nArray[26];
                    GameAI.playerSetState(nArray, 0, 0, 0);
                }
                break block7;
            }
            if (n3 != 0) break block7;
            for (int i7 = 0; i7 < 11; ++i7) {
                GameAI.playerSetState(m_playerStorage[n2][i7], 0, 0, 0);
            }
        }
    }

    public static final int[] teamFindSetPeiceTaker(int n2, int n3) {
        int[] nArray = m_playerStorage[n3][m_setPieceTakers[n2]];
        if (nArray[49] != 2) {
            return nArray;
        }
        for (int i2 = 10; i2 > 0; --i2) {
            nArray = m_playerStorage[n3][i2];
            if (nArray[49] == 2) continue;
            return nArray;
        }
        return null;
    }

    public static final int[] teamFindPlayerInState(int n2, int n3) {
        for (int i2 = 0; i2 < 11; ++i2) {
            int[] nArray = m_playerStorage[n2][i2];
            if (nArray[28] != n3) continue;
            return nArray;
        }
        return null;
    }

    public static final int teamGetPitchSide(int n2) {
        return m_teamStorage[n2][0] & 1;
    }

    public static final void teamSetPitchSide(int n2, int n3) {
        short[] sArray = m_teamStorage[n2];
        sArray[0] = (short)(sArray[0] & 0xFFFFFFFE);
        short[] sArray2 = m_teamStorage[n2];
        sArray2[0] = (short)(sArray2[0] | n3);
    }

    public static final int teamGetControlType(int n2) {
        return m_teamStorage[n2][0] & 2;
    }

    public static final void teamSetControlType(int n2, int n3) {
        short[] sArray = m_teamStorage[n2];
        sArray[0] = (short)(sArray[0] & 0xFFFFFFFD);
        short[] sArray2 = m_teamStorage[n2];
        sArray2[0] = (short)(sArray2[0] | n3);
    }

    public static final void keepPositionWithinPitch(int[] nArray) {
        nArray[0] = DDMath.max(nArray[0], 0);
        nArray[0] = DDMath.min(nArray[0], 24622);
        nArray[1] = DDMath.max(nArray[1], 0);
        nArray[1] = DDMath.min(nArray[1], 32015);
    }

    public static final void keepTargetPositionWithinPitch(int[] nArray) {
        nArray[15] = DDMath.max(nArray[15], 512);
        nArray[15] = DDMath.min(nArray[15], 24110);
        nArray[16] = DDMath.max(nArray[16], 512);
        nArray[16] = DDMath.min(nArray[16], 31503);
    }

    private static final int chooseHeaderVolleyOrOverheadKick(int[] nArray) {
        int n2 = 0;
        int n3 = DDMath.getPositiveRandom() % 100;
        if (GameLogic.isObjectIn18YardBox(nArray, GameAI.teamGetPitchSide(nArray[12] ^ 1))) {
            n2 = n3 < 20 ? 16384 : (n3 < 30 ? 2048 : (n3 < 50 ? 512 : 1024));
        } else if (n3 >= 70) {
            n2 = 512;
        }
        return n2;
    }

    public static final void objectResetVelocity(int[] nArray) {
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
    }

    public static final void objectCopyValues(int[] nArray, int[] nArray2, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray2[n2 + i2] = nArray[n2 + i2];
        }
    }

    public static final void AnimatePass(int[] nArray, int[] nArray2, int n2, int n3) {
        GameLogic.m_matchNextState = n3;
        m_animationPassTarget = nArray2;
        m_animationPassFlags = n2;
        if ((n2 & 0x20) != 0) {
            m_ballStorage[6] = m_ballStorage[6] | 8;
        }
        if ((n2 & 1) == 0) {
            GameAI.playerSetState(nArray, 0, 0, 191);
        } else {
            GameAI.playerSetState(nArray, 0, 0, 190);
        }
        nArray[30] = GameRender.animationGetDuration(nArray[60]);
    }

    public static final void AnimateShot(int[] nArray) {
        GameAI.playerSetState(nArray, 0, 0, 38);
        if (GameAI.teamGetControlType(nArray[12]) == 2) {
            GameLogic.m_controller[nArray[12]].setControlPlayer(null);
        }
        nArray[30] = GameRender.animationGetDuration(nArray[60]);
    }

    private static final int autoSprintCalcDribbleSprintDelay(int[] nArray) {
        int n2 = nArray[42];
        n2 = DDMath.min(n2, 18);
        n2 = DDMath.max(n2, 10);
        n2 = 18 - n2;
        int n3 = n2 * 100 / 8;
        int n4 = n3 * MainFrame.m_inGameFrameRate / 100;
        int n5 = MainFrame.m_inGameFrameRate + n4;
        return n5;
    }

    public static int shootCalculateShotType(int[] nArray, int n2, int n3) {
        int n4 = 0;
        m_shootLastIdealShotType = n3;
        if (debugShotTypeCheatOn) {
            debugshottype = 8;
            n4 = debugshottype << 2 | 0;
        } else {
            if (n3 != 3) {
                GameLogic.m_useGKDivePosition = false;
            }
            switch (n3) {
                case 3: {
                    n4 = GameAI.shootCalculateShotTypeTargeted(nArray, n2);
                    break;
                }
                case 0: {
                    n4 = GameAI.shootCalculateShotTypeMicroGame(nArray, n2);
                    break;
                }
                case 2: {
                    n4 = GameAI.shootCalculateShotTypeSideFooted(nArray, n2);
                    break;
                }
                case 1: {
                    n4 = GameAI.shootCalculateShotTypeLobShot(nArray, n2);
                    break;
                }
                case 4: {
                    n4 = GameAI.shootCalculateShotTypeHeader(nArray, n2);
                    if (n2 != GameLogic.getPlayerTeam() || !GameLogic.beAProIsPlayerBAPPlayer(nArray) || XMLMenuSystem.isTrophyAcquired(13) || XMLMenuSystem.m_menuSeasonType != 2 || nArray[28] != 92 && GameLogic.m_shootingPlayerShotType != 4 || !GameAI.shootCheckIfBeatsKeeper(n4 >> 2)) break;
                    XMLMenuSystem.addTrophyInGame(13);
                    break;
                }
                case 5: {
                    n4 = GameAI.shootCalculateShotTypeVolley(nArray, n2);
                    if (n2 != GameLogic.getPlayerTeam() || !GameLogic.beAProIsPlayerBAPPlayer(nArray) || XMLMenuSystem.isTrophyAcquired(12) || XMLMenuSystem.m_menuSeasonType != 2 || !GameAI.shootCheckIfBeatsKeeper(n4 >> 2)) break;
                    XMLMenuSystem.addTrophyInGame(12);
                    break;
                }
                case 6: {
                    n4 = GameAI.shootCalculateShotTypeFirstTimeShot(nArray, n2);
                }
            }
            debugshottype = n4 >> 2;
            m_shootLastShotType = n4 >> 2;
        }
        if (m_shootLastShotType >= 1 && m_shootLastShotType <= 7) {
            int[] nArray2 = m_playerStorage[n2 ^ 1][0];
            nArray2[71] = nArray2[71] + 1;
        }
        if (!XMLMenuSystem.isTrophyAcquired(1) && XMLMenuSystem.m_menuSeasonType == 2) {
            GameAI.shootCheckForThunderbolt(nArray, n2, n4 >> 2);
        }
        return n4;
    }

    public static void shootCheckForThunderbolt(int[] nArray, int n2, int n3) {
        if (nArray[11] == XMLMenuSystem.m_beAProPlayerIndex) {
            int n4 = 12311;
            int n5 = 12311;
            int n6 = 0;
            int n7 = 32015;
            int n8 = 0;
            int n9 = GameAI.teamGetPitchSide(nArray[12]);
            n8 = n9 == 0 ? DDMath.calcHorizontalDistSquared(nArray[0], nArray[1], n5, n7) : DDMath.calcHorizontalDistSquared(nArray[0], nArray[1], n4, n6);
            if (n8 >= 0x4000000 && GameAI.shootCheckIfBeatsKeeper(n3)) {
                XMLMenuSystem.addTrophyInGame(1);
            }
        }
    }

    public static boolean shootCheckIfBeatsKeeper(int n2) {
        return n2 == 11 || n2 == 9 || n2 == 10 || n2 == 8 || n2 == 17;
    }

    public static int shootCalculateShotTypeTargeted(int[] nArray, int n2) {
        int n3;
        int n4;
        boolean bl = false;
        GameLogic.m_shootingPlayerShotType = GameLogic.m_matchPrevState == 8 ? 10 : 8;
        if ((GameLogic.m_gameMode == 99 || GameLogic.m_matchPeriod == 4) && GameLogic.isShootoutViewEnabled() && GameAI.teamGetControlType(n2) == 2) {
            if (GameLogic.m_setPieceTargetObject[0] < 12311) {
                GameLogic.m_setPieceTargetObject[0] = 12311 - (GameLogic.m_goalWidth >> 1);
            } else if (GameLogic.m_setPieceTargetObject[0] > 12311) {
                GameLogic.m_setPieceTargetObject[0] = 12311 + (GameLogic.m_goalWidth >> 1);
            }
        }
        int n5 = DDMath.abs((GameLogic.m_setPieceTargetObject[0] - (12311 - GameLogic.m_goalWidth / 2)) / (GameLogic.m_goalWidth / 3));
        n5 = DDMath.min(n5, 2);
        int n6 = GameLogic.m_controller[n2].m_microGame.getResult();
        if (GameAI.teamGetControlType(n2) == 0) {
            n6 = 1;
            if (DDMath.abs(DDMath.getRandom() & 0x1F) > 4) {
                n6 = 2;
            }
            n5 = DDMath.getPositiveRandom() % 3;
        }
        int n7 = DDMath.abs(nArray[0] - 12311);
        boolean bl2 = false;
        GameLogic.m_shootingPlayerShotType = 0;
        int n8 = nArray[14] == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32015 - nArray[1] : nArray[1];
        int n9 = DDMath.sqrtRout(n7 * n7 + n8 * n8 >> 16);
        int n10 = GameLogic.m_controller[n2].m_microGame.getMarkerZone();
        if (GameAI.teamGetControlType(n2) == 0 && n6 == 2) {
            n10 = 1;
        }
        if (n10 == 0) {
            GameLogic.beAProCheckIfBAPStatAchieved(14, m_playerStorage[n2][nArray[9]], null);
            switch (DDMath.getPositiveRandom() % 2) {
                case 0: {
                    return 73;
                }
                case 1: {
                    return 48;
                }
            }
        } else if (n10 == 3 && n9 << 8 > 3474) {
            GameLogic.beAProCheckIfBAPStatAchieved(14, m_playerStorage[n2][nArray[9]], null);
            switch (DDMath.getPositiveRandom() % 2) {
                case 0: {
                    return 77;
                }
                case 1: {
                    return 28;
                }
            }
        }
        if (n6 == 2) {
            boolean bl3;
            if (GameLogic.m_matchPeriod == 6 && GameLogic.m_setPieceTargetObject[0] == 12311 && GameLogic.m_setPieceTargetObject[2] == 312 && GameLogic.m_freeKickChallengeCurrentRound > 0) {
                if (GameLogic.m_trajectoryType == 0 || GameLogic.m_trajectoryType == 1) {
                    return 17;
                }
                return 21;
            }
            bl = true;
            n4 = DDMath.getPositiveRandom() % 100;
            boolean bl4 = GameLogic.m_matchState == 8 ? n4 >= 85 : (bl3 = n4 <= 55);
            if (GameLogic.m_gameMode == 5 && !GameLogic.freeKickChallengeGetKeeperActive()) {
                bl3 = true;
            }
            if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 5) {
                bl3 = true;
                XMLMenuSystem.m_tutorialComplete[12] = true;
            }
            if (GameLogic.m_useGKDivePosition) {
                bl3 = true;
                int n11 = DDMath.abs((GameLogic.m_setPieceGKTargetObject[0] - (12311 - GameLogic.m_goalWidth / 2)) / (GameLogic.m_goalWidth / 3));
                if (n5 == (n11 = DDMath.min(n11, 2))) {
                    bl3 = false;
                }
                switch (n5) {
                    case 1: {
                        if (bl3) {
                            n3 = 8;
                            break;
                        }
                        n3 = 1;
                        break;
                    }
                    case 0: 
                    case 2: {
                        if (bl3) {
                            if (n11 == 1) {
                                n3 = 17;
                                break;
                            }
                            n3 = 9;
                            break;
                        }
                        n3 = 1;
                        break;
                    }
                    default: {
                        n3 = 1;
                        break;
                    }
                }
            } else if (n5 == 1) {
                if (GameLogic.m_setPieceTargetObject[2] > 312) {
                    if (bl3) {
                        n3 = 11;
                    } else {
                        switch (DDMath.getPositiveRandom() % 3) {
                            case 0: {
                                n3 = 4;
                                break;
                            }
                            case 1: {
                                n3 = 5;
                                break;
                            }
                            default: {
                                n3 = 2;
                                break;
                            }
                        }
                    }
                } else {
                    n3 = bl3 ? 11 : 4;
                }
            } else {
                n3 = GameLogic.m_setPieceTargetObject[2] > 312 ? (bl3 ? 9 : (DDMath.getPositiveRandom() % 2 == 0 ? 1 : 3)) : (bl3 ? 8 : (DDMath.getPositiveRandom() % 2 == 0 ? 7 : 6));
            }
        } else {
            bl = false;
            n4 = GameLogic.m_controller[n2].m_microGame.getMarkerAccuracy();
            n3 = n5 == 1 ? 18 : (n4 < 25 ? 13 : 12);
        }
        if (bl) {
            int[] nArray2 = m_playerStorage[n2][nArray[9]];
            nArray2[64] = nArray2[64] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(2, m_playerStorage[n2][nArray[9]], null);
        } else {
            int[] nArray3 = m_playerStorage[n2][nArray[9]];
            nArray3[65] = nArray3[65] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(14, m_playerStorage[n2][nArray[9]], null);
        }
        if ((GameLogic.m_gameMode == 99 || GameLogic.m_matchPeriod == 4) && GameLogic.isShootoutViewEnabled()) {
            if (GameAI.teamGetControlType(n2) == 0) {
                n4 = DDMath.abs((GameLogic.m_setPieceGKTargetObject[0] - (12311 - GameLogic.m_goalWidth / 2)) / (GameLogic.m_goalWidth / 3));
                if ((n4 = DDMath.min(n4, 2)) == 1) {
                    GameLogic.m_setPieceGKTargetObject[0] = GameLogic.m_setPieceGKTargetObject[0] < 12311 ? 12311 - (GameLogic.m_goalWidth >> 2) : (GameLogic.m_setPieceGKTargetObject[0] > 12311 ? 12311 + (GameLogic.m_goalWidth >> 2) : 12311);
                }
            } else if (n3 == 8 || n3 == 17) {
                GameLogic.m_setPieceGKTargetObject[0] = GameLogic.m_setPieceTargetObject[0] > 12311 ? 12311 + (GameLogic.m_goalWidth >> 1) : 12311 - (GameLogic.m_goalWidth >> 1);
            } else if (n3 == 1) {
                GameLogic.m_setPieceGKTargetObject[0] = n5 == 1 ? 11811 : (n5 == 0 ? 12311 - (GameLogic.m_goalWidth >> 1) : 12311 + (GameLogic.m_goalWidth >> 1));
            }
        }
        return n3 << 2 | n5;
    }

    private static boolean shootPositionallyBeatenKeeperGoalDistance(int[] nArray, int[] nArray2, int n2) {
        if (GameAI.teamGetPitchSide(nArray[12]) == 0) {
            return nArray[1] > nArray2[1] + n2;
        }
        return nArray[1] < nArray2[1] - n2;
    }

    public static int shootCalculateShotTypeMicroGame(int[] nArray, int n2) {
        boolean bl;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = 0;
        int n11 = 0;
        boolean bl2 = false;
        int[] nArray2 = m_playerStorage[n2 ^ 1][0];
        int n12 = DDMath.abs(nArray[0] - 12311);
        boolean bl3 = false;
        GameLogic.m_shootingPlayerShotType = 0;
        if (nArray[14] == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4) {
            n9 = 32015 - nArray[1];
            n8 = DDMath.atan(12311 - GameLogic.m_goalWidth / 2 + 64 - nArray[0], n9);
            n7 = DDMath.atan(12311 + GameLogic.m_goalWidth / 2 - 64 - nArray[0], n9);
        } else {
            n9 = nArray[1];
            n7 = DDMath.atan(12311 - GameLogic.m_goalWidth / 2 + 64 - nArray[0], -nArray[1]);
            n8 = DDMath.atan(12311 + GameLogic.m_goalWidth / 2 - 64 - nArray[0], -nArray[1]);
        }
        bl3 = GameAI.shootPositionallyBeatenKeeperGoalDistance(nArray, nArray2, 217);
        if (!bl3) {
            bl3 = GameAI.playerCheckOpenGoal(nArray);
        }
        if ((n6 = DDMath.sqrtRout(n12 * n12 + n9 * n9 >> 16)) << 8 >= 4633) {
            GameLogic.m_shootingPlayerShotType = 9;
        }
        int n13 = (n6 << 8) - 2048;
        int n14 = nArray[39] * 2560 / 100;
        if (GameAI.teamGetControlType(n2) == 0) {
            n5 = 20 * GameLogic.m_difficultySettingHumanSavePercantage / 100;
            n4 = 70 * GameLogic.m_difficultySettingHumanSavePercantage / 100;
            n3 = n4 - n5;
        } else {
            n5 = 20 * GameLogic.m_difficultySettingAISavePercentage / 100;
            n4 = 70 * GameLogic.m_difficultySettingAISavePercentage / 100;
            n3 = n4 - n5;
        }
        int n15 = n5 + n13 * n3 / (n3 + n14);
        n15 = DDMath.max(n15, n5);
        n15 = DDMath.min(n15, n4);
        n5 = DDMath.atan(nArray2[0] - 768 - nArray[0], nArray2[1] - nArray[1]);
        n4 = DDMath.atan(nArray2[0] + 768 - nArray[0], nArray2[1] - nArray[1]);
        n3 = !DDMath.angleRangeCheck(n8, n5, n4) ? 1 : 0;
        boolean bl4 = !DDMath.angleRangeCheck(n7, n5, n4);
        int n16 = GameLogic.m_controller[n2].m_microGame.m_markerPosition;
        int n17 = GameLogic.m_controller[n2].m_microGame.getMarkerZone();
        if (n17 == 0) {
            GameLogic.beAProCheckIfBAPStatAchieved(14, m_playerStorage[n2][nArray[9]], null);
            switch (DDMath.getPositiveRandom() % 2) {
                case 0: {
                    return 73;
                }
                case 1: {
                    return 48;
                }
            }
        } else if (n17 == 3 && n6 << 8 > 3474) {
            GameLogic.beAProCheckIfBAPStatAchieved(14, m_playerStorage[n2][nArray[9]], null);
            switch (DDMath.getPositiveRandom() % 2) {
                case 0: {
                    return 77;
                }
                case 1: {
                    return 28;
                }
            }
        }
        if (bl3) {
            if (!GameAI.playerCheckIfHumanDoingOpenGoalCheat(nArray, nArray2)) {
                debugshottype = 14;
                int[] nArray3 = m_playerStorage[n2][nArray[9]];
                nArray3[64] = nArray3[64] + 1;
                GameLogic.beAProCheckIfBAPStatAchieved(2, m_playerStorage[n2][nArray[9]], null);
                return 57;
            }
            return 53;
        }
        if (n6 << 8 > 10240 && (GameLogic.m_gameMode != 2 || XMLMenuSystem.m_currTutorial == 6)) {
            boolean bl5 = bl2 = nArray[39] > DDMath.getPositiveRandom() % 50 + 50;
            if (bl2) {
                n15 = 100;
            } else {
                debugshottype = 19;
                int[] nArray4 = m_playerStorage[n2][nArray[9]];
                nArray4[65] = nArray4[65] + 1;
                GameLogic.beAProCheckIfBAPStatAchieved(14, m_playerStorage[n2][nArray[9]], null);
                return debugshottype << 2 | 1;
            }
        }
        if (GameLogic.m_gameMode == 2 && GameLogic.m_setPieceShotType) {
            debugshottype = 9;
            return 37;
        }
        n11 = nArray[14] == 0 ? (GameLogic.m_controller[n2].m_microGame.m_markerPosition < 50 ? 0 : 2) : (GameLogic.m_controller[n2].m_microGame.m_markerPosition > 50 ? 0 : 2);
        bl2 = true;
        boolean bl6 = bl = DDMath.getPositiveRandom() % 100 > n15;
        if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial != 6) {
            bl = true;
        }
        if (n11 == 0 && n3 == 0 || n11 == 2 && !bl4) {
            if (nArray2[36] < 8) {
                n10 = bl ? 9 : 4;
                GameLogic.m_shootingPlayerShotType = 1;
            } else if (bl) {
                GameLogic.m_shootingPlayerShotType = 1;
                n10 = 9;
            } else {
                int n18 = DDMath.getPositiveRandom() % 4;
                switch (n18) {
                    case 0: {
                        n10 = 1;
                        break;
                    }
                    case 1: {
                        n10 = 2;
                        break;
                    }
                    case 2: {
                        n10 = 3;
                        break;
                    }
                    case 3: {
                        n10 = 6;
                    }
                }
            }
        } else if (bl) {
            int n19 = DDMath.getPositiveRandom() % 3;
            switch (n19) {
                case 0: {
                    GameLogic.m_shootingPlayerShotType = 2;
                    n10 = 8;
                    break;
                }
                case 1: {
                    GameLogic.m_shootingPlayerShotType = 1;
                    n10 = 9;
                    break;
                }
                case 2: {
                    GameLogic.m_shootingPlayerShotType = 1;
                    n10 = 11;
                }
            }
        } else {
            int n20 = DDMath.getPositiveRandom() % 6;
            switch (n20) {
                case 0: {
                    n10 = 3;
                    break;
                }
                case 1: {
                    n10 = 1;
                    break;
                }
                case 2: {
                    n10 = 6;
                    break;
                }
                case 3: {
                    n10 = 7;
                    break;
                }
                case 4: {
                    n10 = 2;
                    break;
                }
                case 5: {
                    n10 = 5;
                }
            }
        }
        if (bl2) {
            int[] nArray5 = m_playerStorage[n2][nArray[9]];
            nArray5[64] = nArray5[64] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(2, m_playerStorage[n2][nArray[9]], null);
        } else {
            int[] nArray6 = m_playerStorage[n2][nArray[9]];
            nArray6[65] = nArray6[65] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(14, m_playerStorage[n2][nArray[9]], null);
        }
        return n10 << 2 | n11;
    }

    public static int shootCalculateShotTypeSideFooted(int[] nArray, int n2) {
        boolean bl;
        boolean bl2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        GameLogic.m_shootingPlayerShotType = 7;
        int n9 = 0;
        int n10 = 0;
        boolean bl3 = false;
        int[] nArray2 = m_playerStorage[n2 ^ 1][0];
        int n11 = DDMath.abs(nArray[0] - 12311);
        boolean bl4 = false;
        if (nArray[14] == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4) {
            n8 = 32015 - nArray[1];
            n7 = DDMath.atan(12311 - GameLogic.m_goalWidth / 2 + 64 - nArray[0], n8);
            n6 = DDMath.atan(12311 - nArray[0], n8);
            n5 = DDMath.atan(12311 + GameLogic.m_goalWidth / 2 - 64 - nArray[0], n8);
        } else {
            n8 = nArray[1];
            n5 = DDMath.atan(12311 - GameLogic.m_goalWidth / 2 + 64 - nArray[0], -nArray[1]);
            n6 = DDMath.atan(12311 - nArray[0], -nArray[1]);
            n7 = DDMath.atan(12311 + GameLogic.m_goalWidth / 2 - 64 - nArray[0], -nArray[1]);
        }
        bl4 = GameAI.shootPositionallyBeatenKeeperGoalDistance(nArray, nArray2, 217);
        if (!bl4) {
            bl4 = GameAI.playerCheckOpenGoal(nArray);
        }
        int n12 = DDMath.sqrtRout(n11 * n11 + n8 * n8 >> 16);
        boolean bl5 = n11 <= 5760 && n8 <= 4608;
        int n13 = (n12 << 8) - 2048;
        int n14 = nArray[39] * 2560 / 100;
        int n15 = 20 + n13 * 50 / (14592 + n14);
        n15 = DDMath.max(n15, 60);
        n15 = DDMath.min(n15, 70);
        int n16 = DDMath.atan(nArray2[0] - 768 - nArray[0], nArray2[1] - nArray[1]);
        if (n16 > (n4 = DDMath.atan(nArray2[0] + 768 - nArray[0], nArray2[1] - nArray[1]))) {
            n3 = n16;
            n16 = n4;
            n4 = n3;
        }
        n3 = !DDMath.angleRangeCheck(n7, n16, n4) ? 1 : 0;
        boolean bl6 = !DDMath.angleRangeCheck(n5, n16, n4);
        boolean bl7 = bl2 = !DDMath.angleRangeCheck(n6, n16, n4);
        if (bl4 || n3 != 0 && bl2 && bl6) {
            if (!GameAI.playerCheckIfHumanDoingOpenGoalCheat(nArray, nArray2)) {
                debugshottype = 14;
                int[] nArray3 = m_playerStorage[n2][nArray[9]];
                nArray3[64] = nArray3[64] + 1;
                GameLogic.beAProCheckIfBAPStatAchieved(2, m_playerStorage[n2][nArray[9]], null);
                return 57;
            }
            return 53;
        }
        if (GameLogic.m_gameMode == 2 && GameLogic.m_setPieceShotType) {
            debugshottype = 9;
            return 37;
        }
        if (n3 != 0 && bl6 && DDMath.getPositiveRandom() % 100 < 50) {
            n3 = 0;
        }
        int n17 = DDMath.getPositiveRandom() % 100;
        if (bl5) {
            n17 -= 10;
        }
        bl3 = n17 < nArray[51];
        boolean bl8 = bl = DDMath.getPositiveRandom() % 100 > (n15 += 20) && bl5;
        if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 4) {
            bl = true;
        }
        if (bl2) {
            n9 = nArray2[36] < 4 ? 17 : (bl3 ? (bl ? 8 : 7) : 13);
            n10 = 1;
        } else if (n3 != 0 || bl6) {
            int n18 = n10 = n3 != 0 ? 0 : 2;
            if (bl3 && nArray2[36] < 10) {
                n9 = 8;
            } else if (bl3) {
                if (bl) {
                    switch (DDMath.getPositiveRandom() % 2) {
                        case 0: {
                            n9 = 8;
                            break;
                        }
                        case 1: {
                            n9 = 16;
                        }
                    }
                } else if (n12 << 8 > 10240) {
                    n9 = 13;
                } else {
                    switch (DDMath.getPositiveRandom() % 3) {
                        case 0: {
                            n9 = 7;
                            break;
                        }
                        case 1: {
                            n9 = 6;
                            break;
                        }
                        case 2: {
                            n9 = 13;
                        }
                    }
                }
            } else if (bl5) {
                n9 = 13;
            } else {
                switch (DDMath.getPositiveRandom() % 2) {
                    case 0: {
                        n9 = 13;
                        break;
                    }
                    case 1: {
                        n9 = 12;
                    }
                }
            }
        } else {
            n9 = bl3 ? 4 : 13;
        }
        if (bl3) {
            int[] nArray4 = m_playerStorage[n2][nArray[9]];
            nArray4[64] = nArray4[64] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(2, m_playerStorage[n2][nArray[9]], null);
        } else {
            int[] nArray5 = m_playerStorage[n2][nArray[9]];
            nArray5[65] = nArray5[65] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(14, m_playerStorage[n2][nArray[9]], null);
        }
        return n9 << 2 | n10;
    }

    public static int shootCalculateShotTypeHeader(int[] nArray, int n2) {
        GameLogic.m_shootingPlayerShotType = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray2 = m_playerStorage[n2 ^ 1][0];
        int n5 = DDMath.abs(nArray[0] - 12311);
        boolean bl3 = false;
        int[] nArray3 = m_playerStorage[n2][nArray[9]];
        nArray3[74] = nArray3[74] + 1;
        short[] sArray = m_teamStorage[n2];
        sArray[18] = (short)(sArray[18] + 1);
        int n6 = nArray[14] == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32015 - nArray[1] : nArray[1];
        bl3 = GameAI.shootPositionallyBeatenKeeperGoalDistance(nArray, nArray2, 0);
        if (!bl3) {
            bl3 = GameAI.playerCheckOpenGoal(nArray);
        }
        int n7 = DDMath.sqrtRout(n5 * n5 + n6 * n6 >> 16);
        boolean bl4 = n5 <= 5760 && n6 <= 4608;
        int n8 = (n7 << 8) - 2048;
        int n9 = nArray[39] * 2560 / 100;
        int n10 = m_crossIsCornerKick ? 50 : 20;
        int n11 = n10 + n8 * 50 / (14592 + n9);
        n11 = DDMath.max(n11, 20);
        n11 = DDMath.min(n11, 70);
        if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 4) {
            bl = true;
            bl2 = true;
        } else {
            if (bl3) {
                m_crossIsCornerKick = false;
                debugshottype = 14;
                return 57;
            }
            if (GameLogic.m_gameMode == 2 && GameLogic.m_setPieceShotType) {
                m_crossIsCornerKick = false;
                debugshottype = 9;
                return 37;
            }
            bl = bl4 && DDMath.getPositiveRandom() % 100 < nArray[40];
            boolean bl5 = bl2 = DDMath.getPositiveRandom() % 100 > n11;
        }
        if (bl) {
            if (bl2) {
                int n12 = n3 = (DDMath.getRandom() & 1) == 0 ? 9 : 8;
                GameLogic.m_shootingPlayerShotType = nArray[28] == 92 || nArray[28] == 96 ? 6 : 4;
            } else {
                switch (DDMath.getPositiveRandom() % 5) {
                    case 0: {
                        n3 = 2;
                        break;
                    }
                    case 1: {
                        n3 = 7;
                        break;
                    }
                    case 2: {
                        n3 = 6;
                        break;
                    }
                    case 3: {
                        n3 = 4;
                        break;
                    }
                    case 4: {
                        n3 = m_crossIsCornerKick ? 18 : 16;
                    }
                }
            }
        } else {
            switch (DDMath.getPositiveRandom() % 6) {
                case 0: 
                case 1: 
                case 2: {
                    n3 = 13;
                    break;
                }
                case 3: {
                    n3 = 12;
                    break;
                }
                case 4: {
                    if (m_crossIsCornerKick) {
                        n3 = 18;
                        break;
                    }
                    n3 = 16;
                    break;
                }
                case 5: {
                    n3 = m_crossIsCornerKick ? 18 : 15;
                }
            }
        }
        if (bl) {
            XMLMenuSystem.m_tutorialComplete[10] = true;
            XMLMenuSystem.m_tutorialTimer = MainFrame.m_inGameFrameRate * 4;
            int[] nArray4 = m_playerStorage[n2][nArray[9]];
            nArray4[64] = nArray4[64] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(4, m_playerStorage[n2][nArray[9]], null);
        } else {
            int[] nArray5 = m_playerStorage[n2][nArray[9]];
            nArray5[65] = nArray5[65] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(15, m_playerStorage[n2][nArray[9]], null);
        }
        m_crossIsCornerKick = false;
        return n3 << 2 | n4;
    }

    public static int shootCalculateShotTypeLobShot(int[] nArray, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        GameLogic.m_shootingPlayerShotType = 3;
        int[] nArray2 = m_playerStorage[n2 ^ 1][0];
        int n6 = DDMath.abs(nArray[0] - 12311);
        boolean bl3 = false;
        int n7 = nArray[14] == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32015 - nArray[1] : nArray[1];
        bl3 = GameAI.shootPositionallyBeatenKeeperGoalDistance(nArray, nArray2, 0);
        if (!bl3) {
            bl3 = GameAI.playerCheckOpenGoal(nArray);
        }
        int n8 = DDMath.sqrtRout(n6 * n6 + n7 * n7 >> 16);
        boolean bl4 = DDMath.sqrtRout(n6 * n6 + n7 * n7) < 6400;
        int n9 = (n8 << 8) - 2048;
        int n10 = nArray[39] * 2560 / 100;
        int n11 = 20 + n9 * 50 / (14592 + n10);
        n11 = DDMath.max(n11, 20);
        n11 = DDMath.min(n11, 70);
        if (bl3) {
            debugshottype = 14;
            int[] nArray3 = m_playerStorage[n2][nArray[9]];
            nArray3[64] = nArray3[64] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(2, m_playerStorage[n2][nArray[9]], null);
            return 57;
        }
        if (GameLogic.m_gameMode == 2) {
            debugshottype = 10;
            return 41;
        }
        if (bl4) {
            bl = true;
        } else if (n8 << 8 > 10240) {
            bl = false;
        } else {
            bl = nArray[38] > DDMath.getPositiveRandom() % 50 + 50;
            bl2 = true;
        }
        int n12 = n3 = nArray[14] == 0 ? 32015 - nArray2[1] : nArray2[1];
        if (bl) {
            if (n3 > 512) {
                if (!bl2 && DDMath.getPositiveRandom() % 100 < 50) {
                    n4 = 10;
                } else {
                    int n13 = DDMath.getPositiveRandom() % 2;
                    switch (n13) {
                        case 0: {
                            n4 = 2;
                            break;
                        }
                        case 1: {
                            n4 = 16;
                        }
                    }
                    GameLogic.m_shootingPlayerShotType = 0;
                }
            } else {
                n4 = DDMath.getPositiveRandom() % 100 < 50 ? 5 : 18;
            }
        } else {
            int n14 = DDMath.getPositiveRandom() % 3;
            switch (n14) {
                case 0: {
                    n4 = 18;
                    break;
                }
                case 1: {
                    n4 = 5;
                    break;
                }
                case 2: {
                    n4 = 1;
                }
            }
        }
        if (bl) {
            int[] nArray4 = m_playerStorage[n2][nArray[9]];
            nArray4[64] = nArray4[64] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(2, m_playerStorage[n2][nArray[9]], null);
        } else {
            int[] nArray5 = m_playerStorage[n2][nArray[9]];
            nArray5[65] = nArray5[65] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(14, m_playerStorage[n2][nArray[9]], null);
        }
        return n4 << 2 | n5;
    }

    public static int shootCalculateShotTypeVolley(int[] nArray, int n2) {
        boolean bl;
        boolean bl2;
        int n3 = 0;
        int n4 = 0;
        int n5 = DDMath.abs(nArray[0] - 12311);
        int n6 = nArray[14] == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32015 - nArray[1] : nArray[1];
        int n7 = DDMath.sqrtRout(n5 * n5 + n6 * n6 >> 16);
        GameLogic.m_shootingPlayerShotType = n7 << 8 >= 4633 ? 9 : 5;
        int n8 = (n7 << 8) - 2048;
        int n9 = nArray[39] * 2560 / 100;
        int n10 = 20 + n8 * 50 / (14592 + n9);
        n10 = DDMath.max(n10, 20);
        n10 = DDMath.min(n10, 70);
        boolean bl3 = bl2 = n5 <= 5760 && n6 <= 6912;
        boolean bl4 = bl2 ? true : DDMath.getPositiveRandom() % 80 < nArray[38] >> 1;
        boolean bl5 = bl = DDMath.getPositiveRandom() % 100 > n10;
        if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 4) {
            bl4 = true;
            bl = true;
        }
        if (bl4) {
            if (bl) {
                n3 = (DDMath.getRandom() & 1) == 0 ? 9 : 11;
            } else {
                switch (DDMath.getPositiveRandom() % 3) {
                    case 0: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 1;
                        break;
                    }
                    case 2: {
                        n3 = 2;
                    }
                }
            }
        } else {
            switch (DDMath.getPositiveRandom() % 8) {
                case 0: 
                case 1: 
                case 2: {
                    n3 = 13;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n3 = 12;
                    break;
                }
                case 6: {
                    n3 = 16;
                    break;
                }
                case 7: {
                    n3 = 15;
                }
            }
        }
        int[] nArray2 = m_playerStorage[n2][nArray[9]];
        nArray2[74] = nArray2[74] + 1;
        short[] sArray = m_teamStorage[n2];
        sArray[18] = (short)(sArray[18] + 1);
        if (bl4) {
            XMLMenuSystem.m_tutorialComplete[10] = true;
            XMLMenuSystem.m_tutorialTimer = MainFrame.m_inGameFrameRate * 4;
            int[] nArray3 = m_playerStorage[n2][nArray[9]];
            nArray3[64] = nArray3[64] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(4, m_playerStorage[n2][nArray[9]], null);
        } else {
            int[] nArray4 = m_playerStorage[n2][nArray[9]];
            nArray4[65] = nArray4[65] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(15, m_playerStorage[n2][nArray[9]], null);
        }
        return n3 << 2 | n4;
    }

    public static int shootCalculateShotTypeFirstTimeShot(int[] nArray, int n2) {
        boolean bl;
        int n3 = 18;
        GameLogic.m_shootingPlayerShotType = 0;
        int n4 = DDMath.getPositiveRandom() % 100 < 50 ? 0 : 2;
        boolean bl2 = bl = DDMath.getPositiveRandom() % 80 < nArray[38];
        if (GameLogic.m_controller[n2].m_microGame.m_type == 1) {
            bl = GameLogic.m_controller[n2].m_microGame.getResult() == 2;
        }
        int n5 = DDMath.abs(nArray[0] - 12311);
        int[] nArray2 = m_playerStorage[n2 ^ 1][0];
        int n6 = nArray[14] == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32015 - nArray[1] : nArray[1];
        int n7 = DDMath.sqrtRout(n5 * n5 + n6 * n6 >> 16);
        if (n7 > 15360) {
            n3 = 19;
        } else if (bl) {
            int[] nArray3 = m_playerStorage[n2][nArray[9]];
            nArray3[64] = nArray3[64] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(2, m_playerStorage[n2][nArray[9]], null);
            switch (DDMath.getPositiveRandom() % 4) {
                case 0: {
                    n3 = 9;
                    break;
                }
                case 1: {
                    n3 = 8;
                    break;
                }
                case 2: {
                    n3 = 11;
                    break;
                }
                case 3: {
                    n3 = 16;
                }
            }
        } else {
            int[] nArray4 = m_playerStorage[n2][nArray[9]];
            nArray4[65] = nArray4[65] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(14, m_playerStorage[n2][nArray[9]], null);
            switch (DDMath.getPositiveRandom() % 4) {
                case 0: {
                    n3 = 5;
                    break;
                }
                case 1: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
                case 3: {
                    n3 = 16;
                }
            }
        }
        return n3 << 2 | n4;
    }

    public static int shootAim(int[] nArray, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = 0;
        if (n3 == 11 || n3 == 9 || n3 == 10 || n3 == 8 || n3 == 17 || n3 == 5 || n3 == 2 || n3 == 4 || n3 == 6 || n3 == 1 || n3 == 3 || n3 == 3 || n3 == 7 || n3 == 15) {
            short[] sArray = m_teamStorage[n2];
            sArray[9] = (short)(sArray[9] + 1);
        }
        GameLogic.m_shootingPlayer = nArray;
        if (m_idealShotType == 2) {
            n7 |= 2;
        }
        int[] nArray2 = m_playerStorage[n2 ^ 1][0];
        int n8 = n3 * 2;
        GameAI.objectCopyValues(nArray2, m_tempPlayer, 0, 9);
        int n9 = m_shotTypeTable[n8 + 0];
        int n10 = m_shotTypeTable[n8 + 1];
        if ((n10 & 1) != 0) {
            n6 = n9 * 4;
            int n11 = m_stateLookUpTable[n6 + 0];
            if ((n6 == 46 || n6 == 56) && n11 == 10) {
                n11 = nArray2[14] == 128 ? 96 : 95;
            }
            int n12 = n5 = GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 128 : nArray2[14];
            if (n4 == 0) {
                n5 = n5 == 128 ? 160 : 224;
            } else if (n4 == 2) {
                n5 = n5 == 128 ? 96 : 32;
            }
            int n13 = GameAI.calculateNearestAnimationDirection(n11, n5);
            int n14 = GameRender.animationGetDuration(n11) - GameRender.animationGetActionTime(n11);
            int n15 = 1024;
            if (n9 == 46) {
                n15 = 0;
            }
            if (n3 == 6) {
                n15 |= 0x100;
            } else if (n3 != 1 && n3 != 3) {
                n15 = n4 == 0 ? (n15 |= 0x100) : (n15 |= 0x200);
            }
            GameAI.CalcDive(m_tempPlayer, 1, n15, n11, true);
            Trajectory.calculateTrajectoryPosition(m_tempPlayer, 1, n14);
            int n16 = n3 * 8 + n13;
            n16 = m_goalkeeperDiveFrameOffsetsList[n16] * 3;
            m_ballhandoffX = m_goalkeeperDiveFrameOffsetsToHands[n16 + 0];
            m_ballhandoffY = m_goalkeeperDiveFrameOffsetsToHands[n16 + 1];
            m_ballhandoffZ = m_goalkeeperDiveFrameOffsetsToHands[n16 + 2];
            GameAI.m_shotTargetObject[0] = m_tempPlayer[0] + m_ballhandoffX;
            GameAI.m_shotTargetObject[1] = m_tempPlayer[1] + m_ballhandoffY;
            GameAI.m_shotTargetObject[2] = m_tempPlayer[2] + m_ballhandoffZ;
        } else if ((n10 & 2) != 0) {
            n6 = GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 128 : nArray2[14];
            int n17 = n9 * 4;
            n5 = m_stateLookUpTable[n17 + 0];
            int n18 = GameAI.calculateNearestAnimationDirection(n5, n6);
            int n19 = GameRender.animationGetDuration(n5) - GameRender.animationGetActionTime(n5);
            GameAI.CalcDive(m_tempPlayer, 2, 0, n5, true);
            Trajectory.calculateTrajectoryPosition(m_tempPlayer, 1, n19);
            int n20 = n3 * 8 + n18;
            n20 = m_goalkeeperDiveFrameOffsetsList[n20] * 3;
            m_ballhandoffX = m_goalkeeperDiveFrameOffsetsToHands[n20 + 0];
            m_ballhandoffY = 0;
            m_ballhandoffZ = m_goalkeeperDiveFrameOffsetsToHands[n20 + 2];
            GameAI.m_tempPlayer[2] = GameLogic.KEEPER_JUMP_VELOCITY;
            GameAI.m_shotTargetObject[0] = m_tempPlayer[0] + m_ballhandoffX;
            GameAI.m_shotTargetObject[1] = m_tempPlayer[1] + m_ballhandoffY;
            GameAI.m_shotTargetObject[2] = m_tempPlayer[2] + m_ballhandoffZ;
        } else if ((n10 & 8) != 0) {
            n6 = GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 128 : nArray2[14];
            int n21 = n9 * 4;
            n5 = m_stateLookUpTable[n21 + 0];
            int n22 = GameAI.calculateNearestAnimationDirection(n5, n6);
            int n23 = n3 * 8 + n22;
            n23 = m_goalkeeperDiveFrameOffsetsList[n23] * 3;
            m_ballhandoffX = m_goalkeeperDiveFrameOffsetsToHands[n23 + 0];
            m_ballhandoffY = m_goalkeeperDiveFrameOffsetsToHands[n23 + 1];
            m_ballhandoffZ = m_goalkeeperDiveFrameOffsetsToHands[n23 + 2];
            GameAI.m_shotTargetObject[0] = m_tempPlayer[0] + m_ballhandoffX;
            GameAI.m_shotTargetObject[1] = m_tempPlayer[1] + m_ballhandoffY;
            GameAI.m_shotTargetObject[2] = m_tempPlayer[2] + m_ballhandoffZ;
        } else if ((n10 & 0x10) != 0) {
            GameAI.m_shotTargetObject[0] = n4 == 0 ? 12311 - GameLogic.m_goalWidth / 2 + 128 + DDMath.getPositiveRandom() % 512 : 12311 + GameLogic.m_goalWidth / 2 - 128 - DDMath.getPositiveRandom() % 512;
            GameAI.m_shotTargetObject[1] = GameAI.teamGetPitchSide(n2) == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32014 : 1;
            GameAI.m_shotTargetObject[2] = 312 + DDMath.abs(DDMath.getRandom() % 624 / 4);
        } else if ((n10 & 0x800) != 0) {
            GameAI.m_shotTargetObject[0] = 12311 + DDMath.getRandom() % (GameLogic.m_goalWidth / 4);
            GameAI.m_shotTargetObject[1] = GameAI.teamGetPitchSide(n2) == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32014 : 1;
            GameAI.m_shotTargetObject[2] = 468 + DDMath.getPositiveRandom() % 156;
        } else if ((n10 & 0x20) != 0) {
            GameAI.m_shotTargetObject[0] = n4 == 0 ? 12311 - GameLogic.m_goalWidth / 2 + GameLogic.m_goalWidth / 6 + DDMath.getPositiveRandom() % GameLogic.m_goalWidth / 6 : (n4 == 1 ? 12311 + DDMath.getRandom() % GameLogic.m_goalWidth / 6 : 12311 + GameLogic.m_goalWidth / 2 - GameLogic.m_goalWidth / 6 - DDMath.getPositiveRandom() % GameLogic.m_goalWidth / 6);
            GameAI.m_shotTargetObject[1] = GameAI.teamGetPitchSide(n2) == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32143 : -128;
            GameAI.m_shotTargetObject[2] = DDMath.getPositiveRandom() % 624 / 2;
            n7 |= 2;
            n6 = DDMath.calcHorizontalDist(nArray, m_shotTargetObject);
            if (n6 > 10240) {
                n5 = 5120;
                int n24 = DDMath.calcAngle(nArray, m_shotTargetObject);
                GameAI.m_shotTargetObject[0] = nArray[0] + (DDMath.sin(n24) * (n6 -= n5) >> 16);
                GameAI.m_shotTargetObject[1] = nArray[1] + (DDMath.cos(n24) * n6 >> 16);
                GameAI.m_shotTargetObject[2] = DDMath.getPositiveRandom() % 624 / 8;
            }
        } else if ((n10 & 0x40) != 0) {
            GameAI.m_shotTargetObject[0] = 12311;
            GameAI.m_shotTargetObject[1] = GameAI.teamGetPitchSide(n2) == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32014 : 1;
            GameAI.m_shotTargetObject[2] = 468;
            n7 = 1;
        } else if ((n10 & 0x80) != 0) {
            GameAI.m_shotTargetObject[0] = n4 == 0 ? 12311 - GameLogic.m_goalWidth - DDMath.getPositiveRandom() % GameLogic.m_goalWidth / 2 : 12311 + GameLogic.m_goalWidth + DDMath.getPositiveRandom() % GameLogic.m_goalWidth / 2;
            int n25 = GameAI.m_shotTargetObject[1] = GameAI.teamGetPitchSide(n2) == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32015 : 0;
            GameAI.m_shotTargetObject[2] = GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? GameLogic.m_setPieceTargetObject[2] : 312;
        } else if ((n10 & 0x100) != 0) {
            n6 = DDMath.getPositiveRandom() % (GameLogic.m_goalWidth / 4);
            GameAI.m_shotTargetObject[0] = n4 == 0 ? 12311 - GameLogic.m_goalWidth / 2 - GameLogic.m_goalWidth / 8 - n6 : 12311 + GameLogic.m_goalWidth / 2 + GameLogic.m_goalWidth / 8 + n6;
            int n26 = GameAI.m_shotTargetObject[1] = GameAI.teamGetPitchSide(n2) == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32015 : 0;
            GameAI.m_shotTargetObject[2] = GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? GameLogic.m_setPieceTargetObject[2] : 312;
        } else if ((n10 & 0x200) != 0) {
            GameAI.m_shotTargetObject[0] = n4 == 0 ? 12311 - GameLogic.m_goalWidth / 2 + 102 - DDMath.getPositiveRandom() % 204 : 12311 + GameLogic.m_goalWidth / 2 - 102 + DDMath.getPositiveRandom() % 204;
            GameAI.m_shotTargetObject[1] = GameAI.teamGetPitchSide(n2) == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32014 : 1;
            GameAI.m_shotTargetObject[2] = 0;
        } else if ((n10 & 0x400) != 0) {
            n6 = DDMath.getPositiveRandom() % 204;
            if (m_shootLastIdealShotType == 0 && GameLogic.m_controller[n2].m_microGame.getResult() != 2) {
                n6 = DDMath.max(n6, 121);
            }
            GameAI.m_shotTargetObject[0] = 12311 + DDMath.abs(DDMath.getRandom() % (GameLogic.m_goalWidth / 2));
            GameAI.m_shotTargetObject[1] = GameAI.teamGetPitchSide(n2) == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32015 : 0;
            GameAI.m_shotTargetObject[2] = 522 + n6;
        } else if ((n10 & 0x2000) != 0) {
            GameAI.m_shotTargetObject[0] = 12311 + DDMath.getRandom() % (GameLogic.m_goalWidth / 2);
            GameAI.m_shotTargetObject[1] = GameAI.teamGetPitchSide(n2) == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32015 : 0;
            GameAI.m_shotTargetObject[2] = 936;
        } else if ((n10 & 0x4000) != 0) {
            int n27 = 12311;
            n5 = GameAI.teamGetPitchSide(n2) == 0 || GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4 ? 32015 : 0;
            int n28 = DDMath.atan(n27 - m_ballStorage[0], n5 - m_ballStorage[1]);
            int n29 = DDMath.calcHorizontalDist(m_ballStorage, n27, n5);
            n29 -= 4633;
            n29 = DDMath.max(n29, 1280);
            GameAI.m_shotTargetObject[0] = m_ballStorage[0] + (DDMath.sin(n28) * n29 >> 16);
            GameAI.m_shotTargetObject[1] = m_ballStorage[1] + (DDMath.cos(n28) * n29 >> 16);
            GameAI.m_shotTargetObject[2] = 0;
            n7 |= 0x4000;
        }
        if ((n10 & 0x1000) != 0) {
            n6 = DDMath.calcHorizontalDist(m_ballStorage, m_shotTargetObject);
            if (n6 > 4096) {
                n5 = DDMath.calcAngle(m_ballStorage, m_shotTargetObject);
                n6 = 4096;
                GameAI.m_shotTargetObject[0] = m_ballStorage[0] + (DDMath.sin(n5) * n6 >> 16);
                GameAI.m_shotTargetObject[1] = m_ballStorage[1] + (DDMath.cos(n5) * n6 >> 16);
                m_shotTargetObject[2] = m_shotTargetObject[2] >> 1;
                n7 |= 0x1000;
            }
            if (m_idealShotType == 0 && GameLogic.m_controller[n2].m_microGame.getMarkerZone() == 0) {
                GameAI.m_shotTargetObject[2] = GameLogic.m_controller[n2].m_microGame.m_markerPosition * 936 / 100;
            }
        }
        if (m_shotTypeTable[n8 + 0] != 0) {
            GameAI.playerSetState(nArray2, 0, 0, 31);
            nArray2[29] = n9;
        }
        return n7;
    }

    public static int shootGetBallSpeed(int[] nArray, int n2, int n3, boolean bl, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        n8 = n2 < 6400 ? GameLogic.SHOT_SPEED_MINIMIUM_FROM_SHORT_DISTANCE + ((n7 = nArray[39] * (GameLogic.SHOT_SPEED_MAXIMUM_FROM_SHORT_DISTANCE - GameLogic.SHOT_SPEED_MINIMIUM_FROM_SHORT_DISTANCE)) > 0 ? n7 / 100 : 0) : (n2 < 8960 ? GameLogic.SHOT_SPEED_MINIMIUM_FROM_MEDIUM_DISTANCE + ((n6 = nArray[39] * (GameLogic.SHOT_SPEED_MAXIMUM_FROM_MEDIUM_DISTANCE - GameLogic.SHOT_SPEED_MINIMIUM_FROM_MEDIUM_DISTANCE)) > 0 ? n6 / 100 : 0) : GameLogic.SHOT_SPEED_MINIMIUM_FROM_LONG_DISTANCE + ((n5 = nArray[39] * (GameLogic.SHOT_SPEED_MAXIMUM_FROM_LONG_DISTANCE - GameLogic.SHOT_SPEED_MINIMIUM_FROM_LONG_DISTANCE)) > 0 ? n5 / 100 : 0));
        if (GameLogic.m_trajectoryType == 3) {
            n8 += 3840 / MainFrame.m_inGameFrameRate;
        }
        n4 = n4 * 130 / 100;
        n4 = DDMath.max(n4, 50);
        n4 = DDMath.min(n4, 130);
        n8 = n8 * n4 / 100;
        return n8;
    }

    private static void shootKickBall(int[] nArray, int n2) {
        int n3;
        int n4;
        int n5 = m_ballStorage[0];
        int n6 = m_ballStorage[1];
        int n7 = m_ballStorage[2];
        int n8 = m_shotTargetObject[0] - n5;
        int n9 = m_shotTargetObject[1] - n6;
        int n10 = m_shotTargetObject[2] - n7;
        int n11 = DDMath.sqrtRout(n8 * n8 + n9 * n9);
        int n12 = 0;
        int n13 = 0;
        m_shootLastDistance = n11;
        m_shootLastPlayer = nArray;
        GameAI.m_ballStorage[6] = 16;
        short[] sArray = m_teamStorage[nArray[12]];
        sArray[8] = (short)(sArray[8] + 1);
        m_playerWithBall = null;
        GameLogic.m_controller[nArray[12]].m_shootBall = false;
        if ((n2 & 2) != 0) {
            n4 = m_idealShotType == 6 ? DDMath.min(n11, 7680) : n11;
        } else {
            n3 = 16640 + nArray[39] * 2560 / 100;
            n4 = DDMath.min(n11, n3);
        }
        if (n4 < n11) {
            n3 = n4 * 100 / n11;
            n8 = n8 * n3 / 100;
            n9 = n9 * n3 / 100;
        }
        n3 = 10;
        if (m_idealShotType == 0 || m_idealShotType == 3) {
            n3 = GameLogic.m_controller[nArray[12]].m_microGame.m_markerPosition;
        }
        if (n3 < 50) {
            n3 = 50;
        }
        int n14 = GameAI.shootGetBallSpeed(nArray, n4, 0, true, n3);
        if ((n2 & 0x1000) != 0) {
            n14 += n4 >> 5;
        }
        int n15 = n4 / n14 + 1;
        if ((n2 & 0x4000) != 0) {
            n15 += MainFrame.m_inGameFrameRate;
        } else if ((n2 & 1) != 0) {
            n15 = n15 * 332 >> 8;
            n15 = DDMath.min(n15, GameLogic.SHOT_LOB_MAX_FRAMES);
        } else if (m_idealShotType == 1) {
            n15 += MainFrame.m_inGameFrameRate >> 1;
        }
        if (m_idealShotType == 3 && GameLogic.m_setPieceType == 0) {
            switch (GameLogic.m_trajectoryType) {
                case 3: {
                    GameAI.m_passTargetObject[2] = 0;
                    break;
                }
                case 2: {
                    n15 += MainFrame.m_inGameFrameRate / 4;
                }
                case 0: 
                case 1: {
                    GameAI.m_passTargetObject[2] = 486;
                    GameAI.calculateSwerveForShot(m_ballStorage, GameLogic.m_setPieceTargetObject, GameLogic.m_trajectoryType);
                    n12 = m_calculatedSwerveX;
                    n13 = m_calculatedSwerveY;
                }
            }
        } else if (m_idealShotType == 4) {
            n15 = m_shotTargetObject[2] < 312 ? (n15 += MainFrame.m_inGameFrameRate / 8) : (nArray[28] == 96 || nArray[28] == 161 ? (n15 += MainFrame.m_inGameFrameRate / 4) : (n15 += MainFrame.m_inGameFrameRate / 2));
        }
        Trajectory.setupTrajectory(m_ballStorage, 0, n15, n5, n6, n7, n5 + n8, n6 + n9, n7 + n10, n12, n13);
        GameLogic.refereeUpdateOffsidePlayerFlags(false);
    }

    public static final void Clearance(int[] nArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (n3) {
            case 1: {
                n4 = nArray[14] + DDMath.getRandom() % 20;
                n6 = GameLogic.KEEPER_CLEARANCE_BALL_SPEED;
                n5 = 21;
                break;
            }
            case 2: {
                n4 = nArray[22] + DDMath.getRandom() % 15;
                n6 = GameLogic.PLAYER_CLEARANCE_BALL_SPEED;
                n5 = 21;
                break;
            }
            case 6: {
                n4 = GameAI.ballCurrentDirection();
                n6 = GameLogic.PLAYER_CLEARANCE_CONTROL_BALL_SPEED;
                n5 = 3;
                break;
            }
            case 0: {
                n4 = nArray[22] + DDMath.getRandom() % 14;
                n6 = GameLogic.PLAYER_CLEARANCE_TACKLE_BALL_SPEED;
                n5 = 10;
                break;
            }
            case 3: {
                n4 = nArray[22] + DDMath.getRandom() % 64;
                n6 = GameLogic.PLAYER_CLEARANCE_HEADER_BALL_SPEED;
                n5 = 42;
                break;
            }
            case 4: {
                n4 = nArray[22] + DDMath.getRandom() % 14;
                n6 = GameLogic.PLAYER_CLEARANCE_STANDING_TACKLE_BALL_SPEED;
                n5 = 17;
                break;
            }
            case 5: {
                int n7 = (int)(2560.0 / (double)MainFrame.m_inGameFrameRate);
                n4 = nArray[14] + DDMath.getRandom() % 21;
                n6 = GameAI.ballGetSpeed() * 100 >> 8;
                n6 = DDMath.max(n6, n7);
                n5 = 32;
                break;
            }
        }
        GameAI.ballSetToFreeBall();
        GameAI.ballSetLastTouchPlayer(nArray);
        GameAI.m_ballStorage[3] = DDMath.sin(n4) * n6 >> 16;
        GameAI.m_ballStorage[4] = DDMath.cos(n4) * n6 >> 16;
        GameAI.m_ballStorage[5] = DDMath.sin(n5) * n6 >> 16;
        GameLogic.m_controller[n2].m_shootBall = false;
        GameLogic.m_controller[n2].m_clearBall = false;
        m_playerWithBall = null;
        GameLogic.refereeUpdateOffsidePlayerFlags(false);
    }

    public static final void passBall(int[] nArray, int[] nArray2, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        int[] nArray3 = GameAI.ballGetLastTouchPlayer();
        boolean bl2 = false;
        boolean bl3 = bl = GameAI.teamGetControlType(GameLogic.m_possession) == 2;
        if (GameLogic.m_matchState == 2 && nArray2 != GameAI.getPassTargetAlternate(nArray3) && nArray3 != GameLogic.m_setPieceTaker && (GameAI.teamGetPitchSide(GameLogic.m_possession) == 0 && nArray[1] < nArray2[1] && DDMath.CalcModDifference(DDMath.calcAngle(nArray, nArray2), 0) < 42 || GameAI.teamGetPitchSide(GameLogic.m_possession) == 1 && nArray[1] > nArray2[1] && DDMath.CalcModDifference(DDMath.calcAngle(nArray, nArray2), 128) < 42)) {
            bl2 = true;
        }
        GameAI.m_teamStorage[0][20] = 0;
        GameAI.m_teamStorage[1][20] = 0;
        GameLogic.m_beAProPassPlayed = GameLogic.beAProIsPlayerBAPPlayer(nArray3);
        m_ballStorage[6] = m_ballStorage[6] & 0xFFFFDEDF;
        m_ballStorage[6] = m_ballStorage[6] | 4;
        if ((n2 & 0x20) != 0) {
            m_ballStorage[6] = m_ballStorage[6] | 8;
        }
        GameAI.m_passTargetObject[0] = nArray2[0];
        GameAI.m_passTargetObject[1] = nArray2[1];
        GameAI.m_passTargetObject[2] = 0;
        int n7 = nArray2[0] - nArray[0];
        int n8 = nArray2[1] - nArray[1];
        int n9 = n6 = nArray2 == GameLogic.m_setPieceTargetObject ? DDMath.sqrtRout(n7 * n7 + n8 * n8) : nArray2[36] << 8;
        if (bl2) {
            n6 = n6 * 588 >> 8;
        }
        int n10 = n5 = n6;
        boolean bl4 = true;
        int n11 = 1;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        if (nArray2.length > 9 && nArray2[9] == 0) {
            n14 = 0;
        }
        if (GameAI.teamGetControlType(GameLogic.m_possession) == 0) {
            GameLogic.m_controller[GameLogic.m_possession ^ 1].setControlPlayer(null);
        }
        if (GameLogic.m_controller[GameLogic.m_possession].m_tappedPass) {
            m_passType = 0;
            if ((n2 & 0x18) != 0) {
                int n16;
                n5 = DDMath.sqrtRout(n7 * n7 + n8 * n8);
                n4 = n5 / GameAI.getPassSpeed(n6, n2);
                GameAI.setPassTargetPosition(nArray, nArray2, n4, n2);
                n3 = DDMath.calcAngle(nArray2, nArray);
                if (n3 > 114 && n3 < 142) {
                    n16 = nArray2[0] < 12311 ? nArray2[7] << 3 : -(nArray2[7] << 3);
                    m_passTargetObject[0] = m_passTargetObject[0] + n16;
                }
                n7 = m_passTargetObject[0] - nArray[0];
                n8 = m_passTargetObject[1] - nArray[1];
                bl4 = false;
                m_ballStorage[6] = m_ballStorage[6] | 0x100;
                n16 = n5 / GameLogic.GROUND_PASS_AVERAGE_SPEED;
                int n17 = GameLogic.THROUGH_BALL_FINAL_SPEED;
                while (n16-- > 0) {
                    n17 = (n17 << 8) / GameLogic.m_friction;
                }
                GameAI.m_ballStorage[3] = n17 * n7 / n5;
                GameAI.m_ballStorage[4] = n17 * n8 / n5;
                if (bl) {
                    m_displayPassTrajectory = true;
                    GameAI.m_passTrajectoryMarker[9] = 0;
                    GameAI.m_passTrajectoryMarker[0] = nArray[0];
                    GameAI.m_passTrajectoryMarker[1] = nArray[1];
                    GameAI.m_passTrajectoryMarker[2] = nArray[2];
                    GameAI.m_passTrajectoryMarker[3] = nArray[0] + n7;
                    GameAI.m_passTrajectoryMarker[4] = nArray[1] + n8;
                    GameAI.m_passTrajectoryMarker[5] = m_passTargetObject[2];
                    GameAI.m_passTrajectoryMarker[6] = n5 / GameLogic.GROUND_PASS_AVERAGE_SPEED;
                }
            } else if (n5 < 1280) {
                bl4 = false;
                m_ballStorage[6] = m_ballStorage[6] | 0x100;
                if (GameLogic.m_controller[GameLogic.m_possession].m_returningOneTwoPassPlayer == nArray2) {
                    n3 = GameLogic.GROUND_PASS_FINAL_SPEED_FOR_ONE_TWO_INITIAL_PASS;
                    n4 = n5 / GameLogic.GROUND_PASS_AVERAGE_SPEED_FOR_ONE_TWO_INITIAL_PASS;
                } else {
                    n3 = GameLogic.GROUND_PASS_FINAL_SPEED;
                    n4 = n5 / GameLogic.GROUND_PASS_AVERAGE_SPEED;
                }
                while (n4-- > 0) {
                    n3 = (n3 << 8) / GameLogic.m_friction;
                }
                GameAI.m_ballStorage[3] = n3 * n7 / n5;
                GameAI.m_ballStorage[4] = n3 * n8 / n5;
            } else {
                int n18;
                int n19;
                int n20;
                n4 = n6 / GameAI.getPassSpeed(n6, n2);
                n11 = GameAI.setPassTargetPosition(nArray, nArray2, n4, n2);
                n3 = -1;
                if (!bl || XMLMenuSystem.m_tacticsPassing == 0 || m_forcePassToSpace) {
                    if (m_forcePassToSpace) {
                        // empty if block
                    }
                    GameAI.m_passTrajectoryMarker[9] = 0;
                    n3 = GameAI.passIntoSpaceIsPassTargetBlocked(nArray, m_passTargetObject);
                    if (DDDebug.DEBUG_DRAW_PASS_INTO_SPACE_CONTROL_POINTS) {
                        GameRender.m_debugDrawPassIntoSpaceRevisedPassTargetX = GameRender.m_debugDrawPassIntoSpaceOriginalPassTargetX = m_passTargetObject[0];
                        GameRender.m_debugDrawPassIntoSpaceRevisedPassTargetY = GameRender.m_debugDrawPassIntoSpaceOriginalPassTargetY = m_passTargetObject[1];
                    }
                    if (n3 != -1 || bl && m_forcePassToSpace) {
                        m_displayPassTrajectory = bl;
                        GameAI.passIntoSpaceUpdateTargetPositions(nArray, m_passTargetObject);
                        n20 = m_passTargetObject[0];
                        n19 = m_passTargetObject[1];
                        GameAI.m_passTargetObject[0] = m_passIntoSpaceGoalSidePositionX;
                        GameAI.m_passTargetObject[1] = m_passIntoSpaceGoalSidePositionY;
                        n18 = GameAI.passIntoSpaceIsPassTargetBlocked(nArray, m_passTargetObject);
                        if (n18 != -1) {
                            GameAI.m_passTargetObject[0] = m_passIntoSpaceDefenceSidePositionX;
                            GameAI.m_passTargetObject[1] = m_passIntoSpaceDefenceSidePositionY;
                            n18 = GameAI.passIntoSpaceIsPassTargetBlocked(nArray, m_passTargetObject);
                            if (!(n18 == -1 || bl && m_forcePassToSpace)) {
                                m_displayPassTrajectory = false;
                                n3 = n18;
                                GameAI.m_passTargetObject[0] = n20;
                                GameAI.m_passTargetObject[1] = n19;
                            }
                        }
                        m_forcePassToSpace = false;
                    } else {
                        m_displayPassTrajectory = false;
                        if (DDDebug.DEBUG_DRAW_PASS_INTO_SPACE_CONTROL_POINTS) {
                            m_passIntoSpaceGoalSidePositionX = -1;
                            m_passIntoSpaceGoalSidePositionY = -1;
                            m_passIntoSpaceDefenceSidePositionX = -1;
                            m_passIntoSpaceDefenceSidePositionY = -1;
                        }
                    }
                    if (n3 != -1) {
                        // empty if block
                    }
                    if (DDDebug.DEBUG_DRAW_PASS_INTO_SPACE_CONTROL_POINTS) {
                        GameRender.m_debugDrawPassIntoSpaceLastClosestPlayerId = n3;
                        GameRender.m_debugDrawPassIntoSpaceLastClosestPlayerTeam = GameLogic.m_possession ^ 1;
                    }
                }
                n7 = m_passTargetObject[0] - nArray[0];
                n8 = m_passTargetObject[1] - nArray[1];
                n5 = DDMath.sqrtRout(n7 * n7 + n8 * n8);
                n20 = bl2 ? 75 : 45;
                if (n3 != -1) {
                    n19 = DDMath.max(0, 10752 - n5);
                    n18 = n19 * 100 / 10752;
                    int n21 = 95 * n18 / 100;
                    n20 -= n20 * n21 / 100;
                }
                n10 = n5 * n20 / 100;
                n11 = n11 * n20 / 100;
                n7 = n7 * n20 / 100;
                n8 = n8 * n20 / 100;
            }
        } else if (GameLogic.m_controller[GameLogic.m_possession].m_headerPass) {
            GameAI.m_passTargetObject[2] = GameAI.passTargetGetHeightFromPassFlags(n2);
            n10 = DDMath.min(n6, 3840);
            n11 = n10 / GameAI.getPassSpeed(n6, n2);
            n11 += MainFrame.m_inGameFrameRate;
        } else if (GameLogic.m_controller[GameLogic.m_possession].m_longPass) {
            if (GameLogic.m_controller[GameLogic.m_possession].m_setPieceLongPass) {
                n2 |= 0x8000;
                switch (GameLogic.m_trajectoryType) {
                    case 3: {
                        GameAI.m_passTargetObject[2] = 0;
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        GameAI.m_passTargetObject[2] = 486;
                        GameAI.calculateSwerveForPass(m_ballStorage, GameLogic.setPieceGetCurrentTarget(), GameLogic.m_trajectoryType);
                        GameAI.calculateAttackingPassOffset(m_ballStorage, GameLogic.setPieceGetCurrentTarget(), GameLogic.m_trajectoryType);
                        n12 = 0;
                        n13 = 0;
                        n14 = m_calculatedSwerveX;
                        n15 = m_calculatedSwerveY;
                    }
                }
            }
            GameAI.m_passTargetObject[2] = GameAI.passTargetGetHeightFromPassFlags(n2);
            n4 = n6 / GameAI.getPassSpeed(n6, n2);
            n11 = GameAI.setPassTargetPosition(nArray, nArray2, n4, n2);
            n7 = m_passTargetObject[0] - nArray[0];
            n8 = m_passTargetObject[1] - nArray[1];
            n5 = DDMath.sqrtRout(n7 * n7 + n8 * n8);
            n3 = GameAI.teamGetControlType(GameLogic.m_possession) == 2 ? GameLogic.m_difficultySettingLongPassingRandomRangeHuman : GameLogic.m_difficultySettingLongPassingRandomRangeAI;
            int n22 = DDMath.min(nArray3[43] * 100 / 85, 100);
            int n23 = (100 - n22) * 100 / 55;
            n23 = DDMath.max(1, DDMath.min(n23 * n3 / 100, 55));
            if (GameLogic.m_controller[GameLogic.m_possession].m_crossBall || (n2 & 0x20) != 0 || GameAI.ballIsInACross()) {
                n23 = n23 * 55 / 100;
            } else if ((n2 & 0x8000) != 0) {
                n23 = n23 * 55 / 100;
            }
            int n24 = 100;
            if (n23 > 0) {
                n24 += DDMath.getRandom() % n23;
            }
            n10 = n5 * n24 / 100;
            n4 = n10 / GameAI.getPassSpeed(n10, n2);
            n11 = n11 * n24 / 100;
            n7 = n7 * n24 / 100;
            n8 = n8 * n24 / 100;
            if (!GameLogic.m_controller[GameLogic.m_possession].m_crossBall && (n2 & 0x20) == 0 && !GameLogic.m_controller[GameLogic.m_possession].m_throughBall && (n2 & 8) == 0 && (n2 & 0x8000) == 0 && GameAI.closestPlayerDistToPoint(n7 * 80 / 100, n8 * 80 / 100, GameLogic.m_possession ^ 1) > 1280) {
                n10 = n5 * 80 / 100;
                n11 = n11 * 80 / 100;
                n7 = n7 * 80 / 100;
                n8 = n8 * 80 / 100;
            }
            if (bl && (n2 & 8) != 0) {
                m_displayPassTrajectory = true;
                GameAI.m_passTrajectoryMarker[9] = 1;
            }
        } else {
            m_passType = 6;
            GameAI.m_passTargetObject[2] = GameAI.passTargetGetHeightFromPassFlags(n2);
        }
        if (bl4) {
            n4 = GameAI.getPassSpeed(n5, n2);
            n3 = DDMath.max(n11, n10 / n4);
            n3 = DDMath.min(n3, MainFrame.m_inGameFrameRate * 3);
            Trajectory.setupTrajectory(m_ballStorage, 0, n3, nArray[0], nArray[1], nArray[2], nArray[0] + n7 + n12, nArray[1] + n8 + n13, m_passTargetObject[2], n14, n15);
            if (m_displayPassTrajectory) {
                GameAI.m_passTrajectoryMarker[0] = nArray[0];
                GameAI.m_passTrajectoryMarker[1] = nArray[1];
                GameAI.m_passTrajectoryMarker[2] = nArray[2];
                GameAI.m_passTrajectoryMarker[3] = nArray[0] + n7 + n12;
                GameAI.m_passTrajectoryMarker[4] = nArray[1] + n8 + n13;
                GameAI.m_passTrajectoryMarker[5] = m_passTargetObject[2];
                GameAI.m_passTrajectoryMarker[7] = n14;
                GameAI.m_passTrajectoryMarker[8] = n15;
                GameAI.m_passTrajectoryMarker[6] = n3;
            }
        }
        nArray3[6] = nArray3[6] | 0x20000;
        nArray3[24] = MainFrame.m_inGameFrameRate / 6;
        m_playerWithBall = null;
        GameLogic.m_controller[GameLogic.m_possession].resetAttackingActions();
        GameLogic.m_controller[GameLogic.m_possession].resetThroughBallTargets();
        GameLogic.m_lockPassTargetsPlayer = null;
        if (GameLogic.m_gameMode != 99 && GameLogic.m_gameMode != 2) {
            GameFormation.interceptionCheckIfPlayersCanInterceptAPass();
        }
        GameFormation.interceptionCheckIfGoalKeeperCanInterceptAPass();
        if (GameLogic.m_matchState == 5) {
            GameLogic.refereeUpdateOffsidePlayerFlags(true);
        } else {
            GameLogic.refereeUpdateOffsidePlayerFlags(false);
        }
        GameLogic.debugPlacePlayerInPathOfBall();
    }

    public static int getPassSpeed(int n2, int n3) {
        if (GameLogic.m_matchState == 17 && n2 > 3840) {
            return GameLogic.AERIAL_PASS_AVERAGE_SPEED_MEDIUM;
        }
        if ((n3 & 0x2000) != 0) {
            return GameLogic.THROW_IN_AVERAGE_SPEED;
        }
        if (n2 < 3840) {
            return GameLogic.AERIAL_PASS_AVERAGE_SPEED_SHORT;
        }
        if (n2 < 8960) {
            return GameLogic.AERIAL_PASS_AVERAGE_SPEED_MEDIUM;
        }
        return GameLogic.AERIAL_PASS_AVERAGE_SPEED_LONG;
    }

    private static int setPassTargetPosition(int[] nArray, int[] nArray2, int n2, int n3) {
        GameAI.m_passTargetObject[0] = nArray2[0];
        GameAI.m_passTargetObject[1] = nArray2[1];
        int n4 = DDMath.calcAngle(nArray, nArray2);
        int n5 = n4 = nArray2 == GameLogic.m_setPieceTargetObject ? 0 : DDMath.abs(DDMath.calcTurnAngle(n4, nArray2[14]));
        m_passType = (n3 & 0x10) != 0 ? 2 : ((n3 & 0x20) != 0 ? 3 : ((n3 & 8) != 0 || n4 < 21 ? 1 : ((n3 & 0x8000) != 0 ? 6 : (n4 < 85 ? 4 : 5))));
        switch (m_passType) {
            case 3: {
                if (nArray2 == GameLogic.m_setPieceTargetObject || !GameLogic.isObjectIn18YardBox(nArray2, GameAI.teamGetPitchSide(nArray2[12] ^ 1))) break;
                int n6 = MainFrame.m_inGameFrameRate == 12 ? 0 : 1280;
                m_passTargetObject[1] = m_passTargetObject[1] + (DDMath.cos(nArray2[14]) * n6 >> 16);
                break;
            }
            case 6: {
                if (nArray2 != GameLogic.m_setPieceTargetObject) break;
                break;
            }
            case 1: 
            case 2: {
                int n7 = nArray2[14];
                int n8 = GameLogic.m_controller[GameLogic.m_possession].m_longPass ? GameAI.playerEstimatePotentialMoveDist(nArray2, n7, n2, 360) : (m_passType != 3 && m_passType != 6 ? GameAI.playerEstimatePotentialMoveDist(nArray2, n7, n2, 360) : 0);
                int n9 = n8 * 2;
                GameAI.setupPassEvalPlayerList(nArray2, n9, n7, 64);
                if (m_passType == 2) {
                    GameAI.setPassTargetPositionThroughBall(nArray2, n2, n8, n7, 64, true);
                    break;
                }
                if (m_passEvalPlayerListCount <= 8 && GameAI.setPassTargetPositionThroughBall(nArray2, n2, n8, n7, 64, false)) break;
                GameAI.setPassTargetPositionInSpace(nArray2, n2);
                break;
            }
            case 4: {
                int n10 = nArray2[14];
                int n11 = GameAI.playerEstimatePotentialMoveDist(nArray2, n10, n2, 360);
                int n12 = n11 * 3 / 2;
                GameAI.setupPassEvalPlayerList(nArray2, n12, n10, 64);
                if (m_passEvalPlayerListCount <= 8 && GameAI.setPassTargetPositionThroughBall(nArray2, n2, n11, n10, 64, false)) break;
                GameAI.setPassTargetPositionInSpace(nArray2, n2);
                break;
            }
            case 5: {
                GameAI.setPassTargetPositionInSpace(nArray2, n2);
            }
        }
        GameAI.keepPositionWithinPitch(m_passTargetObject);
        return DDMath.max(n2, 1);
    }

    private static void setupPassEvalPlayerList(int[] nArray, int n2, int n3, int n4) {
        int n5 = nArray[12] ^ 1;
        int n6 = n2 * n2;
        m_passEvalPlayerListCount = 0;
        for (int i2 = 0; i2 < 11; ++i2) {
            int[] nArray2 = m_playerStorage[n5][i2];
            if (DDMath.calcHorizontalDistSquared(nArray, nArray2) >= n6) continue;
            int n7 = DDMath.calcAngle(nArray, nArray2);
            if (n4 < 128 && DDMath.abs(DDMath.calcTurnAngle(n3, n7)) > n4) continue;
            GameAI.m_passEvalPlayerList[GameAI.m_passEvalPlayerListCount * 2 + 0] = i2;
            GameAI.m_passEvalPlayerList[GameAI.m_passEvalPlayerListCount * 2 + 1] = n7;
            ++m_passEvalPlayerListCount;
        }
    }

    private static void setPassTargetPositionInSpace(int[] nArray, int n2) {
        int n3 = GameAI.playerEstimatePotentialMoveDist(nArray, nArray[22], n2, 256);
        n3 = DDMath.max(n3, GameLogic.PASS_INTO_SPACE_MAX_RUN_DIST);
        GameAI.setupPassEvalPlayerList(nArray, n3, 0, 128);
        int n4 = nArray[12] ^ 1;
        int n5 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < m_passEvalPlayerListCount; ++i2) {
            int[] nArray2 = m_playerStorage[n4][m_passEvalPlayerList[i2 * 2 + 0]];
            int n7 = m_passEvalPlayerList[i2 * 2 + 1] + 128 & 0xFF;
            int n8 = nArray2[0] + (DDMath.sin(n7) * n3 >> 16);
            int n9 = nArray2[1] + (DDMath.cos(n7) * n3 >> 16);
            n5 += n8 - nArray[0];
            n6 += n9 - nArray[1];
        }
        GameAI.m_passTargetObject[0] = nArray[0] + n5;
        GameAI.m_passTargetObject[1] = nArray[1] + n6;
    }

    private static boolean setPassTargetPositionThroughBall(int[] nArray, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        boolean bl2 = false;
        int n13 = nArray[12] ^ 1;
        int n14 = DDMath.min(m_passEvalPlayerListCount, 8);
        for (n12 = 0; n12 < n14; ++n12) {
            int[] nArray2 = m_playerStorage[n13][m_passEvalPlayerList[n12 * 2 + 0]];
            n11 = m_passEvalPlayerList[n12 * 2 + 1];
            n11 = n11 - 64 & 0xFF;
            n10 = GameAI.playerEstimatePotentialMoveDist(nArray2, n11, n2, 256);
            n9 = nArray2[0] + (DDMath.sin(n11) * n10 >> 16);
            n8 = nArray2[1] + (DDMath.cos(n11) * n10 >> 16);
            GameAI.m_throughBallExclusionDirs[n12 * 2 + 0] = DDMath.atan(n9 - nArray[0], n8 - nArray[1]);
            n11 = n11 + 128 & 0xFF;
            n10 = GameAI.playerEstimatePotentialMoveDist(nArray2, n11, n2, 256);
            n9 = nArray2[0] + (DDMath.sin(n11) * n10 >> 16);
            n8 = nArray2[1] + (DDMath.cos(n11) * n10 >> 16);
            GameAI.m_throughBallExclusionDirs[n12 * 2 + 1] = DDMath.atan(n9 - nArray[0], n8 - nArray[1]);
        }
        n12 = n4;
        int n15 = n4;
        n9 = 0;
        do {
            n11 = n12;
            n10 = n15;
            for (n8 = 0; n8 < m_passEvalPlayerListCount && n8 < 8; ++n8) {
                n7 = n8 * 2 + 0;
                n6 = n8 * 2 + 1;
                if (DDMath.angleRangeCheck(n12, m_throughBallExclusionDirs[n7], m_throughBallExclusionDirs[n6])) {
                    n12 = m_throughBallExclusionDirs[n7];
                }
                if (!DDMath.angleRangeCheck(n15, m_throughBallExclusionDirs[n7], m_throughBallExclusionDirs[n6])) continue;
                n15 = m_throughBallExclusionDirs[n6];
            }
        } while (n12 != n11 && n15 != n10);
        n8 = DDMath.abs(DDMath.calcTurnAngle(n4, n12));
        n7 = DDMath.abs(DDMath.calcTurnAngle(n4, n15));
        int n16 = n6 = n8 <= n5 || n7 <= n5 ? 1 : 0;
        if (n6 != 0 || bl) {
            int n17 = n6 != 0 ? (n8 < n7 ? n12 : n15) : n4 + DDMath.getRandom() % (n5 / 2);
            GameAI.m_passTargetObject[0] = nArray[0] + (DDMath.sin(n17) * n3 >> 16);
            GameAI.m_passTargetObject[1] = nArray[1] + (DDMath.cos(n17) * n3 >> 16);
            bl2 = true;
        }
        return bl2;
    }

    private static int playerEstimatePotentialMoveDist(int[] nArray, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = nArray[23];
        int n8 = GameAI.playerCalculateRunSpeed(nArray);
        if ((m_animationPassFlags & 6) != 0) {
            n6 += GameRender.animationGetDuration(1) >> 1;
        }
        while (n6 < n3) {
            if (n7 != n4) {
                n7 = GameAI.playerUpdateCurrentSpeed(XMLMenuSystem.getSprintControlType(nArray) == 0, n7, n4, nArray[42]);
                n5 += n7 * n8 >> 8;
            } else {
                n5 += (n7 * n8 >> 8) * (n3 - n6);
                break;
            }
            ++n6;
        }
        return n5;
    }

    public static int playerEstimatePotentialMoveTime(int[] nArray) {
        int n2;
        int n3;
        if ((nArray[17] & 2) != 0) {
            n3 = nArray[25];
            n2 = nArray[26];
        } else if ((nArray[17] & 8) != 0) {
            n3 = Trajectory.getEndX(0);
            n2 = Trajectory.getEndY(0);
        } else if ((nArray[17] & 4) != 0) {
            n3 = m_ballStorage[0];
            n2 = m_ballStorage[1];
        } else if ((nArray[17] & 0x10) != 0) {
            n3 = m_passTargetObject[0];
            n2 = m_passTargetObject[1];
        } else {
            n3 = nArray[15];
            n2 = nArray[16];
        }
        int n4 = n3 - nArray[0];
        int n5 = n2 - nArray[1];
        int n6 = DDMath.sqrtRout(n4 * n4 + n5 * n5);
        int n7 = nArray[23] * GameAI.playerCalculateRunSpeed(nArray) >> 8;
        if (n7 == 0) {
            return 0;
        }
        return n6 / n7;
    }

    private static void CalcDive(int[] nArray, int n2, int n3, int n4, boolean bl) {
        int n5 = nArray[0];
        int n6 = nArray[1];
        int n7 = 0;
        int n8 = 384;
        int n9 = GameRender.animationGetFramesUntilAction(n4);
        int n10 = DDMath.abs((GameLogic.m_setPieceGKTargetObject[0] - (12311 - GameLogic.m_goalWidth / 2)) / (GameLogic.m_goalWidth / 3));
        n10 = DDMath.min(n10, 2);
        if (n2 == 1 || n2 == 3) {
            if ((n3 & 0x400) != 0) {
                n8 = 512;
                n9 *= 2;
                n9 = DDMath.min(n9, GameRender.animationGetDuration(n4));
            }
            if (!GameLogic.m_useGKDivePosition && (n3 & 0x100) != 0 || GameLogic.m_useGKDivePosition && n10 == 0) {
                n5 -= n8;
            } else if (!GameLogic.m_useGKDivePosition && (n3 & 0x200) != 0 || GameLogic.m_useGKDivePosition && n10 == 2) {
                n5 += n8;
            }
        } else if (n2 == 2) {
            n8 = 0;
            n9 *= 2;
            n9 = DDMath.min(n9, GameRender.animationGetDuration(n4));
            n7 = m_shotTargetObject[2] - 486;
            if (n4 == 53) {
                n7 = m_shotTargetObject[2] - 543;
            }
            n7 = DDMath.max(n7, 0);
        }
        n9 = DDMath.max(n9, 1);
        Trajectory.setupTrajectory(nArray, 1, n9, nArray[0], nArray[1], 0, n5, n6, n7, 0, 0);
    }

    public static final void setupRunOntoBall(int[] nArray, int n2) {
        m_playerRunningOntoBall = nArray;
        m_runOntoBallAction = n2;
        m_runOntoBallTimer = GameLogic.RUN_ONTO_BALL_TIMEOUT;
    }

    public static int calculateNearestAnimationDirection(int n2, int n3) {
        int n4 = -1;
        int n5 = 0;
        int n6 = (n3 + 16 & 0xFF) >> 5;
        do {
            if (GameRender.playersAnimFrameSequences[n2][n6 + n5 & 7] != null) {
                return n6 + n5 & 7;
            }
            if (GameRender.playersAnimFrameSequences[n2][n6 - n5 & 7] != null) {
                return n6 - n5 & 7;
            }
            ++n5;
        } while (n4 == -1);
        return n6;
    }

    public static int[] getPassTarget(int[] nArray) {
        int n2;
        if (nArray != null && (n2 = nArray[32]) != -1) {
            return m_playerStorage[nArray[12]][n2];
        }
        return null;
    }

    public static int[] getPassTargetAlternate(int[] nArray) {
        int n2;
        if (nArray != null && (n2 = nArray[33]) != -1) {
            return m_playerStorage[nArray[12]][n2];
        }
        return null;
    }

    public static final void setPassTarget(int[] nArray, int[] nArray2) {
        nArray[32] = nArray2 == null ? -1 : nArray2[9];
    }

    public static final void setPassTargetLong(int[] nArray, int[] nArray2) {
        nArray[33] = nArray2[9];
    }

    public static final void playerUpdatePassTargetsHeader(int[] nArray) {
        int n2 = nArray[22];
        nArray[22] = DDMath.getPositiveRandom() % 100 < 50 ? 64 : 192;
        int[] nArray2 = GameLogic.nearestPlayerData(nArray, nArray[12], 4);
        nArray[22] = n2;
        if (nArray2 == null || nArray2[36] > 50) {
            nArray2 = GameLogic.nearestPlayerData(nArray, nArray[12], 0, m_playerStorage[nArray[12]][0], null);
        }
        if (nArray2 != null) {
            nArray[32] = nArray2[9];
        }
    }

    private static final int[] playerUpdatePassTargetsCross(int[] nArray, int n2) {
        if (GameAI.getPassTargetAlternate(nArray) != null && GameAI.isPlayerValidCrossingTarget(nArray, GameAI.getPassTargetAlternate(nArray))) {
            return GameAI.getPassTargetAlternate(nArray);
        }
        for (int i2 = 1; i2 < 11; ++i2) {
            int[] nArray2 = m_playerStorage[n2][i2];
            if (nArray2 == nArray || nArray2[49] == 2 || !GameAI.isPlayerValidCrossingTarget(nArray, nArray2)) continue;
            return nArray2;
        }
        return null;
    }

    public static final void playerUpdatePassTargets(int[] nArray) {
        int[] nArray2;
        int n2;
        int n3;
        if (nArray[34] > 0 || nArray == GameLogic.m_lockPassTargetsPlayer && (nArray[32] != -1 || nArray[33] != -1) || GameLogic.m_controller[nArray[12]].m_passBall) {
            return;
        }
        boolean bl = nArray == m_playerWithBall;
        int n4 = nArray[12];
        int n5 = nArray[32];
        int n6 = nArray[33];
        nArray[32] = -1;
        nArray[33] = -1;
        int n7 = Integer.MAX_VALUE;
        int n8 = Integer.MAX_VALUE;
        int n9 = nArray[22];
        if (bl && GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(n4)) || nArray[28] == 10) {
            int n10 = 12311 - nArray[0];
            int n11 = GameAI.teamGetPitchSide(n4) == 1 ? 1543 - nArray[1] : 30472 - nArray[1];
            n9 = DDMath.atan(n10, n11);
        }
        for (n3 = 0; n3 < 11; ++n3) {
            int[] nArray3 = m_playerStorage[n4][n3];
            if (nArray3 == nArray || nArray3[49] == 2 || (GameLogic.m_controller[n4].m_playerLastPass == null || GameLogic.m_controller[n4].m_playerLastPass == nArray3) && GameLogic.m_controller[n4].m_playerLastPass != null) continue;
            int n12 = DDMath.calcTurnAngle(n9, nArray3[35] + 128 & 0xFF);
            int n13 = DDMath.abs(n12);
            int n14 = nArray3[36];
            int n15 = 1024 * n14 + 256 * n12;
            if (n14 < 30) {
                if (n13 >= 56 || n15 >= n7) continue;
                n7 = n15;
                nArray[32] = nArray3[9];
                continue;
            }
            if (n14 >= 60 || nArray3[9] == 0 || n13 >= 32 || n15 >= n8) continue;
            nArray[33] = nArray3[9];
        }
        if (nArray[32] == -1 && nArray[33] == -1 && GameLogic.m_controller[n4].m_playerLastPass != null && GameLogic.m_controller[n4].m_playerLastPass[49] != 2 && (n2 = DDMath.abs(n3 = DDMath.calcTurnAngle(n9, GameLogic.m_controller[n4].m_playerLastPass[35] + 128 & 0xFF))) < 56) {
            nArray[32] = GameLogic.m_controller[n4].m_playerLastPass[9];
        }
        if (!(nArray[32] == n5 && nArray[33] == n6 || nArray[32] == -1 && nArray[33] == -1)) {
            nArray[34] = GameLogic.PASS_TARGET_UPDATE_DELAY;
        }
        if (GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(n4)) && GameAI.getPassTargetAlternate(nArray) != null && !GameAI.isPlayerValidCrossingTarget(nArray, GameAI.getPassTargetAlternate(nArray)) && (nArray2 = GameAI.playerUpdatePassTargetsCross(nArray, n4)) != null) {
            nArray[33] = nArray2[9];
        }
    }

    public static final void playerUpdatePassTargetsForShortPass(int[] nArray) {
        int n2;
        int n3;
        boolean bl = nArray == m_playerWithBall;
        int n4 = nArray[12];
        int n5 = nArray[32];
        int n6 = nArray[33];
        nArray[32] = -1;
        nArray[33] = -1;
        int n7 = Integer.MAX_VALUE;
        int n8 = Integer.MAX_VALUE;
        int n9 = nArray[22];
        for (n3 = 0; n3 < 11; ++n3) {
            int[] nArray2 = m_playerStorage[n4][n3];
            if (nArray2 == nArray || nArray2[49] == 2 || (GameLogic.m_controller[n4].m_playerLastPass == null || GameLogic.m_controller[n4].m_playerLastPass == nArray2) && GameLogic.m_controller[n4].m_playerLastPass != null) continue;
            int n10 = DDMath.calcTurnAngle(n9, nArray2[35] + 128 & 0xFF);
            int n11 = DDMath.abs(n10);
            int n12 = nArray2[36];
            int n13 = 1024 * n12 + 64 * n10;
            if (n12 < 30) {
                if (n11 >= 56 || n13 >= n7) continue;
                n7 = n13;
                nArray[32] = nArray2[9];
                continue;
            }
            if (n12 >= 60 || nArray2[9] == 0 || n11 >= 32 || n13 >= n8) continue;
            nArray[33] = nArray2[9];
        }
        if (nArray[32] == -1 && nArray[33] == -1 && GameLogic.m_controller[n4].m_playerLastPass != null && GameLogic.m_controller[n4].m_playerLastPass[49] != 2 && (n2 = DDMath.abs(n3 = DDMath.calcTurnAngle(n9, GameLogic.m_controller[n4].m_playerLastPass[35] + 128 & 0xFF))) < 56) {
            nArray[32] = GameLogic.m_controller[n4].m_playerLastPass[9];
        }
    }

    public static final void playerUpdateQuickPlayMomentlongPassTarget(int[] nArray) {
        int n2 = nArray[12];
        int n3 = nArray[33];
        nArray[32] = -1;
        nArray[33] = -1;
        int n4 = Integer.MAX_VALUE;
        int n5 = nArray[22];
        if (GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(nArray[12])) || nArray[28] == 10) {
            int n6 = 12311 - nArray[0];
            int n7 = GameAI.teamGetPitchSide(n2) == 1 ? 1543 - nArray[1] : 30472 - nArray[1];
            n5 = DDMath.atan(n6, n7);
        }
        for (int i2 = 0; i2 < 11; ++i2) {
            int[] nArray2 = m_playerStorage[n2][i2];
            if (nArray2 == nArray || nArray2[49] == 2) continue;
            boolean bl = true;
            boolean bl2 = GameLogic.isPlayerOffside(nArray2);
            if (GameAI.teamGetPitchSide(n2) == 1) {
                if (nArray2[1] > nArray[1]) {
                    bl = false;
                }
            } else if (nArray2[1] < nArray[1]) {
                bl = false;
            }
            if (!bl || bl2) continue;
            int n8 = GameLogic.m_foulxpos;
            int n9 = GameLogic.m_foulypos;
            int n10 = n8 - nArray[0];
            int n11 = n9 - nArray[1];
            nArray2[35] = DDMath.atan(n10, n11) & 0xFF;
            int n12 = DDMath.calcTurnAngle(n5, nArray2[35] + 128 & 0xFF);
            int n13 = nArray2[36];
            int n14 = 1024 * n13 + 256 * n12;
            if (n13 >= 60 || nArray2[9] == 0 || n14 >= n4) continue;
            nArray[33] = nArray2[9];
        }
        if (nArray[33] == -1) {
            nArray[33] = n3;
        }
    }

    public static int passTargetGetHeightFromPassFlags(int n2) {
        int n3 = 0;
        n3 = (n2 & 8) != 0 && GameLogic.m_controller[GameLogic.m_possession].m_longPass ? 217 : ((n2 & 2) != 0 ? 384 : ((n2 & 0x804) != 0 ? 486 : ((n2 & 0x4000) != 0 ? 256 : ((n2 & 0x400) != 0 ? 486 + (GameLogic.PLAYER_JUMP_VELOCITY >> 1) : ((n2 & 0x10080) != 0 ? 540 : ((n2 & 0x200) != 0 ? 128 : 0))))));
        return n3;
    }

    private static final int passIntoSpaceIsPassTargetBlocked(int[] nArray, int[] nArray2) {
        if (GameLogic.m_gameMode == 2) {
            return -1;
        }
        int n2 = GameLogic.m_possession ^ 1;
        DDMath.m_vertices[0][0] = nArray[0];
        DDMath.m_vertices[0][1] = nArray[1];
        DDMath.m_vertices[1][0] = nArray2[0];
        DDMath.m_vertices[1][1] = nArray2[1];
        int n3 = DDMath.abs(DDMath.calcHorizontalDistSquared(nArray, nArray2));
        int n4 = 1024960225;
        int n5 = -1;
        int n6 = -1;
        for (int i2 = 1; i2 < 11; ++i2) {
            int n7;
            int[] nArray3 = m_playerStorage[n2][i2];
            int n8 = DDMath.abs(DDMath.calcHorizontalDistSquared(nArray3, nArray));
            if (n8 < 589824) continue;
            int n9 = DDMath.sqrtRout(n8) - 768;
            n9 = DDMath.restrictRange(n9, 0, 5120);
            int n10 = n9 * 100 / 4352;
            int n11 = 512 + 1024 * n10 / 100;
            if (DDMath.abs(DDMath.calcHorizontalDistSquared(nArray3, nArray2)) >= n3) continue;
            DDMath.m_vertices[2][0] = nArray3[0] - n11;
            DDMath.m_vertices[2][1] = nArray3[1];
            DDMath.m_vertices[3][0] = nArray3[0] + n11;
            DDMath.m_vertices[3][1] = nArray3[1];
            boolean bl = false;
            if (DDMath.intersection(0)) {
                bl = true;
            }
            if (!bl) {
                DDMath.m_vertices[2][0] = nArray3[0];
                DDMath.m_vertices[2][1] = nArray3[1] - n11;
                DDMath.m_vertices[3][0] = nArray3[0];
                DDMath.m_vertices[3][1] = nArray3[1] + n11;
                if (DDMath.intersection(0)) {
                    bl = true;
                }
            }
            if (!bl || (n7 = DDMath.abs(DDMath.calcHorizontalDistSquared(nArray3, nArray2))) >= n4) continue;
            n6 = n11;
            n4 = n7;
            n5 = i2;
        }
        if (n6 >= 0) {
            m_passIntoSpaceEnemyDangerRadius = n6;
        }
        return n5;
    }

    private static final void passIntoSpaceUpdateTargetPositions(int[] nArray, int[] nArray2) {
        int n2;
        int n3 = DDMath.calcAngle(nArray, nArray2);
        int n4 = DDMath.calcHorizontalDist(nArray, nArray2);
        int n5 = nArray[0] + (DDMath.sin(n3 + 16) * n4 >> 16);
        int n6 = nArray[1] + (DDMath.cos(n3 + 16) * n4 >> 16);
        int n7 = nArray[0] + (DDMath.sin(n3 - 16) * n4 >> 16);
        int n8 = nArray[1] + (DDMath.cos(n3 - 16) * n4 >> 16);
        int n9 = 12311;
        int n10 = GameAI.teamGetPitchSide(GameLogic.m_possession) == 0 ? 32015 : 0;
        int n11 = DDMath.calcHorizontalDistSquared(n5, n6, n9, n10);
        if (n11 < (n2 = DDMath.calcHorizontalDistSquared(n7, n8, n9, n10))) {
            m_passIntoSpaceGoalSidePositionX = n5;
            m_passIntoSpaceGoalSidePositionY = n6;
            m_passIntoSpaceDefenceSidePositionX = n7;
            m_passIntoSpaceDefenceSidePositionY = n8;
        } else {
            m_passIntoSpaceGoalSidePositionX = n7;
            m_passIntoSpaceGoalSidePositionY = n8;
            m_passIntoSpaceDefenceSidePositionX = n5;
            m_passIntoSpaceDefenceSidePositionY = n6;
        }
        if (m_passIntoSpaceGoalSidePositionX < 768 || m_passIntoSpaceGoalSidePositionX > 23854 || m_passIntoSpaceGoalSidePositionY < 768 || m_passIntoSpaceGoalSidePositionY > 31247) {
            m_passIntoSpaceGoalSidePositionX = nArray2[0];
            m_passIntoSpaceGoalSidePositionY = nArray2[1];
        }
        if (m_passIntoSpaceDefenceSidePositionX < 768 || m_passIntoSpaceDefenceSidePositionX > 23854 || m_passIntoSpaceDefenceSidePositionY < 768 || m_passIntoSpaceDefenceSidePositionY > 31247) {
            m_passIntoSpaceDefenceSidePositionX = nArray2[0];
            m_passIntoSpaceDefenceSidePositionY = nArray2[1];
        }
    }

    public static boolean playersFacingEachOther(int[] nArray, int[] nArray2) {
        return DDMath.CalcModDifference(nArray[22], nArray2[22] - 128 & 0xFF) < 21;
    }

    public static int grappleCalculateAIDribbleDirection(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        if (--m_lastdribbleTimer <= 0) {
            m_lastdribbleDir = n4 = nArray[22] + DDMath.getRandom() % 21;
            m_lastdribbleTimer = 15;
        } else {
            n4 = m_lastdribbleDir;
        }
        int n5 = DDMath.calcAngle(nArray, nArray2);
        if (DDMath.calcHorizontalDistSquared(nArray, nArray2) < 262144) {
            n5 = nArray[22] + (DDMath.calcTurnAngle(nArray[22], n5) > 0 ? 1 : -1) * 64;
        }
        if (DDMath.angleRangeCheck(n4, n3 = n5 - 49 & 0xFF, n2 = n5 + 49 & 0xFF)) {
            int n6 = nArray[22];
            n4 = DDMath.CalcModDifference(n3, n6) < DDMath.CalcModDifference(n2, n6) ? n3 : n2;
        }
        return n4;
    }

    public static final void grappleUpdateGrapplingAnimationFlags(int[] nArray, int[] nArray2) {
        int n2 = DDMath.calcHorizontalDistSquared(nArray, nArray2);
        nArray[6] = nArray[6] & 0xFFFFFFF3;
        if (n2 < 262144) {
            int n3;
            int n4;
            if (nArray[28] == 139 && nArray2[28] == 138) {
                nArray[22] = nArray2[22];
            }
            if ((n4 = DDMath.CalcModDifference(n3 = DDMath.calcAngle(nArray, nArray2), nArray[22])) > 32 && n4 < 96) {
                if (DDMath.calcTurnAngle(nArray[22], n3) < 0) {
                    nArray[6] = nArray[6] | 8;
                    nArray[23] = nArray[23] - 1;
                } else {
                    nArray[6] = nArray[6] | 4;
                    nArray[23] = nArray[23] - 1;
                }
            }
        }
    }

    public static final boolean grappleCheckIfDribblerShouldBreakAwayFromTarget(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        int n5 = nArray[22];
        int n6 = nArray2[22];
        int n7 = nArray[14];
        if (DDMath.CalcModDifference(n7, n5) > 60 && DDMath.CalcModDifference(n5, n6) > 56) {
            bl = true;
        }
        if (nArray2[28] == 71 || nArray2[28] == 0) {
            bl = true;
        }
        if ((n4 = (n3 = nArray[0] - nArray2[0]) * n3 + (n2 = nArray[1] - nArray2[1]) * n2) > 268800) {
            return true;
        }
        return bl;
    }

    public static final void markingSetMoveTargetPosition(int[] nArray, int[] nArray2) {
        if (!GameAI.markingIsTargetShieldingTheRunToOrJockeyPos(nArray, nArray2, false)) {
            if (!GameAI.markingIsTargetShieldingTheRunToOrJockeyPos(nArray, nArray2, true)) {
                nArray[15] = m_ballToGoalMarkerRunToPosJockeyX;
                nArray[16] = m_ballToGoalMarkerRunToPosJockeyY;
            } else {
                nArray[15] = m_ballToGoalMarkerRunToPosX;
                nArray[16] = m_ballToGoalMarkerRunToPosY;
            }
        } else if (DDMath.calcHorizontalDistSquared(m_ballStorage, m_MarkerRunWidePosToUseX, m_MarkerRunWidePosToUseY) < DDMath.calcHorizontalDistSquared(m_ballToGoalMarkerRunToPosX, m_ballToGoalMarkerRunToPosY, m_MarkerRunWidePosToUseX, m_MarkerRunWidePosToUseY)) {
            nArray[15] = m_markTargetFacingAwayFromGoalRunToPosX;
            nArray[16] = m_markTargetFacingAwayFromGoalRunToPosY;
        } else {
            nArray[15] = m_MarkerRunWidePosToUseX;
            nArray[16] = m_MarkerRunWidePosToUseY;
        }
    }

    public static final boolean markingIsTargetShieldingTheRunToOrJockeyPos(int[] nArray, int[] nArray2, boolean bl) {
        int n2;
        int n3;
        if (bl) {
            n3 = m_ballToGoalMarkerRunToPosJockeyX;
            n2 = m_ballToGoalMarkerRunToPosJockeyY;
        } else {
            n3 = m_ballToGoalMarkerRunToPosX;
            n2 = m_ballToGoalMarkerRunToPosY;
        }
        if (DDMath.calcHorizontalDistSquared(nArray, n3, n2) < DDMath.calcHorizontalDistSquared(nArray2, n3, n2)) {
            return false;
        }
        int n4 = DDMath.calcAngle(n3, n2, nArray2[0], nArray2[1]);
        int n5 = n4 - 64 & 0xFF;
        int n6 = n4 + 64 & 0xFF;
        n4 = DDMath.calcAngle(n3, n2, nArray[0], nArray[1]);
        return DDMath.angleRangeCheck(n4, n5, n6);
    }

    public static final boolean markingIsTargetShieldingTheBall(int[] nArray, int[] nArray2) {
        int n2 = DDMath.calcAngle(m_ballStorage, nArray2);
        int n3 = n2 - 64 & 0xFF;
        int n4 = n2 + 64 & 0xFF;
        n2 = DDMath.calcAngle(m_ballStorage, nArray);
        return DDMath.angleRangeCheck(n2, n3, n4);
    }

    public static final boolean markingIsTargetMovingTowardsPlayer(int[] nArray, int[] nArray2) {
        int n2 = DDMath.calcAngle(nArray2, nArray);
        return DDMath.CalcModDifference(n2, nArray2[22]) < 16;
    }

    public static final int markingGetOneInXChanceOfSettingPlayerIntoMarking(int n2, int[] nArray) {
        int n3 = XMLMenuSystem.teamTacticalOptionsMarkingStyleGet(n2);
        int n4 = 0;
        block0 : switch (GameFormation.getPlayerType(nArray[52])) {
            case 1: {
                switch (n3) {
                    case 2: {
                        n4 = 16;
                        break;
                    }
                    case 1: {
                        n4 = 14;
                        break;
                    }
                    case 0: {
                        n4 = 12;
                    }
                }
                break;
            }
            case 2: {
                switch (n3) {
                    case 2: {
                        n4 = 34;
                        break;
                    }
                    case 1: {
                        n4 = 32;
                        break;
                    }
                    case 0: {
                        n4 = 30;
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        n4 = 48;
                        break block0;
                    }
                    case 1: {
                        n4 = 44;
                        break block0;
                    }
                    case 0: {
                        n4 = 40;
                    }
                }
            }
        }
        n4 = n4 * GameLogic.m_difficultySettingMarkingOneInXChanceOfSettingPlayerToMarkMultiplier / 100;
        return n4;
    }

    public static final void formationOffsetPlayerMovePosition(int[] nArray) {
        int n2 = 2560;
        if (GameLogic.m_possession != nArray[12]) {
            n2 = 640;
        }
        nArray[15] = nArray[25];
        nArray[16] = nArray[26];
        if (nArray[16] > 2560 && nArray[16] < 29455) {
            nArray[15] = nArray[15] + (DDMath.sin(nArray[57]) * n2 >> 16);
            nArray[16] = nArray[16] + (DDMath.cos(nArray[57]) * n2 >> 16);
        }
        GameAI.keepTargetPositionWithinPitch(nArray);
    }

    public static final int findAlternativePassTarget(int[] nArray, int n2) {
        int n3 = 1;
        int n4 = 0x40000000;
        boolean bl = false;
        int n5 = m_ballStorage[10] >> 1;
        for (int i2 = 1; i2 < 11; ++i2) {
            int n6 = m_playerStorage[n2][i2][0];
            int n7 = m_playerStorage[n2][i2][1];
            if (m_playerStorage[n2][i2] == nArray || i2 == n5) continue;
            int n8 = DDMath.calcAngle(nArray, m_ballStorage);
            int n9 = DDMath.calcAngle(nArray, m_playerStorage[n2][i2]);
            if (m_playerStorage[n2][i2][49] == 2 || m_playerStorage[n2][i2][28] == 117 || n9 >= (n8 + 64 & 0xFF) || n9 <= (n8 - 64 & 0xFF) || (n6 = nArray[0] - m_playerStorage[n2][i2][0]) * n6 + (n7 = nArray[1] - m_playerStorage[n2][i2][1]) * n7 >= n4) continue;
            n4 = n6 * n6 + n7 * n7;
            n3 = i2;
            m_playerRunningOntoBall = m_playerStorage[n2][i2];
            m_runOntoBallTimer = GameLogic.RUN_ONTO_BALL_TIMEOUT;
            bl = true;
        }
        if (!bl) {
            n3 = n5;
        }
        return n3;
    }

    private static final int closestPlayerDistToPoint(int n2, int n3, int n4) {
        int n5 = -1;
        for (int i2 = 1; i2 < 11; ++i2) {
            int n6 = m_playerStorage[n4][i2][0];
            int n7 = n6 - n2;
            int n8 = m_playerStorage[n4][i2][1];
            int n9 = n8 - n3;
            int n10 = n7 * n7 + n9 * n9;
            if (n10 >= n5 && n5 != -1) continue;
            n5 = n10;
        }
        return DDMath.sqrtRout(n5);
    }

    public static final void calculateSwerveForPass(int[] nArray, int[] nArray2, int n2) {
        int[] nArray3;
        int n3 = DDMath.calcHorizontalDist(nArray, nArray2);
        int n4 = 4608 * ((n3 << 8) / 11520) >> 8;
        n4 = DDMath.min(n4, 4608);
        n4 = DDMath.max(n4, 512);
        if (GameLogic.m_matchState == 6 || m_crossIsCornerKick) {
            nArray3 = m_ballStorage;
            m_crossIsCornerKick = true;
        } else {
            nArray3 = nArray2;
        }
        int n5 = DDMath.atan(nArray2[0] - nArray[0], nArray2[1] - nArray[1]);
        if (n2 == 3 || n2 == 2) {
            n4 = 0;
            m_ballInSwerveCross = false;
        } else if (n2 == 0) {
            n5 = nArray3[0] < 12311 ? (GameAI.teamGetPitchSide(nArray2[12] ^ 1) == 1 ? (m_crossIsCornerKick ? (n5 -= 64) : (n5 += 64)) : (m_crossIsCornerKick ? (n5 += 64) : (n5 -= 64))) : (GameAI.teamGetPitchSide(nArray2[12] ^ 1) == 1 ? (m_crossIsCornerKick ? (n5 += 64) : (n5 -= 64)) : (m_crossIsCornerKick ? (n5 -= 64) : (n5 += 64)));
            n5 &= 0xFF;
            m_ballInSwerveCross = true;
        } else if (n2 == 1) {
            n5 = nArray3[0] < 12311 ? (GameAI.teamGetPitchSide(nArray2[12] ^ 1) == 1 ? (m_crossIsCornerKick ? (n5 += 64) : (n5 -= 64)) : (m_crossIsCornerKick ? (n5 -= 64) : (n5 += 64))) : (GameAI.teamGetPitchSide(nArray2[12] ^ 1) == 1 ? (m_crossIsCornerKick ? (n5 -= 64) : (n5 += 64)) : (m_crossIsCornerKick ? (n5 += 64) : (n5 -= 64)));
            n5 &= 0xFF;
            m_ballInSwerveCross = true;
        }
        m_calculatedSwerveX = DDMath.sin(n5) * n4 >> 16;
        m_calculatedSwerveY = DDMath.cos(n5) * n4 >> 16;
        m_calculatedSwerveX >>= 2;
        m_calculatedSwerveY >>= 2;
    }

    public static final void calculateSwerveForShot(int[] nArray, int[] nArray2, int n2) {
        int n3 = DDMath.calcHorizontalDist(nArray, nArray2);
        int n4 = 3072 * ((n3 << 8) / 10240) >> 8;
        n4 = DDMath.min(n4, 3072);
        n4 = DDMath.max(n4, 512);
        int n5 = GameAI.teamGetPitchSide(GameLogic.m_possession) == 0 ? 32015 : 0;
        int n6 = DDMath.atan(12311 - nArray2[0], n5 - nArray2[1]);
        if (n2 == 2 || n2 == 3) {
            n4 = 0;
            n4 = 0;
        } else if (n2 == 1) {
            n6 += 128;
            n6 &= 0xFF;
        }
        m_calculatedSwerveX = DDMath.sin(n6) * n4 >> 16;
        m_calculatedSwerveY = DDMath.cos(n6) * n4 >> 16;
    }

    public static final void calculateAttackingPassOffset(int[] nArray, int[] nArray2, int n2) {
        m_calculatedAttackingPassOffsetXDistance = 0;
        m_calculatedAttackingPassOffsetYDistance = 0;
        if (n2 == 0 || n2 == 1) {
            int n3 = GameAI.teamGetPitchSide(GameLogic.m_possession) == 0 ? 32015 : 0;
            int n4 = DDMath.atan(12311 - nArray2[0], n3 - nArray2[1]);
            int n5 = GameAI.calculateAttackingPassOffsetDistance(nArray, nArray2);
            m_calculatedAttackingPassOffsetXDistance = DDMath.sin(n4) * n5 >> 16;
            m_calculatedAttackingPassOffsetYDistance = DDMath.cos(n4) * n5 >> 16;
        }
    }

    public static final int calculateAttackingPassOffsetDistance(int[] nArray, int[] nArray2) {
        int n2 = DDMath.calcHorizontalDist(nArray, nArray2);
        int n3 = 1024 * ((n2 << 8) / 11520) >> 8;
        n3 = DDMath.min(n3, 1024);
        n3 = DDMath.max(n3, 128);
        return n3;
    }

    public static final void calculateFreeKickRunUpPosition(int[] nArray) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (GameLogic.m_setPieceMode == 1) {
            int[] nArray2 = GameLogic.setPieceGetCurrentTarget();
            n4 = DDMath.calcHorizontalDist(nArray, nArray2);
            n2 = DDMath.calcAngle(m_ballStorage, nArray2) + 128 & 0xFF;
            n3 = n4 * 24 >> 8;
            n3 = DDMath.max(n3, 512);
            n3 = DDMath.min(n3, 1536);
            if (GameLogic.m_trajectoryType == 0) {
                n2 += 32;
                n2 &= 0xFF;
            } else if (GameLogic.m_trajectoryType == 1) {
                n2 -= 32;
                n2 &= 0xFF;
            }
        } else if (GameLogic.m_setPieceMode == 0) {
            int[] nArray3 = GameLogic.m_setPieceTargetObject;
            n4 = DDMath.calcHorizontalDist(m_ballStorage, nArray3);
            n2 = DDMath.calcAngle(m_ballStorage, nArray3) + 128 & 0xFF;
            n3 = n4 * 24 >> 8;
            n3 = DDMath.max(n3, 768);
            n3 = DDMath.min(n3, 1792);
            if (GameLogic.m_trajectoryType == 0 || GameLogic.m_trajectoryType == 1) {
                if (GameLogic.m_trajectoryType == 0 && nArray3[0] > 12311 || GameLogic.m_trajectoryType == 1 && nArray3[0] < 12311) {
                    n2 += 32;
                    n2 &= 0xFF;
                } else {
                    n2 -= 32;
                    n2 &= 0xFF;
                }
            }
        }
        nArray[15] = m_ballStorage[0] + (DDMath.sin(n2) * n3 >> 16);
        nArray[16] = m_ballStorage[1] + (DDMath.cos(n2) * n3 >> 16);
        nArray[16] = DDMath.max(nArray[16], 128);
        nArray[16] = DDMath.min(nArray[16], 31887);
    }

    public static final void calculateMovePositionToSideOfPlayer(int[] nArray, int n2, int n3) {
        int n4 = DDMath.calcAngle(nArray, m_ballStorage);
        if (n2 == 0) {
            n4 -= 64;
        } else if (n2 == 1) {
            n4 += 64;
        } else if (n2 == 3) {
            n4 += 128;
        }
        nArray[15] = nArray[0] + (DDMath.sin(n4 &= 0xFF) * n3 >> 16);
        nArray[16] = nArray[1] + (DDMath.cos(n4) * n3 >> 16);
        nArray[21] = nArray[22] = DDMath.atan(nArray[0] - nArray[15], nArray[1] - nArray[16]);
    }

    public static final boolean projectedBallCollisionWithSpecifiedAnimation(int n2, int n3, int n4, int n5) {
        return GameAI.projectedBallCollisionWithSpecifiedAnimation(n2, 0, n3, n4, n5);
    }

    public static final boolean projectedBallCollisionWithSpecifiedAnimation(int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = GameRender.animationGetFramesUntilAction(n2) + n3;
        int n11 = MainFrame.m_inGameFrameRate == 12 && GameAI.ballIsInACross() ? 2 : 1;
        for (int i2 = 0; i2 < n11; ++i2) {
            GameLogic.ballCalculateFutureBallPosition(n10 + i2);
            if (i2 == 0) {
                n7 = GameLogic.m_futureBallObject[0];
                n8 = GameLogic.m_futureBallObject[1];
                n9 = GameLogic.m_futureBallObject[2];
            } else {
                n7 += (GameLogic.m_futureBallObject[0] - n7) / 2;
                n8 += (GameLogic.m_futureBallObject[1] - n8) / 2;
                n9 += (GameLogic.m_futureBallObject[2] - n9) / 2;
            }
            int n12 = n7 - n4;
            n12 *= n12;
            int n13 = n8 - n5;
            n13 *= n13;
            int n14 = 217 + m_ballStorage[7];
            n14 = m_ballInSwerveCross && Trajectory.isBallUnderTrajectoryControl() ? n14 * n14 * n14 : (n14 *= n14);
            if (n12 + n13 > n14 || n9 < n6 - 76 || n9 > n6 + 76) continue;
            return true;
        }
        return false;
    }

    public static final boolean projectedBallCollisionWithDefensiveHeaderAnimation(boolean bl, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = m_ballStorage[0] + m_ballStorage[3] * 3;
        int n9 = m_ballStorage[1] + m_ballStorage[4] * 3;
        int n10 = m_ballStorage[2] + m_ballStorage[5] * 3;
        if (bl) {
            n7 = GameLogic.m_difficultySettingDefensiveHeaderMaxBallHeightHuman;
            n6 = GameLogic.m_difficultySettingDefensiveHeaderMinBallHeightHuman;
            n5 = GameLogic.m_difficultySettingDefensiveHeaderMaxHorizontalDistanceHuman;
        } else {
            n7 = GameLogic.m_difficultySettingDefensiveHeaderMaxBallHeight;
            n6 = GameLogic.m_difficultySettingDefensiveHeaderMinBallHeight;
            n5 = GameLogic.m_difficultySettingDefensiveHeaderMaxHorizontalDistance;
        }
        if (n10 > n7 || n10 < n6) {
            return false;
        }
        int n11 = n8 - n2;
        n11 *= n11;
        int n12 = n9 - n3;
        n12 *= n12;
        int n13 = n5 + m_ballStorage[7];
        n13 = m_ballInSwerveCross && Trajectory.isBallUnderTrajectoryControl() ? n13 * n13 * n13 : (n13 *= n13);
        return n11 + n12 <= n13;
    }

    public static void throughBallUpdate() {
        int[] nArray;
        Controller controller = GameLogic.m_controller[GameLogic.m_possession];
        if (GameLogic.m_matchState == 2 && GameAI.ballIsPossessed() && GameAI.teamGetControlType(GameLogic.m_possession) == 2 && GameAI.playerHasAbilityToPerformAThroughBall(nArray = GameAI.ballGetLastTouchPlayer())) {
            int[] nArray2;
            if (GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer == null || GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer[34] <= 0) {
                controller.resetThroughBallTargets();
            }
            if ((nArray2 = GameAI.getPassTarget(nArray)) != null && GameAI.throughBallDoesTargetHavePotentialForThroughBall(nArray2)) {
                controller.m_throughBallTargetShort = nArray2;
            }
            if ((nArray2 = GameAI.getPassTargetAlternate(nArray)) != null && GameAI.throughBallDoesTargetHavePotentialForThroughBall(nArray2) && !GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(nArray[12]))) {
                GameLogic.calculateNearFarGoalPostPositions(nArray2[12] ^ 1);
                GameAI.playerSetState(nArray2, GameLogic.m_nearGoalPostX, GameLogic.m_nearGoalPostY, 182);
                controller.m_throughBallTargetLong = nArray2;
            }
        }
    }

    public static boolean playerHasAbilityToPerformAThroughBall(int[] nArray) {
        return nArray[43] > 60;
    }

    public static boolean throughBallDoesTargetHavePotentialForThroughBall(int[] nArray) {
        int n2 = DDMath.cos(nArray[14]) >> 16;
        int n3 = (GameLogic.m_offsideline[nArray[12] ^ 1] - nArray[1]) * n2;
        if (n3 < 0 || n3 > 2560) {
            return false;
        }
        return nArray[36] <= 41;
    }

    public static final void calculateMovePositionThatNarrowsTheShotAngle(int[] nArray, int n2) {
        GameLogic.calculateNearFarGoalPostPositions(GameAI.teamGetPitchSide(nArray[12]));
        n2 = DDMath.max(n2, 481);
        nArray[0] = nArray[15] = (GameLogic.m_nearGoalPostX + GameLogic.m_farGoalPostX >> 1) + (DDMath.sin(nArray[35]) * n2 >> 16);
        nArray[1] = nArray[16] = (GameLogic.m_nearGoalPostY + GameLogic.m_farGoalPostY >> 1) + (DDMath.cos(nArray[35]) * n2 >> 16);
        DDMath.max(nArray[15], 320);
        DDMath.min(nArray[15], 24302);
        DDMath.max(nArray[16], 320);
        DDMath.min(nArray[16], 31695);
    }

    private static void sendPlayersToBall() {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int n2 = m_ballStorage[0];
        int n3 = m_ballStorage[1];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray2[0] = -1;
        nArray2[1] = -1;
        for (int i2 = 0; i2 < 2; ++i2) {
            int[] nArray3;
            for (int i3 = 1; i3 < 11; ++i3) {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                if (m_playerStorage[i2][i3][49] == 2 || (n8 = (n7 = (n6 = m_playerStorage[i2][i3][0]) - n2) * n7 + (n5 = (n4 = m_playerStorage[i2][i3][1]) - n3) * n5) >= nArray[i2] && nArray[i2] != -1) continue;
                nArray[i2] = n8;
                nArray2[i2] = i3;
            }
            if (nArray2[i2] == -1 || (nArray3 = m_playerStorage[i2][nArray2[i2]])[28] != 0 && nArray3[28] != 71 && nArray3[28] != 10) continue;
            GameAI.playerSetState(nArray3, n2, n3, 34);
        }
    }

    public static final int keeperCalculateDiveDirection(int[] nArray) {
        DDMath.m_vertices[0][0] = m_ballStorage[0] >> 8;
        DDMath.m_vertices[0][1] = m_ballStorage[1] >> 8;
        DDMath.m_vertices[1][0] = m_shotTargetObject[0] >> 8;
        DDMath.m_vertices[1][1] = m_shotTargetObject[1] >> 8;
        DDMath.m_vertices[2][0] = 0;
        DDMath.m_vertices[2][1] = nArray[1] >> 8;
        DDMath.m_vertices[3][0] = 24622;
        DDMath.m_vertices[3][1] = nArray[1] >> 8;
        DDMath.intersection(0);
        if (nArray[0] - (DDMath.m_intersectionPointObject[0] << 8) > 0) {
            return 256;
        }
        return 512;
    }

    public static final boolean keeperGrabbedBall() {
        int[] nArray = GameAI.ballGetLastTouchPlayer();
        return GameAI.ballGetLastTouchPlayerID() == 0 && (nArray[28] == 29 || nArray[28] == 15 || nArray[28] == 90 || nArray[28] == 80 || nArray[28] == 27 || nArray[28] == 179 || nArray[28] == 181 || nArray[28] == 188 || nArray[28] == 189);
    }

    public static byte[] bluetoothGetDataToTransmit() {
        return null;
    }

    public static final void bluetoothUpdateData(byte[] byArray) {
    }

    private static byte bluetoothCalcPlayerDataChecksum() {
        return 0;
    }

    private static int checkAITackle(int n2, int n3) {
        GameLogic.m_controller[n3].m_microGameTackle = true;
        int n4 = DDMath.abs(DDMath.getRandom() % 100);
        int n5 = n4 * 40 / 100 + n2 * 60 / 100;
        if (n5 >= 75) {
            return 2;
        }
        if ((DDMath.getRandom() & 1) == 0) {
            return 1;
        }
        return 3;
    }

    public static void forceSlideTackleNearEdgeOfPitchTest() {
        int[] nArray;
        GameLogic.setState(2, -1, -1, -1);
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 1; i3 < 11; ++i3) {
                nArray = m_playerStorage[i2][i3];
                GameAI.objectSetPosition(nArray, 12311, GameAI.teamGetPitchSide(i2) == 0 ? 0 : 32015, 0);
                GameAI.playerSetState(nArray, 0, 0, 0);
                nArray[6] = 0;
            }
        }
        GameRender.m_cameraJumpToPosition = true;
        nArray = m_playerStorage[1][8];
        GameAI.objectSetPosition(nArray, 23342, 17287, 0);
        GameAI.objectSetPosition(m_ballStorage, 23598, 16519, 0);
        GameLogic.m_controller[1].setControlPlayer(nArray);
        GameAI.teamSetPossession(nArray, m_teamStorage[1], 0);
        nArray[23] = 256;
        nArray = m_playerStorage[0][5];
        GameAI.objectSetPosition(nArray, 22830, 16775, 0);
        nArray[21] = 64;
        nArray[22] = 64;
        nArray[23] = 256;
        GameLogic.m_controller[0].setControlPlayer(nArray);
        GameAI.playerSetState(nArray, 0, 0, 91);
    }

    static {
        m_setPieceTakers = new int[]{2, 3, 4};
        m_displayPassTrajectory = false;
        debugShotTypeCheatOn = false;
        m_ballInSwerveCross = false;
        m_crossIsCornerKick = false;
        freeballcounter = 0;
        m_tempStorage = new int[9];
        m_lastdribbleTimer = 0;
        chestactiondone = false;
        PLAYERRATING_THRESHOLDS = new int[]{20, 32, 45, 64, 81, 96};
        PLAYERRATING_CLEANSHEET_BONUS = new int[]{13, 10, 10, 0};
        PLAYERRATING_GOALS_CONCEDED_PENALTY = new int[]{10, 7, 0, 0};
        PLAYERRATING_GOALS_CONCEDED_MAXPENALTY = new int[]{30, 21, 0, 0};
        PLAYERRATING_PASS_BONUS = new int[]{0, 2, 5, 3};
        PLAYERRATING_PASS_MAXBONUS = new int[]{0, 10, 20, 15};
        PLAYERRATING_TACKLESWON_BONUS = new int[]{0, 5, 5, 3};
        PLAYERRATING_TACKLESWON_MAXBONUS = new int[]{0, 20, 15, 10};
        PLAYERRATING_SHOT_ONTARGET_BONUS = new int[]{0, 5, 5, 6};
        PLAYERRATING_SHOT_OFFTARGET_BONUS = new int[]{0, 2, 2, 2};
        PLAYERRATING_SHOTS_MAXBONUS = new int[]{0, 10, 15, 18};
        PLAYERRATING_GOAL_SCORED_BONUS = new int[]{0, 10, 10, 10};
        PLAYERRATING_GOAL_SCORED_MAXBONUS = new int[]{0, 30, 30, 30};
        PLAYERRATING_OWNGOAL_PENALTY = new int[]{0, 10, 10, 10};
        PLAYERRATING_OWNGOAL_MAXPENALTY = new int[]{0, 20, 20, 20};
        PLAYERRATING_LOST_BALL_PENALTY = new int[]{0, 10, 8, 5};
        PLAYERRATING_LOST_BALL_MAXPENALTY = new int[]{0, 20, 15, 10};
        PLAYERRATING_FOUL_PENALTY = new int[]{0, 8, 5, 4};
        PLAYERRATING_FOUL_MAXPENALTY = new int[]{0, 15, 10, 8};
        diveAtFeetDribbler = null;
        kickedball = false;
        calculatedfinalposition = false;
        theOneWhoShoot = null;
        shootingPlayerFrameCnt = 0;
        m_tempPlayer = new int[80];
        m_throwAwayObject = new int[9];
    }
}

