/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDFile;
import com.ea.game.GameRender;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKUtils;

class DDImage {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 1;
    public static final int TRANS_ROT270 = 2;
    public static final int G_TOP = 16;
    public static final int G_BOTTOM = 32;
    public static final int G_LEFT = 4;
    public static final int G_HCENTER = 1;
    public static final int G_RIGHT = 8;
    public static final int G_VCENTER = 2;
    private static final int HD_CHUNK = 0;
    private static final int FR_CHUNK = 1;
    private static final int FM_CHUNK = 2;
    private static final int F_CHUNK = 3;
    private static final int S_CHUNK = 4;
    private static final int D_CHUNK = 5;
    private static final int O_CHUNK = 6;
    private static final int FH_CHUNK = 7;
    private static final int FA_CHUNK = 8;
    private static final int FU_CHUNK = 9;
    private static final int NUM_CHUNK = 10;
    private static final int BINFILE_HEADER_STRUCTLEN = 4;
    private static final int CHUNK_HEADER_STRUCTLEN = 4;
    private static final int HD_CHUNK_NUMFRAMES = 0;
    private static final int HD_CHUNK_NUMMAPFRAMES = 2;
    private static final int HD_CHUNK_NUMIMAGES = 4;
    private static final int HD_CHUNK_FLAGS = 5;
    private static final int HD_CHUNK_STRUCTLEN = 6;
    private static final int FM_CHUNK_ORIGINAL = 0;
    private static final int FM_CHUNK_ACTUAL = 2;
    private static final int FM_CHUNK_STRUCTLEN = 4;
    private static final int FR_CHUNK_NUMSUBFRAMES = 0;
    private static final int FR_CHUNK_STRUCTLEN = 1;
    private static final int FH_CHUNK_SPACEWIDTH = 0;
    private static final int FH_CHUNK_CHARSPACING = 1;
    private static final int FH_CHUNK_UNICODECHARCOUNT = 2;
    private static final int FH_CHUNK_FONTWIDTH = 4;
    private static final int FH_CHUNK_FONTHEIGHT = 5;
    private static final int FH_CHUNK_FONTBASELINE = 6;
    private static final int FH_CHUNK_STRUCTLEN = 7;
    private static final int UTF8_FONTFORMAT1_ASCIICOUNT = 96;
    private static final int UTF8_FONTFORMAT1_ASCIIRANGESTART = 32;
    private static final int UTF8_FONTFORMAT1_ASCIIRANGEEND = 128;
    private static final int SUBFRAME_SHORT0_LO = 0;
    private static final int SUBFRAME_SHORT0_HI = 1;
    private static final int SUBFRAME_SHORT1_LO = 2;
    private static final int SUBFRAME_SHORT1_HI = 3;
    private static final int SUBFRAME_BYTE0 = 0;
    private static final int SUBFRAME_BYTE1 = 1;
    private static final int SUBFRAME_HFLIP_SHIFT = 7;
    private static final int SUBFRAME_VFLIP_SHIFT = 6;
    private static final int SUBFRAME_NUM_MASK = 31;
    private static final int BYTES_SF_BYTEDATA = 2;
    private static final int BYTES_SF_SHORTDATA = 4;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VERBOSE = false;
    private static final char[][] m_chunkIDs = new char[][]{{'H', 'D'}, {'F', 'R'}, {'F', 'M'}, {'F', 'b'}, {'S', 'b'}, {'D', 'b'}, {'O', 'b'}, {'f', 'H'}, {'f', 'A'}, {'f', 'U'}};
    private static final int MAX_FILENAME = 32;
    private static StringBuffer m_filename = new StringBuffer(32);
    public SDKImage[][] m_images = null;
    private byte[] m_spriteData = null;
    private short[] m_frameOffsets = null;
    private int[] m_chunkOffsets = null;
    private byte[] m_chunkDataSize = null;
    private short[] m_frameWidths = null;
    public int m_numImages = 0;
    private int m_numFrames = 0;
    public int m_numPalettes = 0;
    private Object m_eaFont = null;
    public static int m_landscapeARGBSrcDimensions;
    public static int m_landscapeDrawingMode;

    public static int calcEAJust(int n2) {
        return n2;
    }

    public void dispose() {
        if (this.m_images != null) {
            for (int i2 = 0; i2 < this.m_numPalettes; ++i2) {
                for (int i3 = 0; i3 < this.m_numImages; ++i3) {
                    this.m_images[i2][i3] = null;
                }
                this.m_images[i2] = null;
            }
        }
        this.m_images = null;
        this.m_spriteData = null;
        this.m_frameOffsets = null;
        this.m_chunkOffsets = null;
        this.m_chunkDataSize = null;
        this.m_frameWidths = null;
        this.m_eaFont = null;
        System.gc();
    }

    public static DDImage createSprite(String string) {
        DDImage dDImage = new DDImage();
        if (!DDImage.loadSpriteData(string, dDImage, null, 0, 0, 0, false)) {
            dDImage = null;
            System.gc();
        }
        return dDImage;
    }

    public static DDImage createSprite(String string, byte[] byArray, int n2, int n3, int n4, boolean bl) {
        DDImage dDImage = new DDImage();
        if (!DDImage.loadSpriteData(string, dDImage, byArray, n2, n3, n4, bl)) {
            dDImage = null;
            System.gc();
        }
        return dDImage;
    }

    public static DDImage createSprite(String string, byte[] byArray, byte[] byArray2, int n2, int n3, int n4, boolean bl) {
        DDImage dDImage = new DDImage();
        if (!DDImage.loadSpriteData(string, dDImage, byArray, byArray2, n2, n3, n4, bl)) {
            dDImage = null;
            System.gc();
        }
        return dDImage;
    }

    public int getFrameCount() {
        if (this.m_spriteData == null || this.m_eaFont != null) {
            return 1;
        }
        return this.m_numFrames;
    }

    public int getFrameWidth(int n2) {
        int n3 = -1;
        if (n2 >= 0 && n2 <= this.m_numFrames && this.m_numImages > 0) {
            if (this.m_spriteData == null || this.m_eaFont != null) {
                n3 = this.m_images[0][0].getWidth();
            } else if (this.m_frameWidths != null) {
                n3 = this.m_frameWidths[n2];
            } else {
                int n4 = this.m_spriteData[this.m_chunkOffsets[1] + n2 * 1 + 0] & 0x1F;
                int n5 = this.m_chunkOffsets[5] + this.m_frameOffsets[n2] * this.m_chunkDataSize[5];
                int n6 = this.m_chunkOffsets[6] + this.m_frameOffsets[n2] * this.m_chunkDataSize[6];
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n10;
                    if (this.m_chunkDataSize[5] == 4) {
                        n10 = (this.m_spriteData[n5 + 0] & 0xFF | (this.m_spriteData[n5 + 1] & 0xFF) << 8) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n9 = this.m_spriteData[n6 + 0] & 0xFF | this.m_spriteData[n6 + 1] << 8;
                        }
                    } else {
                        n10 = (this.m_spriteData[n5 + 0] & 0xFF) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n9 = this.m_spriteData[n6 + 0];
                        }
                    }
                    if (i2 == 0 || n9 < n8) {
                        n8 = n9;
                    }
                    if (i2 == 0 || n9 + n10 > n7) {
                        n7 = n9 + n10;
                    }
                    n5 += this.m_chunkDataSize[5];
                    n6 += this.m_chunkDataSize[6];
                }
                n3 = n7 - n8;
            }
        }
        return n3;
    }

    public int getFrameHeight(int n2) {
        int n3 = -1;
        if (n2 >= 0 && n2 <= this.m_numFrames && this.m_numImages > 0) {
            if (this.m_spriteData == null || this.m_eaFont != null) {
                n3 = this.m_images[0][0].getHeight();
            } else {
                int n4 = this.m_spriteData[this.m_chunkOffsets[1] + n2 * 1 + 0] & 0x1F;
                int n5 = this.m_chunkOffsets[5] + this.m_frameOffsets[n2] * this.m_chunkDataSize[5];
                int n6 = this.m_chunkOffsets[6] + this.m_frameOffsets[n2] * this.m_chunkDataSize[6];
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n10;
                    if (this.m_chunkDataSize[4] == 4) {
                        n10 = (this.m_spriteData[n5 + 2] & 0xFF | (this.m_spriteData[n5 + 3] & 0xFF) << 8) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n9 = this.m_spriteData[n6 + 2] & 0xFF | this.m_spriteData[n6 + 3] << 8;
                        }
                    } else {
                        n10 = (this.m_spriteData[n5 + 1] & 0xFF) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n9 = this.m_spriteData[n6 + 1];
                        }
                    }
                    if (i2 == 0 || n9 < n8) {
                        n8 = n9;
                    }
                    if (i2 == 0 || n9 + n10 > n7) {
                        n7 = n9 + n10;
                    }
                    n5 += this.m_chunkDataSize[5];
                    n6 += this.m_chunkDataSize[6];
                }
                n3 = n7 - n8;
            }
        }
        return n3;
    }

    public int getLargestFrame(boolean bl) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.getFrameCount(); ++i2) {
            int n3 = bl ? this.getFrameWidth(i2) : this.getFrameHeight(i2);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public void drawFrame(SDKGraphics sDKGraphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        block42: {
            int n8;
            boolean bl;
            int n9;
            block41: {
                n9 = n7;
                if (this.m_spriteData != null && this.m_eaFont == null) break block41;
                if (this.m_images == null || this.m_images[0] == null) break block42;
                if (n7 == 0) {
                    sDKGraphics.drawImage(this.m_images[0][0], n2, n3, 20);
                } else {
                    sDKGraphics.drawRegion(this.m_images[0][0], 0, 0, this.m_images[0][0].getWidth(), this.m_images[0][0].getHeight(), n7, n2, n3, 20);
                }
                break block42;
            }
            if (n4 < 0 || n4 >= this.m_numFrames || n5 < 0 || n5 >= this.m_numPalettes) {
                return;
            }
            if ((n6 & 1) != 0) {
                n2 -= this.getFrameWidth(n4) >> 1;
            } else if ((n6 & 8) != 0) {
                n2 -= this.getFrameWidth(n4);
            }
            if ((n6 & 2) != 0) {
                n3 -= this.getFrameHeight(n4) >> 1;
            } else if ((n6 & 0x20) != 0) {
                n3 -= this.getFrameHeight(n4);
            }
            int n10 = this.m_spriteData[this.m_chunkOffsets[1] + n4 * 1 + 0];
            int n11 = n10 & 0x1F;
            boolean bl2 = (n10 >> 7 & 1) == 1;
            boolean bl3 = bl = (n10 >> 6 & 1) == 1;
            if (bl2) {
                n9 = m_landscapeDrawingMode != 0 ? (GameRender.m_landscapeMode == 1 ? 7 : 4) : 2;
            } else if (m_landscapeDrawingMode != 0) {
                n9 = GameRender.m_landscapeMode == 1 ? 5 : 6;
            }
            int n12 = 0;
            int n13 = 0;
            if (this.m_chunkOffsets[3] > 0) {
                n8 = this.m_chunkOffsets[3] + n4 * this.m_chunkDataSize[3];
                if (this.m_chunkDataSize[3] == 4) {
                    n12 = this.m_spriteData[n8 + 0] & 0xFF | (this.m_spriteData[n8 + 1] & 0xFF) << 8;
                    n13 = this.m_spriteData[n8 + 2] & 0xFF | (this.m_spriteData[n8 + 3] & 0xFF) << 8;
                } else {
                    n12 = this.m_spriteData[n8 + 0] & 0xFF;
                    n13 = this.m_spriteData[n8 + 1] & 0xFF;
                }
            }
            n8 = this.m_frameOffsets[n4];
            int n14 = this.m_chunkOffsets[4] + n8 * this.m_chunkDataSize[4];
            int n15 = this.m_chunkOffsets[5] + n8 * this.m_chunkDataSize[5];
            int n16 = this.m_chunkOffsets[6] + n8 * this.m_chunkDataSize[6];
            int n17 = 0;
            int n18 = 0;
            if (this.m_chunkDataSize[4] == 4) {
                for (n10 = 0; n10 < n11; ++n10) {
                    int n19;
                    int n20;
                    int n21 = this.m_spriteData[n14 + 0] & 0xFF | (this.m_spriteData[n14 + 1] & 0xFF) << 8;
                    int n22 = this.m_spriteData[n14 + 2] & 0xFF | (this.m_spriteData[n14 + 3] & 0xFF) << 8;
                    int n23 = this.m_spriteData[n15 + 0] & 0xFF | (this.m_spriteData[n15 + 1] & 0xFF) << 8;
                    int n24 = this.m_spriteData[n15 + 2] & 0xFF | (this.m_spriteData[n15 + 3] & 0xFF) << 8;
                    if (this.m_chunkOffsets[6] > 0) {
                        n17 = this.m_spriteData[n16 + 0] & 0xFF | this.m_spriteData[n16 + 1] << 8;
                        n18 = this.m_spriteData[n16 + 2] & 0xFF | this.m_spriteData[n16 + 3] << 8;
                    }
                    int n25 = (n23 & 1) << 1 | n24 & 1;
                    n23 >>= 1;
                    n24 >>= 1;
                    if (bl2) {
                        if (m_landscapeDrawingMode != 0) {
                            if (GameRender.m_landscapeMode == 1) {
                                n20 = 180 - (n3 + n18) - n24;
                                n19 = n2 - n23 - n17 + n12;
                            } else {
                                n20 = n3 + n18;
                                n19 = 320 - (n2 - n23 - n17 + n12) - n23;
                            }
                        } else {
                            n20 = n2 - n23 - n17 + n12;
                            n19 = n3 + n18;
                        }
                    } else if (m_landscapeDrawingMode != 0) {
                        if (GameRender.m_landscapeMode == 1) {
                            n20 = 180 - (n3 + n18 - n13) - n24;
                            n19 = n2 + n17 - n12;
                        } else {
                            n20 = n3 + n18 - n13;
                            n19 = 320 - (n2 + n17 - n12) - n23;
                        }
                    } else {
                        n20 = n2 + n17 - n12;
                        n19 = n3 + n18 - n13;
                    }
                    sDKGraphics.drawRegion(this.m_images[n5][n25], n21, n22, n23, n24, n9, n20, n19, 20);
                    n14 += this.m_chunkDataSize[4];
                    n15 += this.m_chunkDataSize[5];
                    n16 += this.m_chunkDataSize[6];
                }
            } else {
                for (n10 = 0; n10 < n11; ++n10) {
                    int n26;
                    int n27;
                    int n28 = this.m_spriteData[n14 + 0] & 0xFF;
                    int n29 = this.m_spriteData[n14 + 1] & 0xFF;
                    int n30 = this.m_spriteData[n15 + 0] & 0xFF;
                    int n31 = this.m_spriteData[n15 + 1] & 0xFF;
                    if (this.m_chunkOffsets[6] > 0) {
                        n17 = this.m_spriteData[n16 + 0];
                        n18 = this.m_spriteData[n16 + 1];
                    }
                    int n32 = (n30 & 1) << 1 | n31 & 1;
                    n30 >>= 1;
                    n31 >>= 1;
                    if (bl2) {
                        if (m_landscapeDrawingMode != 0) {
                            if (GameRender.m_landscapeMode == 1) {
                                n27 = 180 - (n3 + n18) - n31;
                                n26 = n2 - n30 - n17 + n12;
                            } else {
                                n27 = n3 + n18;
                                n26 = 320 - (n2 - n30 - n17 + n12) - n30;
                            }
                        } else {
                            n27 = n2 - n30 - n17 + n12;
                            n26 = n3 + n18;
                        }
                    } else if (m_landscapeDrawingMode != 0) {
                        if (GameRender.m_landscapeMode == 1) {
                            n27 = 180 - (n3 + n18 - n13) - n31;
                            n26 = n2 + n17 - n12;
                        } else {
                            n27 = n3 + n18 - n13;
                            n26 = 320 - (n2 + n17 - n12) - n30;
                        }
                    } else {
                        n27 = n2 + n17 - n12;
                        n26 = n3 + n18 - n13;
                    }
                    sDKGraphics.drawRegion(this.m_images[n5][n32], n28, n29, n30, n31, n9, n27, n26, 20);
                    n14 += this.m_chunkDataSize[4];
                    n15 += this.m_chunkDataSize[5];
                    n16 += this.m_chunkDataSize[6];
                }
            }
        }
    }

    public int getStringWidth(char[] cArray, int n2, int n3) {
        int n4 = 0;
        if (this.m_chunkOffsets[7] > 0) {
            n4 = this.m_spriteData[this.m_chunkOffsets[7] + 0] & 0xFF;
        }
        int n5 = 0;
        while (n3 > 0) {
            int n6 = this.fontGetCharFrame(cArray[n2]);
            n5 = n6 > 0 ? (n5 += this.getFrameWidth(n6)) : (n5 += n4);
            ++n2;
            --n3;
        }
        return n5;
    }

    public void drawString(SDKGraphics sDKGraphics, char[] cArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        int n9 = 0;
        if (this.m_chunkOffsets[7] > 0) {
            n8 = this.m_spriteData[this.m_chunkOffsets[7] + 0] & 0xFF;
            n9 = this.m_spriteData[this.m_chunkOffsets[7] + 6] & 0xFF;
        }
        if ((n7 & 9) != 0) {
            int n10 = this.getStringWidth(cArray, n2, n3);
            n4 = (n7 & 8) != 0 ? (n4 -= n10) : (n4 -= n10 >> 1);
        }
        if ((n7 & 0x20) == 0) {
            n5 += n9;
        }
        while (n3 > 0) {
            int n11 = this.fontGetCharFrame(cArray[n2]);
            if (n11 > 0) {
                this.drawFrame(sDKGraphics, n4, n5, n11, n6, 20, 0);
                n4 += this.getFrameWidth(n11);
            } else {
                n4 += n8;
            }
            ++n2;
            --n3;
        }
    }

    public Object setEAFont(int n2) {
        if (n2 >= 0 && n2 < this.m_numPalettes && this.m_eaFont != null) {
            SDKUtils.setFont(this.m_eaFont);
            SDKUtils.setFontImage(this.m_images[n2][0]);
            if (m_landscapeDrawingMode != 0) {
                if (GameRender.m_landscapeMode == 1) {
                    SDKUtils.setTransform(5);
                } else {
                    SDKUtils.setTransform(6);
                }
            } else {
                SDKUtils.setTransform(0);
            }
            return SDKUtils.getFont();
        }
        return null;
    }

    private int fontGetCharFrame(int n2) {
        int n3 = -1;
        if (n2 > 32 && n2 < 128) {
            n3 = this.m_chunkOffsets[8] + (n2 - 32) * 2;
        } else {
            int n4 = this.m_chunkOffsets[9];
            int n5 = this.m_spriteData[this.m_chunkOffsets[7] + 2 + 0] & 0xFF | (this.m_spriteData[this.m_chunkOffsets[7] + 2 + 1] & 0xFF) << 8;
            while (n5 > 0) {
                if ((this.m_spriteData[n4 + 0] & 0xFF | (this.m_spriteData[n4 + 1] & 0xFF) << 8) == n2) {
                    n3 = n4 + 2;
                    break;
                }
                --n5;
                n4 += 4;
            }
        }
        if (n3 > 0) {
            n3 = this.m_spriteData[n3 + 0] & 0xFF | (this.m_spriteData[n3 + 1] & 0xFF) << 8;
        }
        return n3;
    }

    private static int findChunk(byte[] byArray, char c2, char c3) {
        for (int i2 = 4; i2 < byArray.length; i2 += (byArray[i2 + 2] & 0xFF | (byArray[i2 + 3] & 0xFF) << 8) + 4) {
            if (byArray[i2] != (byte)c2 || byArray[i2 + 1] != (byte)c3) continue;
            return i2 + 4;
        }
        return -1;
    }

    private static int getShort(DDImage dDImage, int n2) {
        return dDImage.m_spriteData[n2 + 0] & 0xFF | (dDImage.m_spriteData[n2 + 1] & 0xFF) << 8;
    }

    private static boolean loadSpriteData(String string, DDImage dDImage, byte[] byArray, byte[] byArray2, int n2, int n3, int n4, boolean bl) {
        dDImage.m_numImages = 1;
        dDImage.m_numFrames = 1;
        boolean bl2 = true;
        dDImage.m_numPalettes = 1;
        if (byArray2 != null) {
            dDImage.m_numPalettes = n4;
        }
        if (bl2) {
            bl2 = DDImage.loadSpriteImages(string, dDImage, byArray, byArray2, n2, n3, n4, bl);
        }
        return bl2;
    }

    private static boolean loadSpriteData(String string, DDImage dDImage, byte[] byArray, int n2, int n3, int n4, boolean bl) {
        boolean bl2 = false;
        if (string.endsWith("font.png") || string.endsWith("fft.png")) {
            m_filename.setLength(0);
            m_filename.append(string);
            m_filename.setLength(string.length() - 4);
            m_filename.append(".rff");
            dDImage.m_spriteData = DDFile.loadFileBytes(m_filename.toString());
            dDImage.m_eaFont = SDKUtils.loadFont(null, dDImage.m_spriteData);
            dDImage.m_numImages = 1;
            dDImage.m_numFrames = 1;
            bl2 = true;
        } else if (string.endsWith(".spr")) {
            if (DDImage.loadSpriteChunkData(string, dDImage)) {
                DDImage.calculateFrameOffsets(dDImage);
                bl2 = true;
            }
        } else {
            dDImage.m_numImages = 1;
            dDImage.m_numFrames = 1;
            bl2 = true;
        }
        dDImage.m_numPalettes = 1;
        if (byArray != null) {
            dDImage.m_numPalettes = n4;
        }
        if (bl2) {
            bl2 = DDImage.loadSpriteImages(string, dDImage, null, byArray, n2, n3, n4, bl);
        }
        return bl2;
    }

    public static int pngFindPLTE(byte[] byArray, int n2) {
        for (int i2 = 8; i2 < n2; i2 += ((byArray[i2 + 0] & 0xFF) << 24 | (byArray[i2 + 1] & 0xFF) << 16 | (byArray[i2 + 2] & 0xFF) << 8 | (byArray[i2 + 3] & 0xFF) << 0) + 8 + 4) {
            if (byArray[i2 + 4] != 80 || byArray[i2 + 5] != 76 || byArray[i2 + 6] != 84 || byArray[i2 + 7] != 69) continue;
            return i2 + 8;
        }
        return -1;
    }

    public static int pngCalcCRC(byte[] byArray, int n2) {
        int n3 = ((byArray[(n2 -= 4) - 4] & 0xFF) << 24 | (byArray[n2 - 3] & 0xFF) << 16 | (byArray[n2 - 2] & 0xFF) << 8 | (byArray[n2 - 1] & 0xFF) << 0) + 4;
        int n4 = -1;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = (n4 ^ (byte)(byArray[i2 + n2] & 0xFF)) & 0xFF;
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((n5 & 1) != 0) {
                    n5 = 0xEDB88320 ^ n5 >>> 1;
                    continue;
                }
                n5 >>>= 1;
            }
            n4 = n5 ^ n4 >>> 8;
        }
        byArray[n2 + n3 + 0] = (byte)((n4 ^= 0xFFFFFFFF) >> 24 & 0xFF);
        byArray[n2 + n3 + 1] = (byte)(n4 >> 16 & 0xFF);
        byArray[n2 + n3 + 2] = (byte)(n4 >> 8 & 0xFF);
        byArray[n2 + n3 + 3] = (byte)(n4 >> 0 & 0xFF);
        return n4;
    }

    public static void pngCalcAdler(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 1;
        int n6 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            n6 = (n5 += byArray[i2] & 0xFF) + n6;
            n5 %= 65521;
            n6 %= 65521;
        }
        byArray[n4++] = (byte)(n6 >> 8 & 0xFF);
        byArray[n4++] = (byte)(n6 & 0xFF);
        byArray[n4++] = (byte)(n5 >> 8 & 0xFF);
        byArray[n4++] = (byte)(n5 & 0xFF);
    }

    private static boolean loadSpriteImages(String string, DDImage dDImage, byte[] byArray, byte[] byArray2, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        boolean bl2 = true;
        if (byArray == null) {
            m_filename.setLength(0);
            m_filename.append(string);
            m_filename.setLength(string.length() - 4);
            if (dDImage.m_numImages > 1) {
                m_filename.append("_0");
                n5 = m_filename.length() - 1;
            }
            m_filename.append(".png");
        } else {
            m_filename.setLength(0);
            m_filename.append(string);
        }
        dDImage.m_images = new SDKImage[dDImage.m_numPalettes][dDImage.m_numImages];
        try {
            for (int i2 = 0; i2 < dDImage.m_numImages; ++i2) {
                if (dDImage.m_numImages > 1 && byArray == null) {
                    m_filename.setCharAt(n5, (char)(48 + i2));
                }
                if (byArray2 == null && byArray == null) {
                    dDImage.m_images[0][i2] = DDFile.loadImage(m_filename.toString());
                    continue;
                }
                if (byArray != null && byArray2 == null) {
                    dDImage.m_images[0][i2] = SDKUtils.createImage(byArray, 0, DDFile.getFileLength(string));
                    System.gc();
                    continue;
                }
                int n6 = DDFile.getFileLength(m_filename.toString());
                byte[] byArray3 = byArray == null ? DDFile.loadFileBytes(m_filename.toString()) : byArray;
                if (byArray3 == null) continue;
                int n7 = DDImage.pngFindPLTE(byArray3, n6);
                byte[] byArray4 = new byte[byArray3.length];
                System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
                int n8 = !bl ? n3 * 3 : byArray2[4] & 0xFF | (byArray2[5] & 0xFF) << 8;
                int n9 = 0;
                int n10 = n2;
                while (n9 < n4) {
                    byArray3 = null;
                    System.gc();
                    byArray3 = new byte[byArray4.length];
                    System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
                    if (n7 > 0) {
                        for (int i3 = 0; i3 < n3 * 3; ++i3) {
                            byArray3[n7 + i3] = byArray2[n10 + i3];
                        }
                        DDImage.pngCalcCRC(byArray3, n7);
                    }
                    dDImage.m_images[n9][i2] = SDKUtils.createImage(byArray3, 0, n6);
                    dDImage.m_images[n9][i2].getWidth();
                    ++n9;
                    n10 += n8;
                }
                byArray3 = null;
                System.gc();
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        return bl2;
    }

    private static boolean loadSpriteChunkData(String string, DDImage dDImage) {
        boolean bl = false;
        dDImage.m_spriteData = DDFile.loadFileBytes(string);
        if (dDImage.m_spriteData != null) {
            dDImage.m_chunkOffsets = new int[10];
            dDImage.m_chunkDataSize = new byte[10];
            for (int i2 = 0; i2 < 10; ++i2) {
                dDImage.m_chunkOffsets[i2] = DDImage.findChunk(dDImage.m_spriteData, m_chunkIDs[i2][0], m_chunkIDs[i2][1]);
                dDImage.m_chunkDataSize[i2] = 2;
                if (m_chunkIDs[i2][1] != 'b' || dDImage.m_chunkOffsets[i2] != -1) continue;
                dDImage.m_chunkOffsets[i2] = DDImage.findChunk(dDImage.m_spriteData, m_chunkIDs[i2][0], 's');
                dDImage.m_chunkDataSize[i2] = 4;
            }
            bl = true;
            if (dDImage.m_chunkOffsets[0] > 0) {
                dDImage.m_numImages = dDImage.m_spriteData[dDImage.m_chunkOffsets[0] + 4] & 0xFF;
            }
        }
        return bl;
    }

    private static void calculateFrameOffsets(DDImage dDImage) {
        int n2 = DDImage.getShort(dDImage, dDImage.m_chunkOffsets[0] + 0);
        int n3 = DDImage.getShort(dDImage, dDImage.m_chunkOffsets[0] + 2);
        dDImage.m_numFrames = n2;
        dDImage.m_frameOffsets = new short[n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = dDImage.m_chunkOffsets[1];
        int n7 = dDImage.m_chunkOffsets[2];
        while (n4 < n2) {
            if (n3 > 0 && DDImage.getShort(dDImage, n7 + 0) == n4) {
                n7 += 4;
            } else {
                dDImage.m_frameOffsets[n4] = (short)n5;
                n5 += dDImage.m_spriteData[n6 + 0] & 0x1F;
            }
            ++n4;
            ++n6;
        }
        n4 = 0;
        n7 = dDImage.m_chunkOffsets[2];
        while (n4 < n3) {
            dDImage.m_frameOffsets[DDImage.getShort((DDImage)dDImage, (int)(n7 + 0))] = dDImage.m_frameOffsets[DDImage.getShort(dDImage, n7 + 2)];
            ++n4;
            n7 += 4;
        }
        if (dDImage.m_chunkOffsets[7] > 0) {
            short[] sArray = new short[n2];
            for (n4 = 0; n4 < n2; ++n4) {
                sArray[n4] = (short)dDImage.getFrameWidth(n4);
            }
            dDImage.m_frameWidths = sArray;
        }
    }

    private static void debugCheckChunkData(DDImage dDImage) {
    }

    public static void landscapeDrawArc(SDKGraphics sDKGraphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        sDKGraphics.drawArc(n2, n3, n4, n5, n6, n7);
    }

    public static void landscapeFillArc(SDKGraphics sDKGraphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        sDKGraphics.fillArc(n2, n3, n4, n5, n6, n7);
    }

    public static int[] landscapeLoadAndRotateARGB(String string, boolean bl) {
        SDKImage sDKImage = SDKUtils.createImage(DDFile.loadFileBytes(string), 0, DDFile.getFileLength(string));
        int n2 = sDKImage.getWidth();
        int n3 = sDKImage.getHeight();
        m_landscapeARGBSrcDimensions = n3 << 12 | n2 << 0;
        int[] nArray = new int[n2 * n3];
        sDKImage.getRGB(nArray, 0, n2, 0, 0, n2, n3);
        return DDImage.landscapeRotateARGB(nArray, n2, n3, bl);
    }

    public static int[] landscapeRotateARGB(int[] nArray, int n2, int n3, boolean bl) {
        int n4 = m_landscapeDrawingMode;
        if (bl) {
            n4 = GameRender.m_landscapeMode;
        }
        return nArray;
    }

    public static void landscapeSetClip(SDKGraphics sDKGraphics, int n2, int n3, int n4, int n5) {
        sDKGraphics.setClip(n2, n3, n4, n5);
    }

    public static void landscapeDrawRGB(SDKGraphics sDKGraphics, int[] nArray, int n2, int n3, int n4, int n5, boolean bl) {
        sDKGraphics.drawRGB(nArray, 0, n4, n2, n3, n4, n5, bl);
    }

    public static void landscapeDrawImage(SDKGraphics sDKGraphics, SDKImage sDKImage, int n2, int n3) {
        sDKGraphics.drawImage(sDKImage, n2, n3, 20);
    }

    public static void landscapeDrawRotatedSprite(SDKGraphics sDKGraphics, SDKImage sDKImage, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n6 + n4 > sDKImage.getWidth() || n7 + n5 > sDKImage.getHeight()) {
            return;
        }
        int n9 = n8;
        sDKGraphics.drawRegion(sDKImage, n6, n7, n4, n5, n9, n2, n3, 20);
    }

    public static int landscapeGetClipY(SDKGraphics sDKGraphics) {
        return sDKGraphics.getClipY();
    }

    public static int landscapeGetClipX(SDKGraphics sDKGraphics) {
        return sDKGraphics.getClipX();
    }

    public static void landscapeFillRect(SDKGraphics sDKGraphics, int n2, int n3, int n4, int n5) {
        sDKGraphics.fillRect(n2, n3, n4, n5);
    }

    public static void landscapeDrawRect(SDKGraphics sDKGraphics, int n2, int n3, int n4, int n5) {
        sDKGraphics.drawRect(n2, n3, n4, n5);
    }

    public static int[] landscapeTransformScreenCoordinates(int n2, int n3) {
        return null;
    }

    static {
        m_landscapeDrawingMode = 0;
    }
}

