/*
 * Decompiled with CFR 0.152.
 */
package commonstuff;

import commonstuff.Clip;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MyFont {
    private Image image;
    private Hashtable data;
    private Vector content;
    private int x;
    private int y;
    private int originalx;
    private int originaly;
    private int width;
    private int height;
    private final int emptysize;
    private int space = 0;

    public MyFont(Image im, String binding, int x, int y, int emptysize) {
        this.emptysize = emptysize;
        this.data = new Hashtable();
        this.content = new Vector();
        this.x = this.originalx = x;
        this.y = this.originaly = y;
        this.image = im;
        int[] rgb = new int[im.getWidth() * im.getHeight()];
        im.getRGB(rgb, 0, im.getWidth(), 0, 0, im.getWidth(), im.getHeight());
        int szel = im.getWidth();
        boolean lastures = true;
        Clip temp = null;
        int count = 0;
        for (int i = 0; i < im.getWidth(); ++i) {
            boolean ures = true;
            for (int j = 0; j < im.getHeight(); ++j) {
                if ((rgb[i + j * szel] & 0xFF000000) == 0) continue;
                ures = false;
            }
            if (lastures && !ures) {
                temp = new Clip();
                temp.x = i;
                temp.y = 0;
                temp.h = im.getHeight();
            } else if (!lastures && ures) {
                temp.w = i - temp.x;
                this.data.put("" + binding.charAt(count), temp);
                ++count;
            }
            lastures = ures;
        }
    }

    public void Paint(Graphics g) {
        int futox = this.x;
        for (int i = 0; i < this.content.size(); ++i) {
            Clip clip = (Clip)this.content.elementAt(i);
            if (clip != null) {
                g.drawRegion(this.image, clip.x, 0, clip.w, clip.h, 0, futox, this.y, 0);
                futox += clip.w + this.space;
                continue;
            }
            if (clip != null) continue;
            futox += this.emptysize;
        }
    }

    public void PaintMiddle(Graphics g) {
        int futox = this.x - this.width / 2;
        for (int i = 0; i < this.content.size(); ++i) {
            Clip clip = (Clip)this.content.elementAt(i);
            if (clip == null) continue;
            g.drawRegion(this.image, clip.x, 0, clip.w, clip.h, 0, futox, this.y - this.height / 2, 0);
            futox += clip.w + this.space;
        }
    }

    public void SetString(String text) {
        this.content.removeAllElements();
        this.width = 0;
        this.height = 0;
        for (int i = 0; i < text.length(); ++i) {
            Clip temp = null;
            if (text.charAt(i) == ' ') {
                temp = null;
            } else {
                temp = (Clip)this.data.get("" + text.charAt(i));
                if (temp.h >= this.height) {
                    this.height = temp.h;
                }
            }
            this.content.addElement(temp);
            if (temp == null) {
                this.width += this.emptysize;
                continue;
            }
            this.width += temp.w;
        }
    }

    public void SetX(int x) {
        this.x = x;
    }

    public void SetY(int y) {
        this.y = y;
    }

    public int GetAlignX() {
        return this.originalx - this.width;
    }

    public int GetOriginalX() {
        return this.originalx;
    }

    public int GetOriginalY() {
        return this.originaly;
    }

    public int GetX() {
        return this.x;
    }

    public int GetY() {
        return this.y;
    }

    public void SetSpace(int i) {
        this.space = i;
    }
}

