/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import math.Clip;
import math.Vector2D;

public class FlickPlayer {
    double x;
    double y;
    double vx;
    double vy;
    double wx = 0.0;
    double wy = 0.0;
    double m;
    Image im;
    int middlex;
    int middley;
    Clip lastclip;
    Clip newclip;
    int r;
    int[] collision;
    int ID;
    private Image selection;

    public FlickPlayer(double x, double y, int middlex, int middley, int r, double m) {
        this.selection = null;
        this.x = x;
        this.y = y;
        this.middlex = middlex;
        this.middley = middley;
        this.r = r;
        this.m = m;
    }

    public FlickPlayer(Image im, int middlex, int middley, int r, int ID, int x, int y) {
        this.selection = this.selection = null;
        this.ID = ID;
        this.collision = new int[7];
        this.im = im;
        this.r = r;
        this.m = 1.0;
        this.middlex = middlex;
        this.middley = middley;
        this.x = x;
        this.y = y;
        this.lastclip = new Clip(x - middlex, y - middley, im.getWidth(), im.getHeight());
        this.newclip = new Clip(x - middlex, y - middley, im.getWidth(), im.getHeight());
    }

    public FlickPlayer(Image im, int middlex, int middley, int r, int ID, int x, int y, Image selection) {
        this.selection = null;
        this.selection = selection;
        this.ID = ID;
        this.collision = new int[7];
        this.im = im;
        this.r = r;
        this.m = 1.0;
        this.middlex = middlex;
        this.middley = middley;
        this.x = x;
        this.y = y;
        this.lastclip = new Clip(x - middlex, y - middley - 10 - selection.getHeight(), im.getWidth(), im.getHeight() + 10 + selection.getHeight());
        this.newclip = new Clip(x - middlex, y - middley - 10 - selection.getHeight(), im.getWidth(), im.getHeight() + 10 + selection.getHeight());
    }

    public void RefreshClip() {
        if (this.selection == null) {
            this.lastclip = new Clip((int)(this.x - (double)this.middlex), (int)(this.y - (double)this.middley), this.im.getWidth(), this.im.getHeight());
            this.newclip = new Clip((int)(this.x - (double)this.middlex), (int)(this.y - (double)this.middley), this.im.getWidth(), this.im.getHeight());
        } else {
            this.lastclip = new Clip((int)(this.x - (double)this.middlex), (int)(this.y - (double)this.middley - 10.0 - (double)this.selection.getHeight()), this.im.getWidth(), this.im.getHeight() + 10 + this.selection.getHeight());
            this.newclip = new Clip((int)(this.x - (double)this.middlex), (int)(this.y - (double)this.middley - 10.0 - (double)this.selection.getHeight()), this.im.getWidth(), this.im.getHeight() + 10 + this.selection.getHeight());
        }
    }

    public void Paint(Graphics g, boolean selected) {
        g.drawImage(this.im, (int)(this.x - (double)this.middlex), (int)(this.y - (double)this.middley), 0);
        if (this.selection != null && selected) {
            g.drawImage(this.selection, (int)(this.x - 11.0), (int)(this.y - (double)this.middley - (double)this.selection.getHeight() - 10.0), 0);
        }
    }

    public void Paint(Graphics g) {
        g.drawImage(this.im, (int)(this.x - (double)this.middlex), (int)(this.y - (double)this.middley), 0);
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public boolean AlreadyIntersect(int ID) {
        return this.collision[ID] == 1;
    }

    public boolean Move(double t, Play.GameConfig gconfig, Vector movable) {
        if (Math.sqrt(this.vx * this.vx + this.vy * this.vy) > 0.5) {
            int j;
            FlickPlayer flickp;
            int i;
            this.lastclip.x = this.newclip.x;
            this.lastclip.y = this.newclip.y;
            double rem_x = 0.0;
            double rem_y = 0.0;
            boolean fal = false;
            if (this.x + (double)this.r + t * this.vx >= (double)gconfig.right && this.vx > 0.0) {
                this.x += (double)gconfig.right - (this.x + (double)this.r);
                this.x -= t * this.vx - ((double)gconfig.right - (this.x + (double)this.r));
                this.vx = -this.vx;
                fal = true;
                for (i = 0; i < movable.size(); ++i) {
                    flickp = (FlickPlayer)movable.elementAt(i);
                    for (j = 0; j < flickp.collision.length; ++j) {
                        flickp.collision[j] = 0;
                    }
                }
            }
            if (this.x - (double)this.r + t * this.vx <= (double)gconfig.left && this.vx < 0.0) {
                this.x -= this.x - (double)this.r - (double)gconfig.left;
                this.x += -(t * this.vx) - (this.x - (double)this.r - (double)gconfig.left);
                this.vx = -this.vx;
                fal = true;
                for (i = 0; i < movable.size(); ++i) {
                    flickp = (FlickPlayer)movable.elementAt(i);
                    for (j = 0; j < flickp.collision.length; ++j) {
                        flickp.collision[j] = 0;
                    }
                }
            }
            if (this.y - (double)this.r + t * this.vy <= (double)gconfig.top && this.vy < 0.0) {
                this.y -= this.y - (double)this.r - (double)gconfig.top;
                this.y += -t * this.vy - (this.y - (double)this.r - (double)gconfig.top);
                this.vy = -this.vy;
                fal = true;
                for (i = 0; i < movable.size(); ++i) {
                    flickp = (FlickPlayer)movable.elementAt(i);
                    for (j = 0; j < flickp.collision.length; ++j) {
                        flickp.collision[j] = 0;
                    }
                }
            }
            if (this.y + (double)this.r + t * this.vy >= (double)gconfig.bottom && this.vy > 0.0) {
                double megtett = (double)gconfig.bottom - (this.y + (double)this.r);
                this.y += megtett;
                this.y -= t * this.vy - megtett;
                this.vy = -this.vy;
                fal = true;
                for (int i2 = 0; i2 < movable.size(); ++i2) {
                    FlickPlayer flickp2 = (FlickPlayer)movable.elementAt(i2);
                    for (int j2 = 0; j2 < flickp2.collision.length; ++j2) {
                        flickp2.collision[j2] = 0;
                    }
                }
            }
            if (!fal) {
                this.x += t * this.vx;
                this.y += t * this.vy;
            }
            if (this.selection == null) {
                this.newclip.x = (int)(this.x - (double)this.middlex);
                this.newclip.y = (int)(this.y - (double)this.middley);
            } else {
                this.newclip.x = (int)(this.x - (double)this.middlex);
                this.newclip.y = (int)(this.y - (double)this.middley - 10.0 - (double)this.selection.getHeight());
            }
            this.vx *= Math.sqrt(Math.sqrt(gconfig.s));
            this.vy *= Math.sqrt(Math.sqrt(gconfig.s));
            return true;
        }
        this.vx = 0.0;
        this.vy = 0.0;
        return false;
    }

    public Clip getRefreshClip() {
        if (this.lastclip.x != this.newclip.x || this.lastclip.y != this.newclip.y || this.lastclip.w != this.newclip.w || this.lastclip.h != this.newclip.h) {
            return Clip.Union(this.lastclip, this.newclip);
        }
        return null;
    }

    public double FarFromClicked(int cx, int cy, int hatar) {
        double l = Math.sqrt((this.x - (double)cx) * (this.x - (double)cx) + (this.y - (double)cy) * (this.y - (double)cy));
        if (l <= (double)hatar) {
            return l;
        }
        return -1.0;
    }

    public Clip getlastClip() {
        return this.lastclip;
    }

    public Clip getnewClip() {
        return this.newclip;
    }

    public void HandleIntersect(FlickPlayer other) {
        if ((other.x - this.x) * (other.x - this.x) + (other.y - this.y) * (other.y - this.y) <= (double)((this.r + other.r) * (this.r + other.r))) {
            if (this.collision[other.ID] == 0 && other.collision[this.ID] == 0) {
                this.collision[other.ID] = 1;
                other.collision[this.ID] = 1;
                Vector2D v_n = new Vector2D(other.x - this.x, other.y - this.y);
                Vector2D v_un = v_n.Unit();
                Vector2D v_ut = new Vector2D(-v_un.y, v_un.x);
                double v1n = v_un.Dot(new Vector2D(this.vx, this.vy));
                double v1t = v_ut.Dot(new Vector2D(this.vx, this.vy));
                double v2n = v_un.Dot(new Vector2D(other.vx, other.vy));
                double v2t = v_ut.Dot(new Vector2D(other.vx, other.vy));
                double v1tPrime = v1t;
                double v2tPrime = v2t;
                double v1nPrime = (v1n * (this.m - other.m) + 2.0 * other.m * v2n) / (this.m + other.m);
                double v2nPrime = (v2n * (other.m - this.m) + 2.0 * this.m * v1n) / (this.m + other.m);
                Vector2D v_v1nPrime = v_un.MultiplyByScalar(v1nPrime);
                Vector2D v_v1tPrime = v_ut.MultiplyByScalar(v1tPrime);
                Vector2D v_v2nPrime = v_un.MultiplyByScalar(v2nPrime);
                Vector2D v_v2tPrime = v_ut.MultiplyByScalar(v2tPrime);
                this.vx = v_v1nPrime.x + v_v1tPrime.x;
                this.vy = v_v1nPrime.y + v_v1tPrime.y;
                other.vx = v_v2nPrime.x + v_v2tPrime.x;
                other.vy = v_v2nPrime.y + v_v2tPrime.y;
            }
        } else {
            this.collision[other.ID] = 0;
            other.collision[this.ID] = 0;
        }
    }

    public void setVelocity(double vx, double vy) {
        this.vx = vx;
        this.vy = vy;
    }
}

