/*
 * Decompiled with CFR 0.152.
 */
package newstuff;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import newstuff.StateBase;

public class StateManager {
    public Vector states = new Vector();
    StateBase currentState = null;

    public void PushFront(StateBase state, boolean activeNew) {
        this.states.insertElementAt(state, 0);
        this.currentState = state;
        if (activeNew) {
            this.currentState.Activate();
        }
    }

    public void PushAt(StateBase state, int index) {
        this.states.insertElementAt(state, index);
    }

    public void EraseFirst() {
        this.states.removeElementAt(0);
    }

    public void EraseAllWithDeactivate() {
        for (int i = 0; i < this.states.size(); ++i) {
            StateBase sb = (StateBase)this.states.elementAt(i);
            sb.Deactivate();
        }
        this.states.removeAllElements();
    }

    public void EraseFirstWithDeactivate() {
        this.currentState.Deactivate();
        this.states.removeElementAt(0);
        if (this.states.size() > 0) {
            this.currentState = (StateBase)this.states.elementAt(0);
        }
    }

    public void EraseWithDeactivate(int n) {
        StateBase sb = (StateBase)this.states.elementAt(n);
        sb.Deactivate();
        this.states.removeElementAt(n);
        if (this.states.size() > 0) {
            this.currentState = (StateBase)this.states.elementAt(0);
        }
    }

    public void EraseFirstAndActivate(boolean deactivateCurrent) {
        if (deactivateCurrent) {
            this.currentState.Deactivate();
        }
        this.states.removeElementAt(0);
        if (this.states.size() > 0) {
            this.currentState = (StateBase)this.states.elementAt(0);
            this.currentState.Activate();
        }
    }

    public void PushFrontAndErase(StateBase state, boolean activeNew, boolean deactivateCurrent) {
        if (deactivateCurrent) {
            this.currentState.Deactivate();
        }
        this.states.removeElementAt(0);
        this.states.insertElementAt(state, 0);
        this.currentState = state;
        if (activeNew) {
            this.currentState.Activate();
        }
    }

    public void PushFrontAndEraseAll(StateBase state, boolean activeNew, boolean deactivateCurrent) {
        for (int i = 0; i < this.states.size(); ++i) {
            StateBase sb = (StateBase)this.states.elementAt(i);
            sb.Deactivate();
            this.states.setElementAt(null, i);
        }
        this.states.removeAllElements();
        this.states.insertElementAt(state, 0);
        this.currentState = state;
        if (activeNew) {
            this.currentState.Activate();
        }
    }

    public void PopFront(boolean deactivateCurrent, boolean activateNew) {
        if (deactivateCurrent) {
            this.currentState.Deactivate();
        }
        this.states.setElementAt(null, 0);
        this.states.removeElementAt(0);
        if (this.states.size() > 0) {
            this.currentState = (StateBase)this.states.elementAt(0);
            if (activateNew) {
                this.currentState.Activate();
            }
        }
    }

    public void PopFrontWithFree(boolean deactivateCurrent, boolean activateNew) {
        if (deactivateCurrent) {
            this.currentState.Deactivate();
        }
        this.currentState.Free();
        this.states.setElementAt(null, 0);
        System.gc();
        this.states.removeElementAt(0);
        if (this.states.size() > 0) {
            this.currentState = (StateBase)this.states.elementAt(0);
            if (activateNew) {
                this.currentState.Activate();
            }
        }
    }

    public void Update() {
        if (this.currentState != null) {
            this.currentState.Update();
        }
    }

    public void Paint(Graphics g) {
        if (this.currentState != null) {
            this.currentState.Paint(g);
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.currentState != null) {
            this.currentState.pointerDragged(x, y);
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.currentState != null) {
            this.currentState.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.currentState != null) {
            this.currentState.pointerReleased(x, y);
        }
    }

    public void ActivateState() {
        if (this.currentState != null) {
            this.currentState.Activate();
        }
    }

    public void DeactivateState() {
        if (this.currentState != null) {
            this.currentState.Deactivate();
        }
    }

    public void showNotify() {
        if (this.currentState != null) {
            this.currentState.showNotify();
        }
    }

    public void hideNotify() {
        if (this.currentState != null) {
            this.currentState.hideNotify();
        }
    }
}

