/*
 * Decompiled with CFR 0.152.
 */
package newstuff;

import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import newstuff.SaveDataBase;
import stringstuff.StringFunctions;

public abstract class PermanentItemArrayCollection
extends SaveDataBase {
    protected int[] itemCountArray;
    protected int INVALID_ITEM_VALUE;

    public PermanentItemArrayCollection(String recordStoreName, int invalidItemValue) {
        super(recordStoreName);
        this.INVALID_ITEM_VALUE = invalidItemValue;
    }

    public boolean hasItem(int itemId) {
        return itemId < this.itemCountArray.length;
    }

    public void setValue(int itemId, int itemValue) {
        System.out.println(itemId);
        this.itemCountArray[itemId] = itemValue;
    }

    public int getValue(int itemId) {
        if (this.hasItem(itemId)) {
            return this.itemCountArray[itemId];
        }
        return this.INVALID_ITEM_VALUE;
    }

    public boolean isValidValue(int itemId) {
        return this.INVALID_ITEM_VALUE < this.getValue(itemId);
    }

    public int modifyItemValue(int itemId, int itemValueModifier) {
        if (this.hasItem(itemId)) {
            int n = itemId;
            this.itemCountArray[n] = this.itemCountArray[n] + itemValueModifier;
            return this.itemCountArray[itemId];
        }
        return this.INVALID_ITEM_VALUE;
    }

    public void Load() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)false);
            String data1 = new String(rs.getRecord(1));
            String data2 = new String(rs.getRecord(2));
            this.itemCountArray = StringFunctions.SerializedNumArrayToIntArray(data1, ',');
            String[] hashed = StringFunctions.split(data2, ",");
            for (int i = 0; i < this.itemCountArray.length; ++i) {
                if (StringFunctions.SHA1.encode("" + this.itemCountArray[i]).equals(hashed[i])) continue;
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            this.FillDefaultValues();
            this.Save();
        }
    }

    public void Save() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
            byte[] itemCountBytes = StringFunctions.IntArrayToString(this.itemCountArray, ',').getBytes();
            String hash = "";
            for (int i = 0; i < this.itemCountArray.length; ++i) {
                hash = hash + StringFunctions.SHA1.encode("" + this.itemCountArray[i]) + ",";
            }
            byte[] hashBytes = hash.getBytes();
            try {
                rs.setRecord(1, itemCountBytes, 0, itemCountBytes.length);
                rs.setRecord(2, hashBytes, 0, hashBytes.length);
            }
            catch (InvalidRecordIDException ex2) {
                try {
                    rs.addRecord(itemCountBytes, 0, itemCountBytes.length);
                    rs.addRecord(hashBytes, 0, hashBytes.length);
                }
                catch (Exception exe) {
                    // empty catch block
                }
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }
}

