/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.riosupersoccer;

import com.kitmaker.riosupersoccer.SP;
import javax.microedition.lcdui.Graphics;

public class WindParticleSystem {
    private WindParticle[] particles;

    public WindParticleSystem(int _amount) {
        this.particles = new WindParticle[_amount];
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i] = new WindParticle();
        }
    }

    public void update() {
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i].update();
        }
    }

    public void draw(Graphics g) {
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i].draw(g);
        }
    }

    public static class WindParticle {
        private final int MIN_Y;
        private final int MAX_Y;
        private final int LENGTH;
        private int x = SP.getRandom(240, 480);
        private int y = SP.getRandom(45, 270);

        public WindParticle() {
            this.MIN_Y = 45;
            this.MAX_Y = 270;
            this.LENGTH = 20;
        }

        public void update() {
            this.x = (int)((long)this.x - 30L * (SP.dt >> 5));
            if (this.x < 0) {
                this.reset();
            }
        }

        public void draw(Graphics g) {
            g.setColor(0xFFFFFF);
            g.drawLine(this.x, this.y, this.x + 20, this.y);
        }

        public void reset() {
            this.x = SP.getRandom(240, 480);
            this.y = SP.getRandom(45, 270);
        }
    }
}

