/*
 * Decompiled with CFR 0.152.
 */
package kitmaker.online.score.api;

public class KitLang {
    public static final KitLanguageValue ENG = new KitLanguageValue(0);
    public static final KitLanguageValue SPA = new KitLanguageValue(1);
    public static final KitLanguageValue BRA = new KitLanguageValue(2);
    public static final KitLanguageValue ARA = new KitLanguageValue(3);
    public static final KitLanguageValue BEN = new KitLanguageValue(4);
    public static final KitLanguageValue RUS = new KitLanguageValue(5);
    private KitLanguageValue lang;

    public KitLang() {
        this.lang = new KitLanguageValue();
    }

    public KitLang(KitLanguageValue otherLangVal) {
        this.lang = new KitLanguageValue(otherLangVal);
    }

    public KitLang(KitLang otherLang) {
        this.lang = new KitLanguageValue(otherLang.lang);
    }

    public void assign(KitLang otherLang) {
        this.lang.assign(otherLang.lang);
    }

    public String toString() {
        return this.lang.getString();
    }

    public static class KitLanguageValue {
        private int lang;

        private KitLanguageValue() {
            this.lang = 0;
        }

        private KitLanguageValue(int newLang) {
            this.lang = newLang;
        }

        private KitLanguageValue(KitLanguageValue otherLang) {
            this.lang = otherLang.lang;
        }

        private void assign(KitLanguageValue otherLang) {
            this.lang = otherLang.lang;
        }

        private String getString() {
            String result;
            switch (this.lang) {
                case 1: {
                    result = "spanish";
                    break;
                }
                case 2: {
                    result = "brazilian";
                    break;
                }
                case 3: {
                    result = "arabic";
                    break;
                }
                case 4: {
                    result = "bengali";
                    break;
                }
                case 5: {
                    result = "russian";
                    break;
                }
                default: {
                    result = "english";
                }
            }
            return result;
        }
    }
}

