/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class CPlayer
extends CActor {
    public int m_state;
    public int m_faceDirection;
    public int m_shadowPosy;
    static int s_cursorPosY;
    public int m_team;
    public int m_characterId;
    public int m_strength;
    public int m_speed;
    public int m_reach;
    public int m_technique;
    public int m_powerTypeSpike;
    public int m_powerTypeBlock;
    public int m_powerTypeService;
    public int m_powerMeter;
    public int m_victoryType;
    public int m_defeatType;
    boolean m_updateMeter;
    public int m_xDigForce;
    public int m_zDigForce;
    public int m_xMoveSpeed;
    public int m_xLowMoveSpeed;
    public int m_xServingMoveSpeed;
    public int m_zMoveSpeed;
    public int m_runningDirection;
    public int m_shootDirection;
    public int m_shootAccuracy;
    public int m_moveArea;
    public boolean m_bBlocked = false;
    public boolean m_bMovedThisFrame = false;
    public boolean m_bSpecialPowerUsed = false;
    public boolean m_bDigSuccess;
    public int m_framesBeingLocked;
    public int[] m_target = null;
    public boolean m_bIsLocked = false;
    public int m_actionToMake = 0;
    public int m_moveToMake = 0;
    public boolean m_bMoveSelected = false;
    public boolean m_bSpikeMiss = false;
    public int m_framesToDelaySpike;
    public boolean m_bAlreadyDelayedThisFrame;
    public int[] m_predictedMoveVector = null;
    public boolean m_bIsPredictedMove = false;
    public CActor m_emoticon;
    public int m_emoticonDuration;
    public int m_hairStyle;
    public int m_hairColor;
    public int m_swimsuitStyle;
    public int m_swimsuitColor;
    public int[] m_defensePositionCol;
    public int[] m_defensePositionRow;
    public int[] m_spikeAttackProbability;
    public int m_spikeAccuracyProbability;
    public int[] m_rollshotProbality;
    public int[] m_blockProbability;
    public int m_blockDecision;
    public int m_referenceCol;
    public int m_referenceRow;
    static boolean s_bdrawSwimsuit;
    int m_decision;

    public CPlayer(int n, int n2) {
        super(n, n2);
        this.m_team = n < 2 ? 0 : 1;
        this.m_emoticon = new CActor(n, 4);
    }

    public void setPlayerInfo(int n) {
        int n2;
        this.m_characterId = n;
        this.m_hairStyle = CGame.CHARACTER_INFO[n][3];
        this.m_hairColor = CGame.CHARACTER_INFO[n][4];
        this.m_swimsuitStyle = CGame.CHARACTER_INFO[n][5];
        this.m_swimsuitColor = CGame.CHARACTER_INFO[n][6];
        if (CGame.m_gameMode == 1) {
            n2 = CGame.m_cfgWorldTourDifficulty * 20 + CGame.m_cfgCurrentLevel * 20 / 52;
            this.setPlayerSkills(CGame.CHARACTERS_SKILLS_WORLD_TOUR[n * 4] + n2, CGame.CHARACTERS_SKILLS_WORLD_TOUR[n * 4 + 1] + n2, CGame.CHARACTERS_SKILLS_WORLD_TOUR[n * 4 + 2] + n2, CGame.CHARACTERS_SKILLS_WORLD_TOUR[n * 4 + 3] + n2);
        } else {
            n2 = CGame.m_cfgInstantPlayDifficulty * 20;
            this.setPlayerSkills(CGame.CHARACTERS_SKILLS_INSTANT[n * 4] + n2, CGame.CHARACTERS_SKILLS_INSTANT[n * 4 + 1] + n2, CGame.CHARACTERS_SKILLS_INSTANT[n * 4 + 2] + n2, CGame.CHARACTERS_SKILLS_INSTANT[n * 4 + 3] + n2);
        }
        if (!(this.m_index != 0 || CGame.m_gameMode != 1 && CGame.m_gameMode != 3 || CGame.m_bIsInstantPlay)) {
            this.m_powerTypeSpike = CGame.m_cfgPlayerSpecialAttack;
            this.m_powerTypeService = CGame.m_cfgPlayerSpecialService;
            this.m_powerTypeBlock = CGame.m_cfgPlayerSpecialDefense;
        } else {
            n2 = CGame.CHARACTER_INFO[n][1];
            this.m_powerTypeSpike = -1;
            this.m_powerTypeService = -1;
            this.m_powerTypeBlock = -1;
            switch (n2) {
                case 0: 
                case 3: {
                    this.m_powerTypeSpike = n2;
                    break;
                }
                case 1: {
                    this.m_powerTypeBlock = n2;
                    break;
                }
                case 2: {
                    this.m_powerTypeService = n2;
                }
            }
        }
        this.m_pal = CGame.m_cfgPlayerSkinTone;
        this.m_powerMeter = 0;
        this.m_victoryType = CGame.CHARACTER_INFO[n][9];
        this.m_defeatType = CGame.CHARACTER_INFO[n][10];
    }

    public void setPlayerSkills(int n, int n2, int n3, int n4) {
        int n5;
        this.m_strength = 106 + ((n << 7) / 100 * 195 >> 7);
        this.m_speed = 285 + ((n2 << 7) / 100 * 193 >> 7);
        this.m_reach = 100 + ((n3 << 7) / 100 * 60 >> 7);
        this.m_technique = n4;
        this.m_xMoveSpeed = 356 * this.m_speed >> 7;
        this.m_xLowMoveSpeed = 220 * this.m_speed >> 7;
        this.m_zMoveSpeed = this.m_speed;
        this.m_xServingMoveSpeed = 460;
        if (this.m_index == 0) {
            return;
        }
        this.m_spikeAttackProbability = new int[4];
        this.m_blockProbability = new int[3];
        this.m_rollshotProbality = new int[4];
        if (CGame.m_gameMode == 1 && this.m_index > 1) {
            for (n5 = 0; n5 < 4; ++n5) {
                this.m_spikeAttackProbability[n5] = CGame.WT_ATTACK_TYPE_PROBABILITY[CGame.m_cfgWorldTourDifficulty][n5 << 1] + CGame.WT_ATTACK_TYPE_PROBABILITY[CGame.m_cfgWorldTourDifficulty][(n5 << 1) + 1] * CGame.m_cfgCurrentLevel / 52;
            }
            for (n5 = 0; n5 < 3; ++n5) {
                this.m_blockProbability[n5] = CGame.WT_BLOCK_PROBABILITY[CGame.m_cfgWorldTourDifficulty][n5 << 1] + CGame.WT_BLOCK_PROBABILITY[CGame.m_cfgWorldTourDifficulty][(n5 << 1) + 1] * CGame.m_cfgCurrentLevel / 52;
            }
            for (n5 = 0; n5 < 4; ++n5) {
                this.m_rollshotProbality[n5] = CGame.WT_ROLL_SHOT_PROBABILITY[CGame.m_cfgWorldTourDifficulty][n5 << 1] + CGame.WT_ROLL_SHOT_PROBABILITY[CGame.m_cfgWorldTourDifficulty][(n5 << 1) + 1] * CGame.m_cfgCurrentLevel / 52;
            }
            this.m_spikeAccuracyProbability = CGame.WT_SPIKE_ACCURACY_PROBABILITY[CGame.m_cfgWorldTourDifficulty][0] + CGame.WT_SPIKE_ACCURACY_PROBABILITY[CGame.m_cfgWorldTourDifficulty][1] * CGame.m_cfgCurrentLevel / 52;
        } else {
            for (n5 = 0; n5 < 4; ++n5) {
                this.m_spikeAttackProbability[n5] = CGame.WT_ATTACK_TYPE_PROBABILITY[CGame.m_cfgInstantPlayDifficulty][n5 << 1] + CGame.WT_ATTACK_TYPE_PROBABILITY[CGame.m_cfgInstantPlayDifficulty][(n5 << 1) + 1] * this.m_technique / 100;
            }
            for (n5 = 0; n5 < 3; ++n5) {
                this.m_blockProbability[n5] = this.m_index == 1 ? CGame.BLOCK_PARTNER_PROBABILITY[n5 << 1] + CGame.BLOCK_PARTNER_PROBABILITY[(n5 << 1) + 1] * this.m_technique / 100 : CGame.WT_BLOCK_PROBABILITY[CGame.m_cfgInstantPlayDifficulty][n5 << 1] + CGame.WT_BLOCK_PROBABILITY[CGame.m_cfgInstantPlayDifficulty][(n5 << 1) + 1] * this.m_technique / 100;
            }
            for (n5 = 0; n5 < 4; ++n5) {
                this.m_rollshotProbality[n5] = CGame.WT_ROLL_SHOT_PROBABILITY[CGame.m_cfgInstantPlayDifficulty][n5 << 1] + CGame.WT_ROLL_SHOT_PROBABILITY[CGame.m_cfgInstantPlayDifficulty][(n5 << 1) + 1] * this.m_technique / 100;
            }
            this.m_spikeAccuracyProbability = CGame.WT_SPIKE_ACCURACY_PROBABILITY[CGame.m_cfgInstantPlayDifficulty][0] + CGame.WT_SPIKE_ACCURACY_PROBABILITY[CGame.m_cfgInstantPlayDifficulty][1] * this.m_technique / 100;
        }
        if (this.m_index != 2) {
            this.m_defensePositionCol = new int[3];
            for (n5 = 0; n5 < 3; ++n5) {
                this.m_defensePositionCol[n5] = CGame.PARTNER_POSITION_PROBALITY_COL[n5 * 2] + CGame.PARTNER_POSITION_PROBALITY_COL[n5 * 2 + 1] * this.m_technique / 100;
            }
            this.m_defensePositionRow = new int[3];
            for (n5 = 0; n5 < 3; ++n5) {
                this.m_defensePositionRow[n5] = CGame.PARTNER_POSITION_PROBALITY_ROW[n5 * 2] + CGame.PARTNER_POSITION_PROBALITY_ROW[n5 * 2 + 1] * this.m_technique / 100;
            }
        } else {
            this.m_defensePositionCol = new int[2];
            this.m_defensePositionCol[0] = CGame.OPPONENT_POSITION_PROBALITY_COL[0] + CGame.OPPONENT_POSITION_PROBALITY_COL[1] * this.m_technique / 100;
            this.m_defensePositionCol[1] = CGame.OPPONENT_POSITION_PROBALITY_COL[2] + CGame.OPPONENT_POSITION_PROBALITY_COL[3] * this.m_technique / 100;
            this.m_defensePositionRow = new int[4];
            for (n5 = 0; n5 < 4; ++n5) {
                this.m_defensePositionRow[n5] = CGame.OPPONENT_POSITION_PROBALITY_ROW[n5 * 2] + CGame.OPPONENT_POSITION_PROBALITY_ROW[n5 * 2 + 1] * this.m_technique / 100;
            }
        }
    }

    public void refreshPlayerSpeed() {
        this.m_xMoveSpeed = 356 * this.m_speed >> 7;
        this.m_xLowMoveSpeed = 220 * this.m_speed >> 7;
        this.m_xServingMoveSpeed = 153 * this.m_speed >> 7;
        this.m_zMoveSpeed = this.m_speed;
    }

    public void initActor(int n, int n2, int n3, int n4, int n5) {
        this.set3DPosition(n, 0, n2);
        this.changeState(n3);
        this.m_runningDirection = 0;
        this.m_moveArea = n5;
        this.m_faceDirection = n4;
        this.m_flip = n4;
        this.m_bIsLocked = false;
    }

    public void changeState(int n) {
        switch (n) {
            case 0: {
                this.setAnim(1);
                break;
            }
            case 1: {
                this.m_bMovedThisFrame = true;
                switch (this.m_runningDirection) {
                    case 4: {
                        this.setAnim(7);
                        break;
                    }
                    case 3: {
                        if (this.m_faceDirection == 1) {
                            this.setAnim(4);
                            break;
                        }
                        this.setAnim(5);
                        break;
                    }
                    case 5: {
                        if (this.m_faceDirection == 0) {
                            this.setAnim(4);
                            break;
                        }
                        this.setAnim(5);
                        break;
                    }
                    case 6: {
                        this.setAnim(6);
                    }
                }
                break;
            }
            case 2: {
                this.setAnim(8);
                break;
            }
            case 3: {
                this.m_bMovedThisFrame = true;
                if (this.m_runningDirection == 3 && this.m_faceDirection == 0 || this.m_runningDirection == 5 && this.m_faceDirection == 1) {
                    this.setAnim(10);
                    break;
                }
                this.setAnim(9);
                break;
            }
            case 4: {
                this.setAnim(11);
                break;
            }
            case 5: {
                this.setAnim(12);
                break;
            }
            case 6: {
                this.m_faceDirection = this.m_xReal > CGame.m_actorBall.m_hotSpots[3][0] ? 1 : 0;
                this.setAnim(13);
                break;
            }
            case 10: {
                this.m_bBlocked = false;
                int n2 = this.m_faceDirection = this.m_xReal > 0 ? 1 : 0;
                if (this.m_index == 0) {
                    CGame.m_frameRate = 100;
                    CGame.m_framesToSetFPSNormal = 10;
                }
                if (this.m_powerTypeBlock == 1 && this.m_powerMeter >= 100) {
                    this.m_bSpecialPowerUsed = true;
                    CGame.m_specialPowerActivated = 1;
                    CGame.m_bSpecialPowerEffectEnable = true;
                    this.setAnim(21);
                    break;
                }
                this.setAnim(19);
                break;
            }
            case 9: {
                this.setAnim(15 + (this.m_runningDirection == 3 && this.m_faceDirection == 1 ? this.m_runningDirection + 2 : (this.m_runningDirection == 5 && this.m_faceDirection == 1 ? this.m_runningDirection - 2 : this.m_runningDirection)) - 3);
                break;
            }
            case 7: {
                this.m_faceDirection = this.m_xReal > CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal ? 1 : 0;
                this.setAnim(14);
                break;
            }
            case 8: {
                this.m_bAlreadyDelayedThisFrame = false;
                if (this.m_index >= 0 && this.m_index <= 1 && this.m_powerMeter >= 100) {
                    CGame.m_frameRate = 50;
                }
                this.m_faceDirection = this.m_xReal > 0 ? 1 : 0;
                this.setAnim(20);
                break;
            }
            case 12: {
                this.setAnimation(27 + this.m_victoryType, 0);
                break;
            }
            case 13: {
                this.setAnimation(30 + this.m_defeatType, 0);
            }
        }
        this.m_state = n;
    }

    public void miniGameCmdAction(int n) {
        switch (n) {
            case 3: {
                this.moveDirection(-1, 0);
                break;
            }
            case 4: {
                this.moveDirection(0, 1);
                break;
            }
            case 6: {
                this.moveDirection(0, -1);
                break;
            }
            case 5: {
                this.moveDirection(1, 0);
                break;
            }
            case 7: {
                this.moveDirection(-1, 1);
                break;
            }
            case 8: {
                this.moveDirection(1, 1);
                break;
            }
            case 9: {
                this.moveDirection(-1, -1);
                break;
            }
            case 10: {
                this.moveDirection(1, -1);
            }
        }
    }

    public void updateServiceSelectTarget(int n) {
        switch (n) {
            case 3: {
                CGame.m_serviceTargetPosX -= 1024;
                break;
            }
            case 4: {
                CGame.m_serviceTargetPosZ += 512;
                break;
            }
            case 6: {
                CGame.m_serviceTargetPosZ -= 512;
                break;
            }
            case 5: {
                CGame.m_serviceTargetPosX += 1024;
                break;
            }
            case 7: {
                CGame.m_serviceTargetPosX -= 1024;
                CGame.m_serviceTargetPosZ += 512;
                break;
            }
            case 8: {
                CGame.m_serviceTargetPosX += 1024;
                CGame.m_serviceTargetPosZ += 512;
                break;
            }
            case 9: {
                CGame.m_serviceTargetPosX -= 1024;
                CGame.m_serviceTargetPosZ -= 512;
                break;
            }
            case 10: {
                CGame.m_serviceTargetPosX += 1024;
                CGame.m_serviceTargetPosZ -= 512;
                break;
            }
            case 1: {
                CGame.updateStateService();
            }
        }
        if (CGame.m_serviceTargetPosZ > 11008) {
            CGame.m_serviceTargetPosZ = 11008;
        }
        if (CGame.m_serviceTargetPosZ < 1536) {
            CGame.m_serviceTargetPosZ = 1536;
        }
        if (Math.abs(CGame.m_serviceTargetPosX) > 18304) {
            CGame.m_serviceTargetPosX = 18304 * (CGame.m_userSide == 0 ? 1 : -1);
        }
        if (Math.abs(CGame.m_serviceTargetPosX) < CGame.PLAYER_HALF_WIDTH) {
            CGame.m_serviceTargetPosX = CGame.PLAYER_HALF_WIDTH * (CGame.m_userSide == 0 ? 1 : -1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cmdAction(int n) {
        block24: {
            boolean bl;
            boolean bl2 = !this.m_bIsLocked && CGame.m_gameSubState == 1 || CGame.m_gameSubState == 0 && (CGame.m_serviceState == 2 || CGame.m_playerServicer[this.m_team] != this.m_index || CGame.m_serviceSide != (this.m_xReal > 0 ? 1 : 0)) ? true : (bl = false);
            if (CGame.m_gameSubState == 0 && CGame.m_serviceSide == CGame.m_userSide && CGame.m_serviceState == 3 && CGame.m_playerServicer[CGame.m_serviceSide] == 0) {
                this.updateServiceSelectTarget(n);
                return;
            }
            block0 : switch (n) {
                case 3: {
                    if (!bl) return;
                    this.m_target = null;
                    this.moveDirection(-1, 0);
                    return;
                }
                case 4: {
                    if (bl) {
                        this.m_target = null;
                        this.moveDirection(0, 1);
                        return;
                    }
                    if (CGame.m_gameSubState != 0 || this.m_state != 2 || CGame.m_serviceState != 0 || --CGame.m_serviceType >= 0) return;
                    CGame.m_serviceType = 0;
                    return;
                }
                case 6: {
                    if (bl) {
                        this.m_target = null;
                        this.moveDirection(0, -1);
                        return;
                    }
                    if (CGame.m_gameSubState != 0 || this.m_state != 2 || CGame.m_serviceState != 0 || ++CGame.m_serviceType <= 1) return;
                    CGame.m_serviceType = 1;
                    return;
                }
                case 5: {
                    if (!bl) return;
                    this.m_target = null;
                    this.moveDirection(1, 0);
                    return;
                }
                case 7: {
                    if (!bl) return;
                    this.m_target = null;
                    this.moveDirection(-1, 1);
                    return;
                }
                case 8: {
                    if (!bl) return;
                    this.m_target = null;
                    this.moveDirection(1, 1);
                    return;
                }
                case 9: {
                    if (!bl) return;
                    this.m_target = null;
                    this.moveDirection(-1, -1);
                    return;
                }
                case 10: {
                    if (!bl) return;
                    this.m_target = null;
                    this.moveDirection(1, -1);
                    return;
                }
                case 1: {
                    switch (CGame.m_gameSubState) {
                        case 0: {
                            if (CGame.m_serviceSide != (this.m_xReal > 0 ? 1 : 0) || CGame.m_playerServicer[CGame.m_serviceSide] != this.m_index) return;
                            CGame.updateStateService();
                            break block24;
                        }
                        case 1: {
                            if (CGame.m_lockedPlayer == this.m_index && this.m_state != 8 && (CGame.m_touchNumber == 1 || CGame.m_touchNumber == 2)) {
                                if (this.m_shootAccuracy < -5) {
                                    this.m_bSpikeMiss = true;
                                    this.changeState(8);
                                    break block0;
                                }
                                this.m_shootDirection = 1;
                                this.m_bMoveSelected = true;
                                if (this.changeMoveToMake(3)) {
                                    this.changeState(8);
                                }
                                this.m_framesToDelaySpike = CGame.m_actorBall.m_spikingCounter - 6 - 1;
                                this.m_shootAccuracy = 7 - (CGame.m_actorBall.m_spikingCounter - 6);
                                break block0;
                            }
                            if (!(this.m_bIsLocked || this.getColumn() != 0 || this.m_state != 0 && this.m_state != 1 || CGame.m_actorBall.m_xReal > 0 == this.m_xReal > 0)) {
                                this.changeState(10);
                                break block0;
                            }
                            if (!this.m_bIsLocked || this.m_state != 8 || this.m_bSpikeMiss || this.m_powerTypeSpike == -1 && this.m_powerMeter >= 100) return;
                            this.m_moveToMake = 8;
                            this.m_bMoveSelected = true;
                        }
                    }
                }
            }
        }
    }

    public void moveDirection(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this.m_state == 3 || this.m_state == 2) {
            n7 = this.m_xServingMoveSpeed;
            n8 = this.m_zMoveSpeed;
            if (this.m_moveArea == 1) {
                n7 = 0;
            }
        } else if (this.m_state == 1 || this.m_state == 0 || this.m_state == 8 && this.m_currentFrame <= 6) {
            n8 = this.m_zMoveSpeed;
            n7 = n == -1 && this.m_faceDirection == 0 || n == 1 && this.m_faceDirection == 1 ? this.m_xLowMoveSpeed : this.m_xMoveSpeed;
        } else {
            return;
        }
        if (this.m_target != null) {
            n4 = Math.abs(this.m_xReal - this.m_target[0]);
            n3 = Math.abs(this.m_zReal - this.m_target[1]);
            if (n4 < n7) {
                n7 = n4;
            }
            if (n3 < n8) {
                n8 = n3;
            }
        }
        n5 = this.m_xReal + n * n7;
        n6 = this.m_zReal + n2 * n8;
        int n9 = this.m_xReal > 0 ? 1 : (n4 = this.m_xReal < 0 ? -1 : 0);
        if (n6 < 1280) {
            n6 = 1280;
        } else if (n6 > 11008) {
            n6 = 11008;
        }
        switch (this.m_moveArea) {
            case 0: {
                if (Math.abs(n5) < 22400 + CGame.PLAYER_HALF_WIDTH - 4480 - 640) {
                    n5 = (22400 + CGame.PLAYER_HALF_WIDTH - 4480 - 640) * n4;
                } else if (Math.abs(n5) > 22400) {
                    n5 = 22400 * n4;
                }
                if (n6 < 2176 + CGame.PLAYER_HALF_DEPTH) {
                    n6 = 2176 + CGame.PLAYER_HALF_DEPTH;
                    break;
                }
                if (n6 <= 10112) break;
                n6 = 10112;
                break;
            }
            case 2: {
                n3 = n5 - CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal;
                int n10 = n6 - CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_zReal;
                int n11 = CPlayer.fastDistance(n3, n10);
                if (n11 <= 0) {
                    if (CGame.m_lockedPlayer == this.m_index || CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_state == 0 && this.m_index != 0 && this.m_index != 1) {
                        CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal -= -n * 896;
                        CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_zReal -= -n2 * 896;
                    } else {
                        n5 += -n * 896;
                        n6 += -n2 * 896;
                    }
                } else if (n11 < 1792) {
                    int n12 = 1792 - n11;
                    int n13 = n3 * n12 / n11;
                    int n14 = n10 * n12 / n11;
                    if (CGame.m_lockedPlayer == this.m_index || CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_state == 0 && this.m_index != 0 && this.m_index != 1) {
                        CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal -= n13;
                        CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_zReal -= n14;
                    } else {
                        n5 += n13 + 128;
                        n6 += n14 + 128;
                    }
                }
                if (Math.abs(n5) < CGame.PLAYER_HALF_WIDTH) {
                    n5 = CGame.PLAYER_HALF_WIDTH * n4;
                    break;
                }
                if (Math.abs(n5) <= 22400) break;
                n5 = 22400 * n4;
            }
        }
        if (n5 != this.m_xReal || n6 != this.m_zReal) {
            if (n == -1) {
                this.m_runningDirection = 3;
            } else if (n == 1) {
                this.m_runningDirection = 5;
            } else if (n2 == 1) {
                this.m_runningDirection = 4;
            } else if (n2 == -1) {
                this.m_runningDirection = 6;
            }
            if (this.m_state == 0 || this.m_state == 1) {
                this.changeState(1);
            } else if (this.m_state == 2 || this.m_state == 3) {
                this.changeState(3);
            }
            this.m_xReal = n5;
            this.m_zReal = n6;
        } else if (CGame.m_gameState == 11) {
            this.m_target = null;
        }
    }

    public int getArea() {
        int n = this.getColumn();
        int n2 = this.getRow();
        int n3 = -1;
        n3 = n == 3 ? 9 : (n2 == 4 ? 10 : (n2 == 0 ? 11 : 3 - n2 + 3 * n));
        return n3;
    }

    static void getAreaCenter(int[] nArray, int n) {
        int n2 = n / 3;
        int n3 = 3 - n % 3;
        nArray[0] = n2 * 5973 + 2986;
        nArray[1] = n3 * 2645 - 1322 + 2176;
    }

    public int getColumn() {
        int n = Math.abs(this.m_xReal);
        if (n < 17920) {
            return n / 5973;
        }
        return 3;
    }

    public int getRow() {
        if (this.m_zReal < 2176) {
            return 0;
        }
        if (this.m_zReal > 10112) {
            return 4;
        }
        return (this.m_zReal - 2176) / 2645 + 1;
    }

    public boolean isReachable(int n, int n2, int n3) {
        int n4 = this.m_faceDirection == 1 ? (n > this.m_xReal ? this.m_xMoveSpeed : this.m_xLowMoveSpeed) : (n > this.m_xReal ? this.m_xLowMoveSpeed : this.m_xMoveSpeed);
        return Math.abs(n - this.m_xReal) <= n4 * n3 && Math.abs(n2 - this.m_zReal) <= this.m_zMoveSpeed * n3;
    }

    public void reallocateBall() {
        if (this.m_state == 9) {
            int n = 5 + (this.m_runningDirection == 3 && this.m_faceDirection == 1 ? this.m_runningDirection + 2 : (this.m_runningDirection == 5 && this.m_faceDirection == 1 ? this.m_runningDirection - 2 : this.m_runningDirection)) - 3;
            int n2 = (this.m_runningDirection == 3 && this.m_faceDirection == 1 ? this.m_runningDirection + 2 : (this.m_runningDirection == 5 && this.m_faceDirection == 1 ? this.m_runningDirection - 2 : this.m_runningDirection)) - 3;
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = CGame.BALL_OFFSETS_X[n] * (this.m_faceDirection == 1 ? -1 : 1);
            int n4 = CGame.BALL_OFFSETS_Y[n];
            int n5 = CGame.BALL_DIG_OFFSETS_Z[n2];
            CGame.m_actorBall.set3DPosition(this.m_xReal + n3, this.m_yReal + n4, this.m_zReal + n5);
        } else {
            int n = this.m_state - 4;
            if (n < 0) {
                System.getProperty("emu://pause");
                n = 0;
            }
            CGame.m_actorBall.set3DPosition(this.m_xReal + CGame.BALL_OFFSETS_X[n] * (this.m_faceDirection == 1 ? -1 : 1), this.m_yReal + CGame.BALL_OFFSETS_Y[n], this.m_zReal);
        }
    }

    public boolean isInsideMySideCourt(int n, int n2) {
        if ((n > 0 ? 1 : (n < 0 ? -1 : 0)) == (this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0))) {
            return CPlayer.isInsideCourt(n, n2);
        }
        return false;
    }

    public static boolean isInsideCourt(int n, int n2) {
        if (n2 < 2176 || n2 > 10112) {
            return false;
        }
        return Math.abs(n) <= 17920;
    }

    public final int getDistance(int n, int n2) {
        int n3 = this.m_xReal - n;
        int n4 = this.m_zReal - n2;
        return CPlayer.fastDistance(n3, n4);
    }

    public static final int fastDistance(int n, int n2) {
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = n > n2 ? n2 : n;
        return n + n2 - (n3 >> 1) - (n3 >> 2) + (n3 >> 3);
    }

    public boolean changeMoveToMake(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 8: {
                n3 = 6;
                if (Math.abs(CGame.m_actorBall.m_hotSpots[0][0]) >= 5973 || !this.isReachable(CGame.m_actorBall.m_hotSpots[0][0], CGame.m_actorBall.m_hotSpots[0][1], CGame.m_actorBall.m_spikingCounter + n3)) break;
                bl = this.setPlayerTarget(CGame.m_actorBall.m_hotSpots[0][0], CGame.m_actorBall.m_hotSpots[0][1]);
                break;
            }
            case 3: {
                n2 = this.getDistance(CGame.m_actorBall.m_hotSpots[0][0], CGame.m_actorBall.m_hotSpots[0][1]);
                n3 = 6;
                if (CGame.m_actorBall.m_spikingCounter <= 6 + n2 / 1070 || !(bl = this.setPlayerTarget(CGame.m_actorBall.m_hotSpots[0][0], CGame.m_actorBall.m_hotSpots[0][1]))) break;
                this.m_shootAccuracy = 0;
                if (this.m_moveToMake == n) break;
                if (CGame.m_actorsGame[2 - (this.m_team << 1)].m_xReal < CGame.m_actorsGame[3 - (this.m_team << 1)].m_xReal) {
                    CGame.m_actorsGame[2 - (this.m_team << 1)].AIdecideBlock();
                    CGame.m_actorsGame[3 - (this.m_team << 1)].AIdecideBlock();
                    break;
                }
                CGame.m_actorsGame[3 - (this.m_team << 1)].AIdecideBlock();
                CGame.m_actorsGame[2 - (this.m_team << 1)].AIdecideBlock();
                break;
            }
            case 1: 
            case 6: {
                n3 = 5;
                if (n == 6 && CGame.m_touchNumber < 2) {
                    return false;
                }
                if (CGame.m_actorBall.m_passingCounter <= n3) break;
                int n4 = CGame.m_actorBall.m_hotSpots[1][1];
                int n5 = CGame.m_actorBall.m_hotSpots[2][1];
                int n6 = CGame.m_actorBall.m_hotSpots[3][1];
                int n7 = !(this.m_xReal > 0) ? CGame.m_actorBall.m_hotSpots[1][0] : CGame.m_actorBall.m_hotSpots[2][0];
                if (!(this.m_xReal > 0)) {
                    if (this.isReachable(CGame.m_actorBall.m_hotSpots[1][0], CGame.m_actorBall.m_hotSpots[1][1], CGame.m_actorBall.m_passingCounter + n3)) {
                        if (!this.setPlayerTarget(CGame.m_actorBall.m_hotSpots[1][0], CGame.m_actorBall.m_hotSpots[1][1])) {
                            bl = this.setPlayerTarget(CGame.m_actorBall.m_hotSpots[2][0], CGame.m_actorBall.m_hotSpots[2][1]);
                            break;
                        }
                        bl = true;
                        break;
                    }
                    if (this.isReachable(CGame.m_actorBall.m_hotSpots[2][0], CGame.m_actorBall.m_hotSpots[2][1], CGame.m_actorBall.m_passingCounter + n3)) {
                        bl = this.setPlayerTarget(CGame.m_actorBall.m_hotSpots[2][0], CGame.m_actorBall.m_hotSpots[2][1]);
                        break;
                    }
                    bl = false;
                    break;
                }
                if (this.isReachable(CGame.m_actorBall.m_hotSpots[2][0], CGame.m_actorBall.m_hotSpots[2][1], CGame.m_actorBall.m_passingCounter + n3)) {
                    if (!this.setPlayerTarget(CGame.m_actorBall.m_hotSpots[2][0], CGame.m_actorBall.m_hotSpots[2][1])) {
                        bl = this.setPlayerTarget(CGame.m_actorBall.m_hotSpots[1][0], CGame.m_actorBall.m_hotSpots[1][1]);
                        break;
                    }
                    bl = true;
                    break;
                }
                if (this.isReachable(CGame.m_actorBall.m_hotSpots[1][0], CGame.m_actorBall.m_hotSpots[1][1], CGame.m_actorBall.m_passingCounter + n3)) {
                    bl = this.setPlayerTarget(CGame.m_actorBall.m_hotSpots[1][0], CGame.m_actorBall.m_hotSpots[1][1]);
                    break;
                }
                bl = false;
                break;
            }
            case 7: {
                n3 = 3;
                if (CGame.m_actorBall.m_settingCounter <= n3) break;
                bl = this.setPlayerTarget(CGame.m_actorBall.m_hotSpots[3][0], CGame.m_actorBall.m_hotSpots[3][1]);
                break;
            }
            case 5: {
                bl = true;
            }
        }
        if (bl) {
            this.m_moveToMake = n;
        }
        return bl;
    }

    public void checkLockPlayer() {
        block29: {
            block30: {
                if (CGame.m_actorBall.m_hotSpots[4][0] > 0 != this.m_xReal > 0 || CGame.m_gameSubState != 1 || CGame.m_lockedPlayer != -1 || this.m_state != 0 && this.m_state != 1 || !this.isInGoodSpot() || !CGame.m_bIsHotSpotVisible || CGame.m_sideTeamTurn != (this.m_xReal > 0 ? 1 : 0) || this.m_bIsLocked || !CGame.m_actorBall.m_bGoodNetCrossing || CGame.m_actorBall.m_predictedMoveCounter >= CGame.m_preditecShowFrame) break block29;
                if (CGame.m_lastMove != 11 && CGame.m_lastMove != 12) break block30;
                if (CGame.m_lastMove != 11 && CGame.m_lastMove != 12) break block29;
                if (!CBall.isInsideCourt(CGame.m_actorBall.m_hotSpots[4][0], CGame.m_actorBall.m_hotSpots[4][1])) break block29;
            }
            if (CGame.m_playerTurn == -1) {
                if (this.changeMoveToMake(1)) {
                    this.m_bIsLocked = true;
                    CGame.m_cameraPriority[1] = this.m_index;
                    CGame.m_lockedPlayer = this.m_index;
                }
            } else if (CGame.m_bIsPredictedMove && CGame.m_actorBall.m_bGoodNetCrossing) {
                if (this.changeMoveToMake(1)) {
                    this.m_bIsLocked = true;
                    CGame.m_cameraPriority[1] = this.m_index;
                    CGame.m_lockedPlayer = this.m_index;
                }
            } else {
                switch (CGame.m_touchNumber) {
                    case 0: {
                        if (!this.changeMoveToMake(1)) break;
                        this.m_bIsLocked = true;
                        CGame.m_cameraPriority[1] = this.m_index;
                        CGame.m_lockedPlayer = this.m_index;
                        break;
                    }
                    case 1: {
                        if (CGame.m_playerTurn != this.m_index) break;
                        boolean bl = false;
                        if (CGame.m_bEnableSpike && this.m_index == 0) {
                            bl = this.changeMoveToMake(3);
                            int[] nArray = new int[2];
                            CGame.project3Dto2D(nArray, CGame.m_actorBall.m_hotSpots[0][0], 0, CGame.m_actorBall.m_hotSpots[0][1]);
                            CGame.translateToScreen(nArray);
                            CGame.m_spikeMessageY = nArray[1] + 10;
                            this.m_bMoveSelected = false;
                            if (bl) {
                                this.m_bIsLocked = true;
                            }
                        }
                        if (!bl) {
                            if (this.AIdecideSpikeSecondTouch()) {
                                this.m_bIsLocked = true;
                            } else if (this.changeMoveToMake(7)) {
                                this.m_bIsLocked = true;
                            } else if (this.changeMoveToMake(1)) {
                                this.m_bIsLocked = true;
                            }
                        }
                        if (!this.m_bIsLocked) break;
                        CGame.m_cameraPriority[1] = this.m_index;
                        CGame.m_lockedPlayer = this.m_index;
                        break;
                    }
                    case 2: {
                        if (CGame.m_playerTurn != this.m_index) break;
                        boolean bl = false;
                        if (this.m_index == 0) {
                            if (CGame.m_bCanDoSpike || CGame.m_bEnableSpike) {
                                bl = this.changeMoveToMake(3);
                            }
                            if (bl) {
                                int[] nArray = new int[2];
                                CGame.project3Dto2D(nArray, CGame.m_actorBall.m_hotSpots[0][0], 0, CGame.m_actorBall.m_hotSpots[0][1]);
                                CGame.translateToScreen(nArray);
                                CGame.m_spikeMessageY = nArray[1] + 10;
                                this.m_bMoveSelected = false;
                            } else {
                                bl = this.changeMoveToMake(6);
                            }
                        } else {
                            bl = this.changeMoveToMake(6);
                        }
                        if (!bl) break;
                        this.m_bIsLocked = true;
                        CGame.m_cameraPriority[1] = this.m_index;
                        CGame.m_lockedPlayer = this.m_index;
                        if (this.m_index <= 0) break;
                        this.AIdecideAttack();
                    }
                }
            }
            if (this.m_bIsLocked) {
                this.m_framesBeingLocked = 0;
            }
        }
        if (CGame.m_lockedPlayer != -1 && CGame.m_lastMove != 3 && CGame.m_lastMove != 4) {
            CGame.m_spotIndex = 0;
        }
    }

    public void unlock() {
        this.m_framesBeingLocked = 0;
        this.m_bIsLocked = false;
        this.m_moveToMake = 0;
        this.m_target = null;
    }

    public void counterTrigger(int n) {
        this.counterTrigger(n, CGame.m_actorBall);
    }

    public void counterTrigger(int n, CBall cBall) {
        switch (n) {
            case 3: {
                if (this.m_moveToMake != 4 && this.m_moveToMake != 3 && this.m_moveToMake != 8) break;
                if (!this.m_bMoveSelected && this.m_index == 0) {
                    if (CGame.m_touchNumber == 1) {
                        this.changeMoveToMake(7);
                        break;
                    }
                    if (CGame.m_touchNumber != 2) break;
                    this.changeMoveToMake(6);
                    break;
                }
                if (this.m_index != 0) {
                    this.changeState(8);
                }
                if (this.m_index != 2 && this.m_index != 3) break;
                int n2 = CGame.m_actorBall.m_xReal;
                int n3 = CGame.m_actorBall.m_yReal;
                int n4 = CGame.m_actorBall.m_zReal;
                int n5 = this.m_moveToMake;
                CGame.m_actorBall.m_predictedMoveCounter = CGame.m_actorBall.m_spikingCounter;
                CGame.m_predictionCharacter = this.m_index;
                this.m_target = null;
                this.m_bIsPredictedMove = false;
                this.makeMove(this.m_moveToMake, true);
                this.m_bIsPredictedMove = true;
                CGame.m_actorBall.set3DPosition(n2, n3, n4);
                CGame.unlockPlayer();
                this.m_moveToMake = n5;
                break;
            }
            case 7: {
                if (this.m_state == 8) {
                    CGame.m_lastMove = this.m_moveToMake;
                    if (this.m_moveToMake == 4 || this.m_moveToMake == 3 || this.m_moveToMake == 8) {
                        if (this.m_index != 0) {
                            if (this.AIdecideMakeRollShot()) {
                                CGame.m_bIsPredictedMove = false;
                                this.m_bIsPredictedMove = false;
                                if (CGame.m_lockedPlayer != -1 && CGame.m_lockedPlayer != this.m_index) {
                                    CGame.m_actorsGame[CGame.m_lockedPlayer].changeState(0);
                                }
                                CGame.unlockPlayer();
                                this.makeMove(8, false);
                            } else {
                                this.makeMove(this.m_moveToMake, this.m_bIsPredictedMove);
                            }
                        } else if (this.m_index == 0 && !this.m_bSpikeMiss) {
                            this.makeMove(this.m_moveToMake, false);
                        }
                    }
                    this.m_yReal = 0;
                    this.m_bSpikeMiss = false;
                    break;
                }
                if (this.m_bMoveSelected || this.m_index != 0 || CGame.m_touchNumber != 1 && CGame.m_touchNumber != 2) break;
                this.changeMoveToMake(6);
                break;
            }
            case 2: {
                if (this.m_moveToMake != 7) break;
                this.changeState(7);
                break;
            }
            case 6: {
                if (this.m_state != 7) break;
                CGame.m_lastMove = this.m_moveToMake;
                if (this.m_moveToMake != 7) break;
                this.makeMove(this.m_moveToMake, false);
                break;
            }
            case 0: {
                if (this.m_moveToMake != 1 && this.m_moveToMake != 6) break;
                this.changeState(6);
                break;
            }
            case 4: {
                if (this.m_state != 6) break;
                CGame.m_lastMove = this.m_moveToMake;
                this.makeMove(this.m_moveToMake, false);
                break;
            }
            case 10: {
                if (this.m_blockDecision == 3 && this.getColumn() == 0) {
                    this.changeState(10);
                }
                this.m_blockDecision = 0;
                break;
            }
            case 9: {
                if (this.m_blockDecision != 2) break;
                if (this.getColumn() == 0) {
                    this.changeState(10);
                }
                this.m_blockDecision = 0;
                break;
            }
            case 8: {
                if (this.m_blockDecision != 1) break;
                if (this.getColumn() == 0) {
                    this.changeState(10);
                }
                this.m_blockDecision = 0;
            }
        }
        if (CGame.m_gameState != 11 || (CGame.m_actorBall.m_hotSpots[4][0] > 0 == this.m_xReal > 0 || CGame.m_actorBall.m_xReal > 0 == this.m_xReal > 0) && (CGame.m_playerTurn == -1 || CGame.m_playerTurn == this.m_index) && CGame.m_sideTeamTurn == (this.m_xReal > 0 ? 1 : 0)) {
            switch (n) {
                case 1: {
                    if (CGame.m_gameState == 11) {
                        if (!CGame.m_actorBall.m_bGoodNetCrossing || this.m_state != 0 && this.m_state != 1 || CGame.m_lockedPlayer != -1) break;
                        if (!CBall.isInsideCourt(CGame.m_actorBall.m_hotSpots[4][0], CGame.m_actorBall.m_hotSpots[4][1]) && CGame.m_touchNumber == 0 || CGame.m_bMultiBallActivated) break;
                    }
                    this.prepareDig(cBall);
                    break;
                }
                case 5: {
                    if (this.m_moveToMake != 5 || !this.m_bDigSuccess || cBall.m_bBallFell) break;
                    CGame.SoundPlay(13);
                    if (CGame.m_gameState == 11) {
                        if (CGame.m_touchNumber == 0 || CGame.m_touchNumber == 1) {
                            this.makeMove(1, false);
                            CGame.m_bCanDoSpike = false;
                        } else {
                            this.makeMove(6, false);
                        }
                        this.unlock();
                        break;
                    }
                    cBall.m_xForce = 0;
                    cBall.m_yForce = 896;
                    cBall.m_zForce = 0;
                    cBall.m_bBallFell = false;
                    cBall.m_bDigSuccess = false;
                    this.m_bDigSuccess = false;
                }
            }
        }
    }

    public void prepareDig(CBall cBall) {
        int n;
        int n2;
        int n3 = cBall.m_hotSpots[4][0] - this.m_xReal;
        int n4 = cBall.m_hotSpots[4][1] - this.m_zReal;
        if (CGame.m_gameMode != 3) {
            n2 = CGame.PLAYER_HALF_WIDTH * 3 * this.m_reach >> 7;
            n = CGame.PLAYER_HALF_DEPTH * 3 * this.m_reach >> 7;
        } else {
            n2 = CGame.PLAYER_HALF_WIDTH * 3;
            n = CGame.PLAYER_HALF_DEPTH * 3;
        }
        if (this.m_index == 2 || this.m_index == 3) {
            n2 -= CGame.PLAYER_HALF_WIDTH;
            n -= CGame.PLAYER_HALF_DEPTH;
        }
        if (Math.abs(n3) < n2 && Math.abs(n4) < n && this.m_state != 9) {
            this.m_runningDirection = n3 < 0 ? (n4 < 0 ? (Math.abs(n3) > Math.abs(n4) ? 3 : 6) : (Math.abs(n3) > Math.abs(n4) ? 3 : 4)) : (n4 < 0 ? (Math.abs(n3) > Math.abs(n4) ? 5 : 6) : (Math.abs(n3) > Math.abs(n4) ? 5 : 4));
            this.changeState(9);
            this.changeMoveToMake(5);
            int[] nArray = new int[]{cBall.m_hotSpots[4][0] - CGame.BALL_OFFSETS_X[5 + (this.m_runningDirection == 3 && this.m_faceDirection == 1 ? this.m_runningDirection + 2 : (this.m_runningDirection == 5 && this.m_faceDirection == 1 ? this.m_runningDirection - 2 : this.m_runningDirection)) - 3] * (this.m_faceDirection == 1 ? -1 : 1), cBall.m_hotSpots[4][1] - CGame.BALL_DIG_OFFSETS_Z[(this.m_runningDirection == 3 && this.m_faceDirection == 1 ? this.m_runningDirection + 2 : (this.m_runningDirection == 5 && this.m_faceDirection == 1 ? this.m_runningDirection - 2 : this.m_runningDirection)) - 3]};
            int n5 = nArray[0] - this.m_xReal;
            int n6 = nArray[1] - this.m_zReal;
            this.m_xDigForce = n5 / 2;
            this.m_zDigForce = n6 / 2;
            cBall.m_bDigSuccess = cBall.m_diggingCounter == 2;
            this.m_bDigSuccess = cBall.m_bDigSuccess;
        }
    }

    public void makeMove(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (CGame.m_bMultiBallActivated) {
            CGame.m_multiBallDieCounter = 10;
        }
        CGame.m_bBallAlreadyCollided = false;
        if (CGame.m_lastTouchPlayer == 0 && (CGame.m_lastMove == 4 || CGame.m_lastMove == 3)) {
            CGame.m_actorsGame[1].showEmoticon(2, 16);
        }
        if (CGame.m_bSpecialPowerEffectEnable && n == 8) {
            n = 3;
        }
        if (n == 1 && this.m_index != 0 && this.m_framesBeingLocked >= 3 && CGame.m_lastMove != 5) {
            n = 7;
            this.m_moveToMake = 7;
            CGame.m_lastMove = 7;
        }
        CGame.m_lastSuperMove = -1;
        if (!bl || bl && this.m_bIsPredictedMove) {
            for (n4 = 1; n4 < 4; ++n4) {
                CGame.m_actorsGame[n4].m_blockDecision = 0;
                CGame.m_actorsGame[n4].m_decision = 0;
            }
        }
        CGame.m_actorBall.m_gravity = 206;
        n4 = -1;
        int n5 = 2;
        int n6 = 20;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[3];
        boolean bl2 = false;
        boolean bl3 = false;
        int n7 = 0;
        CGame.m_bEnableSpike = false;
        if (CGame.m_bIsBallTailActive) {
            CGame.m_ballTailTimeToDie = CGame.m_frameSequence + 6;
        }
        this.reallocateBall();
        if ((CGame.m_actorBall.m_lastPoint[0] > 0 ? 1 : (CGame.m_actorBall.m_lastPoint[0] < 0 ? -1 : 0)) != (CGame.m_actorBall.m_xReal > 0 ? 1 : (CGame.m_actorBall.m_xReal < 0 ? -1 : 0))) {
            CGame.m_actorBall.m_xReal = 0 + (CGame.m_actorBall.m_lastPoint[0] > 0 ? 1 : (CGame.m_actorBall.m_lastPoint[0] < 0 ? -1 : 0)) * 896;
        }
        switch (n) {
            case 1: {
                if (CGame.m_gameMode == 3 && (CGame.m_tutorialStep == 5 || CGame.m_tutorialStep == 4 || CGame.m_tutorialStep == 1 && CGame.m_menuIndex == 1)) {
                    CGame.m_tutorialResetStepCounter = CGame.m_frameSequence + 25;
                    if (CGame.m_tutorialStep == 5) {
                        if (this.m_moveToMake != 5) {
                            CGame.m_tutorialSuccessState = 1;
                            if (CGame.m_tutorialStep == 5 && ++CGame.m_tutorialCurrentSuccessCount == 2) {
                                CGame.m_tutorialQuestionAsk = 1;
                                CGame.m_menuIndex = 0;
                                CGame.m_tutorialStep = 4;
                            } else if (CGame.m_tutorialCurrentSuccessCount == 1) {
                                CGame.finishTutorialStep(CGame.m_tutorialStep - 3 >> 1);
                            }
                        } else {
                            CGame.m_tutorialSuccessState = 2;
                        }
                    }
                }
                if (!CGame.m_actorBall.m_bDigSuccess) {
                    CGame.SoundPlay(19);
                }
                n6 = 20;
                if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getRow() > 0 && CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getRow() < 4) {
                    switch (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getColumn()) {
                        case 0: 
                        case 1: {
                            nArray[0] = 2986 * (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal > 0 ? 1 : (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal < 0 ? -1 : 0));
                            nArray[1] = 512;
                            nArray[2] = CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_zReal + (CGame.PLAYER_HALF_DEPTH << 1);
                            if (nArray[2] <= 10112) break;
                            nArray[2] = CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_zReal - (CGame.PLAYER_HALF_DEPTH << 1);
                            break;
                        }
                        case 2: {
                            nArray[0] = CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal + (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal > 0 ? -CGame.PLAYER_HALF_WIDTH * 4 : CGame.PLAYER_HALF_WIDTH * 4);
                            nArray[1] = 512;
                            nArray[2] = CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_zReal;
                            break;
                        }
                        case 3: {
                            CPlayer.getAreaCenter(nArray, 6 + (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getRow() - 1 < 1 ? 1 : (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getRow() - 1 > 2 ? 2 : CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getRow() - 1)));
                            if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal < 0) {
                                nArray[0] = -nArray[0];
                            }
                            nArray[2] = nArray[1];
                            nArray[1] = 0;
                        }
                    }
                }
                if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getRow() == 0) {
                    if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getColumn() >= 2) {
                        n4 = 8;
                    } else if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getColumn() == 1) {
                        n4 = 5;
                    } else if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getColumn() == 0) {
                        n4 = 2;
                    }
                }
                if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getRow() == 4) {
                    if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getColumn() >= 2) {
                        n4 = 6;
                    } else if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getColumn() == 1) {
                        n4 = 3;
                    } else if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getColumn() == 0) {
                        n4 = 0;
                    }
                }
                if (n4 != -1) {
                    CPlayer.getAreaCenter(nArray, n4);
                    if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal < 0) {
                        nArray[0] = -nArray[0];
                    }
                    nArray[2] = nArray[1];
                    nArray[1] = 0;
                    n4 = -1;
                }
                n7 = this.m_moveToMake == 5 ? 20 : 5;
                n3 = Math.abs(CGame.m_actorBall.m_xForce) + Math.abs(CGame.m_actorBall.m_yForce) + Math.abs(CGame.m_actorBall.m_zForce);
                n3 = this.m_moveToMake == 5 || Math.abs(this.m_xReal) < Math.abs(CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal) ? (n3 /= 16) : (n3 /= 19);
                if (n3 <= 128) break;
                nArray3[0] = n3;
                nArray3[1] = 0;
                nArray3[2] = n3;
                break;
            }
            case 7: {
                CGame.m_bEnableSpike = true;
                if (!CGame.m_actorBall.m_bDigSuccess) {
                    CGame.SoundPlay(19);
                }
                if (this.m_index == 1) {
                    CGame.m_actorBall.m_gravity = CGame.m_touchNumber == 0 ? 155 : 82;
                    CGame.m_actorsGame[1].showEmoticon(4, 16);
                    n6 = CGame.m_touchNumber == 0 ? 27 : 35;
                    n6 += CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getColumn() << 1;
                } else {
                    n6 = 22;
                    n6 += CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getColumn() << 1;
                }
                if (this.m_index == 1 && !CGame.m_bIsInstantPlay && CGame.m_touchNumber >= 1) {
                    n3 = CGame.random(2 * CGame.m_cfgWorldTourDifficulty + 3 * CGame.m_cfgCurrentLevel / 52, 6 * CGame.m_cfgWorldTourDifficulty + 7 * CGame.m_cfgCurrentLevel / 52);
                    n6 -= n3;
                    CGame.m_actorBall.m_gravity += 10 * n3;
                }
                n3 = this.getRow();
                switch (n3) {
                    case 0: 
                    case 1: {
                        n4 = 0;
                        break;
                    }
                    case 2: {
                        if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_zReal > 6144) {
                            n4 = 0;
                            break;
                        }
                        n4 = 2;
                        break;
                    }
                    default: {
                        n4 = 2;
                    }
                }
                n7 = 10;
                break;
            }
            case 3: 
            case 4: {
                n5 = 3528;
                n4 = this.calculateBestShotArea();
                if (!bl || bl && this.m_bIsPredictedMove) {
                    CGame.m_bIsBallTailActive = true;
                    CGame.m_ballTailTimeToDie = CGame.m_frameSequence - 1;
                    n7 = 20;
                }
                if ((this.m_powerTypeSpike == 3 || CGame.m_gameMode == 3) && this.m_powerMeter >= 100) {
                    if (!bl || bl && this.m_bIsPredictedMove) {
                        CGame.m_lastSuperMove = 3;
                        if (this.m_index == 0) {
                            Display.getDisplay((MIDlet)GloftBVB.instance).vibrate(300);
                        }
                        CGame.SoundPlay(7);
                        bl3 = true;
                        this.m_powerMeter = 0;
                        n7 = 0;
                        CGame.m_actorBall.setAnimation(6, 0);
                    }
                    n4 = 7;
                    n5 = 3528;
                    this.m_bSpecialPowerUsed = true;
                } else if (this.m_powerTypeSpike == 0 && this.m_powerMeter >= 100) {
                    n5 = n5 * 100 >> 7;
                    if (!bl || bl && this.m_bIsPredictedMove) {
                        CGame.m_lastSuperMove = 0;
                        if (this.m_index == 0) {
                            Display.getDisplay((MIDlet)GloftBVB.instance).vibrate(300);
                        }
                        CGame.SoundPlay(7);
                        bl3 = true;
                        this.m_powerMeter = 0;
                        n7 = 0;
                        CGame.m_bMultiBallActivated = true;
                        CGame.m_multiBallCurrentDistance = 0;
                        CGame.m_multiBallDieCounter = 0;
                        this.m_bSpecialPowerUsed = true;
                    }
                    if ((n4 = CGame.random(6, 8)) == 6) {
                        CGame.m_multiBallRealPosition = 0;
                    } else if (n4 == 7) {
                        CGame.m_multiBallRealPosition = 1;
                    } else if (n4 == 8) {
                        CGame.m_multiBallRealPosition = 2;
                    }
                } else {
                    if (!bl || bl && this.m_bIsPredictedMove) {
                        if (this.m_shootAccuracy == 0) {
                            CGame.SoundPlay(16);
                        } else {
                            CGame.SoundPlay(11);
                        }
                    }
                    if (this.m_shootAccuracy >= 4) {
                        n5 -= 5;
                    } else if (this.m_shootAccuracy <= -4) {
                        n5 += 3;
                    }
                }
                CGame.m_sprSpots.animSetUp(0, 0, 0);
                bl2 = true;
                if (bl && (!bl || !this.m_bIsPredictedMove)) break;
                CGame.m_actorBall.createGameEffect(CGame.m_actorBall.m_xReal, CGame.m_actorBall.m_yReal, CGame.m_actorBall.m_zReal, 7);
                break;
            }
            case 6: {
                if (CGame.m_gameMode == 3 && (CGame.m_tutorialStep == 7 || CGame.m_tutorialStep == 9)) {
                    CGame.m_tutorialResetStepCounter = CGame.m_frameSequence + 14;
                    CGame.m_tutorialSuccessState = 2;
                }
                if (!CGame.m_actorBall.m_bDigSuccess) {
                    CGame.SoundPlay(19);
                }
                CGame.m_actorBall.m_gravity = 229;
                n6 = 23;
                n4 = this.calculateBestShotArea();
                nArray3[0] = 50;
                nArray3[1] = 0;
                nArray3[2] = 30;
                bl2 = true;
                if (this.m_moveToMake == 5) {
                    n7 = 20;
                    break;
                }
                n7 = 5;
                break;
            }
            case 8: {
                CGame.SoundPlay(19);
                CGame.m_actorBall.m_gravity = 401;
                n3 = CGame.m_actorsGame[2 - (this.m_team << 1)].getArea();
                n2 = CGame.m_actorsGame[3 - (this.m_team << 1)].getArea();
                while ((n4 = CGame.random(0, 2)) == n3 || n4 == n2) {
                }
                n6 = 14;
                bl2 = true;
                n7 = 20;
                break;
            }
            case 11: {
                if (this.m_index == 0) {
                    ++CGame.m_serviceTimesUser;
                }
                n3 = Math.abs(6 - CGame.m_serviceAccuracy);
                if (this.m_index != 0) {
                    int[] nArray4 = new int[]{105, 95, 0};
                    int n8 = 0;
                    if (CGame.m_servicePower >= 4 && CGame.m_servicePower <= 5) {
                        CGame.m_servicePower = 6;
                    }
                    if (CGame.m_servicePower == 8) {
                        CGame.m_servicePower = 9;
                    }
                    switch (CGame.m_servicePower) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            nArray4[0] = nArray4[0] - 30;
                            nArray4[1] = nArray4[1] + 80;
                            n8 = 128 - (4 - CGame.m_servicePower) * 128 / 10;
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            nArray4[0] = nArray4[0] - 20;
                            nArray4[1] = nArray4[1] + 50;
                            n8 = 128 - (8 - CGame.m_servicePower) * 128 / 10;
                            break;
                        }
                        case 8: 
                        case 9: {
                            n8 = 128 - (10 - CGame.m_servicePower) * 128 / 10;
                            break;
                        }
                        case 10: {
                            CGame.SoundPlay(16);
                            CGame.m_bIsBallTailActive = true;
                            CGame.m_ballTailTimeToDie = CGame.m_frameSequence - 1;
                            CGame.m_actorBall.m_gravity = 333;
                            nArray4[0] = nArray4[0] + 40;
                            n8 = 128 - (11 - CGame.m_servicePower) * 128 / 10;
                        }
                    }
                    if (CGame.m_servicePower < 10) {
                        CGame.SoundPlay(20);
                    }
                    nArray2[0] = (2058 * n8 * nArray4[0] >> 7) * (this.m_faceDirection == 1 ? -1 : 1) >> 7;
                    nArray2[1] = 2058 * n8 * nArray4[1] >> 7 >> 7;
                    nArray2[2] = 2058 * n8 * nArray4[2] >> 7 >> 7;
                } else {
                    n6 = 25 - CGame.m_servicePower * 11 / 10;
                    nArray[0] = CGame.m_serviceTargetPosX;
                    nArray[1] = 0;
                    nArray[2] = CGame.m_serviceTargetPosZ;
                    if (CGame.m_servicePower == 10) {
                        CGame.SoundPlay(16);
                        CGame.m_bIsBallTailActive = true;
                        CGame.m_ballTailTimeToDie = CGame.m_frameSequence - 1;
                        CGame.m_actorBall.m_gravity = 333;
                    } else {
                        CGame.SoundPlay(20);
                    }
                }
                nArray3[0] = n3 * 256;
                nArray3[1] = 0;
                nArray3[2] = n3 * 256;
                bl2 = true;
                CGame.m_bPowerMeterVisible = false;
                n7 = 10;
                CGame.m_actorBall.m_bBallFell = false;
                CGame.m_cameraPriority[0] = 4;
                if (bl && (!bl || !this.m_bIsPredictedMove)) break;
                CGame.m_actorBall.createGameEffect(CGame.m_actorBall.m_xReal, CGame.m_actorBall.m_yReal, CGame.m_actorBall.m_zReal, 7);
                break;
            }
            case 12: {
                n7 = 10;
                if (this.m_powerTypeService == 2 && this.m_powerMeter >= 100) {
                    CGame.m_lastSuperMove = 2;
                    if (this.m_index == 0) {
                        Display.getDisplay((MIDlet)GloftBVB.instance).vibrate(300);
                    }
                    this.m_powerMeter = 0;
                    n7 = 0;
                    CGame.m_bMultiBallActivated = true;
                    CGame.m_multiBallCurrentDistance = 0;
                    CGame.m_multiBallDieCounter = 0;
                    n4 = CGame.random(3, 5);
                    CGame.m_multiBallRealPosition = n4 == 3 ? 0 : (n4 == 4 ? 1 : 2);
                    CPlayer.getAreaCenter(nArray, n4);
                    if (this.m_xReal > 0) {
                        nArray[0] = nArray[0] * -1;
                    }
                    nArray[2] = nArray[1];
                    nArray[1] = 0;
                    CGame.m_actorBall.getForceNeeded(nArray2, nArray[0], nArray[1], nArray[2], 1911);
                    nArray2[1] = nArray2[1] + 500;
                } else {
                    n3 = Math.abs(6 - CGame.m_serviceAccuracy);
                    if (this.m_index != 0) {
                        int[] nArray5 = new int[]{105, 95, 0};
                        int n9 = 0;
                        if (CGame.m_servicePower == 0) {
                            CGame.m_servicePower = 1;
                        }
                        if (CGame.m_servicePower == 4) {
                            CGame.m_servicePower = 5;
                        }
                        switch (CGame.m_servicePower) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                nArray5[0] = nArray5[0] - 10;
                                nArray5[1] = nArray5[1] + 60;
                                n9 = 128 - (4 - CGame.m_servicePower) * 128 / 10;
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                nArray5[1] = nArray5[1] + 30;
                                n9 = 128 - (8 - CGame.m_servicePower) * 128 / 10;
                                break;
                            }
                            case 8: 
                            case 9: {
                                nArray5[0] = nArray5[0] + 30;
                                nArray5[1] = nArray5[1] - 20;
                                n9 = 128 - (11 - CGame.m_servicePower) * 128 / 10;
                                break;
                            }
                            case 10: {
                                CGame.SoundPlay(16);
                                CGame.m_bIsBallTailActive = true;
                                CGame.m_ballTailTimeToDie = CGame.m_frameSequence - 1;
                                CGame.m_actorBall.m_gravity = 333;
                                nArray5[0] = nArray5[0] + 80;
                                nArray5[1] = nArray5[1] - 45;
                                n9 = 128;
                            }
                        }
                        if (CGame.m_servicePower < 10) {
                            CGame.SoundPlay(20);
                        }
                        nArray2[0] = (1764 * n9 * nArray5[0] >> 7) * (this.m_faceDirection == 1 ? -1 : 1) >> 7;
                        nArray2[1] = 1764 * n9 * nArray5[1] >> 7 >> 7;
                        nArray2[2] = 1764 * n9 * nArray5[2] >> 7 >> 7;
                    } else {
                        n6 = 25 - CGame.m_servicePower * 11 / 10;
                        n6 -= 2;
                        nArray[0] = CGame.m_serviceTargetPosX;
                        nArray[1] = 0;
                        nArray[2] = CGame.m_serviceTargetPosZ;
                        if (CGame.m_servicePower == 10) {
                            CGame.SoundPlay(16);
                            CGame.m_bIsBallTailActive = true;
                            CGame.m_ballTailTimeToDie = CGame.m_frameSequence - 1;
                            CGame.m_actorBall.m_gravity = 333;
                        } else {
                            CGame.SoundPlay(20);
                        }
                    }
                    nArray3[0] = n3 * 256;
                    nArray3[1] = 0;
                    nArray3[2] = n3 * 256;
                }
                CGame.m_bPowerMeterVisible = false;
                CGame.m_actorBall.m_bBallFell = false;
                CGame.m_cameraPriority[0] = 4;
                bl2 = true;
                if (bl && (!bl || !this.m_bIsPredictedMove)) break;
                CGame.m_actorBall.createGameEffect(CGame.m_actorBall.m_xReal, CGame.m_actorBall.m_yReal, CGame.m_actorBall.m_zReal, 7);
            }
        }
        if (n4 != -1) {
            CPlayer.getAreaCenter(nArray, n4);
            if ((n == 3 || n == 4) && nArray[0] < (n3 = bl3 ? 6912 * CGame.m_actorBall.m_yReal / Math.abs(this.m_xReal) + Math.abs(this.m_xReal) / 3 : 6912 * CGame.m_actorBall.m_yReal / Math.abs(this.m_xReal) + Math.abs(this.m_xReal) * 5 / 7)) {
                nArray[0] = n3;
            }
            if (n != 7) {
                if (this.m_xReal > 0) {
                    nArray[0] = nArray[0] * -1;
                }
            } else {
                if (n == 7) {
                    nArray[0] = nArray[0] - 500;
                    if (this.m_index == 1 && !CGame.m_bIsInstantPlay) {
                        n3 = CGame.random(30 * CGame.m_cfgWorldTourDifficulty + 30 * CGame.m_cfgCurrentLevel / 52, 1400 * CGame.m_cfgWorldTourDifficulty + 800 * CGame.m_cfgCurrentLevel / 52);
                        nArray[0] = nArray[0] + n3;
                    }
                }
                if (this.m_xReal < 0) {
                    nArray[0] = nArray[0] * -1;
                }
            }
            nArray[2] = nArray[1];
            nArray[1] = 0;
        }
        n3 = 90 - this.m_technique;
        if ((n3 += CGame.m_actorsGame[CGame.m_lastTouchPlayer].m_strength / 10) > 38) {
            n3 = 38;
        }
        if (CGame.m_actorBall.m_animation == 6 && (n == 1 || n == 6 || n == 7)) {
            CGame.m_actorBall.m_yForce = CGame.m_actorBall.m_yForce * -35 >> 7;
            CGame.m_actorBall.m_xForce = CGame.m_actorBall.m_xForce * 70 >> 7;
            CGame.m_actorBall.m_zForce = CGame.m_actorBall.m_zForce * 70 >> 7;
            CGame.m_actorBall.calculateFallSpot(false);
        } else if (CGame.random(0, 128) < n3 && n == 1 && (CGame.m_lastMove == 3 || CGame.m_lastMove == 3)) {
            n2 = CGame.m_actorsGame[CGame.m_lastTouchPlayer].m_strength;
            CGame.m_actorBall.m_xForce = CGame.m_actorBall.m_xForce * CGame.random(10 + n2 / 20, 20 + n2 / 20) >> 7;
            CGame.m_actorBall.m_yForce = CGame.m_actorBall.m_yForce * CGame.random(-80 - n2 / 10, -50) >> 7;
            CGame.m_actorBall.m_zForce = CGame.m_actorBall.m_zForce * CGame.random(20, 70 + n2 / 10) >> 7;
            CGame.m_actorBall.calculateFallSpot(false);
        } else {
            if ((n == 7 || n == 1 || n == 6) && this.m_moveToMake == 5 && this.m_index == 0) {
                CGame.setDisplayMsg(10);
            }
            if (this.m_moveToMake == 5 && this.m_index == 0 && (CGame.m_lastMove == 3 || CGame.m_lastMove == 4)) {
                Display.getDisplay((MIDlet)GloftBVB.instance).vibrate(300);
            }
            if (n == 7 || n == 1 || n == 6 || n == 8 || this.m_index == 0 && (n == 12 || n == 11)) {
                n5 = CGame.m_actorBall.getStrengthNeeded(nArray[0], nArray[1], nArray[2], n6);
            }
            if (n == 3 || n == 4) {
                n5 = n5 * this.m_strength >> 7;
            }
            if (n != 11 && n != 12 || this.m_index == 0) {
                CGame.m_actorBall.getForceNeeded(nArray2, nArray[0], nArray[1], nArray[2], n5);
            }
            if (Math.abs(nArray[0]) - nArray3[0] * 15 < 0 && (n == 3 || n == 4)) {
                nArray3[0] = 0;
            }
            if (CGame.m_gameMode != 3) {
                // empty if block
            }
            if ((n == 11 || n == 12) && nArray3[0] >> 1 > Math.abs(nArray2[0]) - 256) {
                nArray3[0] = 0;
            }
            if ((n == 11 || n == 12) && this.m_index == 0) {
                this.applyNoise(nArray2, nArray3[0], nArray3[1], nArray3[2]);
            }
            if (!(n != 3 && n != 4 || bl3)) {
                if (this.m_shootAccuracy <= -4) {
                    nArray2[0] = nArray2[0] + 2000;
                }
                if (this.m_shootAccuracy >= 4) {
                    nArray2[0] = 1800 * (nArray2[0] > 0 ? 1 : -1);
                    nArray2[1] = -5000;
                    nArray2[2] = 0;
                }
            }
            if (bl) {
                if (!this.m_bIsPredictedMove) {
                    if (this.m_predictedMoveVector == null) {
                        this.m_predictedMoveVector = new int[3];
                    }
                    this.m_predictedMoveVector[0] = nArray2[0];
                    this.m_predictedMoveVector[1] = nArray2[1];
                    this.m_predictedMoveVector[2] = nArray2[2];
                    CGame.m_actorBall.setForcePredicted(nArray2);
                    CGame.m_bIsPredictedMove = true;
                } else {
                    CGame.m_actorBall.setForce(this.m_predictedMoveVector);
                    CGame.m_bIsPredictedMove = false;
                }
            } else {
                if (CGame.m_actorBall.m_bDigSuccess) {
                    CGame.m_lastMove = 5;
                }
                CGame.m_actorBall.setForce(nArray2);
            }
        }
        if (!bl || bl && !this.m_bIsPredictedMove) {
            CGame.unlockPlayer();
        }
        CGame.changeTurn((this.m_team << 1) + (this.m_index + 1) % 2);
        if (bl2) {
            CGame.m_sideTeamTurn = this.m_xReal < 0 ? 1 : 0;
            CGame.m_playerTurn = -1;
        }
        if (bl && (!bl || !this.m_bIsPredictedMove) || !CGame.m_bMultiBallActivated || n == 4 || n == 3 || n == 12) {
            // empty if block
        }
        CGame.m_lastTouchPlayer = this.m_index;
        CGame.m_lastMove = n;
        CGame.clearDigSuccess();
        if (CGame.m_actorBall.m_animation == 6 && n != 3 && n != 4) {
            CGame.m_actorBall.setAnimation(0, 0);
        }
        if (this.m_powerTypeSpike != -1 || this.m_powerTypeBlock != -1 || this.m_powerTypeService != -1 || CGame.m_gameMode == 3) {
            this.m_powerMeter += n7;
            if (this.m_powerMeter >= 100) {
                this.m_powerMeter = 100;
            }
            this.m_updateMeter = 0 != n7;
        }
        if (this.m_index != 0 && (!bl || bl && this.m_bIsPredictedMove)) {
            this.AIcalculateOffensivePosition();
        }
    }

    public int calculateBestShotArea() {
        int[] nArray;
        int n;
        int n2;
        int n3;
        int[][] nArrayArray = new int[][]{{3, 0}, {4, 0}, {5, 0}, {6, 0}, {7, 0}, {8, 0}};
        int[] nArray2 = new int[2];
        for (n3 = 0; n3 < 6; ++n3) {
            CPlayer.getAreaCenter(nArray2, nArrayArray[n3][0]);
            int[] nArray3 = nArrayArray[n3];
            nArray3[1] = nArray3[1] + CPlayer.fastDistance(Math.abs(Math.abs(CGame.m_actorsGame[2 - (this.m_team << 1)].m_xReal) - nArray2[0]), Math.abs(Math.abs(CGame.m_actorsGame[2 - (this.m_team << 1)].m_zReal) - nArray2[1]));
            int[] nArray4 = nArrayArray[n3];
            nArray4[1] = nArray4[1] + CPlayer.fastDistance(Math.abs(Math.abs(CGame.m_actorsGame[3 - (this.m_team << 1)].m_xReal) - nArray2[0]), Math.abs(Math.abs(CGame.m_actorsGame[3 - (this.m_team << 1)].m_zReal) - nArray2[1]));
        }
        for (n3 = 0; n3 < 5; ++n3) {
            for (n2 = n3 + 1; n2 < 6; ++n2) {
                if (nArrayArray[n2][1] <= nArrayArray[n3][1]) continue;
                n = nArrayArray[n3][0];
                nArrayArray[n3][0] = nArrayArray[n2][0];
                nArrayArray[n2][0] = n;
                n = nArrayArray[n3][1];
                nArrayArray[n3][1] = nArrayArray[n2][1];
                nArrayArray[n2][1] = n;
            }
        }
        nArray = new int[]{this.m_technique > 128 ? 128 : this.m_technique * 102 >> 7, nArray[0] + (70 * (128 - nArray[0]) >> 7), nArray[1] + (30 * (128 - nArray[0]) >> 7), 128};
        n2 = CGame.random(0, 127);
        for (n = 0; n < 4; ++n) {
            if (n2 >= nArray[n]) continue;
            n2 = n;
            break;
        }
        return nArrayArray[n2][0];
    }

    public void applyNoise(int[] nArray, int n, int n2, int n3) {
        nArray[0] = nArray[0] + (CGame.random(0, 128) * n >> 7);
        if (this.m_moveToMake != 3 && this.m_moveToMake != 4) {
            nArray[0] = nArray[0] - (n >> 1);
        } else if (this.m_xReal > 0) {
            nArray[0] = nArray[0] - n;
        }
        nArray[1] = nArray[1] + ((CGame.random(0, 128) * n2 >> 7) - (n2 >> 1));
        nArray[2] = nArray[2] + ((CGame.random(0, 128) * n3 >> 7) - (n3 >> 1));
    }

    public boolean isInGoodSpot() {
        if (CGame.m_touchNumber == 2) {
            return this.isInSpot(0) || this.isInSpot(3);
        }
        if (CGame.m_moveRequiredHeight == CGame.BALL_OFFSETS_Y[3]) {
            if (this.m_xReal < 0) {
                return this.isInSpot(1);
            }
            return this.isInSpot(2);
        }
        return this.isInSpot(3);
    }

    public boolean isInAnySpot() {
        return this.isInSpot(3);
    }

    public boolean isInSpot(int n) {
        return Math.abs(this.m_xReal - CGame.m_actorBall.m_hotSpots[n][0]) < CGame.HS_HALF_WIDTH + CGame.PLAYER_HALF_WIDTH && Math.abs(this.m_zReal - CGame.m_actorBall.m_hotSpots[n][1]) < CGame.HS_HALF_HEIGHT + CGame.PLAYER_HALF_DEPTH;
    }

    public boolean setPlayerTargetArea(int n) {
        int[] nArray = new int[2];
        CPlayer.getAreaCenter(nArray, n);
        return this.setPlayerTarget(nArray[0] * (this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0)), nArray[1]);
    }

    public boolean setPlayerTarget(int n, int n2) {
        if (this.m_xReal == n && this.m_zReal == n2) {
            this.m_target = null;
            return true;
        }
        if (this.m_state == 8) {
            this.m_target = null;
            return false;
        }
        if (this.m_target == null) {
            this.m_target = new int[2];
        }
        this.m_target[0] = n;
        this.m_target[1] = n2;
        int n3 = this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0);
        switch (this.m_moveArea) {
            case 0: {
                if (Math.abs(this.m_target[0]) < 22400 + CGame.PLAYER_HALF_WIDTH - 4480 - 640) {
                    this.m_target[0] = (22400 + CGame.PLAYER_HALF_WIDTH - 4480 - 640) * n3;
                } else if (Math.abs(this.m_target[0]) > 22400) {
                    this.m_target[0] = 22400 * n3;
                }
                if (this.m_target[1] < 1280) {
                    this.m_target[1] = 1280;
                    break;
                }
                if (this.m_target[1] <= 11008) break;
                this.m_target[1] = 11008;
                break;
            }
            case 2: {
                if (Math.abs(this.m_target[0]) < CGame.PLAYER_HALF_WIDTH) {
                    this.m_target[0] = CGame.PLAYER_HALF_WIDTH * n3;
                } else if (Math.abs(this.m_target[0]) > 22400) {
                    this.m_target[0] = 22400 * n3;
                }
                if (this.m_target[1] < 1280) {
                    this.m_target[1] = 1280;
                    break;
                }
                if (this.m_target[1] <= 11008) break;
                this.m_target[1] = 11008;
            }
        }
        boolean bl = n == this.m_target[0] && n2 == this.m_target[1];
        return bl;
    }

    public void update() {
        if (!this.m_bIsFreeze) {
            switch (this.m_index) {
                case 0: {
                    this.updateUser();
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    if (CGame.m_gameMode == 3 && (CGame.m_tutorialStep == 5 || CGame.m_tutorialStep == 4 || CGame.m_menuIndex == 1)) break;
                    this.AIupdate();
                }
            }
            this.updateGenericPlayer();
        }
        this.toScreen();
    }

    public void updateUser() {
        if (this.m_moveToMake == 3 && !this.m_bMoveSelected) {
            this.m_shootAccuracy = 7 - (CGame.m_actorBall.m_spikingCounter - 6);
        }
        if (CGame.m_gameMode != 3 || CGame.m_tutorialStep >= 3 && CGame.m_tutorialStep % 2 == 1) {
            int n = -1;
            if ((CGame.m_nCurKey & 0x404) != 0) {
                n = 4;
            } else if ((CGame.m_nCurKey & 0x900) != 0) {
                n = 6;
            }
            if ((CGame.m_nCurKey & 0x1010) != 0) {
                n = n == 4 ? 7 : (n == 6 ? 9 : 3);
            } else if ((CGame.m_nCurKey & 0x2040) != 0) {
                n = n == 4 ? 8 : (n == 6 ? 10 : 5);
            } else if ((CGame.m_nCurKey & 2) != 0) {
                n = 7;
            } else if ((CGame.m_nCurKey & 8) != 0) {
                n = 8;
            } else if ((CGame.m_nCurKey & 0x80) != 0) {
                n = 9;
            } else if ((CGame.m_nCurKey & 0x200) != 0) {
                n = 10;
            }
            if (n > -1) {
                if (CGame.m_gameMode == 3) {
                    CGame.m_tutorialTryCounter = 0;
                }
                if (CGame.m_gameState != 14) {
                    this.cmdAction(n);
                } else {
                    this.miniGameCmdAction(n);
                }
            }
            if ((CGame.m_nKeyPress & 0x4020) != 0) {
                if (CGame.m_gameMode == 3) {
                    CGame.m_tutorialTryCounter = 0;
                }
                this.cmdAction(1);
            } else if ((CGame.m_nKeyPress & 1) != 0) {
                if (CGame.m_lockedPlayer == this.m_index || CGame.m_gameSubState == 0) {
                    this.cmdAction(2);
                } else {
                    CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_actionToMake = 2;
                }
            }
        }
    }

    public void updateGenericPlayer() {
        int n;
        int n2;
        if (this.m_target != null && (this.m_state == 1 || this.m_state == 0 || this.m_state == 8 || CGame.m_gameSubState == 0)) {
            n2 = 0;
            n = 0;
            if (this.m_target[0] < this.m_xReal) {
                n2 = -1;
            } else if (this.m_target[0] > this.m_xReal) {
                n2 = 1;
            }
            if (this.m_target[1] < this.m_zReal) {
                n = -1;
            } else if (this.m_target[1] > this.m_zReal) {
                n = 1;
            }
            this.moveDirection(n2, n);
            if (this.m_target != null && this.m_xReal == this.m_target[0] && this.m_zReal == this.m_target[1]) {
                this.m_target = null;
            }
        }
        if (!this.m_bMovedThisFrame) {
            if (this.m_state == 1) {
                this.changeState(0);
            }
            if (this.m_state == 3) {
                this.changeState(2);
            }
        }
        this.m_bMovedThisFrame = false;
        this.checkLockPlayer();
        switch (this.m_state) {
            case 8: {
                if (CGame.m_b300EffectActive) {
                    this.m_yReal += 128;
                    if (CGame.m_300EffectFrameCount < 10) {
                        --this.m_currentFrame;
                    } else {
                        this.m_yReal = 0;
                    }
                } else if (this.m_currentFrame == 4) {
                    if (CGame.m_actorsGame[0].m_state != 10) {
                        CGame.m_frameRate = 83;
                    }
                } else if (this.m_framesToDelaySpike > 0 && this.m_currentFrame + this.m_framesToDelaySpike >= 6) {
                    if (this.m_currentFrame == 5) {
                        --this.m_framesToDelaySpike;
                        --this.m_currentFrame;
                        this.m_yReal += 128;
                    } else if (!this.m_bAlreadyDelayedThisFrame) {
                        --this.m_framesToDelaySpike;
                        --this.m_currentFrame;
                        this.m_bAlreadyDelayedThisFrame = true;
                        this.m_yReal += 384;
                    } else {
                        this.m_bAlreadyDelayedThisFrame = false;
                        this.m_yReal -= 384;
                    }
                }
                if (this.m_currentFrame < 0) {
                    this.m_bAlreadyDelayedThisFrame = false;
                    ++this.m_framesToDelaySpike;
                    this.m_currentFrame = 0;
                }
                if (!this.m_bIsAnimationOver) break;
                this.m_bSpikeMiss = false;
                break;
            }
            case 11: {
                if (this.m_currentFrame < 2 || this.m_currentFrame > 5 || Math.abs(CGame.m_actorBall.m_xReal - (this.m_xReal + 0)) >= 2304 || Math.abs(CGame.m_actorBall.m_yReal - (this.m_yReal + 10496)) >= 15872 || Math.abs(CGame.m_actorBall.m_zReal - (this.m_zReal + 0)) >= 4992 || this.m_bBlocked) break;
                CGame.m_lastSuperMove = 1;
                if (this.m_index == 0) {
                    Display.getDisplay((MIDlet)GloftBVB.instance).vibrate(300);
                }
                CGame.m_bSpecialPowerEffectEnable = true;
                CGame.m_effectState = 2;
                CGame.SoundPlay(18);
                CGame.m_actorBall.setAnimation(0, 0);
                CGame.m_actorBall.m_xForce = -(CGame.m_actorBall.m_xForce / 2);
                CGame.m_actorBall.m_zForce /= 4;
                CGame.m_actorBall.m_yForce /= 4;
                this.m_bBlocked = true;
                CGame.m_actorBall.calculateFallSpot(false);
                CGame.unlockPlayer();
                break;
            }
            case 10: {
                if (this.m_currentFrame != 3 || this.m_currentFrameTime == 0) {
                    // empty if block
                }
                if (this.m_currentFrame < 2 || this.m_currentFrame > 5 || Math.abs(CGame.m_actorBall.m_xReal - (this.m_xReal + 0)) >= 1664 || Math.abs(CGame.m_actorBall.m_yReal - (this.m_yReal + 9216)) >= 3200 || Math.abs(CGame.m_actorBall.m_zReal - (this.m_zReal + 0)) >= 1536 || this.m_bBlocked || CGame.m_bMultiBallActivated) break;
                CGame.SoundPlay(18);
                if (CGame.m_actorBall.m_animation == 6) {
                    CGame.m_actorBall.m_yForce = CGame.m_actorBall.m_yForce * -35 >> 7;
                } else if (!CGame.m_bMultiBallActivated) {
                    n2 = 90 - this.m_technique;
                    n = CGame.m_actorsGame[CGame.m_lastTouchPlayer].m_strength;
                    if ((n2 += n / 10) > 38) {
                        n2 = 38;
                    }
                    if (CGame.random(0, 128) < n2) {
                        CGame.m_actorBall.m_xForce = CGame.m_actorBall.m_xForce * CGame.random(20 + n / 20, 50 + n / 20) >> 7;
                        CGame.m_actorBall.m_yForce = CGame.m_actorBall.m_yForce * CGame.random(-90 + n / 10, -45) >> 7;
                        CGame.m_actorBall.m_zForce = CGame.m_actorBall.m_zForce * CGame.random(20, 70 + n / 10) >> 7;
                        CGame.m_moveRequiredHeight = CGame.BALL_OFFSETS_Y[3];
                    } else {
                        CGame.m_framesToSetFPSNormal += 5;
                        if (this.m_index == 0) {
                            Display.getDisplay((MIDlet)GloftBVB.instance).vibrate(300);
                        }
                        CGame.m_bSpecialPowerEffectEnable = true;
                        CGame.m_effectState = 2;
                        CGame.m_actorBall.m_xForce = -(CGame.m_actorBall.m_xForce / 2);
                        CGame.m_actorBall.m_zForce /= 4;
                    }
                }
                CGame.changeTurn((this.m_team << 1) + (this.m_index + 1) % 2);
                CGame.clearDigSuccess();
                this.m_bBlocked = true;
                CGame.m_lastTouchPlayer = this.m_index;
                CGame.m_sideTeamTurn = this.m_xReal > 0 ? 1 : 0;
                CGame.m_lastMove = 13;
                CGame.m_actorBall.m_yForce /= 4;
                CGame.m_actorBall.calculateFallSpot(false);
                CGame.m_actorBall.setAnimation(0, 0);
                CGame.unlockPlayer();
                break;
            }
            case 1: {
                if (CGame.m_gameState != 11 || CGame.m_gameSubState != 0 && CGame.m_gameSubState != 1) break;
                if (this.m_blockDecision == 0) {
                    this.m_faceDirection = this.m_xReal > CGame.m_actorBall.m_hotSpots[4][0] ? 1 : 0;
                    break;
                }
                this.m_faceDirection = this.m_xReal < 0 ? 0 : 1;
                break;
            }
            case 0: {
                if (CGame.m_gameState != 11 || CGame.m_gameSubState != 1) break;
                if (this.m_target == null && this.m_bIsLocked) {
                    this.setAnim(3);
                }
                if (this.m_blockDecision == 0) {
                    this.m_faceDirection = this.m_xReal > CGame.m_actorBall.m_hotSpots[4][0] ? 1 : 0;
                    break;
                }
                this.m_faceDirection = this.m_xReal < 0 ? 0 : 1;
                break;
            }
            case 4: {
                if (this.m_currentFrame != 8 || this.m_currentFrameTime != 0) break;
                this.makeMove(11, false);
                this.m_moveArea = 2;
                CGame.m_gameSubState = 1;
                if (this.m_index == 0 && CGame.m_gameMode != 3) {
                    this.setPlayerTarget(8960 * (this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0)), 6144);
                }
                CGame.m_lastTouchPlayer = this.m_index;
                break;
            }
            case 5: {
                if (this.m_currentFrame >= 5 && this.m_currentFrame < 16 && this.m_currentFrameTime == 0) {
                    this.m_xReal += this.m_xReal > 0 ? -768 : 768;
                }
                if (this.m_currentFrame == 12 && this.m_currentFrameTime == 0 && this.m_powerTypeService == 2 && this.m_powerMeter >= 100) {
                    CGame.m_bSpecialPowerEffectEnable = true;
                    CGame.SoundPlay(6);
                    CGame.m_specialPowerActivated = 2;
                }
                if (this.m_currentFrame != 13 || this.m_currentFrameTime != 0) break;
                this.makeMove(12, false);
                this.m_moveArea = 2;
                CGame.m_gameSubState = 1;
                if (this.m_index == 0 && CGame.m_gameMode != 3) {
                    this.setPlayerTarget(8960 * (this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0)), 6144);
                }
                CGame.m_lastTouchPlayer = this.m_index;
                break;
            }
            case 9: {
                n2 = this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0);
                this.m_xReal += this.m_xDigForce;
                this.m_zReal += this.m_zDigForce;
                if (n2 != (this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0))) {
                    this.m_xReal = CGame.PLAYER_HALF_WIDTH * n2;
                }
                this.moveDirection(0, 0);
                if (this.m_runningDirection == 4) {
                    if (this.m_currentFrame != 3) break;
                    this.m_xDigForce = 0;
                    this.m_zDigForce = 0;
                    break;
                }
                if (this.m_currentFrame != 4) break;
                this.m_xDigForce = 0;
                this.m_zDigForce = 0;
            }
        }
        if (this.isAnimOver() && this.m_state != 2 && this.m_state != 3) {
            this.changeState(0);
        }
        this.checkLimits();
        this.m_flip = this.m_faceDirection;
        if (this.m_bIsLocked && this.m_state == 0) {
            ++this.m_framesBeingLocked;
        }
    }

    public void checkLimits() {
        int n = Math.abs(this.m_xReal);
        int n2 = this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0);
        switch (this.m_moveArea) {
            case 2: {
                if (n < CGame.PLAYER_HALF_WIDTH) {
                    this.m_xReal = CGame.PLAYER_HALF_WIDTH * n2;
                } else if (n > 22400) {
                    this.m_xReal = 22400 * n2;
                }
                if (this.m_zReal < 1280) {
                    this.m_zReal = 1280;
                    break;
                }
                if (this.m_zReal <= 11008) break;
                this.m_zReal = 11008;
            }
        }
    }

    public void updateFacing() {
        if (this.m_state == 1 || this.m_state == 0) {
            this.m_faceDirection = this.m_xReal > CGame.m_actorBall.m_hotSpots[4][0] ? 1 : 0;
        }
    }

    void AIdecideReceiveBall() {
        if (CGame.m_playerTurn == -1) {
            if (this.m_decision == 0 && CGame.m_actorBall.m_predictedMoveCounter < CGame.m_preditecShowFrame) {
                if (this.m_actionToMake != 0) {
                    this.m_decision = 2;
                } else {
                    int n = CGame.DISTANCE_CALCULATE_ERROR[0] + CGame.DISTANCE_CALCULATE_ERROR[1] * this.m_technique / 100;
                    int n2 = CGame.random(0, 99);
                    boolean bl = this.isInsideMySideCourt(CGame.m_actorBall.m_hotSpots[4][0], CGame.m_actorBall.m_hotSpots[4][1]);
                    if (this.AIisFallSpotNearCourtLine() && n2 < n) {
                        bl = !bl;
                    }
                    int n3 = 15 + 75 * this.m_technique / 100;
                    boolean bl2 = CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_state == 10 && CGame.random(0, 99) < n3;
                    this.m_decision = bl && this.AIisMyCoveringArea() || bl2 ? 2 : 1;
                }
            }
            if (this.m_decision == 2) {
                this.setPlayerTarget(CGame.m_actorBall.m_hotSpots[3][0], CGame.m_actorBall.m_hotSpots[3][1]);
            }
        } else if (CGame.m_playerTurn == this.m_index) {
            this.setPlayerTarget(CGame.m_actorBall.m_hotSpots[3][0], CGame.m_actorBall.m_hotSpots[3][1]);
        }
    }

    public void AIupdate() {
        switch (CGame.m_gameSubState) {
            case 0: {
                this.AIserviceDecisions();
                break;
            }
            case 1: {
                if (CGame.m_sideTeamTurn != (this.m_xReal > 0 ? 1 : 0)) {
                    this.AIcalculatedefensePosition();
                    break;
                }
                if (CGame.m_lockedPlayer != -1 || CGame.m_bMultiBallActivated) break;
                this.AIdecideReceiveBall();
            }
        }
    }

    void AIserviceDecisions() {
        if (CGame.m_playerServicer[CGame.m_serviceSide] == this.m_index) {
            switch (CGame.m_serviceState) {
                case 1: {
                    int n = this.m_index > 1 && CGame.random(0, 99) < 75 ? CGame.m_actorsGame[0].m_zReal : 7936 / CGame.random(1, 6) + 2176;
                    CGame.m_serviceType = CGame.random(0, 1);
                    if (CGame.m_serviceType != 0) {
                        this.setPlayerTarget(this.m_xReal > 0 ? 22400 : -22400, n);
                    } else {
                        this.setPlayerTarget(this.m_xReal, n);
                    }
                    CGame.m_serviceState = 2;
                    break;
                }
                case 4: {
                    CGame.m_servicePower = CGame.random(6, 10);
                    CGame.m_serviceAccuracy = CGame.random(4, 8);
                    if (CGame.m_serviceType == 1) {
                        this.changeState(5);
                        break;
                    }
                    this.changeState(4);
                }
            }
        } else if (CGame.m_serviceSide == (this.m_xReal > 0 ? 1 : 0)) {
            CPlayer cPlayer = CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2];
            if (this.m_zReal > 6144 && cPlayer.m_zReal > 6144) {
                this.setPlayerTargetArea(5);
            } else if (this.m_zReal < 6144 && cPlayer.m_zReal < 6144) {
                this.setPlayerTargetArea(3);
            }
        } else {
            CPlayer cPlayer = CGame.m_actorsGame[CGame.m_playerServicer[CGame.m_serviceSide]];
            if (this.m_zReal < 6144) {
                if (cPlayer.m_zReal > 6144) {
                    this.setPlayerTargetArea(5);
                } else {
                    this.setPlayerTargetArea(8);
                }
            } else if (this.m_zReal > 6144) {
                if (cPlayer.m_zReal < 6144) {
                    this.setPlayerTargetArea(3);
                } else {
                    this.setPlayerTargetArea(6);
                }
            }
        }
    }

    void AIdecideAttack() {
        int n;
        int n2 = 0;
        int n3 = this.getColumn();
        if (n3 < 3) {
            n2 = this.m_spikeAttackProbability[n3];
        }
        if ((n = CGame.random(0, 99)) < n2 && this.changeMoveToMake(3)) {
            this.m_shootAccuracy = this.AIdecideSpikeAccuracy();
        }
    }

    int AIdecideSpikeAccuracy() {
        int n = 0;
        int n2 = CGame.random(0, 99);
        n = n2 < this.m_spikeAccuracyProbability ? 0 : ((n2 = CGame.random(0, 99)) < 50 ? 4 : -4);
        return n;
    }

    boolean AIdecideSpikeSecondTouch() {
        int n = CGame.random(0, 99);
        if (this.m_index > 1 && CGame.m_bEnableSpike && n < this.m_spikeAttackProbability[3] && this.changeMoveToMake(3)) {
            this.m_shootAccuracy = this.AIdecideSpikeAccuracy();
            return true;
        }
        return false;
    }

    boolean AIdecideMakeRollShot() {
        boolean bl = false;
        int n = CGame.random(0, 99);
        int n2 = 0;
        if (CGame.m_actorsGame[2 - (this.m_team << 1)].m_state == 10 || CGame.m_actorsGame[3 - (this.m_team << 1)].m_state == 10) {
            n2 = 0;
        } else {
            int n3 = CGame.m_actorsGame[2 - (this.m_team << 1)].getColumn();
            int n4 = CGame.m_actorsGame[2 - (this.m_team << 1)].getColumn();
            n2 = n3 > 1 && n4 > 1 ? 2 : (n3 > 0 && n4 > 0 ? 1 : 3);
        }
        if (n < this.m_rollshotProbality[n2]) {
            bl = true;
        }
        return bl;
    }

    void AIdecideBlock() {
        this.m_blockDecision = 0;
        if (this.m_index != 0 && Math.abs(this.m_xReal) < 8960) {
            int n;
            int n2 = CGame.random(0, 99);
            int n3 = n = CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_blockDecision == 0 ? 0 : 3;
            if (this.m_index == 1 && Math.abs(CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal) < 8960) {
                n = 2;
            }
            this.m_blockDecision = 0;
            if (n2 < this.m_blockProbability[0] >> n) {
                this.m_blockDecision = 1;
            } else if (n2 < (this.m_blockProbability[0] >> n) + (this.m_blockProbability[1] >> n)) {
                this.m_blockDecision = 2;
            } else if (n2 < (this.m_blockProbability[0] >> n) + (this.m_blockProbability[1] >> n) + (this.m_blockProbability[2] >> n)) {
                this.m_blockDecision = 3;
            }
            if (this.m_blockDecision > 0) {
                this.setPlayerTarget(CGame.PLAYER_HALF_WIDTH * (this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0)), CGame.m_actorBall.m_hotSpots[0][1]);
            }
        }
    }

    void AIcalculateOffensivePosition() {
        switch (CGame.m_lastMove) {
            case 3: 
            case 6: {
                this.AIcalculatedefensePosition();
                break;
            }
            case 7: {
                int n;
                if (CGame.m_lastTouchPlayer != this.m_index) break;
                if (this.m_index == 2) {
                    int n2 = this.AIcalculateOpponentRowdefensePosition(CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].getRow());
                    n = n2 * 2645 - 1322 + 2176;
                } else {
                    n = this.m_zReal < CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_zReal && this.m_zReal < CGame.m_actorBall.m_hotSpots[3][1] ? 2176 : 10112;
                }
                int n3 = 8960 * (this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0));
                this.setPlayerTarget(n3, n);
                break;
            }
            case 1: 
            case 5: {
                int n = 8789;
                int n4 = 5973 * (this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0));
                if (CGame.m_actorBall.m_hotSpots[3][1] > 6144) {
                    n = 3498;
                }
                this.setPlayerTarget(n4, n);
            }
        }
    }

    private void AIcalculatedefensePosition() {
        boolean bl;
        CPlayer cPlayer;
        if (this.m_target != null) {
            return;
        }
        CPlayer cPlayer2 = cPlayer = this.m_index == 2 ? CGame.m_actorsGame[0] : CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2];
        if (this.m_blockDecision != 0) {
            if (cPlayer.m_blockDecision != 0) {
                if (cPlayer.m_zReal > this.m_zReal) {
                    this.setPlayerTarget(CGame.PLAYER_HALF_WIDTH * (this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0)), CGame.m_actorBall.m_hotSpots[0][1] - 1536);
                } else {
                    this.setPlayerTarget(CGame.PLAYER_HALF_WIDTH * (this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0)), CGame.m_actorBall.m_hotSpots[0][1] + 1536);
                }
            } else {
                return;
            }
        }
        int n = this.getRow();
        int n2 = this.getColumn();
        int n3 = cPlayer.getRow();
        int n4 = n;
        int n5 = n2;
        if (n3 == 4) {
            --n3;
        } else if (n3 == 0) {
            ++n3;
        }
        int n6 = cPlayer.getColumn();
        if (n6 == 3) {
            --n6;
        }
        boolean bl2 = bl = !this.isInsideMySideCourt(this.m_xReal, this.m_zReal);
        if (cPlayer.m_state == 10 || cPlayer.m_blockDecision != 0) {
            n4 = 2;
            n5 = 1;
        } else if (this.m_index == 2) {
            if (this.m_referenceRow != n3 || bl) {
                n4 = this.AIcalculateOpponentRowdefensePosition(n3);
            }
            if (this.m_referenceCol != n6 || bl) {
                n5 = this.AIcalculateOpponentColdefensePosition(n6);
            }
        } else {
            boolean bl3 = bl = bl || Math.abs(cPlayer.m_xReal - this.m_xReal) < 5120;
            if (this.m_referenceRow != n3 || n == n3 || bl) {
                n4 = this.AIcalculatePartnerRowdefensePosition(n3);
            }
            if (this.m_referenceCol != n6 || n2 == n6 || bl) {
                n5 = this.AIcalculatePartnerColdefensePosition(n6);
            }
        }
        int n7 = n4 * 2645 - 1322 + 2176;
        int n8 = (n5 * 5973 + 2986) * (this.m_xReal > 0 ? 1 : (this.m_xReal < 0 ? -1 : 0));
        this.setPlayerTarget(n8, n7);
        this.m_referenceCol = n6;
        this.m_referenceRow = n3;
    }

    int AIcalculateOpponentRowdefensePosition(int n) {
        int n2;
        int n3 = CGame.random(0, 99);
        int n4 = n2 = this.getRow();
        switch (n) {
            case 1: {
                if (n2 == 1 || n2 == 2) break;
                n4 = n3 < this.m_defensePositionRow[0] ? 1 : 2;
                break;
            }
            case 2: {
                if (n2 == 1 || n2 == 3) break;
                n4 = n3 < this.m_defensePositionRow[1] ? 2 : (n3 < this.m_defensePositionRow[2] ? 1 : 3);
                break;
            }
            case 3: {
                if (n2 == 2 || n2 == 3) break;
                n4 = n3 < this.m_defensePositionRow[3] ? 3 : 2;
                break;
            }
            default: {
                n4 = this.m_zReal > 6144 ? 1 : 3;
            }
        }
        return n4;
    }

    int AIcalculateOpponentColdefensePosition(int n) {
        int n2 = CGame.random(0, 99);
        int n3 = this.m_defensePositionCol[0] < n2 ? 0 : (this.m_defensePositionCol[1] < n2 ? 1 : 2);
        return n3;
    }

    int AIcalculatePartnerRowdefensePosition(int n) {
        int n2 = CGame.random(0, 99);
        int n3 = this.getRow();
        if (n3 > 3) {
            n3 = 3;
        }
        if (n3 < 1) {
            n3 = 1;
        }
        int n4 = n3;
        switch (n) {
            case 1: {
                n4 = n2 < this.m_defensePositionRow[0] ? 3 : 2;
                break;
            }
            case 2: {
                if (n3 != 2) break;
                n4 = n2 < this.m_defensePositionRow[1] ? 1 : 3;
                break;
            }
            case 3: {
                n4 = n2 < this.m_defensePositionRow[2] ? 1 : 2;
            }
        }
        return n4;
    }

    int AIcalculatePartnerColdefensePosition(int n) {
        int n2 = CGame.random(0, 99);
        int n3 = this.getColumn();
        int n4 = 1;
        switch (n) {
            case 0: {
                n4 = n2 < this.m_defensePositionCol[0] ? 1 : 2;
                break;
            }
            case 1: {
                if (n3 != 1) break;
                n4 = n2 < this.m_defensePositionCol[1] ? 0 : 2;
                break;
            }
            case 2: {
                n4 = n2 < this.m_defensePositionCol[0] ? 1 : 0;
            }
        }
        return n4;
    }

    private boolean AIisMyCoveringArea() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n3 = CGame.m_actorBall.m_hotSpots[4][0] - this.m_xReal;
        if (this.m_xReal > 0) {
            n3 = -n3;
        }
        n3 = n3 > 0 ? n3 * 128 >> 7 : Math.abs(n3) * 270 >> 7;
        n4 = Math.abs(CGame.m_actorBall.m_hotSpots[4][1] - this.m_zReal) * 340 >> 7;
        n = n3 + n4;
        n3 = CGame.m_actorBall.m_hotSpots[4][0] - CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal;
        if (CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_xReal > 0) {
            n3 = -n3;
        }
        if (n <= (n2 = (n3 = n3 > 0 ? n3 * 128 >> 7 : Math.abs(n3) * 270 >> 7) + (n4 = Math.abs(CGame.m_actorBall.m_hotSpots[4][1] - CGame.m_actorsGame[(this.m_team << 1) + (this.m_index + 1) % 2].m_zReal) * 340 >> 7))) {
            bl = true;
        }
        if (CGame.m_gameMode == 3) {
            bl = false;
        }
        return bl;
    }

    boolean AIisFallSpotNearCourtLine() {
        return Math.abs(CGame.m_actorBall.m_hotSpots[4][1] - 2176) < 440 || Math.abs(CGame.m_actorBall.m_hotSpots[4][1] - 10112) < 440 || Math.abs(Math.abs(CGame.m_actorBall.m_hotSpots[4][0]) - 17920) < 995;
    }

    public void toScreen() {
        super.toScreen();
        this.m_shadowPosy = this.m_screenPosition[1] + ((this.m_yReal >> 7) * 122 >> 7);
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.m_animation < 0) {
            return;
        }
        this.draw(graphics, this.m_animation, this.m_currentFrame, n, n2, this.m_flip);
        if (this.m_index == 0) {
            CPlayer.drawPlayerCursor(graphics, this.m_animation, this.m_currentFrame, n, s_cursorPosY);
        } else if (this.m_index == 1 && CGame.m_gameState != 14) {
            this.m_emoticon.draw(graphics, n, s_cursorPosY);
            if (!this.m_bIsFreeze && CGame.m_gameState != 45) {
                if (this.m_emoticonDuration > 0) {
                    --this.m_emoticonDuration;
                }
                if (this.m_emoticonDuration == 0) {
                    this.m_emoticon.setAnimation(-1);
                }
            }
        }
        this.updateAnimation(this.m_spritesArray[this.m_spriteId]);
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (this.m_animation < 0) {
            return;
        }
        int n6 = n3;
        int n7 = n4;
        ASprite aSprite = this.m_spritesArray[this.m_spriteId];
        aSprite.SetCurrentPalette(this.m_pal);
        int n8 = aSprite._anims_af_start[n] + n2;
        int n9 = aSprite._aframes_frame[n8] & 0xFF;
        n6 = (n5 & 1) != 0 ? (n6 -= aSprite._aframes_ox[n8]) : (n6 += aSprite._aframes_ox[n8]);
        int n10 = aSprite._frames_nfm[n9] & 0xFF;
        this.PaintPlayerFrame(aSprite, n9, n6, n7 += aSprite._aframes_oy[n8], n5 ^ aSprite._aframes_flags[n8] & 0xF);
        if (n == 7 || n == 16 && n2 < 7 || n == 15 && n2 == 0) {
            ASprite aSprite2 = CGame.m_sprHairs[this.m_hairStyle];
            aSprite2.SetCurrentPalette(this.m_hairColor);
            aSprite2.PaintFrame(n9, n6, n7, n5 ^ aSprite._aframes_flags[n8] & 0xF);
            s_cursorPosY = n7 + aSprite2._fmodules_oy[aSprite2._frames_fm_start[n9]];
        }
    }

    static int getYOffset(ASprite aSprite, int n, int n2) {
        int n3 = 0;
        int n4 = aSprite._anims_af_start[n] + n2;
        int n5 = aSprite._aframes_frame[n4] & 0xFF;
        n3 += aSprite._aframes_oy[n4];
        return n3 += aSprite._fmodules_oy[aSprite._frames_fm_start[n5]];
    }

    public static int getFrameXOffset(ASprite aSprite, int n) {
        int n2 = 0;
        return n2;
    }

    static void drawPlayerCursor(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = n4 - 20;
        int n7 = 3;
        if (n5 < 0) {
            n5 = 5;
            n6 = n4 - 29;
            n7 = 4;
        } else if (n5 > 176) {
            n5 = 171;
            n6 = n4 - 29;
            n7 = 4;
        }
        if (CGame.m_gameMode == 3 && (CGame.m_tutorialStep == 1 || CGame.m_tutorialStep > 2 && CGame.m_tutorialStep % 2 == 1) && CGame.m_frameSequence - CGame.m_tutorialResetStepCounter < 20) {
            n6 = n6 - 10 + (CGame.m_frameSequence - CGame.m_tutorialResetStepCounter >> 1);
        }
        if (CGame.m_gameMode != 3 || CGame.m_frameSequence - CGame.m_tutorialResetStepCounter < 20 && (CGame.m_frameSequence & 2) != 0 && CGame.m_tutorialStep > 2 && CGame.m_tutorialStep % 2 == 1 && CGame.m_bIsTutorialStepInitialState || CGame.m_frameSequence - CGame.m_tutorialResetStepCounter >= 20 && CGame.m_tutorialStep % 2 == 1 && CGame.m_tutorialStep > 2) {
            CGame.m_sprSpots.PaintFrame(n7, n5, n6 + 10, 0);
        }
    }

    public void drawShadow(Graphics graphics) {
        int n = this.m_animation >= 15 && this.m_animation <= 18 ? 1 + ((this.m_animation - 15) * 12 + this.m_currentFrame) : 0;
        CPlayer.drawShadow(graphics, n, this.m_screenPosition[0], this.m_shadowPosy, this.m_flip);
        if (CGame.m_bEnableSkillsEdit) {
            graphics.setColor(0xFF0000);
            graphics.drawRect(this.m_screenPosition[0] - (CGame.PLAYER_HALF_WIDTH >> 7), this.m_shadowPosy - (CGame.PLAYER_HALF_DEPTH >> 7), CGame.PLAYER_HALF_WIDTH << 1 >> 7, CGame.PLAYER_HALF_DEPTH << 1 >> 7);
        }
    }

    public static void drawShadow(Graphics graphics, int n, int n2, int n3, int n4) {
        CGame.m_sprShadows.PaintFrame(graphics, n, n2, n3, n4, 0, 0);
    }

    public boolean isAnimOver() {
        return this.m_bIsAnimationOver;
    }

    public void showEmoticon(int n, int n2) {
        this.m_emoticon.setAnimation(n, 0);
        this.m_emoticonDuration = n2;
    }

    public void setAnim(int n) {
        if (!this.m_bIsAnimationOver && this.m_animation == n) {
            return;
        }
        int n2 = -1;
        switch (n) {
            case 1: 
            case 2: 
            case 8: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 3;
            }
        }
        this.setAnimation(n, n2);
    }

    void PaintPlayerFrame(ASprite aSprite, int n, int n2, int n3, int n4) {
        int n5 = aSprite._frames_nfm[n] & 0xFF;
        for (int i = 0; i < n5; ++i) {
            this.PaintPlayerFModule(aSprite, n, i, n2, n3, n4);
        }
    }

    void PaintPlayerFModule(ASprite aSprite, int n, int n2, int n3, int n4, int n5) {
        int n6 = aSprite._frames_fm_start[n] + n2;
        int n7 = aSprite._fmodules_flags[n6] & 0xFF;
        int n8 = aSprite._fmodules_id[n6] & 0xFF;
        int n9 = n3;
        int n10 = n4;
        if (n7 >= 64 && n7 <= 67) {
            n8 += 256;
        }
        n3 = (n5 & 1) != 0 ? (n3 -= aSprite._fmodules_ox[n6] + (aSprite._modules_w[n8 |= (n7 & 0xC0) << 2] & 0xFF)) : (n3 += aSprite._fmodules_ox[n6]);
        n4 = (n5 & 2) != 0 ? (n4 -= aSprite._fmodules_oy[n6] + (aSprite._modules_h[n8] & 0xFF)) : (n4 += aSprite._fmodules_oy[n6]);
        aSprite.PaintModule(n8, n3, n4, n5 ^ n7 & 0xF);
        if (n8 < 33) {
            ASprite aSprite2 = CGame.m_sprHairs[this.m_hairStyle];
            aSprite2.SetCurrentPalette(this.m_hairColor);
            aSprite2.PaintFrame(n, n9, n10, n5);
            s_cursorPosY = n10 + aSprite2._fmodules_oy[aSprite2._frames_fm_start[n]];
        } else if (s_bdrawSwimsuit) {
            if (n8 >= 33 && n8 <= 130) {
                ASprite aSprite3 = CGame.m_sprSwimsuits[this.m_swimsuitStyle];
                aSprite3._poolorder = 4;
                aSprite3.SetCurrentPalette(this.m_swimsuitColor);
                aSprite3.PaintModule(n8 - 33, n3, n4, n5 ^ n7 & 0xF);
            } else if (this.m_swimsuitStyle == 1 && n8 >= 254 && n8 <= 324) {
                ASprite aSprite4 = CGame.m_sprSwimsuits[this.m_swimsuitStyle];
                aSprite4._poolorder = 4;
                aSprite4.SetCurrentPalette(this.m_swimsuitColor);
            }
        }
    }
}

