/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CActor {
    public int m_index;
    public int m_type;
    public int[] m_screenPosition = new int[2];
    public int m_xReal;
    public int m_yReal;
    public int m_zReal;
    public int m_spriteId;
    public int m_pal;
    public int m_currentFrame;
    public int m_currentFrameTime;
    public int m_loopFrame;
    public int m_animation;
    public int m_flip;
    public boolean m_bIsAnimationOver;
    public boolean m_bIsFreeze;
    public int m_activeBox0;
    public int m_activeBox1;
    public int m_activeBox2;
    public int m_activeBox3;
    public ASprite[] m_spritesArray;

    public CActor(int n, int n2) {
        this.m_index = n;
        this.m_spriteId = n2;
        this.m_animation = -1;
        this.m_bIsFreeze = false;
        this.m_spritesArray = CGame.m_sprActors;
    }

    public CActor(int n, int n2, int n3) {
        this.m_index = n;
        this.m_spriteId = n2;
        this.m_type = n3;
        this.setActiveBox();
        this.m_bIsFreeze = false;
        this.m_spritesArray = CGame.m_sprActors;
    }

    public void setAnimation(int n) {
        this.m_animation = n;
        this.m_loopFrame = -1;
        this.m_bIsAnimationOver = false;
        this.m_currentFrame = 0;
        this.m_currentFrameTime = 0;
    }

    public void setAnimation(int n, int n2) {
        this.setAnimation(n);
        this.m_loopFrame = n2;
    }

    public void set3DPosition(int n, int n2, int n3) {
        this.m_xReal = n;
        this.m_yReal = n2;
        this.m_zReal = n3;
        this.toScreen();
    }

    public void setScreenPosition(int n, int n2) {
        this.m_screenPosition[0] = n;
        this.m_screenPosition[1] = n2;
    }

    public void setActiveBox() {
        if (this.m_type > 0) {
            byte[] byArray = CGame.ACTOR_ACTIVE_ZONE[this.m_type];
            this.m_activeBox0 = byArray[0];
            this.m_activeBox1 = byArray[1];
            this.m_activeBox2 = byArray[2];
            this.m_activeBox3 = byArray[3];
        }
    }

    public void toScreen() {
        CGame.project3Dto2D(this.m_screenPosition, this.m_xReal, this.m_yReal, this.m_zReal);
        CGame.translateToScreen(this.m_screenPosition);
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, this.m_screenPosition[0], this.m_screenPosition[1]);
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (n <= -25 || n >= 201 || n2 <= 0 || n2 >= 204) {
            return;
        }
        if (this.m_animation < 0) {
            return;
        }
        ASprite aSprite = this.m_spritesArray[this.m_spriteId];
        aSprite.SetCurrentPalette(this.m_pal);
        aSprite.PaintAFrame(this.m_animation, this.m_currentFrame, n, n2, this.m_flip);
        this.updateAnimation(aSprite);
    }

    void updateAnimation(ASprite aSprite) {
        if (!CGame.s_freezeActors && !this.m_bIsFreeze) {
            int n;
            int n2 = 0;
            int n3 = 1;
            n2 = aSprite.GetAFrameTime(this.m_animation, this.m_currentFrame);
            ++this.m_currentFrameTime;
            if (this.m_currentFrameTime >= n2) {
                this.m_currentFrame += n3;
                this.m_currentFrameTime = 0;
            }
            if (this.m_currentFrame >= (n = aSprite.GetAFrames(this.m_animation))) {
                this.m_currentFrameTime = 0;
                if (this.m_loopFrame >= 0) {
                    this.m_currentFrame = this.m_loopFrame;
                } else {
                    --this.m_currentFrame;
                    this.m_bIsAnimationOver = true;
                    if (this.m_loopFrame == -1) {
                        this.m_animation = -1;
                    }
                }
            }
        }
    }
}

