/*
 * Decompiled with CFR 0.152.
 */
package com.magmic;

public class Slide {
    public int[] x = new int[3];
    public int duration;
    public int progress;
    public static final int MAX_SUPPORTED_DEGREE = 2;
    public static final int LAST = 2;
    public int mode;
    public static final int MODE_LINEAR = 1;

    public void init(int n, int n2, int n3) {
        this.init_ex(n, n2, n3, 1);
    }

    public void init_ex(int n, int n2, int n3, int n4) {
        this.duration = n3;
        this.progress = 0;
        this.mode = n4;
        this.x[0] = n;
        this.x[2] = n2;
    }

    public void restart() {
        this.progress = 0;
    }

    public void init_reverse() {
        this.init_ex(this.get(), this.x[0], this.progress, this.mode);
    }

    public void clear() {
        for (int i = 0; i < 3; ++i) {
            this.x[i] = 0;
        }
        this.progress = 0;
        this.duration = 0;
        this.mode = 1;
    }

    public boolean tick(int n) {
        if (this.progress == this.duration) {
            return false;
        }
        this.progress += n;
        if (this.progress > this.duration) {
            this.progress = this.duration;
        }
        return true;
    }

    public boolean tick_till_end() {
        return this.tick(this.duration);
    }

    public boolean is_done() {
        return this.progress == this.duration;
    }

    public int getStart() {
        return this.getP(this.x, 0);
    }

    public int get() {
        return this.getP(this.x, this.progress);
    }

    public int getDestination() {
        return this.getP(this.x, this.duration);
    }

    private int getP(int[] nArray, int n) {
        int n2 = 0;
        if (this.duration == 0) {
            n2 = nArray[0];
        } else {
            switch (this.mode) {
                case 1: {
                    n2 = nArray[0] + n * (nArray[2] - nArray[0]) / this.duration;
                }
            }
        }
        return n2;
    }
}

