/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.slic;

import com.magmic.maglet.Maglet;
import com.magmic.slic.Slic;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class SprInfo {
    public boolean initialized = false;
    public short[][] progs;
    public short[][] frameXY;
    public short[][] frameResID;
    public short[][] frameCutID;
    private String filename;

    SprInfo(String string) {
        this.filename = string;
    }

    void create(Slic slic) throws IOException {
        Maglet.getInstance();
        InputStream inputStream = Maglet.getResourceInputStream(this.filename);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readShort();
        this.progs = new short[n][];
        this.frameXY = new short[n][];
        this.frameResID = new short[n][];
        this.frameCutID = new short[n][];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = dataInputStream.readShort();
            this.frameXY[i] = new short[n3 * 2];
            this.frameResID[i] = new short[n3];
            this.frameCutID[i] = new short[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.frameXY[i][n2 * 2] = dataInputStream.readShort();
                this.frameXY[i][n2 * 2 + 1] = dataInputStream.readShort();
                this.frameResID[i][n2] = dataInputStream.readShort();
                this.frameCutID[i][n2] = dataInputStream.readShort();
                slic.getResInfo(this.frameResID[i][n2]);
            }
            n2 = dataInputStream.readShort();
            if (n2 == 0) continue;
            this.progs[i] = new short[n2];
            for (int j = 0; j < n2; ++j) {
                this.progs[i][j] = dataInputStream.readShort();
            }
        }
        inputStream.close();
        this.initialized = true;
    }

    void destroy() {
        this.progs = null;
        this.frameXY = null;
        this.frameResID = null;
        this.frameCutID = null;
        this.initialized = false;
    }
}

