/*
 * Decompiled with CFR 0.152.
 */
package com.magmic;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class MagmicIO {
    public byte[] buffer;
    public int buffer_offset;
    private int buffer_length;
    public int pointer;
    public InputStream in;
    public OutputStream out;
    public IOException exception;

    public void bind(byte[] byArray, int n, int n2) {
        this.unbind();
        this.buffer = byArray;
        this.buffer_offset = n;
        this.buffer_length = n2;
        this.pointer = 0;
    }

    public void bind(InputStream inputStream) {
        this.unbind();
        this.in = inputStream;
    }

    public void bind(OutputStream outputStream) {
        this.unbind();
        this.out = outputStream;
    }

    public void unbind() {
        this.in = null;
        this.out = null;
        this.buffer = null;
        this.buffer_offset = 0;
        this.buffer_length = 0;
        this.pointer = 0;
        this.exception = null;
    }

    public long read_s64_big() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 8;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return (long)(this.buffer[n] & 0xFF) << 56 | (long)(this.buffer[n + 1] & 0xFF) << 48 | (long)(this.buffer[n + 2] & 0xFF) << 40 | (long)(this.buffer[n + 3] & 0xFF) << 32 | (long)(this.buffer[n + 4] & 0xFF) << 24 | (long)(this.buffer[n + 5] & 0xFF) << 16 | (long)(this.buffer[n + 6] & 0xFF) << 8 | (long)(this.buffer[this.buffer_offset + 7] & 0xFF);
            }
            if (this.in != null) {
                return (long)(this.in.read() & 0xFF) << 56 | (long)(this.in.read() & 0xFF) << 48 | (long)(this.in.read() & 0xFF) << 40 | (long)(this.in.read() & 0xFF) << 32 | (long)(this.in.read() & 0xFF) << 24 | (long)(this.in.read() & 0xFF) << 16 | (long)(this.in.read() & 0xFF) << 8 | (long)(this.in.read() & 0xFF);
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0L;
        }
        throw new NullPointerException();
    }

    public int read_s32_big() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 4;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return (this.buffer[n] & 0xFF) << 24 | (this.buffer[n + 1] & 0xFF) << 16 | (this.buffer[n + 2] & 0xFF) << 8 | this.buffer[n + 3] & 0xFF;
            }
            if (this.in != null) {
                return (this.in.read() & 0xFF) << 24 | (this.in.read() & 0xFF) << 16 | (this.in.read() & 0xFF) << 8 | this.in.read() & 0xFF;
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0;
        }
        throw new NullPointerException();
    }

    public short read_s16_big() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 2;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return (short)((this.buffer[n] & 0xFF) << 8 | this.buffer[n + 1] & 0xFF);
            }
            if (this.in != null) {
                return (short)((this.in.read() & 0xFF) << 8 | this.in.read() & 0xFF);
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0;
        }
        throw new NullPointerException();
    }

    public char read_char_big() {
        return (char)this.read_s16_big();
    }

    public byte read_s8() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                ++this.pointer;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return this.buffer[n];
            }
            if (this.in != null) {
                return (byte)this.in.read();
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0;
        }
        throw new NullPointerException();
    }

    public long read_u32_big() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 4;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return (long)((this.buffer[n] & 0xFF) << 24 | (this.buffer[n + 1] & 0xFF) << 16 | (this.buffer[n + 2] & 0xFF) << 8 | this.buffer[n + 3] & 0xFF) & 0xFFFFFFFFL;
            }
            if (this.in != null) {
                return (long)((this.in.read() & 0xFF) << 24 | (this.in.read() & 0xFF) << 16 | (this.in.read() & 0xFF) << 8 | this.in.read() & 0xFF) & 0xFFFFFFFFL;
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0L;
        }
        throw new NullPointerException();
    }

    public int read_u16_big() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 2;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return ((this.buffer[n] & 0xFF) << 8) + (this.buffer[n + 1] & 0xFF);
            }
            if (this.in != null) {
                return ((this.in.read() & 0xFF) << 8) + (this.in.read() & 0xFF);
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0;
        }
        throw new NullPointerException();
    }

    public short read_u8() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                ++this.pointer;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return (short)(this.buffer[n] & 0xFF);
            }
            if (this.in != null) {
                return (short)(this.in.read() & 0xFF);
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0;
        }
        throw new NullPointerException();
    }

    public void write_s64_big(long l) {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 8;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n] = (byte)((l & 0xFF00000000000000L) >> 56);
                this.buffer[n + 1] = (byte)((l & 0xFF000000000000L) >> 48);
                this.buffer[n + 2] = (byte)((l & 0xFF0000000000L) >> 40);
                this.buffer[n + 3] = (byte)((l & 0xFF00000000L) >> 32);
                this.buffer[n + 4] = (byte)((l & 0xFFFFFFFFFF000000L) >> 24);
                this.buffer[n + 5] = (byte)((l & 0xFF0000L) >> 16);
                this.buffer[n + 6] = (byte)((l & 0xFF00L) >> 8);
                this.buffer[n + 7] = (byte)(l & 0xFFL);
            }
            if (this.out != null) {
                this.out.write((byte)((l & 0xFF00000000000000L) >> 56));
                this.out.write((byte)((l & 0xFF000000000000L) >> 48));
                this.out.write((byte)((l & 0xFF0000000000L) >> 40));
                this.out.write((byte)((l & 0xFF00000000L) >> 32));
                this.out.write((byte)((l & 0xFFFFFFFFFF000000L) >> 24));
                this.out.write((byte)((l & 0xFF0000L) >> 16));
                this.out.write((byte)((l & 0xFF00L) >> 8));
                this.out.write((byte)(l & 0xFFL));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void write_s32_big(int n) {
        try {
            if (this.buffer != null) {
                int n2 = this.buffer_offset + this.pointer;
                this.pointer += 4;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n2] = (byte)((n & 0xFF000000) >> 24);
                this.buffer[n2 + 1] = (byte)((n & 0xFF0000) >> 16);
                this.buffer[n2 + 2] = (byte)((n & 0xFF00) >> 8);
                this.buffer[n2 + 3] = (byte)(n & 0xFF);
            }
            if (this.out != null) {
                this.out.write((byte)((n & 0xFF000000) >> 24));
                this.out.write((byte)((n & 0xFF0000) >> 16));
                this.out.write((byte)((n & 0xFF00) >> 8));
                this.out.write((byte)(n & 0xFF));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void write_s16_big(short s) {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 2;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n] = (byte)((s & 0xFF00) >> 8);
                this.buffer[n + 1] = (byte)(s & 0xFF);
            }
            if (this.out != null) {
                this.out.write((byte)((s & 0xFF00) >> 8));
                this.out.write((byte)(s & 0xFF));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void write_s8(byte by) {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                ++this.pointer;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n] = by;
            }
            if (this.out != null) {
                this.out.write(by);
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void write_u32_big(long l) {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 4;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n] = (byte)(l >> 24 & 0xFFL);
                this.buffer[n + 1] = (byte)(l >> 16 & 0xFFL);
                this.buffer[n + 2] = (byte)(l >> 8 & 0xFFL);
                this.buffer[n + 3] = (byte)(l & 0xFFL);
            }
            if (this.out != null) {
                this.out.write((byte)(l >> 24 & 0xFFL));
                this.out.write((byte)(l >> 16 & 0xFFL));
                this.out.write((byte)(l >> 8 & 0xFFL));
                this.out.write((byte)(l & 0xFFL));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void write_u16_big(int n) {
        try {
            if (this.buffer != null) {
                int n2 = this.buffer_offset + this.pointer;
                this.pointer += 2;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n2] = (byte)(n >> 8 & 0xFF);
                this.buffer[n2 + 1] = (byte)(n & 0xFF);
            }
            if (this.out != null) {
                this.out.write((byte)(n >> 8 & 0xFF));
                this.out.write((byte)(n & 0xFF));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void write_u8(short s) {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                ++this.pointer;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n] = (byte)(s & 0xFF);
            }
            if (this.out != null) {
                this.out.write((byte)(s & 0xFF));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void write_u8(boolean bl) {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                ++this.pointer;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n] = (byte)(bl ? 1 : 0);
            }
            if (this.out != null) {
                this.out.write((byte)(bl ? 1 : 0));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public long read_s64() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 8;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return (long)(this.buffer[n + 7] & 0xFF) << 56 | (long)(this.buffer[n + 6] & 0xFF) << 48 | (long)(this.buffer[n + 5] & 0xFF) << 40 | (long)(this.buffer[n + 4] & 0xFF) << 32 | (long)(this.buffer[n + 3] & 0xFF) << 24 | (long)(this.buffer[n + 2] & 0xFF) << 16 | (long)(this.buffer[n + 1] & 0xFF) << 8 | (long)(this.buffer[n] & 0xFF);
            }
            if (this.in != null) {
                return (long)(this.in.read() & 0xFF) | (long)(this.in.read() & 0xFF) << 8 | (long)(this.in.read() & 0xFF) << 16 | (long)(this.in.read() & 0xFF) << 24 | (long)(this.in.read() & 0xFF) << 32 | (long)(this.in.read() & 0xFF) << 40 | (long)(this.in.read() & 0xFF) << 48 | (long)(this.in.read() & 0xFF) << 56;
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0L;
        }
        throw new NullPointerException();
    }

    public int read_s32() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 4;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return (this.buffer[n + 3] & 0xFF) << 24 | (this.buffer[n + 2] & 0xFF) << 16 | (this.buffer[n + 1] & 0xFF) << 8 | this.buffer[n] & 0xFF;
            }
            if (this.in != null) {
                return this.in.read() & 0xFF | (this.in.read() & 0xFF) << 8 | (this.in.read() & 0xFF) << 16 | (this.in.read() & 0xFF) << 24;
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0;
        }
        throw new NullPointerException();
    }

    public short read_s16() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 2;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return (short)((this.buffer[n + 1] & 0xFF) << 8 | this.buffer[n] & 0xFF);
            }
            if (this.in != null) {
                return (short)(this.in.read() & 0xFF | (this.in.read() & 0xFF) << 8);
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0;
        }
        throw new NullPointerException();
    }

    public char read_char() {
        return (char)this.read_s16();
    }

    public long read_u32() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 4;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return (long)((this.buffer[n + 3] & 0xFF) << 24 | (this.buffer[n + 2] & 0xFF) << 16 | (this.buffer[n + 1] & 0xFF) << 8 | this.buffer[n] & 0xFF) & 0xFFFFFFFFL;
            }
            if (this.in != null) {
                return (long)(this.in.read() & 0xFF | (this.in.read() & 0xFF) << 8 | (this.in.read() & 0xFF) << 16 | (this.in.read() & 0xFF) << 24) & 0xFFFFFFFFL;
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0L;
        }
        throw new NullPointerException();
    }

    public int read_u16() {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 2;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                return this.buffer[n] & 0xFF | (this.buffer[n + 1] & 0xFF) << 8;
            }
            if (this.in != null) {
                return this.in.read() & 0xFF | (this.in.read() & 0xFF) << 8;
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return 0;
        }
        throw new NullPointerException();
    }

    public void write_s64(long l) {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 8;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n] = (byte)(l & 0xFFL);
                this.buffer[n + 1] = (byte)((l & 0xFF00L) >> 8);
                this.buffer[n + 2] = (byte)((l & 0xFF0000L) >> 16);
                this.buffer[n + 3] = (byte)((l & 0xFFFFFFFFFF000000L) >> 24);
                this.buffer[n + 4] = (byte)((l & 0xFF00000000L) >> 32);
                this.buffer[n + 5] = (byte)((l & 0xFF0000000000L) >> 40);
                this.buffer[n + 6] = (byte)((l & 0xFF000000000000L) >> 48);
                this.buffer[n + 7] = (byte)((l & 0xFF00000000000000L) >> 56);
            }
            if (this.out != null) {
                this.out.write((byte)(l & 0xFFL));
                this.out.write((byte)((l & 0xFF00L) >> 8));
                this.out.write((byte)((l & 0xFF0000L) >> 16));
                this.out.write((byte)((l & 0xFFFFFFFFFF000000L) >> 24));
                this.out.write((byte)((l & 0xFF00000000L) >> 32));
                this.out.write((byte)((l & 0xFF0000000000L) >> 40));
                this.out.write((byte)((l & 0xFF000000000000L) >> 48));
                this.out.write((byte)((l & 0xFF00000000000000L) >> 56));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void write_s32(int n) {
        try {
            if (this.buffer != null) {
                int n2 = this.buffer_offset + this.pointer;
                this.pointer += 4;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n2] = (byte)(n & 0xFF);
                this.buffer[n2 + 1] = (byte)((n & 0xFF00) >> 8);
                this.buffer[n2 + 2] = (byte)((n & 0xFF0000) >> 16);
                this.buffer[n2 + 3] = (byte)((n & 0xFF000000) >> 24);
            }
            if (this.out != null) {
                this.out.write((byte)(n & 0xFF));
                this.out.write((byte)((n & 0xFF00) >> 8));
                this.out.write((byte)((n & 0xFF0000) >> 16));
                this.out.write((byte)((n & 0xFF000000) >> 24));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void write_s16(short s) {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 2;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n] = (byte)(s & 0xFF);
                this.buffer[n + 1] = (byte)((s & 0xFF00) >> 8);
            }
            if (this.out != null) {
                this.out.write((byte)(s & 0xFF));
                this.out.write((byte)((s & 0xFF00) >> 8));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void write_u32(long l) {
        try {
            if (this.buffer != null) {
                int n = this.buffer_offset + this.pointer;
                this.pointer += 4;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n] = (byte)(l & 0xFFL);
                this.buffer[n + 1] = (byte)(l >> 8 & 0xFFL);
                this.buffer[n + 2] = (byte)(l >> 16 & 0xFFL);
                this.buffer[n + 3] = (byte)(l >> 24 & 0xFFL);
            }
            if (this.out != null) {
                this.out.write((byte)(l & 0xFFL));
                this.out.write((byte)(l >> 8 & 0xFFL));
                this.out.write((byte)(l >> 16 & 0xFFL));
                this.out.write((byte)(l >> 24 & 0xFFL));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void write_u16(int n) {
        try {
            if (this.buffer != null) {
                int n2 = this.buffer_offset + this.pointer;
                this.pointer += 2;
                if (this.pointer > this.buffer_length) {
                    throw new EOFException();
                }
                this.buffer[n2] = (byte)(n & 0xFF);
                this.buffer[n2 + 1] = (byte)(n >> 8 & 0xFF);
            }
            if (this.out != null) {
                this.out.write((byte)(n & 0xFF));
                this.out.write((byte)(n >> 8 & 0xFF));
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void read_bytes(byte[] byArray) {
        try {
            this.readFully(byArray);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void read_bytes(byte[] byArray, int n, int n2) {
        try {
            this.readFully(byArray, n, n2);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void skip(int n) {
        try {
            this.skipBytes(n);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void set_pointer(int n) {
        if (this.buffer != null) {
            this.pointer = n;
        }
    }

    public boolean readBoolean() throws IOException {
        boolean bl;
        boolean bl2 = bl = this.read_u8() != 0;
        if (this.exception != null) {
            throw this.exception;
        }
        return bl;
    }

    public byte readByte() throws IOException {
        byte by = this.read_s8();
        if (this.exception != null) {
            throw this.exception;
        }
        return by;
    }

    public char readChar() throws IOException {
        char c = (char)this.read_s16_big();
        if (this.exception != null) {
            throw this.exception;
        }
        return c;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer != null) {
            if (n2 > this.buffer_length - this.pointer) {
                throw new EOFException();
            }
            System.arraycopy(this.buffer, this.buffer_offset + this.pointer, byArray, n, n2);
            this.pointer += n2;
        }
        if (this.in != null) {
            MagmicIO.readFully(this.in, byArray, n, n2);
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 > 0) {
                continue;
            }
            throw new IOException("Didn't read the expected amount of bytes: " + i + "/" + n2 + " " + n3);
        }
    }

    public int readInt() throws IOException {
        int n = this.read_s32_big();
        if (this.exception != null) {
            throw this.exception;
        }
        return n;
    }

    public long readLong() throws IOException {
        long l = this.read_s64_big();
        if (this.exception != null) {
            throw this.exception;
        }
        return l;
    }

    public short readShort() throws IOException {
        short s = this.read_s16_big();
        if (this.exception != null) {
            throw this.exception;
        }
        return s;
    }

    public int readUnsignedByte() throws IOException {
        short s = this.read_u8();
        if (this.exception != null) {
            throw this.exception;
        }
        return s;
    }

    public int readUnsignedShort() throws IOException {
        int n = this.read_u16_big();
        if (this.exception != null) {
            throw this.exception;
        }
        return n;
    }

    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        int n2 = this.buffer_offset + this.pointer;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.pointer - n2 < n) {
            short s;
            short s2 = this.read_u8();
            if ((s2 & 0x80) == 0) {
                stringBuffer.append((char)s2);
                continue;
            }
            if ((s2 & 0x60) == 64) {
                s = this.read_u8();
                if ((s & 0xC0) == 128) {
                    stringBuffer.append((char)((s2 & 0x1F) << 6 | s & 0x3F));
                    continue;
                }
                throw new UTFDataFormatException();
            }
            if ((s2 & 0xF0) != 224) continue;
            s = this.read_u8();
            short s3 = this.read_u8();
            if ((s & 0xC0) == 128 && (s3 & 0xC0) == 128) {
                stringBuffer.append((char)((s2 & 0xF) << 12 | (s & 0x3F) << 6 | s3 & 0x3F));
                continue;
            }
            throw new UTFDataFormatException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return new String(stringBuffer);
    }

    public int skipBytes(int n) throws IOException {
        if (this.buffer != null) {
            this.pointer += n;
            if (this.pointer > this.buffer_length) {
                throw new IOException();
            }
            return n;
        }
        if (this.in != null) {
            int n2 = (int)this.in.skip(n);
            if (n2 != n) {
                throw new IOException();
            }
            return n;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        throw new NullPointerException();
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer != null) {
            if (n2 > this.buffer_length - this.pointer) {
                throw new EOFException();
            }
            System.arraycopy(byArray, n, this.buffer, this.buffer_offset + this.pointer, n2);
            this.pointer += n2;
        }
        if (this.out != null) {
            this.out.write(byArray, n, n2);
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void write(int n) throws IOException {
        this.write_s8((byte)n);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write_u8(bl);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void writeByte(int n) throws IOException {
        this.write_s8((byte)n);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void writeChar(int n) throws IOException {
        this.write_u16_big(n);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void writeChars(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.writeChar(string.charAt(i));
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void writeInt(int n) throws IOException {
        this.write_s32_big(n);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void writeLong(long l) throws IOException {
        this.write_s64_big(l);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void writeShort(int n) throws IOException {
        this.write_s16_big((short)n);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void writeUTF(String string) throws IOException {
        char c;
        int n;
        int n2 = 0;
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            c = string.charAt(n);
            if (c <= '\u007f' && c > '\u0000') {
                ++n2;
                continue;
            }
            if (c < '\u07ff') {
                n2 += 2;
                continue;
            }
            n2 += 3;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        this.write_u16_big(n2);
        for (n = 0; n < n3; ++n) {
            c = string.charAt(n);
            if (c <= '\u007f' && c > '\u0000') {
                this.writeByte((byte)c);
                continue;
            }
            if (c < '\u07ff') {
                this.writeByte((byte)(0xC0 | 0x1F & c >> 6));
                this.writeByte((byte)(0x80 | 0x3F & c));
                continue;
            }
            this.writeByte((byte)(0xE0 | 0xF & c >> 12));
            this.writeByte((byte)(0x80 | 0x3F & c >> 6));
            this.writeByte((byte)(0x80 | 0x3F & c));
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void write_string_8(String string) {
        int n = string.length();
        this.write_u16(n);
        for (int i = 0; i < n; ++i) {
            this.write_s8((byte)string.charAt(i));
        }
    }

    public void write_string_8(char[] cArray, int n, int n2) {
        int n3 = n2;
        this.write_u16(n3);
        for (int i = 0; i < n3; ++i) {
            this.write_s8((byte)cArray[n + i]);
        }
    }

    public String read_string_8() {
        int n = this.read_u16();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.read_s8();
        }
        return new String(cArray);
    }

    public int read_string_8(char[] cArray, int n) {
        int n2 = this.read_u16();
        for (int i = 0; i < n2; ++i) {
            cArray[n + i] = (char)this.read_s8();
        }
        return n2;
    }
}

