/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.net;

import com.magmic.net.NetClient;
import com.magmic.net.NetClientListener;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class OnlineMenu
extends Form
implements CommandListener,
NetClientListener,
ItemCommandListener {
    private CommandListener listener;
    private NetClient netClient;
    private Display display;
    private static final Command CMD_LOGIN_CREATE = new Command("Proceed", 1, 1);
    private static final Command CMD_LOGIN = new Command("Login", 8, 1);
    private static final Command CMD_CREATE = new Command("Create", 8, 1);
    private static final Command CMD_LOGOUT = new Command("Logout", 1, 1);
    private static final Command CMD_CANCEL = new Command("Cancel", 2, 1);
    private static final Command CMD_BACK_TO_MENU = new Command("Back", 2, 1);
    private static final Command CMD_BACK = new Command("Back", 2, 1);
    private boolean waitingForNetResponse = false;
    private TextField usernameField = new TextField("username", "", 14, 0);
    private TextField passwordField = new TextField("password", "", 14, 65536);
    private TextField emailField = new TextField("email", "", 50, 1);
    private StringItem loginField = new StringItem(null, "login");
    private StringItem loginCreateField = new StringItem(null, "create");
    private Image loginImage = null;
    private Image createImage = null;
    private ImageItem loginButton = null;
    private ImageItem createButton = null;

    public OnlineMenu(NetClient netClient, Display display, CommandListener commandListener) {
        super("Magmic Online");
        this.listener = commandListener;
        this.display = display;
        this.netClient = netClient;
        this.netClient.setListener(this);
    }

    private boolean isInputValide(String string) {
        string = string.toLowerCase();
        char[] cArray = string.toCharArray();
        block3: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case ' ': 
                case ',': 
                case '-': 
                case '.': 
                case '@': 
                case '_': {
                    continue block3;
                }
                default: {
                    if (cArray[i] >= 'a' && cArray[i] <= 'z' || cArray[i] >= '0' && cArray[i] <= '9') continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkTextFieldsInput() {
        if (!this.isInputValide(this.usernameField.getString()) || !this.isInputValide(this.passwordField.getString())) {
            this.showErrorScreen("Invalid username or password input. Only alphanumeric characters plus the hyphen, space, underscore, comma, period and @ sign are valid.");
            return false;
        }
        return true;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == CMD_BACK_TO_MENU) {
            this.netClient.setListener(null);
            this.listener.commandAction(CMD_BACK_TO_MENU, (Displayable)this);
        } else if (command == CMD_LOGIN) {
            if (!this.checkTextFieldsInput()) {
                return;
            }
            if (!this.waitingForNetResponse) {
                this.waitingForNetResponse = true;
                this.showWorkingScreen();
                this.netClient.setUsername(this.usernameField.getString().toLowerCase());
                this.netClient.setPassword(this.passwordField.getString().toLowerCase());
                this.netClient.setEmail(this.emailField.getString());
                this.netClient.request((byte)2);
            }
        } else if (command == CMD_CREATE) {
            if (!this.checkTextFieldsInput()) {
                return;
            }
            if (!this.waitingForNetResponse) {
                this.waitingForNetResponse = true;
                this.showWorkingScreen();
                this.netClient.setUsername(this.usernameField.getString().toLowerCase());
                this.netClient.setPassword(this.passwordField.getString().toLowerCase());
                this.netClient.setEmail(this.emailField.getString().toLowerCase());
                this.netClient.request((byte)1);
            }
        } else if (command == CMD_LOGIN_CREATE) {
            this.showLoginCreateScreen();
        } else if (command == CMD_BACK) {
            this.waitingForNetResponse = false;
            this.showLoginCreateScreen();
        } else if (command == CMD_CANCEL) {
            this.waitingForNetResponse = false;
            this.showMainScreen();
        } else if (command == CMD_LOGOUT) {
            this.netClient.logout();
            this.showMainScreen();
        }
    }

    public void commandAction(Command command, Item item) {
        if (command == CMD_LOGIN) {
            if (!this.checkTextFieldsInput()) {
                return;
            }
            if (!this.waitingForNetResponse) {
                this.waitingForNetResponse = true;
                this.showWorkingScreen();
                this.netClient.setUsername(this.usernameField.getString().toLowerCase());
                this.netClient.setPassword(this.passwordField.getString().toLowerCase());
                this.netClient.setEmail(this.emailField.getString());
                this.netClient.request((byte)2);
            }
        } else if (command == CMD_CREATE) {
            if (!this.checkTextFieldsInput()) {
                return;
            }
            if (!this.waitingForNetResponse) {
                this.waitingForNetResponse = true;
                this.showWorkingScreen();
                this.netClient.setUsername(this.usernameField.getString().toLowerCase());
                this.netClient.setPassword(this.passwordField.getString().toLowerCase());
                this.netClient.setEmail(this.emailField.getString().toLowerCase());
                this.netClient.request((byte)1);
            }
        }
    }

    private void showLoginCreateScreen() {
        Form form = new Form("Magmic Online");
        String string = this.netClient.getUsername();
        String string2 = this.netClient.getPassword();
        String string3 = this.netClient.getEmail();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        try {
            this.loginImage = Image.createImage((String)"/login.png");
            this.createImage = Image.createImage((String)"/create.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.usernameField = new TextField("username", string, 14, 0);
        this.passwordField = new TextField("password", string2, 14, 65536);
        this.emailField = new TextField("email", string3, 50, 1);
        this.loginField = new StringItem(null, "login");
        this.loginCreateField = new StringItem(null, "\ncreate");
        this.loginButton = new ImageItem(null, this.loginImage, 32, "Login", 2);
        this.createButton = new ImageItem(null, this.createImage, 32, "Create Account", 2);
        this.loginButton.setDefaultCommand(CMD_LOGIN);
        this.loginButton.setItemCommandListener((ItemCommandListener)this);
        this.createButton.setDefaultCommand(CMD_CREATE);
        this.createButton.setItemCommandListener((ItemCommandListener)this);
        this.loginField.setDefaultCommand(CMD_LOGIN);
        this.loginField.setItemCommandListener((ItemCommandListener)this);
        this.loginCreateField.setDefaultCommand(CMD_CREATE);
        this.loginCreateField.setItemCommandListener((ItemCommandListener)this);
        form.append((Item)this.usernameField);
        form.append((Item)this.passwordField);
        form.append((Item)this.emailField);
        form.append((Item)this.loginButton);
        form.append((Item)this.createButton);
        form.addCommand(CMD_CANCEL);
        form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)form);
    }

    private void showWorkingScreen() {
        Form form = new Form("Magmic Online");
        form.append("Please Wait, Connecting...");
        form.addCommand(CMD_CANCEL);
        form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)form);
    }

    public void netClientEvent(byte by, int n, Object object) {
        this.waitingForNetResponse = false;
        if (n != 100) {
            this.showErrorScreen(NetClient.respToString(n));
        } else {
            this.showMainScreen();
        }
    }

    public void showMainScreen() {
        Form form = new Form("Magmic Online");
        if (this.netClient.isLoggedIn()) {
            form.append("You are currently: logged in");
        } else {
            form.append("You are currently: logged out. ");
            form.append("Please select the 'Proceed' option to login or create an account");
        }
        if (this.netClient.isLoggedIn()) {
            form.addCommand(CMD_LOGOUT);
        } else {
            form.addCommand(CMD_LOGIN_CREATE);
        }
        form.addCommand(CMD_BACK_TO_MENU);
        form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)form);
    }

    private void showErrorScreen(String string) {
        Form form = new Form("Magmic Online");
        form.append("Error: " + string);
        form.addCommand(CMD_BACK);
        form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)form);
    }
}

