/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.slic;

import com.magmic.slic.ResInfo;
import com.magmic.slic.Slic;
import com.magmic.slic.SprInfo;
import com.magmic.ui.MagmicGraphics;
import com.magmic.ui.MagmicImage;
import java.util.Random;

public class Spr {
    protected Slic slic;
    protected SprInfo info;
    protected int sprInfoID;
    protected int seqID;
    protected int frameID;
    protected int actDelta;
    protected short[] progData;
    protected int progPC;
    protected int progDelta;
    protected int progR0;
    protected int progR1;
    protected int progR2;
    protected int progR3;
    protected boolean progCont;
    private boolean isProgramDone;
    protected boolean show;
    protected boolean queueDestroy;
    public static final int PROG_WAIT = 0;
    public static final int PROG_HOLD = 1;
    public static final int PROG_NEXT_FRAME = 2;
    public static final int PROG_PLAY_SOUND = 3;
    public static final int PROG_GOTO_CODE = 4;
    public static final int PROG_GOTO_FRAME = 5;
    public static final int PROG_CALLBACK = 6;
    public static final int PROG_SHOW = 7;
    public static final int PROG_HIDE = 8;
    public static final int PROG_DESTROY = 9;
    private static Random random = new Random();
    private final int WIDTH_PARAMETER;
    private final int HEIGTH_PARAMETER;

    public Spr(Slic slic, int n) {
        this.WIDTH_PARAMETER = 2;
        this.HEIGTH_PARAMETER = 3;
        this.slic = slic;
        this.init(n);
    }

    public void destroy() {
        this.slic.releaseSprInfo(this.sprInfoID);
        this.progData = null;
    }

    public void changeSprite(int n) {
        if (this.sprInfoID == n) {
            return;
        }
        this.slic.releaseSprInfo(this.sprInfoID);
        this.init(n);
    }

    private void init(int n) {
        this.sprInfoID = n;
        this.info = this.slic.getSprInfo(n);
        this.show = true;
        this.queueDestroy = false;
        this.frameID = 0;
        this.progPC = 0;
        this.setSeq(0);
    }

    public int getSeq() {
        return this.seqID;
    }

    public int getSeqCount() {
        if (this.info != null) {
            return this.info.progs.length;
        }
        return 0;
    }

    public void setSeq(int n) {
        this.seqID = n;
        this.progData = (short[])(this.sprInfoID != 0 && this.info.progs != null && this.info.progs.length > 0 && this.info.progs[n] != null && this.info.progs[n].length > 0 ? this.info.progs[this.seqID] : null);
        this.frameID = 0;
        this.progPC = 0;
        this.progDelta = 0;
        this.progR0 = 0;
        this.progR1 = 0;
        this.progR2 = 0;
        this.progR3 = 0;
        this.isProgramDone = this.progData == null || this.progData.length == 0;
        this.calc(0);
    }

    public void set_seq_ex(int n, boolean bl) {
        if (!bl) {
            this.setSeq(n);
            return;
        }
        this.seqID = n;
        this.progData = (short[])(this.sprInfoID != 0 && this.info.progs != null && this.info.progs.length > 0 && this.info.progs[this.seqID] != null && this.info.progs[this.seqID].length > 0 ? this.info.progs[this.seqID] : null);
        this.isProgramDone = this.progData == null || this.progData.length == 0 | this.progPC >= this.progData.length;
    }

    public int get_frame() {
        return this.frameID;
    }

    public void set_frame(int n) {
        if (this.sprInfoID != 0) {
            this.frameID = n % this.info.frameCutID[this.seqID].length;
        }
    }

    public static final String commandToString(int n) {
        switch (n) {
            case 0: {
                return "WAIT";
            }
            case 2: {
                return "NEXT_FRAME";
            }
            case 3: {
                return "PLAY_SOUND";
            }
            case 4: {
                return "GOTO_CODE";
            }
            case 5: {
                return "GOTO_FRAME";
            }
            case 6: {
                return "CALLBACK";
            }
            case 7: {
                return "SHOW";
            }
            case 8: {
                return "DESTROY";
            }
        }
        return "UNKNOWN";
    }

    public void calc(int n) {
        if (this.isProgramDone || this.progData == null || this.progData.length == 0) {
            return;
        }
        this.actDelta = n;
        do {
            this.progCont = false;
            switch (this.progData[this.progPC]) {
                case 0: {
                    short s = this.progData[this.progPC + 1];
                    if (this.progDelta >= s) {
                        this.progDelta -= s;
                        this.nextProg(2);
                        break;
                    }
                    this.progDelta += this.actDelta;
                    this.actDelta = 0;
                    if (this.progDelta < s) break;
                    this.actDelta = this.progDelta - s;
                    this.progDelta -= s;
                    this.nextProg(2);
                    break;
                }
                case 2: {
                    ++this.frameID;
                    if (this.frameID >= this.info.frameCutID[this.seqID].length) {
                        this.frameID = 0;
                    }
                    this.nextProg(1);
                    break;
                }
                case 3: {
                    this.nextProg(2);
                    break;
                }
                case 4: {
                    this.progPC = this.progData[this.progPC + 1];
                    this.nextProg(0);
                    break;
                }
                case 5: {
                    this.frameID = this.progData[this.progPC + 1];
                    this.nextProg(2);
                    break;
                }
                case 6: {
                    this.slic.prgCb(this, this.progPC + 3, this.progPC + 1, this.progData);
                    this.nextProg(2 + this.progData[this.progPC + 1]);
                    break;
                }
                case 7: {
                    this.show = true;
                    this.nextProg(1);
                    break;
                }
                case 8: {
                    this.show = false;
                    this.nextProg(1);
                    break;
                }
            }
        } while (this.progCont);
    }

    protected void nextProg(int n) {
        this.progPC += n;
        if (this.progPC >= this.progData.length) {
            this.progPC = 0;
            this.progCont = false;
            this.isProgramDone = true;
        } else {
            this.progCont = true;
        }
    }

    public void paint(MagmicGraphics magmicGraphics, int n, int n2) {
        short s;
        if (this.show && this.sprInfoID != 0 && (s = this.info.frameResID[this.seqID][this.frameID]) != 0) {
            ResInfo resInfo = this.slic.resInfo[s];
            MagmicImage magmicImage = this.slic.images[resInfo.imageID];
            n -= this.info.frameXY[this.seqID][this.frameID << 1];
            n2 -= this.info.frameXY[this.seqID][(this.frameID << 1) + 1];
            int n3 = this.info.frameCutID[this.seqID][this.frameID] * 4;
            short s2 = resInfo.cuts[n3];
            short s3 = resInfo.cuts[n3 + 1];
            short s4 = resInfo.cuts[n3 + 2];
            short s5 = resInfo.cuts[n3 + 3];
            magmicImage.drawRegion(magmicGraphics, n, n2, s4, s5, s2, s3);
        }
    }

    public void randomize_frame() {
        if (this.sprInfoID != 0) {
            this.frameID = Spr.rand() % this.info.frameCutID[this.seqID].length;
        }
    }

    public static int rand() {
        int n = random.nextInt();
        if (n < 0) {
            n = -n;
        }
        return n;
    }

    public boolean isProgramDone() {
        return this.isProgramDone;
    }

    public short get_curr_frame_w() {
        return this.get_frame_parameter(this.seqID, this.frameID, 2);
    }

    public short get_curr_frame_h() {
        return this.get_frame_parameter(this.seqID, this.frameID, 3);
    }

    public short get_curr_frame_x() {
        return this.info.frameXY[this.seqID][this.frameID << 1];
    }

    public short get_curr_frame_y() {
        return this.info.frameXY[this.seqID][(this.frameID << 1) + 1];
    }

    public short get_max_frame_w() {
        return this.get_max_frame_parameter(2);
    }

    public short get_max_frame_h() {
        return this.get_max_frame_parameter(3);
    }

    public short get_max_curr_seq_frame_w() {
        return this.get_max_seq_frame_parameter(this.seqID, 2);
    }

    public short get_max_curr_seq_frame_h() {
        return this.get_max_seq_frame_parameter(this.seqID, 3);
    }

    private short get_frame_parameter(int n, int n2, int n3) {
        short s = this.info.frameResID[n][n2];
        if (s == 0) {
            return 0;
        }
        short s2 = this.info.frameCutID[n][n2];
        ResInfo resInfo = this.slic.getResInfo(s);
        short s3 = resInfo.cuts[s2 * 4 + n3];
        this.slic.releaseResInfo(s);
        return s3;
    }

    private short get_max_seq_frame_parameter(int n, int n2) {
        short s = 0;
        for (int i = 0; i < this.info.frameResID[n].length; ++i) {
            short s2 = this.get_frame_parameter(n, i, n2);
            if (s >= s2) continue;
            s = s2;
        }
        return s;
    }

    private short get_max_frame_parameter(int n) {
        short s = 0;
        for (int i = 0; i < this.getSeqCount(); ++i) {
            short s2 = this.get_max_seq_frame_parameter(i, n);
            if (s >= s2) continue;
            s = s2;
        }
        return s;
    }
}

